#include <iostream>

using namespace std;
 
void bubbleSort(int arr[], int size);
void swap(int *a, int *b);
void printArray(string label, int arr[], int size);

int main() {
   const int size = 3;
   int arr[size] = {7, 1, 6};
   bubbleSort(arr, size);
   return 0;
}

void bubbleSort(int arr[], int size) {
   printArray("Original array", arr, size);

   while (true) {
      int swaps = 0;
      for (int n=0; n < size; n++) {
         if (arr[n] > arr[n+1]) {
            swap(&arr[n], &arr[n+1]);
            swaps++;
         }
      }
      if (swaps == 0) break;
   }

   printArray("Sorted array", arr, size);
}

void swap(int *a, int *b) {
   int temp = *a;
   *a = *b;
   *b = temp;
}

void printArray(string label, int arr[], int size) {
   cout << label << ":" << endl << "   ";
   string sep = "";
   for (int b=0; b<size; b++) {
      cout << sep << arr[b];
      sep = ", ";
   }
   cout << endl;
}
