#include <stdio.h>
#include <stdlib.h>

static int CallFunctionRec(int (*fun)(int depth), int depth) {
  if (!fun(depth)) {
    return 0;
  }
  if (depth < 10) {
    CallFunctionRec(fun, depth + 1);
  }
  return 1;
}

static int CallFunction(int (*fun)(int depth)) {
  return CallFunctionRec(fun, 1) && !fun(0);
}

static int callback(int depth) {
  printf("Got depth: %d\n", depth);
  return depth != 0;
}

int main() {
  return CallFunction(callback) ? EXIT_SUCCESS : EXIT_FAILURE;
}
