#include <cstring>
#include <cassert>
class Vector
{
public:
  Vector() {}
  Vector( int x, int y )
  {
    m_elements[ 0 ] = x;
    m_elements[ 1 ] = y;
  }
  inline Vector& operator=( const Vector& rhs )
  {
    ::memcpy( m_elements, rhs.m_elements, sizeof( m_elements ) );
    return *this;
  }
  int m_elements[ 2 ];
};
const int NbOfVectors = 5;
class Vectors
{
public:
  Vectors();
  Vector m_vectors[ NbOfVectors ];
};
Vectors::Vectors()
{
  for( int i = 0; i < NbOfVectors - 1; ++i )
    {
      m_vectors[i] = Vector( i, -i );
    }
  m_vectors[ NbOfVectors - 1 ] = Vector( NbOfVectors - 1, -( NbOfVectors - 1 ) );
}
int main( int argc, const char** argv )
{
  Vectors vectors;
  // Check all the vectors.
  for( int i = 0; i < NbOfVectors; ++i )
    {
      const Vector vector = vectors.m_vectors[ i ];
      // Construct what it should be.
      Vector expect( i, -i );
      assert( vector.m_elements[ 0 ] == expect.m_elements[ 0 ] );
      assert( vector.m_elements[ 1 ] == expect.m_elements[ 1 ] );
    }
  return 0;
}
