program main

   use iso_c_binding
   implicit none

   character(*), parameter :: fmt = "(A,40(1x,I2))"

   integer, parameter :: n1 = 2
   integer, parameter :: n2 = 3
   integer, parameter :: n3 = 2

   integer, dimension(2), parameter :: shape2 = (/ n1, n2 /)
   integer, dimension(3), parameter :: shape3 = (/ n1, n2, n3 /)

   integer, dimension(n1, n2), parameter :: &
     c0001 = reshape ( (/  1, 2,  3, 4,  5, 6 /), shape2)
   integer, dimension(n1, n2), parameter :: &
     c0002 = reshape ( (/ -1,-2, -3,-4, -5,-6 /), shape2)
   integer, dimension(n1, n2, n3), parameter :: &
     table_in = reshape ( (/ c0001, c0002 /), shape3)

   integer, dimension(:,:,:), allocatable, target :: table_out

   print fmt, "In: ", table_in

   ! Allocate table_out with shape=shape3
   allocate (table_out (n1, n2, n3))

   ! Set table_out via a C pointer
   call set_table (c_loc (table_out))

   print fmt, "Out:", table_out

contains

   subroutine set_table (cptr)

     type(c_ptr), intent(in) :: cptr
     integer, dimension(:,:,:), pointer :: table_tmp

     ! This should make table_tmp an alias to table_out
     call c_f_pointer (cptr, table_tmp, shape3)

     ! Now set the value of table_tmp
     table_tmp = table_in

     print fmt, "Tmp:", table_tmp

   end subroutine set_table

end program main
