#include <cuchar>

namespace std { }
namespace __std_alias = std;
namespace stlp_std { }
namespace stlport = stlp_std;
namespace _STL = stlp_std;
       
typedef long int ptrdiff_t;
typedef long unsigned int size_t;
namespace std __attribute__ ((__visibility__ ("default"))) {
  using ::ptrdiff_t;
  using ::size_t;
}
namespace stlp_std {
using std::ptrdiff_t;
using std::size_t;
}
       
       
extern "C" {
union wait
  {
    int w_status;
    struct
      {
 unsigned int __w_termsig:7;
 unsigned int __w_coredump:1;
 unsigned int __w_retcode:8;
 unsigned int:16;
      } __wait_terminated;
    struct
      {
 unsigned int __w_stopval:8;
 unsigned int __w_stopsig:8;
 unsigned int:16;
      } __wait_stopped;
  };
typedef struct
  {
    int quot;
    int rem;
  } div_t;
typedef struct
  {
    long int quot;
    long int rem;
  } ldiv_t;
__extension__ typedef struct
  {
    long long int quot;
    long long int rem;
  } lldiv_t;
extern size_t __ctype_get_mb_cur_max (void) throw () ;
extern double atof (__const char *__nptr)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1))) ;
extern int atoi (__const char *__nptr)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1))) ;
extern long int atol (__const char *__nptr)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1))) ;
__extension__ extern long long int atoll (__const char *__nptr)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1))) ;
extern double strtod (__const char *__restrict __nptr,
        char **__restrict __endptr)
     throw () __attribute__ ((__nonnull__ (1))) ;
extern float strtof (__const char *__restrict __nptr,
       char **__restrict __endptr) throw () __attribute__ ((__nonnull__ (1))) ;
extern long double strtold (__const char *__restrict __nptr,
       char **__restrict __endptr)
     throw () __attribute__ ((__nonnull__ (1))) ;
extern long int strtol (__const char *__restrict __nptr,
   char **__restrict __endptr, int __base)
     throw () __attribute__ ((__nonnull__ (1))) ;
extern unsigned long int strtoul (__const char *__restrict __nptr,
      char **__restrict __endptr, int __base)
     throw () __attribute__ ((__nonnull__ (1))) ;
__extension__
extern long long int strtoq (__const char *__restrict __nptr,
        char **__restrict __endptr, int __base)
     throw () __attribute__ ((__nonnull__ (1))) ;
__extension__
extern unsigned long long int strtouq (__const char *__restrict __nptr,
           char **__restrict __endptr, int __base)
     throw () __attribute__ ((__nonnull__ (1))) ;
__extension__
extern long long int strtoll (__const char *__restrict __nptr,
         char **__restrict __endptr, int __base)
     throw () __attribute__ ((__nonnull__ (1))) ;
__extension__
extern unsigned long long int strtoull (__const char *__restrict __nptr,
     char **__restrict __endptr, int __base)
     throw () __attribute__ ((__nonnull__ (1))) ;
typedef struct __locale_struct
{
  struct locale_data *__locales[13];
  const unsigned short int *__ctype_b;
  const int *__ctype_tolower;
  const int *__ctype_toupper;
  const char *__names[13];
} *__locale_t;
extern long int strtol_l (__const char *__restrict __nptr,
     char **__restrict __endptr, int __base,
     __locale_t __loc) throw () __attribute__ ((__nonnull__ (1, 4))) ;
extern unsigned long int strtoul_l (__const char *__restrict __nptr,
        char **__restrict __endptr,
        int __base, __locale_t __loc)
     throw () __attribute__ ((__nonnull__ (1, 4))) ;
__extension__
extern long long int strtoll_l (__const char *__restrict __nptr,
    char **__restrict __endptr, int __base,
    __locale_t __loc)
     throw () __attribute__ ((__nonnull__ (1, 4))) ;
__extension__
extern unsigned long long int strtoull_l (__const char *__restrict __nptr,
       char **__restrict __endptr,
       int __base, __locale_t __loc)
     throw () __attribute__ ((__nonnull__ (1, 4))) ;
extern double strtod_l (__const char *__restrict __nptr,
   char **__restrict __endptr, __locale_t __loc)
     throw () __attribute__ ((__nonnull__ (1, 3))) ;
extern float strtof_l (__const char *__restrict __nptr,
         char **__restrict __endptr, __locale_t __loc)
     throw () __attribute__ ((__nonnull__ (1, 3))) ;
extern long double strtold_l (__const char *__restrict __nptr,
         char **__restrict __endptr,
         __locale_t __loc)
     throw () __attribute__ ((__nonnull__ (1, 3))) ;
extern __inline __attribute__ ((__gnu_inline__)) double
atof (__const char *__nptr) throw ()
{
  return strtod (__nptr, (char **) __null);
}
extern __inline __attribute__ ((__gnu_inline__)) int
atoi (__const char *__nptr) throw ()
{
  return (int) strtol (__nptr, (char **) __null, 10);
}
extern __inline __attribute__ ((__gnu_inline__)) long int
atol (__const char *__nptr) throw ()
{
  return strtol (__nptr, (char **) __null, 10);
}
__extension__ extern __inline __attribute__ ((__gnu_inline__)) long long int
atoll (__const char *__nptr) throw ()
{
  return strtoll (__nptr, (char **) __null, 10);
}
extern char *l64a (long int __n) throw () ;
extern long int a64l (__const char *__s)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1))) ;
extern "C" {
typedef unsigned char __u_char;
typedef unsigned short int __u_short;
typedef unsigned int __u_int;
typedef unsigned long int __u_long;
typedef signed char __int8_t;
typedef unsigned char __uint8_t;
typedef signed short int __int16_t;
typedef unsigned short int __uint16_t;
typedef signed int __int32_t;
typedef unsigned int __uint32_t;
typedef signed long int __int64_t;
typedef unsigned long int __uint64_t;
typedef long int __quad_t;
typedef unsigned long int __u_quad_t;
typedef unsigned long int __dev_t;
typedef unsigned int __uid_t;
typedef unsigned int __gid_t;
typedef unsigned long int __ino_t;
typedef unsigned long int __ino64_t;
typedef unsigned int __mode_t;
typedef unsigned long int __nlink_t;
typedef long int __off_t;
typedef long int __off64_t;
typedef int __pid_t;
typedef struct { int __val[2]; } __fsid_t;
typedef long int __clock_t;
typedef unsigned long int __rlim_t;
typedef unsigned long int __rlim64_t;
typedef unsigned int __id_t;
typedef long int __time_t;
typedef unsigned int __useconds_t;
typedef long int __suseconds_t;
typedef int __daddr_t;
typedef long int __swblk_t;
typedef int __key_t;
typedef int __clockid_t;
typedef void * __timer_t;
typedef long int __blksize_t;
typedef long int __blkcnt_t;
typedef long int __blkcnt64_t;
typedef unsigned long int __fsblkcnt_t;
typedef unsigned long int __fsblkcnt64_t;
typedef unsigned long int __fsfilcnt_t;
typedef unsigned long int __fsfilcnt64_t;
typedef long int __ssize_t;
typedef __off64_t __loff_t;
typedef __quad_t *__qaddr_t;
typedef char *__caddr_t;
typedef long int __intptr_t;
typedef unsigned int __socklen_t;
typedef __u_char u_char;
typedef __u_short u_short;
typedef __u_int u_int;
typedef __u_long u_long;
typedef __quad_t quad_t;
typedef __u_quad_t u_quad_t;
typedef __fsid_t fsid_t;
typedef __loff_t loff_t;
typedef __ino_t ino_t;
typedef __ino64_t ino64_t;
typedef __dev_t dev_t;
typedef __gid_t gid_t;
typedef __mode_t mode_t;
typedef __nlink_t nlink_t;
typedef __uid_t uid_t;
typedef __off_t off_t;
typedef __off64_t off64_t;
typedef __pid_t pid_t;
typedef __id_t id_t;
typedef __ssize_t ssize_t;
typedef __daddr_t daddr_t;
typedef __caddr_t caddr_t;
typedef __key_t key_t;
typedef __clock_t clock_t;
typedef __time_t time_t;
typedef __clockid_t clockid_t;
typedef __timer_t timer_t;
typedef __useconds_t useconds_t;
typedef __suseconds_t suseconds_t;
typedef unsigned long int ulong;
typedef unsigned short int ushort;
typedef unsigned int uint;
typedef int int8_t __attribute__ ((__mode__ (__QI__)));
typedef int int16_t __attribute__ ((__mode__ (__HI__)));
typedef int int32_t __attribute__ ((__mode__ (__SI__)));
typedef int int64_t __attribute__ ((__mode__ (__DI__)));
typedef unsigned int u_int8_t __attribute__ ((__mode__ (__QI__)));
typedef unsigned int u_int16_t __attribute__ ((__mode__ (__HI__)));
typedef unsigned int u_int32_t __attribute__ ((__mode__ (__SI__)));
typedef unsigned int u_int64_t __attribute__ ((__mode__ (__DI__)));
typedef int register_t __attribute__ ((__mode__ (__word__)));
typedef int __sig_atomic_t;
typedef struct
  {
    unsigned long int __val[(1024 / (8 * sizeof (unsigned long int)))];
  } __sigset_t;
typedef __sigset_t sigset_t;
struct timespec
  {
    __time_t tv_sec;
    long int tv_nsec;
  };
struct timeval
  {
    __time_t tv_sec;
    __suseconds_t tv_usec;
  };
typedef long int __fd_mask;
typedef struct
  {
    __fd_mask fds_bits[1024 / (8 * sizeof (__fd_mask))];
  } fd_set;
typedef __fd_mask fd_mask;
extern "C" {
extern int select (int __nfds, fd_set *__restrict __readfds,
     fd_set *__restrict __writefds,
     fd_set *__restrict __exceptfds,
     struct timeval *__restrict __timeout);
extern int pselect (int __nfds, fd_set *__restrict __readfds,
      fd_set *__restrict __writefds,
      fd_set *__restrict __exceptfds,
      const struct timespec *__restrict __timeout,
      const __sigset_t *__restrict __sigmask);
}
__extension__
extern unsigned int gnu_dev_major (unsigned long long int __dev)
     throw ();
__extension__
extern unsigned int gnu_dev_minor (unsigned long long int __dev)
     throw ();
__extension__
extern unsigned long long int gnu_dev_makedev (unsigned int __major,
            unsigned int __minor)
     throw ();
__extension__ extern __inline __attribute__ ((__gnu_inline__)) unsigned int
gnu_dev_major (unsigned long long int __dev) throw ()
{
  return ((__dev >> 8) & 0xfff) | ((unsigned int) (__dev >> 32) & ~0xfff);
}
__extension__ extern __inline __attribute__ ((__gnu_inline__)) unsigned int
gnu_dev_minor (unsigned long long int __dev) throw ()
{
  return (__dev & 0xff) | ((unsigned int) (__dev >> 12) & ~0xff);
}
__extension__ extern __inline __attribute__ ((__gnu_inline__)) unsigned long long int
gnu_dev_makedev (unsigned int __major, unsigned int __minor) throw ()
{
  return ((__minor & 0xff) | ((__major & 0xfff) << 8)
   | (((unsigned long long int) (__minor & ~0xff)) << 12)
   | (((unsigned long long int) (__major & ~0xfff)) << 32));
}
typedef __blksize_t blksize_t;
typedef __blkcnt_t blkcnt_t;
typedef __fsblkcnt_t fsblkcnt_t;
typedef __fsfilcnt_t fsfilcnt_t;
typedef __blkcnt64_t blkcnt64_t;
typedef __fsblkcnt64_t fsblkcnt64_t;
typedef __fsfilcnt64_t fsfilcnt64_t;
typedef unsigned long int pthread_t;
typedef union
{
  char __size[56];
  long int __align;
} pthread_attr_t;
typedef struct __pthread_internal_list
{
  struct __pthread_internal_list *__prev;
  struct __pthread_internal_list *__next;
} __pthread_list_t;
typedef union
{
  struct __pthread_mutex_s
  {
    int __lock;
    unsigned int __count;
    int __owner;
    unsigned int __nusers;
    int __kind;
    int __spins;
    __pthread_list_t __list;
  } __data;
  char __size[40];
  long int __align;
} pthread_mutex_t;
typedef union
{
  char __size[4];
  int __align;
} pthread_mutexattr_t;
typedef union
{
  struct
  {
    int __lock;
    unsigned int __futex;
    __extension__ unsigned long long int __total_seq;
    __extension__ unsigned long long int __wakeup_seq;
    __extension__ unsigned long long int __woken_seq;
    void *__mutex;
    unsigned int __nwaiters;
    unsigned int __broadcast_seq;
  } __data;
  char __size[48];
  __extension__ long long int __align;
} pthread_cond_t;
typedef union
{
  char __size[4];
  int __align;
} pthread_condattr_t;
typedef unsigned int pthread_key_t;
typedef int pthread_once_t;
typedef union
{
  struct
  {
    int __lock;
    unsigned int __nr_readers;
    unsigned int __readers_wakeup;
    unsigned int __writer_wakeup;
    unsigned int __nr_readers_queued;
    unsigned int __nr_writers_queued;
    int __writer;
    int __shared;
    unsigned long int __pad1;
    unsigned long int __pad2;
    unsigned int __flags;
  } __data;
  char __size[56];
  long int __align;
} pthread_rwlock_t;
typedef union
{
  char __size[8];
  long int __align;
} pthread_rwlockattr_t;
typedef volatile int pthread_spinlock_t;
typedef union
{
  char __size[32];
  long int __align;
} pthread_barrier_t;
typedef union
{
  char __size[4];
  int __align;
} pthread_barrierattr_t;
}
extern long int random (void) throw ();
extern void srandom (unsigned int __seed) throw ();
extern char *initstate (unsigned int __seed, char *__statebuf,
   size_t __statelen) throw () __attribute__ ((__nonnull__ (2)));
extern char *setstate (char *__statebuf) throw () __attribute__ ((__nonnull__ (1)));
struct random_data
  {
    int32_t *fptr;
    int32_t *rptr;
    int32_t *state;
    int rand_type;
    int rand_deg;
    int rand_sep;
    int32_t *end_ptr;
  };
extern int random_r (struct random_data *__restrict __buf,
       int32_t *__restrict __result) throw () __attribute__ ((__nonnull__ (1, 2)));
extern int srandom_r (unsigned int __seed, struct random_data *__buf)
     throw () __attribute__ ((__nonnull__ (2)));
extern int initstate_r (unsigned int __seed, char *__restrict __statebuf,
   size_t __statelen,
   struct random_data *__restrict __buf)
     throw () __attribute__ ((__nonnull__ (2, 4)));
extern int setstate_r (char *__restrict __statebuf,
         struct random_data *__restrict __buf)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern int rand (void) throw ();
extern void srand (unsigned int __seed) throw ();
extern int rand_r (unsigned int *__seed) throw ();
extern double drand48 (void) throw ();
extern double erand48 (unsigned short int __xsubi[3]) throw () __attribute__ ((__nonnull__ (1)));
extern long int lrand48 (void) throw ();
extern long int nrand48 (unsigned short int __xsubi[3])
     throw () __attribute__ ((__nonnull__ (1)));
extern long int mrand48 (void) throw ();
extern long int jrand48 (unsigned short int __xsubi[3])
     throw () __attribute__ ((__nonnull__ (1)));
extern void srand48 (long int __seedval) throw ();
extern unsigned short int *seed48 (unsigned short int __seed16v[3])
     throw () __attribute__ ((__nonnull__ (1)));
extern void lcong48 (unsigned short int __param[7]) throw () __attribute__ ((__nonnull__ (1)));
struct drand48_data
  {
    unsigned short int __x[3];
    unsigned short int __old_x[3];
    unsigned short int __c;
    unsigned short int __init;
    unsigned long long int __a;
  };
extern int drand48_r (struct drand48_data *__restrict __buffer,
        double *__restrict __result) throw () __attribute__ ((__nonnull__ (1, 2)));
extern int erand48_r (unsigned short int __xsubi[3],
        struct drand48_data *__restrict __buffer,
        double *__restrict __result) throw () __attribute__ ((__nonnull__ (1, 2)));
extern int lrand48_r (struct drand48_data *__restrict __buffer,
        long int *__restrict __result)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern int nrand48_r (unsigned short int __xsubi[3],
        struct drand48_data *__restrict __buffer,
        long int *__restrict __result)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern int mrand48_r (struct drand48_data *__restrict __buffer,
        long int *__restrict __result)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern int jrand48_r (unsigned short int __xsubi[3],
        struct drand48_data *__restrict __buffer,
        long int *__restrict __result)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern int srand48_r (long int __seedval, struct drand48_data *__buffer)
     throw () __attribute__ ((__nonnull__ (2)));
extern int seed48_r (unsigned short int __seed16v[3],
       struct drand48_data *__buffer) throw () __attribute__ ((__nonnull__ (1, 2)));
extern int lcong48_r (unsigned short int __param[7],
        struct drand48_data *__buffer)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern void *malloc (size_t __size) throw () __attribute__ ((__malloc__)) ;
extern void *calloc (size_t __nmemb, size_t __size)
     throw () __attribute__ ((__malloc__)) ;
extern void *realloc (void *__ptr, size_t __size)
     throw () __attribute__ ((__warn_unused_result__));
extern void free (void *__ptr) throw ();
extern void cfree (void *__ptr) throw ();
extern "C" {
extern void *alloca (size_t __size) throw ();
}
extern void *valloc (size_t __size) throw () __attribute__ ((__malloc__)) ;
extern int posix_memalign (void **__memptr, size_t __alignment, size_t __size)
     throw () __attribute__ ((__nonnull__ (1))) ;
extern void abort (void) throw () __attribute__ ((__noreturn__));
extern int atexit (void (*__func) (void)) throw () __attribute__ ((__nonnull__ (1)));
extern int on_exit (void (*__func) (int __status, void *__arg), void *__arg)
     throw () __attribute__ ((__nonnull__ (1)));
extern void exit (int __status) throw () __attribute__ ((__noreturn__));
extern void _Exit (int __status) throw () __attribute__ ((__noreturn__));
extern char *getenv (__const char *__name) throw () __attribute__ ((__nonnull__ (1))) ;
extern char *__secure_getenv (__const char *__name)
     throw () __attribute__ ((__nonnull__ (1))) ;
extern int putenv (char *__string) throw () __attribute__ ((__nonnull__ (1)));
extern int setenv (__const char *__name, __const char *__value, int __replace)
     throw () __attribute__ ((__nonnull__ (2)));
extern int unsetenv (__const char *__name) throw ();
extern int clearenv (void) throw ();
extern char *mktemp (char *__template) throw () __attribute__ ((__nonnull__ (1))) ;
extern int mkstemp (char *__template) __attribute__ ((__nonnull__ (1))) ;
extern int mkstemp64 (char *__template) __attribute__ ((__nonnull__ (1))) ;
extern char *mkdtemp (char *__template) throw () __attribute__ ((__nonnull__ (1))) ;
extern int mkostemp (char *__template, int __flags) __attribute__ ((__nonnull__ (1))) ;
extern int mkostemp64 (char *__template, int __flags) __attribute__ ((__nonnull__ (1))) ;
extern int system (__const char *__command) ;
extern char *canonicalize_file_name (__const char *__name)
     throw () __attribute__ ((__nonnull__ (1))) ;
extern char *realpath (__const char *__restrict __name,
         char *__restrict __resolved) throw () ;
typedef int (*__compar_fn_t) (__const void *, __const void *);
typedef __compar_fn_t comparison_fn_t;
typedef int (*__compar_d_fn_t) (__const void *, __const void *, void *);
extern void *bsearch (__const void *__key, __const void *__base,
        size_t __nmemb, size_t __size, __compar_fn_t __compar)
     __attribute__ ((__nonnull__ (1, 2, 5))) ;
extern void qsort (void *__base, size_t __nmemb, size_t __size,
     __compar_fn_t __compar) __attribute__ ((__nonnull__ (1, 4)));
extern void qsort_r (void *__base, size_t __nmemb, size_t __size,
       __compar_d_fn_t __compar, void *__arg)
  __attribute__ ((__nonnull__ (1, 4)));
extern int abs (int __x) throw () __attribute__ ((__const__)) ;
extern long int labs (long int __x) throw () __attribute__ ((__const__)) ;
__extension__ extern long long int llabs (long long int __x)
     throw () __attribute__ ((__const__)) ;
extern div_t div (int __numer, int __denom)
     throw () __attribute__ ((__const__)) ;
extern ldiv_t ldiv (long int __numer, long int __denom)
     throw () __attribute__ ((__const__)) ;
__extension__ extern lldiv_t lldiv (long long int __numer,
        long long int __denom)
     throw () __attribute__ ((__const__)) ;
extern char *ecvt (double __value, int __ndigit, int *__restrict __decpt,
     int *__restrict __sign) throw () __attribute__ ((__nonnull__ (3, 4))) ;
extern char *fcvt (double __value, int __ndigit, int *__restrict __decpt,
     int *__restrict __sign) throw () __attribute__ ((__nonnull__ (3, 4))) ;
extern char *gcvt (double __value, int __ndigit, char *__buf)
     throw () __attribute__ ((__nonnull__ (3))) ;
extern char *qecvt (long double __value, int __ndigit,
      int *__restrict __decpt, int *__restrict __sign)
     throw () __attribute__ ((__nonnull__ (3, 4))) ;
extern char *qfcvt (long double __value, int __ndigit,
      int *__restrict __decpt, int *__restrict __sign)
     throw () __attribute__ ((__nonnull__ (3, 4))) ;
extern char *qgcvt (long double __value, int __ndigit, char *__buf)
     throw () __attribute__ ((__nonnull__ (3))) ;
extern int ecvt_r (double __value, int __ndigit, int *__restrict __decpt,
     int *__restrict __sign, char *__restrict __buf,
     size_t __len) throw () __attribute__ ((__nonnull__ (3, 4, 5)));
extern int fcvt_r (double __value, int __ndigit, int *__restrict __decpt,
     int *__restrict __sign, char *__restrict __buf,
     size_t __len) throw () __attribute__ ((__nonnull__ (3, 4, 5)));
extern int qecvt_r (long double __value, int __ndigit,
      int *__restrict __decpt, int *__restrict __sign,
      char *__restrict __buf, size_t __len)
     throw () __attribute__ ((__nonnull__ (3, 4, 5)));
extern int qfcvt_r (long double __value, int __ndigit,
      int *__restrict __decpt, int *__restrict __sign,
      char *__restrict __buf, size_t __len)
     throw () __attribute__ ((__nonnull__ (3, 4, 5)));
extern int mblen (__const char *__s, size_t __n) throw () ;
extern int mbtowc (wchar_t *__restrict __pwc,
     __const char *__restrict __s, size_t __n) throw () ;
extern int wctomb (char *__s, wchar_t __wchar) throw () ;
extern size_t mbstowcs (wchar_t *__restrict __pwcs,
   __const char *__restrict __s, size_t __n) throw ();
extern size_t wcstombs (char *__restrict __s,
   __const wchar_t *__restrict __pwcs, size_t __n)
     throw ();
extern int rpmatch (__const char *__response) throw () __attribute__ ((__nonnull__ (1))) ;
extern int getsubopt (char **__restrict __optionp,
        char *__const *__restrict __tokens,
        char **__restrict __valuep)
     throw () __attribute__ ((__nonnull__ (1, 2, 3))) ;
extern void setkey (__const char *__key) throw () __attribute__ ((__nonnull__ (1)));
extern int posix_openpt (int __oflag) ;
extern int grantpt (int __fd) throw ();
extern int unlockpt (int __fd) throw ();
extern char *ptsname (int __fd) throw () ;
extern int ptsname_r (int __fd, char *__buf, size_t __buflen)
     throw () __attribute__ ((__nonnull__ (2)));
extern int getpt (void);
extern int getloadavg (double __loadavg[], int __nelem)
     throw () __attribute__ ((__nonnull__ (1)));
}
namespace std __attribute__ ((__visibility__ ("default"))) {
  using ::div_t;
  using ::ldiv_t;
  using ::abort;
  using ::abs;
  using ::atexit;
  using ::atof;
  using ::atoi;
  using ::atol;
  using ::bsearch;
  using ::calloc;
  using ::div;
  using ::exit;
  using ::free;
  using ::getenv;
  using ::labs;
  using ::ldiv;
  using ::malloc;
  using ::mblen;
  using ::mbstowcs;
  using ::mbtowc;
  using ::qsort;
  using ::rand;
  using ::realloc;
  using ::srand;
  using ::strtod;
  using ::strtol;
  using ::strtoul;
  using ::system;
  using ::wcstombs;
  using ::wctomb;
  inline long
  abs(long __i) { return labs(__i); }
  inline ldiv_t
  div(long __i, long __j) { return ldiv(__i, __j); }
}
namespace __gnu_cxx __attribute__ ((__visibility__ ("default"))) {
  using ::lldiv_t;
  using ::_Exit;
  inline long long
  abs(long long __x) { return __x >= 0 ? __x : -__x; }
  using ::llabs;
  inline lldiv_t
  div(long long __n, long long __d)
  { lldiv_t __q; __q.quot = __n / __d; __q.rem = __n % __d; return __q; }
  using ::lldiv;
  using ::atoll;
  using ::strtoll;
  using ::strtoull;
  using ::strtof;
  using ::strtold;
}
namespace std __attribute__ ((__visibility__ ("default"))) {
  using ::__gnu_cxx::lldiv_t;
  using ::__gnu_cxx::_Exit;
  using ::__gnu_cxx::abs;
  using ::__gnu_cxx::llabs;
  using ::__gnu_cxx::div;
  using ::__gnu_cxx::lldiv;
  using ::__gnu_cxx::atoll;
  using ::__gnu_cxx::strtof;
  using ::__gnu_cxx::strtoll;
  using ::__gnu_cxx::strtoull;
  using ::__gnu_cxx::strtold;
}
namespace std
{
  using std::lldiv_t;
  using std::llabs;
  using std::lldiv;
  using std::atoll;
  using std::strtoll;
  using std::strtoull;
  using std::strtof;
  using std::strtold;
  using std::abs;
  using std::div;
}
namespace stlp_std {
using std::div_t;
using std::ldiv_t;
using std::size_t;
using std::abort;
using std::getenv;
using std::mblen;
using std::mbtowc;
using std::system;
using std::bsearch;
using std::atexit;
using std::exit;
using std::calloc;
using std::free;
using std::malloc;
using std::realloc;
using std::atof;
using std::atoi;
using std::atol;
using std::mbstowcs;
using std::strtod;
using std::strtol;
using std::strtoul;
using std::wcstombs;
using std::wctomb;
using std::qsort;
using std::labs;
using std::ldiv;
using std::llabs;
using std::lldiv_t;
using std::lldiv;
using std::rand;
using std::srand;
}
inline long abs(long __x) { return std::labs(__x); }
inline std::ldiv_t div(long __x, long __y) { return std::ldiv(__x, __y); }
inline long long abs(long long __x) { return std::llabs(__x); }
inline lldiv_t div(long long __x, long long __y) { return std::lldiv(__x, __y); }
       
       
       
       
namespace __gnu_cxx __attribute__ ((__visibility__ ("default"))) {
  template<typename _Iterator, typename _Container>
    class __normal_iterator;
}
namespace std __attribute__ ((__visibility__ ("default"))) {
  struct __true_type { };
  struct __false_type { };
  template<bool>
    struct __truth_type
    { typedef __false_type __type; };
  template<>
    struct __truth_type<true>
    { typedef __true_type __type; };
  template<class _Sp, class _Tp>
    struct __traitor
    {
      enum { __value = bool(_Sp::__value) || bool(_Tp::__value) };
      typedef typename __truth_type<__value>::__type __type;
    };
  template<typename, typename>
    struct __are_same
    {
      enum { __value = 0 };
      typedef __false_type __type;
    };
  template<typename _Tp>
    struct __are_same<_Tp, _Tp>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<typename _Tp>
    struct __is_void
    {
      enum { __value = 0 };
      typedef __false_type __type;
    };
  template<>
    struct __is_void<void>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<typename _Tp>
    struct __is_integer
    {
      enum { __value = 0 };
      typedef __false_type __type;
    };
  template<>
    struct __is_integer<bool>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<>
    struct __is_integer<char>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<>
    struct __is_integer<signed char>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<>
    struct __is_integer<unsigned char>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<>
    struct __is_integer<wchar_t>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<>
    struct __is_integer<char16_t>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<>
    struct __is_integer<char32_t>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<>
    struct __is_integer<short>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<>
    struct __is_integer<unsigned short>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<>
    struct __is_integer<int>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<>
    struct __is_integer<unsigned int>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<>
    struct __is_integer<long>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<>
    struct __is_integer<unsigned long>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<>
    struct __is_integer<long long>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<>
    struct __is_integer<unsigned long long>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<typename _Tp>
    struct __is_floating
    {
      enum { __value = 0 };
      typedef __false_type __type;
    };
  template<>
    struct __is_floating<float>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<>
    struct __is_floating<double>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<>
    struct __is_floating<long double>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<typename _Tp>
    struct __is_pointer
    {
      enum { __value = 0 };
      typedef __false_type __type;
    };
  template<typename _Tp>
    struct __is_pointer<_Tp*>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<typename _Tp>
    struct __is_normal_iterator
    {
      enum { __value = 0 };
      typedef __false_type __type;
    };
  template<typename _Iterator, typename _Container>
    struct __is_normal_iterator< __gnu_cxx::__normal_iterator<_Iterator,
             _Container> >
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<typename _Tp>
    struct __is_arithmetic
    : public __traitor<__is_integer<_Tp>, __is_floating<_Tp> >
    { };
  template<typename _Tp>
    struct __is_fundamental
    : public __traitor<__is_void<_Tp>, __is_arithmetic<_Tp> >
    { };
  template<typename _Tp>
    struct __is_scalar
    : public __traitor<__is_arithmetic<_Tp>, __is_pointer<_Tp> >
    { };
  template<typename _Tp>
    struct __is_char
    {
      enum { __value = 0 };
      typedef __false_type __type;
    };
  template<>
    struct __is_char<char>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<>
    struct __is_char<wchar_t>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<typename _Tp>
    struct __is_byte
    {
      enum { __value = 0 };
      typedef __false_type __type;
    };
  template<>
    struct __is_byte<char>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<>
    struct __is_byte<signed char>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<>
    struct __is_byte<unsigned char>
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
  template<typename _Tp>
    struct __is_move_iterator
    {
      enum { __value = 0 };
      typedef __false_type __type;
    };
  template<typename _Iterator>
    class move_iterator;
  template<typename _Iterator>
    struct __is_move_iterator< move_iterator<_Iterator> >
    {
      enum { __value = 1 };
      typedef __true_type __type;
    };
}
       
namespace __gnu_cxx __attribute__ ((__visibility__ ("default"))) {
  template<bool, typename>
    struct __enable_if
    { };
  template<typename _Tp>
    struct __enable_if<true, _Tp>
    { typedef _Tp __type; };
  template<bool _Cond, typename _Iftrue, typename _Iffalse>
    struct __conditional_type
    { typedef _Iftrue __type; };
  template<typename _Iftrue, typename _Iffalse>
    struct __conditional_type<false, _Iftrue, _Iffalse>
    { typedef _Iffalse __type; };
  template<typename _Tp>
    struct __add_unsigned
    {
    private:
      typedef __enable_if<std::__is_integer<_Tp>::__value, _Tp> __if_type;
    public:
      typedef typename __if_type::__type __type;
    };
  template<>
    struct __add_unsigned<char>
    { typedef unsigned char __type; };
  template<>
    struct __add_unsigned<signed char>
    { typedef unsigned char __type; };
  template<>
    struct __add_unsigned<short>
    { typedef unsigned short __type; };
  template<>
    struct __add_unsigned<int>
    { typedef unsigned int __type; };
  template<>
    struct __add_unsigned<long>
    { typedef unsigned long __type; };
  template<>
    struct __add_unsigned<long long>
    { typedef unsigned long long __type; };
  template<>
    struct __add_unsigned<bool>;
  template<>
    struct __add_unsigned<wchar_t>;
  template<typename _Tp>
    struct __remove_unsigned
    {
    private:
      typedef __enable_if<std::__is_integer<_Tp>::__value, _Tp> __if_type;
    public:
      typedef typename __if_type::__type __type;
    };
  template<>
    struct __remove_unsigned<char>
    { typedef signed char __type; };
  template<>
    struct __remove_unsigned<unsigned char>
    { typedef signed char __type; };
  template<>
    struct __remove_unsigned<unsigned short>
    { typedef short __type; };
  template<>
    struct __remove_unsigned<unsigned int>
    { typedef int __type; };
  template<>
    struct __remove_unsigned<unsigned long>
    { typedef long __type; };
  template<>
    struct __remove_unsigned<unsigned long long>
    { typedef long long __type; };
  template<>
    struct __remove_unsigned<bool>;
  template<>
    struct __remove_unsigned<wchar_t>;
  template<typename _Type>
    inline bool
    __is_null_pointer(_Type* __ptr)
    { return __ptr == 0; }
  template<typename _Type>
    inline bool
    __is_null_pointer(_Type)
    { return false; }
  template<typename _Tp, bool = std::__is_integer<_Tp>::__value>
    struct __promote
    { typedef double __type; };
  template<typename _Tp>
    struct __promote<_Tp, false>
    { typedef _Tp __type; };
  template<typename _Tp, typename _Up>
    struct __promote_2
    {
    private:
      typedef typename __promote<_Tp>::__type __type1;
      typedef typename __promote<_Up>::__type __type2;
    public:
      typedef __typeof__(__type1() + __type2()) __type;
    };
  template<typename _Tp, typename _Up, typename _Vp>
    struct __promote_3
    {
    private:
      typedef typename __promote<_Tp>::__type __type1;
      typedef typename __promote<_Up>::__type __type2;
      typedef typename __promote<_Vp>::__type __type3;
    public:
      typedef __typeof__(__type1() + __type2() + __type3()) __type;
    };
  template<typename _Tp, typename _Up, typename _Vp, typename _Wp>
    struct __promote_4
    {
    private:
      typedef typename __promote<_Tp>::__type __type1;
      typedef typename __promote<_Up>::__type __type2;
      typedef typename __promote<_Vp>::__type __type3;
      typedef typename __promote<_Wp>::__type __type4;
    public:
      typedef __typeof__(__type1() + __type2() + __type3() + __type4()) __type;
    };
}
extern "C" {
typedef float float_t;
typedef double double_t;
extern double acos (double __x) throw (); extern double __acos (double __x) throw ();
extern double asin (double __x) throw (); extern double __asin (double __x) throw ();
extern double atan (double __x) throw (); extern double __atan (double __x) throw ();
extern double atan2 (double __y, double __x) throw (); extern double __atan2 (double __y, double __x) throw ();
extern double cos (double __x) throw (); extern double __cos (double __x) throw ();
extern double sin (double __x) throw (); extern double __sin (double __x) throw ();
extern double tan (double __x) throw (); extern double __tan (double __x) throw ();
extern double cosh (double __x) throw (); extern double __cosh (double __x) throw ();
extern double sinh (double __x) throw (); extern double __sinh (double __x) throw ();
extern double tanh (double __x) throw (); extern double __tanh (double __x) throw ();
extern void sincos (double __x, double *__sinx, double *__cosx) throw (); extern void __sincos (double __x, double *__sinx, double *__cosx) throw ();
extern double acosh (double __x) throw (); extern double __acosh (double __x) throw ();
extern double asinh (double __x) throw (); extern double __asinh (double __x) throw ();
extern double atanh (double __x) throw (); extern double __atanh (double __x) throw ();
extern double exp (double __x) throw (); extern double __exp (double __x) throw ();
extern double frexp (double __x, int *__exponent) throw (); extern double __frexp (double __x, int *__exponent) throw ();
extern double ldexp (double __x, int __exponent) throw (); extern double __ldexp (double __x, int __exponent) throw ();
extern double log (double __x) throw (); extern double __log (double __x) throw ();
extern double log10 (double __x) throw (); extern double __log10 (double __x) throw ();
extern double modf (double __x, double *__iptr) throw (); extern double __modf (double __x, double *__iptr) throw ();
extern double exp10 (double __x) throw (); extern double __exp10 (double __x) throw ();
extern double pow10 (double __x) throw (); extern double __pow10 (double __x) throw ();
extern double expm1 (double __x) throw (); extern double __expm1 (double __x) throw ();
extern double log1p (double __x) throw (); extern double __log1p (double __x) throw ();
extern double logb (double __x) throw (); extern double __logb (double __x) throw ();
extern double exp2 (double __x) throw (); extern double __exp2 (double __x) throw ();
extern double log2 (double __x) throw (); extern double __log2 (double __x) throw ();
extern double pow (double __x, double __y) throw (); extern double __pow (double __x, double __y) throw ();
extern double sqrt (double __x) throw (); extern double __sqrt (double __x) throw ();
extern double hypot (double __x, double __y) throw (); extern double __hypot (double __x, double __y) throw ();
extern double cbrt (double __x) throw (); extern double __cbrt (double __x) throw ();
extern double ceil (double __x) throw () __attribute__ ((__const__)); extern double __ceil (double __x) throw () __attribute__ ((__const__));
extern double fabs (double __x) throw () __attribute__ ((__const__)); extern double __fabs (double __x) throw () __attribute__ ((__const__));
extern double floor (double __x) throw () __attribute__ ((__const__)); extern double __floor (double __x) throw () __attribute__ ((__const__));
extern double fmod (double __x, double __y) throw (); extern double __fmod (double __x, double __y) throw ();
extern int __isinf (double __value) throw () __attribute__ ((__const__));
extern int __finite (double __value) throw () __attribute__ ((__const__));
extern int isinf (double __value) throw () __attribute__ ((__const__));
extern int finite (double __value) throw () __attribute__ ((__const__));
extern double drem (double __x, double __y) throw (); extern double __drem (double __x, double __y) throw ();
extern double significand (double __x) throw (); extern double __significand (double __x) throw ();
extern double copysign (double __x, double __y) throw () __attribute__ ((__const__)); extern double __copysign (double __x, double __y) throw () __attribute__ ((__const__));
extern double nan (__const char *__tagb) throw () __attribute__ ((__const__)); extern double __nan (__const char *__tagb) throw () __attribute__ ((__const__));
extern int __isnan (double __value) throw () __attribute__ ((__const__));
extern int isnan (double __value) throw () __attribute__ ((__const__));
extern double j0 (double) throw (); extern double __j0 (double) throw ();
extern double j1 (double) throw (); extern double __j1 (double) throw ();
extern double jn (int, double) throw (); extern double __jn (int, double) throw ();
extern double y0 (double) throw (); extern double __y0 (double) throw ();
extern double y1 (double) throw (); extern double __y1 (double) throw ();
extern double yn (int, double) throw (); extern double __yn (int, double) throw ();
extern double erf (double) throw (); extern double __erf (double) throw ();
extern double erfc (double) throw (); extern double __erfc (double) throw ();
extern double lgamma (double) throw (); extern double __lgamma (double) throw ();
extern double tgamma (double) throw (); extern double __tgamma (double) throw ();
extern double gamma (double) throw (); extern double __gamma (double) throw ();
extern double lgamma_r (double, int *__signgamp) throw (); extern double __lgamma_r (double, int *__signgamp) throw ();
extern double rint (double __x) throw (); extern double __rint (double __x) throw ();
extern double nextafter (double __x, double __y) throw () __attribute__ ((__const__)); extern double __nextafter (double __x, double __y) throw () __attribute__ ((__const__));
extern double nexttoward (double __x, long double __y) throw () __attribute__ ((__const__)); extern double __nexttoward (double __x, long double __y) throw () __attribute__ ((__const__));
extern double remainder (double __x, double __y) throw (); extern double __remainder (double __x, double __y) throw ();
extern double scalbn (double __x, int __n) throw (); extern double __scalbn (double __x, int __n) throw ();
extern int ilogb (double __x) throw (); extern int __ilogb (double __x) throw ();
extern double scalbln (double __x, long int __n) throw (); extern double __scalbln (double __x, long int __n) throw ();
extern double nearbyint (double __x) throw (); extern double __nearbyint (double __x) throw ();
extern double round (double __x) throw () __attribute__ ((__const__)); extern double __round (double __x) throw () __attribute__ ((__const__));
extern double trunc (double __x) throw () __attribute__ ((__const__)); extern double __trunc (double __x) throw () __attribute__ ((__const__));
extern double remquo (double __x, double __y, int *__quo) throw (); extern double __remquo (double __x, double __y, int *__quo) throw ();
extern long int lrint (double __x) throw (); extern long int __lrint (double __x) throw ();
extern long long int llrint (double __x) throw (); extern long long int __llrint (double __x) throw ();
extern long int lround (double __x) throw (); extern long int __lround (double __x) throw ();
extern long long int llround (double __x) throw (); extern long long int __llround (double __x) throw ();
extern double fdim (double __x, double __y) throw (); extern double __fdim (double __x, double __y) throw ();
extern double fmax (double __x, double __y) throw (); extern double __fmax (double __x, double __y) throw ();
extern double fmin (double __x, double __y) throw (); extern double __fmin (double __x, double __y) throw ();
extern int __fpclassify (double __value) throw ()
     __attribute__ ((__const__));
extern int __signbit (double __value) throw ()
     __attribute__ ((__const__));
extern double fma (double __x, double __y, double __z) throw (); extern double __fma (double __x, double __y, double __z) throw ();
extern double scalb (double __x, double __n) throw (); extern double __scalb (double __x, double __n) throw ();
extern float acosf (float __x) throw (); extern float __acosf (float __x) throw ();
extern float asinf (float __x) throw (); extern float __asinf (float __x) throw ();
extern float atanf (float __x) throw (); extern float __atanf (float __x) throw ();
extern float atan2f (float __y, float __x) throw (); extern float __atan2f (float __y, float __x) throw ();
extern float cosf (float __x) throw (); extern float __cosf (float __x) throw ();
extern float sinf (float __x) throw (); extern float __sinf (float __x) throw ();
extern float tanf (float __x) throw (); extern float __tanf (float __x) throw ();
extern float coshf (float __x) throw (); extern float __coshf (float __x) throw ();
extern float sinhf (float __x) throw (); extern float __sinhf (float __x) throw ();
extern float tanhf (float __x) throw (); extern float __tanhf (float __x) throw ();
extern void sincosf (float __x, float *__sinx, float *__cosx) throw (); extern void __sincosf (float __x, float *__sinx, float *__cosx) throw ();
extern float acoshf (float __x) throw (); extern float __acoshf (float __x) throw ();
extern float asinhf (float __x) throw (); extern float __asinhf (float __x) throw ();
extern float atanhf (float __x) throw (); extern float __atanhf (float __x) throw ();
extern float expf (float __x) throw (); extern float __expf (float __x) throw ();
extern float frexpf (float __x, int *__exponent) throw (); extern float __frexpf (float __x, int *__exponent) throw ();
extern float ldexpf (float __x, int __exponent) throw (); extern float __ldexpf (float __x, int __exponent) throw ();
extern float logf (float __x) throw (); extern float __logf (float __x) throw ();
extern float log10f (float __x) throw (); extern float __log10f (float __x) throw ();
extern float modff (float __x, float *__iptr) throw (); extern float __modff (float __x, float *__iptr) throw ();
extern float exp10f (float __x) throw (); extern float __exp10f (float __x) throw ();
extern float pow10f (float __x) throw (); extern float __pow10f (float __x) throw ();
extern float expm1f (float __x) throw (); extern float __expm1f (float __x) throw ();
extern float log1pf (float __x) throw (); extern float __log1pf (float __x) throw ();
extern float logbf (float __x) throw (); extern float __logbf (float __x) throw ();
extern float exp2f (float __x) throw (); extern float __exp2f (float __x) throw ();
extern float log2f (float __x) throw (); extern float __log2f (float __x) throw ();
extern float powf (float __x, float __y) throw (); extern float __powf (float __x, float __y) throw ();
extern float sqrtf (float __x) throw (); extern float __sqrtf (float __x) throw ();
extern float hypotf (float __x, float __y) throw (); extern float __hypotf (float __x, float __y) throw ();
extern float cbrtf (float __x) throw (); extern float __cbrtf (float __x) throw ();
extern float ceilf (float __x) throw () __attribute__ ((__const__)); extern float __ceilf (float __x) throw () __attribute__ ((__const__));
extern float fabsf (float __x) throw () __attribute__ ((__const__)); extern float __fabsf (float __x) throw () __attribute__ ((__const__));
extern float floorf (float __x) throw () __attribute__ ((__const__)); extern float __floorf (float __x) throw () __attribute__ ((__const__));
extern float fmodf (float __x, float __y) throw (); extern float __fmodf (float __x, float __y) throw ();
extern int __isinff (float __value) throw () __attribute__ ((__const__));
extern int __finitef (float __value) throw () __attribute__ ((__const__));
extern int isinff (float __value) throw () __attribute__ ((__const__));
extern int finitef (float __value) throw () __attribute__ ((__const__));
extern float dremf (float __x, float __y) throw (); extern float __dremf (float __x, float __y) throw ();
extern float significandf (float __x) throw (); extern float __significandf (float __x) throw ();
extern float copysignf (float __x, float __y) throw () __attribute__ ((__const__)); extern float __copysignf (float __x, float __y) throw () __attribute__ ((__const__));
extern float nanf (__const char *__tagb) throw () __attribute__ ((__const__)); extern float __nanf (__const char *__tagb) throw () __attribute__ ((__const__));
extern int __isnanf (float __value) throw () __attribute__ ((__const__));
extern int isnanf (float __value) throw () __attribute__ ((__const__));
extern float j0f (float) throw (); extern float __j0f (float) throw ();
extern float j1f (float) throw (); extern float __j1f (float) throw ();
extern float jnf (int, float) throw (); extern float __jnf (int, float) throw ();
extern float y0f (float) throw (); extern float __y0f (float) throw ();
extern float y1f (float) throw (); extern float __y1f (float) throw ();
extern float ynf (int, float) throw (); extern float __ynf (int, float) throw ();
extern float erff (float) throw (); extern float __erff (float) throw ();
extern float erfcf (float) throw (); extern float __erfcf (float) throw ();
extern float lgammaf (float) throw (); extern float __lgammaf (float) throw ();
extern float tgammaf (float) throw (); extern float __tgammaf (float) throw ();
extern float gammaf (float) throw (); extern float __gammaf (float) throw ();
extern float lgammaf_r (float, int *__signgamp) throw (); extern float __lgammaf_r (float, int *__signgamp) throw ();
extern float rintf (float __x) throw (); extern float __rintf (float __x) throw ();
extern float nextafterf (float __x, float __y) throw () __attribute__ ((__const__)); extern float __nextafterf (float __x, float __y) throw () __attribute__ ((__const__));
extern float nexttowardf (float __x, long double __y) throw () __attribute__ ((__const__)); extern float __nexttowardf (float __x, long double __y) throw () __attribute__ ((__const__));
extern float remainderf (float __x, float __y) throw (); extern float __remainderf (float __x, float __y) throw ();
extern float scalbnf (float __x, int __n) throw (); extern float __scalbnf (float __x, int __n) throw ();
extern int ilogbf (float __x) throw (); extern int __ilogbf (float __x) throw ();
extern float scalblnf (float __x, long int __n) throw (); extern float __scalblnf (float __x, long int __n) throw ();
extern float nearbyintf (float __x) throw (); extern float __nearbyintf (float __x) throw ();
extern float roundf (float __x) throw () __attribute__ ((__const__)); extern float __roundf (float __x) throw () __attribute__ ((__const__));
extern float truncf (float __x) throw () __attribute__ ((__const__)); extern float __truncf (float __x) throw () __attribute__ ((__const__));
extern float remquof (float __x, float __y, int *__quo) throw (); extern float __remquof (float __x, float __y, int *__quo) throw ();
extern long int lrintf (float __x) throw (); extern long int __lrintf (float __x) throw ();
extern long long int llrintf (float __x) throw (); extern long long int __llrintf (float __x) throw ();
extern long int lroundf (float __x) throw (); extern long int __lroundf (float __x) throw ();
extern long long int llroundf (float __x) throw (); extern long long int __llroundf (float __x) throw ();
extern float fdimf (float __x, float __y) throw (); extern float __fdimf (float __x, float __y) throw ();
extern float fmaxf (float __x, float __y) throw (); extern float __fmaxf (float __x, float __y) throw ();
extern float fminf (float __x, float __y) throw (); extern float __fminf (float __x, float __y) throw ();
extern int __fpclassifyf (float __value) throw ()
     __attribute__ ((__const__));
extern int __signbitf (float __value) throw ()
     __attribute__ ((__const__));
extern float fmaf (float __x, float __y, float __z) throw (); extern float __fmaf (float __x, float __y, float __z) throw ();
extern float scalbf (float __x, float __n) throw (); extern float __scalbf (float __x, float __n) throw ();
extern long double acosl (long double __x) throw (); extern long double __acosl (long double __x) throw ();
extern long double asinl (long double __x) throw (); extern long double __asinl (long double __x) throw ();
extern long double atanl (long double __x) throw (); extern long double __atanl (long double __x) throw ();
extern long double atan2l (long double __y, long double __x) throw (); extern long double __atan2l (long double __y, long double __x) throw ();
extern long double cosl (long double __x) throw (); extern long double __cosl (long double __x) throw ();
extern long double sinl (long double __x) throw (); extern long double __sinl (long double __x) throw ();
extern long double tanl (long double __x) throw (); extern long double __tanl (long double __x) throw ();
extern long double coshl (long double __x) throw (); extern long double __coshl (long double __x) throw ();
extern long double sinhl (long double __x) throw (); extern long double __sinhl (long double __x) throw ();
extern long double tanhl (long double __x) throw (); extern long double __tanhl (long double __x) throw ();
extern void sincosl (long double __x, long double *__sinx, long double *__cosx) throw (); extern void __sincosl (long double __x, long double *__sinx, long double *__cosx) throw ();
extern long double acoshl (long double __x) throw (); extern long double __acoshl (long double __x) throw ();
extern long double asinhl (long double __x) throw (); extern long double __asinhl (long double __x) throw ();
extern long double atanhl (long double __x) throw (); extern long double __atanhl (long double __x) throw ();
extern long double expl (long double __x) throw (); extern long double __expl (long double __x) throw ();
extern long double frexpl (long double __x, int *__exponent) throw (); extern long double __frexpl (long double __x, int *__exponent) throw ();
extern long double ldexpl (long double __x, int __exponent) throw (); extern long double __ldexpl (long double __x, int __exponent) throw ();
extern long double logl (long double __x) throw (); extern long double __logl (long double __x) throw ();
extern long double log10l (long double __x) throw (); extern long double __log10l (long double __x) throw ();
extern long double modfl (long double __x, long double *__iptr) throw (); extern long double __modfl (long double __x, long double *__iptr) throw ();
extern long double exp10l (long double __x) throw (); extern long double __exp10l (long double __x) throw ();
extern long double pow10l (long double __x) throw (); extern long double __pow10l (long double __x) throw ();
extern long double expm1l (long double __x) throw (); extern long double __expm1l (long double __x) throw ();
extern long double log1pl (long double __x) throw (); extern long double __log1pl (long double __x) throw ();
extern long double logbl (long double __x) throw (); extern long double __logbl (long double __x) throw ();
extern long double exp2l (long double __x) throw (); extern long double __exp2l (long double __x) throw ();
extern long double log2l (long double __x) throw (); extern long double __log2l (long double __x) throw ();
extern long double powl (long double __x, long double __y) throw (); extern long double __powl (long double __x, long double __y) throw ();
extern long double sqrtl (long double __x) throw (); extern long double __sqrtl (long double __x) throw ();
extern long double hypotl (long double __x, long double __y) throw (); extern long double __hypotl (long double __x, long double __y) throw ();
extern long double cbrtl (long double __x) throw (); extern long double __cbrtl (long double __x) throw ();
extern long double ceill (long double __x) throw () __attribute__ ((__const__)); extern long double __ceill (long double __x) throw () __attribute__ ((__const__));
extern long double fabsl (long double __x) throw () __attribute__ ((__const__)); extern long double __fabsl (long double __x) throw () __attribute__ ((__const__));
extern long double floorl (long double __x) throw () __attribute__ ((__const__)); extern long double __floorl (long double __x) throw () __attribute__ ((__const__));
extern long double fmodl (long double __x, long double __y) throw (); extern long double __fmodl (long double __x, long double __y) throw ();
extern int __isinfl (long double __value) throw () __attribute__ ((__const__));
extern int __finitel (long double __value) throw () __attribute__ ((__const__));
extern int isinfl (long double __value) throw () __attribute__ ((__const__));
extern int finitel (long double __value) throw () __attribute__ ((__const__));
extern long double dreml (long double __x, long double __y) throw (); extern long double __dreml (long double __x, long double __y) throw ();
extern long double significandl (long double __x) throw (); extern long double __significandl (long double __x) throw ();
extern long double copysignl (long double __x, long double __y) throw () __attribute__ ((__const__)); extern long double __copysignl (long double __x, long double __y) throw () __attribute__ ((__const__));
extern long double nanl (__const char *__tagb) throw () __attribute__ ((__const__)); extern long double __nanl (__const char *__tagb) throw () __attribute__ ((__const__));
extern int __isnanl (long double __value) throw () __attribute__ ((__const__));
extern int isnanl (long double __value) throw () __attribute__ ((__const__));
extern long double j0l (long double) throw (); extern long double __j0l (long double) throw ();
extern long double j1l (long double) throw (); extern long double __j1l (long double) throw ();
extern long double jnl (int, long double) throw (); extern long double __jnl (int, long double) throw ();
extern long double y0l (long double) throw (); extern long double __y0l (long double) throw ();
extern long double y1l (long double) throw (); extern long double __y1l (long double) throw ();
extern long double ynl (int, long double) throw (); extern long double __ynl (int, long double) throw ();
extern long double erfl (long double) throw (); extern long double __erfl (long double) throw ();
extern long double erfcl (long double) throw (); extern long double __erfcl (long double) throw ();
extern long double lgammal (long double) throw (); extern long double __lgammal (long double) throw ();
extern long double tgammal (long double) throw (); extern long double __tgammal (long double) throw ();
extern long double gammal (long double) throw (); extern long double __gammal (long double) throw ();
extern long double lgammal_r (long double, int *__signgamp) throw (); extern long double __lgammal_r (long double, int *__signgamp) throw ();
extern long double rintl (long double __x) throw (); extern long double __rintl (long double __x) throw ();
extern long double nextafterl (long double __x, long double __y) throw () __attribute__ ((__const__)); extern long double __nextafterl (long double __x, long double __y) throw () __attribute__ ((__const__));
extern long double nexttowardl (long double __x, long double __y) throw () __attribute__ ((__const__)); extern long double __nexttowardl (long double __x, long double __y) throw () __attribute__ ((__const__));
extern long double remainderl (long double __x, long double __y) throw (); extern long double __remainderl (long double __x, long double __y) throw ();
extern long double scalbnl (long double __x, int __n) throw (); extern long double __scalbnl (long double __x, int __n) throw ();
extern int ilogbl (long double __x) throw (); extern int __ilogbl (long double __x) throw ();
extern long double scalblnl (long double __x, long int __n) throw (); extern long double __scalblnl (long double __x, long int __n) throw ();
extern long double nearbyintl (long double __x) throw (); extern long double __nearbyintl (long double __x) throw ();
extern long double roundl (long double __x) throw () __attribute__ ((__const__)); extern long double __roundl (long double __x) throw () __attribute__ ((__const__));
extern long double truncl (long double __x) throw () __attribute__ ((__const__)); extern long double __truncl (long double __x) throw () __attribute__ ((__const__));
extern long double remquol (long double __x, long double __y, int *__quo) throw (); extern long double __remquol (long double __x, long double __y, int *__quo) throw ();
extern long int lrintl (long double __x) throw (); extern long int __lrintl (long double __x) throw ();
extern long long int llrintl (long double __x) throw (); extern long long int __llrintl (long double __x) throw ();
extern long int lroundl (long double __x) throw (); extern long int __lroundl (long double __x) throw ();
extern long long int llroundl (long double __x) throw (); extern long long int __llroundl (long double __x) throw ();
extern long double fdiml (long double __x, long double __y) throw (); extern long double __fdiml (long double __x, long double __y) throw ();
extern long double fmaxl (long double __x, long double __y) throw (); extern long double __fmaxl (long double __x, long double __y) throw ();
extern long double fminl (long double __x, long double __y) throw (); extern long double __fminl (long double __x, long double __y) throw ();
extern int __fpclassifyl (long double __value) throw ()
     __attribute__ ((__const__));
extern int __signbitl (long double __value) throw ()
     __attribute__ ((__const__));
extern long double fmal (long double __x, long double __y, long double __z) throw (); extern long double __fmal (long double __x, long double __y, long double __z) throw ();
extern long double scalbl (long double __x, long double __n) throw (); extern long double __scalbl (long double __x, long double __n) throw ();
extern int signgam;
enum
  {
    FP_NAN,
    FP_INFINITE,
    FP_ZERO,
    FP_SUBNORMAL,
    FP_NORMAL
  };
typedef enum
{
  _IEEE_ = -1,
  _SVID_,
  _XOPEN_,
  _POSIX_,
  _ISOC_
} _LIB_VERSION_TYPE;
extern _LIB_VERSION_TYPE _LIB_VERSION;
struct __exception
  {
    int type;
    char *name;
    double arg1;
    double arg2;
    double retval;
  };
extern int matherr (struct __exception *__exc) throw ();
extern __inline __attribute__ ((__gnu_inline__)) int
__signbitf (float __x) throw ()
{
  __extension__ union { float __f; int __i; } __u = { __f: __x };
  return __u.__i < 0;
}
extern __inline __attribute__ ((__gnu_inline__)) int
__signbit (double __x) throw ()
{
  __extension__ union { double __d; int __i[2]; } __u = { __d: __x };
  return __u.__i[1] < 0;
}
extern __inline __attribute__ ((__gnu_inline__)) int
__signbitl (long double __x) throw ()
{
  __extension__ union { long double __l; int __i[3]; } __u = { __l: __x };
  return (__u.__i[2] & 0x8000) != 0;
}
}
namespace std __attribute__ ((__visibility__ ("default"))) {
  template<typename _Tp>
    _Tp __cmath_power(_Tp, unsigned int);
  template<typename _Tp>
    inline _Tp
    __pow_helper(_Tp __x, int __n)
    {
      return __n < 0
        ? _Tp(1)/__cmath_power(__x, -__n)
        : __cmath_power(__x, __n);
    }
  inline double
  abs(double __x)
  { return __builtin_fabs(__x); }
  inline float
  abs(float __x)
  { return __builtin_fabsf(__x); }
  inline long double
  abs(long double __x)
  { return __builtin_fabsl(__x); }
  using ::acos;
  inline float
  acos(float __x)
  { return __builtin_acosf(__x); }
  inline long double
  acos(long double __x)
  { return __builtin_acosl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_integer<_Tp>::__value,
        double>::__type
    acos(_Tp __x)
    { return __builtin_acos(__x); }
  using ::asin;
  inline float
  asin(float __x)
  { return __builtin_asinf(__x); }
  inline long double
  asin(long double __x)
  { return __builtin_asinl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_integer<_Tp>::__value,
        double>::__type
    asin(_Tp __x)
    { return __builtin_asin(__x); }
  using ::atan;
  inline float
  atan(float __x)
  { return __builtin_atanf(__x); }
  inline long double
  atan(long double __x)
  { return __builtin_atanl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_integer<_Tp>::__value,
        double>::__type
    atan(_Tp __x)
    { return __builtin_atan(__x); }
  using ::atan2;
  inline float
  atan2(float __y, float __x)
  { return __builtin_atan2f(__y, __x); }
  inline long double
  atan2(long double __y, long double __x)
  { return __builtin_atan2l(__y, __x); }
  template<typename _Tp, typename _Up>
    inline
    typename __gnu_cxx::__promote_2<
    typename __gnu_cxx::__enable_if<__is_arithmetic<_Tp>::__value
        && __is_arithmetic<_Up>::__value,
        _Tp>::__type, _Up>::__type
    atan2(_Tp __y, _Up __x)
    {
      typedef typename __gnu_cxx::__promote_2<_Tp, _Up>::__type __type;
      return atan2(__type(__y), __type(__x));
    }
  using ::ceil;
  inline float
  ceil(float __x)
  { return __builtin_ceilf(__x); }
  inline long double
  ceil(long double __x)
  { return __builtin_ceill(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_integer<_Tp>::__value,
        double>::__type
    ceil(_Tp __x)
    { return __builtin_ceil(__x); }
  using ::cos;
  inline float
  cos(float __x)
  { return __builtin_cosf(__x); }
  inline long double
  cos(long double __x)
  { return __builtin_cosl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_integer<_Tp>::__value,
        double>::__type
    cos(_Tp __x)
    { return __builtin_cos(__x); }
  using ::cosh;
  inline float
  cosh(float __x)
  { return __builtin_coshf(__x); }
  inline long double
  cosh(long double __x)
  { return __builtin_coshl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_integer<_Tp>::__value,
        double>::__type
    cosh(_Tp __x)
    { return __builtin_cosh(__x); }
  using ::exp;
  inline float
  exp(float __x)
  { return __builtin_expf(__x); }
  inline long double
  exp(long double __x)
  { return __builtin_expl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_integer<_Tp>::__value,
        double>::__type
    exp(_Tp __x)
    { return __builtin_exp(__x); }
  using ::fabs;
  inline float
  fabs(float __x)
  { return __builtin_fabsf(__x); }
  inline long double
  fabs(long double __x)
  { return __builtin_fabsl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_integer<_Tp>::__value,
        double>::__type
    fabs(_Tp __x)
    { return __builtin_fabs(__x); }
  using ::floor;
  inline float
  floor(float __x)
  { return __builtin_floorf(__x); }
  inline long double
  floor(long double __x)
  { return __builtin_floorl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_integer<_Tp>::__value,
        double>::__type
    floor(_Tp __x)
    { return __builtin_floor(__x); }
  using ::fmod;
  inline float
  fmod(float __x, float __y)
  { return __builtin_fmodf(__x, __y); }
  inline long double
  fmod(long double __x, long double __y)
  { return __builtin_fmodl(__x, __y); }
  using ::frexp;
  inline float
  frexp(float __x, int* __exp)
  { return __builtin_frexpf(__x, __exp); }
  inline long double
  frexp(long double __x, int* __exp)
  { return __builtin_frexpl(__x, __exp); }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_integer<_Tp>::__value,
        double>::__type
    frexp(_Tp __x, int* __exp)
    { return __builtin_frexp(__x, __exp); }
  using ::ldexp;
  inline float
  ldexp(float __x, int __exp)
  { return __builtin_ldexpf(__x, __exp); }
  inline long double
  ldexp(long double __x, int __exp)
  { return __builtin_ldexpl(__x, __exp); }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_integer<_Tp>::__value,
        double>::__type
  ldexp(_Tp __x, int __exp)
  { return __builtin_ldexp(__x, __exp); }
  using ::log;
  inline float
  log(float __x)
  { return __builtin_logf(__x); }
  inline long double
  log(long double __x)
  { return __builtin_logl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_integer<_Tp>::__value,
        double>::__type
    log(_Tp __x)
    { return __builtin_log(__x); }
  using ::log10;
  inline float
  log10(float __x)
  { return __builtin_log10f(__x); }
  inline long double
  log10(long double __x)
  { return __builtin_log10l(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_integer<_Tp>::__value,
        double>::__type
    log10(_Tp __x)
    { return __builtin_log10(__x); }
  using ::modf;
  inline float
  modf(float __x, float* __iptr)
  { return __builtin_modff(__x, __iptr); }
  inline long double
  modf(long double __x, long double* __iptr)
  { return __builtin_modfl(__x, __iptr); }
  using ::pow;
  inline float
  pow(float __x, float __y)
  { return __builtin_powf(__x, __y); }
  inline long double
  pow(long double __x, long double __y)
  { return __builtin_powl(__x, __y); }
  template<typename _Tp, typename _Up>
    inline
    typename __gnu_cxx::__promote_2<
    typename __gnu_cxx::__enable_if<__is_arithmetic<_Tp>::__value
        && __is_arithmetic<_Up>::__value,
        _Tp>::__type, _Up>::__type
    pow(_Tp __x, _Up __y)
    {
      typedef typename __gnu_cxx::__promote_2<_Tp, _Up>::__type __type;
      return pow(__type(__x), __type(__y));
    }
  using ::sin;
  inline float
  sin(float __x)
  { return __builtin_sinf(__x); }
  inline long double
  sin(long double __x)
  { return __builtin_sinl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_integer<_Tp>::__value,
        double>::__type
    sin(_Tp __x)
    { return __builtin_sin(__x); }
  using ::sinh;
  inline float
  sinh(float __x)
  { return __builtin_sinhf(__x); }
  inline long double
  sinh(long double __x)
  { return __builtin_sinhl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_integer<_Tp>::__value,
        double>::__type
    sinh(_Tp __x)
    { return __builtin_sinh(__x); }
  using ::sqrt;
  inline float
  sqrt(float __x)
  { return __builtin_sqrtf(__x); }
  inline long double
  sqrt(long double __x)
  { return __builtin_sqrtl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_integer<_Tp>::__value,
        double>::__type
    sqrt(_Tp __x)
    { return __builtin_sqrt(__x); }
  using ::tan;
  inline float
  tan(float __x)
  { return __builtin_tanf(__x); }
  inline long double
  tan(long double __x)
  { return __builtin_tanl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_integer<_Tp>::__value,
        double>::__type
    tan(_Tp __x)
    { return __builtin_tan(__x); }
  using ::tanh;
  inline float
  tanh(float __x)
  { return __builtin_tanhf(__x); }
  inline long double
  tanh(long double __x)
  { return __builtin_tanhl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_integer<_Tp>::__value,
        double>::__type
    tanh(_Tp __x)
    { return __builtin_tanh(__x); }
}
namespace std __attribute__ ((__visibility__ ("default"))) {
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_arithmetic<_Tp>::__value,
        int>::__type
    fpclassify(_Tp __f)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return __builtin_fpclassify(FP_NAN, FP_INFINITE, FP_NORMAL,
      FP_SUBNORMAL, FP_ZERO, __type(__f));
    }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_arithmetic<_Tp>::__value,
        int>::__type
    isfinite(_Tp __f)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return __builtin_isfinite(__type(__f));
    }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_arithmetic<_Tp>::__value,
        int>::__type
    isinf(_Tp __f)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return __builtin_isinf(__type(__f));
    }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_arithmetic<_Tp>::__value,
        int>::__type
    isnan(_Tp __f)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return __builtin_isnan(__type(__f));
    }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_arithmetic<_Tp>::__value,
        int>::__type
    isnormal(_Tp __f)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return __builtin_isnormal(__type(__f));
    }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_arithmetic<_Tp>::__value,
        int>::__type
    signbit(_Tp __f)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return __builtin_signbit(__type(__f));
    }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_arithmetic<_Tp>::__value,
        int>::__type
    isgreater(_Tp __f1, _Tp __f2)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return __builtin_isgreater(__type(__f1), __type(__f2));
    }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_arithmetic<_Tp>::__value,
        int>::__type
    isgreaterequal(_Tp __f1, _Tp __f2)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return __builtin_isgreaterequal(__type(__f1), __type(__f2));
    }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_arithmetic<_Tp>::__value,
        int>::__type
    isless(_Tp __f1, _Tp __f2)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return __builtin_isless(__type(__f1), __type(__f2));
    }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_arithmetic<_Tp>::__value,
        int>::__type
    islessequal(_Tp __f1, _Tp __f2)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return __builtin_islessequal(__type(__f1), __type(__f2));
    }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_arithmetic<_Tp>::__value,
        int>::__type
    islessgreater(_Tp __f1, _Tp __f2)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return __builtin_islessgreater(__type(__f1), __type(__f2));
    }
  template<typename _Tp>
    inline typename __gnu_cxx::__enable_if<__is_arithmetic<_Tp>::__value,
        int>::__type
    isunordered(_Tp __f1, _Tp __f2)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return __builtin_isunordered(__type(__f1), __type(__f2));
    }
}
namespace std __attribute__ ((__visibility__ ("default"))) {
  template<typename _Tp>
    inline _Tp
    __cmath_power(_Tp __x, unsigned int __n)
    {
      _Tp __y = __n % 2 ? __x : _Tp(1);
      while (__n >>= 1)
        {
          __x = __x * __x;
          if (__n % 2)
            __y = __y * __x;
        }
      return __y;
    }
}
namespace std
{
  using ::double_t;
  using ::float_t;
  using ::acosh;
  using ::acoshf;
  using ::acoshl;
  using ::asinh;
  using ::asinhf;
  using ::asinhl;
  using ::atanh;
  using ::atanhf;
  using ::atanhl;
  using ::cbrt;
  using ::cbrtf;
  using ::cbrtl;
  using ::copysign;
  using ::copysignf;
  using ::copysignl;
  using ::erf;
  using ::erff;
  using ::erfl;
  using ::erfc;
  using ::erfcf;
  using ::erfcl;
  using ::exp2;
  using ::exp2f;
  using ::exp2l;
  using ::expm1;
  using ::expm1f;
  using ::expm1l;
  using ::fdim;
  using ::fdimf;
  using ::fdiml;
  using ::fma;
  using ::fmaf;
  using ::fmal;
  using ::fmax;
  using ::fmaxf;
  using ::fmaxl;
  using ::fmin;
  using ::fminf;
  using ::fminl;
  using ::hypot;
  using ::hypotf;
  using ::hypotl;
  using ::ilogb;
  using ::ilogbf;
  using ::ilogbl;
  using ::lgamma;
  using ::lgammaf;
  using ::lgammal;
  using ::llrint;
  using ::llrintf;
  using ::llrintl;
  using ::llround;
  using ::llroundf;
  using ::llroundl;
  using ::log1p;
  using ::log1pf;
  using ::log1pl;
  using ::log2;
  using ::log2f;
  using ::log2l;
  using ::logb;
  using ::logbf;
  using ::logbl;
  using ::lrint;
  using ::lrintf;
  using ::lrintl;
  using ::lround;
  using ::lroundf;
  using ::lroundl;
  using ::nan;
  using ::nanf;
  using ::nanl;
  using ::nearbyint;
  using ::nearbyintf;
  using ::nearbyintl;
  using ::nextafter;
  using ::nextafterf;
  using ::nextafterl;
  using ::nexttoward;
  using ::nexttowardf;
  using ::nexttowardl;
  using ::remainder;
  using ::remainderf;
  using ::remainderl;
  using ::remquo;
  using ::remquof;
  using ::remquol;
  using ::rint;
  using ::rintf;
  using ::rintl;
  using ::round;
  using ::roundf;
  using ::roundl;
  using ::scalbln;
  using ::scalblnf;
  using ::scalblnl;
  using ::scalbn;
  using ::scalbnf;
  using ::scalbnl;
  using ::tgamma;
  using ::tgammaf;
  using ::tgammal;
  using ::trunc;
  using ::truncf;
  using ::truncl;
  using std::signbit;
  using std::fpclassify;
  using std::isfinite;
  using std::isinf;
  using std::isnan;
  using std::isnormal;
  using std::isgreater;
  using std::isgreaterequal;
  using std::isless;
  using std::islessequal;
  using std::islessgreater;
  using std::isunordered;
  using std::acos;
  inline float
  acosh(float __x)
  { return __builtin_acoshf(__x); }
  inline long double
  acosh(long double __x)
  { return __builtin_acoshl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__promote<_Tp>::__type
    acosh(_Tp __x)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return acosh(__type(__x));
    }
  using std::asin;
  inline float
  asinh(float __x)
  { return __builtin_asinhf(__x); }
  inline long double
  asinh(long double __x)
  { return __builtin_asinhl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__promote<_Tp>::__type
    asinh(_Tp __x)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return asinh(__type(__x));
    }
  using std::atan;
  using std::atan2;
  inline float
  atanh(float __x)
  { return __builtin_atanhf(__x); }
  inline long double
  atanh(long double __x)
  { return __builtin_atanhl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__promote<_Tp>::__type
    atanh(_Tp __x)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return atanh(__type(__x));
    }
  inline float
  cbrt(float __x)
  { return __builtin_cbrtf(__x); }
  inline long double
  cbrt(long double __x)
  { return __builtin_cbrtl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__promote<_Tp>::__type
    cbrt(_Tp __x)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return cbrt(__type(__x));
    }
  using std::ceil;
  inline float
  copysign(float __x, float __y)
  { return __builtin_copysignf(__x, __y); }
  inline long double
  copysign(long double __x, long double __y)
  { return __builtin_copysignl(__x, __y); }
  template<typename _Tp, typename _Up>
    inline typename __gnu_cxx::__promote_2<_Tp, _Up>::__type
    copysign(_Tp __x, _Up __y)
    {
      typedef typename __gnu_cxx::__promote_2<_Tp, _Up>::__type __type;
      return copysign(__type(__x), __type(__y));
    }
  using std::cos;
  using std::cosh;
  inline float
  erf(float __x)
  { return __builtin_erff(__x); }
  inline long double
  erf(long double __x)
  { return __builtin_erfl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__promote<_Tp>::__type
    erf(_Tp __x)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return erf(__type(__x));
    }
  inline float
  erfc(float __x)
  { return __builtin_erfcf(__x); }
  inline long double
  erfc(long double __x)
  { return __builtin_erfcl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__promote<_Tp>::__type
    erfc(_Tp __x)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return erfc(__type(__x));
    }
  using std::exp;
  inline float
  exp2(float __x)
  { return __builtin_exp2f(__x); }
  inline long double
  exp2(long double __x)
  { return __builtin_exp2l(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__promote<_Tp>::__type
    exp2(_Tp __x)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return exp2(__type(__x));
    }
  inline float
  expm1(float __x)
  { return __builtin_expm1f(__x); }
  inline long double
  expm1(long double __x)
  { return __builtin_expm1l(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__promote<_Tp>::__type
    expm1(_Tp __x)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return expm1(__type(__x));
    }
  using std::fabs;
  inline float
  fdim(float __x, float __y)
  { return __builtin_fdimf(__x, __y); }
  inline long double
  fdim(long double __x, long double __y)
  { return __builtin_fdiml(__x, __y); }
  template<typename _Tp, typename _Up>
    inline typename __gnu_cxx::__promote_2<_Tp, _Up>::__type
    fdim(_Tp __x, _Up __y)
    {
      typedef typename __gnu_cxx::__promote_2<_Tp, _Up>::__type __type;
      return fdim(__type(__x), __type(__y));
    }
  using std::floor;
  inline float
  fma(float __x, float __y, float __z)
  { return __builtin_fmaf(__x, __y, __z); }
  inline long double
  fma(long double __x, long double __y, long double __z)
  { return __builtin_fmal(__x, __y, __z); }
  template<typename _Tp, typename _Up, typename _Vp>
    inline typename __gnu_cxx::__promote_3<_Tp, _Up, _Vp>::__type
    fma(_Tp __x, _Up __y, _Vp __z)
    {
      typedef typename __gnu_cxx::__promote_3<_Tp, _Up, _Vp>::__type __type;
      return fma(__type(__x), __type(__y), __type(__z));
    }
  inline float
  fmax(float __x, float __y)
  { return __builtin_fmaxf(__x, __y); }
  inline long double
  fmax(long double __x, long double __y)
  { return __builtin_fmaxl(__x, __y); }
  template<typename _Tp, typename _Up>
    inline typename __gnu_cxx::__promote_2<_Tp, _Up>::__type
    fmax(_Tp __x, _Up __y)
    {
      typedef typename __gnu_cxx::__promote_2<_Tp, _Up>::__type __type;
      return fmax(__type(__x), __type(__y));
    }
  inline float
  fmin(float __x, float __y)
  { return __builtin_fminf(__x, __y); }
  inline long double
  fmin(long double __x, long double __y)
  { return __builtin_fminl(__x, __y); }
  template<typename _Tp, typename _Up>
    inline typename __gnu_cxx::__promote_2<_Tp, _Up>::__type
    fmin(_Tp __x, _Up __y)
    {
      typedef typename __gnu_cxx::__promote_2<_Tp, _Up>::__type __type;
      return fmin(__type(__x), __type(__y));
    }
  using std::fmod;
  using std::frexp;
  inline float
  hypot(float __x, float __y)
  { return __builtin_hypotf(__x, __y); }
  inline long double
  hypot(long double __x, long double __y)
  { return __builtin_hypotl(__x, __y); }
  template<typename _Tp, typename _Up>
    inline typename __gnu_cxx::__promote_2<_Tp, _Up>::__type
    hypot(_Tp __x, _Up __y)
    {
      typedef typename __gnu_cxx::__promote_2<_Tp, _Up>::__type __type;
      return hypot(__type(__x), __type(__y));
    }
  inline int
  ilogb(float __x)
  { return __builtin_ilogbf(__x); }
  inline int
  ilogb(long double __x)
  { return __builtin_ilogbl(__x); }
  template<typename _Tp>
    inline int
    ilogb(_Tp __x)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return ilogb(__type(__x));
    }
  using std::ldexp;
  inline float
  lgamma(float __x)
  { return __builtin_lgammaf(__x); }
  inline long double
  lgamma(long double __x)
  { return __builtin_lgammal(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__promote<_Tp>::__type
    lgamma(_Tp __x)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return lgamma(__type(__x));
    }
  inline long long
  llrint(float __x)
  { return __builtin_llrintf(__x); }
  inline long long
  llrint(long double __x)
  { return __builtin_llrintl(__x); }
  template<typename _Tp>
    inline long long
    llrint(_Tp __x)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return llrint(__type(__x));
    }
  inline long long
  llround(float __x)
  { return __builtin_llroundf(__x); }
  inline long long
  llround(long double __x)
  { return __builtin_llroundl(__x); }
  template<typename _Tp>
    inline long long
    llround(_Tp __x)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return llround(__type(__x));
    }
  using std::log;
  using std::log10;
  inline float
  log1p(float __x)
  { return __builtin_log1pf(__x); }
  inline long double
  log1p(long double __x)
  { return __builtin_log1pl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__promote<_Tp>::__type
    log1p(_Tp __x)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return log1p(__type(__x));
    }
  inline float
  log2(float __x)
  { return __builtin_log2f(__x); }
  inline long double
  log2(long double __x)
  { return __builtin_log2l(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__promote<_Tp>::__type
    log2(_Tp __x)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return log2(__type(__x));
    }
  inline float
  logb(float __x)
  { return __builtin_logbf(__x); }
  inline long double
  logb(long double __x)
  { return __builtin_logbl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__promote<_Tp>::__type
    logb(_Tp __x)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return logb(__type(__x));
    }
  inline long
  lrint(float __x)
  { return __builtin_lrintf(__x); }
  inline long
  lrint(long double __x)
  { return __builtin_lrintl(__x); }
  template<typename _Tp>
    inline long
    lrint(_Tp __x)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return lrint(__type(__x));
    }
  inline long
  lround(float __x)
  { return __builtin_lroundf(__x); }
  inline long
  lround(long double __x)
  { return __builtin_lroundl(__x); }
  template<typename _Tp>
    inline long
    lround(_Tp __x)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return lround(__type(__x));
    }
  inline float
  nearbyint(float __x)
  { return __builtin_nearbyintf(__x); }
  inline long double
  nearbyint(long double __x)
  { return __builtin_nearbyintl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__promote<_Tp>::__type
    nearbyint(_Tp __x)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return nearbyint(__type(__x));
    }
  inline float
  nextafter(float __x, float __y)
  { return __builtin_nextafterf(__x, __y); }
  inline long double
  nextafter(long double __x, long double __y)
  { return __builtin_nextafterl(__x, __y); }
  template<typename _Tp, typename _Up>
    inline typename __gnu_cxx::__promote_2<_Tp, _Up>::__type
    nextafter(_Tp __x, _Up __y)
    {
      typedef typename __gnu_cxx::__promote_2<_Tp, _Up>::__type __type;
      return nextafter(__type(__x), __type(__y));
    }
  inline float
  nexttoward(float __x, long double __y)
  { return __builtin_nexttowardf(__x, __y); }
  inline long double
  nexttoward(long double __x, long double __y)
  { return __builtin_nexttowardl(__x, __y); }
  template<typename _Tp>
    inline typename __gnu_cxx::__promote<_Tp>::__type
    nexttoward(_Tp __x, long double __y)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return nexttoward(__type(__x), __y);
    }
  inline float
  remainder(float __x, float __y)
  { return __builtin_remainderf(__x, __y); }
  inline long double
  remainder(long double __x, long double __y)
  { return __builtin_remainderl(__x, __y); }
  template<typename _Tp, typename _Up>
    inline typename __gnu_cxx::__promote_2<_Tp, _Up>::__type
    remainder(_Tp __x, _Up __y)
    {
      typedef typename __gnu_cxx::__promote_2<_Tp, _Up>::__type __type;
      return remainder(__type(__x), __type(__y));
    }
  inline float
  remquo(float __x, float __y, int* __pquo)
  { return __builtin_remquof(__x, __y, __pquo); }
  inline long double
  remquo(long double __x, long double __y, int* __pquo)
  { return __builtin_remquol(__x, __y, __pquo); }
  template<typename _Tp, typename _Up>
    inline typename __gnu_cxx::__promote_2<_Tp, _Up>::__type
    remquo(_Tp __x, _Up __y, int* __pquo)
    {
      typedef typename __gnu_cxx::__promote_2<_Tp, _Up>::__type __type;
      return remquo(__type(__x), __type(__y), __pquo);
    }
  inline float
  rint(float __x)
  { return __builtin_rintf(__x); }
  inline long double
  rint(long double __x)
  { return __builtin_rintl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__promote<_Tp>::__type
    rint(_Tp __x)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return rint(__type(__x));
    }
  inline float
  round(float __x)
  { return __builtin_roundf(__x); }
  inline long double
  round(long double __x)
  { return __builtin_roundl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__promote<_Tp>::__type
    round(_Tp __x)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return round(__type(__x));
    }
  inline float
  scalbln(float __x, long __ex)
  { return __builtin_scalblnf(__x, __ex); }
  inline long double
  scalbln(long double __x, long __ex)
  { return __builtin_scalblnl(__x, __ex); }
  template<typename _Tp>
    inline typename __gnu_cxx::__promote<_Tp>::__type
    scalbln(_Tp __x, long __ex)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return scalbln(__type(__x), __ex);
    }
  inline float
  scalbn(float __x, int __ex)
  { return __builtin_scalbnf(__x, __ex); }
  inline long double
  scalbn(long double __x, int __ex)
  { return __builtin_scalbnl(__x, __ex); }
  template<typename _Tp>
    inline typename __gnu_cxx::__promote<_Tp>::__type
    scalbn(_Tp __x, int __ex)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return scalbn(__type(__x), __ex);
    }
  using std::sin;
  using std::sinh;
  using std::sqrt;
  using std::tan;
  using std::tanh;
  inline float
  tgamma(float __x)
  { return __builtin_tgammaf(__x); }
  inline long double
  tgamma(long double __x)
  { return __builtin_tgammal(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__promote<_Tp>::__type
    tgamma(_Tp __x)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return tgamma(__type(__x));
    }
  inline float
  trunc(float __x)
  { return __builtin_truncf(__x); }
  inline long double
  trunc(long double __x)
  { return __builtin_truncl(__x); }
  template<typename _Tp>
    inline typename __gnu_cxx::__promote<_Tp>::__type
    trunc(_Tp __x)
    {
      typedef typename __gnu_cxx::__promote<_Tp>::__type __type;
      return trunc(__type(__x));
    }
}
inline double abs(double __x)
{ return ::fabs(__x); }
inline float abs (float x) { return ::fabsf(x); } inline long double abs (long double x) { return ::fabsl(x); }
inline float acos (float x) { return ::acosf(x); } inline long double acos (long double x) { return ::acosl(x); }
inline float asin (float x) { return ::asinf(x); } inline long double asin (long double x) { return ::asinl(x); }
inline float atan (float x) { return ::atanf(x); } inline long double atan (long double x) { return ::atanl(x); }
inline float atan2 (float x, float y) { return ::atan2f(x, y); } inline long double atan2 (long double x, long double y) { return ::atan2l(x, y); }
inline float ceil (float x) { return ::ceilf(x); } inline long double ceil (long double x) { return ::ceill(x); }
inline float cos (float x) { return ::cosf(x); } inline long double cos (long double x) { return ::cosl(x); }
inline float cosh (float x) { return ::coshf(x); } inline long double cosh (long double x) { return ::coshl(x); }
inline float exp (float x) { return ::expf(x); } inline long double exp (long double x) { return ::expl(x); }
inline float fabs (float x) { return ::fabsf(x); } inline long double fabs (long double x) { return ::fabsl(x); }
inline float floor (float x) { return ::floorf(x); } inline long double floor (long double x) { return ::floorl(x); }
inline float fmod (float x, float y) { return ::fmodf(x, y); } inline long double fmod (long double x, long double y) { return ::fmodl(x, y); }
inline float frexp (float x, int * y) { return ::frexpf(x, y); } inline long double frexp (long double x, int * y) { return ::frexpl(x, y); }
inline float ldexp (float x, int y) { return ::ldexpf(x, y); } inline long double ldexp (long double x, int y) { return ::ldexpl(x, y); }
inline float log (float x) { return ::logf(x); } inline long double log (long double x) { return ::logl(x); }
inline float log10 (float x) { return ::log10f(x); } inline long double log10 (long double x) { return ::log10l(x); }
inline float modf (float x, float * y) { return ::modff(x, y); } inline long double modf (long double x, long double * y) { return ::modfl(x, y); }
inline float sin (float x) { return ::sinf(x); } inline long double sin (long double x) { return ::sinl(x); }
inline float sinh (float x) { return ::sinhf(x); } inline long double sinh (long double x) { return ::sinhl(x); }
inline float sqrt (float x) { return ::sqrtf(x); } inline long double sqrt (long double x) { return ::sqrtl(x); }
inline float tan (float x) { return ::tanf(x); } inline long double tan (long double x) { return ::tanl(x); }
inline float tanh (float x) { return ::tanhf(x); } inline long double tanh (long double x) { return ::tanhl(x); }
inline float pow (float x, float y) { return ::powf(x, y); } inline long double pow (long double x, long double y) { return ::powl(x, y); }
inline float pow(float __x, int __y) { return ::powf(__x, static_cast<float>(__y)); }
inline double pow(double __x, int __y) { return ::pow(__x, static_cast<double>(__y)); }
inline long double pow(long double __x, int __y) { return ::powl(__x, static_cast<long double>(__y)); }
namespace stlp_std {
using ::abs;
using ::acos;
using ::asin;
using ::atan;
using ::atan2;
using ::ceil;
using ::cos;
using ::cosh;
using ::exp;
using ::fabs;
using ::floor;
using ::fmod;
using ::frexp;
using ::hypot;
using ::ldexp;
using ::log;
using ::log10;
using ::modf;
using ::pow;
using ::sin;
using ::sinh;
using ::sqrt;
using ::tan;
using ::tanh;
}
namespace stlp_std {
using ::abs;
using ::div;
}
       
       
extern "C" {
extern void *memcpy (void *__restrict __dest,
       __const void *__restrict __src, size_t __n)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern void *memmove (void *__dest, __const void *__src, size_t __n)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern void *memccpy (void *__restrict __dest, __const void *__restrict __src,
        int __c, size_t __n)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern void *memset (void *__s, int __c, size_t __n) throw () __attribute__ ((__nonnull__ (1)));
extern int memcmp (__const void *__s1, __const void *__s2, size_t __n)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1, 2)));
extern void *memchr (__const void *__s, int __c, size_t __n)
      throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1)));
extern void *rawmemchr (__const void *__s, int __c)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1)));
extern void *memrchr (__const void *__s, int __c, size_t __n)
      throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1)));
extern char *strcpy (char *__restrict __dest, __const char *__restrict __src)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern char *strncpy (char *__restrict __dest,
        __const char *__restrict __src, size_t __n)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern char *strcat (char *__restrict __dest, __const char *__restrict __src)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern char *strncat (char *__restrict __dest, __const char *__restrict __src,
        size_t __n) throw () __attribute__ ((__nonnull__ (1, 2)));
extern int strcmp (__const char *__s1, __const char *__s2)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1, 2)));
extern int strncmp (__const char *__s1, __const char *__s2, size_t __n)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1, 2)));
extern int strcoll (__const char *__s1, __const char *__s2)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1, 2)));
extern size_t strxfrm (char *__restrict __dest,
         __const char *__restrict __src, size_t __n)
     throw () __attribute__ ((__nonnull__ (2)));
extern int strcoll_l (__const char *__s1, __const char *__s2, __locale_t __l)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1, 2, 3)));
extern size_t strxfrm_l (char *__dest, __const char *__src, size_t __n,
    __locale_t __l) throw () __attribute__ ((__nonnull__ (2, 4)));
extern char *strdup (__const char *__s)
     throw () __attribute__ ((__malloc__)) __attribute__ ((__nonnull__ (1)));
extern char *strndup (__const char *__string, size_t __n)
     throw () __attribute__ ((__malloc__)) __attribute__ ((__nonnull__ (1)));
extern char *strchr (__const char *__s, int __c)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1)));
extern char *strrchr (__const char *__s, int __c)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1)));
extern char *strchrnul (__const char *__s, int __c)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1)));
extern size_t strcspn (__const char *__s, __const char *__reject)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1, 2)));
extern size_t strspn (__const char *__s, __const char *__accept)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1, 2)));
extern char *strpbrk (__const char *__s, __const char *__accept)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1, 2)));
extern char *strstr (__const char *__haystack, __const char *__needle)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1, 2)));
extern char *strtok (char *__restrict __s, __const char *__restrict __delim)
     throw () __attribute__ ((__nonnull__ (2)));
extern char *__strtok_r (char *__restrict __s,
    __const char *__restrict __delim,
    char **__restrict __save_ptr)
     throw () __attribute__ ((__nonnull__ (2, 3)));
extern char *strtok_r (char *__restrict __s, __const char *__restrict __delim,
         char **__restrict __save_ptr)
     throw () __attribute__ ((__nonnull__ (2, 3)));
extern char *strcasestr (__const char *__haystack, __const char *__needle)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1, 2)));
extern void *memmem (__const void *__haystack, size_t __haystacklen,
       __const void *__needle, size_t __needlelen)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1, 3)));
extern void *__mempcpy (void *__restrict __dest,
   __const void *__restrict __src, size_t __n)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern void *mempcpy (void *__restrict __dest,
        __const void *__restrict __src, size_t __n)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern size_t strlen (__const char *__s)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1)));
extern size_t strnlen (__const char *__string, size_t __maxlen)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1)));
extern char *strerror (int __errnum) throw ();
extern char *strerror_r (int __errnum, char *__buf, size_t __buflen)
     throw () __attribute__ ((__nonnull__ (2)));
extern char *strerror_l (int __errnum, __locale_t __l) throw ();
extern void __bzero (void *__s, size_t __n) throw () __attribute__ ((__nonnull__ (1)));
extern void bcopy (__const void *__src, void *__dest, size_t __n)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern void bzero (void *__s, size_t __n) throw () __attribute__ ((__nonnull__ (1)));
extern int bcmp (__const void *__s1, __const void *__s2, size_t __n)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1, 2)));
extern char *index (__const char *__s, int __c)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1)));
extern char *rindex (__const char *__s, int __c)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1)));
extern int ffs (int __i) throw () __attribute__ ((__const__));
extern int ffsl (long int __l) throw () __attribute__ ((__const__));
__extension__ extern int ffsll (long long int __ll)
     throw () __attribute__ ((__const__));
extern int strcasecmp (__const char *__s1, __const char *__s2)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1, 2)));
extern int strncasecmp (__const char *__s1, __const char *__s2, size_t __n)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1, 2)));
extern int strcasecmp_l (__const char *__s1, __const char *__s2,
    __locale_t __loc)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1, 2, 3)));
extern int strncasecmp_l (__const char *__s1, __const char *__s2,
     size_t __n, __locale_t __loc)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1, 2, 4)));
extern char *strsep (char **__restrict __stringp,
       __const char *__restrict __delim)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern int strverscmp (__const char *__s1, __const char *__s2)
     throw () __attribute__ ((__pure__)) __attribute__ ((__nonnull__ (1, 2)));
extern char *strsignal (int __sig) throw ();
extern char *__stpcpy (char *__restrict __dest, __const char *__restrict __src)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern char *stpcpy (char *__restrict __dest, __const char *__restrict __src)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern char *__stpncpy (char *__restrict __dest,
   __const char *__restrict __src, size_t __n)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern char *stpncpy (char *__restrict __dest,
        __const char *__restrict __src, size_t __n)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern char *strfry (char *__string) throw () __attribute__ ((__nonnull__ (1)));
extern void *memfrob (void *__s, size_t __n) throw () __attribute__ ((__nonnull__ (1)));
extern char *basename (__const char *__filename) throw () __attribute__ ((__nonnull__ (1)));
}
namespace std __attribute__ ((__visibility__ ("default"))) {
  using ::memchr;
  using ::memcmp;
  using ::memcpy;
  using ::memmove;
  using ::memset;
  using ::strcat;
  using ::strcmp;
  using ::strcoll;
  using ::strcpy;
  using ::strcspn;
  using ::strerror;
  using ::strlen;
  using ::strncat;
  using ::strncmp;
  using ::strncpy;
  using ::strspn;
  using ::strtok;
  using ::strxfrm;
  using ::strchr;
  using ::strpbrk;
  using ::strrchr;
  using ::strstr;
  inline void*
  memchr(void* __p, int __c, size_t __n)
  { return memchr(const_cast<const void*>(__p), __c, __n); }
  inline char*
  strchr(char* __s1, int __n)
  { return __builtin_strchr(const_cast<const char*>(__s1), __n); }
  inline char*
  strpbrk(char* __s1, const char* __s2)
  { return __builtin_strpbrk(const_cast<const char*>(__s1), __s2); }
  inline char*
  strrchr(char* __s1, int __n)
  { return __builtin_strrchr(const_cast<const char*>(__s1), __n); }
  inline char*
  strstr(char* __s1, const char* __s2)
  { return __builtin_strstr(const_cast<const char*>(__s1), __s2); }
}
namespace stlp_std {
using std::size_t;
using std::memmove;
using std::memcpy;
using std::strcoll;
using std::strerror;
using std::strxfrm;
using std::memchr;
using std::strchr;
using std::strpbrk;
using std::strrchr;
using std::strstr;
using std::memcmp;
using std::memset;
using std::strcat;
using std::strcmp;
using std::strcpy;
using std::strcspn;
using std::strlen;
using std::strncat;
using std::strncmp;
using std::strncpy;
using std::strspn;
using std::strtok;
}
       
namespace stlp_std {
struct __true_type {};
struct __false_type {};
namespace priv {
using ::stlp_std::__true_type;
using ::stlp_std::__false_type;
}
template <int _Is>
struct __bool2type
{ typedef __true_type _Ret; };
template<>
struct __bool2type<1> { typedef __true_type _Ret; };
template<>
struct __bool2type<0> { typedef __false_type _Ret; };
template <class __bool_type>
struct __type2bool { enum {_Ret = 1}; };
template<>
struct __type2bool<__true_type> { enum {_Ret = 1}; };
template<>
struct __type2bool<__false_type> { enum {_Ret = 0}; };
template <class _BoolType>
struct _Not { typedef __false_type _Ret; };
template<>
struct _Not<__false_type> { typedef __true_type _Ret; };
template <class _P1, class _P2>
struct _Land2 { typedef __false_type _Ret; };
template<>
struct _Land2<__true_type, __true_type> { typedef __true_type _Ret; };
template <class _P1, class _P2, class _P3>
struct _Land3 { typedef __false_type _Ret; };
template<>
struct _Land3<__true_type, __true_type, __true_type> { typedef __true_type _Ret; };
template <class _P1, class _P2>
struct _Lor2 { typedef __true_type _Ret; };
template<>
struct _Lor2<__false_type, __false_type> { typedef __false_type _Ret; };
template <class _P1, class _P2, class _P3>
struct _Lor3 { typedef __true_type _Ret; };
template<>
struct _Lor3<__false_type, __false_type, __false_type> { typedef __false_type _Ret; };
template <bool _Cond, class _Tp1, class _Tp2>
struct __select { typedef _Tp1 _Ret; };
template <class _Tp1, class _Tp2>
struct __select<false, _Tp1, _Tp2> { typedef _Tp2 _Ret; };
struct _NoVolatilePointerShim { _NoVolatilePointerShim(const void*); };
template <class _Tp>
char _IsCopyableFun(bool, _NoVolatilePointerShim, _Tp const*, _Tp*);
char* _IsCopyableFun(bool, ...);
template <class _Src, class _Dst>
struct _Copyable {
  static _Src* __null_src();
  static _Dst* __null_dst();
  enum { _Ret = (sizeof(_IsCopyableFun(false, __null_src(), __null_src(), __null_dst())) == sizeof(char)) };
  typedef typename __bool2type<_Ret>::_Ret _RetT;
};
template <class _Src, class _Dst>
struct _AreCopyable {
  enum { _Same = _Copyable<_Src, _Dst>::_Ret };
  typedef typename _Copyable<_Src, _Dst>::_RetT _Ret;
};
template <class _Tp1, class _Tp2>
struct _AreSameTypes {
  enum { _Same = 0 };
  typedef __false_type _Ret;
};
template <class _Tp>
struct _AreSameTypes<_Tp, _Tp> {
  enum { _Same = 1 };
  typedef __true_type _Ret;
};
template <class _Src, class _Dst>
struct _ConversionHelper {
  static char _Test(bool, _Dst);
  static char* _Test(bool, ...);
  static _Src _MakeSource();
};
template <class _Src, class _Dst>
struct _IsConvertible {
  typedef _ConversionHelper<_Src*, const volatile _Dst*> _H;
  enum { value = (sizeof(char) == sizeof(_H::_Test(false, _H::_MakeSource()))) };
  typedef typename __bool2type<value>::_Ret _Ret;
};
template <class _Src, class _Dst>
struct _IsCVConvertible {
  typedef _ConversionHelper<_Src, _Dst> _H;
  enum { value = (sizeof(char) == sizeof(_H::_Test(false, _H::_MakeSource()))) };
  typedef typename __bool2type<value>::_Ret _Ret;
};
}
namespace stlp_std {
template <class _Tp> struct _IsIntegral
{ typedef __false_type _Ret; };
template<> struct _IsIntegral<bool>
{ typedef __true_type _Ret; };
template<> struct _IsIntegral<char>
{ typedef __true_type _Ret; };
template<> struct _IsIntegral<signed char>
{ typedef __true_type _Ret; };
template<> struct _IsIntegral<unsigned char>
{ typedef __true_type _Ret; };
template<> struct _IsIntegral<wchar_t>
{ typedef __true_type _Ret; };
template<> struct _IsIntegral<short>
{ typedef __true_type _Ret; };
template<> struct _IsIntegral<unsigned short>
{ typedef __true_type _Ret; };
template<> struct _IsIntegral<int>
{ typedef __true_type _Ret; };
template<> struct _IsIntegral<unsigned int>
{ typedef __true_type _Ret; };
template<> struct _IsIntegral<long>
{ typedef __true_type _Ret; };
template<> struct _IsIntegral<unsigned long>
{ typedef __true_type _Ret; };
template<> struct _IsIntegral<long long>
{ typedef __true_type _Ret; };
template<> struct _IsIntegral<unsigned long long>
{ typedef __true_type _Ret; };
template <class _Tp> struct _IsRational
{ typedef __false_type _Ret; };
template<> struct _IsRational<float>
{ typedef __true_type _Ret; };
template<> struct _IsRational<double>
{ typedef __true_type _Ret; };
template<> struct _IsRational<long double>
{ typedef __true_type _Ret; };
template <class _Tp> struct __type_traits;
template <class _IsPOD> struct __type_traits_aux {
   typedef __false_type has_trivial_default_constructor;
   typedef __false_type has_trivial_copy_constructor;
   typedef __false_type has_trivial_assignment_operator;
   typedef __false_type has_trivial_destructor;
   typedef __false_type is_POD_type;
};
template<>
struct __type_traits_aux<__false_type> {
   typedef __false_type has_trivial_default_constructor;
   typedef __false_type has_trivial_copy_constructor;
   typedef __false_type has_trivial_assignment_operator;
   typedef __false_type has_trivial_destructor;
   typedef __false_type is_POD_type;
};
template<>
struct __type_traits_aux<__true_type> {
  typedef __true_type has_trivial_default_constructor;
  typedef __true_type has_trivial_copy_constructor;
  typedef __true_type has_trivial_assignment_operator;
  typedef __true_type has_trivial_destructor;
  typedef __true_type is_POD_type;
};
template <class _Tp>
struct _IsRef {
  typedef __false_type _Ret;
};
template <class _Tp> struct _IsPtr {
  typedef __false_type _Ret;
};
template <class _Tp>
struct __type_traits {
   typedef __true_type this_dummy_member_must_be_first;
   typedef __false_type has_trivial_default_constructor;
   typedef __false_type has_trivial_copy_constructor;
   typedef __false_type has_trivial_assignment_operator;
   typedef __false_type has_trivial_destructor;
   typedef __false_type is_POD_type;
};
template <class _Tp> struct _IsPtr<_Tp*>
{ typedef __true_type _Ret; };
template <class _Tp> struct _IsRef<_Tp&>
{ typedef __true_type _Ret; };
template <class _Tp> struct __type_traits<_Tp*> : __type_traits_aux<__true_type>
{};
template<> struct __type_traits< bool > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const bool > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< volatile bool > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const volatile bool > : __type_traits_aux<__true_type> {};
template<> struct __type_traits< char > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const char > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< volatile char > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const volatile char > : __type_traits_aux<__true_type> {};
template<> struct __type_traits< signed char > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const signed char > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< volatile signed char > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const volatile signed char > : __type_traits_aux<__true_type> {};
template<> struct __type_traits< unsigned char > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const unsigned char > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< volatile unsigned char > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const volatile unsigned char > : __type_traits_aux<__true_type> {};
template<> struct __type_traits< wchar_t > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const wchar_t > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< volatile wchar_t > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const volatile wchar_t > : __type_traits_aux<__true_type> {};
template<> struct __type_traits< short > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const short > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< volatile short > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const volatile short > : __type_traits_aux<__true_type> {};
template<> struct __type_traits< unsigned short > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const unsigned short > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< volatile unsigned short > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const volatile unsigned short > : __type_traits_aux<__true_type> {};
template<> struct __type_traits< int > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const int > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< volatile int > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const volatile int > : __type_traits_aux<__true_type> {};
template<> struct __type_traits< unsigned int > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const unsigned int > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< volatile unsigned int > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const volatile unsigned int > : __type_traits_aux<__true_type> {};
template<> struct __type_traits< long > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const long > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< volatile long > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const volatile long > : __type_traits_aux<__true_type> {};
template<> struct __type_traits< unsigned long > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const unsigned long > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< volatile unsigned long > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const volatile unsigned long > : __type_traits_aux<__true_type> {};
template<> struct __type_traits< long long > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const long long > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< volatile long long > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const volatile long long > : __type_traits_aux<__true_type> {};
template<> struct __type_traits< unsigned long long > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const unsigned long long > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< volatile unsigned long long > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const volatile unsigned long long > : __type_traits_aux<__true_type> {};
template<> struct __type_traits< float > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const float > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< volatile float > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const volatile float > : __type_traits_aux<__true_type> {};
template<> struct __type_traits< double > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const double > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< volatile double > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const volatile double > : __type_traits_aux<__true_type> {};
template<> struct __type_traits< long double > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const long double > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< volatile long double > : __type_traits_aux<__true_type> {}; template<> struct __type_traits< const volatile long double > : __type_traits_aux<__true_type> {};
template <class _ArePtrs, class _Src, class _Dst>
struct _IsCVConvertibleIf
{ typedef typename _IsCVConvertible<_Src, _Dst>::_Ret _Ret; };
template <class _Src, class _Dst>
struct _IsCVConvertibleIf<__false_type, _Src, _Dst>
{ typedef __false_type _Ret; };
template <class _Src, class _Dst>
struct _TrivialNativeTypeCopy {
  typedef typename _IsPtr<_Src>::_Ret _Ptr1;
  typedef typename _IsPtr<_Dst>::_Ret _Ptr2;
  typedef typename _Land2<_Ptr1, _Ptr2>::_Ret _BothPtrs;
  typedef typename _IsCVConvertibleIf<_BothPtrs, _Src, _Dst>::_Ret _Convertible;
  typedef typename _Land2<_BothPtrs, _Convertible>::_Ret _Trivial1;
  typedef typename __bool2type<(sizeof(_Src) == sizeof(_Dst))>::_Ret _SameSize;
  typedef typename _IsIntegral<_Src>::_Ret _Int1;
  typedef typename _IsIntegral<_Dst>::_Ret _Int2;
  typedef typename _Land2<_Int1, _Int2>::_Ret _BothInts;
  typedef typename _IsRational<_Src>::_Ret _Rat1;
  typedef typename _IsRational<_Dst>::_Ret _Rat2;
  typedef typename _Land2<_Rat1, _Rat2>::_Ret _BothRats;
  typedef typename _Lor2<_BothInts, _BothRats>::_Ret _BothNatives;
  typedef typename _Land2<_BothNatives, _SameSize>::_Ret _Trivial2;
  typedef typename _Lor2<_Trivial1, _Trivial2>::_Ret _Ret;
};
template <class _Src, class _Dst>
struct _TrivialCopy {
  typedef typename _TrivialNativeTypeCopy<_Src, _Dst>::_Ret _NativeRet;
  typedef typename __type_traits<_Src>::has_trivial_assignment_operator _Tr1;
  typedef typename _AreCopyable<_Src, _Dst>::_Ret _Tr2;
  typedef typename _Land2<_Tr1, _Tr2>::_Ret _UserRet;
  typedef typename _Lor2<_NativeRet, _UserRet>::_Ret _Ret;
  static _Ret _Answer() { return _Ret(); }
};
template <class _Src, class _Dst>
struct _TrivialUCopy {
  typedef typename _TrivialNativeTypeCopy<_Src, _Dst>::_Ret _NativeRet;
  typedef typename __type_traits<_Src>::has_trivial_copy_constructor _Tr1;
  typedef typename _AreCopyable<_Src, _Dst>::_Ret _Tr2;
  typedef typename _Land2<_Tr1, _Tr2>::_Ret _UserRet;
  typedef typename _Lor2<_NativeRet, _UserRet>::_Ret _Ret;
  static _Ret _Answer() { return _Ret(); }
};
template <class _Tp>
struct _DefaultZeroValue {
  typedef typename _IsIntegral<_Tp>::_Ret _Tr1;
  typedef typename _IsRational<_Tp>::_Ret _Tr2;
  typedef typename _IsPtr<_Tp>::_Ret _Tr3;
  typedef typename _Lor3<_Tr1, _Tr2, _Tr3>::_Ret _Ret;
};
template <class _Tp>
struct _TrivialInit {
  typedef typename __type_traits<_Tp>::has_trivial_default_constructor _Tr1;
  typedef typename _DefaultZeroValue<_Tp>::_Ret _Tr2;
  typedef typename _Not<_Tr2>::_Ret _Tr3;
  typedef typename _Land2<_Tr1, _Tr3>::_Ret _Ret;
  static _Ret _Answer() { return _Ret(); }
};
template <class _Tp>
struct _IsPtrType {
  typedef typename _IsPtr<_Tp>::_Ret _Type;
  static _Type _Ret() { return _Type(); }
};
template <class _Tp>
struct _IsRefType {
  typedef typename _IsRef<_Tp>::_Ret _Type;
  static _Type _Ret() { return _Type();}
};
template <class _Tp>
struct __call_traits {
  typedef const _Tp& const_param_type;
  typedef _Tp& param_type;
};
template <class _Tp>
struct __call_traits<_Tp&> {
  typedef _Tp& param_type;
  typedef const _Tp& const_param_type;
};
template <class _Tp>
struct __call_traits<const _Tp&> {
  typedef _Tp& param_type;
  typedef const _Tp& const_param_type;
};
template <class _Tp1, class _Tp2>
struct _BothPtrType {
  typedef typename _IsPtr<_Tp1>::_Ret _IsPtr1;
  typedef typename _IsPtr<_Tp2>::_Ret _IsPtr2;
  typedef typename _Land2<_IsPtr1, _IsPtr2>::_Ret _Ret;
  static _Ret _Answer() { return _Ret(); }
};
template <class _Tp1, class _Tp2, class _IsRef1, class _IsRef2>
struct _OKToSwap {
  typedef typename _AreSameTypes<_Tp1, _Tp2>::_Ret _Same;
  typedef typename _Land3<_Same, _IsRef1, _IsRef2>::_Ret _Type;
  static _Type _Answer() { return _Type(); }
};
template <class _Tp1, class _Tp2, class _IsRef1, class _IsRef2>
inline _OKToSwap<_Tp1, _Tp2, _IsRef1, _IsRef2>
_IsOKToSwap(_Tp1*, _Tp2*, const _IsRef1&, const _IsRef2&)
{ return _OKToSwap<_Tp1, _Tp2, _IsRef1, _IsRef2>(); }
template <class _Src, class _Dst>
inline _TrivialCopy<_Src, _Dst> _UseTrivialCopy(_Src*, _Dst*)
{ return _TrivialCopy<_Src, _Dst>(); }
template <class _Src, class _Dst>
inline _TrivialUCopy<_Src, _Dst> _UseTrivialUCopy(_Src*, _Dst*)
{ return _TrivialUCopy<_Src, _Dst>(); }
struct _NegativeAnswer {
  typedef __false_type _Ret;
  static _Ret _Answer() { return _Ret(); }
};
template <class _Src, class _Dst>
inline _NegativeAnswer _UseTrivialCopy(_Src*, const _Dst*)
{ return _NegativeAnswer(); }
template <class _Src, class _Dst>
inline _NegativeAnswer _UseTrivialCopy(_Src*, volatile _Dst*)
{ return _NegativeAnswer(); }
template <class _Src, class _Dst>
inline _NegativeAnswer _UseTrivialCopy(_Src*, const volatile _Dst*)
{ return _NegativeAnswer(); }
template <class _Src, class _Dst>
inline _NegativeAnswer _UseTrivialUCopy(_Src*, const _Dst*)
{ return _NegativeAnswer(); }
template <class _Src, class _Dst>
inline _NegativeAnswer _UseTrivialUCopy(_Src*, volatile _Dst*)
{ return _NegativeAnswer(); }
template <class _Src, class _Dst>
inline _NegativeAnswer _UseTrivialUCopy(_Src*, const volatile _Dst*)
{ return _NegativeAnswer(); }
template <class _Tp>
inline _TrivialInit<_Tp> _UseTrivialInit(_Tp*)
{ return _TrivialInit<_Tp>(); }
template <class _Tp>
struct _IsPOD {
  typedef typename __type_traits<_Tp>::is_POD_type _Type;
  static _Type _Answer() { return _Type(); }
};
template <class _Tp>
inline _IsPOD<_Tp> _Is_POD(_Tp*)
{ return _IsPOD<_Tp>(); }
template <class _Tp>
struct _DefaultZeroValueQuestion {
  typedef typename _DefaultZeroValue<_Tp>::_Ret _Ret;
  static _Ret _Answer() { return _Ret(); }
};
template <class _Tp>
inline _DefaultZeroValueQuestion<_Tp> _HasDefaultZeroValue(_Tp*)
{ return _DefaultZeroValueQuestion<_Tp>(); }
template <class _Tp>
struct __stlport_class
{ typedef _Tp _Type; };
template <class _Tp>
struct _IsSTLportClass {
  typedef typename _IsConvertible<_Tp, __stlport_class<_Tp> >::_Ret _Ret;
};
template <class _Tp>
class _TpWithState : private _Tp {
  _TpWithState();
  int _state;
};
template <class _Tp>
struct _IsStateless {
  enum { _Is = sizeof(_TpWithState<_Tp>) == sizeof(int) };
  typedef typename __bool2type<_Is>::_Ret _Ret;
};
}
namespace stlp_std {
template <class _Tp>
class __move_source {
public:
  explicit __move_source (_Tp &_src) : _M_data(_src)
  {}
  _Tp& get() const
  { return _M_data; }
private:
  _Tp &_M_data;
  typedef __move_source<_Tp> _Self;
  _Self& operator = (_Self const&);
};
template <class _Tp>
struct __move_traits {
  typedef __false_type implemented;
  typedef typename __type_traits<_Tp>::has_trivial_destructor complete;
};
namespace priv {
template <class _Tp>
struct _MoveSourceTraits {
  typedef typename __move_traits<_Tp>::implemented _MvImpRet;
  enum {_MvImp = __type2bool<_MvImpRet>::_Ret};
  typedef typename __select<_MvImp,
                            __move_source<_Tp>,
                            _Tp const&>::_Ret _Type;
};
template <class _Tp>
inline typename _MoveSourceTraits<_Tp>::_Type
_AsMoveSource (_Tp &src) {
  typedef typename _MoveSourceTraits<_Tp>::_Type _SrcType;
  return _SrcType(src);
}
template <class _Tp>
struct __move_traits_aux {
  typedef typename __move_traits<_Tp>::implemented implemented;
  typedef typename __move_traits<_Tp>::complete complete;
};
template <class _Tp1, class _Tp2>
struct __move_traits_aux2 {
  typedef __move_traits<_Tp1> _MoveTraits1;
  typedef __move_traits<_Tp2> _MoveTraits2;
  typedef typename _Lor2<typename _MoveTraits1::implemented,
                         typename _MoveTraits2::implemented>::_Ret implemented;
  typedef typename _Land2<typename _MoveTraits1::complete,
                          typename _MoveTraits2::complete>::_Ret complete;
};
template <class _Tp>
struct __move_traits_help {
  typedef __true_type implemented;
  typedef typename __move_traits<_Tp>::complete complete;
};
template <class _Tp1, class _Tp2>
struct __move_traits_help1 {
  typedef __move_traits<_Tp1> _MoveTraits1;
  typedef __move_traits<_Tp2> _MoveTraits2;
  typedef typename _Lor2<typename _MoveTraits1::implemented,
                         typename _MoveTraits2::implemented>::_Ret implemented;
  typedef typename _Land2<typename _MoveTraits1::complete,
                          typename _MoveTraits2::complete>::_Ret complete;
};
template <class _Tp1, class _Tp2>
struct __move_traits_help2 {
  typedef __move_traits<_Tp1> _MoveTraits1;
  typedef __move_traits<_Tp2> _MoveTraits2;
  typedef __true_type implemented;
  typedef typename _Land2<typename _MoveTraits1::complete,
                          typename _MoveTraits2::complete>::_Ret complete;
};
}
}
namespace stlp_std {
template <class _T1, class _T2>
struct pair {
  typedef _T1 first_type;
  typedef _T2 second_type;
  _T1 first;
  _T2 second;
  pair() : first(_T1()), second(_T2()) {}
  pair(const _T1& __a, const _T2& __b) : first(__a), second(__b) {}
  template <class _U1, class _U2>
  pair(const pair<_U1, _U2>& __p) : first(__p.first), second(__p.second) {}
  pair(const pair<_T1,_T2>& __o) : first(__o.first), second(__o.second) {}
  pair(__move_source<pair<_T1, _T2> > src) : first(::stlp_std::priv:: _AsMoveSource(src.get().first)),
                                             second(::stlp_std::priv:: _AsMoveSource(src.get().second))
  {}
 
};
template <class _T1, class _T2>
inline bool operator==(const pair<_T1, _T2>& __x, const pair<_T1, _T2>& __y)
{ return __x.first == __y.first && __x.second == __y.second; }
template <class _T1, class _T2>
inline bool operator<(const pair<_T1, _T2>& __x, const pair<_T1, _T2>& __y) {
  return __x.first < __y.first ||
         (!(__y.first < __x.first) && __x.second < __y.second);
}
template <class _T1, class _T2>
inline bool operator!=(const pair<_T1, _T2>& __x, const pair<_T1, _T2>& __y)
{ return !(__x == __y); }
template <class _T1, class _T2>
inline bool operator>(const pair<_T1, _T2>& __x, const pair<_T1, _T2>& __y)
{ return __y < __x; }
template <class _T1, class _T2>
inline bool operator<=(const pair<_T1, _T2>& __x, const pair<_T1, _T2>& __y)
{ return !(__y < __x); }
template <class _T1, class _T2>
inline bool operator>=(const pair<_T1, _T2>& __x, const pair<_T1, _T2>& __y)
{ return !(__x < __y); }
template <class _T1, class _T2, int _Sz>
inline pair<_T1, _T2 const*> make_pair(_T1 const& __x,
                                       _T2 const (&__y)[_Sz])
{ return pair<_T1, _T2 const*>(__x, static_cast<_T2 const*>(__y)); }
template <class _T1, class _T2, int _Sz>
inline pair<_T1 const*, _T2> make_pair(_T1 const (&__x)[_Sz],
                                       _T2 const& __y)
{ return pair<_T1 const*, _T2>(static_cast<_T1 const*>(__x), __y); }
template <class _T1, class _T2, int _Sz1, int _Sz2>
inline pair<_T1 const*, _T2 const*> make_pair(_T1 const (&__x)[_Sz1],
                                              _T2 const (&__y)[_Sz2]) {
  return pair<_T1 const*, _T2 const*>(static_cast<_T1 const*>(__x),
                                      static_cast<_T2 const*>(__y));
}
template <class _T1, class _T2>
inline pair<_T1, _T2> make_pair(_T1 __x, _T2 __y)
{ return pair<_T1, _T2>(__x, __y); }
}
namespace stlp_std { namespace rel_ops {
template <class _Tp>
inline bool operator!=(const _Tp& __x, const _Tp& __y)
{ return !(__x == __y); }
template <class _Tp>
inline bool operator>(const _Tp& __x, const _Tp& __y)
{ return __y < __x; }
template <class _Tp>
inline bool operator<=(const _Tp& __x, const _Tp& __y)
{ return !(__y < __x); }
template <class _Tp>
inline bool operator>=(const _Tp& __x, const _Tp& __y)
{ return !(__x < __y); }
} }
namespace stlp_std {
template <class _T1, class _T2>
struct __type_traits<pair<_T1, _T2> > {
  typedef __type_traits<_T1> _T1Traits;
  typedef __type_traits<_T2> _T2Traits;
  typedef typename _Land2<typename _T1Traits::has_trivial_default_constructor,
                          typename _T2Traits::has_trivial_default_constructor>::_Ret has_trivial_default_constructor;
  typedef typename _Land2<typename _T1Traits::has_trivial_copy_constructor,
                          typename _T2Traits::has_trivial_copy_constructor>::_Ret has_trivial_copy_constructor;
  typedef typename _Land2<typename _T1Traits::has_trivial_assignment_operator,
                          typename _T2Traits::has_trivial_assignment_operator>::_Ret has_trivial_assignment_operator;
  typedef typename _Land2<typename _T1Traits::has_trivial_destructor,
                          typename _T2Traits::has_trivial_destructor>::_Ret has_trivial_destructor;
  typedef __false_type is_POD_type;
};
template <class _T1, class _T2>
struct __move_traits<pair<_T1, _T2> >
  : ::stlp_std::priv:: __move_traits_help1<_T1, _T2> {};
}
namespace stlp_std {
struct input_iterator_tag {};
struct output_iterator_tag {};
struct forward_iterator_tag : public input_iterator_tag {};
struct bidirectional_iterator_tag : public forward_iterator_tag {};
struct random_access_iterator_tag : public bidirectional_iterator_tag {};
template <class _Category, class _Tp, class _Distance = ptrdiff_t,
          class _Pointer = _Tp*, class _Reference = _Tp& >
struct iterator {
  typedef _Category iterator_category;
  typedef _Tp value_type;
  typedef _Distance difference_type;
  typedef _Pointer pointer;
  typedef _Reference reference;
};
template<>
struct iterator<output_iterator_tag, void, void, void, void> {
  typedef output_iterator_tag iterator_category;
  typedef void value_type;
  typedef void difference_type;
  typedef void pointer;
  typedef void reference;
};
template <class _Iterator>
struct iterator_traits {
  typedef typename _Iterator::iterator_category iterator_category;
  typedef typename _Iterator::value_type value_type;
  typedef typename _Iterator::difference_type difference_type;
  typedef typename _Iterator::pointer pointer;
  typedef typename _Iterator::reference reference;
};
template <class _Tp>
struct iterator_traits<const _Tp*> {
  typedef random_access_iterator_tag iterator_category;
  typedef _Tp value_type;
  typedef ptrdiff_t difference_type;
  typedef const _Tp* pointer;
  typedef const _Tp& reference;
};
template <class _Tp>
struct iterator_traits<_Tp*> {
  typedef random_access_iterator_tag iterator_category;
  typedef _Tp value_type;
  typedef ptrdiff_t difference_type;
  typedef _Tp* pointer;
  typedef _Tp& reference;
};
}
namespace stlp_std {
template <class _Tp, class _Distance> struct input_iterator :
  public iterator <input_iterator_tag, _Tp, _Distance, _Tp*, _Tp&> {};
struct output_iterator : public iterator <output_iterator_tag, void, void, void, void> {};
template <class _Tp, class _Distance> struct forward_iterator :
  public iterator<forward_iterator_tag, _Tp, _Distance, _Tp*, _Tp&> {};
template <class _Tp, class _Distance> struct bidirectional_iterator :
  public iterator<bidirectional_iterator_tag, _Tp, _Distance, _Tp*, _Tp&> {};
template <class _Tp, class _Distance> struct random_access_iterator :
  public iterator<random_access_iterator_tag, _Tp, _Distance, _Tp*, _Tp&> {};
namespace priv {
template <class _InputIterator>
inline typename iterator_traits<_InputIterator>::difference_type
__distance(const _InputIterator& __first, const _InputIterator& __last,
           const input_iterator_tag &) {
  typename iterator_traits<_InputIterator>::difference_type __n = 0;
  _InputIterator __it(__first);
  while (__it != __last) {
    ++__it; ++__n;
  }
  return __n;
}
template <class _RandomAccessIterator>
inline typename iterator_traits<_RandomAccessIterator>::difference_type
__distance(const _RandomAccessIterator& __first, const _RandomAccessIterator& __last,
           const random_access_iterator_tag &)
{ return __last - __first; }
}
template <class _InputIterator>
inline typename iterator_traits<_InputIterator>::difference_type
distance(_InputIterator __first, _InputIterator __last)
{ return ::stlp_std::priv:: __distance(__first, __last, typename ::stlp_std::iterator_traits< _InputIterator >::iterator_category()); }
template <class _InputIterator, class _Distance>
inline void distance(const _InputIterator& __first,
                                const _InputIterator& __last, _Distance& __n)
{ __n += ::stlp_std::distance(__first, __last); }
template <class _Tp>
struct _Nonconst_traits;
template <class _Tp>
struct _Const_traits {
  typedef _Tp value_type;
  typedef const _Tp& reference;
  typedef const _Tp* pointer;
  typedef _Const_traits<_Tp> _ConstTraits;
  typedef _Nonconst_traits<_Tp> _NonConstTraits;
};
template <class _Tp>
struct _Nonconst_traits {
  typedef _Tp value_type;
  typedef _Tp& reference;
  typedef _Tp* pointer;
  typedef _Const_traits<_Tp> _ConstTraits;
  typedef _Nonconst_traits<_Tp> _NonConstTraits;
};
template <class _Tp>
struct _Nonconst_Const_traits;
template <class _Tp>
struct _Const_Const_traits {
  typedef _Tp value_type;
  typedef const _Tp& reference;
  typedef const _Tp* pointer;
  typedef _Const_Const_traits<_Tp> _ConstTraits;
  typedef _Nonconst_Const_traits<_Tp> _NonConstTraits;
};
template <class _Tp>
struct _Nonconst_Const_traits {
  typedef _Tp value_type;
  typedef const _Tp& reference;
  typedef const _Tp* pointer;
  typedef _Const_Const_traits<_Tp> _ConstTraits;
  typedef _Nonconst_Const_traits<_Tp> _NonConstTraits;
};
namespace priv {
template <class _InputIter, class _Distance>
inline void
__advance(_InputIter& __i, _Distance __n, const input_iterator_tag &)
{ while (__n--) ++__i; }
template <class _InputIter, class _Distance>
inline void
__advance(_InputIter& __i, _Distance __n, const output_iterator_tag &)
{ while (__n--) ++__i; }
template <class _BidirectionalIterator, class _Distance>
inline void
__advance(_BidirectionalIterator& __i, _Distance __n,
          const bidirectional_iterator_tag &) {
  if (__n > 0)
    while (__n--) ++__i;
  else
    while (__n++) --__i;
}
template <class _RandomAccessIterator, class _Distance>
inline void
__advance(_RandomAccessIterator& __i, _Distance __n,
          const random_access_iterator_tag &)
{ __i += __n; }
}
template <class _InputIterator, class _Distance>
inline void advance(_InputIterator& __i, _Distance __n)
{ ::stlp_std::priv:: __advance(__i, __n, typename ::stlp_std::iterator_traits< _InputIterator >::iterator_category()); }
}
namespace stlp_std {
template <class _Tp>
inline void swap(_Tp& __a, _Tp& __b) {
  _Tp __tmp = __a;
  __a = __b;
  __b = __tmp;
}
namespace priv {
template <class _ForwardIter1, class _ForwardIter2, class _Value>
inline void __iter_swap_aux_aux(_ForwardIter1& __i1, _ForwardIter2& __i2, _Value *) {
  _Value tmp = *__i1;
  *__i1 = *__i2;
  *__i2 = tmp;
}
template <class _ForwardIter1, class _ForwardIter2>
inline void __iter_swap_aux(_ForwardIter1& __i1, _ForwardIter2& __i2, const __true_type& ) {
                  swap(*__i1, *__i2);
}
template <class _ForwardIter1, class _ForwardIter2>
inline void __iter_swap_aux(_ForwardIter1& __i1, _ForwardIter2& __i2, const __false_type& ) {
  ::stlp_std::priv:: __iter_swap_aux_aux( __i1, __i2, (typename ::stlp_std::iterator_traits< _ForwardIter1 >::value_type*)0 );
}
}
template <class _ForwardIter1, class _ForwardIter2>
inline void iter_swap(_ForwardIter1 __i1, _ForwardIter2 __i2) {
  ::stlp_std::priv:: __iter_swap_aux( __i1, __i2, _IsOKToSwap((typename ::stlp_std::iterator_traits< _ForwardIter1 >::value_type*)0, (typename ::stlp_std::iterator_traits< _ForwardIter2 >::value_type*)0,
                                                      ::stlp_std::_IsRefType< typename ::stlp_std::iterator_traits< _ForwardIter1 >::reference >::_Ret(),
                                                      ::stlp_std::_IsRefType< typename ::stlp_std::iterator_traits< _ForwardIter2 >::reference >::_Ret())._Answer());
}
template <class _Tp>
inline const _Tp& (min)(const _Tp& __a, const _Tp& __b) { return __b < __a ? __b : __a; }
template <class _Tp>
inline const _Tp& (max)(const _Tp& __a, const _Tp& __b) { return __a < __b ? __b : __a; }
template <class _Tp, class _Compare>
inline const _Tp& (min)(const _Tp& __a, const _Tp& __b, _Compare __comp) {
  return __comp(__b, __a) ? __b : __a;
}
template <class _Tp, class _Compare>
inline const _Tp& (max)(const _Tp& __a, const _Tp& __b, _Compare __comp) {
  return __comp(__a, __b) ? __b : __a;
}
namespace priv {
template <class _InputIter, class _OutputIter, class _Distance>
inline _OutputIter __copy(_InputIter __first, _InputIter __last,
                          _OutputIter __result, const input_iterator_tag &, _Distance*) {
  for ( ; __first != __last; ++__result, ++__first)
    *__result = *__first;
  return __result;
}
template <class _RandomAccessIter, class _OutputIter, class _Distance>
inline _OutputIter
__copy(_RandomAccessIter __first, _RandomAccessIter __last,
       _OutputIter __result, const random_access_iterator_tag &, _Distance*) {
  for (_Distance __n = __last - __first; __n > 0; --__n) {
    *__result = *__first;
    ++__first;
    ++__result;
  }
  return __result;
}
inline void*
__copy_trivial(const void* __first, const void* __last, void* __result) {
  size_t __n = (const char*)__last - (const char*)__first;
  return __n ? (void *)((char*)memmove(__result, __first, __n) + __n) : __result;
}
template <class _BidirectionalIter1, class _BidirectionalIter2,
          class _Distance>
inline _BidirectionalIter2 __copy_backward(_BidirectionalIter1 __first,
                                           _BidirectionalIter1 __last,
                                           _BidirectionalIter2 __result,
                                           const bidirectional_iterator_tag &,
                                           _Distance*) {
  while (__first != __last)
    *--__result = *--__last;
  return __result;
}
template <class _RandomAccessIter, class _BidirectionalIter, class _Distance>
inline _BidirectionalIter __copy_backward(_RandomAccessIter __first,
                                          _RandomAccessIter __last,
                                          _BidirectionalIter __result,
                                          const random_access_iterator_tag &,
                                          _Distance*) {
  for (_Distance __n = __last - __first; __n > 0; --__n)
    *--__result = *--__last;
  return __result;
}
inline void*
__copy_trivial_backward(const void* __first, const void* __last, void* __result) {
  const ptrdiff_t _Num = (const char*)__last - (const char*)__first;
  return (_Num > 0) ? memmove((char*)__result - _Num, __first, _Num) : __result ;
}
template <class _InputIter, class _OutputIter>
inline _OutputIter __copy_ptrs(_InputIter __first, _InputIter __last, _OutputIter __result,
                               const __false_type& ) {
  return ::stlp_std::priv:: __copy(__first, __last, __result, random_access_iterator_tag(), (ptrdiff_t*)0);
}
template <class _InputIter, class _OutputIter>
inline _OutputIter __copy_ptrs(_InputIter __first, _InputIter __last, _OutputIter __result,
                               const __true_type& ) {
  return (_OutputIter)::stlp_std::priv:: __copy_trivial(__first, __last, __result);
}
template <class _InputIter, class _OutputIter>
inline _OutputIter __copy_aux(_InputIter __first, _InputIter __last, _OutputIter __result,
                              const __true_type& ) {
  return ::stlp_std::priv:: __copy_ptrs(__first, __last, __result,
                                _UseTrivialCopy((typename ::stlp_std::iterator_traits< _InputIter >::value_type*)0,
                                                (typename ::stlp_std::iterator_traits< _OutputIter >::value_type*)0)._Answer());
}
template <class _InputIter, class _OutputIter>
inline _OutputIter __copy_aux(_InputIter __first, _InputIter __last, _OutputIter __result,
                              const __false_type& ) {
  return ::stlp_std::priv:: __copy(__first, __last, __result,
                           typename ::stlp_std::iterator_traits< _InputIter >::iterator_category(),
                           (typename ::stlp_std::iterator_traits< _InputIter >::difference_type*)0);
}
}
template <class _InputIter, class _OutputIter>
inline _OutputIter copy(_InputIter __first, _InputIter __last, _OutputIter __result) {
 
  return ::stlp_std::priv:: __copy_aux(__first, __last, __result, _BothPtrType< _InputIter, _OutputIter>::_Answer());
}
namespace priv {
template <class _InputIter, class _OutputIter>
inline _OutputIter __copy_backward_ptrs(_InputIter __first, _InputIter __last,
                                        _OutputIter __result, const __false_type& ) {
  return ::stlp_std::priv:: __copy_backward(__first, __last, __result,
                                    typename ::stlp_std::iterator_traits< _InputIter >::iterator_category(),
                                    (typename ::stlp_std::iterator_traits< _InputIter >::difference_type*)0);
}
template <class _InputIter, class _OutputIter>
inline _OutputIter __copy_backward_ptrs(_InputIter __first, _InputIter __last,
                                        _OutputIter __result, const __true_type& ) {
  return (_OutputIter)::stlp_std::priv:: __copy_trivial_backward(__first, __last, __result);
}
template <class _InputIter, class _OutputIter>
inline _OutputIter __copy_backward_aux(_InputIter __first, _InputIter __last, _OutputIter __result, const __false_type&) {
  return ::stlp_std::priv:: __copy_backward(__first, __last, __result,
                                    typename ::stlp_std::iterator_traits< _InputIter >::iterator_category(),
                                    (typename ::stlp_std::iterator_traits< _InputIter >::difference_type*)0);
}
template <class _InputIter, class _OutputIter>
inline _OutputIter __copy_backward_aux(_InputIter __first, _InputIter __last, _OutputIter __result, const __true_type&) {
  return ::stlp_std::priv:: __copy_backward_ptrs(__first, __last, __result,
                                         _UseTrivialCopy((typename ::stlp_std::iterator_traits< _InputIter >::value_type*)0,
                                                         (typename ::stlp_std::iterator_traits< _OutputIter >::value_type*)0)._Answer());
}
}
template <class _InputIter, class _OutputIter>
inline _OutputIter copy_backward(_InputIter __first, _InputIter __last, _OutputIter __result) {
 
  return ::stlp_std::priv:: __copy_backward_aux(__first, __last, __result, _BothPtrType< _InputIter, _OutputIter>::_Answer() );
}
namespace priv {
template <class _InputIter, class _Size, class _OutputIter>
inline ::stlp_std::pair<_InputIter, _OutputIter>
__copy_n(_InputIter __first, _Size __count, _OutputIter __result,
         const input_iterator_tag &) {
  for ( ; __count > 0; --__count) {
    *__result = *__first;
    ++__first;
    ++__result;
  }
  return ::stlp_std::pair<_InputIter, _OutputIter>(__first, __result);
}
template <class _RAIter, class _Size, class _OutputIter>
inline ::stlp_std::pair<_RAIter, _OutputIter>
__copy_n(_RAIter __first, _Size __count, _OutputIter __result,
         const random_access_iterator_tag &) {
  _RAIter __last = __first + __count;
  return ::stlp_std::pair<_RAIter, _OutputIter>(__last, ::stlp_std::copy(__first, __last, __result));
}
}
template <class _InputIter, class _Size, class _OutputIter>
inline pair<_InputIter, _OutputIter>
copy_n(_InputIter __first, _Size __count, _OutputIter __result) {
 
  return ::stlp_std::priv:: __copy_n(__first, __count, __result, typename ::stlp_std::iterator_traits< _InputIter >::iterator_category());
}
namespace priv {
template <class _ForwardIter, class _Tp>
inline
void __fill_fwd(_ForwardIter __first, _ForwardIter __last, const _Tp& __val) {
  for ( ; __first != __last; ++__first)
    *__first = __val;
}
template <class _ForwardIter, class _Tp, class _Distance>
inline void __fill(_ForwardIter __first, _ForwardIter __last, const _Tp& __val,
                   const input_iterator_tag &, _Distance*) {
  ::stlp_std::priv:: __fill_fwd(__first, __last, __val);
}
template <class _RandomAccessIter, class _Tp, class _Distance>
inline
void __fill(_RandomAccessIter __first, _RandomAccessIter __last, const _Tp& __val,
            const random_access_iterator_tag &, _Distance*) {
  for (_Distance __n = __last - __first ; __n > 0; ++__first, --__n)
    *__first = __val;
}
}
template <class _ForwardIter, class _Tp>
inline void fill(_ForwardIter __first, _ForwardIter __last, const _Tp& __val) {
 
  ::stlp_std::priv:: __fill(__first, __last, __val,
                    typename ::stlp_std::iterator_traits< _ForwardIter >::iterator_category(),
                    (typename ::stlp_std::iterator_traits< _ForwardIter >::difference_type*)0);
}
inline void fill(unsigned char* __first, unsigned char* __last,
                 const unsigned char& __val) {
  unsigned char __tmp = __val;
  memset(__first, __tmp, __last - __first);
}
inline void fill(signed char* __first, signed char* __last,
                 const signed char& __val) {
  signed char __tmp = __val;
  memset(__first, static_cast<unsigned char>(__tmp), __last - __first);
}
inline void fill(char* __first, char* __last, const char& __val) {
  char __tmp = __val;
  memset(__first, static_cast<unsigned char>(__tmp), __last - __first);
}
namespace priv {
template <class _OutputIter, class _Size, class _Tp>
inline
_OutputIter __fill_n(_OutputIter __first, _Size __n, const _Tp& __val) {
 
  for ( ; __n > 0; --__n, ++__first)
    *__first = __val;
  return __first;
}
template <class _Size>
inline unsigned char* __fill_n(unsigned char* __first, _Size __n,
                               const unsigned char& __val) {
  ::stlp_std::fill(__first, __first + __n, __val);
  return __first + __n;
}
template <class _Size>
inline signed char* __fill_n(signed char* __first, _Size __n,
                             const signed char& __val) {
  ::stlp_std::fill(__first, __first + __n, __val);
  return __first + __n;
}
template <class _Size>
inline char* __fill_n(char* __first, _Size __n,
                      const char& __val) {
  ::stlp_std::fill(__first, __first + __n, __val);
  return __first + __n;
}
}
template <class _OutputIter, class _Size, class _Tp>
inline void fill_n(_OutputIter __first, _Size __n, const _Tp& __val) {
 
  ::stlp_std::priv:: __fill_n(__first, __n, __val);
}
template <class _InputIter1, class _InputIter2>
inline
::stlp_std::pair<_InputIter1, _InputIter2> mismatch(_InputIter1 __first1,
                                                   _InputIter1 __last1,
                                                   _InputIter2 __first2) {
 
 
  while (__first1 != __last1 && *__first1 == *__first2) {
    ++__first1;
    ++__first2;
  }
  return ::stlp_std::pair<_InputIter1, _InputIter2>(__first1, __first2);
}
template <class _InputIter1, class _InputIter2, class _BinaryPredicate>
inline
::stlp_std::pair<_InputIter1, _InputIter2> mismatch(_InputIter1 __first1,
                                                   _InputIter1 __last1,
                                                   _InputIter2 __first2,
                                                   _BinaryPredicate __binary_pred) {
 
 
  while (__first1 != __last1 && __binary_pred(*__first1, *__first2)) {
    ++__first1;
    ++__first2;
  }
  return ::stlp_std::pair<_InputIter1, _InputIter2>(__first1, __first2);
}
template <class _InputIter1, class _InputIter2>
inline
bool equal(_InputIter1 __first1, _InputIter1 __last1,
           _InputIter2 __first2) {
 
 
  for ( ; __first1 != __last1; ++__first1, ++__first2)
    if (!(*__first1 == *__first2))
      return false;
  return true;
}
template <class _InputIter1, class _InputIter2, class _BinaryPredicate>
inline
bool equal(_InputIter1 __first1, _InputIter1 __last1,
           _InputIter2 __first2, _BinaryPredicate __binary_pred) {
 
 
  for ( ; __first1 != __last1; ++__first1, ++__first2)
    if (!__binary_pred(*__first1, *__first2))
      return false;
  return true;
}
template <class _InputIter1, class _InputIter2>
bool lexicographical_compare(_InputIter1 __first1, _InputIter1 __last1,
                             _InputIter2 __first2, _InputIter2 __last2);
template <class _InputIter1, class _InputIter2, class _Compare>
bool lexicographical_compare(_InputIter1 __first1, _InputIter1 __last1,
                             _InputIter2 __first2, _InputIter2 __last2,
                             _Compare __comp);
inline bool
lexicographical_compare(const unsigned char* __first1,
                        const unsigned char* __last1,
                        const unsigned char* __first2,
                        const unsigned char* __last2) {
  const size_t __len1 = __last1 - __first1;
  const size_t __len2 = __last2 - __first2;
 
 
  const int __result = memcmp(__first1, __first2, (min) (__len1, __len2));
  return __result != 0 ? (__result < 0) : (__len1 < __len2);
}
namespace priv {
template <class _InputIter1, class _InputIter2>
int __lexicographical_compare_3way(_InputIter1 __first1, _InputIter1 __last1,
                                   _InputIter2 __first2, _InputIter2 __last2);
inline int
__lexicographical_compare_3way(const unsigned char* __first1,
                               const unsigned char* __last1,
                               const unsigned char* __first2,
                               const unsigned char* __last2) {
  const ptrdiff_t __len1 = __last1 - __first1;
  const ptrdiff_t __len2 = __last2 - __first2;
  const int __result = memcmp(__first1, __first2, (min) (__len1, __len2));
  return __result != 0 ? __result
                       : (__len1 == __len2 ? 0 : (__len1 < __len2 ? -1 : 1));
}
}
template <class _InputIter1, class _InputIter2>
int lexicographical_compare_3way(_InputIter1 __first1, _InputIter1 __last1,
                                 _InputIter2 __first2, _InputIter2 __last2);
template <class _InputIter, class _Tp>
inline typename iterator_traits<_InputIter>::difference_type
count(_InputIter __first, _InputIter __last, const _Tp& __val) {
 
  typename iterator_traits<_InputIter>::difference_type __n = 0;
  for ( ; __first != __last; ++__first)
    if (*__first == __val)
      ++__n;
  return __n;
}
template <class _InputIter, class _Tp>
_InputIter find(_InputIter __first, _InputIter __last, const _Tp& __val);
template <class _InputIter, class _Predicate>
_InputIter find_if(_InputIter __first, _InputIter __last, _Predicate __pred);
template <class _ForwardIter1, class _ForwardIter2, class _BinaryPred>
_ForwardIter1 search(_ForwardIter1 __first1, _ForwardIter1 __last1,
                     _ForwardIter2 __first2, _ForwardIter2 __last2, _BinaryPred __predicate);
namespace priv {
template <class _InputIter, class _ForwardIter>
_InputIter __find_first_of(_InputIter __first1, _InputIter __last1,
                           _ForwardIter __first2, _ForwardIter __last2);
template <class _InputIter, class _ForwardIter, class _BinaryPredicate>
_InputIter __find_first_of(_InputIter __first1, _InputIter __last1,
                           _ForwardIter __first2, _ForwardIter __last2,
                           _BinaryPredicate __comp);
}
template <class _ForwardIter1, class _ForwardIter2,
          class _BinaryPredicate>
_ForwardIter1
find_end(_ForwardIter1 __first1, _ForwardIter1 __last1,
         _ForwardIter2 __first2, _ForwardIter2 __last2,
         _BinaryPredicate __comp);
template <class _ForwardIter, class _Tp>
inline void
replace(_ForwardIter __first, _ForwardIter __last,
        const _Tp& __old_value, const _Tp& __new_value) {
 
  for ( ; __first != __last; ++__first)
    if (*__first == __old_value)
      *__first = __new_value;
}
namespace priv {
template <class _ForwardIter, class _Tp, class _Compare1, class _Compare2, class _Distance>
_ForwardIter __lower_bound(_ForwardIter __first, _ForwardIter __last,
                           const _Tp& __val, _Compare1 __comp1, _Compare2 __comp2, _Distance*);
}
}
namespace stlp_std {
template <class _Arg, class _Result>
struct unary_function {
  typedef _Arg argument_type;
  typedef _Result result_type;
protected:
  ~unary_function() {}
};
template <class _Arg1, class _Arg2, class _Result>
struct binary_function {
  typedef _Arg1 first_argument_type;
  typedef _Arg2 second_argument_type;
  typedef _Result result_type;
protected:
  ~binary_function() {}
};
template <class _Tp>
struct equal_to : public binary_function<_Tp, _Tp, bool> {
  bool operator()(const _Tp& __x, const _Tp& __y) const { return __x == __y; }
};
template <class _Tp>
struct less : public binary_function<_Tp,_Tp,bool>
              , public __stlport_class<less<_Tp> >
{
  bool operator()(const _Tp& __x, const _Tp& __y) const { return __x < __y; }
};
template <class _Tp>
struct __type_traits<less<_Tp> > {
  typedef typename _IsSTLportClass<less<_Tp> >::_Ret _STLportLess;
  typedef _STLportLess has_trivial_default_constructor;
  typedef _STLportLess has_trivial_copy_constructor;
  typedef _STLportLess has_trivial_assignment_operator;
  typedef _STLportLess has_trivial_destructor;
  typedef _STLportLess is_POD_type;
};
namespace priv {
template <class _Tp>
less<_Tp> __less(_Tp* ) { return less<_Tp>(); }
template <class _Tp>
equal_to<_Tp> __equal_to(_Tp* ) { return equal_to<_Tp>(); }
}
template <class _Tp>
struct plus : public binary_function<_Tp, _Tp, _Tp> {
  _Tp operator()(const _Tp& __x, const _Tp& __y) const { return __x + __y; }
};
template <class _Tp>
struct minus : public binary_function<_Tp, _Tp, _Tp> {
  _Tp operator()(const _Tp& __x, const _Tp& __y) const { return __x - __y; }
};
namespace priv {
template <class _Tp>
plus<_Tp> __plus(_Tp* ) { return plus<_Tp>(); }
template <class _Tp>
minus<_Tp> __minus(_Tp* ) { return minus<_Tp>(); }
}
template <class _Tp>
struct multiplies : public binary_function<_Tp, _Tp, _Tp> {
  _Tp operator()(const _Tp& __x, const _Tp& __y) const { return __x * __y; }
};
namespace priv {
template <class _Pair>
struct _Select1st : public unary_function<_Pair, typename _Pair::first_type> {
  const typename _Pair::first_type& operator()(const _Pair& __x) const {
    return __x.first;
  }
};
template <class _Pair>
struct _Select2nd : public unary_function<_Pair, typename _Pair::second_type> {
  const typename _Pair::second_type& operator()(const _Pair& __x) const {
    return __x.second;
  }
};
template <class _Arg1, class _Arg2>
struct _Project1st : public binary_function<_Arg1, _Arg2, _Arg1> {
  _Arg1 operator()(const _Arg1& __x, const _Arg2&) const { return __x; }
};
template <class _Arg1, class _Arg2>
struct _Project2nd : public binary_function<_Arg1, _Arg2, _Arg2> {
  _Arg2 operator()(const _Arg1&, const _Arg2& __y) const { return __y; }
};
template <class _Tp>
struct _Identity : public unary_function<_Tp,_Tp> {
  const _Tp& operator()(const _Tp& __x) const { return __x; }
};
template <class _Result, class _Argument>
struct _Constant_unary_fun {
  typedef _Argument argument_type;
  typedef _Result result_type;
  result_type _M_val;
  _Constant_unary_fun(const result_type& __v) : _M_val(__v) {}
  const result_type& operator()(const _Argument&) const { return _M_val; }
};
template <class _Result, class _Arg1, class _Arg2>
struct _Constant_binary_fun {
  typedef _Arg1 first_argument_type;
  typedef _Arg2 second_argument_type;
  typedef _Result result_type;
  _Result _M_val;
  _Constant_binary_fun(const _Result& __v) : _M_val(__v) {}
  const result_type& operator()(const _Arg1&, const _Arg2&) const {
    return _M_val;
  }
};
template <class _Tp> inline _Tp __identity_element(plus<_Tp>) { return _Tp(0); }
template <class _Tp> inline _Tp __identity_element(multiplies<_Tp>) { return _Tp(1); }
}
}
namespace stlp_std {
template <class _InputIter1, class _InputIter2>
bool lexicographical_compare(_InputIter1 __first1, _InputIter1 __last1,
                             _InputIter2 __first2, _InputIter2 __last2) {
 
 
  for ( ; __first1 != __last1 && __first2 != __last2
        ; ++__first1, ++__first2) {
    if (*__first1 < *__first2) {
     
      return true;
    }
    if (*__first2 < *__first1)
      return false;
  }
  return __first1 == __last1 && __first2 != __last2;
}
template <class _InputIter1, class _InputIter2, class _Compare>
bool lexicographical_compare(_InputIter1 __first1, _InputIter1 __last1,
                             _InputIter2 __first2, _InputIter2 __last2,
                             _Compare __comp) {
 
 
  for ( ; __first1 != __last1 && __first2 != __last2
        ; ++__first1, ++__first2) {
    if (__comp(*__first1, *__first2)) {
     
      return true;
    }
    if (__comp(*__first2, *__first1))
      return false;
  }
  return __first1 == __last1 && __first2 != __last2;
}
namespace priv {
template <class _InputIter1, class _InputIter2>
int __lexicographical_compare_3way(_InputIter1 __first1, _InputIter1 __last1,
                                   _InputIter2 __first2, _InputIter2 __last2) {
  while (__first1 != __last1 && __first2 != __last2) {
    if (*__first1 < *__first2) {
     
      return -1;
    }
    if (*__first2 < *__first1)
      return 1;
    ++__first1;
    ++__first2;
  }
  if (__first2 == __last2) {
    return !(__first1 == __last1);
  }
  else {
    return -1;
  }
}
}
template <class _InputIter1, class _InputIter2>
int lexicographical_compare_3way(_InputIter1 __first1, _InputIter1 __last1,
                                 _InputIter2 __first2, _InputIter2 __last2) {
 
 
  return ::stlp_std::priv:: __lexicographical_compare_3way(__first1, __last1, __first2, __last2);
}
namespace priv {
template <class _RandomAccessIter, class _Tp>
inline _RandomAccessIter __find(_RandomAccessIter __first, _RandomAccessIter __last,
                                           const _Tp& __val,
                                           const random_access_iterator_tag &) {
  typename iterator_traits<_RandomAccessIter>::difference_type __trip_count = (__last - __first) >> 2;
  for ( ; __trip_count > 0 ; --__trip_count) {
    if (*__first == __val) return __first;
    ++__first;
    if (*__first == __val) return __first;
    ++__first;
    if (*__first == __val) return __first;
    ++__first;
    if (*__first == __val) return __first;
    ++__first;
  }
  switch (__last - __first) {
  case 3:
    if (*__first == __val) return __first;
    ++__first;
  case 2:
    if (*__first == __val) return __first;
    ++__first;
  case 1:
    if (*__first == __val) return __first;
  case 0:
  default:
    return __last;
  }
}
inline char*
__find(char* __first, char* __last, char __val, const random_access_iterator_tag &) {
  void *res = memchr(__first, __val, __last - __first);
  return res != 0 ? static_cast<char*>(res) : __last;
}
inline const char*
__find(const char* __first, const char* __last, char __val, const random_access_iterator_tag &) {
  const void *res = memchr(__first, __val, __last - __first);
  return res != 0 ? static_cast<const char*>(res) : __last;
}
template <class _RandomAccessIter, class _Predicate>
inline _RandomAccessIter __find_if(_RandomAccessIter __first, _RandomAccessIter __last,
                                              _Predicate __pred,
                                              const random_access_iterator_tag &) {
  typename iterator_traits<_RandomAccessIter>::difference_type __trip_count = (__last - __first) >> 2;
  for ( ; __trip_count > 0 ; --__trip_count) {
    if (__pred(*__first)) return __first;
    ++__first;
    if (__pred(*__first)) return __first;
    ++__first;
    if (__pred(*__first)) return __first;
    ++__first;
    if (__pred(*__first)) return __first;
    ++__first;
  }
  switch(__last - __first) {
  case 3:
    if (__pred(*__first)) return __first;
    ++__first;
  case 2:
    if (__pred(*__first)) return __first;
    ++__first;
  case 1:
    if (__pred(*__first)) return __first;
  case 0:
  default:
    return __last;
  }
}
template <class _InputIter, class _Tp>
inline _InputIter __find(_InputIter __first, _InputIter __last,
                                    const _Tp& __val,
                                    const input_iterator_tag &) {
  while (__first != __last && !(*__first == __val)) ++__first;
  return __first;
}
template <class _InputIter, class _Predicate>
inline _InputIter __find_if(_InputIter __first, _InputIter __last,
                                       _Predicate __pred,
                                       const input_iterator_tag &) {
  while (__first != __last && !__pred(*__first))
    ++__first;
  return __first;
}
}
template <class _InputIter, class _Predicate>
_InputIter find_if(_InputIter __first, _InputIter __last,
                   _Predicate __pred) {
 
  return ::stlp_std::priv:: __find_if(__first, __last, __pred, typename ::stlp_std::iterator_traits< _InputIter >::iterator_category());
}
template <class _InputIter, class _Tp>
_InputIter find(_InputIter __first, _InputIter __last, const _Tp& __val) {
 
  return ::stlp_std::priv:: __find(__first, __last, __val, typename ::stlp_std::iterator_traits< _InputIter >::iterator_category());
}
template <class _ForwardIter1, class _ForwardIter2, class _BinaryPred>
_ForwardIter1 search(_ForwardIter1 __first1, _ForwardIter1 __last1,
                     _ForwardIter2 __first2, _ForwardIter2 __last2,
                     _BinaryPred __pred) {
 
 
  if (__first1 == __last1 || __first2 == __last2)
    return __first1;
  _ForwardIter2 __p1(__first2);
  if ( ++__p1 == __last2 ) {
    while (__first1 != __last1 && !__pred(*__first1, *__first2)) {
      ++__first1;
    }
    return __first1;
  }
  for ( ; ; ) {
    while (__first1 != __last1 && !__pred(*__first1, *__first2)) {
      ++__first1;
    }
    if (__first1 == __last1) {
      return __last1;
    }
    _ForwardIter2 __p = __p1;
    _ForwardIter1 __current = __first1;
    if (++__current == __last1) return __last1;
    while (__pred(*__current, *__p)) {
      if (++__p == __last2)
        return __first1;
      if (++__current == __last1)
        return __last1;
    }
    ++__first1;
  }
  return __first1;
}
namespace priv {
template <class _Tp>
struct _IsCharLikeType
{ typedef __false_type _Ret; };
template<> struct _IsCharLikeType<char>
{ typedef __true_type _Ret; };
template<> struct _IsCharLikeType<unsigned char>
{ typedef __true_type _Ret; };
template<> struct _IsCharLikeType<signed char>
{ typedef __true_type _Ret; };
template <class _Tp1, class _Tp2>
inline bool __stlp_eq(_Tp1 __val1, _Tp2 __val2)
{ return __val1 == __val2; }
template <class _Tp>
inline bool __stlp_eq(_Tp, _Tp)
{ return true; }
template <class _InputIter, class _ForwardIter, class _Tp2, class _Predicate>
inline _InputIter __find_first_of_aux2(_InputIter __first1, _InputIter __last1,
                                       _ForwardIter __first2, _ForwardIter __last2,
                                       _Tp2*, _Predicate __pred,
                                       const __true_type& ) {
  unsigned char __hints[((127 * 2 + 1) + 1) / 8];
  memset(__hints, 0, sizeof(__hints) / sizeof(unsigned char));
  for (; __first2 != __last2; ++__first2) {
    unsigned char __tmp = (unsigned char)*__first2;
    __hints[__tmp / 8] |= (1 << (__tmp % 8));
  }
  for (; __first1 != __last1; ++__first1) {
    _Tp2 __tmp = (_Tp2)*__first1;
    if (__stlp_eq(*__first1, __tmp) &&
        __pred((__hints[(unsigned char)__tmp / 8] & (1 << ((unsigned char)__tmp % 8))) != 0))
      break;
  }
  return __first1;
}
template <class _InputIter, class _ForwardIter, class _Tp2, class _Predicate>
inline _InputIter __find_first_of_aux2(_InputIter __first1, _InputIter __last1,
                                       _ForwardIter __first2, _ForwardIter __last2,
                                       _Tp2* , _Predicate ,
                                       const __false_type& ) {
  return ::stlp_std::priv:: __find_first_of(__first1, __last1, __first2, __last2,
                                    ::stlp_std::priv:: __equal_to((typename ::stlp_std::iterator_traits< _InputIter >::value_type*)0));
}
template <class _InputIter, class _ForwardIter, class _Tp1, class _Tp2>
inline _InputIter __find_first_of_aux1(_InputIter __first1, _InputIter __last1,
                                       _ForwardIter __first2, _ForwardIter __last2,
                                       _Tp1* __pt1, _Tp2* __pt2) {
  typedef typename ::stlp_std::_IsIntegral<_Tp1>::_Ret _IsIntegral;
  typedef typename ::stlp_std::priv:: _IsCharLikeType<_Tp2>::_Ret _IsCharLike;
  typedef typename ::stlp_std::_Land2<_IsIntegral, _IsCharLike>::_Ret _UseStrcspnLikeAlgo;
  return ::stlp_std::priv:: __find_first_of_aux2(__first1, __last1,
                                         __first2, __last2,
                                         __pt2, _Identity<bool>(), _UseStrcspnLikeAlgo());
}
template <class _InputIter, class _ForwardIter>
inline _InputIter __find_first_of(_InputIter __first1, _InputIter __last1,
                                  _ForwardIter __first2, _ForwardIter __last2) {
  return ::stlp_std::priv:: __find_first_of_aux1(__first1, __last1, __first2, __last2,
                                         (typename ::stlp_std::iterator_traits< _InputIter >::value_type*)0,
                                         (typename ::stlp_std::iterator_traits< _ForwardIter >::value_type*)0);
}
template <class _InputIter, class _ForwardIter, class _BinaryPredicate>
_InputIter __find_first_of(_InputIter __first1, _InputIter __last1,
                           _ForwardIter __first2, _ForwardIter __last2,
                           _BinaryPredicate __comp) {
  for ( ; __first1 != __last1; ++__first1) {
    for (_ForwardIter __iter = __first2; __iter != __last2; ++__iter) {
      if (__comp(*__first1, *__iter)) {
        return __first1;
      }
    }
  }
  return __last1;
}
template <class _ForwardIter1, class _ForwardIter2,
  class _BinaryPredicate>
_ForwardIter1 __find_end(_ForwardIter1 __first1, _ForwardIter1 __last1,
                         _ForwardIter2 __first2, _ForwardIter2 __last2,
                         const forward_iterator_tag &, const forward_iterator_tag &,
                         _BinaryPredicate __comp) {
  if (__first2 == __last2)
    return __last1;
  else {
    _ForwardIter1 __result = __last1;
    for (;;) {
      _ForwardIter1 __new_result = ::stlp_std::search(__first1, __last1, __first2, __last2, __comp);
      if (__new_result == __last1)
        return __result;
      else {
        __result = __new_result;
        __first1 = __new_result;
        ++__first1;
      }
    }
  }
}
}
}
namespace stlp_std {
template <class _Iterator>
class reverse_iterator :
  public iterator<typename iterator_traits<_Iterator>::iterator_category,
                  typename iterator_traits<_Iterator>::value_type,
                  typename iterator_traits<_Iterator>::difference_type,
                  typename iterator_traits<_Iterator>::pointer,
                  typename iterator_traits<_Iterator>::reference> {
protected:
  _Iterator current;
  typedef reverse_iterator<_Iterator> _Self;
public:
  typedef typename iterator_traits<_Iterator>::difference_type difference_type;
  typedef typename iterator_traits<_Iterator>::pointer pointer;
  typedef typename iterator_traits<_Iterator>::reference reference;
  typedef _Iterator iterator_type;
public:
  reverse_iterator() {}
  explicit reverse_iterator(iterator_type __x) : current(__x) {}
  reverse_iterator(const _Self& __x) : current(__x.current) {}
  _Self& operator = (const _Self& __x) { current = __x.base(); return *this; }
  template <class _Iter>
  reverse_iterator(const reverse_iterator<_Iter>& __x) : current(__x.base()) {}
  template <class _Iter>
  _Self& operator = (const reverse_iterator<_Iter>& __x) { current = __x.base(); return *this; }
  iterator_type base() const { return current; }
  reference operator*() const {
    _Iterator __tmp = current;
    return *--__tmp;
  }
  pointer operator->() const { return &(operator*()); }
  _Self& operator++() {
    --current;
    return *this;
  }
  _Self operator++(int) {
    _Self __tmp = *this;
    --current;
    return __tmp;
  }
  _Self& operator--() {
    ++current;
    return *this;
  }
  _Self operator--(int) {
    _Self __tmp = *this;
    ++current;
    return __tmp;
  }
  _Self operator+(difference_type __n) const { return _Self(current - __n); }
  _Self& operator+=(difference_type __n) {
    current -= __n;
    return *this;
  }
  _Self operator-(difference_type __n) const { return _Self(current + __n); }
  _Self& operator-=(difference_type __n) {
    current += __n;
    return *this;
  }
  reference operator[](difference_type __n) const { return *(*this + __n); }
};
template <class _Iterator>
inline bool operator==(const reverse_iterator<_Iterator>& __x,
                                   const reverse_iterator<_Iterator>& __y)
{ return __x.base() == __y.base(); }
template <class _Iterator>
inline bool operator<(const reverse_iterator<_Iterator>& __x,
                                 const reverse_iterator<_Iterator>& __y)
{ return __y.base() < __x.base(); }
template <class _Iterator>
inline bool operator!=(const reverse_iterator<_Iterator>& __x,
                                  const reverse_iterator<_Iterator>& __y)
{ return !(__x == __y); }
template <class _Iterator>
inline bool operator>(const reverse_iterator<_Iterator>& __x,
                                 const reverse_iterator<_Iterator>& __y)
{ return __y < __x; }
template <class _Iterator>
inline bool operator<=(const reverse_iterator<_Iterator>& __x,
                                  const reverse_iterator<_Iterator>& __y)
{ return !(__y < __x); }
template <class _Iterator>
inline bool operator>=(const reverse_iterator<_Iterator>& __x,
                                  const reverse_iterator<_Iterator>& __y)
{ return !(__x < __y); }
template <class _Iterator>
inline typename reverse_iterator<_Iterator>::difference_type
operator-(const reverse_iterator<_Iterator>& __x,
          const reverse_iterator<_Iterator>& __y)
{ return __y.base() - __x.base(); }
template <class _Iterator, class _DifferenceType>
inline reverse_iterator<_Iterator>
operator+(_DifferenceType n,const reverse_iterator<_Iterator>& x)
{ return x.operator+(n); }
template <class _Container>
class back_insert_iterator
  : public iterator<output_iterator_tag, void, void, void, void> {
  typedef back_insert_iterator<_Container> _Self;
protected:
  _Container *container;
public:
  typedef _Container container_type;
  typedef output_iterator_tag iterator_category;
  explicit back_insert_iterator(_Container& __x) : container(&__x) {}
  _Self& operator=(const _Self& __other) {
    container = __other.container;
    return *this;
  }
  _Self& operator=(const typename _Container::value_type& __val) {
    container->push_back(__val);
    return *this;
  }
  _Self& operator*() { return *this; }
  _Self& operator++() { return *this; }
  _Self operator++(int) { return *this; }
};
template <class _Container>
inline back_insert_iterator<_Container> back_inserter(_Container& __x)
{ return back_insert_iterator<_Container>(__x); }
template <class _Container>
class front_insert_iterator
  : public iterator<output_iterator_tag, void, void, void, void> {
  typedef front_insert_iterator<_Container> _Self;
protected:
  _Container *container;
public:
  typedef _Container container_type;
  typedef output_iterator_tag iterator_category;
  explicit front_insert_iterator(_Container& __x) : container(&__x) {}
  _Self& operator=(const _Self& __other) {
    container = __other.container;
    return *this;
  }
  _Self& operator=(const typename _Container::value_type& __val) {
    container->push_front(__val);
    return *this;
  }
  _Self& operator*() { return *this; }
  _Self& operator++() { return *this; }
  _Self operator++(int) { return *this; }
};
template <class _Container>
inline front_insert_iterator<_Container> front_inserter(_Container& __x)
{ return front_insert_iterator<_Container>(__x); }
template <class _Container>
class insert_iterator
  : public iterator<output_iterator_tag, void, void, void, void> {
  typedef insert_iterator<_Container> _Self;
protected:
  _Container *container;
  typename _Container::iterator _M_iter;
public:
  typedef _Container container_type;
  typedef output_iterator_tag iterator_category;
  insert_iterator(_Container& __x, typename _Container::iterator __i)
    : container(&__x), _M_iter(__i) {}
  _Self& operator=(_Self const& __other) {
    container = __other.container;
    _M_iter = __other._M_iter;
    return *this;
  }
  _Self& operator=(const typename _Container::value_type& __val) {
    _M_iter = container->insert(_M_iter, __val);
    ++_M_iter;
    return *this;
  }
  _Self& operator*() { return *this; }
  _Self& operator++() { return *this; }
  _Self& operator++(int) { return *this; }
};
template <class _Container, class _Iterator>
inline insert_iterator<_Container>
inserter(_Container& __x, _Iterator __i) {
  typedef typename _Container::iterator __iter;
  return insert_iterator<_Container>(__x, __iter(__i));
}
}
namespace stlp_std {
namespace priv {
template <class _BidirectionalIter1, class _BidirectionalIter2,
          class _BinaryPredicate>
_BidirectionalIter1
__find_end(_BidirectionalIter1 __first1, _BidirectionalIter1 __last1,
           _BidirectionalIter2 __first2, _BidirectionalIter2 __last2,
           const bidirectional_iterator_tag &, const bidirectional_iterator_tag &,
           _BinaryPredicate __comp) {
  typedef ::stlp_std::reverse_iterator<_BidirectionalIter1> _RevIter1;
  typedef ::stlp_std::reverse_iterator<_BidirectionalIter2> _RevIter2;
  _RevIter1 __rlast1(__first1);
  _RevIter2 __rlast2(__first2);
  _RevIter1 __rresult = ::stlp_std::search(_RevIter1(__last1), __rlast1,
                                          _RevIter2(__last2), __rlast2,
                                          __comp);
  if (__rresult == __rlast1)
    return __last1;
  else {
    _BidirectionalIter1 __result = __rresult.base();
    ::stlp_std::advance(__result, -::stlp_std::distance(__first2, __last2));
    return __result;
  }
}
}
template <class _ForwardIter1, class _ForwardIter2,
          class _BinaryPredicate>
_ForwardIter1
find_end(_ForwardIter1 __first1, _ForwardIter1 __last1,
         _ForwardIter2 __first2, _ForwardIter2 __last2,
         _BinaryPredicate __comp) {
 
 
  return ::stlp_std::priv:: __find_end(__first1, __last1, __first2, __last2,
                               typename ::stlp_std::iterator_traits< _ForwardIter1 >::iterator_category(),
                               typename ::stlp_std::iterator_traits< _ForwardIter2 >::iterator_category(),
                               __comp);
}
namespace priv {
template <class _ForwardIter, class _Tp, class _Compare1, class _Compare2, class _Distance>
_ForwardIter __lower_bound(_ForwardIter __first, _ForwardIter __last, const _Tp& __val,
                           _Compare1 __comp1, _Compare2 __comp2, _Distance*) {
  _Distance __len = ::stlp_std::distance(__first, __last);
  _Distance __half;
  _ForwardIter __middle;
  while (__len > 0) {
    __half = __len >> 1;
    __middle = __first;
    ::stlp_std::advance(__middle, __half);
    if (__comp1(*__middle, __val)) {
     
      __first = __middle;
      ++__first;
      __len = __len - __half - 1;
    }
    else
      __len = __half;
  }
  return __first;
}
}
}
       
extern "C++" {
namespace std
{
  class exception
  {
  public:
    exception() throw() { }
    virtual ~exception() throw();
    virtual const char* what() const throw();
  };
  class bad_exception : public exception
  {
  public:
    bad_exception() throw() { }
    virtual ~bad_exception() throw();
    virtual const char* what() const throw();
  };
  typedef void (*terminate_handler) ();
  typedef void (*unexpected_handler) ();
  terminate_handler set_terminate(terminate_handler) throw();
  void terminate() __attribute__ ((__noreturn__));
  unexpected_handler set_unexpected(unexpected_handler) throw();
  void unexpected() __attribute__ ((__noreturn__));
  bool uncaught_exception() throw();
}
namespace __gnu_cxx __attribute__ ((__visibility__ ("default"))) {
  void __verbose_terminate_handler();
}
}
extern "C++" {
namespace std
{
  namespace __exception_ptr
  {
    class exception_ptr;
  }
  using __exception_ptr::exception_ptr;
  exception_ptr current_exception() throw();
  void rethrow_exception(exception_ptr) __attribute__ ((__noreturn__));
  template<typename _Ex>
    exception_ptr
    copy_exception(_Ex __ex) throw();
  namespace __exception_ptr
  {
    bool
    operator==(const exception_ptr&, const exception_ptr&) throw();
    bool
    operator!=(const exception_ptr&, const exception_ptr&) throw();
    class exception_ptr
    {
      void* _M_exception_object;
      explicit exception_ptr(void* __e) throw();
      void _M_addref() throw();
      void _M_release() throw();
      void *_M_get() const throw();
      void _M_safe_bool_dummy();
      friend exception_ptr std::current_exception() throw();
      friend void std::rethrow_exception(exception_ptr);
    public:
      exception_ptr() throw();
      typedef void (exception_ptr::*__safe_bool)();
      exception_ptr(__safe_bool) throw();
      exception_ptr(const exception_ptr&) throw();
      exception_ptr(exception_ptr&& __o) throw()
      : _M_exception_object(__o._M_exception_object)
      { __o._M_exception_object = 0; }
      exception_ptr&
      operator=(const exception_ptr&) throw();
      exception_ptr&
      operator=(exception_ptr&& __o) throw()
      {
        exception_ptr(__o).swap(*this);
        return *this;
      }
      ~exception_ptr() throw();
      void
      swap(exception_ptr&) throw();
      void
      swap(exception_ptr &&__o) throw()
      {
        void *__tmp = _M_exception_object;
        _M_exception_object = __o._M_exception_object;
        __o._M_exception_object = __tmp;
      }
      bool operator!() const throw();
      operator __safe_bool() const throw();
      friend bool
      operator==(const exception_ptr&, const exception_ptr&) throw();
      const type_info*
      __cxa_exception_type() const throw();
    };
  }
  template<typename _Ex>
    exception_ptr
    copy_exception(_Ex __ex) throw()
    {
      try
 {
   throw __ex;
 }
      catch(...)
 {
   return current_exception ();
 }
    }
}
}
extern "C++" {
namespace std
{
  class bad_alloc : public exception
  {
  public:
    bad_alloc() throw() { }
    virtual ~bad_alloc() throw();
    virtual const char* what() const throw();
  };
  struct nothrow_t { };
  extern const nothrow_t nothrow;
  typedef void (*new_handler)();
  new_handler set_new_handler(new_handler) throw();
}
void* operator new(std::size_t) throw (std::bad_alloc);
void* operator new[](std::size_t) throw (std::bad_alloc);
void operator delete(void*) throw();
void operator delete[](void*) throw();
void* operator new(std::size_t, const std::nothrow_t&) throw();
void* operator new[](std::size_t, const std::nothrow_t&) throw();
void operator delete(void*, const std::nothrow_t&) throw();
void operator delete[](void*, const std::nothrow_t&) throw();
inline void* operator new(std::size_t, void* __p) throw() { return __p; }
inline void* operator new[](std::size_t, void* __p) throw() { return __p; }
inline void operator delete (void*, void*) throw() { }
inline void operator delete[](void*, void*) throw() { }
}
namespace stlp_std {
using std::bad_alloc;
using std::nothrow_t;
using std::nothrow;
using std::new_handler;
using std::set_new_handler;
}
namespace stlp_std {
inline void* __stl_new(size_t __n) { return ::operator new(__n); }
inline void __stl_delete(void* __p) { ::operator delete(__p); }
}
namespace stlp_std {
template <class _Tp>
inline void __destroy_aux(_Tp* __pointer, const __false_type& )
{ __pointer->~_Tp(); }
template <class _Tp>
inline void __destroy_aux(_Tp*, const __true_type& ) {}
template <class _Tp>
inline void _Destroy(_Tp* __pointer) {
  typedef typename __type_traits<_Tp>::has_trivial_destructor _Trivial_destructor;
  __destroy_aux(__pointer, _Trivial_destructor());
}
template <class _Tp>
inline void _Destroy_Moved(_Tp* __pointer) {
  typedef typename __move_traits<_Tp>::complete _Trivial_destructor;
  __destroy_aux(__pointer, _Trivial_destructor());
}
template <class _T1>
inline void _Construct_aux (_T1* __p, const __false_type&) {
  new(__p) _T1();
}
template <class _T1>
inline void _Construct_aux (_T1* __p, const __true_type&) {
  *__p = _T1();
}
template <class _T1>
inline void _Construct(_T1* __p) {
  _Construct_aux (__p, _Is_POD(__p)._Answer());
}
template <class _Tp>
inline void _Copy_Construct_aux(_Tp* __p, const _Tp& __val, const __false_type&) {
  new(__p) _Tp(__val);
}
template <class _Tp>
inline void _Copy_Construct_aux(_Tp* __p, const _Tp& __val, const __true_type&) {
  *__p = __val;
}
template <class _Tp>
inline void _Copy_Construct(_Tp* __p, const _Tp& __val) {
  _Copy_Construct_aux(__p, __val, _Is_POD(__p)._Answer());
}
template <class _T1, class _T2>
inline void _Param_Construct_aux(_T1* __p, const _T2& __val, const __false_type&) {
  new(__p) _T1(__val);
}
template <class _T1, class _T2>
inline void _Param_Construct_aux(_T1* __p, const _T2& __val, const __true_type&) {
  *__p = _T1(__val);
}
template <class _T1, class _T2>
inline void _Param_Construct(_T1* __p, const _T2& __val) {
  _Param_Construct_aux(__p, __val, _Is_POD(__p)._Answer());
}
template <class _T1, class _T2>
inline void _Move_Construct_Aux(_T1* __p, _T2& __val, const __false_type& ) {
  new(__p) _T1(::stlp_std::priv:: _AsMoveSource(__val));
}
template <class _T1, class _T2>
inline void _Move_Construct_Aux(_T1* __p, _T2& __val, const __true_type& ) {
  *__p = _T1(__val);
}
template <class _T1, class _T2>
inline void _Move_Construct(_T1* __p, _T2& __val) {
  _Move_Construct_Aux(__p, __val, _Is_POD(__p)._Answer());
}
template <class _ForwardIterator, class _Tp>
inline void
__destroy_range_aux(_ForwardIterator __first, _ForwardIterator __last, _Tp*, const __false_type& ) {
  for ( ; __first != __last; ++__first) {
    __destroy_aux(&(*__first), __false_type());
  }
}
template <class _ForwardIterator, class _Tp>
inline void
__destroy_range_aux(_ForwardIterator, _ForwardIterator, _Tp*, const __true_type& ) {}
template <class _ForwardIterator, class _Tp>
inline void
__destroy_range(_ForwardIterator __first, _ForwardIterator __last, _Tp *__ptr) {
  typedef typename __type_traits<_Tp>::has_trivial_destructor _Trivial_destructor;
  __destroy_range_aux(__first, __last, __ptr, _Trivial_destructor());
}
template <class _ForwardIterator>
inline void _Destroy_Range(_ForwardIterator __first, _ForwardIterator __last) {
  __destroy_range(__first, __last, (typename ::stlp_std::iterator_traits< _ForwardIterator >::value_type*)0);
}
inline void _Destroy_Range(char*, char*) {}
inline void _Destroy_Range(wchar_t*, wchar_t*) {}
inline void _Destroy_Range(const wchar_t*, const wchar_t*) {}
template <class _ForwardIterator, class _Tp>
inline void
__destroy_mv_srcs(_ForwardIterator __first, _ForwardIterator __last, _Tp *__ptr) {
  typedef typename __move_traits<_Tp>::complete _CompleteMove;
  __destroy_range_aux(__first, __last, __ptr, _CompleteMove());
}
template <class _ForwardIterator>
inline void _Destroy_Moved_Range(_ForwardIterator __first, _ForwardIterator __last)
{ __destroy_mv_srcs(__first, __last, (typename ::stlp_std::iterator_traits< _ForwardIterator >::value_type*)0); }
template <class _T1, class _T2>
inline void construct(_T1* __p, const _T2& __val) {_Param_Construct(__p, __val); }
template <class _T1>
inline void construct(_T1* __p) { ::stlp_std::_Construct(__p); }
template <class _Tp>
inline void destroy(_Tp* __pointer) { ::stlp_std::_Destroy(__pointer); }
template <class _ForwardIterator>
inline void destroy(_ForwardIterator __first, _ForwardIterator __last) { ::stlp_std::_Destroy_Range(__first, __last); }
}
namespace stlp_std {
typedef void (* __oom_handler_type)();
class __attribute__((visibility("default"))) __malloc_alloc {
public:
  typedef char value_type;
  static void* allocate(size_t __n)
  ;
  static void deallocate(void* __p, size_t ) { free((char*)__p); }
  static __oom_handler_type set_malloc_handler(__oom_handler_type __f);
};
class __attribute__((visibility("default"))) __new_alloc {
public:
  typedef char value_type;
  static void* allocate(size_t __n) { return __stl_new(__n); }
  static void deallocate(void* __p, size_t) { __stl_delete(__p); }
};
template <class _Alloc>
class __debug_alloc : public _Alloc {
public:
  typedef _Alloc __allocator_type;
  typedef typename _Alloc::value_type value_type;
private:
  struct __alloc_header {
    size_t __magic: 16;
    size_t __type_size:16;
    unsigned long _M_size;
  };
  enum { __pad = 8, __magic = 0xdeba, __deleted_magic = 0xdebd,
         __shred_byte = 0xA3 };
  enum { __extra_before = 16, __extra_after = 8 };
  static size_t __extra_before_chunk() {
    return (long)__extra_before / sizeof(value_type) +
      (size_t)((long)__extra_before % sizeof(value_type) > 0);
  }
  static size_t __extra_after_chunk() {
    return (long)__extra_after / sizeof(value_type) +
      (size_t)((long)__extra_after % sizeof(value_type) > 0);
  }
public:
  __debug_alloc() {}
  ~__debug_alloc() {}
  static void* allocate(size_t);
  static void deallocate(void *, size_t);
};
enum { _MAX_BYTES = 32 * sizeof(void*) };
class __attribute__((visibility("default"))) __node_alloc {
  static void * _M_allocate(size_t& __n);
  static void _M_deallocate(void *__p, size_t __n);
public:
  typedef char value_type;
  static void* allocate(size_t& __n)
  { return (__n > (size_t)_MAX_BYTES) ? __stl_new(__n) : _M_allocate(__n); }
  static void deallocate(void *__p, size_t __n)
  { if (__n > (size_t)_MAX_BYTES) __stl_delete(__p); else _M_deallocate(__p, __n); }
};
template <class _Tp, class _Allocator>
struct _Alloc_traits {
  typedef _Allocator _Orig;
  typedef typename _Allocator::template rebind<_Tp> _Rebind_type;
  typedef typename _Rebind_type::other allocator_type;
  static allocator_type create_allocator(const _Orig& __a)
  { return allocator_type(__a); }
};
typedef __malloc_alloc __alloc_type;
typedef __alloc_type __sgi_alloc;
typedef __sgi_alloc __single_client_alloc;
typedef __sgi_alloc __multithreaded_alloc;
template <class _Tp>
class allocator
                : public __stlport_class<allocator<_Tp> >
{
public:
  typedef _Tp value_type;
  typedef _Tp* pointer;
  typedef const _Tp* const_pointer;
  typedef _Tp& reference;
  typedef const _Tp& const_reference;
  typedef size_t size_type;
  typedef ptrdiff_t difference_type;
  template <class _Tp1> struct rebind {
    typedef allocator<_Tp1> other;
  };
  allocator() throw() {}
  template <class _Tp1> allocator(const allocator<_Tp1>&) throw() {}
  allocator(const allocator<_Tp>&) throw() {}
  allocator(__move_source<allocator<_Tp> > src) throw() {}
  ~allocator() throw() {}
  pointer address(reference __x) const {return &__x;}
  const_pointer address(const_reference __x) const { return &__x; }
  _Tp* allocate(size_type __n, const void* = 0) {
    if (__n > max_size()) {
      throw ::stlp_std::bad_alloc();
    }
    if (__n != 0) {
      size_type __buf_size = __n * sizeof(value_type);
      _Tp* __ret = reinterpret_cast<_Tp*>(__sgi_alloc::allocate(__buf_size));
      return __ret;
    }
    return 0;
  }
  void deallocate(pointer __p, size_type __n) {
   
    if (__p != 0) {
      __sgi_alloc::deallocate((void*)__p, __n * sizeof(value_type));
    }
  }
  void deallocate(pointer __p) const { if (__p != 0) __sgi_alloc::deallocate((void*)__p, sizeof(value_type)); }
  size_type max_size() const throw() { return size_t(-1) / sizeof(value_type); }
  void construct(pointer __p, const_reference __val) { ::stlp_std::_Copy_Construct(__p, __val); }
  void destroy(pointer __p) { ::stlp_std::_Destroy(__p); }
  _Tp* _M_allocate(size_type __n, size_type& __allocated_n) {
    if (__n > max_size()) {
      throw ::stlp_std::bad_alloc();
    }
    if (__n != 0) {
      size_type __buf_size = __n * sizeof(value_type);
      _Tp* __ret = reinterpret_cast<_Tp*>(__sgi_alloc::allocate(__buf_size));
      __allocated_n = __buf_size / sizeof(value_type);
      return __ret;
    }
    return 0;
  }
};
template<>
class __attribute__((visibility("default"))) allocator<void> {
public:
  typedef size_t size_type;
  typedef ptrdiff_t difference_type;
  typedef void* pointer;
  typedef const void* const_pointer;
  typedef void value_type;
  template <class _Tp1> struct rebind {
    typedef allocator<_Tp1> other;
  };
};
template <class _T1, class _T2>
inline bool operator==(const allocator<_T1>&, const allocator<_T2>&) throw()
{ return true; }
template <class _T1, class _T2>
inline bool operator!=(const allocator<_T1>&, const allocator<_T2>&) throw()
{ return false; }
namespace priv {
template <class _Tp>
struct __alloc_type_traits {
  typedef typename _IsSTLportClass<allocator<_Tp> >::_Ret _STLportAlloc;
  typedef _STLportAlloc has_trivial_default_constructor;
  typedef _STLportAlloc has_trivial_copy_constructor;
  typedef _STLportAlloc has_trivial_assignment_operator;
  typedef _STLportAlloc has_trivial_destructor;
  typedef _STLportAlloc is_POD_type;
};
}
template <class _Tp>
struct __type_traits<allocator<_Tp> > : ::stlp_std::priv:: __alloc_type_traits<_Tp> {};
template <class _Tp, class _Alloc>
inline typename _Alloc_traits<_Tp, _Alloc>::allocator_type
__stl_alloc_create(const _Alloc& __a, const _Tp*) {
  typedef typename _Alloc::template rebind<_Tp>::other _Rebound_type;
  return _Rebound_type(__a);
}
namespace priv {
template <class _Value, class _Tp, class _MaybeReboundAlloc>
class _STLP_alloc_proxy : public _MaybeReboundAlloc {
private:
  typedef _MaybeReboundAlloc _Base;
  typedef typename _Base::size_type size_type;
  typedef _STLP_alloc_proxy<_Value, _Tp, _MaybeReboundAlloc> _Self;
public:
  _Value _M_data;
  _STLP_alloc_proxy (const _MaybeReboundAlloc& __a, _Value __p) :
    _MaybeReboundAlloc(__a), _M_data(__p) {}
  _STLP_alloc_proxy (__move_source<_Self> src) :
    _Base(::stlp_std::priv:: _AsMoveSource(src.get()._M_base())),
    _M_data(::stlp_std::priv:: _AsMoveSource(src.get()._M_data)) {}
  _Base& _M_base()
  { return *this; }
private:
  void _M_swap_alloc(_Self&, const __true_type& )
  {}
  void _M_swap_alloc(_Self& __x, const __false_type& ) {
    _MaybeReboundAlloc &__base_this = *this;
    _MaybeReboundAlloc &__base_x = __x;
    ::stlp_std::swap(__base_this, __base_x);
  }
public:
  void _M_swap_alloc(_Self& __x) {
    typedef typename _IsStateless<_MaybeReboundAlloc>::_Ret _StatelessAlloc;
    _M_swap_alloc(__x, _StatelessAlloc());
  }
  void swap(_Self& __x) {
    _M_swap_alloc(__x);
    ::stlp_std::swap(_M_data, __x._M_data);
  }
  _Tp* allocate(size_type __n, size_type& __allocated_n) {
    typedef typename _IsSTLportClass<_MaybeReboundAlloc>::_Ret _STLportAlloc;
    return allocate(__n, __allocated_n, _STLportAlloc());
  }
  _Tp* allocate(size_type __n)
  { return _Base::allocate(__n); }
private:
  _Tp* allocate(size_type __n, size_type& __allocated_n, const __true_type& )
  { return _Base::_M_allocate(__n, __allocated_n); }
  _Tp* allocate(size_type __n, size_type& __allocated_n, const __false_type& )
  { __allocated_n = __n; return allocate(__n); }
};
}
}
namespace stlp_std {
template <class _Alloc>
void * __debug_alloc<_Alloc>::allocate(size_t __n) {
  size_t __total_extra = __extra_before_chunk() + __extra_after_chunk();
  size_t __real_n = __n + __total_extra;
  if (__real_n < __n) {
    throw ::stlp_std::bad_alloc();
  }
  __alloc_header *__result = (__alloc_header *)__allocator_type::allocate(__real_n);
  memset((char*)__result, __shred_byte, __real_n * sizeof(value_type));
  __result->__magic = __magic;
  __result->__type_size = sizeof(value_type);
  __result->_M_size = (unsigned long)__n;
  return ((char*)__result) + (long)__extra_before;
}
template <class _Alloc>
void
__debug_alloc<_Alloc>::deallocate(void *__p, size_t __n) {
  __alloc_header * __real_p = (__alloc_header*)((char *)__p -(long)__extra_before);
 
 
 
 
  unsigned char* __tmp;
  for (__tmp = (unsigned char*)(__real_p + 1); __tmp < (unsigned char*)__p; ++__tmp) {
   
  }
  size_t __real_n = __n + __extra_before_chunk() + __extra_after_chunk();
  for (__tmp= ((unsigned char*)__p) + __n * sizeof(value_type);
       __tmp < ((unsigned char*)__real_p) + __real_n ; ++__tmp) {
   
  }
  __real_p->__magic = __deleted_magic;
  memset((char*)__p, __shred_byte, __n * sizeof(value_type));
  __allocator_type::deallocate(__real_p, __real_n);
}
}
       
       
       
struct _IO_FILE;
typedef struct _IO_FILE FILE;
typedef struct _IO_FILE __FILE;
typedef __builtin_va_list __gnuc_va_list;
typedef unsigned int wint_t;
typedef struct
{
  int __count;
  union
  {
    unsigned int __wch;
    char __wchb[4];
  } __value;
} __mbstate_t;
typedef __mbstate_t mbstate_t;
extern "C" {
struct tm;
extern wchar_t *wcscpy (wchar_t *__restrict __dest,
   __const wchar_t *__restrict __src) throw ();
extern wchar_t *wcsncpy (wchar_t *__restrict __dest,
    __const wchar_t *__restrict __src, size_t __n)
     throw ();
extern wchar_t *wcscat (wchar_t *__restrict __dest,
   __const wchar_t *__restrict __src) throw ();
extern wchar_t *wcsncat (wchar_t *__restrict __dest,
    __const wchar_t *__restrict __src, size_t __n)
     throw ();
extern int wcscmp (__const wchar_t *__s1, __const wchar_t *__s2)
     throw () __attribute__ ((__pure__));
extern int wcsncmp (__const wchar_t *__s1, __const wchar_t *__s2, size_t __n)
     throw () __attribute__ ((__pure__));
extern int wcscasecmp (__const wchar_t *__s1, __const wchar_t *__s2) throw ();
extern int wcsncasecmp (__const wchar_t *__s1, __const wchar_t *__s2,
   size_t __n) throw ();
extern int wcscasecmp_l (__const wchar_t *__s1, __const wchar_t *__s2,
    __locale_t __loc) throw ();
extern int wcsncasecmp_l (__const wchar_t *__s1, __const wchar_t *__s2,
     size_t __n, __locale_t __loc) throw ();
extern int wcscoll (__const wchar_t *__s1, __const wchar_t *__s2) throw ();
extern size_t wcsxfrm (wchar_t *__restrict __s1,
         __const wchar_t *__restrict __s2, size_t __n) throw ();
extern int wcscoll_l (__const wchar_t *__s1, __const wchar_t *__s2,
        __locale_t __loc) throw ();
extern size_t wcsxfrm_l (wchar_t *__s1, __const wchar_t *__s2,
    size_t __n, __locale_t __loc) throw ();
extern wchar_t *wcsdup (__const wchar_t *__s) throw () __attribute__ ((__malloc__));
extern wchar_t *wcschr (__const wchar_t *__wcs, wchar_t __wc)
     throw () __attribute__ ((__pure__));
extern wchar_t *wcsrchr (__const wchar_t *__wcs, wchar_t __wc)
     throw () __attribute__ ((__pure__));
extern wchar_t *wcschrnul (__const wchar_t *__s, wchar_t __wc)
     throw () __attribute__ ((__pure__));
extern size_t wcscspn (__const wchar_t *__wcs, __const wchar_t *__reject)
     throw () __attribute__ ((__pure__));
extern size_t wcsspn (__const wchar_t *__wcs, __const wchar_t *__accept)
     throw () __attribute__ ((__pure__));
extern wchar_t *wcspbrk (__const wchar_t *__wcs, __const wchar_t *__accept)
     throw () __attribute__ ((__pure__));
extern wchar_t *wcsstr (__const wchar_t *__haystack, __const wchar_t *__needle)
     throw () __attribute__ ((__pure__));
extern wchar_t *wcstok (wchar_t *__restrict __s,
   __const wchar_t *__restrict __delim,
   wchar_t **__restrict __ptr) throw ();
extern size_t wcslen (__const wchar_t *__s) throw () __attribute__ ((__pure__));
extern wchar_t *wcswcs (__const wchar_t *__haystack, __const wchar_t *__needle)
     throw () __attribute__ ((__pure__));
extern size_t wcsnlen (__const wchar_t *__s, size_t __maxlen)
     throw () __attribute__ ((__pure__));
extern wchar_t *wmemchr (__const wchar_t *__s, wchar_t __c, size_t __n)
     throw () __attribute__ ((__pure__));
extern int wmemcmp (__const wchar_t *__restrict __s1,
      __const wchar_t *__restrict __s2, size_t __n)
     throw () __attribute__ ((__pure__));
extern wchar_t *wmemcpy (wchar_t *__restrict __s1,
    __const wchar_t *__restrict __s2, size_t __n) throw ();
extern wchar_t *wmemmove (wchar_t *__s1, __const wchar_t *__s2, size_t __n)
     throw ();
extern wchar_t *wmemset (wchar_t *__s, wchar_t __c, size_t __n) throw ();
extern wchar_t *wmempcpy (wchar_t *__restrict __s1,
     __const wchar_t *__restrict __s2, size_t __n)
     throw ();
extern wint_t btowc (int __c) throw ();
extern int wctob (wint_t __c) throw ();
extern int mbsinit (__const mbstate_t *__ps) throw () __attribute__ ((__pure__));
extern size_t mbrtowc (wchar_t *__restrict __pwc,
         __const char *__restrict __s, size_t __n,
         mbstate_t *__p) throw ();
extern size_t wcrtomb (char *__restrict __s, wchar_t __wc,
         mbstate_t *__restrict __ps) throw ();
extern size_t __mbrlen (__const char *__restrict __s, size_t __n,
   mbstate_t *__restrict __ps) throw ();
extern size_t mbrlen (__const char *__restrict __s, size_t __n,
        mbstate_t *__restrict __ps) throw ();
extern wint_t __btowc_alias (int __c) __asm ("btowc");
extern __inline __attribute__ ((__gnu_inline__)) wint_t
btowc (int __c) throw ()
{ return (__builtin_constant_p (__c) && __c >= '\0' && __c <= '\x7f'
   ? (wint_t) __c : __btowc_alias (__c)); }
extern int __wctob_alias (wint_t __c) __asm ("wctob");
extern __inline __attribute__ ((__gnu_inline__)) int
wctob (wint_t __wc) throw ()
{ return (__builtin_constant_p (__wc) && __wc >= L'\0' && __wc <= L'\x7f'
   ? (int) __wc : __wctob_alias (__wc)); }
extern __inline __attribute__ ((__gnu_inline__)) size_t
mbrlen (__const char *__restrict __s, size_t __n, mbstate_t *__restrict __ps) throw ()
{ return (__ps != __null
   ? mbrtowc (__null, __s, __n, __ps) : __mbrlen (__s, __n, __null)); }
extern size_t mbsrtowcs (wchar_t *__restrict __dst,
    __const char **__restrict __src, size_t __len,
    mbstate_t *__restrict __ps) throw ();
extern size_t wcsrtombs (char *__restrict __dst,
    __const wchar_t **__restrict __src, size_t __len,
    mbstate_t *__restrict __ps) throw ();
extern size_t mbsnrtowcs (wchar_t *__restrict __dst,
     __const char **__restrict __src, size_t __nmc,
     size_t __len, mbstate_t *__restrict __ps) throw ();
extern size_t wcsnrtombs (char *__restrict __dst,
     __const wchar_t **__restrict __src,
     size_t __nwc, size_t __len,
     mbstate_t *__restrict __ps) throw ();
extern int wcwidth (wchar_t __c) throw ();
extern int wcswidth (__const wchar_t *__s, size_t __n) throw ();
extern double wcstod (__const wchar_t *__restrict __nptr,
        wchar_t **__restrict __endptr) throw ();
extern float wcstof (__const wchar_t *__restrict __nptr,
       wchar_t **__restrict __endptr) throw ();
extern long double wcstold (__const wchar_t *__restrict __nptr,
       wchar_t **__restrict __endptr) throw ();
extern long int wcstol (__const wchar_t *__restrict __nptr,
   wchar_t **__restrict __endptr, int __base) throw ();
extern unsigned long int wcstoul (__const wchar_t *__restrict __nptr,
      wchar_t **__restrict __endptr, int __base)
     throw ();
__extension__
extern long long int wcstoll (__const wchar_t *__restrict __nptr,
         wchar_t **__restrict __endptr, int __base)
     throw ();
__extension__
extern unsigned long long int wcstoull (__const wchar_t *__restrict __nptr,
     wchar_t **__restrict __endptr,
     int __base) throw ();
__extension__
extern long long int wcstoq (__const wchar_t *__restrict __nptr,
        wchar_t **__restrict __endptr, int __base)
     throw ();
__extension__
extern unsigned long long int wcstouq (__const wchar_t *__restrict __nptr,
           wchar_t **__restrict __endptr,
           int __base) throw ();
extern long int wcstol_l (__const wchar_t *__restrict __nptr,
     wchar_t **__restrict __endptr, int __base,
     __locale_t __loc) throw ();
extern unsigned long int wcstoul_l (__const wchar_t *__restrict __nptr,
        wchar_t **__restrict __endptr,
        int __base, __locale_t __loc) throw ();
__extension__
extern long long int wcstoll_l (__const wchar_t *__restrict __nptr,
    wchar_t **__restrict __endptr,
    int __base, __locale_t __loc) throw ();
__extension__
extern unsigned long long int wcstoull_l (__const wchar_t *__restrict __nptr,
       wchar_t **__restrict __endptr,
       int __base, __locale_t __loc)
     throw ();
extern double wcstod_l (__const wchar_t *__restrict __nptr,
   wchar_t **__restrict __endptr, __locale_t __loc)
     throw ();
extern float wcstof_l (__const wchar_t *__restrict __nptr,
         wchar_t **__restrict __endptr, __locale_t __loc)
     throw ();
extern long double wcstold_l (__const wchar_t *__restrict __nptr,
         wchar_t **__restrict __endptr,
         __locale_t __loc) throw ();
extern wchar_t *wcpcpy (wchar_t *__dest, __const wchar_t *__src) throw ();
extern wchar_t *wcpncpy (wchar_t *__dest, __const wchar_t *__src, size_t __n)
     throw ();
extern __FILE *open_wmemstream (wchar_t **__bufloc, size_t *__sizeloc) throw ();
extern int fwide (__FILE *__fp, int __mode) throw ();
extern int fwprintf (__FILE *__restrict __stream,
       __const wchar_t *__restrict __format, ...)
                                                           ;
extern int wprintf (__const wchar_t *__restrict __format, ...)
                                                           ;
extern int swprintf (wchar_t *__restrict __s, size_t __n,
       __const wchar_t *__restrict __format, ...)
     throw () ;
extern int vfwprintf (__FILE *__restrict __s,
        __const wchar_t *__restrict __format,
        __gnuc_va_list __arg)
                                                           ;
extern int vwprintf (__const wchar_t *__restrict __format,
       __gnuc_va_list __arg)
                                                           ;
extern int vswprintf (wchar_t *__restrict __s, size_t __n,
        __const wchar_t *__restrict __format,
        __gnuc_va_list __arg)
     throw () ;
extern int fwscanf (__FILE *__restrict __stream,
      __const wchar_t *__restrict __format, ...)
                                                          ;
extern int wscanf (__const wchar_t *__restrict __format, ...)
                                                          ;
extern int swscanf (__const wchar_t *__restrict __s,
      __const wchar_t *__restrict __format, ...)
     throw () ;
extern int vfwscanf (__FILE *__restrict __s,
       __const wchar_t *__restrict __format,
       __gnuc_va_list __arg)
                                                          ;
extern int vwscanf (__const wchar_t *__restrict __format,
      __gnuc_va_list __arg)
                                                          ;
extern int vswscanf (__const wchar_t *__restrict __s,
       __const wchar_t *__restrict __format,
       __gnuc_va_list __arg)
     throw () ;
extern wint_t fgetwc (__FILE *__stream);
extern wint_t getwc (__FILE *__stream);
extern wint_t getwchar (void);
extern wint_t fputwc (wchar_t __wc, __FILE *__stream);
extern wint_t putwc (wchar_t __wc, __FILE *__stream);
extern wint_t putwchar (wchar_t __wc);
extern wchar_t *fgetws (wchar_t *__restrict __ws, int __n,
   __FILE *__restrict __stream);
extern int fputws (__const wchar_t *__restrict __ws,
     __FILE *__restrict __stream);
extern wint_t ungetwc (wint_t __wc, __FILE *__stream);
extern wint_t getwc_unlocked (__FILE *__stream);
extern wint_t getwchar_unlocked (void);
extern wint_t fgetwc_unlocked (__FILE *__stream);
extern wint_t fputwc_unlocked (wchar_t __wc, __FILE *__stream);
extern wint_t putwc_unlocked (wchar_t __wc, __FILE *__stream);
extern wint_t putwchar_unlocked (wchar_t __wc);
extern wchar_t *fgetws_unlocked (wchar_t *__restrict __ws, int __n,
     __FILE *__restrict __stream);
extern int fputws_unlocked (__const wchar_t *__restrict __ws,
       __FILE *__restrict __stream);
extern size_t wcsftime (wchar_t *__restrict __s, size_t __maxsize,
   __const wchar_t *__restrict __format,
   __const struct tm *__restrict __tp) throw ();
extern size_t wcsftime_l (wchar_t *__restrict __s, size_t __maxsize,
     __const wchar_t *__restrict __format,
     __const struct tm *__restrict __tp,
     __locale_t __loc) throw ();
}
namespace std __attribute__ ((__visibility__ ("default"))) {
  using ::mbstate_t;
}
namespace std __attribute__ ((__visibility__ ("default"))) {
  using ::wint_t;
  using ::btowc;
  using ::fgetwc;
  using ::fgetws;
  using ::fputwc;
  using ::fputws;
  using ::fwide;
  using ::fwprintf;
  using ::fwscanf;
  using ::getwc;
  using ::getwchar;
  using ::mbrlen;
  using ::mbrtowc;
  using ::mbsinit;
  using ::mbsrtowcs;
  using ::putwc;
  using ::putwchar;
  using ::swprintf;
  using ::swscanf;
  using ::ungetwc;
  using ::vfwprintf;
  using ::vfwscanf;
  using ::vswprintf;
  using ::vswscanf;
  using ::vwprintf;
  using ::vwscanf;
  using ::wcrtomb;
  using ::wcscat;
  using ::wcscmp;
  using ::wcscoll;
  using ::wcscpy;
  using ::wcscspn;
  using ::wcsftime;
  using ::wcslen;
  using ::wcsncat;
  using ::wcsncmp;
  using ::wcsncpy;
  using ::wcsrtombs;
  using ::wcsspn;
  using ::wcstod;
  using ::wcstof;
  using ::wcstok;
  using ::wcstol;
  using ::wcstoul;
  using ::wcsxfrm;
  using ::wctob;
  using ::wmemcmp;
  using ::wmemcpy;
  using ::wmemmove;
  using ::wmemset;
  using ::wprintf;
  using ::wscanf;
  using ::wcschr;
  using ::wcspbrk;
  using ::wcsrchr;
  using ::wcsstr;
  using ::wmemchr;
  inline wchar_t*
  wcschr(wchar_t* __p, wchar_t __c)
  { return wcschr(const_cast<const wchar_t*>(__p), __c); }
  inline wchar_t*
  wcspbrk(wchar_t* __s1, const wchar_t* __s2)
  { return wcspbrk(const_cast<const wchar_t*>(__s1), __s2); }
  inline wchar_t*
  wcsrchr(wchar_t* __p, wchar_t __c)
  { return wcsrchr(const_cast<const wchar_t*>(__p), __c); }
  inline wchar_t*
  wcsstr(wchar_t* __s1, const wchar_t* __s2)
  { return wcsstr(const_cast<const wchar_t*>(__s1), __s2); }
  inline wchar_t*
  wmemchr(wchar_t* __p, wchar_t __c, size_t __n)
  { return wmemchr(const_cast<const wchar_t*>(__p), __c, __n); }
}
namespace __gnu_cxx __attribute__ ((__visibility__ ("default"))) {
  using ::wcstold;
  using ::wcstoll;
  using ::wcstoull;
}
namespace std __attribute__ ((__visibility__ ("default"))) {
  using ::__gnu_cxx::wcstold;
  using ::__gnu_cxx::wcstoll;
  using ::__gnu_cxx::wcstoull;
}
namespace std
{
  using std::wcstof;
  using std::vfwscanf;
  using std::vswscanf;
  using std::vwscanf;
  using std::wcstold;
  using std::wcstoll;
  using std::wcstoull;
}
namespace stlp_std {
using ::wint_t;
using std::size_t;
using std::mbstate_t;
using std::fgetwc;
using std::fgetws;
using std::fputwc;
using std::fputws;
using std::fwide;
using std::fwprintf;
using std::fwscanf;
using std::getwchar;
using std::getwc;
using std::ungetwc;
using std::putwc;
using std::putwchar;
using std::swprintf;
using std::vswprintf;
using std::swscanf;
using std::vfwprintf;
using std::vwprintf;
using std::wcsftime;
using std::wcstok;
using std::wcscoll;
using std::wcsxfrm;
using std::wcscat;
using std::wcsrchr;
using std::wcscmp;
using std::wcscpy;
using std::wcscspn;
using std::wcslen;
using std::wcsncat;
using std::wcsncmp;
using std::wcsncpy;
using std::wcspbrk;
using std::wcschr;
using std::wcsspn;
using std::wcstod;
using std::wcstol;
using std::wcsstr;
using std::wmemchr;
using std::wctob;
using std::wmemcmp;
using std::wmemmove;
using std::wprintf;
using std::wscanf;
using std::wmemcpy;
using std::wmemset;
}
namespace stlp_std {
template <class _Tp> class allocator;
typedef off64_t streamoff;
typedef ptrdiff_t streamsize;
template <class _StateT> class fpos {
public:
  fpos(streamoff __pos) : _M_pos(__pos), _M_st(_StateT()) {}
  fpos() : _M_pos(0), _M_st(_StateT()) {}
  operator streamoff() const { return _M_pos; }
  bool operator==(const fpos& __y) const
  { return _M_pos == __y._M_pos; }
  bool operator!=(const fpos& __y) const
  { return _M_pos != __y._M_pos; }
  fpos& operator+=(streamoff __off) {
    _M_pos += __off;
    return *this;
  }
  fpos& operator-=(streamoff __off) {
    _M_pos -= __off;
    return *this;
  }
  fpos operator+(streamoff __off) {
    fpos __tmp(*this);
    __tmp += __off;
    return __tmp;
  }
  fpos operator-(streamoff __off) {
    fpos __tmp(*this);
    __tmp -= __off;
    return __tmp;
  }
public:
  _StateT state() const { return _M_st; }
  void state(_StateT __st) { _M_st = __st; }
private:
  streamoff _M_pos;
  _StateT _M_st;
};
typedef fpos<mbstate_t> streampos;
typedef fpos<mbstate_t> wstreampos;
template <class _CharT, class _IntT>
class __char_traits_base {
public:
  typedef _CharT char_type;
  typedef _IntT int_type;
  typedef streamoff off_type;
  typedef streampos pos_type;
  typedef mbstate_t state_type;
  static void assign(char_type& __c1, const char_type& __c2) { __c1 = __c2; }
  static bool eq(const char_type& __c1, const char_type& __c2)
  { return __c1 == __c2; }
  static bool lt(const char_type& __c1, const char_type& __c2)
  { return __c1 < __c2; }
  static int compare(const char_type* __s1, const char_type* __s2, size_t __n) {
    for (size_t __i = 0; __i < __n; ++__i)
      if (!eq(__s1[__i], __s2[__i]))
        return __s1[__i] < __s2[__i] ? -1 : 1;
    return 0;
  }
  static size_t length(const char_type* __s) {
    const char_type _NullChar = char_type();
    size_t __i(0);
    for (; !eq(__s[__i], _NullChar); ++__i) {}
    return __i;
  }
  static const char_type* find(const char_type* __s, size_t __n, const char_type& __c) {
    for ( ; __n > 0 ; ++__s, --__n)
      if (eq(*__s, __c))
        return __s;
    return 0;
  }
  static char_type* move(char_type* __s1, const char_type* __s2, size_t _Sz)
  { return (_Sz == 0 ? __s1 : (char_type*)memmove(__s1, __s2, _Sz * sizeof(char_type))); }
  static char_type* copy(char_type* __s1, const char_type* __s2, size_t __n) {
    return (__n == 0 ? __s1 :
      (char_type*)memcpy(__s1, __s2, __n * sizeof(char_type)));
  }
  static char_type* assign(char_type* __s, size_t __n, char_type __c) {
    for (size_t __i = 0; __i < __n; ++__i)
      __s[__i] = __c;
    return __s;
  }
  static int_type not_eof(const int_type& __c)
  { return !eq_int_type(__c, eof()) ? __c : static_cast<int_type>(0); }
  static char_type to_char_type(const int_type& __c)
  { return (char_type)__c; }
  static int_type to_int_type(const char_type& __c)
  { return (int_type)__c; }
  static bool eq_int_type(const int_type& __c1, const int_type& __c2)
  { return __c1 == __c2; }
  static int_type eof()
  { return (int_type)-1; }
};
template <class _CharT>
class char_traits
  : public __char_traits_base<_CharT, _CharT> {};
template<>
class __attribute__((visibility("default"))) char_traits<char>
  : public __char_traits_base<char, int>,
    public __stlport_class<char_traits<char> > {
public:
  typedef char char_type;
  typedef int int_type;
  typedef streamoff off_type;
  typedef streampos pos_type;
  typedef mbstate_t state_type;
  static char to_char_type(const int& __c)
  { return (char)(unsigned char)__c; }
  static int to_int_type(const char& __c)
  { return (unsigned char)__c; }
  static int compare(const char* __s1, const char* __s2, size_t __n)
  { return memcmp(__s1, __s2, __n); }
  static size_t length(const char* __s)
  { return strlen(__s); }
  static void assign(char& __c1, const char& __c2)
  { __c1 = __c2; }
  static char* assign(char* __s, size_t __n, char __c) {
    memset(__s, __c, __n);
    return __s;
  }
};
template<>
class __attribute__((visibility("default"))) char_traits<wchar_t>
  : public __char_traits_base<wchar_t, wint_t> {
public:
  static wchar_t* move(wchar_t* __dest, const wchar_t* __src, size_t __n)
  { return wmemmove(__dest, __src, __n); }
  static wchar_t* copy(wchar_t* __dest, const wchar_t* __src, size_t __n)
  { return wmemcpy(__dest, __src, __n); }
  static int compare(const wchar_t* __s1, const wchar_t* __s2, size_t __n)
  { return wmemcmp(__s1, __s2, __n); }
  static wchar_t* assign(wchar_t* __s, size_t __n, wchar_t __c)
  { return wmemset(__s, __c, __n); }
  static size_t length(const wchar_t* __s)
  { return wcslen(__s); }
  static void assign(wchar_t& __c1, const wchar_t& __c2)
  { __c1 = __c2; }
};
}
namespace stlp_std {
class ios_base;
template <class _CharT, class _Traits = char_traits<_CharT> >
class basic_ios;
template <class _CharT, class _Traits = char_traits<_CharT> >
class basic_streambuf;
template <class _CharT, class _Traits = char_traits<_CharT> >
class basic_istream;
template <class _CharT, class _Traits = char_traits<_CharT> >
class basic_ostream;
template <class _CharT, class _Traits = char_traits<_CharT> >
class basic_iostream;
template <class _CharT, class _Traits = char_traits<_CharT>,
          class _Allocator = allocator<_CharT> >
class basic_stringbuf;
template <class _CharT, class _Traits = char_traits<_CharT>,
          class _Allocator = allocator<_CharT> >
class basic_istringstream;
template <class _CharT, class _Traits = char_traits<_CharT>,
          class _Allocator = allocator<_CharT> >
class basic_ostringstream;
template <class _CharT, class _Traits = char_traits<_CharT>,
          class _Allocator = allocator<_CharT> >
class basic_stringstream;
template <class _CharT, class _Traits = char_traits<_CharT> >
class basic_filebuf;
template <class _CharT, class _Traits = char_traits<_CharT> >
class basic_ifstream;
template <class _CharT, class _Traits = char_traits<_CharT> >
class basic_ofstream;
template <class _CharT, class _Traits = char_traits<_CharT> >
class basic_fstream;
template <class _CharT, class _Traits = char_traits<_CharT> >
class istreambuf_iterator;
template <class _CharT, class _Traits = char_traits<_CharT> >
class ostreambuf_iterator;
typedef basic_ios<char, char_traits<char> > ios;
typedef basic_ios<wchar_t, char_traits<wchar_t> > wios;
class locale;
template <class _Facet>
inline const _Facet& use_facet(const locale&);
template <class _CharT> class ctype;
template <class _CharT> class ctype_byname;
template <class _CharT> class collate;
template <class _CharT> class collate_byname;
template<> class ctype<char>;
template<> class ctype_byname<char>;
template<> class collate<char>;
template<> class collate_byname<char>;
template<> class ctype<wchar_t>;
template<> class ctype_byname<wchar_t>;
template<> class collate<wchar_t>;
template<> class collate_byname<wchar_t>;
typedef basic_istream<char, char_traits<char> > istream;
typedef basic_ostream<char, char_traits<char> > ostream;
typedef basic_iostream<char, char_traits<char> > iostream;
typedef basic_streambuf<char,char_traits<char> > streambuf;
typedef basic_stringbuf<char, char_traits<char>, allocator<char> > stringbuf;
typedef basic_istringstream<char, char_traits<char>, allocator<char> > istringstream;
typedef basic_ostringstream<char, char_traits<char>, allocator<char> > ostringstream;
typedef basic_stringstream<char, char_traits<char>, allocator<char> > stringstream;
typedef basic_filebuf<char, char_traits<char> > filebuf;
typedef basic_ifstream<char, char_traits<char> > ifstream;
typedef basic_ofstream<char, char_traits<char> > ofstream;
typedef basic_fstream<char, char_traits<char> > fstream;
typedef basic_streambuf<wchar_t, char_traits<wchar_t> > wstreambuf;
typedef basic_istream<wchar_t, char_traits<wchar_t> > wistream;
typedef basic_ostream<wchar_t, char_traits<wchar_t> > wostream;
typedef basic_iostream<wchar_t, char_traits<wchar_t> > wiostream;
typedef basic_stringbuf<wchar_t, char_traits<wchar_t>, allocator<wchar_t> > wstringbuf;
typedef basic_istringstream<wchar_t, char_traits<wchar_t>, allocator<wchar_t> > wistringstream;
typedef basic_ostringstream<wchar_t, char_traits<wchar_t>, allocator<wchar_t> > wostringstream;
typedef basic_stringstream<wchar_t, char_traits<wchar_t>, allocator<wchar_t> > wstringstream;
typedef basic_filebuf<wchar_t, char_traits<wchar_t> > wfilebuf;
typedef basic_ifstream<wchar_t, char_traits<wchar_t> > wifstream;
typedef basic_ofstream<wchar_t, char_traits<wchar_t> > wofstream;
typedef basic_fstream<wchar_t, char_traits<wchar_t> > wfstream;
}
namespace stlp_std {
template <class _CharT,
          class _Traits = char_traits<_CharT>,
          class _Alloc = allocator<_CharT> >
class basic_string;
typedef basic_string<char, char_traits<char>, allocator<char> > string;
typedef basic_string<wchar_t, char_traits<wchar_t>, allocator<wchar_t> > wstring;
namespace priv {
const char* __get_c_string(const string& __str);
}
}
namespace stlp_std {
namespace priv {
template <class _InputIter, class _OutputIter, class _Distance>
inline _OutputIter __ucopy(_InputIter __first, _InputIter __last,
                           _OutputIter __result, _Distance*) {
  _OutputIter __cur = __result;
  try {
    for ( ; __first != __last; ++__first, ++__cur)
      _Param_Construct(&*__cur, *__first);
    return __cur;
  }
  catch(...) { ::stlp_std::_Destroy_Range(__result, __cur); throw; }
 
}
template <class _InputIter, class _OutputIter, class _Distance>
inline _OutputIter __ucopy(_InputIter __first, _InputIter __last,
                           _OutputIter __result, const input_iterator_tag &, _Distance* __d)
{ return __ucopy(__first, __last, __result, __d); }
template <class _RandomAccessIter, class _OutputIter, class _Distance>
inline _OutputIter __ucopy(_RandomAccessIter __first, _RandomAccessIter __last,
                           _OutputIter __result, const random_access_iterator_tag &, _Distance*) {
  _OutputIter __cur = __result;
  try {
    for (_Distance __n = __last - __first; __n > 0; --__n) {
      _Param_Construct(&*__cur, *__first);
      ++__first;
      ++__cur;
    }
    return __cur;
  }
  catch(...) { ::stlp_std::_Destroy_Range(__result, __cur); throw; }
 
}
template <class _RandomAccessIter, class _OutputIter>
inline _OutputIter __ucopy(_RandomAccessIter __first, _RandomAccessIter __last, _OutputIter __result)
{ return __ucopy(__first, __last, __result, random_access_iterator_tag(), (ptrdiff_t*)0); }
inline void*
__ucopy_trivial(const void* __first, const void* __last, void* __result) {
  return (__last == __first) ? __result :
    ((char*)memcpy(__result, __first, ((const char*)__last - (const char*)__first))) +
    ((const char*)__last - (const char*)__first);
}
template <class _InputIter, class _OutputIter>
inline _OutputIter __ucopy_ptrs(_InputIter __first, _InputIter __last, _OutputIter __result,
                                const __false_type& )
{ return __ucopy(__first, __last, __result, random_access_iterator_tag(), (ptrdiff_t*)0); }
template <class _InputIter, class _OutputIter>
inline _OutputIter __ucopy_ptrs(_InputIter __first, _InputIter __last, _OutputIter __result,
                                const __true_type& ) {
  return (_OutputIter)__ucopy_trivial(__first, __last, __result);
}
template <class _InputIter, class _OutputIter>
inline _OutputIter __ucopy_aux(_InputIter __first, _InputIter __last, _OutputIter __result,
                               const __true_type& ) {
  return __ucopy_ptrs(__first, __last, __result,
                      _UseTrivialUCopy((typename ::stlp_std::iterator_traits< _InputIter >::value_type*)0,
                                       (typename ::stlp_std::iterator_traits< _OutputIter >::value_type*)0)._Answer());
}
template <class _InputIter, class _OutputIter>
inline _OutputIter __ucopy_aux(_InputIter __first, _InputIter __last, _OutputIter __result,
                               const __false_type& ) {
  return __ucopy(__first, __last, __result,
                 typename ::stlp_std::iterator_traits< _InputIter >::iterator_category(),
                 (typename ::stlp_std::iterator_traits< _InputIter >::difference_type*)0);
}
}
template <class _InputIter, class _ForwardIter>
inline _ForwardIter
uninitialized_copy(_InputIter __first, _InputIter __last, _ForwardIter __result)
{ return ::stlp_std::priv:: __ucopy_aux(__first, __last, __result, _BothPtrType< _InputIter, _ForwardIter>::_Answer()); }
inline char*
uninitialized_copy(const char* __first, const char* __last, char* __result)
{ return (char*)::stlp_std::priv:: __ucopy_trivial(__first, __last, __result); }
inline wchar_t*
uninitialized_copy(const wchar_t* __first, const wchar_t* __last, wchar_t* __result)
{ return (wchar_t*)::stlp_std::priv:: __ucopy_trivial (__first, __last, __result); }
namespace priv {
template <class _InputIter, class _Size, class _ForwardIter>
inline
pair<_InputIter, _ForwardIter>
__ucopy_n(_InputIter __first, _Size __count, _ForwardIter __result,
          const input_iterator_tag &) {
  _ForwardIter __cur = __result;
  try {
    for ( ; __count > 0 ; --__count, ++__first, ++__cur)
      _Param_Construct(&*__cur, *__first);
    return pair<_InputIter, _ForwardIter>(__first, __cur);
  }
  catch(...) { ::stlp_std::_Destroy_Range(__result, __cur); throw; }
 
}
template <class _RandomAccessIter, class _Size, class _ForwardIter>
inline pair<_RandomAccessIter, _ForwardIter>
__ucopy_n(_RandomAccessIter __first, _Size __count, _ForwardIter __result,
                       const random_access_iterator_tag &) {
  _RandomAccessIter __last = __first + __count;
  return pair<_RandomAccessIter, _ForwardIter>(__last, uninitialized_copy(__first, __last, __result));
}
template <class _InputIter, class _Size, class _ForwardIter>
inline pair<_InputIter, _ForwardIter>
__ucopy_n(_InputIter __first, _Size __count, _ForwardIter __result)
{ return ::stlp_std::priv:: __ucopy_n(__first, __count, __result, typename ::stlp_std::iterator_traits< _InputIter >::iterator_category()); }
}
template <class _InputIter, class _Size, class _ForwardIter>
inline pair<_InputIter, _ForwardIter>
uninitialized_copy_n(_InputIter __first, _Size __count, _ForwardIter __result)
{ return ::stlp_std::priv:: __ucopy_n(__first, __count, __result); }
namespace priv {
template <class _ForwardIter, class _Tp, class _Distance>
inline void __ufill(_ForwardIter __first, _ForwardIter __last, const _Tp& __x, _Distance*) {
  _ForwardIter __cur = __first;
  try {
    for ( ; __cur != __last; ++__cur)
      _Param_Construct(&*__cur, __x);
  }
  catch(...) { ::stlp_std::_Destroy_Range(__first, __cur); throw; }
}
template <class _ForwardIter, class _Tp, class _Distance>
inline void __ufill(_ForwardIter __first, _ForwardIter __last,
                    const _Tp& __x, const input_iterator_tag &, _Distance* __d)
{ __ufill(__first, __last, __x, __d); }
template <class _ForwardIter, class _Tp, class _Distance>
inline void __ufill(_ForwardIter __first, _ForwardIter __last,
                    const _Tp& __x, const random_access_iterator_tag &, _Distance*) {
  _ForwardIter __cur = __first;
  try {
    for (_Distance __n = __last - __first; __n > 0; --__n, ++__cur)
      _Param_Construct(&*__cur, __x);
  }
  catch(...) { ::stlp_std::_Destroy_Range(__first, __cur); throw; }
}
}
template <class _ForwardIter, class _Tp>
inline void uninitialized_fill(_ForwardIter __first, _ForwardIter __last, const _Tp& __x) {
  ::stlp_std::priv:: __ufill(__first, __last, __x,
                     typename ::stlp_std::iterator_traits< _ForwardIter >::iterator_category(),
                     (typename ::stlp_std::iterator_traits< _ForwardIter >::difference_type*)0);
}
inline void uninitialized_fill(unsigned char* __first, unsigned char* __last,
                               const unsigned char& __val) {
  unsigned char __tmp = __val;
  memset(__first, __tmp, __last - __first);
}
inline void uninitialized_fill(signed char* __first, signed char* __last,
                               const signed char& __val) {
  signed char __tmp = __val;
  memset(__first, static_cast<unsigned char>(__tmp), __last - __first);
}
inline void uninitialized_fill(char* __first, char* __last, const char& __val) {
  char __tmp = __val;
  memset(__first, static_cast<unsigned char>(__tmp), __last - __first);
}
namespace priv {
template <class _ForwardIter, class _Size, class _Tp>
inline _ForwardIter __ufill_n(_ForwardIter __first, _Size __n, const _Tp& __x) {
  _ForwardIter __cur = __first;
  try {
    for ( ; __n > 0; --__n, ++__cur)
      _Param_Construct(&*__cur, __x);
  }
  catch(...) { ::stlp_std::_Destroy_Range(__first, __cur); throw; }
  return __cur;
}
template <class _ForwardIter, class _Size, class _Tp>
inline _ForwardIter __ufill_n(_ForwardIter __first, _Size __n, const _Tp& __x,
                              const input_iterator_tag &)
{ return __ufill_n(__first, __n, __x); }
template <class _ForwardIter, class _Size, class _Tp>
inline _ForwardIter __uninitialized_fill_n(_ForwardIter __first, _Size __n, const _Tp& __x) {
  _ForwardIter __last = __first + __n;
  __ufill(__first, __last, __x, random_access_iterator_tag(), (ptrdiff_t*)0);
  return __last;
}
template <class _ForwardIter, class _Size, class _Tp>
inline _ForwardIter __ufill_n(_ForwardIter __first, _Size __n, const _Tp& __x,
                              const random_access_iterator_tag &)
{ return __uninitialized_fill_n(__first, __n, __x); }
template <class _ForwardIter, class _Size, class _Tp>
inline _ForwardIter __uinit_aux_aux(_ForwardIter __first, _Size __n, const _Tp& __val,
                                    const __false_type& )
{ return __uninitialized_fill_n(__first, __n, __val); }
template <class _ForwardIter, class _Size, class _Tp>
inline _ForwardIter __uinit_aux_aux(_ForwardIter __first, _Size __n, const _Tp& ,
                                    const __true_type& ) {
  memset((unsigned char*)__first, 0, __n * sizeof(_Tp));
  return __first + __n;
}
template <class _ForwardIter, class _Size, class _Tp>
inline _ForwardIter __uinit_aux(_ForwardIter __first, _Size __n, const _Tp&,
                                const __true_type& )
{ return __first + __n; }
template <class _ForwardIter, class _Size, class _Tp>
inline _ForwardIter __uinit_aux(_ForwardIter __first, _Size __n, const _Tp& __val,
                                const __false_type& )
{ return __uinit_aux_aux(__first, __n, __val, _HasDefaultZeroValue(__first)._Answer()); }
template <class _ForwardIter, class _Size, class _Tp>
inline _ForwardIter __uninitialized_init(_ForwardIter __first, _Size __n, const _Tp& __val)
{ return __uinit_aux(__first, __n, __val, _UseTrivialInit(__first)._Answer()); }
}
template <class _ForwardIter, class _Size, class _Tp>
inline void
uninitialized_fill_n(_ForwardIter __first, _Size __n, const _Tp& __x)
{ ::stlp_std::priv:: __ufill_n(__first, __n, __x, typename ::stlp_std::iterator_traits< _ForwardIter >::iterator_category()); }
namespace priv {
template <class _InputIter1, class _InputIter2, class _ForwardIter>
inline _ForwardIter
__uninitialized_copy_copy(_InputIter1 __first1, _InputIter1 __last1,
                          _InputIter2 __first2, _InputIter2 __last2,
                          _ForwardIter __result) {
  _ForwardIter __new_result = uninitialized_copy(__first1, __last1, __result);
  try {
    return uninitialized_copy(__first2, __last2, __new_result);
  }
  catch(...) { ::stlp_std::_Destroy_Range(__result, __new_result); throw; }
 
}
template <class _ForwardIter, class _Tp, class _InputIter>
inline _ForwardIter
__uninitialized_fill_copy(_ForwardIter __result, _ForwardIter __mid, const _Tp& __x,
                          _InputIter __first, _InputIter __last) {
  uninitialized_fill(__result, __mid, __x);
  try {
    return uninitialized_copy(__first, __last, __mid);
  }
  catch(...) { ::stlp_std::_Destroy_Range(__result, __mid); throw; }
 
}
template <class _Iter, class _Tp>
inline void
__uninitialized_copy_fill(_Iter __first1, _Iter __last1, _Iter __first2, _Iter __last2,
                          const _Tp& __x) {
  _Iter __mid2 = uninitialized_copy(__first1, __last1, __first2);
  try {
    uninitialized_fill(__mid2, __last2, __x);
  }
  catch(...) { ::stlp_std::_Destroy_Range(__first2, __mid2); throw; }
}
template <class _InputIter, class _ForwardIter, class _TrivialUCpy>
inline _ForwardIter
__uninitialized_move(_InputIter __first, _InputIter __last, _ForwardIter __result,
                     _TrivialUCpy __trivial_ucpy, const __false_type& )
{ return __ucopy_ptrs(__first, __last, __result, __trivial_ucpy); }
template <class _InputIter, class _ForwardIter, class _TrivialUCpy>
inline
_ForwardIter
__uninitialized_move(_InputIter __first, _InputIter __last, _ForwardIter __result,
                     _TrivialUCpy , const __true_type& ) {
  for (ptrdiff_t __n = __last - __first ; __n > 0; --__n) {
    _Move_Construct(&*__result, *__first);
    ++__first; ++__result;
  }
  return __result;
}
}
}
namespace stlp_std {
namespace priv {
template <class _Tp, class _Alloc>
class _String_base {
    typedef _String_base<_Tp, _Alloc> _Self;
protected:
 
public:
  enum {_DEFAULT_SIZE = 8};
  typedef _Alloc allocator_type;
  typedef _STLP_alloc_proxy<_Tp*, _Tp, allocator_type> _AllocProxy;
  typedef size_t size_type;
private:
  union _Buffers {
    _Tp* _M_end_of_storage;
    _Tp _M_static_buf[_DEFAULT_SIZE];
  } _M_buffers;
protected:
  bool _M_using_static_buf() const
  { return (_M_start_of_storage._M_data == _M_buffers._M_static_buf); }
  _Tp const* _M_Start() const { return _M_start_of_storage._M_data; }
  _Tp* _M_Start() { return _M_start_of_storage._M_data; }
  _Tp const* _M_End() const
  { return _M_using_static_buf() ? _M_buffers._M_static_buf + _DEFAULT_SIZE : _M_buffers._M_end_of_storage; }
  _Tp* _M_End()
  { return _M_using_static_buf() ? _M_buffers._M_static_buf + _DEFAULT_SIZE : _M_buffers._M_end_of_storage; }
  size_type _M_capacity() const
  { return _M_using_static_buf() ? _DEFAULT_SIZE : _M_buffers._M_end_of_storage - _M_start_of_storage._M_data; }
  size_type _M_rest() const
  { return _M_using_static_buf() ? _DEFAULT_SIZE - (_M_finish - _M_buffers._M_static_buf) : _M_buffers._M_end_of_storage - _M_finish; }
  _Tp* _M_finish;
  _AllocProxy _M_start_of_storage;
  _Tp const* _M_Finish() const {return _M_finish;}
  _Tp* _M_Finish() {return _M_finish;}
  void _M_allocate_block(size_t __n = _DEFAULT_SIZE);
  void _M_deallocate_block() {
    if (!_M_using_static_buf() && (_M_start_of_storage._M_data != 0))
      _M_start_of_storage.deallocate(_M_start_of_storage._M_data, _M_buffers._M_end_of_storage - _M_start_of_storage._M_data);
  }
  size_t max_size() const {
    const size_type __string_max_size = size_type(-1) / sizeof(_Tp);
    typename allocator_type::size_type __alloc_max_size = _M_start_of_storage.max_size();
    return (min)(__alloc_max_size, __string_max_size) - 1;
  }
  _String_base(const allocator_type& __a)
    : _M_finish(_M_buffers._M_static_buf), _M_start_of_storage(__a, _M_buffers._M_static_buf)
    {}
  _String_base(const allocator_type& __a, size_t __n)
    : _M_finish(_M_buffers._M_static_buf), _M_start_of_storage(__a, _M_buffers._M_static_buf) {
      _M_allocate_block(__n);
    }
  void _M_move_src (_Self &src) {
    if (src._M_using_static_buf()) {
      _M_buffers = src._M_buffers;
      _M_finish = _M_buffers._M_static_buf + (src._M_finish - src._M_start_of_storage._M_data);
      _M_start_of_storage._M_data = _M_buffers._M_static_buf;
    }
    else {
      _M_start_of_storage._M_data = src._M_start_of_storage._M_data;
      _M_finish = src._M_finish;
      _M_buffers._M_end_of_storage = src._M_buffers._M_end_of_storage;
      src._M_start_of_storage._M_data = 0;
    }
  }
  _String_base(__move_source<_Self> src)
    : _M_start_of_storage(__move_source<_AllocProxy>(src.get()._M_start_of_storage)) {
      _M_move_src(src.get());
    }
  ~_String_base() { _M_deallocate_block(); }
  void _M_reset(_Tp *__start, _Tp *__finish, _Tp *__end_of_storage) {
    _M_buffers._M_end_of_storage = __end_of_storage;
    _M_finish = __finish;
    _M_start_of_storage._M_data = __start;
  }
  void _M_swap(_Self &__s) {
    if (_M_using_static_buf()) {
      if (__s._M_using_static_buf()) {
        ::stlp_std::swap(_M_buffers, __s._M_buffers);
        _Tp *__tmp = _M_finish;
        _M_finish = _M_start_of_storage._M_data + (__s._M_finish - __s._M_start_of_storage._M_data);
        __s._M_finish = __s._M_buffers._M_static_buf + (__tmp - _M_start_of_storage._M_data);
        _M_start_of_storage.swap(__s._M_start_of_storage);
        _M_start_of_storage._M_data = _M_buffers._M_static_buf;
        __s._M_start_of_storage._M_data = __s._M_buffers._M_static_buf;
      } else {
        __s._M_swap(*this);
        return;
      }
    }
    else if (__s._M_using_static_buf()) {
      _Tp *__tmp = _M_start_of_storage._M_data;
      _Tp *__tmp_finish = _M_finish;
      _Tp *__tmp_end_data = _M_buffers._M_end_of_storage;
      _M_buffers = __s._M_buffers;
      _M_start_of_storage.swap(__s._M_start_of_storage);
      _M_start_of_storage._M_data = _M_buffers._M_static_buf;
      _M_finish = _M_buffers._M_static_buf + (__s._M_finish - __s._M_buffers._M_static_buf);
      __s._M_buffers._M_end_of_storage = __tmp_end_data;
      __s._M_start_of_storage._M_data = __tmp;
      __s._M_finish = __tmp_finish;
    }
    else {
      ::stlp_std::swap(_M_buffers._M_end_of_storage, __s._M_buffers._M_end_of_storage);
      _M_start_of_storage.swap(__s._M_start_of_storage);
      ::stlp_std::swap(_M_finish, __s._M_finish);
    }
  }
  void __attribute__((noreturn)) _M_throw_length_error() const;
  void __attribute__((noreturn)) _M_throw_out_of_range() const;
};
}
}
namespace stlp_std {
namespace priv {
struct _String_reserve_t {};
}
template <class _CharT, class _Traits, class _Alloc>
class basic_string : private ::stlp_std::priv:: _String_base<_CharT,_Alloc>
{
private:
  typedef ::stlp_std::priv:: _String_base<_CharT,_Alloc> _Base;
  typedef basic_string<_CharT, _Traits, _Alloc> _Self;
public:
  typedef _CharT value_type;
  typedef _Traits traits_type;
  typedef value_type* pointer;
  typedef const value_type* const_pointer;
  typedef value_type& reference;
  typedef const value_type& const_reference;
  typedef typename _Base::size_type size_type;
  typedef ptrdiff_t difference_type;
  typedef random_access_iterator_tag _Iterator_category;
  typedef const value_type* const_iterator;
  typedef value_type* iterator;
  typedef ::stlp_std::reverse_iterator<const_iterator> const_reverse_iterator; typedef ::stlp_std::reverse_iterator<iterator> reverse_iterator;
  static const size_t npos = ~(size_t)0;
  typedef ::stlp_std::priv:: _String_reserve_t _Reserve_t;
public:
  typedef typename _Base::allocator_type allocator_type;
  allocator_type get_allocator() const
  { return (const allocator_type&)this->_M_start_of_storage; }
  explicit basic_string(const allocator_type& __a = allocator_type())
      : ::stlp_std::priv:: _String_base<_CharT,_Alloc>(__a, _Base::_DEFAULT_SIZE)
  { _M_terminate_string(); }
  basic_string(_Reserve_t, size_t __n,
               const allocator_type& __a = allocator_type())
    : ::stlp_std::priv:: _String_base<_CharT,_Alloc>(__a, __n + 1)
  { _M_terminate_string(); }
  basic_string(const _Self&);
  basic_string(const _Self& __s, size_type __pos, size_type __n = npos,
               const allocator_type& __a = allocator_type())
    : ::stlp_std::priv:: _String_base<_CharT,_Alloc>(__a) {
    if (__pos > __s.size())
      this->_M_throw_out_of_range();
    else
      _M_range_initialize(__s._M_Start() + __pos,
                          __s._M_Start() + __pos + (min) (__n, __s.size() - __pos));
  }
  basic_string(const _CharT* __s, size_type __n,
               const allocator_type& __a = allocator_type())
    : ::stlp_std::priv:: _String_base<_CharT,_Alloc>(__a) {
     
      _M_range_initialize(__s, __s + __n);
    }
  basic_string(const _CharT* __s,
               const allocator_type& __a = allocator_type());
  basic_string(size_type __n, _CharT __c,
               const allocator_type& __a = allocator_type())
    : ::stlp_std::priv:: _String_base<_CharT,_Alloc>(__a, __n + 1) {
    this->_M_finish = ::stlp_std::priv:: __uninitialized_fill_n(this->_M_Start(), __n, __c);
    _M_terminate_string();
  }
  basic_string(__move_source<_Self> src)
    : ::stlp_std::priv:: _String_base<_CharT,_Alloc>(__move_source<_Base>(src.get())) {}
  template <class _InputIterator>
  basic_string(_InputIterator __f, _InputIterator __l,
               const allocator_type & __a = allocator_type())
    : ::stlp_std::priv:: _String_base<_CharT,_Alloc>(__a) {
    typedef typename _IsIntegral<_InputIterator>::_Ret _Integral;
    _M_initialize_dispatch(__f, __l, _Integral());
  }
private:
  size_type _M_compute_next_size(size_type __n) {
    const size_type __size = size();
    if (__n > max_size() - __size)
      this->_M_throw_length_error();
    size_type __len = __size + (max)(__n, __size) + 1;
    if (__len > max_size() || __len < __size)
      __len = max_size();
    return __len;
  }
  template <class _InputIter>
  void _M_range_initialize(_InputIter __f, _InputIter __l,
                           const input_iterator_tag &__tag) {
    this->_M_allocate_block();
    _M_construct_null(this->_M_Finish());
    _M_appendT(__f, __l, __tag);
  }
  template <class _ForwardIter>
  void _M_range_initialize(_ForwardIter __f, _ForwardIter __l,
                           const forward_iterator_tag &) {
    difference_type __n = ::stlp_std::distance(__f, __l);
    this->_M_allocate_block(__n + 1);
    this->_M_finish = uninitialized_copy(__f, __l, this->_M_Start());
    this->_M_terminate_string();
  }
  template <class _InputIter>
  void _M_range_initializeT(_InputIter __f, _InputIter __l) {
    _M_range_initialize(__f, __l, typename ::stlp_std::iterator_traits< _InputIter >::iterator_category());
  }
  template <class _Integer>
  void _M_initialize_dispatch(_Integer __n, _Integer __x, const __true_type& ) {
    this->_M_allocate_block(__n + 1);
    this->_M_finish = ::stlp_std::priv:: __uninitialized_fill_n(this->_M_Start(), __n, __x);
    this->_M_terminate_string();
  }
  template <class _InputIter>
  void _M_initialize_dispatch(_InputIter __f, _InputIter __l, const __false_type& ) {
    _M_range_initializeT(__f, __l);
  }
public:
  _Self& operator=(const _Self& __s) {
    if (&__s != this)
      _M_assign(__s._M_Start(), __s._M_Finish());
    return *this;
  }
  _Self& operator=(const _CharT* __s) {
   
    return _M_assign(__s, __s + traits_type::length(__s));
  }
  _Self& operator=(_CharT __c)
  { return assign(static_cast<size_type>(1), __c); }
private:
  static _CharT _M_null()
  { return _CharT(); }
private:
  void _M_construct_null(_CharT* __p) const
  { ::stlp_std::_Construct(__p); }
  void _M_terminate_string()
  { _M_construct_null(this->_M_Finish()); }
  bool _M_inside(const _CharT* __s) const {
   
    return (__s >= this->_M_Start()) && (__s < this->_M_Finish());
  }
  void _M_range_initialize(const _CharT* __f, const _CharT* __l) {
   
    ptrdiff_t __n = __l - __f;
    this->_M_allocate_block(__n + 1);
    this->_M_finish = uninitialized_copy(__f, __l, this->_M_Start());
    _M_terminate_string();
  }
public:
  iterator begin() { return this->_M_Start(); }
  iterator end() { return this->_M_Finish(); }
  const_iterator begin() const { return this->_M_Start(); }
  const_iterator end() const { return this->_M_Finish(); }
  reverse_iterator rbegin()
  { return reverse_iterator(this->_M_Finish()); }
  reverse_iterator rend()
  { return reverse_iterator(this->_M_Start()); }
  const_reverse_iterator rbegin() const
  { return const_reverse_iterator(this->_M_Finish()); }
  const_reverse_iterator rend() const
  { return const_reverse_iterator(this->_M_Start()); }
public:
  size_type size() const { return this->_M_Finish() - this->_M_Start(); }
  size_type length() const { return size(); }
  size_type max_size() const { return _Base::max_size(); }
  void resize(size_type __n, _CharT __c) {
    if (__n <= size())
      erase(begin() + __n, end());
    else
      append(__n - size(), __c);
  }
  void resize(size_type __n) { resize(__n, _M_null()); }
private:
  void _M_reserve(size_type);
public:
  void reserve(size_type = 0);
  size_type capacity() const
  { return this->_M_capacity() - 1; }
  void clear() {
    if (!empty()) {
      _Traits::assign(*(this->_M_Start()), _M_null());
      this->_M_finish = this->_M_Start();
    }
  }
  bool empty() const { return this->_M_Start() == this->_M_Finish(); }
public:
  const_reference operator[](size_type __n) const
  { return *(this->_M_Start() + __n); }
  reference operator[](size_type __n)
  { return *(this->_M_Start() + __n); }
  const_reference at(size_type __n) const {
    if (__n >= size())
      this->_M_throw_out_of_range();
    return *(this->_M_Start() + __n);
  }
  reference at(size_type __n) {
    if (__n >= size())
      this->_M_throw_out_of_range();
    return *(this->_M_Start() + __n);
  }
public:
  _Self& operator+=(const _Self& __s) { return append(__s); }
  _Self& operator+=(const _CharT* __s) { return append(__s); }
  _Self& operator+=(_CharT __c) { push_back(__c); return *this; }
private:
  _Self& _M_append(const _CharT* __first, const _CharT* __last);
  template <class _InputIter>
  _Self& _M_appendT(_InputIter __first, _InputIter __last,
                    const input_iterator_tag &) {
    for ( ; __first != __last ; ++__first)
      push_back(*__first);
    return *this;
  }
  template <class _ForwardIter>
  _Self& _M_appendT(_ForwardIter __first, _ForwardIter __last,
                    const forward_iterator_tag &) {
    if (__first != __last) {
      size_type __n = static_cast<size_type>(::stlp_std::distance(__first, __last));
      if (__n >= this->_M_rest()) {
        size_type __len = _M_compute_next_size(__n);
        pointer __new_start = this->_M_start_of_storage.allocate(__len, __len);
        pointer __new_finish = uninitialized_copy(this->_M_Start(), this->_M_Finish(), __new_start);
        __new_finish = uninitialized_copy(__first, __last, __new_finish);
        _M_construct_null(__new_finish);
        this->_M_deallocate_block();
        this->_M_reset(__new_start, __new_finish, __new_start + __len);
      }
      else {
        _Traits::assign(*this->_M_finish, *__first++);
        uninitialized_copy(__first, __last, this->_M_Finish() + 1);
        _M_construct_null(this->_M_Finish() + __n);
        this->_M_finish += __n;
      }
    }
    return *this;
  }
  template <class _Integer>
  _Self& _M_append_dispatch(_Integer __n, _Integer __x, const __true_type& )
  { return append((size_type) __n, (_CharT) __x); }
  template <class _InputIter>
  _Self& _M_append_dispatch(_InputIter __f, _InputIter __l, const __false_type& )
  { return _M_appendT(__f, __l, typename ::stlp_std::iterator_traits< _InputIter >::iterator_category()); }
public:
  template <class _InputIter>
  _Self& append(_InputIter __first, _InputIter __last) {
    typedef typename _IsIntegral<_InputIter>::_Ret _Integral;
    return _M_append_dispatch(__first, __last, _Integral());
  }
public:
  _Self& append(const _Self& __s)
  { return _M_append(__s._M_Start(), __s._M_Finish()); }
  _Self& append(const _Self& __s,
                size_type __pos, size_type __n) {
    if (__pos > __s.size())
      this->_M_throw_out_of_range();
    return _M_append(__s._M_Start() + __pos,
                     __s._M_Start() + __pos + (min) (__n, __s.size() - __pos));
  }
  _Self& append(const _CharT* __s, size_type __n)
  { return _M_append(__s, __s+__n); }
  _Self& append(const _CharT* __s)
  { return _M_append(__s, __s + traits_type::length(__s)); }
  _Self& append(size_type __n, _CharT __c);
public:
  void push_back(_CharT __c) {
    if (this->_M_rest() == 1 )
      _M_reserve(_M_compute_next_size(1));
    _M_construct_null(this->_M_Finish() + 1);
    _Traits::assign(*(this->_M_Finish()), __c);
    ++this->_M_finish;
  }
  void pop_back() {
    _Traits::assign(*(this->_M_Finish() - 1), _M_null());
    --this->_M_finish;
  }
public:
  _Self& assign(const _Self& __s)
  { return _M_assign(__s._M_Start(), __s._M_Finish()); }
  _Self& assign(const _Self& __s,
                size_type __pos, size_type __n) {
    if (__pos > __s.size())
      this->_M_throw_out_of_range();
    return _M_assign(__s._M_Start() + __pos,
                     __s._M_Start() + __pos + (min) (__n, __s.size() - __pos));
  }
  _Self& assign(const _CharT* __s, size_type __n)
  { return _M_assign(__s, __s + __n); }
  _Self& assign(const _CharT* __s)
  { return _M_assign(__s, __s + _Traits::length(__s)); }
  _Self& assign(size_type __n, _CharT __c);
private:
  _Self& _M_assign(const _CharT* __f, const _CharT* __l);
  template <class _Integer>
  _Self& _M_assign_dispatch(_Integer __n, _Integer __x, const __true_type& )
  { return assign((size_type) __n, (_CharT) __x); }
  template <class _InputIter>
  _Self& _M_assign_dispatch(_InputIter __f, _InputIter __l, const __false_type& ) {
    pointer __cur = this->_M_Start();
    while (__f != __l && __cur != this->_M_Finish()) {
      _Traits::assign(*__cur, *__f);
      ++__f;
      ++__cur;
    }
    if (__f == __l)
      erase(__cur, this->end());
    else
      _M_appendT(__f, __l, typename ::stlp_std::iterator_traits< _InputIter >::iterator_category());
    return *this;
  }
public:
  template <class _InputIter>
  _Self& assign(_InputIter __first, _InputIter __last) {
    typedef typename _IsIntegral<_InputIter>::_Ret _Integral;
    return _M_assign_dispatch(__first, __last, _Integral());
  }
public:
  _Self& insert(size_type __pos, const _Self& __s) {
    if (__pos > size())
      this->_M_throw_out_of_range();
    if (__s.size() > max_size() - size())
      this->_M_throw_length_error();
    _M_insert(begin() + __pos, __s._M_Start(), __s._M_Finish(), &__s == this);
    return *this;
  }
  _Self& insert(size_type __pos, const _Self& __s,
                size_type __beg, size_type __n) {
    if (__pos > size() || __beg > __s.size())
      this->_M_throw_out_of_range();
    size_type __len = (min) (__n, __s.size() - __beg);
    if (__len > max_size() - size())
      this->_M_throw_length_error();
    _M_insert(begin() + __pos,
              __s._M_Start() + __beg, __s._M_Start() + __beg + __len, &__s == this);
    return *this;
  }
  _Self& insert(size_type __pos, const _CharT* __s, size_type __n) {
   
    if (__pos > size())
      this->_M_throw_out_of_range();
    if (__n > max_size() - size())
      this->_M_throw_length_error();
    _M_insert(begin() + __pos, __s, __s + __n, _M_inside(__s));
    return *this;
  }
  _Self& insert(size_type __pos, const _CharT* __s) {
   
    if (__pos > size())
      this->_M_throw_out_of_range();
    size_type __len = _Traits::length(__s);
    if (__len > max_size() - size())
      this->_M_throw_length_error();
    _M_insert(this->_M_Start() + __pos, __s, __s + __len, _M_inside(__s));
    return *this;
  }
  _Self& insert(size_type __pos, size_type __n, _CharT __c) {
    if (__pos > size())
      this->_M_throw_out_of_range();
    if (__n > max_size() - size())
      this->_M_throw_length_error();
    insert(begin() + __pos, __n, __c);
    return *this;
  }
  iterator insert(iterator __p, _CharT __c) {
   
    if (__p == end()) {
      push_back(__c);
      return this->_M_Finish() - 1;
    }
    else
      return _M_insert_aux(__p, __c);
  }
  void insert(iterator __p, size_t __n, _CharT __c);
private:
  void _M_insert(iterator __p, const _CharT* __first, const _CharT* __last, bool __self_ref);
  pointer _M_insert_aux(pointer, _CharT);
  void _M_copy(const _CharT* __f, const _CharT* __l, _CharT* __res) {
   
   
    _Traits::copy(__res, __f, __l - __f);
  }
  void _M_move(const _CharT* __f, const _CharT* __l, _CharT* __res) {
   
    _Traits::move(__res, __f, __l - __f);
  }
  template <class _ForwardIter>
  void _M_insert_overflow(iterator __pos, _ForwardIter __first, _ForwardIter __last,
                          size_type __n) {
    size_type __len = _M_compute_next_size(__n);
    pointer __new_start = this->_M_start_of_storage.allocate(__len, __len);
    pointer __new_finish = uninitialized_copy(this->_M_Start(), __pos, __new_start);
    __new_finish = uninitialized_copy(__first, __last, __new_finish);
    __new_finish = uninitialized_copy(__pos, this->_M_Finish(), __new_finish);
    _M_construct_null(__new_finish);
    this->_M_deallocate_block();
    this->_M_reset(__new_start, __new_finish, __new_start + __len);
  }
  template <class _InputIter>
  void _M_insertT(iterator __p, _InputIter __first, _InputIter __last,
                  const input_iterator_tag &) {
    for ( ; __first != __last; ++__first) {
      __p = insert(__p, *__first);
      ++__p;
    }
  }
  template <class _ForwardIter>
  void _M_insertT(iterator __pos, _ForwardIter __first, _ForwardIter __last,
                  const forward_iterator_tag &) {
    if (__first != __last) {
      size_type __n = ::stlp_std::distance(__first, __last);
      if (__n < this->_M_rest()) {
        const size_type __elems_after = this->_M_finish - __pos;
        if (__elems_after >= __n) {
          uninitialized_copy((this->_M_Finish() - __n) + 1, this->_M_Finish() + 1, this->_M_Finish() + 1);
          this->_M_finish += __n;
          _Traits::move(__pos + __n, __pos, (__elems_after - __n) + 1);
          _M_copyT(__first, __last, __pos);
        }
        else {
          pointer __old_finish = this->_M_Finish();
          _ForwardIter __mid = __first;
          ::stlp_std::advance(__mid, __elems_after + 1);
          ::stlp_std::uninitialized_copy(__mid, __last, this->_M_Finish() + 1);
          this->_M_finish += __n - __elems_after;
          uninitialized_copy(__pos, __old_finish + 1, this->_M_Finish());
          this->_M_finish += __elems_after;
          _M_copyT(__first, __mid, __pos);
        }
      }
      else {
        _M_insert_overflow(__pos, __first, __last, __n);
      }
    }
  }
  template <class _Integer>
  void _M_insert_dispatch(iterator __p, _Integer __n, _Integer __x,
                          const __true_type& )
  { insert(__p, (size_type) __n, (_CharT) __x); }
  template <class _InputIter>
  void _M_insert_dispatch(iterator __p, _InputIter __first, _InputIter __last,
                          const __false_type& ) {
   
    const _Self __self(__first, __last, get_allocator());
    _M_insertT(__p, __self.begin(), __self.end(), forward_iterator_tag());
  }
  template <class _InputIterator>
  void _M_copyT(_InputIterator __first, _InputIterator __last, pointer __result) {
   
    for ( ; __first != __last; ++__first, ++__result)
      _Traits::assign(*__result, *__first);
  }
  void _M_copyT(const _CharT* __f, const _CharT* __l, _CharT* __res) {
   
   
    _Traits::copy(__res, __f, __l - __f);
  }
public:
  template <class _InputIter>
  void insert(iterator __p, _InputIter __first, _InputIter __last) {
    typedef typename _IsIntegral<_InputIter>::_Ret _Integral;
    _M_insert_dispatch(__p, __first, __last, _Integral());
  }
public:
  void insert(iterator __p, const _CharT* __f, const _CharT* __l) {
   
    _M_insert(__p, __f, __l, _M_inside(__f));
  }
public:
  _Self& erase(size_type __pos = 0, size_type __n = npos) {
    if (__pos > size())
      this->_M_throw_out_of_range();
    erase(begin() + __pos, begin() + __pos + (min) (__n, size() - __pos));
    return *this;
  }
  iterator erase(iterator __pos) {
    _Traits::move(__pos, __pos + 1, this->_M_Finish() - __pos);
    --this->_M_finish;
    return __pos;
  }
  iterator erase(iterator __first, iterator __last) {
    if (__first != __last) {
      traits_type::move(__first, __last, (this->_M_Finish() - __last) + 1);
      this->_M_finish = this->_M_Finish() - (__last - __first);
    }
    return __first;
  }
public:
  _Self& replace(size_type __pos, size_type __n, const _Self& __s) {
    const size_type __size = size();
    if (__pos > __size)
      this->_M_throw_out_of_range();
    const size_type __len = (min) (__n, __size - __pos);
    if (__s.size() > max_size() - (__size - __len))
      this->_M_throw_length_error();
    return _M_replace(begin() + __pos, begin() + __pos + __len,
                      __s._M_Start(), __s._M_Finish(), &__s == this);
  }
  _Self& replace(size_type __pos1, size_type __n1, const _Self& __s,
                 size_type __pos2, size_type __n2) {
    const size_type __size1 = size();
    const size_type __size2 = __s.size();
    if (__pos1 > __size1 || __pos2 > __size2)
      this->_M_throw_out_of_range();
    const size_type __len1 = (min) (__n1, __size1 - __pos1);
    const size_type __len2 = (min) (__n2, __size2 - __pos2);
    if (__len2 > max_size() - (__size1 - __len1))
      this->_M_throw_length_error();
    return _M_replace(begin() + __pos1, begin() + __pos1 + __len1,
                      __s._M_Start() + __pos2, __s._M_Start() + __pos2 + __len2, &__s == this);
  }
  _Self& replace(size_type __pos, size_type __n1,
                 const _CharT* __s, size_type __n2) {
   
    const size_type __size = size();
    if (__pos > __size)
      this->_M_throw_out_of_range();
    const size_type __len = (min) (__n1, __size - __pos);
    if (__n2 > max_size() - (__size - __len))
      this->_M_throw_length_error();
    return _M_replace(begin() + __pos, begin() + __pos + __len,
                      __s, __s + __n2, _M_inside(__s));
  }
  _Self& replace(size_type __pos, size_type __n1, const _CharT* __s) {
   
    return replace(__pos, __n1, __s, _Traits::length(__s));
  }
  _Self& replace(size_type __pos, size_type __n1,
                 size_type __n2, _CharT __c) {
    const size_type __size = size();
    if (__pos > __size)
      this->_M_throw_out_of_range();
    const size_type __len = (min) (__n1, __size - __pos);
    if (__n2 > max_size() - (__size - __len))
      this->_M_throw_length_error();
    return replace(begin() + __pos, begin() + __pos + __len, __n2, __c);
  }
  _Self& replace(iterator __first, iterator __last, const _Self& __s) {
   
    return _M_replace(__first, __last, __s._M_Start(), __s._M_Finish(), &__s == this);
  }
  _Self& replace(iterator __first, iterator __last,
                 const _CharT* __s, size_type __n) {
   
   
    return _M_replace(__first, __last, __s, __s + __n, _M_inside(__s));
  }
  _Self& replace(iterator __first, iterator __last,
                 const _CharT* __s) {
   
   
    return _M_replace(__first, __last, __s, __s + _Traits::length(__s), _M_inside(__s));
  }
  _Self& replace(iterator __first, iterator __last, size_type __n, _CharT __c);
private:
  _Self& _M_replace(iterator __first, iterator __last,
                    const _CharT* __f, const _CharT* __l, bool __self_ref);
  template <class _Integer>
  _Self& _M_replace_dispatch(iterator __first, iterator __last,
                             _Integer __n, _Integer __x, const __true_type& ) {
   
    return replace(__first, __last, (size_type) __n, (_CharT) __x);
  }
  template <class _InputIter>
  _Self& _M_replace_dispatch(iterator __first, iterator __last,
                             _InputIter __f, _InputIter __l, const __false_type& ) {
   
    const _Self __self(__f, __l, get_allocator());
    return _M_replace(__first, __last, __self._M_Start(), __self._M_Finish(), false);
  }
public:
  template <class _InputIter>
  _Self& replace(iterator __first, iterator __last,
                 _InputIter __f, _InputIter __l) {
   
    typedef typename _IsIntegral<_InputIter>::_Ret _Integral;
    return _M_replace_dispatch(__first, __last, __f, __l, _Integral());
  }
public:
  _Self& replace(iterator __first, iterator __last,
                 const _CharT* __f, const _CharT* __l) {
   
   
    return _M_replace(__first, __last, __f, __l, _M_inside(__f));
  }
public:
  size_type copy(_CharT* __s, size_type __n, size_type __pos = 0) const {
   
    if (__pos > size())
      this->_M_throw_out_of_range();
    const size_type __len = (min) (__n, size() - __pos);
    _Traits::copy(__s, this->_M_Start() + __pos, __len);
    return __len;
  }
  void swap(_Self& __s) { this->_M_swap(__s); }
public:
  const _CharT* c_str() const { return this->_M_Start(); }
  const _CharT* data() const { return this->_M_Start(); }
public:
  size_type find(const _Self& __s, size_type __pos = 0) const
  { return find(__s._M_Start(), __pos, __s.size()); }
  size_type find(const _CharT* __s, size_type __pos = 0) const
  { return find(__s, __pos, _Traits::length(__s)); }
  size_type find(const _CharT* __s, size_type __pos, size_type __n) const;
  size_type find(_CharT __c) const { return find(__c, 0); }
  size_type find(_CharT __c, size_type __pos ) const;
public:
  size_type rfind(const _Self& __s, size_type __pos = npos) const
  { return rfind(__s._M_Start(), __pos, __s.size()); }
  size_type rfind(const _CharT* __s, size_type __pos = npos) const
  { return rfind(__s, __pos, _Traits::length(__s)); }
  size_type rfind(const _CharT* __s, size_type __pos, size_type __n) const;
  size_type rfind(_CharT __c, size_type __pos = npos) const;
public:
  size_type find_first_of(const _Self& __s, size_type __pos = 0) const
  { return find_first_of(__s._M_Start(), __pos, __s.size()); }
  size_type find_first_of(const _CharT* __s, size_type __pos = 0) const
  { return find_first_of(__s, __pos, _Traits::length(__s)); }
  size_type find_first_of(const _CharT* __s, size_type __pos, size_type __n) const;
  size_type find_first_of(_CharT __c, size_type __pos = 0) const
  { return find(__c, __pos); }
public:
  size_type find_last_of(const _Self& __s, size_type __pos = npos) const
  { return find_last_of(__s._M_Start(), __pos, __s.size()); }
  size_type find_last_of(const _CharT* __s, size_type __pos = npos) const
  { return find_last_of(__s, __pos, _Traits::length(__s)); }
  size_type find_last_of(const _CharT* __s, size_type __pos, size_type __n) const;
  size_type find_last_of(_CharT __c, size_type __pos = npos) const
  { return rfind(__c, __pos); }
public:
  size_type find_first_not_of(const _Self& __s, size_type __pos = 0) const
  { return find_first_not_of(__s._M_Start(), __pos, __s.size()); }
  size_type find_first_not_of(const _CharT* __s, size_type __pos = 0) const
  { return find_first_not_of(__s, __pos, _Traits::length(__s)); }
  size_type find_first_not_of(const _CharT* __s, size_type __pos, size_type __n) const;
  size_type find_first_not_of(_CharT __c, size_type __pos = 0) const;
public:
  size_type find_last_not_of(const _Self& __s, size_type __pos = npos) const
  { return find_last_not_of(__s._M_Start(), __pos, __s.size()); }
  size_type find_last_not_of(const _CharT* __s, size_type __pos = npos) const
  { return find_last_not_of(__s, __pos, _Traits::length(__s)); }
  size_type find_last_not_of(const _CharT* __s, size_type __pos, size_type __n) const;
  size_type find_last_not_of(_CharT __c, size_type __pos = npos) const;
public:
  _Self substr(size_type __pos = 0, size_type __n = npos) const
  { return _Self(*this, __pos, __n, get_allocator()); }
public:
  int compare(const _Self& __s) const
  { return _M_compare(this->_M_Start(), this->_M_Finish(), __s._M_Start(), __s._M_Finish()); }
  int compare(size_type __pos1, size_type __n1, const _Self& __s) const {
    if (__pos1 > size())
      this->_M_throw_out_of_range();
    return _M_compare(this->_M_Start() + __pos1,
                      this->_M_Start() + __pos1 + (min) (__n1, size() - __pos1),
                      __s._M_Start(), __s._M_Finish());
  }
  int compare(size_type __pos1, size_type __n1, const _Self& __s,
              size_type __pos2, size_type __n2) const {
    if (__pos1 > size() || __pos2 > __s.size())
      this->_M_throw_out_of_range();
    return _M_compare(this->_M_Start() + __pos1,
                      this->_M_Start() + __pos1 + (min) (__n1, size() - __pos1),
                      __s._M_Start() + __pos2,
                      __s._M_Start() + __pos2 + (min) (__n2, __s.size() - __pos2));
  }
  int compare(const _CharT* __s) const {
   
    return _M_compare(this->_M_Start(), this->_M_Finish(), __s, __s + _Traits::length(__s));
  }
  int compare(size_type __pos1, size_type __n1, const _CharT* __s) const {
   
    if (__pos1 > size())
      this->_M_throw_out_of_range();
    return _M_compare(this->_M_Start() + __pos1,
                      this->_M_Start() + __pos1 + (min) (__n1, size() - __pos1),
                      __s, __s + _Traits::length(__s));
  }
  int compare(size_type __pos1, size_type __n1, const _CharT* __s, size_type __n2) const {
   
    if (__pos1 > size())
      this->_M_throw_out_of_range();
    return _M_compare(this->_M_Start() + __pos1,
                      this->_M_Start() + __pos1 + (min) (__n1, size() - __pos1),
                      __s, __s + __n2);
  }
public:
  static int _M_compare(const _CharT* __f1, const _CharT* __l1,
                                   const _CharT* __f2, const _CharT* __l2) {
    const ptrdiff_t __n1 = __l1 - __f1;
    const ptrdiff_t __n2 = __l2 - __f2;
    const int cmp = _Traits::compare(__f1, __f2, (min) (__n1, __n2));
    return cmp != 0 ? cmp : (__n1 < __n2 ? -1 : (__n1 > __n2 ? 1 : 0));
  }
};
}
namespace stlp_std {
template <class _CharT, class _Traits, class _Alloc>
inline void
swap(basic_string<_CharT,_Traits,_Alloc>& __x,
     basic_string<_CharT,_Traits,_Alloc>& __y)
{ __x.swap(__y); }
template <class _CharT, class _Traits, class _Alloc>
struct __move_traits<basic_string<_CharT, _Traits, _Alloc> > {
  typedef __true_type implemented;
  typedef typename __move_traits<_Alloc>::complete complete;
};
namespace priv {
template <class _CharT, class _Traits, class _Alloc>
void _S_string_copy(const basic_string<_CharT,_Traits,_Alloc>& __s,
                               _CharT* __buf, size_t __n);
inline const char*
__get_c_string(const string& __str) { return __str.c_str(); }
}
}
namespace stlp_std {
template <class _CharT, class _Traits, class _Alloc>
inline basic_string<_CharT,_Traits,_Alloc>
operator+(const basic_string<_CharT,_Traits,_Alloc>& __s,
          const basic_string<_CharT,_Traits,_Alloc>& __y) {
  typedef basic_string<_CharT,_Traits,_Alloc> _Str;
  typedef typename _Str::_Reserve_t _Reserve_t;
  _Str __result = _Str(_Reserve_t(), __s.size() + __y.size(), __s.get_allocator());
  __result.append(__s);
  __result.append(__y);
  return __result;
}
template <class _CharT, class _Traits, class _Alloc>
inline basic_string<_CharT,_Traits,_Alloc>
operator+(const _CharT* __s,
          const basic_string<_CharT,_Traits,_Alloc>& __y) {
 
  typedef basic_string<_CharT,_Traits,_Alloc> _Str;
  typedef typename _Str::_Reserve_t _Reserve_t;
  const size_t __n = _Traits::length(__s);
  _Str __result = _Str(_Reserve_t(), __n + __y.size(), __y.get_allocator());
  __result.append(__s, __s + __n);
  __result.append(__y);
  return __result;
}
template <class _CharT, class _Traits, class _Alloc>
inline basic_string<_CharT,_Traits,_Alloc>
operator+(_CharT __c,
          const basic_string<_CharT,_Traits,_Alloc>& __y) {
  typedef basic_string<_CharT,_Traits,_Alloc> _Str;
  typedef typename _Str::_Reserve_t _Reserve_t;
  _Str __result = _Str(_Reserve_t(), 1 + __y.size(), __y.get_allocator());
  __result.push_back(__c);
  __result.append(__y);
  return __result;
}
template <class _CharT, class _Traits, class _Alloc>
inline basic_string<_CharT,_Traits,_Alloc>
operator+(const basic_string<_CharT,_Traits,_Alloc>& __x,
          const _CharT* __s) {
 
  typedef basic_string<_CharT,_Traits,_Alloc> _Str;
  typedef typename _Str::_Reserve_t _Reserve_t;
  const size_t __n = _Traits::length(__s);
  _Str __result = _Str(_Reserve_t(), __x.size() + __n, __x.get_allocator());
  __result.append(__x);
  __result.append(__s, __s + __n);
  return __result;
}
template <class _CharT, class _Traits, class _Alloc>
inline basic_string<_CharT,_Traits,_Alloc>
operator+(const basic_string<_CharT,_Traits,_Alloc>& __x,
          const _CharT __c) {
  typedef basic_string<_CharT,_Traits,_Alloc> _Str;
  typedef typename _Str::_Reserve_t _Reserve_t;
  _Str __result = _Str(_Reserve_t(), __x.size() + 1, __x.get_allocator());
  __result.append(__x);
  __result.push_back(__c);
  return __result;
}
template <class _CharT, class _Traits, class _Alloc>
inline bool
operator==(const basic_string<_CharT,_Traits,_Alloc>& __x,
           const basic_string<_CharT,_Traits,_Alloc>& __y) {
  return __x.size() == __y.size() && _Traits::compare(__x.data(), __y.data(), __x.size()) == 0;
}
template <class _CharT, class _Traits, class _Alloc>
inline bool
operator==(const _CharT* __s,
           const basic_string<_CharT,_Traits,_Alloc>& __y) {
 
  size_t __n = _Traits::length(__s);
  return __n == __y.size() && _Traits::compare(__s, __y.data(), __n) == 0;
}
template <class _CharT, class _Traits, class _Alloc>
inline bool
operator==(const basic_string<_CharT,_Traits,_Alloc>& __x,
           const _CharT* __s) {
 
  size_t __n = _Traits::length(__s);
  return __x.size() == __n && _Traits::compare(__x.data(), __s, __n) == 0;
}
template <class _CharT, class _Traits, class _Alloc>
inline bool
operator<(const basic_string<_CharT,_Traits,_Alloc>& __x,
          const basic_string<_CharT,_Traits,_Alloc>& __y) {
  return basic_string<_CharT,_Traits,_Alloc> ::_M_compare(__x.begin(), __x.end(),
                                                          __y.begin(), __y.end()) < 0;
}
template <class _CharT, class _Traits, class _Alloc>
inline bool
operator<(const _CharT* __s,
          const basic_string<_CharT,_Traits,_Alloc>& __y) {
 
  size_t __n = _Traits::length(__s);
  return basic_string<_CharT,_Traits,_Alloc> ::_M_compare(__s, __s + __n,
                                                          __y.begin(), __y.end()) < 0;
}
template <class _CharT, class _Traits, class _Alloc>
inline bool
operator<(const basic_string<_CharT,_Traits,_Alloc>& __x,
          const _CharT* __s) {
 
  size_t __n = _Traits::length(__s);
  return basic_string<_CharT,_Traits,_Alloc> ::_M_compare(__x.begin(), __x.end(),
                                                          __s, __s + __n) < 0;
}
template <class _CharT, class _Traits, class _Alloc>
inline bool
operator!=(const basic_string<_CharT,_Traits,_Alloc>& __x,
           const basic_string<_CharT,_Traits,_Alloc>& __y)
{ return !(__x == __y); }
template <class _CharT, class _Traits, class _Alloc>
inline bool
operator>(const basic_string<_CharT,_Traits,_Alloc>& __x,
          const basic_string<_CharT,_Traits,_Alloc>& __y)
{ return __y < __x; }
template <class _CharT, class _Traits, class _Alloc>
inline bool
operator<=(const basic_string<_CharT,_Traits,_Alloc>& __x,
           const basic_string<_CharT,_Traits,_Alloc>& __y)
{ return !(__y < __x); }
template <class _CharT, class _Traits, class _Alloc>
inline bool
operator>=(const basic_string<_CharT,_Traits,_Alloc>& __x,
           const basic_string<_CharT,_Traits,_Alloc>& __y)
{ return !(__x < __y); }
template <class _CharT, class _Traits, class _Alloc>
inline bool
operator!=(const _CharT* __s,
           const basic_string<_CharT,_Traits,_Alloc>& __y) {
 
  return !(__s == __y);
}
template <class _CharT, class _Traits, class _Alloc>
inline bool
operator!=(const basic_string<_CharT,_Traits,_Alloc>& __x,
           const _CharT* __s) {
 
  return !(__x == __s);
}
template <class _CharT, class _Traits, class _Alloc>
inline bool
operator>(const _CharT* __s,
          const basic_string<_CharT,_Traits,_Alloc>& __y) {
 
  return __y < __s;
}
template <class _CharT, class _Traits, class _Alloc>
inline bool
operator>(const basic_string<_CharT,_Traits,_Alloc>& __x,
          const _CharT* __s) {
 
  return __s < __x;
}
template <class _CharT, class _Traits, class _Alloc>
inline bool
operator<=(const _CharT* __s,
           const basic_string<_CharT,_Traits,_Alloc>& __y) {
 
  return !(__y < __s);
}
template <class _CharT, class _Traits, class _Alloc>
inline bool
operator<=(const basic_string<_CharT,_Traits,_Alloc>& __x,
           const _CharT* __s) {
 
  return !(__s < __x);
}
template <class _CharT, class _Traits, class _Alloc>
inline bool
operator>=(const _CharT* __s,
           const basic_string<_CharT,_Traits,_Alloc>& __y) {
 
  return !(__s < __y);
}
template <class _CharT, class _Traits, class _Alloc>
inline bool
operator>=(const basic_string<_CharT,_Traits,_Alloc>& __x,
           const _CharT* __s) {
 
  return !(__x < __s);
}
}
namespace stlp_std {
namespace priv {
template <class _Traits>
struct _Eq_traits
  : public binary_function<typename _Traits::char_type,
                           typename _Traits::char_type,
                           bool> {
  bool operator()(const typename _Traits::char_type& __x,
                  const typename _Traits::char_type& __y) const
  { return _Traits::eq(__x, __y); }
};
template <class _Traits>
struct _Eq_char_bound
  : public unary_function<typename _Traits::char_type, bool> {
  typename _Traits::char_type __val;
  _Eq_char_bound(typename _Traits::char_type __c) : __val(__c) {}
  bool operator()(const typename _Traits::char_type& __x) const
  { return _Traits::eq(__x, __val); }
};
template <class _Traits>
struct _Neq_char_bound
  : public unary_function<typename _Traits::char_type, bool>
{
  typename _Traits::char_type __val;
  _Neq_char_bound(typename _Traits::char_type __c) : __val(__c) {}
  bool operator()(const typename _Traits::char_type& __x) const
  { return !_Traits::eq(__x, __val); }
};
template <class _Traits>
struct _Eq_int_bound
  : public unary_function<typename _Traits::char_type, bool> {
  typename _Traits::int_type __val;
  _Eq_int_bound(typename _Traits::int_type __c) : __val(__c) {}
  bool operator()(const typename _Traits::char_type& __x) const
  { return _Traits::eq_int_type(_Traits::to_int_type(__x), __val); }
};
}
}
namespace stlp_std {
template <class _Tp>
struct not_equal_to : public binary_function<_Tp, _Tp, bool> {
  bool operator()(const _Tp& __x, const _Tp& __y) const { return __x != __y; }
};
template <class _Tp>
struct greater : public binary_function<_Tp, _Tp, bool> {
  bool operator()(const _Tp& __x, const _Tp& __y) const { return __x > __y; }
};
template <class _Tp>
struct greater_equal : public binary_function<_Tp, _Tp, bool> {
  bool operator()(const _Tp& __x, const _Tp& __y) const { return __x >= __y; }
};
template <class _Tp>
struct less_equal : public binary_function<_Tp, _Tp, bool> {
  bool operator()(const _Tp& __x, const _Tp& __y) const { return __x <= __y; }
};
template <class _Tp>
struct divides : public binary_function<_Tp, _Tp, _Tp> {
  _Tp operator()(const _Tp& __x, const _Tp& __y) const { return __x / __y; }
};
template <class _Tp>
struct modulus : public binary_function<_Tp, _Tp, _Tp> {
  _Tp operator()(const _Tp& __x, const _Tp& __y) const { return __x % __y; }
};
template <class _Tp>
struct negate : public unary_function<_Tp, _Tp> {
  _Tp operator()(const _Tp& __x) const { return -__x; }
};
template <class _Tp>
struct logical_and : public binary_function<_Tp, _Tp, bool> {
  bool operator()(const _Tp& __x, const _Tp& __y) const { return __x && __y; }
};
template <class _Tp>
struct logical_or : public binary_function<_Tp, _Tp,bool> {
  bool operator()(const _Tp& __x, const _Tp& __y) const { return __x || __y; }
};
template <class _Tp>
struct logical_not : public unary_function<_Tp, bool> {
  bool operator()(const _Tp& __x) const { return !__x; }
};
template <class _Tp> inline _Tp identity_element(plus<_Tp>) { return _Tp(0); }
template <class _Tp> inline _Tp identity_element(multiplies<_Tp>) { return _Tp(1); }
template <class _Predicate>
class unary_negate
    : public unary_function<typename _Predicate::argument_type, bool> {
  typedef unary_function<typename _Predicate::argument_type, bool> _Base;
public:
  typedef typename _Base::argument_type argument_type;
private:
  typedef typename __call_traits<argument_type>::const_param_type _ArgParamType;
protected:
  _Predicate _M_pred;
public:
  explicit unary_negate(const _Predicate& __x) : _M_pred(__x) {}
  bool operator()(_ArgParamType __x) const {
    return !_M_pred(__x);
  }
};
template <class _Predicate>
inline unary_negate<_Predicate>
not1(const _Predicate& __pred) {
  return unary_negate<_Predicate>(__pred);
}
template <class _Predicate>
class binary_negate
    : public binary_function<typename _Predicate::first_argument_type,
                             typename _Predicate::second_argument_type,
                             bool> {
  typedef binary_function<typename _Predicate::first_argument_type,
                          typename _Predicate::second_argument_type,
                          bool> _Base;
public:
  typedef typename _Base::first_argument_type first_argument_type;
  typedef typename _Base::second_argument_type second_argument_type;
private:
  typedef typename __call_traits<first_argument_type>::const_param_type _FstArgParamType;
  typedef typename __call_traits<second_argument_type>::const_param_type _SndArgParamType;
protected:
  _Predicate _M_pred;
public:
  explicit binary_negate(const _Predicate& __x) : _M_pred(__x) {}
  bool operator()(_FstArgParamType __x, _SndArgParamType __y) const {
    return !_M_pred(__x, __y);
  }
};
template <class _Predicate>
inline binary_negate<_Predicate>
not2(const _Predicate& __pred) {
  return binary_negate<_Predicate>(__pred);
}
template <class _Operation>
class binder1st :
    public unary_function<typename _Operation::second_argument_type,
                          typename _Operation::result_type > {
  typedef unary_function<typename _Operation::second_argument_type,
                         typename _Operation::result_type > _Base;
public:
  typedef typename _Base::argument_type argument_type;
  typedef typename _Base::result_type result_type;
private:
  typedef typename __call_traits<argument_type>::param_type _ArgParamType;
  typedef typename __call_traits<argument_type>::const_param_type _ConstArgParamType;
  typedef typename __call_traits<typename _Operation::first_argument_type>::const_param_type _ValueParamType;
protected:
  _Operation op;
  typename _Operation::first_argument_type _M_value;
public:
  binder1st(const _Operation& __x, _ValueParamType __y)
    : op(__x), _M_value(__y) {}
  result_type operator()(_ConstArgParamType __x) const
  { return op(_M_value, __x); }
  result_type operator()(_ArgParamType __x) const
  { return op(_M_value, __x); }
};
template <class _Operation, class _Tp>
inline binder1st<_Operation>
bind1st(const _Operation& __fn, const _Tp& __x) {
  typedef typename _Operation::first_argument_type _Arg1_type;
  return binder1st<_Operation>(__fn, _Arg1_type(__x));
}
template <class _Operation>
class binder2nd
  : public unary_function<typename _Operation::first_argument_type,
                          typename _Operation::result_type> {
  typedef unary_function<typename _Operation::first_argument_type,
                         typename _Operation::result_type> _Base;
public:
  typedef typename _Base::argument_type argument_type;
  typedef typename _Base::result_type result_type;
private:
  typedef typename __call_traits<argument_type>::param_type _ArgParamType;
  typedef typename __call_traits<argument_type>::const_param_type _ConstArgParamType;
  typedef typename __call_traits<typename _Operation::second_argument_type>::const_param_type _ValueParamType;
protected:
  _Operation op;
  typename _Operation::second_argument_type value;
public:
  binder2nd(const _Operation& __x, _ValueParamType __y)
      : op(__x), value(__y) {}
  result_type operator()(_ConstArgParamType __x) const
  { return op(__x, value); }
  result_type operator()(_ArgParamType __x) const
  { return op(__x, value); }
};
template <class _Operation, class _Tp>
inline binder2nd<_Operation>
bind2nd(const _Operation& __fn, const _Tp& __x) {
  typedef typename _Operation::second_argument_type _Arg2_type;
  return binder2nd<_Operation>(__fn, _Arg2_type(__x));
}
template <class _Operation1, class _Operation2>
class unary_compose :
  public unary_function<typename _Operation2::argument_type,
                        typename _Operation1::result_type> {
  typedef unary_function<typename _Operation2::argument_type,
                         typename _Operation1::result_type> _Base;
public:
  typedef typename _Base::argument_type argument_type;
  typedef typename _Base::result_type result_type;
private:
  typedef typename __call_traits<argument_type>::const_param_type _ArgParamType;
protected:
  _Operation1 _M_fn1;
  _Operation2 _M_fn2;
public:
  unary_compose(const _Operation1& __x, const _Operation2& __y)
    : _M_fn1(__x), _M_fn2(__y) {}
  result_type operator()(_ArgParamType __x) const {
    return _M_fn1(_M_fn2(__x));
  }
};
template <class _Operation1, class _Operation2>
inline unary_compose<_Operation1,_Operation2>
compose1(const _Operation1& __fn1, const _Operation2& __fn2) {
  return unary_compose<_Operation1,_Operation2>(__fn1, __fn2);
}
template <class _Operation1, class _Operation2, class _Operation3>
class binary_compose :
    public unary_function<typename _Operation2::argument_type,
                          typename _Operation1::result_type> {
  typedef unary_function<typename _Operation2::argument_type,
                         typename _Operation1::result_type> _Base;
public:
  typedef typename _Base::argument_type argument_type;
  typedef typename _Base::result_type result_type;
private:
  typedef typename __call_traits<argument_type>::const_param_type _ArgParamType;
protected:
  _Operation1 _M_fn1;
  _Operation2 _M_fn2;
  _Operation3 _M_fn3;
public:
  binary_compose(const _Operation1& __x, const _Operation2& __y,
                 const _Operation3& __z)
    : _M_fn1(__x), _M_fn2(__y), _M_fn3(__z) { }
  result_type operator()(_ArgParamType __x) const {
    return _M_fn1(_M_fn2(__x), _M_fn3(__x));
  }
};
template <class _Operation1, class _Operation2, class _Operation3>
inline binary_compose<_Operation1, _Operation2, _Operation3>
compose2(const _Operation1& __fn1, const _Operation2& __fn2,
         const _Operation3& __fn3) {
  return binary_compose<_Operation1,_Operation2,_Operation3>(__fn1, __fn2, __fn3);
}
template <class _Tp> struct identity : public ::stlp_std::priv:: _Identity<_Tp> {};
template <class _Pair> struct select1st : public ::stlp_std::priv:: _Select1st<_Pair> {};
template <class _Pair> struct select2nd : public ::stlp_std::priv:: _Select2nd<_Pair> {};
template <class _Arg1, class _Arg2>
struct project1st : public ::stlp_std::priv:: _Project1st<_Arg1, _Arg2> {};
template <class _Arg1, class _Arg2>
struct project2nd : public ::stlp_std::priv:: _Project2nd<_Arg1, _Arg2> {};
namespace priv {
template <class _Result>
struct _Constant_void_fun {
  typedef _Result result_type;
  result_type _M_val;
  _Constant_void_fun(const result_type& __v) : _M_val(__v) {}
  const result_type& operator()() const { return _M_val; }
};
}
template <class _Result>
struct constant_void_fun : public ::stlp_std::priv:: _Constant_void_fun<_Result> {
  constant_void_fun(const _Result& __v)
    : ::stlp_std::priv:: _Constant_void_fun<_Result>(__v) {}
};
template <class _Result, class _Argument = _Result >
struct constant_unary_fun : public ::stlp_std::priv:: _Constant_unary_fun<_Result, _Argument> {
  constant_unary_fun(const _Result& __v)
    : ::stlp_std::priv:: _Constant_unary_fun<_Result, _Argument>(__v) {}
};
template <class _Result, class _Arg1 = _Result, class _Arg2 = _Arg1 >
struct constant_binary_fun
  : public ::stlp_std::priv:: _Constant_binary_fun<_Result, _Arg1, _Arg2> {
  constant_binary_fun(const _Result& __v)
    : ::stlp_std::priv:: _Constant_binary_fun<_Result, _Arg1, _Arg2>(__v) {}
};
template <class _Result>
inline constant_void_fun<_Result> constant0(const _Result& __val) {
  return constant_void_fun<_Result>(__val);
}
template <class _Result>
inline constant_unary_fun<_Result,_Result> constant1(const _Result& __val) {
  return constant_unary_fun<_Result,_Result>(__val);
}
template <class _Result>
inline constant_binary_fun<_Result,_Result,_Result>
constant2(const _Result& __val) {
  return constant_binary_fun<_Result,_Result,_Result>(__val);
}
class subtractive_rng : public unary_function<unsigned long, unsigned long> {
private:
  unsigned long _M_table[55];
  unsigned long _M_index1;
  unsigned long _M_index2;
public:
  unsigned long operator()(unsigned long __limit) {
    _M_index1 = (_M_index1 + 1) % 55;
    _M_index2 = (_M_index2 + 1) % 55;
    _M_table[_M_index1] = _M_table[_M_index1] - _M_table[_M_index2];
    return _M_table[_M_index1] % __limit;
  }
  void _M_initialize(unsigned long __seed) {
    unsigned long __k = 1;
    _M_table[54] = __seed;
    unsigned long __i;
    for (__i = 0; __i < 54; __i++) {
        unsigned long __ii = (21 * (__i + 1) % 55) - 1;
        _M_table[__ii] = __k;
        __k = __seed - __k;
        __seed = _M_table[__ii];
    }
    for (int __loop = 0; __loop < 4; __loop++) {
        for (__i = 0; __i < 55; __i++)
            _M_table[__i] = _M_table[__i] - _M_table[(1 + __i + 30) % 55];
    }
    _M_index1 = 0;
    _M_index2 = 31;
  }
  subtractive_rng(unsigned int __seed) { _M_initialize(__seed); }
  subtractive_rng() { _M_initialize(161803398ul); }
};
}
namespace stlp_std {
template <class _Ret, class _Tp>
class mem_fun_t : public unary_function<_Tp*,_Ret> {
  typedef _Ret (_Tp::*__fun_type)(void);
public:
  explicit mem_fun_t(__fun_type __pf) : _M_f(__pf) {}
  _Ret operator()(_Tp* __p) const { return (__p->*_M_f)(); }
private:
  __fun_type _M_f;
};
template <class _Ret, class _Tp>
class const_mem_fun_t : public unary_function<const _Tp*,_Ret> {
  typedef _Ret (_Tp::*__fun_type)(void) const;
public:
  explicit const_mem_fun_t(__fun_type __pf) : _M_f(__pf) {}
  _Ret operator()(const _Tp* __p) const { return (__p->*_M_f)(); }
private:
  __fun_type _M_f;
};
template <class _Ret, class _Tp>
class mem_fun_ref_t : public unary_function<_Tp,_Ret> {
  typedef _Ret (_Tp::*__fun_type)(void);
public:
  explicit mem_fun_ref_t(__fun_type __pf) : _M_f(__pf) {}
  _Ret operator()(_Tp& __r) const { return (__r.*_M_f)(); }
private:
  __fun_type _M_f;
};
template <class _Ret, class _Tp>
class const_mem_fun_ref_t : public unary_function<_Tp,_Ret> {
  typedef _Ret (_Tp::*__fun_type)(void) const;
public:
  explicit const_mem_fun_ref_t(__fun_type __pf) : _M_f(__pf) {}
  _Ret operator()(const _Tp& __r) const { return (__r.*_M_f)(); }
private:
  __fun_type _M_f;
};
template <class _Ret, class _Tp, class _Arg>
class mem_fun1_t : public binary_function<_Tp*,_Arg,_Ret> {
  typedef _Ret (_Tp::*__fun_type)(_Arg);
public:
  explicit mem_fun1_t(__fun_type __pf) : _M_f(__pf) {}
  _Ret operator()(_Tp* __p, _Arg __x) const { return (__p->*_M_f)(__x); }
private:
  __fun_type _M_f;
};
template <class _Ret, class _Tp, class _Arg>
class const_mem_fun1_t : public binary_function<const _Tp*,_Arg,_Ret> {
  typedef _Ret (_Tp::*__fun_type)(_Arg) const;
public:
  explicit const_mem_fun1_t(__fun_type __pf) : _M_f(__pf) {}
  _Ret operator()(const _Tp* __p, _Arg __x) const
    { return (__p->*_M_f)(__x); }
private:
  __fun_type _M_f;
};
template <class _Ret, class _Tp, class _Arg>
class mem_fun1_ref_t : public binary_function<_Tp,_Arg,_Ret> {
  typedef _Ret (_Tp::*__fun_type)(_Arg);
public:
  explicit mem_fun1_ref_t(__fun_type __pf) : _M_f(__pf) {}
  _Ret operator()(_Tp& __r, _Arg __x) const { return (__r.*_M_f)(__x); }
private:
  __fun_type _M_f;
};
template <class _Ret, class _Tp, class _Arg>
class const_mem_fun1_ref_t : public binary_function<_Tp,_Arg,_Ret> {
  typedef _Ret (_Tp::*__fun_type)(_Arg) const;
public:
  explicit const_mem_fun1_ref_t(__fun_type __pf) : _M_f(__pf) {}
  _Ret operator()(const _Tp& __r, _Arg __x) const { return (__r.*_M_f)(__x); }
private:
  __fun_type _M_f;
};
template <class _Arg, class _Result>
class pointer_to_unary_function : public unary_function<_Arg, _Result> {
protected:
  _Result (*_M_ptr)(_Arg);
public:
  pointer_to_unary_function() {}
  explicit pointer_to_unary_function(_Result (*__x)(_Arg)) : _M_ptr(__x) {}
  _Result operator()(_Arg __x) const { return _M_ptr(__x); }
};
template <class _Arg1, class _Arg2, class _Result>
class pointer_to_binary_function :
  public binary_function<_Arg1,_Arg2,_Result> {
protected:
    _Result (*_M_ptr)(_Arg1, _Arg2);
public:
    pointer_to_binary_function() {}
    explicit pointer_to_binary_function(_Result (*__x)(_Arg1, _Arg2))
      : _M_ptr(__x) {}
    _Result operator()(_Arg1 __x, _Arg2 __y) const {
      return _M_ptr(__x, __y);
    }
};
template <class _Result, class _Tp>
inline mem_fun_t<_Result,_Tp>
mem_fun(_Result (_Tp::*__f)()) { return mem_fun_t<_Result,_Tp>(__f); }
template <class _Result, class _Tp>
inline const_mem_fun_t<_Result,_Tp>
mem_fun(_Result (_Tp::*__f)() const) { return const_mem_fun_t<_Result,_Tp>(__f); }
template <class _Result, class _Tp>
inline mem_fun_ref_t<_Result,_Tp>
mem_fun_ref(_Result (_Tp::*__f)()) { return mem_fun_ref_t<_Result,_Tp>(__f); }
template <class _Result, class _Tp>
inline const_mem_fun_ref_t<_Result,_Tp>
mem_fun_ref(_Result (_Tp::*__f)() const) { return const_mem_fun_ref_t<_Result,_Tp>(__f); }
template <class _Result, class _Tp, class _Arg>
inline mem_fun1_t<_Result,_Tp,_Arg>
mem_fun(_Result (_Tp::*__f)(_Arg)) { return mem_fun1_t<_Result,_Tp,_Arg>(__f); }
template <class _Result, class _Tp, class _Arg>
inline const_mem_fun1_t<_Result,_Tp,_Arg>
mem_fun(_Result (_Tp::*__f)(_Arg) const) { return const_mem_fun1_t<_Result,_Tp,_Arg>(__f); }
template <class _Result, class _Tp, class _Arg>
inline mem_fun1_ref_t<_Result,_Tp,_Arg>
mem_fun_ref(_Result (_Tp::*__f)(_Arg)) { return mem_fun1_ref_t<_Result,_Tp,_Arg>(__f); }
template <class _Result, class _Tp, class _Arg>
inline const_mem_fun1_ref_t<_Result,_Tp,_Arg>
mem_fun_ref(_Result (_Tp::*__f)(_Arg) const) { return const_mem_fun1_ref_t<_Result,_Tp,_Arg>(__f); }
template <class _Result, class _Tp, class _Arg>
inline mem_fun1_t<_Result,_Tp,_Arg>
mem_fun1(_Result (_Tp::*__f)(_Arg)) { return mem_fun1_t<_Result,_Tp,_Arg>(__f); }
template <class _Result, class _Tp, class _Arg>
inline const_mem_fun1_t<_Result,_Tp,_Arg>
mem_fun1(_Result (_Tp::*__f)(_Arg) const) { return const_mem_fun1_t<_Result,_Tp,_Arg>(__f); }
template <class _Result, class _Tp, class _Arg>
inline mem_fun1_ref_t<_Result,_Tp,_Arg>
mem_fun1_ref(_Result (_Tp::*__f)(_Arg)) { return mem_fun1_ref_t<_Result,_Tp,_Arg>(__f); }
template <class _Result, class _Tp, class _Arg>
inline const_mem_fun1_ref_t<_Result,_Tp,_Arg>
mem_fun1_ref(_Result (_Tp::*__f)(_Arg) const) { return const_mem_fun1_ref_t<_Result,_Tp,_Arg>(__f); }
template <class _Arg, class _Result>
inline pointer_to_unary_function<_Arg, _Result>
ptr_fun(_Result (*__f)(_Arg))
{ return pointer_to_unary_function<_Arg, _Result>(__f); }
template <class _Arg1, class _Arg2, class _Result>
inline pointer_to_binary_function<_Arg1,_Arg2,_Result>
ptr_fun(_Result (*__f)(_Arg1, _Arg2))
{ return pointer_to_binary_function<_Arg1,_Arg2,_Result>(__f); }
}
namespace stlp_std {
namespace priv {
template <class _Traits>
struct _Not_within_traits : public unary_function<typename _Traits::char_type, bool> {
  typedef typename _Traits::char_type _CharT;
  const _CharT* _M_first;
  const _CharT* _M_last;
  _Not_within_traits(const _CharT* __f, const _CharT* __l)
    : _M_first(__f), _M_last(__l) {}
  bool operator()(const _CharT& __x) const {
    return find_if(_M_first, _M_last,
                   ::stlp_std::priv:: _Eq_char_bound<_Traits>(__x)) == _M_last;
  }
};
template <class _InputIter, class _CharT, class _Traits>
inline _InputIter __str_find_first_of_aux(_InputIter __first1, _InputIter __last1,
                                          const _CharT* __first2, const _CharT* __last2,
                                          _Traits*, const __true_type& )
{ return __find_first_of(__first1, __last1, __first2, __last2); }
template <class _InputIter, class _CharT, class _Traits>
inline _InputIter __str_find_first_of_aux(_InputIter __first1, _InputIter __last1,
                                          const _CharT* __first2, const _CharT* __last2,
                                          _Traits*, const __false_type& )
{ return __find_first_of(__first1, __last1, __first2, __last2, ::stlp_std::priv:: _Eq_traits<_Traits>()); }
template <class _InputIter, class _CharT, class _Traits>
inline _InputIter __str_find_first_of(_InputIter __first1, _InputIter __last1,
                                      const _CharT* __first2, const _CharT* __last2,
                                      _Traits* __traits) {
  typedef typename _IsSTLportClass<_Traits>::_Ret _STLportTraits;
  return __str_find_first_of_aux(__first1, __last1, __first2, __last2, __traits, _STLportTraits());
}
template <class _InputIter, class _CharT, class _Traits>
inline _InputIter __str_find_first_not_of_aux3(_InputIter __first1, _InputIter __last1,
                                               const _CharT* __first2, const _CharT* __last2,
                                               _Traits* , const __true_type& __useStrcspnLikeAlgo)
{ return __find_first_of_aux2(__first1, __last1, __first2, __last2, __first2, not1(_Identity<bool>()), __useStrcspnLikeAlgo); }
template <class _InputIter, class _CharT, class _Traits>
inline _InputIter __str_find_first_not_of_aux3(_InputIter __first1, _InputIter __last1,
                                               const _CharT* __first2, const _CharT* __last2,
                                               _Traits* , const __false_type& )
{ return ::stlp_std::find_if(__first1, __last1, ::stlp_std::priv:: _Not_within_traits<_Traits>(__first2, __last2)); }
template <class _InputIter, class _CharT, class _Tp, class _Traits>
inline _InputIter __str_find_first_not_of_aux2(_InputIter __first1, _InputIter __last1,
                                               const _CharT* __first2, const _CharT* __last2,
                                               _Tp* __pt, _Traits* __traits) {
  typedef typename _IsIntegral<_Tp>::_Ret _IsIntegral;
  typedef typename _IsCharLikeType<_CharT>::_Ret _IsCharLike;
  typedef typename _Land2<_IsIntegral, _IsCharLike>::_Ret _UseStrcspnLikeAlgo;
  return __str_find_first_not_of_aux3(__first1, __last1, __first2, __last2, __traits, _UseStrcspnLikeAlgo());
}
template <class _InputIter, class _CharT, class _Traits>
inline _InputIter __str_find_first_not_of_aux1(_InputIter __first1, _InputIter __last1,
                                               const _CharT* __first2, const _CharT* __last2,
                                               _Traits* __traits, const __true_type& )
{ return __str_find_first_not_of_aux2(__first1, __last1, __first2, __last2,
                                      (typename ::stlp_std::iterator_traits< _InputIter >::value_type*)0, __traits); }
template <class _InputIter, class _CharT, class _Traits>
inline _InputIter __str_find_first_not_of_aux1(_InputIter __first1, _InputIter __last1,
                                               const _CharT* __first2, const _CharT* __last2,
                                               _Traits*, const __false_type& )
{ return ::stlp_std::find_if(__first1, __last1, ::stlp_std::priv:: _Not_within_traits<_Traits>(__first2, __last2)); }
template <class _InputIter, class _CharT, class _Traits>
inline _InputIter __str_find_first_not_of(_InputIter __first1, _InputIter __last1,
                                          const _CharT* __first2, const _CharT* __last2,
                                          _Traits* __traits) {
  typedef typename _IsSTLportClass<_Traits>::_Ret _STLportTraits;
  return __str_find_first_not_of_aux1(__first1, __last1, __first2, __last2, __traits, _STLportTraits());
}
}
template <class _CharT, class _Traits, class _Alloc>
void basic_string<_CharT,_Traits,_Alloc>::reserve(size_type __res_arg) {
  if (__res_arg > max_size())
    this->_M_throw_length_error();
  size_type __n = (max)(__res_arg, size()) + 1;
  if (__n < this->_M_capacity())
    return;
  _M_reserve(__n);
}
template <class _CharT, class _Traits, class _Alloc>
void basic_string<_CharT,_Traits,_Alloc>::_M_reserve(size_type __n) {
  pointer __new_start = this->_M_start_of_storage.allocate(__n, __n);
  pointer __new_finish = ::stlp_std::priv:: __ucopy(this->_M_Start(), this->_M_Finish(), __new_start);
  _M_construct_null(__new_finish);
  this->_M_deallocate_block();
  this->_M_reset(__new_start, __new_finish, __new_start + __n);
}
template <class _CharT, class _Traits, class _Alloc>
basic_string<_CharT,_Traits,_Alloc>&
basic_string<_CharT,_Traits,_Alloc>::append(size_type __n, _CharT __c) {
  if (__n > 0) {
    if (__n > max_size() - size())
      this->_M_throw_length_error();
    if (__n >= this->_M_rest())
      _M_reserve(_M_compute_next_size(__n));
    ::stlp_std::priv:: __uninitialized_fill_n(this->_M_finish + 1, __n - 1, __c);
    _M_construct_null(this->_M_finish + __n);
    _Traits::assign(*end(), __c);
    this->_M_finish += __n;
  }
  return *this;
}
template <class _CharT, class _Traits, class _Alloc>
basic_string<_CharT, _Traits, _Alloc>&
basic_string<_CharT, _Traits, _Alloc>::_M_append(const _CharT* __first, const _CharT* __last) {
  if (__first != __last) {
    size_type __n = static_cast<size_type>(__last - __first);
    if (__n >= this->_M_rest()) {
      size_type __len = _M_compute_next_size(__n);
      pointer __new_start = this->_M_start_of_storage.allocate(__len, __len);
      pointer __new_finish = ::stlp_std::priv:: __ucopy(this->_M_Start(), this->_M_Finish(), __new_start);
      __new_finish = ::stlp_std::priv:: __ucopy(__first, __last, __new_finish);
      _M_construct_null(__new_finish);
      this->_M_deallocate_block();
      this->_M_reset(__new_start, __new_finish, __new_start + __len);
    }
    else {
      const _CharT* __f1 = __first;
      ++__f1;
      ::stlp_std::priv:: __ucopy(__f1, __last, this->_M_finish + 1);
      _M_construct_null(this->_M_finish + __n);
      _Traits::assign(*end(), *__first);
      this->_M_finish += __n;
    }
  }
  return *this;
}
template <class _CharT, class _Traits, class _Alloc>
basic_string<_CharT,_Traits,_Alloc>&
basic_string<_CharT,_Traits,_Alloc>::assign(size_type __n, _CharT __c) {
  if (__n <= size()) {
    _Traits::assign(this->_M_Start(), __n, __c);
    erase(begin() + __n, end());
  }
  else {
    if (__n < capacity()) {
      _Traits::assign(this->_M_Start(), size(), __c);
      append(__n - size(), __c);
    }
    else {
      _Self __str(__n, __c);
      this->swap(__str);
    }
  }
  return *this;
}
template <class _CharT, class _Traits, class _Alloc>
basic_string<_CharT,_Traits,_Alloc>&
basic_string<_CharT,_Traits,_Alloc>::_M_assign(const _CharT* __f, const _CharT* __l) {
  ptrdiff_t __n = __l - __f;
  if (static_cast<size_type>(__n) <= size()) {
    _Traits::copy(this->_M_Start(), __f, __n);
    erase(begin() + __n, end());
  }
  else {
    _Traits::copy(this->_M_Start(), __f, size());
    _M_append(__f + size(), __l);
  }
  return *this;
}
template <class _CharT, class _Traits, class _Alloc>
_CharT* basic_string<_CharT,_Traits,_Alloc> ::_M_insert_aux(_CharT* __p,
                                                            _CharT __c) {
  pointer __new_pos = __p;
  if (this->_M_rest() > 1 ) {
    _M_construct_null(this->_M_finish + 1);
    _Traits::move(__p + 1, __p, this->_M_finish - __p);
    _Traits::assign(*__p, __c);
    ++this->_M_finish;
  }
  else {
    size_type __len = _M_compute_next_size(1);
    pointer __new_start = this->_M_start_of_storage.allocate(__len, __len);
    __new_pos = ::stlp_std::priv:: __ucopy(this->_M_Start(), __p, __new_start);
    _Traits::assign(*__new_pos, __c);
    pointer __new_finish = __new_pos + 1;
    __new_finish = ::stlp_std::priv:: __ucopy(__p, this->_M_finish, __new_finish);
    _M_construct_null(__new_finish);
    this->_M_deallocate_block();
    this->_M_reset(__new_start, __new_finish, __new_start + __len);
  }
  return __new_pos;
}
template <class _CharT, class _Traits, class _Alloc>
void basic_string<_CharT,_Traits,_Alloc>::insert(iterator __pos,
                                                 size_t __n, _CharT __c) {
  if (__n != 0) {
    if (this->_M_rest() > __n) {
      const size_type __elems_after = this->_M_finish - __pos;
      pointer __old_finish = this->_M_finish;
      if (__elems_after >= __n) {
        ::stlp_std::priv:: __ucopy((this->_M_finish - __n) + 1, this->_M_finish + 1, this->_M_finish + 1);
        this->_M_finish += __n;
        _Traits::move(__pos + __n, __pos, (__elems_after - __n) + 1);
        _Traits::assign(__pos, __n, __c);
      }
      else {
        ::stlp_std::priv:: __uninitialized_fill_n(this->_M_finish + 1, __n - __elems_after - 1, __c);
        this->_M_finish += __n - __elems_after;
        ::stlp_std::priv:: __ucopy(__pos, __old_finish + 1, this->_M_finish);
        this->_M_finish += __elems_after;
        _Traits::assign(__pos, __elems_after + 1, __c);
      }
    }
    else {
      size_type __len = _M_compute_next_size(__n);
      pointer __new_start = this->_M_start_of_storage.allocate(__len, __len);
      pointer __new_finish = ::stlp_std::priv:: __ucopy(this->_M_Start(), __pos, __new_start);
      __new_finish = ::stlp_std::priv:: __uninitialized_fill_n(__new_finish, __n, __c);
      __new_finish = ::stlp_std::priv:: __ucopy(__pos, this->_M_finish, __new_finish);
      _M_construct_null(__new_finish);
      this->_M_deallocate_block();
      this->_M_reset(__new_start, __new_finish, __new_start + __len);
    }
  }
}
template <class _CharT, class _Traits, class _Alloc>
void basic_string<_CharT,_Traits,_Alloc>::_M_insert(iterator __pos,
                                                    const _CharT* __first, const _CharT* __last,
                                                    bool __self_ref) {
  if (__first != __last) {
    const size_t __n = __last - __first;
    if (this->_M_rest() > __n) {
      const size_t __elems_after = this->_M_finish - __pos;
      pointer __old_finish = this->_M_finish;
      if (__elems_after >= __n) {
        ::stlp_std::priv:: __ucopy((this->_M_finish - __n) + 1, this->_M_finish + 1, this->_M_finish + 1);
        this->_M_finish += __n;
        _Traits::move(__pos + __n, __pos, (__elems_after - __n) + 1);
        if (!__self_ref || __last < __pos) {
          _M_copy(__first, __last, __pos);
        }
        else {
          if (__first >= __pos) {
            __first += __n;
            __last += __n;
            _M_copy(__first, __last, __pos);
          }
          else {
            _M_move(__first, __last, __pos);
          }
        }
      }
      else {
        const_iterator __mid = __first;
        __mid += __elems_after + 1;
        ::stlp_std::priv:: __ucopy(__mid, __last, this->_M_finish + 1);
        this->_M_finish += __n - __elems_after;
        ::stlp_std::priv:: __ucopy(__pos, __old_finish + 1, this->_M_finish);
        this->_M_finish += __elems_after;
        if (!__self_ref)
          _M_copy(__first, __mid, __pos);
        else
          _M_move(__first, __mid, __pos);
      }
    }
    else {
      size_type __len = _M_compute_next_size(__n);
      pointer __new_start = this->_M_start_of_storage.allocate(__len, __len);
      pointer __new_finish = ::stlp_std::priv:: __ucopy(this->_M_Start(), __pos, __new_start);
      __new_finish = ::stlp_std::priv:: __ucopy(__first, __last, __new_finish);
      __new_finish = ::stlp_std::priv:: __ucopy(__pos, this->_M_finish, __new_finish);
      _M_construct_null(__new_finish);
      this->_M_deallocate_block();
      this->_M_reset(__new_start, __new_finish, __new_start + __len);
    }
  }
}
template <class _CharT, class _Traits, class _Alloc>
basic_string<_CharT,_Traits,_Alloc>&
basic_string<_CharT,_Traits,_Alloc> ::replace(iterator __first, iterator __last,
                                              size_type __n, _CharT __c) {
  size_type __len = (size_type)(__last - __first);
  if (__len >= __n) {
    _Traits::assign(__first, __n, __c);
    erase(__first + __n, __last);
  }
  else {
    _Traits::assign(__first, __len, __c);
    insert(__last, __n - __len, __c);
  }
  return *this;
}
template <class _CharT, class _Traits, class _Alloc>
basic_string<_CharT,_Traits,_Alloc>&
basic_string<_CharT,_Traits,_Alloc> ::_M_replace(iterator __first, iterator __last,
                                                 const _CharT* __f, const _CharT* __l,
                                                 bool __self_ref) {
  const ptrdiff_t __n = __l - __f;
  const difference_type __len = __last - __first;
  if (__len >= __n) {
    if (!__self_ref || __l < __first || __f >= __last)
      _M_copy(__f, __l, __first);
    else
      _M_move(__f, __l, __first);
    erase(__first + __n, __last);
  } else if (!__self_ref || (__f >= __last) || (__l <= __first)) {
    const_iterator __m = __f + __len;
    _M_copy(__f, __m, __first);
    _M_insert(__last, __m, __l, __self_ref );
  } else if (__f < __first) {
    const_iterator __m = __f + __len;
    const difference_type __off_dest = __first - this->begin();
    const difference_type __off_src = __f - this->begin();
    _M_insert(__last, __m, __l, true);
    _Traits::move(begin() + __off_dest, begin() + __off_src, __len);
  } else {
    const_iterator __m = __f + __len;
    _Traits::move(__first, __f, __len);
    _M_insert(__last, __m, __l, true);
  }
  return *this;
}
template <class _CharT, class _Traits, class _Alloc>
typename basic_string<_CharT,_Traits,_Alloc>::size_type basic_string<_CharT,_Traits,_Alloc>::find( const _CharT* __s, size_type __pos,
                                                         size_type __n) const
{
  const size_t __len = size();
  if (__pos >= __len || __pos + __n > __len) {
    if ( __n == 0 && __pos <= __len ) {
      return __pos;
    }
    return npos;
  }
  const_pointer __result =
    ::stlp_std::search(this->_M_Start() + __pos, this->_M_Finish(),
                      __s, __s + __n, ::stlp_std::priv:: _Eq_traits<_Traits>());
  return __result != this->_M_Finish() ? __result - this->_M_Start() : npos;
}
template <class _CharT, class _Traits, class _Alloc>
typename basic_string<_CharT,_Traits,_Alloc>::size_type basic_string<_CharT,_Traits,_Alloc>::find(_CharT __c, size_type __pos) const
{
  if (__pos >= size()) {
    return npos;
  }
  const_pointer __result =
    ::stlp_std::find_if(this->_M_Start() + __pos, this->_M_Finish(),
                       ::stlp_std::priv:: _Eq_char_bound<_Traits>(__c));
  return __result != this->_M_Finish() ? __result - this->_M_Start() : npos;
}
template <class _CharT, class _Traits, class _Alloc>
typename basic_string<_CharT,_Traits,_Alloc>::size_type basic_string<_CharT,_Traits,_Alloc>::rfind(const _CharT* __s, size_type __pos,
                                                         size_type __n) const
{
  const size_type __len = size();
  if ( __len < __n ) {
    return npos;
  }
  const_pointer __last = this->_M_Start() + (min)( __len - __n, __pos) + __n;
  if ( __n == 0 ) {
    return __last - this->_M_Start();
  }
  const_pointer __result = ::stlp_std::find_end(this->_M_Start(), __last,
                                               __s, __s + __n, ::stlp_std::priv:: _Eq_traits<_Traits>());
  return __result != __last ? __result - this->_M_Start() : npos;
}
template <class _CharT, class _Traits, class _Alloc>
typename basic_string<_CharT,_Traits,_Alloc>::size_type basic_string<_CharT,_Traits,_Alloc>::rfind(_CharT __c, size_type __pos) const
{
  const size_type __len = size();
  if ( __len < 1 ) {
    return npos;
  }
  const_iterator __last = begin() + (min)(__len - 1, __pos) + 1;
  const_reverse_iterator __rresult =
    ::stlp_std::find_if(const_reverse_iterator(__last), rend(),
                       ::stlp_std::priv:: _Eq_char_bound<_Traits>(__c));
  return __rresult != rend() ? (__rresult.base() - 1) - begin() : npos;
}
template <class _CharT, class _Traits, class _Alloc> typename basic_string<_CharT,_Traits,_Alloc>::size_type
basic_string<_CharT,_Traits,_Alloc> ::find_first_of(const _CharT* __s, size_type __pos,
                                                    size_type __n) const {
  if (__pos >= size())
    return npos;
  else {
    const_iterator __result = ::stlp_std::priv:: __str_find_first_of(begin() + __pos, end(),
                                                             __s, __s + __n,
                                                             static_cast<_Traits*>(0));
    return __result != end() ? __result - begin() : npos;
  }
}
template <class _CharT, class _Traits, class _Alloc>
 typename basic_string<_CharT,_Traits,_Alloc>::size_type
basic_string<_CharT,_Traits,_Alloc> ::find_last_of(const _CharT* __s, size_type __pos,
                                                   size_type __n) const
{
  const size_type __len = size();
  if ( __len < 1 ) {
    return npos;
  }
  const const_iterator __last = begin() + (min)(__len - 1, __pos) + 1;
  const const_reverse_iterator __rresult =
    ::stlp_std::priv:: __str_find_first_of(const_reverse_iterator(__last), rend(),
                                   __s, __s + __n,
                                   static_cast<_Traits*>(0));
  return __rresult != rend() ? (__rresult.base() - 1) - begin() : npos;
}
template <class _CharT, class _Traits, class _Alloc> typename basic_string<_CharT,_Traits,_Alloc>::size_type
basic_string<_CharT,_Traits,_Alloc> ::find_first_not_of(const _CharT* __s, size_type __pos,
                                                        size_type __n) const {
  typedef typename _Traits::char_type _CharType;
  if (__pos >= size())
    return npos;
  else {
    const_pointer __result = ::stlp_std::priv:: __str_find_first_not_of(this->_M_Start() + __pos, this->_M_Finish(),
                                                                static_cast<const _CharType*>(__s),
                                                                static_cast<const _CharType*>(__s) + __n,
                                                                static_cast<_Traits*>(0));
    return __result != this->_M_finish ? __result - this->_M_Start() : npos;
  }
}
template <class _CharT, class _Traits, class _Alloc> typename basic_string<_CharT,_Traits,_Alloc>::size_type
basic_string<_CharT,_Traits,_Alloc> ::find_first_not_of(_CharT __c, size_type __pos) const {
  if (1 > size())
    return npos;
  else {
    const_pointer __result = ::stlp_std::find_if(this->_M_Start() + __pos, this->_M_Finish(),
                                                ::stlp_std::priv:: _Neq_char_bound<_Traits>(__c));
    return __result != this->_M_finish ? __result - this->_M_Start() : npos;
  }
}
template <class _CharT, class _Traits, class _Alloc>
typename basic_string<_CharT,_Traits,_Alloc>::size_type
basic_string<_CharT,_Traits,_Alloc>::find_last_not_of(const _CharT* __s, size_type __pos, size_type __n) const
{
  typedef typename _Traits::char_type _CharType;
  const size_type __len = size();
  if ( __len < 1 ) {
    return npos;
  }
  const_iterator __last = begin() + (min)(__len - 1, __pos) + 1;
  const_reverse_iterator __rlast = const_reverse_iterator(__last);
  const_reverse_iterator __rresult =
    ::stlp_std::priv:: __str_find_first_not_of(__rlast, rend(),
                                       static_cast<const _CharType*>(__s),
                                       static_cast<const _CharType*>(__s) + __n,
                                       static_cast<_Traits*>(0));
  return __rresult != rend() ? (__rresult.base() - 1) - begin() : npos;
}
template <class _CharT, class _Traits, class _Alloc>
typename basic_string<_CharT,_Traits,_Alloc>::size_type
basic_string<_CharT, _Traits, _Alloc>::find_last_not_of(_CharT __c, size_type __pos) const
{
  const size_type __len = size();
  if ( __len < 1 ) {
    return npos;
  }
  const_iterator __last = begin() + (min)(__len - 1, __pos) + 1;
  const_reverse_iterator __rlast = const_reverse_iterator(__last);
  const_reverse_iterator __rresult =
    ::stlp_std::find_if(__rlast, rend(),
                       ::stlp_std::priv:: _Neq_char_bound<_Traits>(__c));
  return __rresult != rend() ? (__rresult.base() - 1) - begin() : npos;
}
namespace priv {
template <class _CharT, class _Traits, class _Alloc>
void _S_string_copy(const basic_string<_CharT,_Traits,_Alloc>& __s,
                               _CharT* __buf, size_t __n) {
  if (__n > 0) {
    __n = (min) (__n - 1, __s.size());
    ::stlp_std::copy(__s.begin(), __s.begin() + __n, __buf);
    __buf[__n] = _CharT();
  }
}
}
}
namespace stlp_std {
void __attribute__((noreturn)) __attribute__((visibility("default"))) __stl_throw_runtime_error(const char* __msg);
void __attribute__((noreturn)) __attribute__((visibility("default"))) __stl_throw_range_error(const char* __msg);
void __attribute__((noreturn)) __attribute__((visibility("default"))) __stl_throw_out_of_range(const char* __msg);
void __attribute__((noreturn)) __attribute__((visibility("default"))) __stl_throw_length_error(const char* __msg);
void __attribute__((noreturn)) __attribute__((visibility("default"))) __stl_throw_invalid_argument(const char* __msg);
void __attribute__((noreturn)) __attribute__((visibility("default"))) __stl_throw_overflow_error(const char* __msg);
}
namespace stlp_std {
namespace priv {
template <class _Tp, class _Alloc>
void _String_base<_Tp,_Alloc>::_M_throw_length_error() const
{ __stl_throw_length_error("basic_string"); }
template <class _Tp, class _Alloc>
void _String_base<_Tp, _Alloc>::_M_throw_out_of_range() const
{ __stl_throw_out_of_range("basic_string"); }
template <class _Tp, class _Alloc>
void _String_base<_Tp, _Alloc>::_M_allocate_block(size_t __n) {
  if ((__n <= (max_size() + 1)) && (__n > 0)) {
    if (__n > _DEFAULT_SIZE) {
      this->_M_start_of_storage._M_data = _M_start_of_storage.allocate(__n, __n);
      this->_M_finish = this->_M_start_of_storage._M_data;
      this->_M_buffers._M_end_of_storage = this->_M_start_of_storage._M_data + __n;
    }
  } else {
    this->_M_throw_length_error();
  }
}
}
template <class _CharT, class _Traits, class _Alloc>
basic_string<_CharT, _Traits, _Alloc>::basic_string(const _CharT* __s,
                                                    const allocator_type& __a)
  : ::stlp_std::priv:: _String_base<_CharT,_Alloc>(__a) {
 
  _M_range_initialize(__s, __s + traits_type::length(__s));
}
template <class _CharT, class _Traits, class _Alloc>
basic_string<_CharT, _Traits, _Alloc>::basic_string(const basic_string<_CharT, _Traits, _Alloc> & __s)
  : ::stlp_std::priv:: _String_base<_CharT,_Alloc>(__s.get_allocator())
{ _M_range_initialize(__s._M_Start(), __s._M_Finish()); }
template <class _CharT, class _Traits, class _Alloc>
const size_t basic_string<_CharT, _Traits, _Alloc>::npos;
}
namespace stlp_std {
template <class _Key> struct hash { };
namespace priv {
inline size_t __stl_hash_string(const char* __s) {
 
  unsigned long __h = 0;
  for ( ; *__s; ++__s)
    __h = 5*__h + *__s;
  return size_t(__h);
}
}
template<>
struct hash<char*> {
  size_t operator()(const char* __s) const {
   
    return ::stlp_std::priv:: __stl_hash_string(__s);
  }
};
template<>
struct hash<const char*> {
  size_t operator()(const char* __s) const {
   
    return ::stlp_std::priv:: __stl_hash_string(__s);
  }
};
template<> struct hash<char> {
  size_t operator()(char __x) const { return __x; }
};
template<> struct hash<unsigned char> {
  size_t operator()(unsigned char __x) const { return __x; }
};
template<> struct hash<signed char> {
  size_t operator()(unsigned char __x) const { return __x; }
};
template<> struct hash<short> {
  size_t operator()(short __x) const { return __x; }
};
template<> struct hash<unsigned short> {
  size_t operator()(unsigned short __x) const { return __x; }
};
template<> struct hash<int> {
  size_t operator()(int __x) const { return __x; }
};
template<> struct hash<unsigned int> {
  size_t operator()(unsigned int __x) const { return __x; }
};
template<> struct hash<long> {
  size_t operator()(long __x) const { return __x; }
};
template<> struct hash<unsigned long> {
  size_t operator()(unsigned long __x) const { return __x; }
};
template<> struct hash<long long> {
  size_t operator()(long long x) const { return (size_t)x; }
};
template<> struct hash<unsigned long long> {
  size_t operator()(unsigned long long x) const { return (size_t)x; }
};
template<>
struct hash<void *>
{
    union __vp {
        size_t s;
        void *p;
    };
    size_t operator()(void *__x) const
      {
        __vp vp;
        vp.p = __x;
        return vp.s;
      }
};
}
namespace stlp_std {
template <class _CharT, class _Traits, class _Alloc>
inline size_t
__stl_string_hash(const basic_string<_CharT,_Traits,_Alloc>& __s) {
  unsigned long __h = 0;
  size_t __len = __s.size();
  const _CharT* __data = __s.data();
  for ( size_t __i = 0; __i < __len; ++__i)
    __h = (__h << 2) + __h + __data[__i];
  return size_t(__h);
}
template <class _CharT, class _Traits, class _Alloc>
struct hash<basic_string<_CharT,_Traits,_Alloc> > {
  size_t operator()(const basic_string<_CharT,_Traits,_Alloc>& __s) const
    { return __stl_string_hash(__s); }
};
}
namespace stlp_std {
using std::exception;
using std::bad_exception;
using std::unexpected;
using std::unexpected_handler;
using std::set_unexpected;
using std::terminate;
using std::terminate_handler;
using std::set_terminate;
using std::uncaught_exception;
}
namespace stlp_std {
using std::exception;
class __attribute__((visibility("default"))) __Named_exception : public exception {
public:
  __Named_exception(const string& __str);
  __Named_exception(const __Named_exception&);
  __Named_exception& operator = (const __Named_exception&);
  const char* what() const throw();
  ~__Named_exception() throw();
private:
  enum { _S_bufsize = 256 };
  char _M_static_name[_S_bufsize];
  char *_M_name;
};
}
struct sched_param
  {
    int __sched_priority;
  };
extern "C" {
extern int clone (int (*__fn) (void *__arg), void *__child_stack,
    int __flags, void *__arg, ...) throw ();
extern int unshare (int __flags) throw ();
extern int sched_getcpu (void) throw ();
}
struct __sched_param
  {
    int __sched_priority;
  };
typedef unsigned long int __cpu_mask;
typedef struct
{
  __cpu_mask __bits[1024 / (8 * sizeof (__cpu_mask))];
} cpu_set_t;
extern "C" {
extern int __sched_cpucount (size_t __setsize, const cpu_set_t *__setp)
  throw ();
extern cpu_set_t *__sched_cpualloc (size_t __count) throw () ;
extern void __sched_cpufree (cpu_set_t *__set) throw ();
}
extern "C" {
extern int sched_setparam (__pid_t __pid, __const struct sched_param *__param)
     throw ();
extern int sched_getparam (__pid_t __pid, struct sched_param *__param) throw ();
extern int sched_setscheduler (__pid_t __pid, int __policy,
          __const struct sched_param *__param) throw ();
extern int sched_getscheduler (__pid_t __pid) throw ();
extern int sched_yield (void) throw ();
extern int sched_get_priority_max (int __algorithm) throw ();
extern int sched_get_priority_min (int __algorithm) throw ();
extern int sched_rr_get_interval (__pid_t __pid, struct timespec *__t) throw ();
extern int sched_setaffinity (__pid_t __pid, size_t __cpusetsize,
         __const cpu_set_t *__cpuset) throw ();
extern int sched_getaffinity (__pid_t __pid, size_t __cpusetsize,
         cpu_set_t *__cpuset) throw ();
}
extern "C" {
struct tm
{
  int tm_sec;
  int tm_min;
  int tm_hour;
  int tm_mday;
  int tm_mon;
  int tm_year;
  int tm_wday;
  int tm_yday;
  int tm_isdst;
  long int tm_gmtoff;
  __const char *tm_zone;
};
struct itimerspec
  {
    struct timespec it_interval;
    struct timespec it_value;
  };
struct sigevent;
extern clock_t clock (void) throw ();
extern time_t time (time_t *__timer) throw ();
extern double difftime (time_t __time1, time_t __time0)
     throw () __attribute__ ((__const__));
extern time_t mktime (struct tm *__tp) throw ();
extern size_t strftime (char *__restrict __s, size_t __maxsize,
   __const char *__restrict __format,
   __const struct tm *__restrict __tp) throw ();
extern char *strptime (__const char *__restrict __s,
         __const char *__restrict __fmt, struct tm *__tp)
     throw ();
extern size_t strftime_l (char *__restrict __s, size_t __maxsize,
     __const char *__restrict __format,
     __const struct tm *__restrict __tp,
     __locale_t __loc) throw ();
extern char *strptime_l (__const char *__restrict __s,
    __const char *__restrict __fmt, struct tm *__tp,
    __locale_t __loc) throw ();
extern struct tm *gmtime (__const time_t *__timer) throw ();
extern struct tm *localtime (__const time_t *__timer) throw ();
extern struct tm *gmtime_r (__const time_t *__restrict __timer,
       struct tm *__restrict __tp) throw ();
extern struct tm *localtime_r (__const time_t *__restrict __timer,
          struct tm *__restrict __tp) throw ();
extern char *asctime (__const struct tm *__tp) throw ();
extern char *ctime (__const time_t *__timer) throw ();
extern char *asctime_r (__const struct tm *__restrict __tp,
   char *__restrict __buf) throw ();
extern char *ctime_r (__const time_t *__restrict __timer,
        char *__restrict __buf) throw ();
extern char *__tzname[2];
extern int __daylight;
extern long int __timezone;
extern char *tzname[2];
extern void tzset (void) throw ();
extern int daylight;
extern long int timezone;
extern int stime (__const time_t *__when) throw ();
extern time_t timegm (struct tm *__tp) throw ();
extern time_t timelocal (struct tm *__tp) throw ();
extern int dysize (int __year) throw () __attribute__ ((__const__));
extern int nanosleep (__const struct timespec *__requested_time,
        struct timespec *__remaining);
extern int clock_getres (clockid_t __clock_id, struct timespec *__res) throw ();
extern int clock_gettime (clockid_t __clock_id, struct timespec *__tp) throw ();
extern int clock_settime (clockid_t __clock_id, __const struct timespec *__tp)
     throw ();
extern int clock_nanosleep (clockid_t __clock_id, int __flags,
       __const struct timespec *__req,
       struct timespec *__rem);
extern int clock_getcpuclockid (pid_t __pid, clockid_t *__clock_id) throw ();
extern int timer_create (clockid_t __clock_id,
    struct sigevent *__restrict __evp,
    timer_t *__restrict __timerid) throw ();
extern int timer_delete (timer_t __timerid) throw ();
extern int timer_settime (timer_t __timerid, int __flags,
     __const struct itimerspec *__restrict __value,
     struct itimerspec *__restrict __ovalue) throw ();
extern int timer_gettime (timer_t __timerid, struct itimerspec *__value)
     throw ();
extern int timer_getoverrun (timer_t __timerid) throw ();
extern int getdate_err;
extern struct tm *getdate (__const char *__string);
extern int getdate_r (__const char *__restrict __string,
        struct tm *__restrict __resbufp);
}
extern "C" {
}
typedef long int __jmp_buf[8];
enum
{
  PTHREAD_CREATE_JOINABLE,
  PTHREAD_CREATE_DETACHED
};
enum
{
  PTHREAD_MUTEX_TIMED_NP,
  PTHREAD_MUTEX_RECURSIVE_NP,
  PTHREAD_MUTEX_ERRORCHECK_NP,
  PTHREAD_MUTEX_ADAPTIVE_NP
  ,
  PTHREAD_MUTEX_NORMAL = PTHREAD_MUTEX_TIMED_NP,
  PTHREAD_MUTEX_RECURSIVE = PTHREAD_MUTEX_RECURSIVE_NP,
  PTHREAD_MUTEX_ERRORCHECK = PTHREAD_MUTEX_ERRORCHECK_NP,
  PTHREAD_MUTEX_DEFAULT = PTHREAD_MUTEX_NORMAL
  , PTHREAD_MUTEX_FAST_NP = PTHREAD_MUTEX_TIMED_NP
};
enum
{
  PTHREAD_MUTEX_STALLED_NP,
  PTHREAD_MUTEX_ROBUST_NP
};
enum
{
  PTHREAD_PRIO_NONE,
  PTHREAD_PRIO_INHERIT,
  PTHREAD_PRIO_PROTECT
};
enum
{
  PTHREAD_RWLOCK_PREFER_READER_NP,
  PTHREAD_RWLOCK_PREFER_WRITER_NP,
  PTHREAD_RWLOCK_PREFER_WRITER_NONRECURSIVE_NP,
  PTHREAD_RWLOCK_DEFAULT_NP = PTHREAD_RWLOCK_PREFER_READER_NP
};
enum
{
  PTHREAD_INHERIT_SCHED,
  PTHREAD_EXPLICIT_SCHED
};
enum
{
  PTHREAD_SCOPE_SYSTEM,
  PTHREAD_SCOPE_PROCESS
};
enum
{
  PTHREAD_PROCESS_PRIVATE,
  PTHREAD_PROCESS_SHARED
};
struct _pthread_cleanup_buffer
{
  void (*__routine) (void *);
  void *__arg;
  int __canceltype;
  struct _pthread_cleanup_buffer *__prev;
};
enum
{
  PTHREAD_CANCEL_ENABLE,
  PTHREAD_CANCEL_DISABLE
};
enum
{
  PTHREAD_CANCEL_DEFERRED,
  PTHREAD_CANCEL_ASYNCHRONOUS
};
extern "C" {
extern int pthread_create (pthread_t *__restrict __newthread,
      __const pthread_attr_t *__restrict __attr,
      void *(*__start_routine) (void *),
      void *__restrict __arg) throw () __attribute__ ((__nonnull__ (1, 3)));
extern void pthread_exit (void *__retval) __attribute__ ((__noreturn__));
extern int pthread_join (pthread_t __th, void **__thread_return);
extern int pthread_tryjoin_np (pthread_t __th, void **__thread_return) throw ();
extern int pthread_timedjoin_np (pthread_t __th, void **__thread_return,
     __const struct timespec *__abstime);
extern int pthread_detach (pthread_t __th) throw ();
extern pthread_t pthread_self (void) throw () __attribute__ ((__const__));
extern int pthread_equal (pthread_t __thread1, pthread_t __thread2) throw ();
extern int pthread_attr_init (pthread_attr_t *__attr) throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_attr_destroy (pthread_attr_t *__attr)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_attr_getdetachstate (__const pthread_attr_t *__attr,
     int *__detachstate)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern int pthread_attr_setdetachstate (pthread_attr_t *__attr,
     int __detachstate)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_attr_getguardsize (__const pthread_attr_t *__attr,
          size_t *__guardsize)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern int pthread_attr_setguardsize (pthread_attr_t *__attr,
          size_t __guardsize)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_attr_getschedparam (__const pthread_attr_t *__restrict
           __attr,
           struct sched_param *__restrict __param)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern int pthread_attr_setschedparam (pthread_attr_t *__restrict __attr,
           __const struct sched_param *__restrict
           __param) throw () __attribute__ ((__nonnull__ (1, 2)));
extern int pthread_attr_getschedpolicy (__const pthread_attr_t *__restrict
     __attr, int *__restrict __policy)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern int pthread_attr_setschedpolicy (pthread_attr_t *__attr, int __policy)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_attr_getinheritsched (__const pthread_attr_t *__restrict
      __attr, int *__restrict __inherit)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern int pthread_attr_setinheritsched (pthread_attr_t *__attr,
      int __inherit)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_attr_getscope (__const pthread_attr_t *__restrict __attr,
      int *__restrict __scope)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern int pthread_attr_setscope (pthread_attr_t *__attr, int __scope)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_attr_getstackaddr (__const pthread_attr_t *__restrict
          __attr, void **__restrict __stackaddr)
     throw () __attribute__ ((__nonnull__ (1, 2))) __attribute__ ((__deprecated__));
extern int pthread_attr_setstackaddr (pthread_attr_t *__attr,
          void *__stackaddr)
     throw () __attribute__ ((__nonnull__ (1))) __attribute__ ((__deprecated__));
extern int pthread_attr_getstacksize (__const pthread_attr_t *__restrict
          __attr, size_t *__restrict __stacksize)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern int pthread_attr_setstacksize (pthread_attr_t *__attr,
          size_t __stacksize)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_attr_getstack (__const pthread_attr_t *__restrict __attr,
      void **__restrict __stackaddr,
      size_t *__restrict __stacksize)
     throw () __attribute__ ((__nonnull__ (1, 2, 3)));
extern int pthread_attr_setstack (pthread_attr_t *__attr, void *__stackaddr,
      size_t __stacksize) throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_attr_setaffinity_np (pthread_attr_t *__attr,
     size_t __cpusetsize,
     __const cpu_set_t *__cpuset)
     throw () __attribute__ ((__nonnull__ (1, 3)));
extern int pthread_attr_getaffinity_np (__const pthread_attr_t *__attr,
     size_t __cpusetsize,
     cpu_set_t *__cpuset)
     throw () __attribute__ ((__nonnull__ (1, 3)));
extern int pthread_getattr_np (pthread_t __th, pthread_attr_t *__attr)
     throw () __attribute__ ((__nonnull__ (2)));
extern int pthread_setschedparam (pthread_t __target_thread, int __policy,
      __const struct sched_param *__param)
     throw () __attribute__ ((__nonnull__ (3)));
extern int pthread_getschedparam (pthread_t __target_thread,
      int *__restrict __policy,
      struct sched_param *__restrict __param)
     throw () __attribute__ ((__nonnull__ (2, 3)));
extern int pthread_setschedprio (pthread_t __target_thread, int __prio)
     throw ();
extern int pthread_getconcurrency (void) throw ();
extern int pthread_setconcurrency (int __level) throw ();
extern int pthread_yield (void) throw ();
extern int pthread_setaffinity_np (pthread_t __th, size_t __cpusetsize,
       __const cpu_set_t *__cpuset)
     throw () __attribute__ ((__nonnull__ (3)));
extern int pthread_getaffinity_np (pthread_t __th, size_t __cpusetsize,
       cpu_set_t *__cpuset)
     throw () __attribute__ ((__nonnull__ (3)));
extern int pthread_once (pthread_once_t *__once_control,
    void (*__init_routine) (void)) __attribute__ ((__nonnull__ (1, 2)));
extern int pthread_setcancelstate (int __state, int *__oldstate);
extern int pthread_setcanceltype (int __type, int *__oldtype);
extern int pthread_cancel (pthread_t __th);
extern void pthread_testcancel (void);
typedef struct
{
  struct
  {
    __jmp_buf __cancel_jmp_buf;
    int __mask_was_saved;
  } __cancel_jmp_buf[1];
  void *__pad[4];
} __pthread_unwind_buf_t __attribute__ ((__aligned__));
struct __pthread_cleanup_frame
{
  void (*__cancel_routine) (void *);
  void *__cancel_arg;
  int __do_it;
  int __cancel_type;
};
class __pthread_cleanup_class
{
  void (*__cancel_routine) (void *);
  void *__cancel_arg;
  int __do_it;
  int __cancel_type;
 public:
  __pthread_cleanup_class (void (*__fct) (void *), void *__arg)
    : __cancel_routine (__fct), __cancel_arg (__arg), __do_it (1) { }
  ~__pthread_cleanup_class () { if (__do_it) __cancel_routine (__cancel_arg); }
  void __setdoit (int __newval) { __do_it = __newval; }
  void __defer () { pthread_setcanceltype (PTHREAD_CANCEL_DEFERRED,
        &__cancel_type); }
  void __restore () const { pthread_setcanceltype (__cancel_type, 0); }
};
struct __jmp_buf_tag;
extern int __sigsetjmp (struct __jmp_buf_tag *__env, int __savemask) throw ();
extern int pthread_mutex_init (pthread_mutex_t *__mutex,
          __const pthread_mutexattr_t *__mutexattr)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_mutex_destroy (pthread_mutex_t *__mutex)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_mutex_trylock (pthread_mutex_t *__mutex)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_mutex_lock (pthread_mutex_t *__mutex)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_mutex_timedlock (pthread_mutex_t *__restrict __mutex,
                                    __const struct timespec *__restrict
                                    __abstime) throw () __attribute__ ((__nonnull__ (1, 2)));
extern int pthread_mutex_unlock (pthread_mutex_t *__mutex)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_mutex_getprioceiling (__const pthread_mutex_t *
      __restrict __mutex,
      int *__restrict __prioceiling)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern int pthread_mutex_setprioceiling (pthread_mutex_t *__restrict __mutex,
      int __prioceiling,
      int *__restrict __old_ceiling)
     throw () __attribute__ ((__nonnull__ (1, 3)));
extern int pthread_mutex_consistent_np (pthread_mutex_t *__mutex)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_mutexattr_init (pthread_mutexattr_t *__attr)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_mutexattr_destroy (pthread_mutexattr_t *__attr)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_mutexattr_getpshared (__const pthread_mutexattr_t *
      __restrict __attr,
      int *__restrict __pshared)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern int pthread_mutexattr_setpshared (pthread_mutexattr_t *__attr,
      int __pshared)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_mutexattr_gettype (__const pthread_mutexattr_t *__restrict
          __attr, int *__restrict __kind)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern int pthread_mutexattr_settype (pthread_mutexattr_t *__attr, int __kind)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_mutexattr_getprotocol (__const pthread_mutexattr_t *
       __restrict __attr,
       int *__restrict __protocol)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern int pthread_mutexattr_setprotocol (pthread_mutexattr_t *__attr,
       int __protocol)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_mutexattr_getprioceiling (__const pthread_mutexattr_t *
          __restrict __attr,
          int *__restrict __prioceiling)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern int pthread_mutexattr_setprioceiling (pthread_mutexattr_t *__attr,
          int __prioceiling)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_mutexattr_getrobust_np (__const pthread_mutexattr_t *__attr,
        int *__robustness)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern int pthread_mutexattr_setrobust_np (pthread_mutexattr_t *__attr,
        int __robustness)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_rwlock_init (pthread_rwlock_t *__restrict __rwlock,
    __const pthread_rwlockattr_t *__restrict
    __attr) throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_rwlock_destroy (pthread_rwlock_t *__rwlock)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_rwlock_rdlock (pthread_rwlock_t *__rwlock)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_rwlock_tryrdlock (pthread_rwlock_t *__rwlock)
  throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_rwlock_timedrdlock (pthread_rwlock_t *__restrict __rwlock,
           __const struct timespec *__restrict
           __abstime) throw () __attribute__ ((__nonnull__ (1, 2)));
extern int pthread_rwlock_wrlock (pthread_rwlock_t *__rwlock)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_rwlock_trywrlock (pthread_rwlock_t *__rwlock)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_rwlock_timedwrlock (pthread_rwlock_t *__restrict __rwlock,
           __const struct timespec *__restrict
           __abstime) throw () __attribute__ ((__nonnull__ (1, 2)));
extern int pthread_rwlock_unlock (pthread_rwlock_t *__rwlock)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_rwlockattr_init (pthread_rwlockattr_t *__attr)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_rwlockattr_destroy (pthread_rwlockattr_t *__attr)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_rwlockattr_getpshared (__const pthread_rwlockattr_t *
       __restrict __attr,
       int *__restrict __pshared)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern int pthread_rwlockattr_setpshared (pthread_rwlockattr_t *__attr,
       int __pshared)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_rwlockattr_getkind_np (__const pthread_rwlockattr_t *
       __restrict __attr,
       int *__restrict __pref)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern int pthread_rwlockattr_setkind_np (pthread_rwlockattr_t *__attr,
       int __pref) throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_cond_init (pthread_cond_t *__restrict __cond,
         __const pthread_condattr_t *__restrict
         __cond_attr) throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_cond_destroy (pthread_cond_t *__cond)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_cond_signal (pthread_cond_t *__cond)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_cond_broadcast (pthread_cond_t *__cond)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_cond_wait (pthread_cond_t *__restrict __cond,
         pthread_mutex_t *__restrict __mutex)
     __attribute__ ((__nonnull__ (1, 2)));
extern int pthread_cond_timedwait (pthread_cond_t *__restrict __cond,
       pthread_mutex_t *__restrict __mutex,
       __const struct timespec *__restrict
       __abstime) __attribute__ ((__nonnull__ (1, 2, 3)));
extern int pthread_condattr_init (pthread_condattr_t *__attr)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_condattr_destroy (pthread_condattr_t *__attr)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_condattr_getpshared (__const pthread_condattr_t *
                                        __restrict __attr,
                                        int *__restrict __pshared)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern int pthread_condattr_setpshared (pthread_condattr_t *__attr,
                                        int __pshared) throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_condattr_getclock (__const pthread_condattr_t *
          __restrict __attr,
          __clockid_t *__restrict __clock_id)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern int pthread_condattr_setclock (pthread_condattr_t *__attr,
          __clockid_t __clock_id)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_spin_init (pthread_spinlock_t *__lock, int __pshared)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_spin_destroy (pthread_spinlock_t *__lock)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_spin_lock (pthread_spinlock_t *__lock)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_spin_trylock (pthread_spinlock_t *__lock)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_spin_unlock (pthread_spinlock_t *__lock)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_barrier_init (pthread_barrier_t *__restrict __barrier,
     __const pthread_barrierattr_t *__restrict
     __attr, unsigned int __count)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_barrier_destroy (pthread_barrier_t *__barrier)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_barrier_wait (pthread_barrier_t *__barrier)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_barrierattr_init (pthread_barrierattr_t *__attr)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_barrierattr_destroy (pthread_barrierattr_t *__attr)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_barrierattr_getpshared (__const pthread_barrierattr_t *
        __restrict __attr,
        int *__restrict __pshared)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern int pthread_barrierattr_setpshared (pthread_barrierattr_t *__attr,
                                           int __pshared)
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_key_create (pthread_key_t *__key,
          void (*__destr_function) (void *))
     throw () __attribute__ ((__nonnull__ (1)));
extern int pthread_key_delete (pthread_key_t __key) throw ();
extern void *pthread_getspecific (pthread_key_t __key) throw ();
extern int pthread_setspecific (pthread_key_t __key,
    __const void *__pointer) throw () ;
extern int pthread_getcpuclockid (pthread_t __thread_id,
      __clockid_t *__clock_id)
     throw () __attribute__ ((__nonnull__ (2)));
extern int pthread_atfork (void (*__prepare) (void),
      void (*__parent) (void),
      void (*__child) (void)) throw ();
extern __inline __attribute__ ((__gnu_inline__)) int
pthread_equal (pthread_t __thread1, pthread_t __thread2) throw ()
{
  return __thread1 == __thread2;
}
}
typedef size_t __stl_atomic_t;
namespace stlp_std {
struct __attribute__((visibility("default"))) _STLP_mutex_base {
  pthread_spinlock_t _M_lock;
  inline void _M_initialize() { pthread_spin_init( &_M_lock, 0 ); }
  inline void _M_destroy() { pthread_spin_destroy( &_M_lock ); }
  inline void _M_acquire_lock() { pthread_spin_lock( &_M_lock ); }
  inline void _M_release_lock() { pthread_spin_unlock( &_M_lock ); }
};
class __attribute__((visibility("default"))) _STLP_mutex : public _STLP_mutex_base {
  public:
    inline _STLP_mutex () { _M_initialize(); }
    inline ~_STLP_mutex () { _M_destroy(); }
  private:
    _STLP_mutex(const _STLP_mutex&);
    void operator=(const _STLP_mutex&);
};
struct __attribute__((visibility("default"))) _STLP_auto_lock {
  _STLP_auto_lock(_STLP_mutex& __lock) : _M_lock(__lock)
  { _M_lock._M_acquire_lock(); }
  ~_STLP_auto_lock()
  { _M_lock._M_release_lock(); }
private:
  _STLP_mutex& _M_lock;
  void operator=(const _STLP_auto_lock&);
  _STLP_auto_lock(const _STLP_auto_lock&);
};
class __attribute__((visibility("default"))) _Refcount_Base {
  volatile __stl_atomic_t _M_ref_count;
  _STLP_mutex _M_mutex;
  public:
  _Refcount_Base(__stl_atomic_t __n) : _M_ref_count(__n) {}
  __stl_atomic_t _M_incr() {
    _STLP_auto_lock l(_M_mutex);
    return ++_M_ref_count;
  }
  __stl_atomic_t _M_decr() {
    _STLP_auto_lock l(_M_mutex);
    return --_M_ref_count;
  }
};
template <int __use_ptr_atomic_swap>
class _Atomic_swap_struct {
public:
  static _STLP_mutex _S_swap_lock;
  static __stl_atomic_t _S_swap(volatile __stl_atomic_t* __p, __stl_atomic_t __q) {
  _S_swap_lock._M_acquire_lock();
  __stl_atomic_t __result = *__p;
  *__p = __q;
  _S_swap_lock._M_release_lock();
  return __result;
  }
  static void* _S_swap_ptr(void* volatile* __p, void* __q) {
  _S_swap_lock._M_acquire_lock();
  void *__result = *__p;
  *__p = __q;
  _S_swap_lock._M_release_lock();
  return __result;
  }
};
template<>
class _Atomic_swap_struct<0> {
public:
  static _STLP_mutex _S_swap_lock;
  static __stl_atomic_t _S_swap(volatile __stl_atomic_t* __p, __stl_atomic_t __q) {
  _S_swap_lock._M_acquire_lock();
  __stl_atomic_t __result = *__p;
  *__p = __q;
  _S_swap_lock._M_release_lock();
  return __result;
  }
  static void* _S_swap_ptr(void* volatile* __p, void* __q) {
  _S_swap_lock._M_acquire_lock();
  void *__result = *__p;
  *__p = __q;
  _S_swap_lock._M_release_lock();
  return __result;
  }
};
inline __stl_atomic_t _Atomic_swap(volatile __stl_atomic_t * __p, __stl_atomic_t __q) {
  const int __use_ptr_atomic_swap = sizeof(__stl_atomic_t) == sizeof(void*);
  return _Atomic_swap_struct<__use_ptr_atomic_swap>::_S_swap(__p, __q);
}
inline void* _Atomic_swap_ptr(void* volatile* __p, void* __q) {
  const int __use_ptr_atomic_swap = sizeof(__stl_atomic_t) == sizeof(void*);
  return _Atomic_swap_struct<__use_ptr_atomic_swap>::_S_swap_ptr(__p, __q);
}
}
       
       
namespace std __attribute__ ((__visibility__ ("default"))) {
  using ::clock_t;
  using ::time_t;
  using ::tm;
  using ::clock;
  using ::difftime;
  using ::mktime;
  using ::time;
  using ::asctime;
  using ::ctime;
  using ::gmtime;
  using ::localtime;
  using ::strftime;
}
namespace stlp_std {
using std::size_t;
using std::clock_t;
using std::time_t;
using std::tm;
using std::clock;
using std::asctime;
using std::ctime;
using std::gmtime;
using std::difftime;
using std::mktime;
using std::localtime;
using std::strftime;
using std::time;
}
using std::time_t;
extern "C" {
struct timezone
  {
    int tz_minuteswest;
    int tz_dsttime;
  };
typedef struct timezone *__restrict __timezone_ptr_t;
extern int gettimeofday (struct timeval *__restrict __tv,
    __timezone_ptr_t __tz) throw () __attribute__ ((__nonnull__ (1)));
extern int settimeofday (__const struct timeval *__tv,
    __const struct timezone *__tz)
     throw () __attribute__ ((__nonnull__ (1)));
extern int adjtime (__const struct timeval *__delta,
      struct timeval *__olddelta) throw ();
enum __itimer_which
  {
    ITIMER_REAL = 0,
    ITIMER_VIRTUAL = 1,
    ITIMER_PROF = 2
  };
struct itimerval
  {
    struct timeval it_interval;
    struct timeval it_value;
  };
typedef int __itimer_which_t;
extern int getitimer (__itimer_which_t __which,
        struct itimerval *__value) throw ();
extern int setitimer (__itimer_which_t __which,
        __const struct itimerval *__restrict __new,
        struct itimerval *__restrict __old) throw ();
extern int utimes (__const char *__file, __const struct timeval __tvp[2])
     throw () __attribute__ ((__nonnull__ (1)));
extern int lutimes (__const char *__file, __const struct timeval __tvp[2])
     throw () __attribute__ ((__nonnull__ (1)));
extern int futimes (int __fd, __const struct timeval __tvp[2]) throw ();
extern int futimesat (int __fd, __const char *__file,
        __const struct timeval __tvp[2]) throw ();
}
namespace stlp_std {
template<int __32bits>
_STLP_mutex
_Atomic_swap_struct<__32bits>::_S_swap_lock ;
}
namespace stlp_std {
template <class _CharT, class _InputIter = istreambuf_iterator<_CharT, char_traits<_CharT> > >
class money_get;
template <class _CharT, class _OutputIter = ostreambuf_iterator<_CharT, char_traits<_CharT> > >
class money_put;
template <class _CharT, class _InputIter = istreambuf_iterator<_CharT, char_traits<_CharT> > >
class num_get;
template <class _CharT, class _OutputIter = ostreambuf_iterator<_CharT, char_traits<_CharT> > >
class num_put;
template <class _Ch, class _InIt = istreambuf_iterator<_Ch, char_traits<_Ch> > >
class time_get;
template <class _Ch, class _OutIt = ostreambuf_iterator<_Ch, char_traits<_Ch> > >
class time_put;
}
namespace stlp_std {
class _Locale_impl;
class locale;
template <class _CharT, class _Traits, class _Alloc>
bool __locale_do_operator_call(const locale& __loc,
                               const basic_string<_CharT, _Traits, _Alloc>& __x,
                               const basic_string<_CharT, _Traits, _Alloc>& __y);
__attribute__((visibility("default"))) _Locale_impl * _get_Locale_impl( _Locale_impl *locimpl );
__attribute__((visibility("default"))) _Locale_impl * _copy_Nameless_Locale_impl( _Locale_impl *locimpl );
namespace priv {
template <class _Facet>
bool _HasFacet(const locale& __loc, const _Facet* __facet) throw();
template <class _Facet>
_Facet* _UseFacet(const locale& __loc, const _Facet* __facet);
template <class _Facet>
void _InsertFacet(locale& __loc, _Facet* __facet);
}
class __attribute__((visibility("default"))) locale {
public:
  class __attribute__((visibility("default"))) facet : protected _Refcount_Base {
  protected:
    explicit facet(size_t __init_count = 0) : _Refcount_Base( __init_count == 0 ? 0 : 1 ) {}
    virtual ~facet();
    friend class locale;
    friend class _Locale_impl;
    friend facet * _get_facet( facet * );
    friend void _release_facet( facet *& );
  private:
    facet(const facet& ) ;
    void operator=(const facet&);
  };
  class
  __attribute__((visibility("default"))) id {
  public:
    size_t _M_index;
    static size_t _S_max;
  };
  typedef int category;
  static const category none = 0x000;
  static const category collate = 0x010;
  static const category ctype = 0x020;
  static const category monetary = 0x040;
  static const category numeric = 0x100;
  static const category time = 0x200;
  static const category messages = 0x400;
  static const category all = collate | ctype | monetary | numeric | time | messages;
  locale() throw();
  locale(const locale&) throw();
  explicit locale(const char *);
  locale(const locale&, const char*, category);
  template <class _Facet>
  locale(const locale& __loc, _Facet* __f) {
    if ( __f != 0 ) {
      this->_M_impl = _get_Locale_impl( _copy_Nameless_Locale_impl( __loc._M_impl ) );
      ::stlp_std::priv:: _InsertFacet(*this, __f);
    } else {
      this->_M_impl = _get_Locale_impl( __loc._M_impl );
    }
  }
protected:
  locale(_Locale_impl*);
public:
  locale(const locale&, const locale&, category);
  const locale& operator=(const locale&) throw();
   ~locale() throw();
public:
  template <class _Facet>
  locale combine(const locale& __loc) const {
    _Facet *__facet = 0;
    if (!::stlp_std::priv:: _HasFacet(__loc, __facet))
      _M_throw_on_combine_error(__loc.name());
    return locale(*this, ::stlp_std::priv:: _UseFacet(__loc, __facet));
  }
  string name() const;
  bool operator==(const locale&) const;
  bool operator!=(const locale&) const;
  template <class _CharT, class _Traits, class _Alloc>
  bool operator()(const basic_string<_CharT, _Traits, _Alloc>& __x,
                  const basic_string<_CharT, _Traits, _Alloc>& __y) const
  { return __locale_do_operator_call(*this, __x, __y); }
  static locale global(const locale&);
  static const locale& classic();
  facet* _M_get_facet(const id&) const;
  facet* _M_use_facet(const id&) const;
  static void __attribute__((noreturn)) _M_throw_on_combine_error(const string& name);
  static void __attribute__((noreturn)) _M_throw_on_null_name();
  static void __attribute__((noreturn)) _M_throw_on_creation_failure(int __err_code,
                                                                            const char* name, const char* facet);
  void _M_insert(facet* __f, id& __id);
  friend class _Locale_impl;
protected:
  _Locale_impl* _M_impl;
  _Locale_impl* _M_get_impl() const { return _M_impl; }
};
template <class _Facet>
inline const _Facet&
use_facet(const locale& __loc)
{
  _Facet *__facet = 0;
  return *(::stlp_std::priv:: _UseFacet(__loc, __facet));
}
template <class _Facet>
inline bool has_facet(const locale& __loc) throw()
{
  _Facet *__facet = 0;
  return ::stlp_std::priv:: _HasFacet(__loc, __facet);
}
namespace priv {
template <class _Facet>
inline locale::id& _GetFacetId(const _Facet*)
{ return _Facet::id; }
__attribute__((visibility("default"))) locale::id& _GetFacetId(const money_get<char, istreambuf_iterator<char, char_traits<char> > >*);
__attribute__((visibility("default"))) locale::id& _GetFacetId(const money_put<char, ostreambuf_iterator<char, char_traits<char> > >*);
__attribute__((visibility("default"))) locale::id& _GetFacetId(const num_get<char, istreambuf_iterator<char, char_traits<char> > >*);
__attribute__((visibility("default"))) locale::id& _GetFacetId(const num_put<char, ostreambuf_iterator<char, char_traits<char> > >*);
__attribute__((visibility("default"))) locale::id& _GetFacetId(const time_get<char, istreambuf_iterator<char, char_traits<char> > >*);
__attribute__((visibility("default"))) locale::id& _GetFacetId(const time_put<char, ostreambuf_iterator<char, char_traits<char> > >*);
__attribute__((visibility("default"))) locale::id& _GetFacetId(const money_get<wchar_t, istreambuf_iterator<wchar_t, char_traits<wchar_t> > >*);
__attribute__((visibility("default"))) locale::id& _GetFacetId(const money_put<wchar_t, ostreambuf_iterator<wchar_t, char_traits<wchar_t> > >*);
__attribute__((visibility("default"))) locale::id& _GetFacetId(const num_get<wchar_t, istreambuf_iterator<wchar_t, char_traits<wchar_t> > >*);
__attribute__((visibility("default"))) locale::id& _GetFacetId(const num_put<wchar_t, ostreambuf_iterator<wchar_t, char_traits<wchar_t> > >*);
__attribute__((visibility("default"))) locale::id& _GetFacetId(const time_get<wchar_t, istreambuf_iterator<wchar_t, char_traits<wchar_t> > >*);
__attribute__((visibility("default"))) locale::id& _GetFacetId(const time_put<wchar_t, ostreambuf_iterator<wchar_t, char_traits<wchar_t> > >*);
template <class _Facet>
inline bool _HasFacet(const locale& __loc, const _Facet* __facet) throw()
{ return (__loc._M_get_facet(_GetFacetId(__facet)) != 0); }
template <class _Facet>
inline _Facet* _UseFacet(const locale& __loc, const _Facet* __facet)
{ return static_cast<_Facet*>(__loc._M_use_facet(_GetFacetId(__facet))); }
template <class _Facet>
inline void _InsertFacet(locale& __loc, _Facet* __facet)
{ __loc._M_insert(__facet, _GetFacetId(__facet)); }
}
}
namespace stlp_std {
class __attribute__((visibility("default"))) ios_base {
public:
  class __attribute__((visibility("default"))) failure : public __Named_exception {
  public:
    explicit failure(const string&);
    virtual ~failure() throw();
  };
  typedef int fmtflags;
  typedef int iostate;
  typedef int openmode;
  typedef int seekdir;
  typedef fmtflags fmt_flags;
  static const int left = 0x0001;
  static const int right = 0x0002;
  static const int internal = 0x0004;
  static const int dec = 0x0008;
  static const int hex = 0x0010;
  static const int oct = 0x0020;
  static const int fixed = 0x0040;
  static const int scientific = 0x0080;
  static const int boolalpha = 0x0100;
  static const int showbase = 0x0200;
  static const int showpoint = 0x0400;
  static const int showpos = 0x0800;
  static const int skipws = 0x1000;
  static const int unitbuf = 0x2000;
  static const int uppercase = 0x4000;
  static const int adjustfield = left | right | internal;
  static const int basefield = dec | hex | oct;
  static const int floatfield = scientific | fixed;
  static const int goodbit = 0x00;
  static const int badbit = 0x01;
  static const int eofbit = 0x02;
  static const int failbit = 0x04;
  static const int __default_mode = 0x0;
  static const int app = 0x01;
  static const int ate = 0x02;
  static const int binary = 0x04;
  static const int in = 0x08;
  static const int out = 0x10;
  static const int trunc = 0x20;
  static const int beg = 0x01;
  static const int cur = 0x02;
  static const int end = 0x04;
public:
  fmtflags flags() const { return _M_fmtflags; }
  fmtflags flags(fmtflags __flags) {
    fmtflags __tmp = _M_fmtflags;
    _M_fmtflags = __flags;
    return __tmp;
  }
  fmtflags setf(fmtflags __flag) {
    fmtflags __tmp = _M_fmtflags;
    _M_fmtflags |= __flag;
    return __tmp;
  }
  fmtflags setf(fmtflags __flag, fmtflags __mask) {
    fmtflags __tmp = _M_fmtflags;
    _M_fmtflags &= ~__mask;
    _M_fmtflags |= __flag & __mask;
    return __tmp;
  }
  void unsetf(fmtflags __mask) { _M_fmtflags &= ~__mask; }
  streamsize precision() const { return _M_precision; }
  streamsize precision(streamsize __newprecision) {
    streamsize __tmp = _M_precision;
    _M_precision = __newprecision;
    return __tmp;
  }
  streamsize width() const { return _M_width; }
  streamsize width(streamsize __newwidth) {
    streamsize __tmp = _M_width;
    _M_width = __newwidth;
    return __tmp;
  }
public:
  locale imbue(const locale&);
  locale getloc() const { return _M_locale; }
public:
  static int xalloc();
  long& iword(int __index);
  void*& pword(int __index);
public:
  virtual ~ios_base();
public:
  enum event { erase_event, imbue_event, copyfmt_event };
  typedef void (*event_callback)(event, ios_base&, int __index);
  void register_callback(event_callback __fn, int __index);
public:
  static bool sync_with_stdio(bool __sync = true);
public:
  operator void*() const { return !fail() ? (void*) const_cast<ios_base*>(this) : (void*) 0; }
  bool operator!() const { return fail(); }
  iostate rdstate() const { return _M_iostate; }
  bool good() const { return _M_iostate == 0; }
  bool eof() const { return (_M_iostate & eofbit) != 0; }
  bool fail() const { return (_M_iostate & (failbit | badbit)) != 0; }
  bool bad() const { return (_M_iostate & badbit) != 0; }
protected:
  void _M_copy_state(const ios_base& __x);
  void _M_setstate_nothrow(iostate __state) { _M_iostate |= __state; }
  void _M_clear_nothrow(iostate __state) { _M_iostate = __state; }
  iostate _M_get_exception_mask() const { return _M_exception_mask; }
  void _M_set_exception_mask(iostate __mask) { _M_exception_mask = __mask; }
  void _M_check_exception_mask() {
    if (_M_iostate & _M_exception_mask)
      _M_throw_failure();
  }
  void _M_invoke_callbacks(event);
  void __attribute__((noreturn)) _M_throw_failure();
  ios_base();
protected:
  static void _S_initialize();
  static void _S_uninitialize();
  static bool _S_is_synced;
private:
  ios_base(const ios_base&);
  void operator=(const ios_base&);
private:
  fmtflags _M_fmtflags;
  iostate _M_iostate;
  openmode _M_openmode;
  seekdir _M_seekdir;
  iostate _M_exception_mask;
  streamsize _M_precision;
  streamsize _M_width;
  locale _M_locale;
  pair<event_callback, int>* _M_callbacks;
  size_t _M_num_callbacks;
  size_t _M_callback_index;
  long* _M_iwords;
  size_t _M_num_iwords;
  void** _M_pwords;
  size_t _M_num_pwords;
public:
  class __attribute__((visibility("default"))) Init
  {
    public:
      Init();
      ~Init();
    private:
      static long _S_count;
      friend class ios_base;
  };
  friend class Init;
public:
  typedef iostate io_state;
  typedef openmode open_mode;
  typedef seekdir seek_dir;
  typedef ::stlp_std::streamoff streamoff;
  typedef ::stlp_std::streampos streampos;
};
inline ios_base& boolalpha(ios_base& __s)
  { __s.setf(ios_base::boolalpha); return __s;}
inline ios_base& noboolalpha(ios_base& __s)
  { __s.unsetf(ios_base::boolalpha); return __s;}
inline ios_base& showbase(ios_base& __s)
  { __s.setf(ios_base::showbase); return __s;}
inline ios_base& noshowbase(ios_base& __s)
  { __s.unsetf(ios_base::showbase); return __s;}
inline ios_base& showpoint(ios_base& __s)
  { __s.setf(ios_base::showpoint); return __s;}
inline ios_base& noshowpoint(ios_base& __s)
  { __s.unsetf(ios_base::showpoint); return __s;}
inline ios_base& showpos(ios_base& __s)
  { __s.setf(ios_base::showpos); return __s;}
inline ios_base& noshowpos(ios_base& __s)
  { __s.unsetf(ios_base::showpos); return __s;}
inline ios_base& skipws(ios_base& __s)
  { __s.setf(ios_base::skipws); return __s;}
inline ios_base& noskipws(ios_base& __s)
  { __s.unsetf(ios_base::skipws); return __s;}
inline ios_base& uppercase(ios_base& __s)
  { __s.setf(ios_base::uppercase); return __s;}
inline ios_base& nouppercase(ios_base& __s)
  { __s.unsetf(ios_base::uppercase); return __s;}
inline ios_base& unitbuf(ios_base& __s)
  { __s.setf(ios_base::unitbuf); return __s;}
inline ios_base& nounitbuf(ios_base& __s)
  { __s.unsetf(ios_base::unitbuf); return __s;}
inline ios_base& internal(ios_base& __s)
  { __s.setf(ios_base::internal, ios_base::adjustfield); return __s; }
inline ios_base& left(ios_base& __s)
  { __s.setf(ios_base::left, ios_base::adjustfield); return __s; }
inline ios_base& right(ios_base& __s)
  { __s.setf(ios_base::right, ios_base::adjustfield); return __s; }
inline ios_base& dec(ios_base& __s)
  { __s.setf(ios_base::dec, ios_base::basefield); return __s; }
inline ios_base& hex(ios_base& __s)
  { __s.setf(ios_base::hex, ios_base::basefield); return __s; }
inline ios_base& oct(ios_base& __s)
  { __s.setf(ios_base::oct, ios_base::basefield); return __s; }
inline ios_base& fixed(ios_base& __s)
  { __s.setf(ios_base::fixed, ios_base::floatfield); return __s; }
inline ios_base& scientific(ios_base& __s)
  { __s.setf(ios_base::scientific, ios_base::floatfield); return __s; }
}
extern "C" {
enum
{
  _ISupper = ((0) < 8 ? ((1 << (0)) << 8) : ((1 << (0)) >> 8)),
  _ISlower = ((1) < 8 ? ((1 << (1)) << 8) : ((1 << (1)) >> 8)),
  _ISalpha = ((2) < 8 ? ((1 << (2)) << 8) : ((1 << (2)) >> 8)),
  _ISdigit = ((3) < 8 ? ((1 << (3)) << 8) : ((1 << (3)) >> 8)),
  _ISxdigit = ((4) < 8 ? ((1 << (4)) << 8) : ((1 << (4)) >> 8)),
  _ISspace = ((5) < 8 ? ((1 << (5)) << 8) : ((1 << (5)) >> 8)),
  _ISprint = ((6) < 8 ? ((1 << (6)) << 8) : ((1 << (6)) >> 8)),
  _ISgraph = ((7) < 8 ? ((1 << (7)) << 8) : ((1 << (7)) >> 8)),
  _ISblank = ((8) < 8 ? ((1 << (8)) << 8) : ((1 << (8)) >> 8)),
  _IScntrl = ((9) < 8 ? ((1 << (9)) << 8) : ((1 << (9)) >> 8)),
  _ISpunct = ((10) < 8 ? ((1 << (10)) << 8) : ((1 << (10)) >> 8)),
  _ISalnum = ((11) < 8 ? ((1 << (11)) << 8) : ((1 << (11)) >> 8))
};
extern __const unsigned short int **__ctype_b_loc (void)
     throw () __attribute__ ((__const));
extern __const __int32_t **__ctype_tolower_loc (void)
     throw () __attribute__ ((__const));
extern __const __int32_t **__ctype_toupper_loc (void)
     throw () __attribute__ ((__const));
extern int isalnum (int) throw ();
extern int isalpha (int) throw ();
extern int iscntrl (int) throw ();
extern int isdigit (int) throw ();
extern int islower (int) throw ();
extern int isgraph (int) throw ();
extern int isprint (int) throw ();
extern int ispunct (int) throw ();
extern int isspace (int) throw ();
extern int isupper (int) throw ();
extern int isxdigit (int) throw ();
extern int tolower (int __c) throw ();
extern int toupper (int __c) throw ();
extern int isblank (int) throw ();
extern int isctype (int __c, int __mask) throw ();
extern int isascii (int __c) throw ();
extern int toascii (int __c) throw ();
extern int _toupper (int) throw ();
extern int _tolower (int) throw ();
extern int isalnum_l (int, __locale_t) throw ();
extern int isalpha_l (int, __locale_t) throw ();
extern int iscntrl_l (int, __locale_t) throw ();
extern int isdigit_l (int, __locale_t) throw ();
extern int islower_l (int, __locale_t) throw ();
extern int isgraph_l (int, __locale_t) throw ();
extern int isprint_l (int, __locale_t) throw ();
extern int ispunct_l (int, __locale_t) throw ();
extern int isspace_l (int, __locale_t) throw ();
extern int isupper_l (int, __locale_t) throw ();
extern int isxdigit_l (int, __locale_t) throw ();
extern int isblank_l (int, __locale_t) throw ();
extern int __tolower_l (int __c, __locale_t __l) throw ();
extern int tolower_l (int __c, __locale_t __l) throw ();
extern int __toupper_l (int __c, __locale_t __l) throw ();
extern int toupper_l (int __c, __locale_t __l) throw ();
}
struct _Locale_ctype;
struct _Locale_codecvt;
struct _Locale_numeric;
struct _Locale_time;
struct _Locale_collate;
struct _Locale_monetary;
struct _Locale_messages;
namespace stlp_std {
class __attribute__((visibility("default"))) ctype_base {
public:
  enum mask {
    space = _ISspace,
    print = _ISprint,
    cntrl = _IScntrl,
    upper = _ISupper,
    lower = _ISlower,
    alpha = _ISalpha,
    digit = _ISdigit,
    punct = _ISpunct,
    xdigit = _ISxdigit,
    alnum = alpha | digit,
    graph = alnum | punct
  };
};
template <class charT> class ctype {};
template <class charT> class ctype_byname {};
template<>
class __attribute__((visibility("default"))) ctype<char> : public locale::facet, public ctype_base {
    friend class ctype<wchar_t>;
public:
  typedef char char_type;
  explicit ctype(const mask* __tab = 0, bool __del = false, size_t __refs = 0);
  bool is(mask __m, char __c) const
  { return ((*(_M_ctype_table+(unsigned char)__c)) & __m) != 0; }
  const char* is(const char* __low, const char* __high, mask* __vec) const {
    for (const char* __p = __low;__p != __high; ++__p, ++__vec) {
      *__vec = _M_ctype_table[(unsigned char)*__p];
    }
    return __high;
  }
  const char* scan_is(mask __m, const char* __low, const char* __high) const;
  const char* scan_not(mask __m, const char* __low, const char* __high) const;
  char (toupper)(char __c) const { return do_toupper(__c); }
  const char* (toupper)(char* __low, const char* __high) const {
    return do_toupper(__low, __high);
  }
  char (tolower)(char __c) const { return do_tolower(__c); }
  const char* (tolower)(char* __low, const char* __high) const {
    return do_tolower(__low, __high);
  }
  char widen(char __c) const { return do_widen(__c); }
  const char* widen(const char* __low, const char* __high, char* __to) const {
    return do_widen(__low, __high, __to);
  }
  char narrow(char __c, char __dfault) const {
    return do_narrow(__c, __dfault);
  }
  const char* narrow(const char* __low, const char* __high,
                     char __dfault, char* __to) const {
    return do_narrow(__low, __high, __dfault, __to);
  }
  static locale::id id;
  static const size_t table_size = 256;
protected:
  const mask* table() const throw() { return _M_ctype_table; }
  static const mask* classic_table() throw();
  ~ctype();
  virtual char do_toupper(char __c) const;
  virtual char do_tolower(char __c) const;
  virtual const char* do_toupper(char* __low, const char* __high) const;
  virtual const char* do_tolower(char* __low, const char* __high) const;
  virtual char do_widen(char __c) const;
  virtual const char* do_widen(const char* __low, const char* __high,
                               char* __to) const;
  virtual char do_narrow(char __c, char ) const;
  virtual const char* do_narrow(const char* __low, const char* __high,
                                char , char* __to) const;
private:
  struct _Is_mask {
    mask __m;
    _Is_mask(mask __x): __m(__x) {}
   bool operator()(char __c) {return (__m & (unsigned char) __c) != 0;}
  };
protected:
  const mask* _M_ctype_table;
private:
  bool _M_delete;
};
template<>
class __attribute__((visibility("default"))) ctype_byname<char>: public ctype<char> {
  friend class _Locale_impl;
public:
  explicit ctype_byname(const char*, size_t = 0);
  ~ctype_byname();
  virtual char do_toupper(char __c) const;
  virtual char do_tolower(char __c) const;
  virtual const char* do_toupper(char*, const char*) const;
  virtual const char* do_tolower(char*, const char*) const;
private:
  ctype_byname(_Locale_ctype* __ctype)
    : _M_ctype(__ctype)
  { _M_init(); }
  void _M_init();
  typedef ctype_byname<char> _Self;
  ctype_byname(_Self const&);
  _Self& operator = (_Self const&);
  mask _M_byname_table[table_size];
  _Locale_ctype* _M_ctype;
};
template<>
class __attribute__((visibility("default"))) ctype<wchar_t> : public locale::facet, public ctype_base {
public:
  typedef wchar_t char_type;
  explicit ctype(size_t __refs = 0) : locale::facet(__refs) {}
  bool is(mask __m, wchar_t __c) const
    { return do_is(__m, __c); }
  const wchar_t* is(const wchar_t* __low, const wchar_t* __high,
                    mask* __vec) const
    { return do_is(__low, __high, __vec); }
  const wchar_t* scan_is(mask __m,
                         const wchar_t* __low, const wchar_t* __high) const
    { return do_scan_is(__m, __low, __high); }
  const wchar_t* scan_not (mask __m,
                           const wchar_t* __low, const wchar_t* __high) const
    { return do_scan_not(__m, __low, __high); }
  wchar_t (toupper)(wchar_t __c) const { return do_toupper(__c); }
  const wchar_t* (toupper)(wchar_t* __low, const wchar_t* __high) const
    { return do_toupper(__low, __high); }
  wchar_t (tolower)(wchar_t __c) const { return do_tolower(__c); }
  const wchar_t* (tolower)(wchar_t* __low, const wchar_t* __high) const
    { return do_tolower(__low, __high); }
  wchar_t widen(char __c) const { return do_widen(__c); }
  const char* widen(const char* __low, const char* __high,
                    wchar_t* __to) const
    { return do_widen(__low, __high, __to); }
  char narrow(wchar_t __c, char __dfault) const
    { return do_narrow(__c, __dfault); }
  const wchar_t* narrow(const wchar_t* __low, const wchar_t* __high,
                        char __dfault, char* __to) const
    { return do_narrow(__low, __high, __dfault, __to); }
  static locale::id id;
protected:
  ~ctype();
  virtual bool do_is(mask __m, wchar_t __c) const;
  virtual const wchar_t* do_is(const wchar_t*, const wchar_t*, mask*) const;
  virtual const wchar_t* do_scan_is(mask,
                                    const wchar_t*, const wchar_t*) const;
  virtual const wchar_t* do_scan_not(mask,
                                     const wchar_t*, const wchar_t*) const;
  virtual wchar_t do_toupper(wchar_t __c) const;
  virtual const wchar_t* do_toupper(wchar_t*, const wchar_t*) const;
  virtual wchar_t do_tolower(wchar_t c) const;
  virtual const wchar_t* do_tolower(wchar_t*, const wchar_t*) const;
  virtual wchar_t do_widen(char c) const;
  virtual const char* do_widen(const char*, const char*, wchar_t*) const;
  virtual char do_narrow(wchar_t __c, char __dfault) const;
  virtual const wchar_t* do_narrow(const wchar_t*, const wchar_t*,
                                   char, char*) const;
};
template<>
class __attribute__((visibility("default"))) ctype_byname<wchar_t>: public ctype<wchar_t> {
  friend class _Locale_impl;
public:
  explicit ctype_byname(const char* __name, size_t __refs = 0);
protected:
  ~ctype_byname();
  virtual bool do_is(mask __m, wchar_t __c) const;
  virtual const wchar_t* do_is(const wchar_t*, const wchar_t*, mask*) const;
  virtual const wchar_t* do_scan_is(mask,
                                    const wchar_t*, const wchar_t*) const;
  virtual const wchar_t* do_scan_not(mask,
                                     const wchar_t*, const wchar_t*) const;
  virtual wchar_t do_toupper(wchar_t __c) const;
  virtual const wchar_t* do_toupper(wchar_t*, const wchar_t*) const;
  virtual wchar_t do_tolower(wchar_t c) const;
  virtual const wchar_t* do_tolower(wchar_t*, const wchar_t*) const;
private:
  ctype_byname(_Locale_ctype* __ctype)
    : _M_ctype(__ctype) {}
  typedef ctype_byname<wchar_t> _Self;
  ctype_byname(_Self const&);
  _Self& operator = (_Self const&);
  _Locale_ctype* _M_ctype;
};
}
namespace stlp_std {
template <class _CharT> class numpunct {};
template <class _CharT> class numpunct_byname {};
template <class _Ch, class _InIt> class num_get;
template<>
class __attribute__((visibility("default"))) numpunct<char> : public locale::facet {
public:
  typedef char char_type;
  typedef string string_type;
  explicit numpunct(size_t __refs = 0)
    : locale::facet(__refs) {}
  char decimal_point() const { return do_decimal_point(); }
  char thousands_sep() const { return do_thousands_sep(); }
  string grouping() const { return do_grouping(); }
  string truename() const { return do_truename(); }
  string falsename() const { return do_falsename(); }
  static locale::id id;
protected:
  ~numpunct();
  virtual char do_decimal_point() const;
  virtual char do_thousands_sep() const;
  virtual string do_grouping() const;
  virtual string do_truename() const;
  virtual string do_falsename() const;
};
template<>
class __attribute__((visibility("default"))) numpunct<wchar_t> : public locale::facet {
public:
  typedef wchar_t char_type;
  typedef wstring string_type;
  explicit numpunct(size_t __refs = 0)
    : locale::facet(__refs) {}
  wchar_t decimal_point() const { return do_decimal_point(); }
  wchar_t thousands_sep() const { return do_thousands_sep(); }
  string grouping() const { return do_grouping(); }
  wstring truename() const { return do_truename(); }
  wstring falsename() const { return do_falsename(); }
  static locale::id id;
protected:
  ~numpunct();
  virtual wchar_t do_decimal_point() const;
  virtual wchar_t do_thousands_sep() const;
  virtual string do_grouping() const;
  virtual wstring do_truename() const;
  virtual wstring do_falsename() const;
};
template<>
class __attribute__((visibility("default"))) numpunct_byname<char> : public numpunct<char> {
  friend class _Locale_impl;
public:
  typedef char char_type;
  typedef string string_type;
  explicit numpunct_byname(const char* __name, size_t __refs = 0);
protected:
  ~numpunct_byname();
  virtual char do_decimal_point() const;
  virtual char do_thousands_sep() const;
  virtual string do_grouping() const;
  virtual string do_truename() const;
  virtual string do_falsename() const;
private:
  numpunct_byname(_Locale_numeric *__numeric)
    : _M_numeric(__numeric) {}
  typedef numpunct_byname<char> _Self;
  numpunct_byname(_Self const&);
  _Self& operator = (_Self const&);
  _Locale_numeric* _M_numeric;
};
template<>
class __attribute__((visibility("default"))) numpunct_byname<wchar_t>: public numpunct<wchar_t> {
  friend class _Locale_impl;
public:
  typedef wchar_t char_type;
  typedef wstring string_type;
  explicit numpunct_byname(const char* __name, size_t __refs = 0);
protected:
  ~numpunct_byname();
  virtual wchar_t do_decimal_point() const;
  virtual wchar_t do_thousands_sep() const;
  virtual string do_grouping() const;
  virtual wstring do_truename() const;
  virtual wstring do_falsename() const;
private:
  numpunct_byname(_Locale_numeric *__numeric)
    : _M_numeric(__numeric) {}
  typedef numpunct_byname<wchar_t> _Self;
  numpunct_byname(_Self const&);
  _Self& operator = (_Self const&);
  _Locale_numeric* _M_numeric;
};
}
namespace stlp_std {
template <class _CharT, class _Traits>
class basic_ios : public ios_base {
  friend class ios_base;
public:
  typedef _CharT char_type;
  typedef typename _Traits::int_type int_type;
  typedef typename _Traits::pos_type pos_type;
  typedef typename _Traits::off_type off_type;
  typedef _Traits traits_type;
public:
  explicit basic_ios(basic_streambuf<_CharT, _Traits>* __streambuf);
  virtual ~basic_ios() {}
public:
  basic_ostream<_CharT, _Traits>* tie() const {
    return _M_tied_ostream;
  }
  basic_ostream<_CharT, _Traits>*
  tie(basic_ostream<char_type, traits_type>* __new_tied_ostream) {
    basic_ostream<char_type, traits_type>* __tmp = _M_tied_ostream;
    _M_tied_ostream = __new_tied_ostream;
    return __tmp;
  }
  basic_streambuf<_CharT, _Traits>* rdbuf() const
    { return _M_streambuf; }
  basic_streambuf<_CharT, _Traits>*
  rdbuf(basic_streambuf<char_type, traits_type>*);
  basic_ios<_CharT, _Traits>& copyfmt(const basic_ios<_CharT, _Traits>& __x);
  char_type fill() const { return _M_fill; }
  char_type fill(char_type __fill) {
    char_type __tmp(_M_fill);
    _M_fill = __fill;
    return __tmp;
  }
public:
  void clear(iostate __state = goodbit) {
    _M_clear_nothrow(this->rdbuf() ? __state : iostate(__state|ios_base::badbit));
    _M_check_exception_mask();
  }
  void setstate(iostate __state) { this->clear(rdstate() | __state); }
  iostate exceptions() const { return this->_M_get_exception_mask(); }
  void exceptions(iostate __mask) {
    this->_M_set_exception_mask(__mask);
    this->clear(this->rdstate());
  }
public:
  locale imbue(const locale&);
  inline char narrow(_CharT, char) const ;
  inline _CharT widen(char) const;
  static bool _S_eof(int_type __c) {
    const int_type __eof = _Traits::eof();
    return _Traits::eq_int_type(__c, __eof);
  }
protected:
  const ctype<char_type>* _M_cached_ctype;
public:
  const ctype<char_type>* _M_ctype_facet() const { return _M_cached_ctype; }
protected:
  basic_ios();
  void init(basic_streambuf<_CharT, _Traits>* __streambuf);
public:
  void _M_handle_exception(ios_base::iostate __flag);
private:
  char_type _M_fill;
  basic_streambuf<_CharT, _Traits>* _M_streambuf;
  basic_ostream<_CharT, _Traits>* _M_tied_ostream;
};
template <class _CharT, class _Traits>
inline char
basic_ios<_CharT, _Traits>::narrow(_CharT __c, char __default) const
{ return _M_ctype_facet()->narrow(__c, __default); }
template <class _CharT, class _Traits>
inline _CharT
basic_ios<_CharT, _Traits>::widen(char __c) const
{ return _M_ctype_facet()->widen(__c); }
template<>
inline char
basic_ios<char, char_traits<char> >::narrow(char __c, char) const
{
  return __c;
}
template<>
inline char
basic_ios<char, char_traits<char> >::widen(char __c) const
{
  return __c;
}
}
namespace stlp_std {
template <class _CharT, class _Traits>
class basic_streambuf {
  friend class basic_istream<_CharT, _Traits>;
  friend class basic_ostream<_CharT, _Traits>;
public:
  typedef _CharT char_type;
  typedef typename _Traits::int_type int_type;
  typedef typename _Traits::pos_type pos_type;
  typedef typename _Traits::off_type off_type;
  typedef _Traits traits_type;
private:
  char_type* _M_gbegin;
  char_type* _M_gnext;
  char_type* _M_gend;
  char_type* _M_pbegin;
  char_type* _M_pnext;
  char_type* _M_pend;
  locale _M_locale;
public:
  virtual ~basic_streambuf();
protected:
  basic_streambuf()
  ;
protected:
  char_type* eback() const { return _M_gbegin; }
  char_type* gptr() const { return _M_gnext; }
  char_type* egptr() const { return _M_gend; }
  void gbump(int __n) { _M_gnext += __n; }
  void setg(char_type* __gbegin, char_type* __gnext, char_type* __gend) {
    _M_gbegin = __gbegin;
    _M_gnext = __gnext;
    _M_gend = __gend;
  }
public:
  char_type* _M_eback() const { return eback(); }
  char_type* _M_gptr() const { return gptr(); }
  char_type* _M_egptr() const { return egptr(); }
  void _M_gbump(int __n) { gbump(__n); }
  void _M_setg(char_type* __gbegin, char_type* __gnext, char_type* __gend)
  { this->setg(__gbegin, __gnext, __gend); }
protected:
  char_type* pbase() const { return _M_pbegin; }
  char_type* pptr() const { return _M_pnext; }
  char_type* epptr() const { return _M_pend; }
  void pbump(int __n) { _M_pnext += __n; }
  void setp(char_type* __pbegin, char_type* __pend) {
    _M_pbegin = __pbegin;
    _M_pnext = __pbegin;
    _M_pend = __pend;
  }
protected:
  virtual basic_streambuf<_CharT, _Traits>* setbuf(char_type*, streamsize);
  virtual pos_type seekoff(off_type, ios_base::seekdir,
                           ios_base::openmode = ios_base::in | ios_base::out);
  virtual pos_type
  seekpos(pos_type, ios_base::openmode = ios_base::in | ios_base::out);
  virtual int sync();
public:
  basic_streambuf<_CharT, _Traits>* pubsetbuf(char_type* __s, streamsize __n)
  { return this->setbuf(__s, __n); }
  pos_type pubseekoff(off_type __offset, ios_base::seekdir __way,
                      ios_base::openmode __mod = ios_base::in | ios_base::out)
  { return this->seekoff(__offset, __way, __mod); }
  pos_type pubseekpos(pos_type __sp,
                      ios_base::openmode __mod = ios_base::in | ios_base::out)
  { return this->seekpos(__sp, __mod); }
  int pubsync() { return this->sync(); }
protected:
  virtual streamsize showmanyc();
  virtual streamsize xsgetn(char_type* __s, streamsize __n);
  virtual int_type underflow();
  virtual int_type uflow();
  virtual int_type pbackfail(int_type = traits_type::eof());
protected:
  virtual streamsize xsputn(const char_type* __s, streamsize __n);
  virtual streamsize _M_xsputnc(char_type __c, streamsize __n);
  virtual int_type overflow(int_type = traits_type::eof());
public:
  int_type sputc(char_type __c) {
    return ((_M_pnext < _M_pend) ? _Traits::to_int_type(*_M_pnext++ = __c)
      : this->overflow(_Traits::to_int_type(__c)));
  }
  streamsize sputn(const char_type* __s, streamsize __n)
  { return this->xsputn(__s, __n); }
  streamsize _M_sputnc(char_type __c, streamsize __n)
  { return this->_M_xsputnc(__c, __n); }
private:
  int_type _M_snextc_aux();
public:
  streamsize in_avail() {
    return (_M_gnext < _M_gend) ? (_M_gend - _M_gnext) : this->showmanyc();
  }
  int_type snextc() {
  return ( _M_gend - _M_gnext > 1 ?
             _Traits::to_int_type(*++_M_gnext) :
             this->_M_snextc_aux());
  }
  int_type sbumpc() {
    return _M_gnext < _M_gend ? _Traits::to_int_type(*_M_gnext++)
      : this->uflow();
  }
  int_type sgetc() {
    return _M_gnext < _M_gend ? _Traits::to_int_type(*_M_gnext)
      : this->underflow();
  }
  streamsize sgetn(char_type* __s, streamsize __n)
  { return this->xsgetn(__s, __n); }
  int_type sputbackc(char_type __c) {
    return ((_M_gbegin < _M_gnext) && _Traits::eq(__c, *(_M_gnext - 1)))
      ? _Traits::to_int_type(*--_M_gnext)
      : this->pbackfail(_Traits::to_int_type(__c));
  }
  int_type sungetc() {
    return (_M_gbegin < _M_gnext)
      ? _Traits::to_int_type(*--_M_gnext)
      : this->pbackfail();
  }
protected:
  virtual void imbue(const locale&);
public:
  locale pubimbue(const locale&);
  locale getloc() const { return _M_locale; }
  void stossc() { this->sbumpc(); }
};
}
namespace stlp_std {
template <class _CharT, class _Traits>
basic_streambuf<_CharT, _Traits>::basic_streambuf()
  : _M_gbegin(0), _M_gnext(0), _M_gend(0),
    _M_pbegin(0), _M_pnext(0), _M_pend(0),
    _M_locale() {
}
template <class _CharT, class _Traits>
basic_streambuf<_CharT, _Traits>::~basic_streambuf()
{}
template <class _CharT, class _Traits>
locale
basic_streambuf<_CharT, _Traits>::pubimbue(const locale& __loc) {
  this->imbue(__loc);
  locale __tmp = _M_locale;
  _M_locale = __loc;
  return __tmp;
}
template <class _CharT, class _Traits>
streamsize
basic_streambuf<_CharT, _Traits>::xsgetn(_CharT* __s, streamsize __n) {
  streamsize __result = 0;
  const int_type __eof = _Traits::eof();
  while (__result < __n) {
    if (_M_gnext < _M_gend) {
      size_t __chunk = (min) (static_cast<size_t>(_M_gend - _M_gnext),
                              static_cast<size_t>(__n - __result));
      _Traits::copy(__s, _M_gnext, __chunk);
      __result += __chunk;
      __s += __chunk;
      _M_gnext += __chunk;
    }
    else {
      int_type __c = this->sbumpc();
      if (!_Traits::eq_int_type(__c, __eof)) {
        *__s = _Traits::to_char_type(__c);
        ++__result;
        ++__s;
      }
      else
        break;
    }
  }
  return __result;
}
template <class _CharT, class _Traits>
streamsize
basic_streambuf<_CharT, _Traits>::xsputn(const _CharT* __s, streamsize __n)
{
  streamsize __result = 0;
  const int_type __eof = _Traits::eof();
  while (__result < __n) {
    if (_M_pnext < _M_pend) {
      size_t __chunk = (min) (static_cast<size_t>(_M_pend - _M_pnext),
                           static_cast<size_t>(__n - __result));
      _Traits::copy(_M_pnext, __s, __chunk);
      __result += __chunk;
      __s += __chunk;
      _M_pnext += __chunk;
    }
    else if (!_Traits::eq_int_type(this->overflow(_Traits::to_int_type(*__s)),
                                   __eof)) {
      ++__result;
      ++__s;
    }
    else
      break;
  }
  return __result;
}
template <class _CharT, class _Traits>
streamsize
basic_streambuf<_CharT, _Traits>::_M_xsputnc(_CharT __c, streamsize __n)
{
  streamsize __result = 0;
  const int_type __eof = _Traits::eof();
  while (__result < __n) {
    if (_M_pnext < _M_pend) {
      size_t __chunk = (min) (static_cast<size_t>(_M_pend - _M_pnext),
                           static_cast<size_t>(__n - __result));
      _Traits::assign(_M_pnext, __chunk, __c);
      __result += __chunk;
      _M_pnext += __chunk;
    }
    else if (!_Traits::eq_int_type(this->overflow(_Traits::to_int_type(__c)),
                                   __eof))
      ++__result;
    else
      break;
  }
  return __result;
}
template <class _CharT, class _Traits>
typename basic_streambuf<_CharT, _Traits>::int_type
basic_streambuf<_CharT, _Traits>::_M_snextc_aux()
{
  int_type __eof = _Traits::eof();
  if (_M_gend == _M_gnext)
    return _Traits::eq_int_type(this->uflow(), __eof) ? __eof : this->sgetc();
  else {
    _M_gnext = _M_gend;
    return this->underflow();
  }
}
template <class _CharT, class _Traits>
typename basic_streambuf<_CharT, _Traits>::int_type
basic_streambuf<_CharT, _Traits>::pbackfail(int_type) {
 return _Traits::eof();
}
template <class _CharT, class _Traits>
typename basic_streambuf<_CharT, _Traits>::int_type
basic_streambuf<_CharT, _Traits>::overflow(int_type) {
  return _Traits::eof();
}
template <class _CharT, class _Traits>
typename basic_streambuf<_CharT, _Traits>::int_type
basic_streambuf<_CharT, _Traits>::uflow() {
    return ( _Traits::eq_int_type(this->underflow(),_Traits::eof()) ?
             _Traits::eof() :
             _Traits::to_int_type(*_M_gnext++));
}
template <class _CharT, class _Traits>
typename basic_streambuf<_CharT, _Traits>::int_type
basic_streambuf<_CharT, _Traits>::underflow()
{ return _Traits::eof(); }
template <class _CharT, class _Traits>
streamsize
basic_streambuf<_CharT, _Traits>::showmanyc()
{ return 0; }
template <class _CharT, class _Traits>
void
basic_streambuf<_CharT, _Traits>::imbue(const locale&) {}
template <class _CharT, class _Traits>
int
basic_streambuf<_CharT, _Traits>::sync() { return 0; }
template <class _CharT, class _Traits>
typename basic_streambuf<_CharT, _Traits>::pos_type
basic_streambuf<_CharT, _Traits>::seekpos(pos_type, ios_base::openmode)
{ return pos_type(-1); }
template <class _CharT, class _Traits>
typename basic_streambuf<_CharT, _Traits>::pos_type
basic_streambuf<_CharT, _Traits>::seekoff(off_type, ios_base::seekdir,
                                          ios_base::openmode)
{ return pos_type(-1); }
template <class _CharT, class _Traits>
basic_streambuf<_CharT, _Traits>*
basic_streambuf<_CharT, _Traits>:: setbuf(char_type*, streamsize)
{ return this; }
}
namespace stlp_std {
template <class _CharT, class _Traits>
basic_ios<_CharT, _Traits>
  ::basic_ios(basic_streambuf<_CharT, _Traits>* __streambuf)
    : ios_base(), _M_cached_ctype(0),
      _M_fill(_CharT()), _M_streambuf(0), _M_tied_ostream(0) {
  basic_ios<_CharT, _Traits>::init(__streambuf);
}
template <class _CharT, class _Traits>
basic_streambuf<_CharT, _Traits>*
basic_ios<_CharT, _Traits>::rdbuf(basic_streambuf<_CharT, _Traits>* __buf) {
  basic_streambuf<_CharT, _Traits>* __tmp = _M_streambuf;
  _M_streambuf = __buf;
  this->clear();
  return __tmp;
}
template <class _CharT, class _Traits>
basic_ios<_CharT, _Traits>&
basic_ios<_CharT, _Traits>::copyfmt(const basic_ios<_CharT, _Traits>& __x) {
  _M_invoke_callbacks(erase_event);
  _M_copy_state(__x);
  _M_cached_ctype = __x._M_cached_ctype;
  _M_fill = __x._M_fill;
  _M_tied_ostream = __x._M_tied_ostream;
  _M_invoke_callbacks(copyfmt_event);
  this->_M_set_exception_mask(__x.exceptions());
  return *this;
}
template <class _CharT, class _Traits>
locale basic_ios<_CharT, _Traits>::imbue(const locale& __loc) {
  locale __tmp = ios_base::imbue(__loc);
  try {
    if (_M_streambuf)
      _M_streambuf->pubimbue(__loc);
    _M_cached_ctype = &use_facet<ctype<char_type> >(__loc);
  }
  catch(...) {
    __tmp = ios_base::imbue(__tmp);
    _M_handle_exception(ios_base::failbit);
  }
  return __tmp;
}
template <class _CharT, class _Traits>
basic_ios<_CharT, _Traits>::basic_ios()
  : ios_base(),
    _M_fill(_CharT()), _M_streambuf(0), _M_tied_ostream(0)
{}
template <class _CharT, class _Traits>
void
basic_ios<_CharT, _Traits>::init(basic_streambuf<_CharT, _Traits>* __sb)
{
  this->rdbuf(__sb);
  this->imbue(locale());
  this->tie(0);
  this->_M_set_exception_mask(ios_base::goodbit);
  this->_M_clear_nothrow(__sb != 0 ? ios_base::goodbit : ios_base::badbit);
  ios_base::flags(ios_base::skipws | ios_base::dec);
  ios_base::width(0);
  ios_base::precision(6);
  this->fill(widen(' '));
}
template <class _CharT, class _Traits>
void basic_ios<_CharT, _Traits>::_M_handle_exception(ios_base::iostate __flag)
{
  this->_M_setstate_nothrow(__flag);
  if (this->_M_get_exception_mask() & __flag)
    throw;
}
}
namespace stlp_std {
namespace priv {
template<class _CharT, class _Traits>
extern basic_streambuf<_CharT, _Traits>* __get_ostreambuf(basic_ostream<_CharT, _Traits>&);
}
template <class _CharT, class _Traits>
class ostreambuf_iterator :
  public iterator<output_iterator_tag, void, void, void, void> {
public:
  typedef _CharT char_type;
  typedef _Traits traits_type;
  typedef typename _Traits::int_type int_type;
  typedef basic_streambuf<_CharT, _Traits> streambuf_type;
  typedef basic_ostream<_CharT, _Traits> ostream_type;
  typedef output_iterator_tag iterator_category;
  typedef void value_type;
  typedef void difference_type;
  typedef void pointer;
  typedef void reference;
public:
  ostreambuf_iterator(streambuf_type* __buf) throw() : _M_buf(__buf), _M_ok(__buf!=0) {}
  inline ostreambuf_iterator(ostream_type& __o) throw();
  ostreambuf_iterator<_CharT, _Traits>& operator=(char_type __c) {
    _M_ok = _M_ok && !traits_type::eq_int_type(_M_buf->sputc(__c),
                                               traits_type::eof());
    return *this;
  }
  ostreambuf_iterator<_CharT, _Traits>& operator*() { return *this; }
  ostreambuf_iterator<_CharT, _Traits>& operator++() { return *this; }
  ostreambuf_iterator<_CharT, _Traits>& operator++(int) { return *this; }
  bool failed() const { return !_M_ok; }
private:
  streambuf_type* _M_buf;
  bool _M_ok;
};
template <class _CharT, class _Traits>
inline ostreambuf_iterator<_CharT, _Traits>::ostreambuf_iterator(basic_ostream<_CharT, _Traits>& __o) throw()
  : _M_buf(::stlp_std::priv:: __get_ostreambuf(__o)), _M_ok(_M_buf != 0) {}
}
namespace stlp_std {
namespace priv {
template <class _CharT, class _Traits>
bool __init_bostr(basic_ostream<_CharT, _Traits>& __str);
}
template <class _CharT, class _Traits>
class basic_ostream : virtual public basic_ios<_CharT, _Traits> {
  typedef basic_ostream<_CharT, _Traits> _Self;
public:
  typedef _CharT char_type;
  typedef typename _Traits::int_type int_type;
  typedef typename _Traits::pos_type pos_type;
  typedef typename _Traits::off_type off_type;
  typedef _Traits traits_type;
  typedef basic_ios<_CharT, _Traits> _Basic_ios;
public:
  explicit basic_ostream(basic_streambuf<_CharT, _Traits>* __buf);
  ~basic_ostream();
public:
  typedef basic_ios<_CharT, _Traits>& ( *__ios_fn)(basic_ios<_CharT, _Traits>&);
  typedef ios_base& ( *__ios_base_fn)(ios_base&);
  typedef _Self& ( *__ostream_fn)(_Self&);
  _Self& operator<< (__ostream_fn __f) { return __f(*this); }
  _Self & operator<< (__ios_base_fn __f) { __f(*this); return *this; }
  _Self& operator<< (__ios_fn __ff) { __ff(*this); return *this; }
private:
  bool _M_copy_buffered(basic_streambuf<_CharT, _Traits>* __from,
                        basic_streambuf<_CharT, _Traits>* __to);
  bool _M_copy_unbuffered(basic_streambuf<_CharT, _Traits>* __from,
                          basic_streambuf<_CharT, _Traits>* __to);
public:
  void _M_put_char(_CharT __c);
  void _M_put_nowiden(const _CharT* __s);
  void _M_put_widen(const char* __s);
  bool _M_put_widen_aux(const char* __s, streamsize __n);
public:
  _Self& put(char_type __c);
  _Self& write(const char_type* __s, streamsize __n);
public:
  _Self& operator<<(basic_streambuf<_CharT, _Traits>* __buf);
  _Self& operator<<(unsigned char __x) { _M_put_char(__x); return *this; }
  _Self& operator<<(short __x);
  _Self& operator<<(unsigned short __x);
  _Self& operator<<(int __x);
  _Self& operator<<(unsigned int __x);
  _Self& operator<<(long __x);
  _Self& operator<<(unsigned long __x);
  _Self& operator<< (long long __x);
  _Self& operator<< (unsigned long long __x);
  _Self& operator<<(float __x);
  _Self& operator<<(double __x);
  _Self& operator<<(long double __x);
  _Self& operator<<(const void* __x);
  _Self& operator<<(bool __x);
public:
  _Self& flush() {
    if (this->rdbuf())
      if (this->rdbuf()->pubsync() == -1)
        this->setstate(ios_base::badbit);
    return *this;
  }
  pos_type tellp() {
    return this->rdbuf() && !this->fail()
      ? this->rdbuf()->pubseekoff(0, ios_base::cur, ios_base::out)
      : pos_type(-1);
  }
  _Self& seekp(pos_type __pos) {
    if (this->rdbuf() && !this->fail()) {
      if (this->rdbuf()->pubseekpos(__pos, ios_base::out) == pos_type(-1)) {
        this->setstate(ios_base::failbit);
      }
    }
    return *this;
  }
  _Self& seekp(off_type __off, ios_base::seekdir __dir) {
    if (this->rdbuf() && !this->fail())
      this->rdbuf()->pubseekoff(__off, __dir, ios_base::out);
    return *this;
  }
    class sentry {
      typedef sentry _Self;
    private:
      basic_ostream<_CharT, _Traits>& _M_str;
      bool _M_ok;
    public:
      explicit sentry(basic_ostream<_CharT, _Traits>& __str)
        : _M_str(__str), _M_ok(::stlp_std::priv:: __init_bostr(__str))
      {}
      ~sentry() {
        if (_M_str.flags() & ios_base::unitbuf)
          if (!uncaught_exception())
            _M_str.flush();
      }
      operator bool() const { return _M_ok; }
    private:
      sentry(const _Self& __s) : _M_str(__s._M_str) {}
      _Self& operator=(const _Self&) { return *this; }
    };
};
namespace priv {
template <class _CharT, class _Traits>
bool __init_bostr(basic_ostream<_CharT, _Traits>& __str) {
  if (__str.good()) {
    if (!__str.rdbuf())
      __str.setstate(ios_base::badbit);
    if (__str.tie())
      __str.tie()->flush();
    return __str.good();
  }
  else
    return false;
}
template <class _CharT, class _Traits>
inline basic_streambuf<_CharT, _Traits>*
__get_ostreambuf(basic_ostream<_CharT, _Traits>& __St)
{ return __St.rdbuf(); }
}
template <class _CharT, class _Traits>
inline basic_ostream<_CharT, _Traits>&
operator<<(basic_ostream<_CharT, _Traits>& __os, _CharT __c){
  __os._M_put_char(__c);
  return __os;
}
template <class _CharT, class _Traits>
inline basic_ostream<_CharT, _Traits>&
operator<<(basic_ostream<_CharT, _Traits>& __os, const _CharT* __s) {
  __os._M_put_nowiden(__s);
  return __os;
}
template <class _CharT, class _Traits>
inline basic_ostream<_CharT, _Traits>&
operator<<(basic_ostream<_CharT, _Traits>& __os, char __c) {
  __os._M_put_char(__os.widen(__c));
  return __os;
}
template <class _Traits>
inline basic_ostream<char, _Traits>&
operator<<(basic_ostream<char, _Traits>& __os, char __c) {
  __os._M_put_char(__c);
  return __os;
}
template <class _Traits>
inline basic_ostream<char, _Traits>&
operator<<(basic_ostream<char, _Traits>& __os, signed char __c) {
  __os._M_put_char(__c);
  return __os;
}
template <class _Traits>
inline basic_ostream<char, _Traits>&
operator<<(basic_ostream<char, _Traits>& __os, unsigned char __c) {
  __os._M_put_char(__c);
  return __os;
}
template <class _CharT, class _Traits>
inline basic_ostream<_CharT, _Traits>&
operator<<(basic_ostream<_CharT, _Traits>& __os, const char* __s) {
  __os._M_put_widen(__s);
  return __os;
}
template <class _Traits>
inline basic_ostream<char, _Traits>&
operator<<(basic_ostream<char, _Traits>& __os, const char* __s) {
  __os._M_put_nowiden(__s);
  return __os;
}
template <class _Traits>
inline basic_ostream<char, _Traits>&
operator<<(basic_ostream<char, _Traits>& __os, const signed char* __s) {
  __os._M_put_nowiden(reinterpret_cast<const char*>(__s));
  return __os;
}
template <class _Traits>
inline basic_ostream<char, _Traits>&
operator<<(basic_ostream<char, _Traits>& __os, const unsigned char* __s) {
  __os._M_put_nowiden(reinterpret_cast<const char*>(__s));
  return __os;
}
template <class _CharT, class _Traits>
inline basic_ostream<_CharT, _Traits>&
endl(basic_ostream<_CharT, _Traits>& __os) {
  __os.put(__os.widen('\n'));
  __os.flush();
  return __os;
}
template <class _CharT, class _Traits>
inline basic_ostream<_CharT, _Traits>&
ends(basic_ostream<_CharT, _Traits>& __os) {
  __os.put(_CharT());
  return __os;
}
template <class _CharT, class _Traits>
inline basic_ostream<_CharT, _Traits>&
flush(basic_ostream<_CharT, _Traits>& __os) {
  __os.flush();
  return __os;
}
}
namespace stlp_std {
namespace priv {
template <class _CharT>
class __iostring_allocator : public allocator<_CharT> {
public:
  enum { _STR_SIZE = 256 };
private:
  enum { _BUF_SIZE = _STR_SIZE + 1 };
  typedef allocator<_CharT> _Base;
  _CharT _M_static_buf[_BUF_SIZE];
public:
  typedef typename _Base::size_type size_type;
  typedef typename _Base::pointer pointer;
  template <class _Tp1> struct rebind {
    typedef __iostring_allocator<_Tp1> other;
  };
  _CharT* allocate(size_type __n, const void* __ptr = 0) {
    if (__n > _BUF_SIZE) {
      return _Base::allocate(__n, __ptr);
    }
    return _M_static_buf;
  }
  void deallocate(pointer __p, size_type __n) {
    if (__p != _M_static_buf) _Base::deallocate(__p, __n);
  }
};
template <class _CharT>
struct __basic_iostring : public basic_string<_CharT, char_traits<_CharT>, __iostring_allocator<_CharT> > {
  typedef __basic_iostring<_CharT> _Self;
  typedef basic_string<_CharT, char_traits<_CharT>, __iostring_allocator<_CharT> > _Base;
  typedef typename _Base::_Reserve_t _Reserve_t;
  __basic_iostring() : _Base(_Reserve_t(), __iostring_allocator<_CharT>::_STR_SIZE)
  {}
  _Self& operator=(const _CharT* __s) {
    _Base::operator=(__s);
    return *this;
  }
};
typedef __basic_iostring<char> __iostring;
typedef __basic_iostring<wchar_t> __iowstring;
}
}
namespace stlp_std {
template <class _CharT, class _OutputIter>
class num_put: public locale::facet {
public:
  typedef _CharT char_type;
  typedef _OutputIter iter_type;
  explicit num_put(size_t __refs = 0) : locale::facet(__refs) {}
  iter_type put(iter_type __s, ios_base& __f, char_type __fill,
                bool __val) const {
    return do_put(__s, __f, __fill, __val);
  }
  iter_type put(iter_type __s, ios_base& __f, char_type __fill,
               long __val) const {
    return do_put(__s, __f, __fill, __val);
  }
  iter_type put(iter_type __s, ios_base& __f, char_type __fill,
                unsigned long __val) const {
    return do_put(__s, __f, __fill, __val);
  }
  iter_type put(iter_type __s, ios_base& __f, char_type __fill,
                long long __val) const {
    return do_put(__s, __f, __fill, __val);
  }
  iter_type put(iter_type __s, ios_base& __f, char_type __fill,
                unsigned long long __val) const {
    return do_put(__s, __f, __fill, __val);
  }
  iter_type put(iter_type __s, ios_base& __f, char_type __fill,
                double __val) const {
    return do_put(__s, __f, __fill, (double)__val);
  }
  iter_type put(iter_type __s, ios_base& __f, char_type __fill,
                long double __val) const {
    return do_put(__s, __f, __fill, __val);
  }
  iter_type put(iter_type __s, ios_base& __f, char_type __fill,
                const void * __val) const {
    return do_put(__s, __f, __fill, __val);
  }
  static locale::id id;
protected:
  ~num_put() {}
  virtual _OutputIter do_put(_OutputIter __s, ios_base& __f, _CharT __fill, bool __val) const;
  virtual _OutputIter do_put(_OutputIter __s, ios_base& __f, _CharT __fill, long __val) const;
  virtual _OutputIter do_put(_OutputIter __s, ios_base& __f, _CharT __fill, unsigned long __val) const;
  virtual _OutputIter do_put(_OutputIter __s, ios_base& __f, _CharT __fill, double __val) const;
  virtual _OutputIter do_put(_OutputIter __s, ios_base& __f, _CharT __fill, long double __val) const;
  virtual _OutputIter do_put(_OutputIter __s, ios_base& __f, _CharT __fill, long long __val) const;
  virtual _OutputIter do_put(_OutputIter __s, ios_base& __f, _CharT __fill,
                           unsigned long long __val) const ;
  virtual _OutputIter do_put(_OutputIter __s, ios_base& __f, _CharT __fill, const void* __val) const;
};
namespace priv {
template <class _Integer>
char*
__write_integer_backward(char* __buf, ios_base::fmtflags __flags, _Integer __x);
extern size_t __write_float(__iostring&, ios_base::fmtflags, int, double);
extern size_t __write_float(__iostring&, ios_base::fmtflags, int, long double);
void __get_floor_digits(__iostring&, long double);
template <class _CharT>
void __get_money_digits(::stlp_std::priv:: __basic_iostring<_CharT>&, ios_base&, long double);
extern void __convert_float_buffer(__iostring const&, __iowstring&, const ctype<wchar_t>&, wchar_t, bool = true);
extern void __adjust_float_buffer(__iostring&, char);
extern char*
__write_integer(char* buf, ios_base::fmtflags flags, long x);
extern ptrdiff_t __insert_grouping(char* first, char* last, const string&, char, char, char, int);
extern void __insert_grouping(__iostring&, size_t, const string&, char, char, char, int);
extern ptrdiff_t __insert_grouping(wchar_t*, wchar_t*, const string&, wchar_t, wchar_t, wchar_t, int);
extern void __insert_grouping(__iowstring&, size_t, const string&, wchar_t, wchar_t, wchar_t, int);
}
}
       
namespace stlp_std {
enum float_round_style {
  round_indeterminate = -1,
  round_toward_zero = 0,
  round_to_nearest = 1,
  round_toward_infinity = 2,
  round_toward_neg_infinity = 3
};
enum float_denorm_style {
  denorm_indeterminate = -1,
  denorm_absent = 0,
  denorm_present = 1
};
namespace priv {
template <class __number>
class _Numeric_limits_base {
public:
  static __number ( min)() throw() { return __number(); }
  static __number ( max)() throw() { return __number(); }
  static const int digits = 0;
  static const int digits10 = 0;
  static const int radix = 0;
  static const int min_exponent = 0;
  static const int min_exponent10 = 0;
  static const int max_exponent = 0;
  static const int max_exponent10 = 0;
  static const float_denorm_style has_denorm = denorm_absent;
  static const float_round_style round_style = round_toward_zero;
  static const bool is_specialized = false;
  static const bool is_signed = false;
  static const bool is_integer = false;
  static const bool is_exact = false;
  static const bool has_infinity = false;
  static const bool has_quiet_NaN = false;
  static const bool has_signaling_NaN = false;
  static const bool has_denorm_loss = false;
  static const bool is_iec559 = false;
  static const bool is_bounded = false;
  static const bool is_modulo = false;
  static const bool traps = false;
  static const bool tinyness_before = false;
  static __number epsilon() throw() { return __number(); }
  static __number round_error() throw() { return __number(); }
  static __number infinity() throw() { return __number(); }
  static __number quiet_NaN() throw() { return __number(); }
  static __number signaling_NaN() throw() { return __number(); }
  static __number denorm_min() throw() { return __number(); }
};
template <class _Int,
          _Int __imin,
          _Int __imax,
          int __idigits, bool __ismod>
class _Integer_limits : public _Numeric_limits_base<_Int> {
public:
  static _Int ( min) () throw() { return (_Int)__imin; }
  static _Int ( max) () throw() { return (_Int)__imax; }
  static const int digits = (__idigits < 0) ? ((int)((sizeof(_Int) * (8))) - ((__imin == 0) ? 0 : 1)) : (__idigits);
  static const int digits10 = (digits * 301UL) / 1000;
  static const int radix = 2;
  static const bool is_specialized = true;
  static const bool is_signed = (__imin != 0);
  static const bool is_integer = true;
  static const bool is_exact = true;
  static const bool is_bounded = true;
  static const bool is_modulo = __ismod;
};
template <class __number,
         int __Digits, int __Digits10,
         int __MinExp, int __MaxExp,
         int __MinExp10, int __MaxExp10,
         bool __IsIEC559,
         float_denorm_style __DenormStyle,
         float_round_style __RoundStyle>
class _Floating_limits : public _Numeric_limits_base<__number> {
public:
  static const int digits = __Digits;
  static const int digits10 = __Digits10;
  static const int radix = 2;
  static const int min_exponent = __MinExp;
  static const int max_exponent = __MaxExp;
  static const int min_exponent10 = __MinExp10;
  static const int max_exponent10 = __MaxExp10;
  static const float_denorm_style has_denorm = __DenormStyle;
  static const float_round_style round_style = __RoundStyle;
  static const bool is_specialized = true;
  static const bool is_signed = true;
  static const bool has_infinity = true;
  static const bool has_quiet_NaN = true;
  static const bool has_signaling_NaN = true;
  static const bool is_iec559 = __IsIEC559 && has_infinity && has_quiet_NaN && has_signaling_NaN && (has_denorm == denorm_present);
  static const bool has_denorm_loss = false;
  static const bool is_bounded = true;
  static const bool traps = true;
  static const bool tinyness_before = false;
};
}
template<class _Tp>
class numeric_limits : public ::stlp_std::priv:: _Numeric_limits_base<_Tp> {};
template<>
class numeric_limits<bool>
  : public ::stlp_std::priv:: _Integer_limits<bool, false, true, 1, false>
{};
template<>
class numeric_limits<char>
  : public ::stlp_std::priv:: _Integer_limits<char, (-127 - 1), 127, -1, true>
{};
template<>
class numeric_limits<signed char>
  : public ::stlp_std::priv:: _Integer_limits<signed char, (-127 - 1), 127, -1, true>
{};
template<>
class numeric_limits<unsigned char>
  : public ::stlp_std::priv:: _Integer_limits<unsigned char, 0, (127 * 2 + 1), -1, true>
{};
template<>
class numeric_limits<wchar_t>
  : public ::stlp_std::priv:: _Integer_limits<wchar_t, (-2147483647 - 1), (2147483647), -1, true>
{};
template<>
class numeric_limits<short>
  : public ::stlp_std::priv:: _Integer_limits<short, (-32767 - 1), 32767, -1, true>
{};
template<>
class numeric_limits<unsigned short>
  : public ::stlp_std::priv:: _Integer_limits<unsigned short, 0, (32767 * 2 + 1), -1, true>
{};
template<>
class numeric_limits<int>
  : public ::stlp_std::priv:: _Integer_limits<int, (-2147483647 - 1), 2147483647, -1, true>
{};
template<>
class numeric_limits<unsigned int>
  : public ::stlp_std::priv:: _Integer_limits<unsigned int, 0, (2147483647 * 2U + 1U), -1, true>
{};
template<>
class numeric_limits<long>
  : public ::stlp_std::priv:: _Integer_limits<long, (-9223372036854775807L - 1L), 9223372036854775807L, -1, true>
{};
template<>
class numeric_limits<unsigned long>
  : public ::stlp_std::priv:: _Integer_limits<unsigned long, 0, (9223372036854775807L * 2UL + 1UL), -1, true>
{};
template<>
class numeric_limits<long long>
  : public ::stlp_std::priv:: _Integer_limits<long long, (-0x7fffffffffffffffLL -1LL), 0x7fffffffffffffffLL, -1, true>
{};
template<>
class numeric_limits<unsigned long long>
  : public ::stlp_std::priv:: _Integer_limits<unsigned long long, 0, 0xffffffffffffffffULL, -1, true>
{};
namespace priv {
template <class __dummy>
class _LimG {
public:
  static float get_F_inf();
  static float get_F_qNaN();
  static float get_F_sNaN();
  static float get_F_denormMin();
  static double get_D_inf();
  static double get_D_qNaN();
  static double get_D_sNaN();
  static double get_D_denormMin();
  static long double get_LD_inf();
  static long double get_LD_qNaN();
  static long double get_LD_sNaN();
  static long double get_LD_denormMin();
};
}
template<>
class numeric_limits<float>
  : public ::stlp_std::priv:: _Floating_limits<float,
                                       24,
                                       6,
                                       (-125),
                                       128,
                                       (-37),
                                       38,
                                       true,
                                       denorm_present,
                                       round_to_nearest> {
public:
  static float ( min) () throw() { return 1.17549435e-38F; }
  static float denorm_min() throw()
  { return 1.40129846e-45F; }
  static float ( max) () throw() { return 3.40282347e+38F; }
  static float epsilon() throw() { return 1.19209290e-7F; }
  static float round_error() throw() { return 0.5f; }
  static float infinity() throw() { return ::stlp_std::priv:: _LimG<bool>::get_F_inf(); }
  static float quiet_NaN() throw() { return ::stlp_std::priv:: _LimG<bool>::get_F_qNaN(); }
  static float signaling_NaN() throw() { return ::stlp_std::priv:: _LimG<bool>::get_F_sNaN(); }
};
template<>
class numeric_limits<double>
  : public ::stlp_std::priv:: _Floating_limits<double,
                                       53,
                                       15,
                                       (-1021),
                                       1024,
                                       (-307),
                                       308,
                                       true,
                                       denorm_present,
                                       round_to_nearest> {
public:
  static double ( min)() throw() { return 2.2250738585072014e-308; }
  static double denorm_min() throw()
  { return 4.9406564584124654e-324; }
  static double ( max)() throw() { return 1.7976931348623157e+308; }
  static double epsilon() throw() { return 2.2204460492503131e-16; }
  static double round_error() throw() { return 0.5; }
  static double infinity() throw() { return ::stlp_std::priv:: _LimG<bool>::get_D_inf(); }
  static double quiet_NaN() throw() { return ::stlp_std::priv:: _LimG<bool>::get_D_qNaN(); }
  static double signaling_NaN() throw() { return ::stlp_std::priv:: _LimG<bool>::get_D_sNaN(); }
};
template<>
class numeric_limits<long double>
  : public ::stlp_std::priv:: _Floating_limits<long double,
                                       64,
                                       18,
                                       (-16381),
                                       16384,
                                       (-4931),
                                       4932,
                                       false,
                                       denorm_present,
                                       round_to_nearest> {
public:
  static long double ( min) () throw() { return 3.36210314311209350626e-4932L; }
  static long double denorm_min() throw()
  { return 3.64519953188247460253e-4951L; }
  static const bool is_iec559 = false;
  static long double ( max) () throw() { return 1.18973149535723176502e+4932L; }
  static long double epsilon() throw() { return 1.08420217248550443401e-19L; }
  static long double round_error() throw() { return 0.5l; }
  static long double infinity() throw()
  { return ::stlp_std::priv:: _LimG<bool>::get_LD_inf(); }
  static long double quiet_NaN() throw()
  { return ::stlp_std::priv:: _LimG<bool>::get_LD_qNaN(); }
  static long double signaling_NaN() throw()
  { return ::stlp_std::priv:: _LimG<bool>::get_LD_sNaN(); }
};
}
namespace stlp_std {
namespace priv {
template <class __number> const bool _Numeric_limits_base<__number>:: is_specialized;
template <class __number> const int _Numeric_limits_base<__number>:: digits;
template <class __number> const int _Numeric_limits_base<__number>:: digits10;
template <class __number> const bool _Numeric_limits_base<__number>:: is_signed;
template <class __number> const bool _Numeric_limits_base<__number>:: is_integer;
template <class __number> const bool _Numeric_limits_base<__number>:: is_exact;
template <class __number> const int _Numeric_limits_base<__number>:: radix;
template <class __number> const int _Numeric_limits_base<__number>:: min_exponent;
template <class __number> const int _Numeric_limits_base<__number>:: max_exponent;
template <class __number> const int _Numeric_limits_base<__number>:: min_exponent10;
template <class __number> const int _Numeric_limits_base<__number>:: max_exponent10;
template <class __number> const bool _Numeric_limits_base<__number>:: has_infinity;
template <class __number> const bool _Numeric_limits_base<__number>:: has_quiet_NaN;
template <class __number> const bool _Numeric_limits_base<__number>:: has_signaling_NaN;
template <class __number> const float_denorm_style _Numeric_limits_base<__number>:: has_denorm;
template <class __number> const bool _Numeric_limits_base<__number>:: has_denorm_loss;
template <class __number> const bool _Numeric_limits_base<__number>:: is_iec559;
template <class __number> const bool _Numeric_limits_base<__number>:: is_bounded;
template <class __number> const bool _Numeric_limits_base<__number>:: is_modulo;
template <class __number> const bool _Numeric_limits_base<__number>:: traps;
template <class __number> const bool _Numeric_limits_base<__number>:: tinyness_before;
template <class __number> const float_round_style _Numeric_limits_base<__number>:: round_style;
template <class _Int, _Int __imin, _Int __imax, int __idigits, bool __ismod> const bool _Integer_limits<_Int, __imin, __imax, __idigits, __ismod>:: is_specialized;
template <class _Int, _Int __imin, _Int __imax, int __idigits, bool __ismod> const int _Integer_limits<_Int, __imin, __imax, __idigits, __ismod>:: digits;
template <class _Int, _Int __imin, _Int __imax, int __idigits, bool __ismod> const int _Integer_limits<_Int, __imin, __imax, __idigits, __ismod>:: digits10;
template <class _Int, _Int __imin, _Int __imax, int __idigits, bool __ismod> const bool _Integer_limits<_Int, __imin, __imax, __idigits, __ismod>:: is_signed;
template <class _Int, _Int __imin, _Int __imax, int __idigits, bool __ismod> const bool _Integer_limits<_Int, __imin, __imax, __idigits, __ismod>:: is_integer;
template <class _Int, _Int __imin, _Int __imax, int __idigits, bool __ismod> const bool _Integer_limits<_Int, __imin, __imax, __idigits, __ismod>:: is_exact;
template <class _Int, _Int __imin, _Int __imax, int __idigits, bool __ismod> const int _Integer_limits<_Int, __imin, __imax, __idigits, __ismod>:: radix;
template <class _Int, _Int __imin, _Int __imax, int __idigits, bool __ismod> const bool _Integer_limits<_Int, __imin, __imax, __idigits, __ismod>:: is_bounded;
template <class _Int, _Int __imin, _Int __imax, int __idigits, bool __ismod> const bool _Integer_limits<_Int, __imin, __imax, __idigits, __ismod>:: is_modulo;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const bool _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle>:: is_specialized;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const int _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle>:: digits;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const int _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle>:: digits10;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const bool _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle>:: is_signed;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const int _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle>:: radix;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const int _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle>:: min_exponent;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const int _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle>:: max_exponent;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const int _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle>:: min_exponent10;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const int _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle>:: max_exponent10;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const bool _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle>:: has_infinity;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const bool _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle>:: has_quiet_NaN;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const bool _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle>:: has_signaling_NaN;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const float_denorm_style _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle>:: has_denorm;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const bool _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle>:: has_denorm_loss;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const bool _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle>:: is_iec559;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const bool _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle>:: is_bounded;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const bool _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle>:: traps;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const bool _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle>:: tinyness_before;
template <class __number, int __Digits, int __Digits10, int __MinExp, int __MaxExp, int __MinExp10, int __MaxExp10, bool __IsIEC559, float_denorm_style __DenormStyle, float_round_style __RoundStyle> const float_round_style _Floating_limits< __number, __Digits, __Digits10, __MinExp, __MaxExp, __MinExp10, __MaxExp10, __IsIEC559, __DenormStyle, __RoundStyle>:: round_style;
template<class _Number, unsigned short _Word>
struct float_helper {
  union _WordsNumber {
    unsigned short _Words[8];
    _Number _num;
  };
  static _Number get_word_higher() throw() {
    _WordsNumber __tmp = { { _Word, 0, 0, 0, 0, 0, 0, 0 } };
    return __tmp._num;
  }
  static _Number get_word_lower() throw() {
    _WordsNumber __tmp = { { 0, 0, 0, 0, 0, 0, 0, 0 } };
    __tmp._Words[(sizeof(_Number) >= 12 ? 10 : sizeof(_Number)) / sizeof(unsigned short) - 1] = _Word;
    return __tmp._num;
  }
  static _Number get_from_last_word() throw() {
    return get_word_lower();
  }
  static _Number get_from_first_word() throw() {
    return get_word_higher();
  }
};
template<class _Number, unsigned short _Word1, unsigned short _Word2>
struct float_helper2 {
  union _WordsNumber {
    unsigned short _Words[8];
    _Number _num;
  };
  static _Number get_word_lower() throw() {
    _WordsNumber __tmp = { { 0, 0, 0, 0, 0, 0, 0, 0 } };
    __tmp._Words[(sizeof(_Number) >= 12 ? 10 : sizeof(_Number)) / sizeof(unsigned short) - 2] = _Word1;
    __tmp._Words[(sizeof(_Number) >= 12 ? 10 : sizeof(_Number)) / sizeof(unsigned short) - 1] = _Word2;
    return __tmp._num;
  }
  static _Number get_from_last_word() throw() {
    return get_word_lower();
  }
};
template <class __dummy>
float _LimG<__dummy>::get_F_inf() {
  typedef float_helper<float, 0x7f80u> _FloatHelper;
  return _FloatHelper::get_from_last_word();
}
template <class __dummy>
float _LimG<__dummy>::get_F_qNaN() {
  typedef float_helper<float, 0x7f81u> _FloatHelper;
  return _FloatHelper::get_from_last_word();
}
template <class __dummy>
float _LimG<__dummy>::get_F_sNaN() {
  typedef float_helper<float, 0x7fc1u> _FloatHelper;
  return _FloatHelper::get_from_last_word();
}
template <class __dummy>
float _LimG<__dummy>::get_F_denormMin() {
  typedef float_helper<float, 0x0001u> _FloatHelper;
  return _FloatHelper::get_from_first_word();
}
template <int __use_double_limits>
class _NumericLimitsAccess;
template<>
class _NumericLimitsAccess<1> {
public:
  static double get_inf() {
    typedef float_helper<double, 0x7ff0u> _FloatHelper;
    return _FloatHelper::get_from_last_word();
  }
  static double get_qNaN() {
    typedef float_helper<double, 0x7ff1u> _FloatHelper;
    return _FloatHelper::get_from_last_word();
  }
  static double get_sNaN() {
    typedef float_helper<double, 0x7ff9u> _FloatHelper;
    return _FloatHelper::get_from_last_word();
  }
};
template <class __dummy>
double _LimG<__dummy>::get_D_inf()
{ return _NumericLimitsAccess<1>::get_inf(); }
template <class __dummy>
double _LimG<__dummy>::get_D_qNaN()
{ return _NumericLimitsAccess<1>::get_qNaN(); }
template <class __dummy>
double _LimG<__dummy>::get_D_sNaN()
{ return _NumericLimitsAccess<1>::get_sNaN(); }
template <class __dummy>
double _LimG<__dummy>::get_D_denormMin() {
  typedef float_helper<double, 0x0001u> _FloatHelper;
  return _FloatHelper::get_from_first_word();
}
template<>
class _NumericLimitsAccess<0> {
public:
  static long double get_inf() {
    typedef float_helper2<long double, 0x8000u, 0x7fffu> _FloatHelper;
    return _FloatHelper::get_from_last_word();
  }
  static long double get_qNaN() {
    typedef float_helper2<long double, 0xc000u, 0x7fffu> _FloatHelper;
    return _FloatHelper::get_from_last_word();
  }
  static long double get_sNaN() {
    typedef float_helper2<long double, 0x9000u, 0x7fffu> _FloatHelper;
    return _FloatHelper::get_from_last_word();
  }
};
template <class __dummy>
long double _LimG<__dummy>::get_LD_inf() {
  const int __use_double_limits = sizeof(double) == sizeof(long double) ? 1 : 0;
  return _NumericLimitsAccess<__use_double_limits>::get_inf();
}
template <class __dummy>
long double _LimG<__dummy>::get_LD_qNaN() {
  const int __use_double_limits = sizeof(double) == sizeof(long double) ? 1 : 0;
  return _NumericLimitsAccess<__use_double_limits>::get_qNaN();
}
template <class __dummy>
long double _LimG<__dummy>::get_LD_sNaN() {
  const int __use_double_limits = sizeof(double) == sizeof(long double) ? 1 : 0;
  return _NumericLimitsAccess<__use_double_limits>::get_sNaN();
}
template <class __dummy>
long double _LimG<__dummy>::get_LD_denormMin() {
  typedef float_helper<long double, 0x0001u> _FloatHelper;
  return _FloatHelper::get_from_first_word();
}
}
}
namespace stlp_std {
namespace priv {
template <class _CharT, class _OutputIter>
_OutputIter
__copy_float_and_fill(const _CharT* __first, const _CharT* __last,
                      _OutputIter __oi,
                      ios_base::fmtflags __flags,
                      streamsize __width, _CharT __fill,
                      _CharT __xplus, _CharT __xminus) {
  if (__width <= __last - __first)
    return ::stlp_std::copy(__first, __last, __oi);
  else {
    streamsize __pad = __width - (__last - __first);
    ios_base::fmtflags __dir = __flags & ios_base::adjustfield;
    if (__dir == ios_base::left) {
      __oi = ::stlp_std::copy(__first, __last, __oi);
      return ::stlp_std::priv:: __fill_n(__oi, __pad, __fill);
    }
    else if (__dir == ios_base::internal && __first != __last &&
             (*__first == __xplus || *__first == __xminus)) {
      *__oi++ = *__first++;
      __oi = ::stlp_std::priv:: __fill_n(__oi, __pad, __fill);
      return ::stlp_std::copy(__first, __last, __oi);
    }
    else {
      __oi = ::stlp_std::priv:: __fill_n(__oi, __pad, __fill);
      return ::stlp_std::copy(__first, __last, __oi);
    }
  }
}
template <class _OutputIter>
_OutputIter
__put_float(__iostring &__str, _OutputIter __oi,
            ios_base& __f, wchar_t __fill,
            wchar_t __decimal_point, wchar_t __sep,
            size_t __group_pos, const string& __grouping) {
  const ctype<wchar_t>& __ct = use_facet<ctype<wchar_t> >(__f.getloc());
  __iowstring __wbuf;
  __convert_float_buffer(__str, __wbuf, __ct, __decimal_point);
  if (!__grouping.empty()) {
    __insert_grouping(__wbuf, __group_pos, __grouping,
                      __sep, __ct.widen('+'), __ct.widen('-'), 0);
  }
  return __copy_float_and_fill(__wbuf.data(), __wbuf.data() + __wbuf.size(), __oi,
                               __f.flags(), __f.width(0), __fill, __ct.widen('+'), __ct.widen('-'));
}
template <class _OutputIter>
_OutputIter
__put_float(__iostring &__str, _OutputIter __oi,
            ios_base& __f, char __fill,
            char __decimal_point, char __sep,
            size_t __group_pos, const string& __grouping) {
  if ((__group_pos < __str.size()) && (__str[__group_pos] == '.')) {
    __str[__group_pos] = __decimal_point;
  }
  if (!__grouping.empty()) {
    __insert_grouping(__str, __group_pos,
                      __grouping, __sep, '+', '-', 0);
  }
  return __copy_float_and_fill(__str.data(), __str.data() + __str.size(), __oi,
                               __f.flags(), __f.width(0), __fill, '+', '-');
}
template <class _CharT, class _OutputIter, class _Float>
_OutputIter
__do_put_float(_OutputIter __s, ios_base& __f,
                _CharT __fill, _Float __x) {
  __iostring __buf;
  size_t __group_pos = __write_float(__buf, __f.flags(), (int)__f.precision(), __x);
  const numpunct<_CharT>& __np = use_facet<numpunct<_CharT> >(__f.getloc());
  return __put_float(__buf, __s, __f, __fill,
                     __np.decimal_point(), __np.thousands_sep(),
                     __group_pos, __np.grouping());
}
inline void __get_money_digits_aux (__iostring &__buf, ios_base &, long double __x)
{ __get_floor_digits(__buf, __x); }
inline void __get_money_digits_aux (__iowstring &__wbuf, ios_base &__f, long double __x) {
  __iostring __buf;
  __get_floor_digits(__buf, __x);
  const ctype<wchar_t>& __ct = use_facet<ctype<wchar_t> >(__f.getloc());
  __convert_float_buffer(__buf, __wbuf, __ct, wchar_t(0), false);
}
template <class _CharT>
void __get_money_digits(::stlp_std::priv:: __basic_iostring<_CharT> &__buf, ios_base& __f, long double __x)
{ __get_money_digits_aux(__buf, __f, __x); }
template <class _CharT, class _OutputIter>
_OutputIter
__copy_integer_and_fill(const _CharT* __buf, ptrdiff_t __len,
                        _OutputIter __oi,
                        ios_base::fmtflags __flg, streamsize __wid, _CharT __fill,
                        _CharT __xplus, _CharT __xminus) {
  if (__len >= __wid)
    return ::stlp_std::copy(__buf, __buf + __len, __oi);
  else {
    typedef char __static_assert[(sizeof(streamsize) > sizeof(ptrdiff_t)) || ((sizeof(streamsize) == sizeof(ptrdiff_t)) && numeric_limits<ptrdiff_t>::is_signed) ? 1 : -1];
    ptrdiff_t __pad = static_cast<ptrdiff_t>((min) (static_cast<streamsize>((numeric_limits<ptrdiff_t>::max)()), static_cast<streamsize>(__wid - __len)));
    ios_base::fmtflags __dir = __flg & ios_base::adjustfield;
    if (__dir == ios_base::left) {
      __oi = ::stlp_std::copy(__buf, __buf + __len, __oi);
      return ::stlp_std::priv:: __fill_n(__oi, __pad, __fill);
    }
    else if (__dir == ios_base::internal && __len != 0 &&
             (__buf[0] == __xplus || __buf[0] == __xminus)) {
      *__oi++ = __buf[0];
      __oi = __fill_n(__oi, __pad, __fill);
      return ::stlp_std::copy(__buf + 1, __buf + __len, __oi);
    }
    else if (__dir == ios_base::internal && __len >= 2 &&
             (__flg & ios_base::showbase) &&
             (__flg & ios_base::basefield) == ios_base::hex) {
      *__oi++ = __buf[0];
      *__oi++ = __buf[1];
      __oi = __fill_n(__oi, __pad, __fill);
      return ::stlp_std::copy(__buf + 2, __buf + __len, __oi);
    }
    else {
      __oi = __fill_n(__oi, __pad, __fill);
      return ::stlp_std::copy(__buf, __buf + __len, __oi);
    }
  }
}
template <class _OutputIter>
_OutputIter
__put_integer(char* __buf, char* __iend, _OutputIter __s,
              ios_base& __f,
              ios_base::fmtflags __flags, wchar_t __fill) {
  locale __loc = __f.getloc();
  const ctype<wchar_t>& __ct = use_facet<ctype<wchar_t> >(__loc);
  wchar_t __xplus = __ct.widen('+');
  wchar_t __xminus = __ct.widen('-');
  wchar_t __wbuf[64];
  __ct.widen(__buf, __iend, __wbuf);
  ptrdiff_t __len = __iend - __buf;
  wchar_t* __eend = __wbuf + __len;
  const numpunct<wchar_t>& __np = use_facet<numpunct<wchar_t> >(__loc);
  const string& __grouping = __np.grouping();
  if (!__grouping.empty()) {
    int __basechars;
    if (__flags & ios_base::showbase)
      switch (__flags & ios_base::basefield) {
        case ios_base::hex: __basechars = 2; break;
        case ios_base::oct: __basechars = 1; break;
        default: __basechars = 0;
      }
    else
      __basechars = 0;
    __len = __insert_grouping(__wbuf, __eend, __grouping, __np.thousands_sep(),
                              __xplus, __xminus, __basechars);
  }
  return __copy_integer_and_fill((wchar_t*)__wbuf, __len, __s,
                                 __flags, __f.width(0), __fill, __xplus, __xminus);
}
template <class _OutputIter>
_OutputIter
__put_integer(char* __buf, char* __iend, _OutputIter __s,
              ios_base& __f, ios_base::fmtflags __flags, char __fill) {
  char __grpbuf[64];
  ptrdiff_t __len = __iend - __buf;
  const numpunct<char>& __np = use_facet<numpunct<char> >(__f.getloc());
  const string& __grouping = __np.grouping();
  if (!__grouping.empty()) {
    int __basechars;
    if (__flags & ios_base::showbase)
      switch (__flags & ios_base::basefield) {
        case ios_base::hex: __basechars = 2; break;
        case ios_base::oct: __basechars = 1; break;
        default: __basechars = 0;
      }
    else
      __basechars = 0;
    ::stlp_std::copy(__buf, __iend, (char *) __grpbuf);
    __buf = __grpbuf;
    __iend = __grpbuf + __len;
    __len = __insert_grouping(__buf, __iend, __grouping, __np.thousands_sep(),
                              '+', '-', __basechars);
  }
  return __copy_integer_and_fill(__buf, __len, __s, __flags, __f.width(0), __fill, '+', '-');
}
typedef long long __max_int_t;
typedef unsigned long long __umax_int_t;
__attribute__((visibility("default"))) const char* __hex_char_table_lo();
__attribute__((visibility("default"))) const char* __hex_char_table_hi();
template <class _Integer>
inline char*
__write_decimal_backward(char* __ptr, _Integer __x, ios_base::fmtflags __flags, const __true_type& ) {
  const bool __negative = __x < 0 ;
  __max_int_t __temp = __x;
  __umax_int_t __utemp = __negative?-__temp:__temp;
  for (; __utemp != 0; __utemp /= 10)
    *--__ptr = (char)((int)(__utemp % 10) + '0');
  if (__negative)
    *--__ptr = '-';
  else if (__flags & ios_base::showpos)
    *--__ptr = '+';
  return __ptr;
}
template <class _Integer>
inline char*
__write_decimal_backward(char* __ptr, _Integer __x, ios_base::fmtflags __flags, const __false_type& ) {
  for (; __x != 0; __x /= 10)
    *--__ptr = (char)((int)(__x % 10) + '0');
  if (__flags & ios_base::showpos)
    *--__ptr = '+';
  return __ptr;
}
template <class _Integer>
char*
__write_integer_backward(char* __buf, ios_base::fmtflags __flags, _Integer __x) {
  char* __ptr = __buf;
  if (__x == 0) {
    *--__ptr = '0';
    if ((__flags & ios_base::showpos) && ((__flags & (ios_base::oct | ios_base::hex)) == 0))
      *--__ptr = '+';
  }
  else {
    switch (__flags & ios_base::basefield) {
      case ios_base::oct:
        {
          __umax_int_t __temp = __x;
          if ( sizeof(__x) < 8 && sizeof(__umax_int_t) >= 8 )
            __temp &= 0xFFFFFFFF;
          for (; __temp != 0; __temp >>=3)
            *--__ptr = (char)((((unsigned)__temp)& 0x7) + '0');
          if (__flags & ios_base::showbase)
            *--__ptr = '0';
        }
        break;
      case ios_base::hex:
        {
          const char* __table_ptr = (__flags & ios_base::uppercase) ?
            __hex_char_table_hi() : __hex_char_table_lo();
          __umax_int_t __temp = __x;
          if ( sizeof(__x) < 8 && sizeof(__umax_int_t) >= 8 )
            __temp &= 0xFFFFFFFF;
          for (; __temp != 0; __temp >>=4)
            *--__ptr = __table_ptr[((unsigned)__temp & 0xF)];
          if (__flags & ios_base::showbase) {
            *--__ptr = __table_ptr[16];
            *--__ptr = '0';
          }
        }
        break;
      default:
        {
          typedef typename __bool2type<numeric_limits<_Integer>::is_signed>::_Ret _IsSigned;
          __ptr = __write_decimal_backward(__ptr, __x, __flags, _IsSigned());
        }
        break;
    }
  }
  return __ptr;
}
template <class _CharT, class _OutputIter, class _Integer>
_OutputIter
__do_put_integer(_OutputIter __s, ios_base& __f, _CharT __fill, _Integer __x) {
  char __buf[sizeof(_Integer) * 3 + 2];
  const ptrdiff_t __buf_size = sizeof(__buf) / sizeof(char);
  ios_base::fmtflags __flags = __f.flags();
  char* __ibeg = __write_integer_backward((char*)__buf + __buf_size, __flags, __x);
  return __put_integer(__ibeg, (char*)__buf + __buf_size, __s, __f, __flags, __fill);
}
template <class _CharT, class _OutputIter>
_OutputIter
__do_put_bool(_OutputIter __s, ios_base& __f, _CharT __fill, bool __x) {
  const numpunct<_CharT>& __np = use_facet<numpunct<_CharT> >(__f.getloc());
  basic_string<_CharT, char_traits<_CharT>, allocator<_CharT> > __str = __x ? __np.truename() : __np.falsename();
  streamsize __wid = __f.width(0);
  if (__str.size() >= static_cast<size_t>(__wid))
    return ::stlp_std::copy(__str.begin(), __str.end(), __s);
  else {
    streamsize __pad = __wid - __str.size();
    ios_base::fmtflags __dir = __f.flags() & ios_base::adjustfield;
    if (__dir == ios_base::left) {
      __s = ::stlp_std::copy(__str.begin(), __str.end(), __s);
      return __fill_n(__s, __pad, __fill);
    }
    else {
      __s = __fill_n(__s, __pad, __fill);
      return ::stlp_std::copy(__str.begin(), __str.end(), __s);
    }
  }
}
}
template <class _CharT, class _OutputIterator>
locale::id num_put<_CharT, _OutputIterator>::id;
template <class _CharT, class _OutputIter>
_OutputIter
num_put<_CharT, _OutputIter>::do_put(_OutputIter __s, ios_base& __f, _CharT __fill,
                                     bool __val) const {
  if (!(__f.flags() & ios_base::boolalpha))
    return do_put(__s, __f, __fill, static_cast<long>(__val));
  return ::stlp_std::priv:: __do_put_bool(__s, __f, __fill, __val);
}
template <class _CharT, class _OutputIter>
_OutputIter
num_put<_CharT, _OutputIter>::do_put(_OutputIter __s, ios_base& __f, _CharT __fill,
                                     long __val) const
{ return ::stlp_std::priv:: __do_put_integer(__s, __f, __fill, __val); }
template <class _CharT, class _OutputIter>
_OutputIter
num_put<_CharT, _OutputIter>::do_put(_OutputIter __s, ios_base& __f, _CharT __fill,
                                     unsigned long __val) const
{ return ::stlp_std::priv:: __do_put_integer(__s, __f, __fill, __val); }
template <class _CharT, class _OutputIter>
_OutputIter
num_put<_CharT, _OutputIter>::do_put(_OutputIter __s, ios_base& __f, _CharT __fill,
                                     double __val) const
{ return ::stlp_std::priv:: __do_put_float(__s, __f, __fill, __val); }
template <class _CharT, class _OutputIter>
_OutputIter
num_put<_CharT, _OutputIter>::do_put(_OutputIter __s, ios_base& __f, _CharT __fill,
                                     long double __val) const
{ return ::stlp_std::priv:: __do_put_float(__s, __f, __fill, __val); }
template <class _CharT, class _OutputIter>
_OutputIter
num_put<_CharT, _OutputIter>::do_put(_OutputIter __s, ios_base& __f, _CharT __fill,
                                     long long __val) const
{ return ::stlp_std::priv:: __do_put_integer(__s, __f, __fill, __val); }
template <class _CharT, class _OutputIter>
_OutputIter
num_put<_CharT, _OutputIter>::do_put(_OutputIter __s, ios_base& __f, _CharT __fill,
                                     unsigned long long __val) const
{ return ::stlp_std::priv:: __do_put_integer(__s, __f, __fill, __val); }
template <class _CharT, class _OutputIter>
_OutputIter
num_put<_CharT, _OutputIter>::do_put(_OutputIter __s, ios_base& __f, _CharT ,
                                     const void* __val) const {
  const ctype<_CharT>& __c_type = use_facet<ctype<_CharT> >(__f.getloc());
  ios_base::fmtflags __save_flags = __f.flags();
  __f.setf(ios_base::hex, ios_base::basefield);
  __f.setf(ios_base::showbase);
  __f.setf(ios_base::internal, ios_base::adjustfield);
  __f.width((sizeof(void*) * 2) + 2);
  if ( __val == 0 ) {
    const char* __table_ptr = (__save_flags & ios_base::uppercase) ?
            ::stlp_std::priv:: __hex_char_table_hi() : ::stlp_std::priv:: __hex_char_table_lo();
    __s++ = __c_type.widen( '0' );
    __s++ = __c_type.widen( __table_ptr[16] );
    __f.width((sizeof(void*) * 2));
  } else {
    __f.width((sizeof(void*) * 2) + 2);
  }
  _OutputIter result =
    ( sizeof(void*) == sizeof(unsigned long) ) ?
    ::stlp_std::priv:: __do_put_integer(__s, __f, __c_type.widen('0'), reinterpret_cast<unsigned long>(__val))
      :
    ::stlp_std::priv:: __do_put_integer(__s, __f, __c_type.widen('0'), reinterpret_cast<unsigned long long>(__val))
        ;
  __f.flags(__save_flags);
  return result;
}
}
namespace stlp_std {
template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>::basic_ostream(basic_streambuf<_CharT, _Traits>* __buf)
    : basic_ios<_CharT, _Traits>() {
  this->init(__buf);
}
template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>::~basic_ostream()
{}
template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>&
basic_ostream<_CharT, _Traits>::operator<<(basic_streambuf<_CharT, _Traits>* __from) {
  sentry __sentry(*this);
  if (__sentry) {
    if (__from) {
      bool __any_inserted = __from->gptr() != __from->egptr()
        ? this->_M_copy_buffered(__from, this->rdbuf())
        : this->_M_copy_unbuffered(__from, this->rdbuf());
      if (!__any_inserted)
        this->setstate(ios_base::failbit);
    }
    else
      this->setstate(ios_base::badbit);
  }
  return *this;
}
template <class _CharT, class _Traits>
bool basic_ostream<_CharT, _Traits>
  ::_M_copy_buffered(basic_streambuf<_CharT, _Traits>* __from,
                     basic_streambuf<_CharT, _Traits>* __to) {
  bool __any_inserted = false;
  while (__from->egptr() != __from->gptr()) {
    const ptrdiff_t __avail = __from->egptr() - __from->gptr();
    streamsize __nwritten;
    try {
      __nwritten = __to->sputn(__from->gptr(), __avail);
      __from->gbump((int)__nwritten);
    }
    catch(...) {
      this->_M_handle_exception(ios_base::badbit);
      return __any_inserted;
    }
    if (__nwritten == __avail) {
      try {
        if (this->_S_eof(__from->sgetc()))
          return true;
        else
          __any_inserted = true;
      }
      catch(...) {
        this->_M_handle_exception(ios_base::failbit);
        return false;
      }
    }
    else if (__nwritten != 0)
      return true;
    else
      return __any_inserted;
  }
  return __any_inserted || this->_M_copy_unbuffered(__from, __to);
}
template <class _CharT, class _Traits>
struct _SPutBackC {
  typedef basic_streambuf<_CharT, _Traits> _StreamBuf;
  typedef typename _StreamBuf::int_type int_type;
  _SPutBackC(_StreamBuf *pfrom)
    : __pfrom(pfrom), __c(0), __do_guard(false) {}
  ~_SPutBackC() {
    if (__do_guard) {
      __pfrom->sputbackc(_Traits::to_char_type(__c));
    }
  }
  void guard(int_type c) {
    __c = c;
    __do_guard = true;
  }
  void release() {
    __do_guard = false;
  }
private:
  _StreamBuf *__pfrom;
  int_type __c;
  bool __do_guard;
};
template <class _CharT, class _Traits>
bool basic_ostream<_CharT, _Traits>
  ::_M_copy_unbuffered(basic_streambuf<_CharT, _Traits>* __from,
                       basic_streambuf<_CharT, _Traits>* __to) {
  typedef _SPutBackC<_CharT, _Traits> _SPutBackCGuard;
  bool __any_inserted = false;
  int_type __c;
  try {
    _SPutBackCGuard __cguard(__from);
    for (;;) {
      try {
        __c = __from->sbumpc();
      }
      catch(...) {
        this->_M_handle_exception(ios_base::failbit);
        break;
      }
      if (this->_S_eof(__c))
        break;
      __cguard.guard(__c);
      if (this->_S_eof(__to->sputc(_Traits::to_char_type(__c))))
        break;
      __cguard.release();
      __any_inserted = true;
    }
  }
  catch(...) {
    this->_M_handle_exception(ios_base::badbit);
  }
  return __any_inserted;
}
namespace priv {
template <class _CharT, class _Traits, class _Number>
basic_ostream<_CharT, _Traits>&
__put_num(basic_ostream<_CharT, _Traits>& __os, _Number __x) {
  typedef typename basic_ostream<_CharT, _Traits>::sentry _Sentry;
  _Sentry __sentry(__os);
  bool __failed = true;
  if (__sentry) {
    try {
      typedef num_put<_CharT, ostreambuf_iterator<_CharT, _Traits> > _NumPut;
      __failed = (use_facet<_NumPut>(__os.getloc())).put(ostreambuf_iterator<_CharT, _Traits>(__os.rdbuf()),
                                                         __os, __os.fill(),
                                                         __x).failed();
    }
    catch(...) {
      __os._M_handle_exception(ios_base::badbit);
    }
  }
  if (__failed)
    __os.setstate(ios_base::badbit);
  return __os;
}
}
template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<<(short __x) {
  typedef char __static_assert[sizeof(short) <= sizeof(long) ? 1 : -1];
  long __tmp = ((this->flags() & _Basic_ios::basefield) != ios_base::dec) ?
                  static_cast<long>(static_cast<unsigned short>(__x)): __x;
  return ::stlp_std::priv:: __put_num(*this, __tmp);
}
template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<<(unsigned short __x) {
  typedef char __static_assert[sizeof(unsigned short) <= sizeof(unsigned long) ? 1 : -1];
  return ::stlp_std::priv:: __put_num(*this, static_cast<unsigned long>(__x));
}
template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<<(int __x) {
  typedef char __static_assert[sizeof(int) <= sizeof(long) ? 1 : -1];
  long __tmp = ((this->flags() & _Basic_ios::basefield) != ios_base::dec) ?
                  static_cast<long>(static_cast<unsigned int>(__x)): __x;
  return ::stlp_std::priv:: __put_num(*this, __tmp);
}
template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<<(unsigned int __x) {
  typedef char __static_assert[sizeof(unsigned int) <= sizeof(unsigned long) ? 1 : -1];
  return ::stlp_std::priv:: __put_num(*this, static_cast<unsigned long>(__x));
}
template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<<(long __x)
{ return ::stlp_std::priv:: __put_num(*this, __x); }
template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<<(unsigned long __x)
{ return ::stlp_std::priv:: __put_num(*this, __x); }
template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<< (long long __x)
{ return ::stlp_std::priv:: __put_num(*this, __x); }
template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<< (unsigned long long __x)
{ return ::stlp_std::priv:: __put_num(*this, __x); }
template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<<(float __x)
{ return ::stlp_std::priv:: __put_num(*this, static_cast<double>(__x)); }
template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<<(double __x)
{ return ::stlp_std::priv:: __put_num(*this, __x); }
template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<<(long double __x)
{ return ::stlp_std::priv:: __put_num(*this, __x); }
template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<<(const void* __x)
{ return ::stlp_std::priv:: __put_num(*this, __x); }
template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>& basic_ostream<_CharT, _Traits>::operator<<(bool __x)
{ return ::stlp_std::priv:: __put_num(*this, __x); }
template <class _CharT, class _Traits>
void basic_ostream<_CharT, _Traits>::_M_put_char(_CharT __c) {
  sentry __sentry(*this);
  if (__sentry) {
    bool __failed = true;
    try {
      streamsize __npad = this->width() > 0 ? this->width() - 1 : 0;
      if (__npad == 0)
        __failed = this->_S_eof(this->rdbuf()->sputc(__c));
      else if ((this->flags() & ios_base::adjustfield) == ios_base::left) {
        __failed = this->_S_eof(this->rdbuf()->sputc(__c));
        __failed = __failed ||
                   this->rdbuf()->_M_sputnc(this->fill(), __npad) != __npad;
      }
      else {
        __failed = this->rdbuf()->_M_sputnc(this->fill(), __npad) != __npad;
        __failed = __failed || this->_S_eof(this->rdbuf()->sputc(__c));
      }
      this->width(0);
    }
    catch(...) {
      this->_M_handle_exception(ios_base::badbit);
    }
    if (__failed)
      this->setstate(ios_base::badbit);
  }
}
template <class _CharT, class _Traits>
void basic_ostream<_CharT, _Traits>::_M_put_nowiden(const _CharT* __s) {
  sentry __sentry(*this);
  if (__sentry) {
    bool __failed = true;
    streamsize __n = _Traits::length(__s);
    streamsize __npad = this->width() > __n ? this->width() - __n : 0;
    try {
      if (__npad == 0)
        __failed = this->rdbuf()->sputn(__s, __n) != __n;
      else if ((this->flags() & ios_base::adjustfield) == ios_base::left) {
        __failed = this->rdbuf()->sputn(__s, __n) != __n;
        __failed = __failed ||
                   this->rdbuf()->_M_sputnc(this->fill(), __npad) != __npad;
      }
      else {
        __failed = this->rdbuf()->_M_sputnc(this->fill(), __npad) != __npad;
        __failed = __failed || this->rdbuf()->sputn(__s, __n) != __n;
      }
      this->width(0);
    }
    catch(...) {
      this->_M_handle_exception(ios_base::badbit);
    }
    if (__failed)
      this->setstate(ios_base::failbit);
  }
}
template <class _CharT, class _Traits>
void basic_ostream<_CharT, _Traits>::_M_put_widen(const char* __s) {
  sentry __sentry(*this);
  if (__sentry) {
    bool __failed = true;
    streamsize __n = char_traits<char>::length(__s);
    streamsize __npad = this->width() > __n ? this->width() - __n : 0;
    try {
      if (__npad == 0)
        __failed = !this->_M_put_widen_aux(__s, __n);
      else if ((this->flags() & ios_base::adjustfield) == ios_base::left) {
        __failed = !this->_M_put_widen_aux(__s, __n);
        __failed = __failed ||
                   this->rdbuf()->_M_sputnc(this->fill(), __npad) != __npad;
      }
      else {
        __failed = this->rdbuf()->_M_sputnc(this->fill(), __npad) != __npad;
        __failed = __failed || !this->_M_put_widen_aux(__s, __n);
      }
      this->width(0);
    }
    catch(...) {
      this->_M_handle_exception(ios_base::badbit);
    }
    if (__failed)
      this->setstate(ios_base::failbit);
  }
}
template <class _CharT, class _Traits>
bool basic_ostream<_CharT, _Traits>::_M_put_widen_aux(const char* __s,
                                                      streamsize __n) {
  basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
  for ( ; __n > 0 ; --__n)
    if (this->_S_eof(__buf->sputc(this->widen(*__s++))))
      return false;
  return true;
}
template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>&
basic_ostream<_CharT, _Traits>::put(char_type __c) {
  sentry __sentry(*this);
  bool __failed = true;
  if (__sentry) {
    try {
      __failed = this->_S_eof(this->rdbuf()->sputc(__c));
    }
    catch(...) {
      this->_M_handle_exception(ios_base::badbit);
    }
  }
  if (__failed)
    this->setstate(ios_base::badbit);
  return *this;
}
template <class _CharT, class _Traits>
basic_ostream<_CharT, _Traits>&
basic_ostream<_CharT, _Traits>::write(const char_type* __s, streamsize __n) {
  sentry __sentry(*this);
  bool __failed = true;
  if (__sentry) {
    try {
      __failed = this->rdbuf()->sputn(__s, __n) != __n;
    }
    catch(...) {
      this->_M_handle_exception(ios_base::badbit);
    }
  }
  if (__failed)
    this->setstate(ios_base::badbit);
  return *this;
}
}
namespace stlp_std {
template <class _CharT, class _Traits>
extern basic_streambuf<_CharT, _Traits>* _M_get_istreambuf(basic_istream<_CharT, _Traits>& ) ;
template<class _CharT, class _Traits>
class istreambuf_iterator :
  public iterator<input_iterator_tag, _CharT, typename _Traits::off_type, _CharT*, _CharT&>
{
public:
  typedef _CharT char_type;
  typedef _Traits traits_type;
  typedef typename _Traits::int_type int_type;
  typedef basic_streambuf<_CharT, _Traits> streambuf_type;
  typedef basic_istream<_CharT, _Traits> istream_type;
  typedef input_iterator_tag iterator_category;
  typedef _CharT value_type;
  typedef typename _Traits::off_type difference_type;
  typedef const _CharT* pointer;
  typedef const _CharT& reference;
public:
  istreambuf_iterator(streambuf_type* __p = 0) { this->_M_init(__p); }
  inline istreambuf_iterator(basic_istream<_CharT, _Traits>& __is);
  char_type operator*() const { this->_M_getc(); return _M_c; }
  istreambuf_iterator<_CharT, _Traits>& operator++() {
    _M_buf->sbumpc();
    _M_have_c = false;
    return *this;
  }
  istreambuf_iterator<_CharT, _Traits> operator++(int);
  bool equal(const istreambuf_iterator<_CharT, _Traits>& __i) const {
    if (this->_M_buf)
      this->_M_getc();
    if (__i._M_buf)
      __i._M_getc();
    return this->_M_eof == __i._M_eof;
  }
private:
  void _M_init(streambuf_type* __p) {
    _M_buf = __p;
    _M_eof = (__p == 0);
    _M_have_c = false;
  }
  void _M_getc() const {
    if (_M_have_c)
      return;
    int_type __c = _M_buf->sgetc();
    _M_c = traits_type::to_char_type(__c);
    _M_eof = traits_type::eq_int_type(__c, traits_type::eof());
    _M_have_c = true;
  }
private:
  streambuf_type* _M_buf;
  mutable _CharT _M_c;
  mutable bool _M_eof;
  mutable bool _M_have_c;
};
template<class _CharT, class _Traits>
inline istreambuf_iterator<_CharT, _Traits>::istreambuf_iterator(basic_istream<_CharT, _Traits>& __is)
{ this->_M_init(_M_get_istreambuf(__is)); }
template<class _CharT, class _Traits>
inline bool operator==(const istreambuf_iterator<_CharT, _Traits>& __x,
                                  const istreambuf_iterator<_CharT, _Traits>& __y) {
  return __x.equal(__y);
}
template<class _CharT, class _Traits>
inline bool operator!=(const istreambuf_iterator<_CharT, _Traits>& __x,
                                  const istreambuf_iterator<_CharT, _Traits>& __y) {
  return !__x.equal(__y);
}
template <class _CharT, class _Traits>
istreambuf_iterator<_CharT, _Traits>
istreambuf_iterator<_CharT, _Traits>::operator++(int) {
  _M_getc();
  istreambuf_iterator<_CharT, _Traits> __tmp = *this;
  _M_buf->sbumpc();
  _M_have_c = false;
  return __tmp;
}
}
namespace stlp_std {
struct _No_Skip_WS {};
template <class _CharT, class _Traits>
bool _M_init_skip(basic_istream<_CharT, _Traits>& __istr);
template <class _CharT, class _Traits>
bool _M_init_noskip(basic_istream<_CharT, _Traits>& __istr);
template <class _CharT, class _Traits>
class basic_istream : virtual public basic_ios<_CharT, _Traits> {
  typedef basic_istream<_CharT, _Traits> _Self;
public:
  typedef _CharT char_type;
  typedef typename _Traits::int_type int_type;
  typedef typename _Traits::pos_type pos_type;
  typedef typename _Traits::off_type off_type;
  typedef _Traits traits_type;
  typedef basic_ios<_CharT, _Traits> _Basic_ios;
  typedef basic_ios<_CharT, _Traits>& ( *__ios_fn)(basic_ios<_CharT, _Traits>&);
  typedef ios_base& ( *__ios_base_fn)(ios_base&);
  typedef _Self& ( *__istream_fn)(_Self&);
public:
  explicit basic_istream(basic_streambuf<_CharT, _Traits>* __buf) :
    basic_ios<_CharT, _Traits>(), _M_gcount(0) {
    this->init(__buf);
  }
  ~basic_istream() {};
public:
public:
  _Self& operator>> (__istream_fn __f) { return __f(*this); }
  _Self& operator>> (__ios_fn __f) { __f(*this); return *this; }
  _Self& operator>> (__ios_base_fn __f) { __f(*this); return *this; }
public:
  _Self& operator>> (short& __val);
  _Self& operator>> (int& __val);
  _Self& operator>> (unsigned short& __val);
  _Self& operator>> (unsigned int& __val);
  _Self& operator>> (long& __val);
  _Self& operator>> (unsigned long& __val);
  _Self& operator>> (long long& __val);
  _Self& operator>> (unsigned long long& __val);
  _Self& operator>> (float& __val);
  _Self& operator>> (double& __val);
  _Self& operator>> (long double& __val);
  _Self& operator>> (bool& __val);
  _Self& operator>> (void*& __val);
public:
  _Self& operator>>(basic_streambuf<_CharT, _Traits>*);
public:
  streamsize gcount() const { return _M_gcount; }
  int_type peek();
public:
  int_type get();
  _Self& get(char_type& __c);
public:
  _Self& get(char_type* __s, streamsize __n, char_type __delim);
  _Self& get(char_type* __s, streamsize __n)
    { return get(__s, __n, this->widen('\n')); }
public:
  _Self& get(basic_streambuf<_CharT, _Traits>& __buf,
                     char_type __delim);
  _Self& get(basic_streambuf<_CharT, _Traits>& __buf)
    { return get(__buf, this->widen('\n')); }
public:
  _Self& getline(char_type* __s, streamsize __n, char_type delim);
  _Self& getline(char_type* __s, streamsize __n)
    { return getline(__s, __n, this->widen('\n')); }
public:
  _Self& ignore();
  _Self& ignore(streamsize __n);
  _Self& ignore(streamsize __n, int_type __delim);
  _Self& read(char_type* __s, streamsize __n);
  streamsize readsome(char_type* __s, streamsize __n);
public:
  _Self& putback(char_type __c);
  _Self& unget();
public:
  int sync();
  pos_type tellg();
  _Self& seekg(pos_type __pos);
  _Self& seekg(off_type, ios_base::seekdir);
public:
  void _M_formatted_get(_CharT& __c);
  void _M_formatted_get(_CharT* __s);
  void _M_skip_whitespace(bool __set_failbit);
private:
  streamsize _M_gcount;
public:
  class sentry {
    typedef sentry _Self;
  private:
    const bool _M_ok;
  public:
    typedef _Traits traits_type;
    explicit sentry(basic_istream<_CharT, _Traits>& __istr,
                    bool __noskipws = false) :
      _M_ok((__noskipws || !(__istr.flags() & ios_base::skipws)) ? _M_init_noskip(__istr) : _M_init_skip(__istr) )
      {}
    sentry(basic_istream<_CharT, _Traits>& __istr, _No_Skip_WS) :
      _M_ok(_M_init_noskip(__istr)) {}
    ~sentry() {}
    operator bool() const { return _M_ok; }
  private:
    sentry(const _Self&) : _M_ok(false) {}
    _Self& operator=(const _Self&) { return *this; }
  };
};
template <class _CharT, class _Traits>
inline basic_istream<_CharT, _Traits>&
operator>>(basic_istream<_CharT, _Traits>& __in_str, _CharT& __c) {
  __in_str._M_formatted_get(__c);
  return __in_str;
}
template <class _Traits>
inline basic_istream<char, _Traits>&
operator>>(basic_istream<char, _Traits>& __in_str, unsigned char& __c) {
  __in_str._M_formatted_get(reinterpret_cast<char&>(__c));
  return __in_str;
}
template <class _Traits>
inline basic_istream<char, _Traits>&
operator>>(basic_istream<char, _Traits>& __in_str, signed char& __c) {
  __in_str._M_formatted_get(reinterpret_cast<char&>(__c));
  return __in_str;
}
template <class _CharT, class _Traits>
inline basic_istream<_CharT, _Traits>&
operator>>(basic_istream<_CharT, _Traits>& __in_str, _CharT* __s) {
  __in_str._M_formatted_get(__s);
  return __in_str;
}
template <class _Traits>
inline basic_istream<char, _Traits>&
operator>>(basic_istream<char, _Traits>& __in_str, unsigned char* __s) {
  __in_str._M_formatted_get(reinterpret_cast<char*>(__s));
  return __in_str;
}
template <class _Traits>
inline basic_istream<char, _Traits>&
operator>>(basic_istream<char, _Traits>& __in_str, signed char* __s) {
  __in_str._M_formatted_get(reinterpret_cast<char*>(__s));
  return __in_str;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>&
ws(basic_istream<_CharT, _Traits>& __istr) {
  if (!__istr.eof()) {
    typedef typename basic_istream<_CharT, _Traits>::sentry _Sentry;
    _Sentry __sentry(__istr, _No_Skip_WS());
    if (__sentry)
      __istr._M_skip_whitespace(false);
  }
  return __istr;
}
template <class _CharT, class _Traits>
inline bool _M_init_skip(basic_istream<_CharT, _Traits>& __istr) {
  if (__istr.good()) {
    if (__istr.tie())
      __istr.tie()->flush();
    __istr._M_skip_whitespace(true);
  }
  if (!__istr.good()) {
    __istr.setstate(ios_base::failbit);
    return false;
  } else
    return true;
}
template <class _CharT, class _Traits>
inline bool _M_init_noskip(basic_istream<_CharT, _Traits>& __istr) {
  if (__istr.good()) {
    if (__istr.tie())
      __istr.tie()->flush();
    if (!__istr.rdbuf())
      __istr.setstate(ios_base::badbit);
  }
  else
    __istr.setstate(ios_base::failbit);
  return __istr.good();
}
template <class _CharT, class _Traits>
class basic_iostream
  : public basic_istream<_CharT, _Traits>,
    public basic_ostream<_CharT, _Traits>
{
public:
  typedef basic_ios<_CharT, _Traits> _Basic_ios;
  explicit basic_iostream(basic_streambuf<_CharT, _Traits>* __buf);
  virtual ~basic_iostream();
};
template <class _CharT, class _Traits>
basic_streambuf<_CharT, _Traits>* _M_get_istreambuf(basic_istream<_CharT, _Traits>& __istr)
{ return __istr.rdbuf(); }
}
namespace stlp_std {
template <class _CharT, class _InputIter>
class num_get: public locale::facet {
public:
  typedef _CharT char_type;
  typedef _InputIter iter_type;
  explicit num_get(size_t __refs = 0): locale::facet(__refs) {}
  _InputIter get(_InputIter __ii, _InputIter __end, ios_base& __str,
                 ios_base::iostate& __err, bool& __val) const
  { return do_get(__ii, __end, __str, __err, __val); }
  _InputIter get(_InputIter __ii, _InputIter __end, ios_base& __str,
                 ios_base::iostate& __err, long& __val) const
  { return do_get(__ii, __end, __str, __err, __val); }
  _InputIter get(_InputIter __ii, _InputIter __end, ios_base& __str,
                 ios_base::iostate& __err, unsigned short& __val) const
  { return do_get(__ii, __end, __str, __err, __val); }
  _InputIter get(_InputIter __ii, _InputIter __end, ios_base& __str,
                 ios_base::iostate& __err, unsigned int& __val) const
  { return do_get(__ii, __end, __str, __err, __val); }
  _InputIter get(_InputIter __ii, _InputIter __end, ios_base& __str,
                 ios_base::iostate& __err, unsigned long& __val) const
  { return do_get(__ii, __end, __str, __err, __val); }
  _InputIter get(_InputIter __ii, _InputIter __end, ios_base& __str,
                 ios_base::iostate& __err, long long& __val) const
  { return do_get(__ii, __end, __str, __err, __val); }
  _InputIter get(_InputIter __ii, _InputIter __end, ios_base& __str,
                 ios_base::iostate& __err, unsigned long long& __val) const
  { return do_get(__ii, __end, __str, __err, __val); }
  _InputIter get(_InputIter __ii, _InputIter __end, ios_base& __str,
                 ios_base::iostate& __err, float& __val) const
  { return do_get(__ii, __end, __str, __err, __val); }
  _InputIter get(_InputIter __ii, _InputIter __end, ios_base& __str,
                 ios_base::iostate& __err, double& __val) const
  { return do_get(__ii, __end, __str, __err, __val); }
  _InputIter get(_InputIter __ii, _InputIter __end, ios_base& __str,
                 ios_base::iostate& __err, long double& __val) const
  { return do_get(__ii, __end, __str, __err, __val); }
  _InputIter get(_InputIter __ii, _InputIter __end, ios_base& __str,
                 ios_base::iostate& __err, void*& __val) const
  { return do_get(__ii, __end, __str, __err, __val); }
  static locale::id id;
protected:
  ~num_get() {}
  typedef string string_type;
  typedef ctype<_CharT> _Ctype;
  typedef numpunct<_CharT> _Numpunct;
  virtual _InputIter do_get(_InputIter __ii, _InputIter __end, ios_base& __str,
                            ios_base::iostate& __err, bool& __val) const;
  virtual _InputIter do_get(_InputIter __ii, _InputIter __end, ios_base& __str,
                            ios_base::iostate& __err, long& __val) const;
  virtual _InputIter do_get(_InputIter __ii, _InputIter __end, ios_base& __str,
                            ios_base::iostate& __err, unsigned short& __val) const;
  virtual _InputIter do_get(_InputIter __ii, _InputIter __end, ios_base& __str,
                            ios_base::iostate& __err, unsigned int& __val) const;
  virtual _InputIter do_get(_InputIter __ii, _InputIter __end, ios_base& __str,
                            ios_base::iostate& __err, unsigned long& __val) const;
  virtual _InputIter do_get(_InputIter __ii, _InputIter __end, ios_base& __str,
                            ios_base::iostate& __err, float& __val) const;
  virtual _InputIter do_get(_InputIter __ii, _InputIter __end, ios_base& __str,
                            ios_base::iostate& __err, double& __val) const;
  virtual _InputIter do_get(_InputIter __ii, _InputIter __end, ios_base& __str,
                            ios_base::iostate& __err, void*& __p) const;
  virtual _InputIter do_get(_InputIter __ii, _InputIter __end, ios_base& __str,
                            ios_base::iostate& __err, long double& __val) const;
  virtual _InputIter do_get(_InputIter __ii, _InputIter __end, ios_base& __str,
                            ios_base::iostate& __err, long long& __val) const;
  virtual _InputIter do_get(_InputIter __ii, _InputIter __end, ios_base& __str,
                            ios_base::iostate& __err, unsigned long long& __val) const;
};
namespace priv {
__attribute__((visibility("default"))) bool __valid_grouping(const char*, const char*, const char*, const char*);
template <class _InputIter, class _Integer, class _CharT>
bool
__get_decimal_integer(_InputIter& __first, _InputIter& __last, _Integer& __val, _CharT*);
bool __attribute__((visibility("default"))) __get_fdigit(wchar_t&, const wchar_t*);
bool __attribute__((visibility("default"))) __get_fdigit_or_sep(wchar_t&, wchar_t, const wchar_t*);
inline void
_Initialize_get_float(const ctype<char>&,
                       char& Plus, char& Minus,
                       char& pow_e, char& pow_E,
                       char*) {
  Plus = '+';
  Minus = '-';
  pow_e = 'e';
  pow_E = 'E';
}
void __attribute__((visibility("default"))) _Initialize_get_float(const ctype<wchar_t>&,
                                                     wchar_t&, wchar_t&, wchar_t&, wchar_t&, wchar_t*);
void __attribute__((visibility("default"))) __string_to_float(const __iostring&, float&);
void __attribute__((visibility("default"))) __string_to_float(const __iostring&, double&);
void __attribute__((visibility("default"))) __string_to_float(const __iostring&, long double&);
}
}
namespace stlp_std {
namespace priv {
__attribute__((visibility("default"))) unsigned char __digit_val_table(unsigned);
__attribute__((visibility("default"))) const char* __narrow_atoms();
inline bool __get_fdigit(char __c, const char*)
{ return __c >= '0' && __c <= '9'; }
inline bool __get_fdigit_or_sep(char& __c, char __sep, const char *__digits) {
  if (__c == __sep) {
    __c = ',' ;
    return true ;
  }
  else
    return __get_fdigit(__c, __digits);
}
inline int
__get_digit_from_table(unsigned __index)
{ return (__index > 127 ? 0xFF : __digit_val_table(__index)); }
template <class _InputIter, class _CharT>
int
__get_base_or_zero(_InputIter& __in_ite, _InputIter& __end,
                   ios_base::fmtflags __flags, const ctype<_CharT>& __c_type) {
  _CharT __atoms[5];
  __c_type.widen(__narrow_atoms(), __narrow_atoms() + 5, __atoms);
  bool __negative = false;
  _CharT __c = *__in_ite;
  if (__c == __atoms[1] ) {
    __negative = true;
    ++__in_ite;
  }
  else if (__c == __atoms[0] )
    ++__in_ite;
  int __base;
  int __valid_zero = 0;
  ios_base::fmtflags __basefield = __flags & ios_base::basefield;
  switch (__basefield) {
  case ios_base::oct:
    __base = 8;
    break;
  case ios_base::dec:
    __base = 10;
    break;
  case ios_base::hex:
    __base = 16;
    if (__in_ite != __end && *__in_ite == __atoms[2] ) {
      ++__in_ite;
      if (__in_ite != __end &&
          (*__in_ite == __atoms[3] || *__in_ite == __atoms[4] ))
        ++__in_ite;
      else
        __valid_zero = 1;
    }
    break;
  default:
    if (__in_ite != __end && *__in_ite == __atoms[2] ) {
      ++__in_ite;
      if (__in_ite != __end &&
          (*__in_ite == __atoms[3] || *__in_ite == __atoms[4] )) {
        ++__in_ite;
        __base = 16;
      }
      else
        {
          __base = 8;
          __valid_zero = 1;
        }
    }
    else
      __base = 10;
    break;
  }
  return (__base << 2) | ((int)__negative << 1) | __valid_zero;
}
template <class _InputIter, class _Integer, class _CharT>
bool
__get_integer(_InputIter& __first, _InputIter& __last,
              int __base, _Integer& __val,
              int __got, bool __is_negative, _CharT __separator, const string& __grouping, const __true_type& ) {
  bool __ovflow = false;
  _Integer __result = 0;
  bool __is_group = !__grouping.empty();
  char __group_sizes[64];
  char __current_group_size = 0;
  char* __group_sizes_end = __group_sizes;
  _Integer __over_base = (numeric_limits<_Integer>::min)() / static_cast<_Integer>(__base);
   for ( ; __first != __last ; ++__first) {
     const _CharT __c = *__first;
     if (__is_group && __c == __separator) {
       *__group_sizes_end++ = __current_group_size;
       __current_group_size = 0;
       continue;
     }
     int __n = __get_digit_from_table(__c);
     if (__n >= __base)
       break;
     ++__got;
     ++__current_group_size;
     if (__result < __over_base)
       __ovflow = true;
     else {
       _Integer __next = static_cast<_Integer>(__base * __result - __n);
       if (__result != 0)
         __ovflow = __ovflow || __next >= __result;
       __result = __next;
     }
   }
   if (__is_group && __group_sizes_end != __group_sizes) {
     *__group_sizes_end++ = __current_group_size;
   }
   if (__got > 0) {
       __val = __ovflow ? __is_negative ? (numeric_limits<_Integer>::min)()
                                        : (numeric_limits<_Integer>::max)()
                        : __is_negative ? __result
                                        : static_cast<_Integer>(-__result);
   }
  return ((__got > 0) && !__ovflow) &&
          (__is_group == 0 ||
           __valid_grouping(__group_sizes, __group_sizes_end,
                            __grouping.data(), __grouping.data()+ __grouping.size()));
}
template <class _InputIter, class _Integer, class _CharT>
bool
__get_integer(_InputIter& __first, _InputIter& __last,
              int __base, _Integer& __val,
              int __got, bool __is_negative, _CharT __separator, const string& __grouping, const __false_type& ) {
  bool __ovflow = false;
  _Integer __result = 0;
  bool __is_group = !__grouping.empty();
  char __group_sizes[64];
  char __current_group_size = 0;
  char* __group_sizes_end = __group_sizes;
  _Integer __over_base = (numeric_limits<_Integer>::max)() / static_cast<_Integer>(__base);
  for ( ; __first != __last ; ++__first) {
    const _CharT __c = *__first;
    if (__is_group && __c == __separator) {
      *__group_sizes_end++ = __current_group_size;
      __current_group_size = 0;
      continue;
    }
    int __n = __get_digit_from_table(__c);
    if (__n >= __base)
      break;
    ++__got;
    ++__current_group_size;
    if (__result > __over_base)
      __ovflow = true;
    else {
      _Integer __next = static_cast<_Integer>(__base * __result + __n);
      if (__result != 0)
        __ovflow = __ovflow || __next <= __result;
        __result = __next;
      }
  }
  if (__is_group && __group_sizes_end != __group_sizes) {
      *__group_sizes_end++ = __current_group_size;
  }
  if (__got > 0) {
      __val = __ovflow ? (numeric_limits<_Integer>::max)()
                       : (__is_negative ? static_cast<_Integer>(-__result)
                                        : __result);
  }
  return ((__got > 0) && !__ovflow) &&
          (__is_group == 0 ||
           __valid_grouping(__group_sizes, __group_sizes_end,
                            __grouping.data(), __grouping.data()+ __grouping.size()));
}
template <class _InputIter, class _Integer, class _CharT>
bool
__get_decimal_integer(_InputIter& __first, _InputIter& __last, _Integer& __val, _CharT* ) {
  string __grp;
  return __get_integer(__first, __last, 10, __val, 0, false, _CharT() , __grp, __false_type());
}
template <class _InputIter, class _Integer, class _CharT>
_InputIter
__do_get_integer(_InputIter& __in_ite, _InputIter& __end, ios_base& __str,
                 ios_base::iostate& __err, _Integer& __val, _CharT* ) {
  locale __loc = __str.getloc();
  const ctype<_CharT>& __ctype = use_facet<ctype<_CharT> >(__loc);
  typedef typename __bool2type<numeric_limits<_Integer>::is_signed>::_Ret _IsSigned;
  const int __base_or_zero = __get_base_or_zero(__in_ite, __end, __str.flags(), __ctype);
  int __got = __base_or_zero & 1;
  bool __result;
  if (__in_ite == __end) {
    if (__got > 0) {
      __val = 0;
      __result = true;
    }
    else
      __result = false;
  }
  else {
    const numpunct<_CharT>& __np = use_facet<numpunct<_CharT> >(__loc);
    const bool __negative = (__base_or_zero & 2) != 0;
    const int __base = __base_or_zero >> 2;
    __result = __get_integer(__in_ite, __end, __base, __val, __got, __negative, __np.thousands_sep(), __np.grouping(), _IsSigned());
  }
  __err = static_cast<ios_base::iostate>(__result ? ios_base::goodbit : ios_base::failbit);
  if (__in_ite == __end)
    __err |= ios_base::eofbit;
  return __in_ite;
}
template <class _InputIter, class _CharT>
_InputIter
__copy_sign(_InputIter __first, _InputIter __last, __iostring& __v,
            _CharT __xplus, _CharT __xminus) {
  if (__first != __last) {
    _CharT __c = *__first;
    if (__c == __xplus)
      ++__first;
    else if (__c == __xminus) {
      __v.push_back('-');
      ++__first;
    }
  }
  return __first;
}
template <class _InputIter, class _CharT>
bool
__copy_digits(_InputIter& __first, _InputIter __last,
              __iostring& __v, const _CharT* __digits) {
  bool __ok = false;
  for ( ; __first != __last; ++__first) {
    _CharT __c = *__first;
    if (__get_fdigit(__c, __digits)) {
      __v.push_back((char)__c);
      __ok = true;
    }
    else
      break;
  }
  return __ok;
}
template <class _InputIter, class _CharT>
bool
__copy_grouped_digits(_InputIter& __first, _InputIter __last,
                      __iostring& __v, const _CharT * __digits,
                      _CharT __sep, const string& __grouping,
                      bool& __grouping_ok) {
  bool __ok = false;
  char __group_sizes[64];
  char*__group_sizes_end = __group_sizes;
  char __current_group_size = 0;
  for ( ; __first != __last; ++__first) {
    _CharT __c = *__first;
    bool __tmp = __get_fdigit_or_sep(__c, __sep, __digits);
    if (__tmp) {
      if (__c == ',') {
        *__group_sizes_end++ = __current_group_size;
        __current_group_size = 0;
      }
      else {
        __ok = true;
        __v.push_back((char)__c);
        ++__current_group_size;
      }
    }
    else
      break;
  }
  if (__group_sizes_end != __group_sizes)
    *__group_sizes_end++ = __current_group_size;
  __grouping_ok = __valid_grouping(__group_sizes, __group_sizes_end, __grouping.data(), __grouping.data() + __grouping.size());
  return __ok;
}
template <class _InputIter, class _CharT>
bool
__read_float(__iostring& __buf, _InputIter& __in_ite, _InputIter& __end,
             const ctype<_CharT> &__ct, const numpunct<_CharT> &__numpunct) {
  string __grouping = __numpunct.grouping();
  bool __digits_before_dot ;
  bool __digits_after_dot = false;
  bool __ok;
  bool __grouping_ok = true;
  _CharT __dot = __numpunct.decimal_point();
  _CharT __sep = __numpunct.thousands_sep();
  _CharT __digits[10];
  _CharT __xplus;
  _CharT __xminus;
  _CharT __pow_e;
  _CharT __pow_E;
  _Initialize_get_float(__ct, __xplus, __xminus, __pow_e, __pow_E, __digits);
  __in_ite = __copy_sign(__in_ite, __end, __buf, __xplus, __xminus);
  if (!__grouping.empty())
    __digits_before_dot = __copy_grouped_digits(__in_ite, __end, __buf, __digits,
                                                __sep, __grouping, __grouping_ok);
  else
    __digits_before_dot = __copy_digits(__in_ite, __end, __buf, __digits);
  if (__in_ite != __end && *__in_ite == __dot) {
    __buf.push_back('.');
    ++__in_ite;
    __digits_after_dot = __copy_digits(__in_ite, __end, __buf, __digits);
  }
  __ok = __digits_before_dot || __digits_after_dot;
  if (__ok && __in_ite != __end && (*__in_ite == __pow_e || *__in_ite == __pow_E)) {
    __buf.push_back('e');
    ++__in_ite;
    __in_ite = __copy_sign(__in_ite, __end, __buf, __xplus, __xminus);
    __ok = __copy_digits(__in_ite, __end, __buf, __digits);
  }
  return __ok;
}
template <class _InputIter, class _Float, class _CharT>
_InputIter
__do_get_float(_InputIter& __in_ite, _InputIter& __end, ios_base& __str,
               ios_base::iostate& __err, _Float& __val, _CharT* ) {
  locale __loc = __str.getloc();
  const ctype<_CharT> &__ctype = use_facet<ctype<_CharT> >(__loc);
  const numpunct<_CharT> &__numpunct = use_facet<numpunct<_CharT> >(__loc);
  __iostring __buf ;
  bool __ok = __read_float(__buf, __in_ite, __end, __ctype, __numpunct);
  if (__ok) {
    __string_to_float(__buf, __val);
    __err = ios_base::goodbit;
  }
  else {
    __err = ios_base::failbit;
  }
  if (__in_ite == __end)
    __err |= ios_base::eofbit;
  return __in_ite;
}
template <class _InputIter, class _CharT>
_InputIter
__do_get_alphabool(_InputIter& __in_ite, _InputIter& __end, ios_base& __str,
                   ios_base::iostate& __err, bool& __x, _CharT* ) {
  const numpunct<_CharT>& __np = use_facet<numpunct<_CharT> >(__str.getloc());
  const basic_string<_CharT, char_traits<_CharT>, allocator<_CharT> > __truename = __np.truename();
  const basic_string<_CharT, char_traits<_CharT>, allocator<_CharT> > __falsename = __np.falsename();
  bool __true_ok = true;
  bool __false_ok = true;
  size_t __n = 0;
  for ( ; __in_ite != __end; ++__in_ite) {
    _CharT __c = *__in_ite;
    __true_ok = __true_ok && (__c == __truename[__n]);
    __false_ok = __false_ok && (__c == __falsename[__n]);
    ++__n;
    if ((!__true_ok && !__false_ok) ||
        (__true_ok && __n >= __truename.size()) ||
        (__false_ok && __n >= __falsename.size())) {
      ++__in_ite;
      break;
    }
  }
  if (__true_ok && __n < __truename.size()) __true_ok = false;
  if (__false_ok && __n < __falsename.size()) __false_ok = false;
  if (__true_ok || __false_ok) {
    __err = ios_base::goodbit;
    __x = __true_ok;
  }
  else
    __err = ios_base::failbit;
  if (__in_ite == __end)
    __err |= ios_base::eofbit;
  return __in_ite;
}
}
template <class _CharT, class _InputIterator>
locale::id num_get<_CharT, _InputIterator>::id;
template <class _CharT, class _InputIter>
_InputIter
num_get<_CharT, _InputIter>::do_get(_InputIter __in_ite, _InputIter __end,
                                    ios_base& __s, ios_base::iostate& __err, bool& __x) const {
  if (__s.flags() & ios_base::boolalpha) {
    return ::stlp_std::priv:: __do_get_alphabool(__in_ite, __end, __s, __err, __x, (_CharT*)0);
  }
  else {
    long __lx;
    _InputIter __tmp = ::stlp_std::priv:: __do_get_integer(__in_ite, __end, __s, __err, __lx, (_CharT*)0 );
    if (!(__err & ios_base::failbit)) {
      if (__lx == 0)
        __x = false;
      else if (__lx == 1)
        __x = true;
      else
        __err |= ios_base::failbit;
    }
    return __tmp;
  }
}
template <class _CharT, class _InputIter>
_InputIter
num_get<_CharT, _InputIter>::do_get(_InputIter __in_ite, _InputIter __end, ios_base& __str,
                                    ios_base::iostate& __err, long& __val) const
{ return ::stlp_std::priv:: __do_get_integer(__in_ite, __end, __str, __err, __val, (_CharT*)0 ); }
template <class _CharT, class _InputIter>
_InputIter
num_get<_CharT, _InputIter>::do_get(_InputIter __in_ite, _InputIter __end, ios_base& __str,
                                    ios_base::iostate& __err,
                                    unsigned short& __val) const
{ return ::stlp_std::priv:: __do_get_integer(__in_ite, __end, __str, __err, __val, (_CharT*)0 ); }
template <class _CharT, class _InputIter>
_InputIter
num_get<_CharT, _InputIter>::do_get(_InputIter __in_ite, _InputIter __end, ios_base& __str,
                                    ios_base::iostate& __err,
                                    unsigned int& __val) const
{ return ::stlp_std::priv:: __do_get_integer(__in_ite, __end, __str, __err, __val, (_CharT*)0 ); }
template <class _CharT, class _InputIter>
_InputIter
num_get<_CharT, _InputIter>::do_get(_InputIter __in_ite, _InputIter __end, ios_base& __str,
                                    ios_base::iostate& __err,
                                    unsigned long& __val) const
{ return ::stlp_std::priv:: __do_get_integer(__in_ite, __end, __str, __err, __val, (_CharT*)0 ); }
template <class _CharT, class _InputIter>
_InputIter
num_get<_CharT, _InputIter>::do_get(_InputIter __in_ite, _InputIter __end, ios_base& __str,
                                    ios_base::iostate& __err,
                                    float& __val) const
{ return ::stlp_std::priv:: __do_get_float(__in_ite, __end, __str, __err, __val, (_CharT*)0 ); }
template <class _CharT, class _InputIter>
_InputIter
num_get<_CharT, _InputIter>::do_get(_InputIter __in_ite, _InputIter __end, ios_base& __str,
                                    ios_base::iostate& __err,
                                    double& __val) const
{ return ::stlp_std::priv:: __do_get_float(__in_ite, __end, __str, __err, __val, (_CharT*)0 ); }
template <class _CharT, class _InputIter>
_InputIter
num_get<_CharT, _InputIter>::do_get(_InputIter __in_ite, _InputIter __end, ios_base& __str,
                                    ios_base::iostate& __err,
                                    long double& __val) const
{ return ::stlp_std::priv:: __do_get_float(__in_ite, __end, __str, __err, __val, (_CharT*)0 ); }
template <class _CharT, class _InputIter>
_InputIter
num_get<_CharT, _InputIter>::do_get(_InputIter __in_ite, _InputIter __end, ios_base& __str,
                                    ios_base::iostate& __err,
                                    void*& __p) const {
  unsigned long long __val;
  iter_type __tmp = ::stlp_std::priv:: __do_get_integer(__in_ite, __end, __str, __err, __val, (_CharT*)0 );
  if (!(__err & ios_base::failbit))
    __p = reinterpret_cast<void*>(__val);
  return __tmp;
}
template <class _CharT, class _InputIter>
_InputIter
num_get<_CharT, _InputIter>::do_get(_InputIter __in_ite, _InputIter __end, ios_base& __str,
                                    ios_base::iostate& __err,
                                    long long& __val) const
{ return ::stlp_std::priv:: __do_get_integer(__in_ite, __end, __str, __err, __val, (_CharT*)0 ); }
template <class _CharT, class _InputIter>
_InputIter
num_get<_CharT, _InputIter>::do_get(_InputIter __in_ite, _InputIter __end, ios_base& __str,
                                    ios_base::iostate& __err,
                                    unsigned long long& __val) const
{ return ::stlp_std::priv:: __do_get_integer(__in_ite, __end, __str, __err, __val, (_CharT*)0 ); }
}
namespace stlp_std {
namespace priv {
template <class _Traits>
struct _Is_not_wspace {
  typedef typename _Traits::char_type argument_type;
  typedef bool result_type;
  const ctype<argument_type>* _M_ctype;
  _Is_not_wspace(const ctype<argument_type>* __c_type) : _M_ctype(__c_type) {}
  bool operator()(argument_type __c) const
    { return !_M_ctype->is(ctype_base::space, __c); }
};
template <class _Traits>
struct _Is_wspace_null {
  typedef typename _Traits::char_type argument_type;
  typedef bool result_type;
  const ctype<argument_type>* _M_ctype;
  _Is_wspace_null(const ctype<argument_type>* __c_type) : _M_ctype(__c_type) {}
  bool operator()(argument_type __c) const {
    return _Traits::eq(__c, argument_type()) ||
           _M_ctype->is(ctype_base::space, __c);
  }
};
template <class _Traits>
struct _Scan_for_wspace {
  typedef typename _Traits::char_type char_type;
  typedef char_type* first_argument_type;
  typedef char_type* second_argument_type;
  typedef char_type* result_type;
  const ctype<char_type>* _M_ctype;
  _Scan_for_wspace(const ctype<char_type>* __ctype) : _M_ctype(__ctype) {}
  const char_type*
  operator()(const char_type* __first, const char_type* __last) const {
    return _M_ctype->scan_is(ctype_base::space, __first, __last);
  }
};
template <class _Traits>
struct _Scan_wspace_null {
  typedef typename _Traits::char_type char_type;
  typedef char_type* first_argument_type;
  typedef char_type* second_argument_type;
  typedef char_type* result_type;
  const ctype<char_type>* _M_ctype;
  _Scan_wspace_null(const ctype<char_type>* __c_type) : _M_ctype(__c_type) {}
  const char_type*
  operator()(const char_type* __first, const char_type* __last) const {
    __last = find_if(__first, __last,
                     _Eq_char_bound<_Traits>(char_type()));
    return _M_ctype->scan_is(ctype_base::space, __first, __last);
  }
};
template <class _Traits>
struct _Scan_for_not_wspace {
  typedef typename _Traits::char_type char_type;
  typedef char_type* first_argument_type;
  typedef char_type* second_argument_type;
  typedef char_type* result_type;
  const ctype<char_type>* _M_ctype;
  _Scan_for_not_wspace(const ctype<char_type>* __c_type) : _M_ctype(__c_type) {}
  const char_type*
  operator()(const char_type* __first, const char_type* __last) const {
    return _M_ctype->scan_not(ctype_base::space, __first, __last);
  }
};
template <class _Traits>
struct _Scan_for_char_val {
  typedef typename _Traits::char_type char_type;
  typedef char_type* first_argument_type;
  typedef char_type* second_argument_type;
  typedef char_type* result_type;
  char_type _M_val;
  _Scan_for_char_val(char_type __val) : _M_val(__val) {}
  const char_type*
  operator()(const char_type* __first, const char_type* __last) const {
    return find_if(__first, __last, _Eq_char_bound<_Traits>(_M_val));
  }
};
template <class _Traits>
struct _Scan_for_int_val {
  typedef typename _Traits::char_type char_type;
  typedef typename _Traits::int_type int_type;
  typedef char_type* first_argument_type;
  typedef char_type* second_argument_type;
  typedef char_type* result_type;
  int_type _M_val;
  _Scan_for_int_val(int_type __val) : _M_val(__val) {}
  const char_type*
  operator()(const char_type* __first, const char_type* __last) const {
    return find_if(__first, __last,
                   _Eq_int_bound<_Traits>(_M_val));
  }
};
template <class _CharT, class _Traits>
bool
__pushback(basic_streambuf<_CharT, _Traits>* __buf, _CharT __c) {
  bool ret;
  try {
    const typename _Traits::int_type __eof = _Traits::eof();
    ret = !_Traits::eq_int_type(__buf->sputbackc(__c), __eof);
  }
  catch(...) {
    ret = false;
  }
  return ret;
}
template <class _CharT, class _Traits, class _Number>
ios_base::iostate
__get_num(basic_istream<_CharT, _Traits>& __that, _Number& __val) {
  typedef typename basic_istream<_CharT, _Traits>::sentry _Sentry;
  ios_base::iostate __err = 0;
  _Sentry __sentry( __that );
  if (__sentry) {
    typedef num_get<_CharT, istreambuf_iterator<_CharT, _Traits> > _Num_get;
    try {
      (use_facet<_Num_get>(__that.getloc())).get(istreambuf_iterator<_CharT, _Traits>(__that.rdbuf()),
                                               0, __that, __err, __val);
    }
    catch(...) {
      __that._M_handle_exception(ios_base::badbit);
    }
    if (__err) __that.setstate(__err);
  }
  return __err;
}
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (short& __val) {
  long __lval;
  ::stlp_std::priv:: __get_num(*this, __lval);
  if ( this->fail() ) {
    return *this;
  }
  short __tmp = static_cast<short>(__lval);
  unsigned short __uval = static_cast<unsigned short>(__lval);
  if ((__tmp != __lval) && ((long)__uval != __lval))
    this->setstate(ios_base::failbit);
  else
    __val = __tmp;
  return *this;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (int& __val) {
  long __lval;
  ::stlp_std::priv:: __get_num(*this, __lval);
  if ( this->fail() ) {
    return *this;
  }
  int __tmp = __lval;
  unsigned int __uval = __lval;
  if ((__tmp != __lval) && ((long)__uval != __lval))
    this->setstate(ios_base::failbit);
  else
    __val = __tmp;
  return *this;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (unsigned short& __val) {
  ::stlp_std::priv:: __get_num(*this, __val);
  return *this;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (unsigned int& __val) {
  ::stlp_std::priv:: __get_num(*this, __val);
  return *this;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (long& __val) {
  ::stlp_std::priv:: __get_num(*this, __val);
  return *this;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (unsigned long& __val) {
  ::stlp_std::priv:: __get_num(*this, __val);
  return *this;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (long long& __val) {
  ::stlp_std::priv:: __get_num(*this, __val);
  return *this;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (unsigned long long& __val) {
  ::stlp_std::priv:: __get_num(*this, __val);
  return *this;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (float& __val) {
  ::stlp_std::priv:: __get_num(*this, __val);
  return *this;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (double& __val) {
  ::stlp_std::priv:: __get_num(*this, __val);
  return *this;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (long double& __val) {
  ::stlp_std::priv:: __get_num(*this, __val);
  return *this;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (bool& __val) {
  ::stlp_std::priv:: __get_num(*this, __val);
  return *this;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::operator>> (void*& __val) {
  ::stlp_std::priv:: __get_num(*this, __val);
  return *this;
}
template <class _CharT, class _Traits>
typename basic_istream<_CharT, _Traits>::int_type
basic_istream<_CharT, _Traits>::peek() {
  typename _Traits::int_type __tmp = _Traits::eof();
  this->_M_gcount = 0;
  sentry __sentry(*this, _No_Skip_WS());
  if (__sentry) {
    try {
      __tmp = this->rdbuf()->sgetc();
    }
    catch(...) {
      this->_M_handle_exception(ios_base::badbit);
    }
    if (this->_S_eof(__tmp))
      this->setstate(ios_base::eofbit);
  }
  return __tmp;
}
template <class _CharT, class _Traits>
typename basic_istream<_CharT, _Traits>::int_type
basic_istream<_CharT, _Traits>::get() {
  typename _Traits::int_type __tmp = _Traits::eof();
  sentry __sentry(*this, _No_Skip_WS());
  this->_M_gcount = 0;
  if (__sentry) {
    try {
      __tmp = this->rdbuf()->sbumpc();
    }
    catch(...) {
      this->_M_handle_exception(ios_base::badbit);
    }
    if (!this->_S_eof(__tmp))
      this->_M_gcount = 1;
  }
  if (_M_gcount == 0)
    this->setstate(ios_base::eofbit | ios_base::failbit);
  return __tmp;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>&
basic_istream<_CharT, _Traits>::get(_CharT& __c) {
  sentry __sentry(*this, _No_Skip_WS());
  this->_M_gcount = 0;
  if (__sentry) {
    typename _Traits::int_type __tmp = _Traits::eof();
    try {
      __tmp = this->rdbuf()->sbumpc();
    }
    catch(...) {
      this->_M_handle_exception(ios_base::badbit);
    }
    if (!this->_S_eof(__tmp)) {
      this->_M_gcount = 1;
      __c = _Traits::to_char_type(__tmp);
    }
  }
  if (this->_M_gcount == 0)
    this->setstate(ios_base::eofbit | ios_base::failbit);
  return *this;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::ignore() {
  sentry __sentry(*this, _No_Skip_WS());
  this->_M_gcount = 0;
  if (__sentry) {
    int_type __c;
    try {
      __c = this->rdbuf()->sbumpc();
    }
    catch(...) {
      this->_M_handle_exception(ios_base::badbit);
      return *this;
    }
    if (!this->_S_eof(__c))
      this->_M_gcount = 1;
    else
      this->setstate(ios_base::eofbit);
  }
  return *this;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>&
basic_istream<_CharT, _Traits>::putback(_CharT __c) {
  this->_M_gcount = 0;
  sentry __sentry(*this, _No_Skip_WS());
  if (__sentry) {
    typename _Traits::int_type __tmp = _Traits::eof();
    basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
    if (__buf) {
      try {
        __tmp = __buf->sputbackc(__c);
      }
      catch(...) {
        this->_M_handle_exception(ios_base::badbit);
      }
    }
    if (this->_S_eof(__tmp))
      this->setstate(ios_base::badbit);
  }
  else
    this->setstate(ios_base::failbit);
  return *this;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>& basic_istream<_CharT, _Traits>::unget() {
  this->_M_gcount = 0;
  sentry __sentry(*this, _No_Skip_WS());
  if (__sentry) {
    basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
    if (__buf) {
      try {
        if (this->_S_eof(__buf->sungetc()))
          this->setstate(ios_base::badbit);
      }
      catch(...) {
        this->_M_handle_exception(ios_base::badbit);
      }
    } else
      this->setstate(ios_base::badbit);
  }
  else
    this->setstate(ios_base::failbit);
  return *this;
}
template <class _CharT, class _Traits>
int basic_istream<_CharT, _Traits>::sync() {
  sentry __sentry(*this, _No_Skip_WS());
  basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
  if (__buf) {
    if (__buf->pubsync() == -1) {
      this->setstate(ios_base::badbit);
      return -1;
    }
    else
      return 0;
  }
  else
    return -1;
}
template <class _CharT, class _Traits>
typename basic_istream<_CharT, _Traits>::pos_type
basic_istream<_CharT, _Traits>::tellg() {
  sentry __sentry(*this, _No_Skip_WS());
  basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
  return (__buf && !this->fail()) ? __buf->pubseekoff(0, ios_base::cur, ios_base::in)
    : pos_type(-1);
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>&
basic_istream<_CharT, _Traits>::seekg(pos_type __pos) {
  sentry __sentry(*this, _No_Skip_WS());
  basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
  if (!this->fail() && __buf) {
    if (__buf->pubseekpos(__pos, ios_base::in) == pos_type(-1)) {
      this->setstate(ios_base::failbit);
    }
  }
  return *this;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>&
basic_istream<_CharT, _Traits>::seekg(off_type __off, ios_base::seekdir __dir) {
  sentry __sentry(*this, _No_Skip_WS());
  basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
  if (!this->fail() && __buf)
    __buf->pubseekoff(__off, __dir, ios_base::in);
  return *this;
}
template <class _CharT, class _Traits>
void basic_istream<_CharT, _Traits>::_M_formatted_get(_CharT& __c) {
  sentry __sentry(*this);
  if (__sentry) {
    typename _Traits::int_type __tmp;
    try {
      __tmp = this->rdbuf()->sbumpc();
    }
    catch(...) {
      this->_M_handle_exception(ios_base::badbit);
      return;
    }
    if (!this->_S_eof(__tmp))
      __c = _Traits::to_char_type(__tmp);
    else
      this->setstate(ios_base::eofbit | ios_base::failbit);
  }
}
namespace priv {
template < class _CharT, class _Traits, class _Is_Delim>
streamsize
__read_unbuffered(basic_istream<_CharT, _Traits>* __that, basic_streambuf<_CharT, _Traits>* __buf,
                  streamsize _Num, _CharT* __s,
                  _Is_Delim __is_delim,
                  bool __extract_delim, bool __append_null,
                  bool __is_getline)
{
  streamsize __n = 0;
  ios_base::iostate __status = 0;
  typedef typename basic_istream<_CharT, _Traits>::int_type int_type;
  try {
    for (;;) {
      if (__n == _Num) {
        if (__is_getline)
          __status |= ios_base::failbit;
        break;
      }
      int_type __c = __buf->sbumpc();
      if (__that->_S_eof(__c)) {
        if (__n < _Num || __is_getline)
          __status |= ios_base::eofbit;
        break;
      } else if (__is_delim(_Traits::to_char_type(__c))) {
        if (__extract_delim) {
          ++__n;
        } else if ( !__pushback(__buf, _Traits::to_char_type(__c)) ) {
          __status |= ios_base::failbit;
        }
        break;
      }
      *__s++ = _Traits::to_char_type(__c);
      ++__n;
    }
  }
  catch(...) {
    __that->_M_handle_exception(ios_base::badbit);
    *__s = _CharT();
    return __n;
  }
  if (__append_null)
    *__s = _CharT();
  if (__status)
    __that->setstate(__status);
  return __n;
}
template < class _CharT, class _Traits, class _Is_Delim, class _Scan_Delim>
streamsize
__read_buffered(basic_istream<_CharT, _Traits>* __that, basic_streambuf<_CharT, _Traits>* __buf,
                 streamsize _Num, _CharT* __s,
                 _Is_Delim __is_delim, _Scan_Delim __scan_delim,
                 bool __extract_delim, bool __append_null,
                 bool __is_getline) {
  streamsize __n = 0;
  ios_base::iostate __status = 0;
  bool __done = false;
  try {
    while (__buf->_M_egptr() != __buf->_M_gptr() && !__done) {
      const _CharT* __first = __buf->_M_gptr();
      const _CharT* __last = __buf->_M_egptr();
      typedef char __static_assert[(sizeof(streamsize) > sizeof(ptrdiff_t)) || ((sizeof(streamsize) == sizeof(ptrdiff_t)) && numeric_limits<ptrdiff_t>::is_signed) ? 1 : -1];
      ptrdiff_t __request = static_cast<ptrdiff_t>((min) (static_cast<streamsize>((numeric_limits<ptrdiff_t>::max)()), _Num - __n));
      const _CharT* __p = __scan_delim(__first, __last);
      ptrdiff_t __chunk = (min) (ptrdiff_t(__p - __first), __request);
      _Traits::copy(__s, __first, __chunk);
      __s += __chunk;
      __n += __chunk;
      __buf->_M_gbump((int)__chunk);
      if (__p != __last && __p - __first <= __request) {
        if (__extract_delim) {
          __n += 1;
          __buf->_M_gbump(1);
        }
        __done = true;
      }
      else if (__n == _Num) {
        if (__is_getline) {
          if (__chunk == __last - __first) {
            if (__that->_S_eof(__buf->sgetc()))
              __status |= ios_base::eofbit;
          }
          else
            __status |= ios_base::failbit;
        }
        __done = true;
      }
      else {
        if (__that->_S_eof(__buf->sgetc())) {
          __status |= ios_base::eofbit;
          __done = true;
        }
      }
    }
  }
  catch(...) {
    __that->_M_handle_exception(ios_base::badbit);
    __done = true;
  }
  if (__done) {
    if (__append_null)
        *__s = _CharT();
    if (__status != 0)
      __that->setstate(__status);
    return __n;
  }
  return __n + __read_unbuffered(__that, __buf, _Num - __n, __s, __is_delim,
                                 __extract_delim,__append_null,__is_getline);
}
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>&
basic_istream<_CharT, _Traits>::get(_CharT* __s, streamsize __n,
                                    _CharT __delim) {
  sentry __sentry(*this, _No_Skip_WS());
  this->_M_gcount = 0;
  if (__sentry) {
    if (__n > 0) {
      basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
      if (__buf->egptr() != __buf->gptr())
        this->_M_gcount =
          ::stlp_std::priv:: __read_buffered(this, __buf, __n - 1, __s,
                                     ::stlp_std::priv:: _Eq_char_bound<_Traits>(__delim),
                                     ::stlp_std::priv:: _Scan_for_char_val<_Traits>(__delim),
                                     false, true, false);
      else
        this->_M_gcount =
          ::stlp_std::priv:: __read_unbuffered(this, __buf, __n - 1, __s,
                                       ::stlp_std::priv:: _Eq_char_bound<_Traits>(__delim),
                                       false, true, false);
    }
  }
  if (this->_M_gcount == 0)
    this->setstate(ios_base::failbit);
  return *this;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>&
basic_istream<_CharT, _Traits>::getline(_CharT* __s, streamsize __n,
                                        _CharT __delim) {
  sentry __sentry(*this, _No_Skip_WS());
  this->_M_gcount = 0;
  if (__sentry) {
    if (__n > 0) {
      basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
      this->_M_gcount = __buf->egptr() != __buf->gptr()
        ? ::stlp_std::priv:: __read_buffered(this, __buf, __n - 1, __s,
                                     ::stlp_std::priv:: _Eq_char_bound<_Traits>(__delim),
                                     ::stlp_std::priv:: _Scan_for_char_val<_Traits>(__delim),
                                     true, true, true)
        : ::stlp_std::priv:: __read_unbuffered(this, __buf, __n - 1, __s,
                                       ::stlp_std::priv:: _Eq_char_bound<_Traits>(__delim),
                                       true, true, true);
    }
  }
  if (this->_M_gcount == 0)
    this->setstate(ios_base::failbit);
  return *this;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>&
basic_istream<_CharT, _Traits>::read(char_type* __s, streamsize __n) {
  sentry __sentry(*this, _No_Skip_WS());
  this->_M_gcount = 0;
  if (__sentry && !this->eof()) {
    basic_streambuf<_CharT, _Traits>*__buf = this->rdbuf();
    if (__buf->gptr() != __buf->egptr())
      _M_gcount
        = ::stlp_std::priv:: __read_buffered(this, __buf, __n, __s,
                                     ::stlp_std::priv:: _Constant_unary_fun<bool, int_type>(false),
                                     ::stlp_std::priv:: _Project2nd<const _CharT*, const _CharT*>(),
                                     false, false, false);
    else
      _M_gcount
        = ::stlp_std::priv:: __read_unbuffered(this, __buf, __n, __s,
                                       ::stlp_std::priv:: _Constant_unary_fun<bool, int_type>(false),
                                       false, false, false);
  }
  else
    this->setstate(ios_base::failbit);
  if (this->eof())
    this->setstate(ios_base::eofbit | ios_base::failbit);
  return *this;
}
template <class _CharT, class _Traits>
streamsize
basic_istream<_CharT, _Traits>::readsome(char_type* __s, streamsize __nmax) {
  sentry __sentry(*this, _No_Skip_WS());
  this->_M_gcount = 0;
  if (__sentry && !this->eof() && __nmax >= 0) {
    basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
    streamsize __avail = __buf->in_avail();
    if (__avail == -1)
      this->_M_setstate_nothrow(ios_base::eofbit);
    else if (__avail != 0) {
      if (__buf->gptr() != __buf->egptr())
        _M_gcount
          = ::stlp_std::priv:: __read_buffered(this, __buf, (min) (__avail, __nmax), __s,
                                       ::stlp_std::priv:: _Constant_unary_fun<bool, int_type>(false),
                                       ::stlp_std::priv:: _Project2nd<const _CharT*, const _CharT*>(),
                                       false, false, false);
      else
        _M_gcount
          = ::stlp_std::priv:: __read_unbuffered(this, __buf, (min) (__avail, __nmax), __s,
                                         ::stlp_std::priv:: _Constant_unary_fun<bool, int_type>(false),
                                         false, false, false);
    }
  }
  else {
    if (this->eof())
      this->setstate(ios_base::eofbit | ios_base::failbit);
    else
      this->setstate(ios_base::failbit);
  }
  return _M_gcount;
}
template <class _CharT, class _Traits>
void basic_istream<_CharT, _Traits>::_M_formatted_get(_CharT* __s) {
  sentry __sentry(*this);
  if (__sentry) {
    basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
    streamsize __nmax = this->width() > 0
      ? this->width() - 1
      : ((numeric_limits<streamsize>::max)() / sizeof(_CharT)) - 1;
    streamsize __n = __buf->gptr() != __buf->egptr()
      ? ::stlp_std::priv:: __read_buffered(this, __buf, __nmax, __s,
                                   ::stlp_std::priv:: _Is_wspace_null<_Traits>(this->_M_ctype_facet()),
                                   ::stlp_std::priv:: _Scan_wspace_null<_Traits>(this->_M_ctype_facet()),
                                   false, true, false)
      : ::stlp_std::priv:: __read_unbuffered(this, __buf, __nmax, __s,
                                     ::stlp_std::priv:: _Is_wspace_null<_Traits>(this->_M_ctype_facet()),
                                     false, true, false);
    if (__n == 0)
      this->setstate(ios_base::failbit);
  }
  this->width(0);
}
template < class _CharT, class _Traits, class _Is_Delim>
void
_M_ignore_unbuffered(basic_istream<_CharT, _Traits>* __that,
                     basic_streambuf<_CharT, _Traits>* __buf,
                     _Is_Delim __is_delim,
                     bool __extract_delim, bool __set_failbit) {
  bool __done = false;
  ios_base::iostate __status = 0;
  typedef typename basic_istream<_CharT, _Traits>::int_type int_type;
  try {
    while (!__done) {
      int_type __c = __buf->sbumpc();
      if (__that->_S_eof(__c)) {
        __done = true;
        __status |= __set_failbit ? ios_base::eofbit | ios_base::failbit
                                  : ios_base::eofbit;
      }
      else if (__is_delim(_Traits::to_char_type(__c))) {
        __done = true;
        if (!__extract_delim)
          if (__that->_S_eof(__buf->sputbackc(_Traits::to_char_type(__c))))
            __status |= ios_base::failbit;
      }
    }
  }
  catch(...) {
    __that->_M_handle_exception(ios_base::badbit);
  }
  __that->setstate(__status);
}
template < class _CharT, class _Traits, class _Is_Delim, class _Scan_Delim>
void
_M_ignore_buffered(basic_istream<_CharT, _Traits>* __that,
                   basic_streambuf<_CharT, _Traits>* __buf,
                   _Is_Delim __is_delim, _Scan_Delim __scan_delim,
                   bool __extract_delim, bool __set_failbit) {
  bool __at_eof = false;
  bool __found_delim = false;
  try {
    while (__buf->_M_egptr() != __buf->_M_gptr() && !__at_eof && !__found_delim) {
      const _CharT* __p = __scan_delim(__buf->_M_gptr(), __buf->_M_egptr());
      __buf->_M_gbump((int)(__p - __buf->_M_gptr()));
      if (__p != __buf->_M_egptr()) {
        if (__extract_delim)
          __buf->_M_gbump(1);
        __found_delim = true;
      }
      else
        __at_eof = __that->_S_eof(__buf->sgetc());
    }
  }
  catch(...) {
    __that->_M_handle_exception(ios_base::badbit);
    return;
  }
  if (__at_eof) {
    __that->setstate(__set_failbit ? ios_base::eofbit | ios_base::failbit
                                   : ios_base::eofbit);
    return;
  }
  if (__found_delim)
    return;
  _M_ignore_unbuffered(__that, __buf, __is_delim, __extract_delim, __set_failbit);
}
template < class _CharT, class _Traits, class _Max_Chars, class _Is_Delim>
streamsize
_M_ignore_unbuffered(basic_istream<_CharT, _Traits>* __that,
                     basic_streambuf<_CharT, _Traits>* __buf,
                     streamsize _Num, _Max_Chars __max_chars,
                     _Is_Delim __is_delim,
                     bool __extract_delim, bool __set_failbit) {
  streamsize __n = 0;
  ios_base::iostate __status = 0;
  typedef typename basic_istream<_CharT, _Traits>::int_type int_type;
  try {
    while (__max_chars(_Num, __n) > 0) {
      int_type __c = __buf->sbumpc();
      if (__that->_S_eof(__c)) {
        __status |= __set_failbit ? ios_base::eofbit | ios_base::failbit
                                  : ios_base::eofbit;
        break;
      }
      else if (__is_delim(_Traits::to_char_type(__c))) {
        if (__extract_delim)
          ++__n;
        else if (__that->_S_eof(__buf->sputbackc(_Traits::to_char_type(__c))))
          __status |= ios_base::failbit;
        break;
      }
      ++__n;
    }
  }
  catch(...) {
    __that->_M_handle_exception(ios_base::badbit);
  }
  if (__status)
    __that->setstate(__status);
  return __n;
}
template < class _CharT, class _Traits, class _Max_Chars, class _Is_Delim, class _Scan_Delim>
streamsize
_M_ignore_buffered(basic_istream<_CharT, _Traits>* __that,
                   basic_streambuf<_CharT, _Traits>* __buf,
                   streamsize _Num,
                   _Max_Chars __max_chars,
                   _Is_Delim __is_delim, _Scan_Delim __scan_delim,
                   bool __extract_delim, bool __set_failbit) {
  streamsize __n = 0;
  bool __at_eof = false;
  bool __done = false;
  try {
    while (__buf->_M_egptr() != __buf->_M_gptr() && !__done) {
      ptrdiff_t __avail = __buf->_M_egptr() - __buf->_M_gptr();
      streamsize __m = __max_chars(_Num, __n);
      if (__avail >= __m) {
        const _CharT* __last = __buf->_M_gptr() + static_cast<ptrdiff_t>(__m);
        const _CharT* __p = __scan_delim(__buf->_M_gptr(), __last);
        ptrdiff_t __chunk = __p - __buf->_M_gptr();
        __n += __chunk;
        __buf->_M_gbump((int)__chunk);
        if (__extract_delim && __p != __last) {
          __n += 1;
          __buf->_M_gbump(1);
        }
        __done = true;
      }
      else {
        const _CharT* __p = __scan_delim(__buf->_M_gptr(), __buf->_M_egptr());
        ptrdiff_t __chunk = __p - __buf->_M_gptr();
        __n += __chunk;
        __buf->_M_gbump((int)__chunk);
        if (__p != __buf->_M_egptr()) {
          if (__extract_delim) {
            __n += 1;
            __buf->_M_gbump(1);
          }
          __done = true;
        }
        else if (__that->_S_eof(__buf->sgetc())) {
          __done = true;
          __at_eof = true;
        }
      }
    }
  }
  catch(...) {
    __that->_M_handle_exception(ios_base::badbit);
    return __n;
  }
  if (__at_eof)
    __that->setstate(__set_failbit ? ios_base::eofbit | ios_base::failbit
                                   : ios_base::eofbit);
  if (__done)
    return __n;
  return __n + _M_ignore_unbuffered(__that, __buf, _Num, __max_chars,
                                    __is_delim, __extract_delim, __set_failbit);
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>&
basic_istream<_CharT, _Traits>::ignore(streamsize __n) {
  sentry __sentry(*this, _No_Skip_WS());
  this->_M_gcount = 0;
  if (__sentry) {
    basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
    typedef ::stlp_std::priv:: _Constant_unary_fun<bool, int_type> _Const_bool;
    typedef ::stlp_std::priv:: _Constant_binary_fun<streamsize, streamsize, streamsize> _Const_streamsize;
    const streamsize __maxss = (numeric_limits<streamsize>::max)();
    if (__n == (numeric_limits<int>::max)()) {
      if (__buf->gptr() != __buf->egptr())
        _M_gcount = _M_ignore_buffered(this, __buf,
                                       __maxss, _Const_streamsize(__maxss),
                                       _Const_bool(false),
                                       ::stlp_std::priv:: _Project2nd<const _CharT*, const _CharT*>(),
                                       false, false);
      else
        _M_gcount = _M_ignore_unbuffered(this, __buf,
                                         __maxss, _Const_streamsize(__maxss),
                                         _Const_bool(false), false, false);
    }
    else {
      if (__buf->gptr() != __buf->egptr())
        _M_gcount = _M_ignore_buffered(this, __buf,
                                       __n, minus<streamsize>(),
                                       _Const_bool(false),
                                       ::stlp_std::priv:: _Project2nd<const _CharT*, const _CharT*>(),
                                       false, false);
      else
        _M_gcount = _M_ignore_unbuffered(this, __buf, __n, minus<streamsize>(),
                                         _Const_bool(false), false, false);
    }
  }
  return *this;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>&
basic_istream<_CharT, _Traits>::ignore(streamsize __n, int_type __delim) {
  sentry __sentry(*this, _No_Skip_WS());
  this->_M_gcount = 0;
  if (__sentry) {
    basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
    typedef ::stlp_std::priv:: _Constant_unary_fun<bool, int_type> _Const_bool;
    typedef ::stlp_std::priv:: _Constant_binary_fun<streamsize, streamsize, streamsize>
      _Const_streamsize;
    const streamsize __maxss = (numeric_limits<streamsize>::max)();
    if (__n == (numeric_limits<int>::max)()) {
      if (__buf->gptr() != __buf->egptr())
        _M_gcount = _M_ignore_buffered(this, __buf,
                                       __maxss, _Const_streamsize(__maxss),
                                       ::stlp_std::priv:: _Eq_int_bound<_Traits>(__delim),
                                       ::stlp_std::priv:: _Scan_for_int_val<_Traits>(__delim),
                                       true, false);
      else
        _M_gcount = _M_ignore_unbuffered(this, __buf,
                                         __maxss, _Const_streamsize(__maxss),
                                         ::stlp_std::priv:: _Eq_int_bound<_Traits>(__delim),
                                         true, false);
    }
    else {
      if (__buf->gptr() != __buf->egptr())
        _M_gcount = _M_ignore_buffered(this, __buf,
                                       __n, minus<streamsize>(),
                                       ::stlp_std::priv:: _Eq_int_bound<_Traits>(__delim),
                                       ::stlp_std::priv:: _Scan_for_int_val<_Traits>(__delim),
                                       true, false);
      else
        _M_gcount = _M_ignore_unbuffered(this, __buf, __n, minus<streamsize>(),
                                         ::stlp_std::priv:: _Eq_int_bound<_Traits>(__delim),
                                         true, false);
    }
  }
  return *this;
}
template <class _CharT, class _Traits>
void basic_istream<_CharT, _Traits>::_M_skip_whitespace(bool __set_failbit) {
  basic_streambuf<_CharT, _Traits>* __buf = this->rdbuf();
  if (!__buf)
    this->setstate(ios_base::badbit);
  else if (__buf->gptr() != __buf->egptr())
    _M_ignore_buffered(this, __buf,
                       ::stlp_std::priv:: _Is_not_wspace<_Traits>(this->_M_ctype_facet()),
                       ::stlp_std::priv:: _Scan_for_not_wspace<_Traits>(this->_M_ctype_facet()),
                       false, __set_failbit);
  else
    _M_ignore_unbuffered(this, __buf,
                         ::stlp_std::priv:: _Is_not_wspace<_Traits>(this->_M_ctype_facet()),
                         false, __set_failbit);
}
namespace priv {
template < class _CharT, class _Traits, class _Is_Delim>
streamsize
__copy_unbuffered(basic_istream<_CharT, _Traits>* __that, basic_streambuf<_CharT, _Traits>* __src,
                  basic_streambuf<_CharT, _Traits>* __dest,
                  _Is_Delim __is_delim,
                  bool __extract_delim, bool __rethrow) {
  streamsize __extracted = 0;
  ios_base::iostate __status = 0;
  typedef typename basic_istream<_CharT, _Traits>::int_type int_type;
  int_type __c;
  try {
    for (;;) {
      __c = __src->sbumpc();
      if (__that->_S_eof(__c)) {
        __status |= ios_base::eofbit;
        break;
      }
      else if (__is_delim(_Traits::to_char_type(__c))) {
        if (!__extract_delim && !__pushback(__src, _Traits::to_char_type(__c)))
          __status |= ios_base::failbit;
        break;
      }
      else {
        bool __failed = false;
        try {
          if (!__that->_S_eof(__dest->sputc(_Traits::to_char_type(__c))))
            ++__extracted;
          else
            __failed = true;
        }
        catch(...) {
          __failed = true;
        }
        if (__failed && !__pushback(__src, _Traits::to_char_type(__c)))
          __status |= ios_base::failbit;
        if (__failed)
          break;
      }
    }
  }
  catch(...) {
    if (__rethrow && __extracted == 0)
      __that->_M_handle_exception(ios_base::failbit);
  }
  __that->setstate(__status);
  return __extracted;
}
template < class _CharT, class _Traits, class _Is_Delim, class _Scan_Delim>
streamsize
__copy_buffered(basic_istream<_CharT, _Traits>* __that, basic_streambuf<_CharT, _Traits>* __src,
                basic_streambuf<_CharT, _Traits>* __dest,
                _Scan_Delim __scan_delim, _Is_Delim __is_delim,
                bool __extract_delim, bool __rethrow) {
  streamsize __extracted = 0;
  ios_base::iostate __status = 0;
  typedef typename basic_istream<_CharT, _Traits>::int_type int_type;
  int_type __c ;
  _CharT* __first = __src->_M_gptr();
  ptrdiff_t __avail = __src->_M_egptr() - __first;
  bool __do_handle_exceptions = false;
  try {
    for (;;) {
      const _CharT* __last = __scan_delim(__first, __src->_M_egptr());
      streamsize __n = __dest->sputn(__first, __extract_delim && __last != __src->_M_egptr()
                                     ? (__last - __first) + 1
                                     : (__last - __first));
      __src->_M_gbump((int)__n);
      __extracted += __n;
      __do_handle_exceptions = true;
      if (__n < __avail)
        break;
      __c = __src->sgetc();
      __first = __src->_M_gptr();
      __avail = __src->_M_egptr() - __first;
      if (__avail > 0)
        {}
      else if (__that->_S_eof(__c)) {
        __status |= ios_base::eofbit;
        break;
      }
      else {
        return __extracted + __copy_unbuffered(__that, __src, __dest, __is_delim,
                                                __extract_delim, __rethrow);
      }
      __do_handle_exceptions = false;
    }
  }
  catch(...) {
    if (__rethrow && __do_handle_exceptions && __extracted == 0)
      __that->_M_handle_exception(ios_base::failbit);
  }
  if (__status)
    __that->setstate(__status);
  return __extracted;
}
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>&
basic_istream<_CharT, _Traits>
  ::get(basic_streambuf<_CharT, _Traits>& __dest, _CharT __delim) {
  sentry __sentry(*this, _No_Skip_WS());
  this->_M_gcount = 0;
  if (__sentry) {
    basic_streambuf<_CharT, _Traits>* __src = this->rdbuf();
    if (__src)
      this->_M_gcount = __src->egptr() != __src->gptr()
        ? ::stlp_std::priv:: __copy_buffered(this, __src, &__dest,
                                     ::stlp_std::priv:: _Scan_for_char_val<_Traits>(__delim),
                                     ::stlp_std::priv:: _Eq_char_bound<_Traits>(__delim),
                                     false, false)
        : ::stlp_std::priv:: __copy_unbuffered(this, __src, &__dest,
                                       ::stlp_std::priv:: _Eq_char_bound<_Traits>(__delim),
                                       false, false);
  }
  if (this->_M_gcount == 0)
    this->setstate(ios_base::failbit);
  return *this;
}
template <class _CharT, class _Traits>
basic_istream<_CharT, _Traits>&
basic_istream<_CharT, _Traits>
  ::operator>>(basic_streambuf<_CharT, _Traits>* __dest) {
  streamsize __n = 0;
  typedef typename basic_istream<_CharT, _Traits>::sentry _Sentry;
  _Sentry __sentry(*this);
  if (__sentry) {
    basic_streambuf<_CharT, _Traits>* __src = this->rdbuf();
    if (__src && __dest)
      __n = __src->egptr() != __src->gptr()
        ? ::stlp_std::priv:: __copy_buffered(this, __src, __dest,
                                     ::stlp_std::priv:: _Project2nd<const _CharT*, const _CharT*>(),
                                     ::stlp_std::priv:: _Constant_unary_fun<bool, int_type>(false),
                                     false, true)
        : ::stlp_std::priv:: __copy_unbuffered(this, __src, __dest,
                                       ::stlp_std::priv:: _Constant_unary_fun<bool, int_type>(false),
                                       false, true);
  }
  if (__n == 0)
    this->setstate(ios_base::failbit);
  return *this;
}
template <class _CharT, class _Traits>
basic_iostream<_CharT, _Traits>
  ::basic_iostream(basic_streambuf<_CharT, _Traits>* __buf)
    : basic_ios<_CharT, _Traits>(),
      basic_istream<_CharT, _Traits>(__buf),
      basic_ostream<_CharT, _Traits>(__buf) {
  this->init(__buf);
}
template <class _CharT, class _Traits>
basic_iostream<_CharT, _Traits>::~basic_iostream()
{}
}
namespace stlp_std {
template <class _CharT, class _Traits, class _Alloc>
basic_ostream<_CharT, _Traits>&
operator<<(basic_ostream<_CharT, _Traits>& __os,
           const basic_string<_CharT,_Traits,_Alloc>& __s);
template <class _CharT, class _Traits, class _Alloc>
basic_istream<_CharT, _Traits>&
operator>>(basic_istream<_CharT, _Traits>& __is,
           basic_string<_CharT,_Traits,_Alloc>& __s);
template <class _CharT, class _Traits, class _Alloc>
basic_istream<_CharT, _Traits>&
getline(basic_istream<_CharT, _Traits>& __is,
        basic_string<_CharT,_Traits,_Alloc>& __s,
        _CharT __delim);
template <class _CharT, class _Traits, class _Alloc>
inline basic_istream<_CharT, _Traits>&
getline(basic_istream<_CharT, _Traits>& __is,
        basic_string<_CharT,_Traits,_Alloc>& __s) {
  return getline(__is, __s, __is.widen('\n'));
}
}
namespace stlp_std {
template <class _CharT, class _Traits>
bool
__stlp_string_fill(basic_ostream<_CharT, _Traits>& __os,
                   basic_streambuf<_CharT, _Traits>* __buf,
                   streamsize __n) {
  _CharT __f = __os.fill();
  for (streamsize __i = 0; __i < __n; ++__i) {
    if (_Traits::eq_int_type(__buf->sputc(__f), _Traits::eof()))
      return false;
  }
  return true;
}
template <class _CharT, class _Traits, class _Alloc>
basic_ostream<_CharT, _Traits>&
operator << (basic_ostream<_CharT, _Traits>& __os,
             const basic_string<_CharT,_Traits,_Alloc>& __s) {
  typedef basic_ostream<_CharT, _Traits> __ostream;
  typedef typename basic_string<_CharT, _Traits, _Alloc>::size_type size_type;
  typedef char __static_assert[static_cast<size_type>(-1) > 0 ? 1 : -1];
  typename __ostream::sentry __sentry(__os);
  bool __ok = false;
  if (__sentry) {
    __ok = true;
    size_type __n = __s.size();
    const bool __left = (__os.flags() & __ostream::left) != 0;
    const streamsize __w = __os.width(0);
    basic_streambuf<_CharT, _Traits>* __buf = __os.rdbuf();
    const bool __need_pad = (((sizeof(streamsize) > sizeof(size_t)) && (static_cast<streamsize>(__n) < __w)) ||
                             ((sizeof(streamsize) <= sizeof(size_t)) && (__n < static_cast<size_t>(__w))));
    streamsize __pad_len = __need_pad ? __w - __n : 0;
    if (!__left)
      __ok = __stlp_string_fill(__os, __buf, __pad_len);
    __ok = __ok && (__buf->sputn(__s.data(), streamsize(__n)) == streamsize(__n));
    if (__left)
      __ok = __ok && __stlp_string_fill(__os, __buf, __pad_len);
  }
  if (!__ok)
    __os.setstate(__ostream::failbit);
  return __os;
}
template <class _CharT, class _Traits, class _Alloc>
basic_istream<_CharT, _Traits>&
operator >> (basic_istream<_CharT, _Traits>& __is,
             basic_string<_CharT,_Traits, _Alloc>& __s) {
  typedef basic_istream<_CharT, _Traits> __istream;
  typedef typename basic_string<_CharT, _Traits, _Alloc>::size_type size_type;
  typedef char __static_assert[static_cast<size_type>(-1) > 0 ? 1 : -1];
  typename __istream::sentry __sentry(__is);
  if (__sentry) {
    basic_streambuf<_CharT, _Traits>* __buf = __is.rdbuf();
    typedef ctype<_CharT> _C_type;
    const locale& __loc = __is.getloc();
    const _C_type& _Ctype = use_facet<_C_type>(__loc);
    __s.clear();
    streamsize __width = __is.width(0);
    size_type __n;
    if (__width <= 0)
      __n = __s.max_size();
    else if (sizeof(streamsize) > sizeof(size_type) &&
             (__width > static_cast<streamsize>(__s.max_size())))
      __n = 0;
    else {
      __n = static_cast<size_type>(__width);
      __s.reserve(__n);
    }
    while (__n-- > 0) {
      typename _Traits::int_type __c1 = __buf->sbumpc();
      if (_Traits::eq_int_type(__c1, _Traits::eof())) {
        __is.setstate(__istream::eofbit);
        break;
      }
      else {
        _CharT __c = _Traits::to_char_type(__c1);
        if (_Ctype.is(_C_type::space, __c)) {
          if (_Traits::eq_int_type(__buf->sputbackc(__c), _Traits::eof()))
            __is.setstate(__istream::failbit);
          break;
        }
        else
          __s.push_back(__c);
      }
    }
    if (__s.empty())
      __is.setstate(__istream::failbit);
  }
  else
    __is.setstate(__istream::failbit);
  return __is;
}
template <class _CharT, class _Traits, class _Alloc>
basic_istream<_CharT, _Traits>&
getline(basic_istream<_CharT, _Traits>& __is,
        basic_string<_CharT,_Traits,_Alloc>& __s,
        _CharT __delim) {
  typedef basic_istream<_CharT, _Traits> __istream;
  typedef typename basic_string<_CharT, _Traits, _Alloc>::size_type size_type;
  size_type __nread = 0;
  typename basic_istream<_CharT, _Traits>::sentry __sentry(__is, true);
  if (__sentry) {
    basic_streambuf<_CharT, _Traits>* __buf = __is.rdbuf();
    __s.clear();
    while (__nread < __s.max_size()) {
      int __c1 = __buf->sbumpc();
      if (_Traits::eq_int_type(__c1, _Traits::eof())) {
        __is.setstate(__istream::eofbit);
        break;
      }
      else {
        ++__nread;
        _CharT __c = _Traits::to_char_type(__c1);
        if (!_Traits::eq(__c, __delim))
          __s.push_back(__c);
        else
          break;
      }
    }
  }
  if (__nread == 0 || __nread >= __s.max_size())
    __is.setstate(__istream::failbit);
  return __is;
}
}
namespace stlp_std {
class __attribute__((visibility("default"))) logic_error : public __Named_exception {
public:
  logic_error(const string& __s) : __Named_exception(__s) {}
  ~logic_error() throw();
};
class __attribute__((visibility("default"))) runtime_error : public __Named_exception {
public:
  runtime_error(const string& __s) : __Named_exception(__s) {}
  ~runtime_error() throw();
};
class __attribute__((visibility("default"))) domain_error : public logic_error {
public:
  domain_error(const string& __arg) : logic_error(__arg) {}
  ~domain_error() throw();
};
class __attribute__((visibility("default"))) invalid_argument : public logic_error {
public:
  invalid_argument(const string& __arg) : logic_error(__arg) {}
  ~invalid_argument() throw();
};
class __attribute__((visibility("default"))) length_error : public logic_error {
public:
  length_error(const string& __arg) : logic_error(__arg) {}
  ~length_error() throw();
};
class __attribute__((visibility("default"))) out_of_range : public logic_error {
public:
  out_of_range(const string& __arg) : logic_error(__arg) {}
  ~out_of_range() throw();
};
class __attribute__((visibility("default"))) range_error : public runtime_error {
public:
  range_error(const string& __arg) : runtime_error(__arg) {}
  ~range_error() throw();
};
class __attribute__((visibility("default"))) overflow_error : public runtime_error {
public:
  overflow_error(const string& __arg) : runtime_error(__arg) {}
  ~overflow_error() throw();
};
class __attribute__((visibility("default"))) underflow_error : public runtime_error {
public:
  underflow_error(const string& __arg) : runtime_error(__arg) {}
  ~underflow_error() throw();
};
}
       
       
extern "C" {
typedef struct
{
  __off_t __pos;
  __mbstate_t __state;
} _G_fpos_t;
typedef struct
{
  __off64_t __pos;
  __mbstate_t __state;
} _G_fpos64_t;
typedef int _G_int16_t __attribute__ ((__mode__ (__HI__)));
typedef int _G_int32_t __attribute__ ((__mode__ (__SI__)));
typedef unsigned int _G_uint16_t __attribute__ ((__mode__ (__HI__)));
typedef unsigned int _G_uint32_t __attribute__ ((__mode__ (__SI__)));
struct _IO_jump_t; struct _IO_FILE;
typedef void _IO_lock_t;
struct _IO_marker {
  struct _IO_marker *_next;
  struct _IO_FILE *_sbuf;
  int _pos;
};
enum __codecvt_result
{
  __codecvt_ok,
  __codecvt_partial,
  __codecvt_error,
  __codecvt_noconv
};
struct _IO_FILE {
  int _flags;
  char* _IO_read_ptr;
  char* _IO_read_end;
  char* _IO_read_base;
  char* _IO_write_base;
  char* _IO_write_ptr;
  char* _IO_write_end;
  char* _IO_buf_base;
  char* _IO_buf_end;
  char *_IO_save_base;
  char *_IO_backup_base;
  char *_IO_save_end;
  struct _IO_marker *_markers;
  struct _IO_FILE *_chain;
  int _fileno;
  int _flags2;
  __off_t _old_offset;
  unsigned short _cur_column;
  signed char _vtable_offset;
  char _shortbuf[1];
  _IO_lock_t *_lock;
  __off64_t _offset;
  void *__pad1;
  void *__pad2;
  void *__pad3;
  void *__pad4;
  size_t __pad5;
  int _mode;
  char _unused2[15 * sizeof (int) - 4 * sizeof (void *) - sizeof (size_t)];
};
struct _IO_FILE_plus;
extern struct _IO_FILE_plus _IO_2_1_stdin_;
extern struct _IO_FILE_plus _IO_2_1_stdout_;
extern struct _IO_FILE_plus _IO_2_1_stderr_;
typedef __ssize_t __io_read_fn (void *__cookie, char *__buf, size_t __nbytes);
typedef __ssize_t __io_write_fn (void *__cookie, __const char *__buf,
     size_t __n);
typedef int __io_seek_fn (void *__cookie, __off64_t *__pos, int __w);
typedef int __io_close_fn (void *__cookie);
typedef __io_read_fn cookie_read_function_t;
typedef __io_write_fn cookie_write_function_t;
typedef __io_seek_fn cookie_seek_function_t;
typedef __io_close_fn cookie_close_function_t;
typedef struct
{
  __io_read_fn *read;
  __io_write_fn *write;
  __io_seek_fn *seek;
  __io_close_fn *close;
} _IO_cookie_io_functions_t;
typedef _IO_cookie_io_functions_t cookie_io_functions_t;
struct _IO_cookie_file;
extern void _IO_cookie_init (struct _IO_cookie_file *__cfile, int __read_write,
        void *__cookie, _IO_cookie_io_functions_t __fns);
extern "C" {
extern int __underflow (_IO_FILE *);
extern int __uflow (_IO_FILE *);
extern int __overflow (_IO_FILE *, int);
extern int _IO_getc (_IO_FILE *__fp);
extern int _IO_putc (int __c, _IO_FILE *__fp);
extern int _IO_feof (_IO_FILE *__fp) throw ();
extern int _IO_ferror (_IO_FILE *__fp) throw ();
extern int _IO_peekc_locked (_IO_FILE *__fp);
extern void _IO_flockfile (_IO_FILE *) throw ();
extern void _IO_funlockfile (_IO_FILE *) throw ();
extern int _IO_ftrylockfile (_IO_FILE *) throw ();
extern int _IO_vfscanf (_IO_FILE * __restrict, const char * __restrict,
   __gnuc_va_list, int *__restrict);
extern int _IO_vfprintf (_IO_FILE *__restrict, const char *__restrict,
    __gnuc_va_list);
extern __ssize_t _IO_padn (_IO_FILE *, int, __ssize_t);
extern size_t _IO_sgetn (_IO_FILE *, void *, size_t);
extern __off64_t _IO_seekoff (_IO_FILE *, __off64_t, int, int);
extern __off64_t _IO_seekpos (_IO_FILE *, __off64_t, int);
extern void _IO_free_backup_area (_IO_FILE *) throw ();
}
typedef __gnuc_va_list va_list;
typedef _G_fpos_t fpos_t;
typedef _G_fpos64_t fpos64_t;
extern struct _IO_FILE *stdin;
extern struct _IO_FILE *stdout;
extern struct _IO_FILE *stderr;
extern int remove (__const char *__filename) throw ();
extern int rename (__const char *__old, __const char *__new) throw ();
extern int renameat (int __oldfd, __const char *__old, int __newfd,
       __const char *__new) throw ();
extern FILE *tmpfile (void) ;
extern FILE *tmpfile64 (void) ;
extern char *tmpnam (char *__s) throw () ;
extern char *tmpnam_r (char *__s) throw () ;
extern char *tempnam (__const char *__dir, __const char *__pfx)
     throw () __attribute__ ((__malloc__)) ;
extern int fclose (FILE *__stream);
extern int fflush (FILE *__stream);
extern int fflush_unlocked (FILE *__stream);
extern int fcloseall (void);
extern FILE *fopen (__const char *__restrict __filename,
      __const char *__restrict __modes) ;
extern FILE *freopen (__const char *__restrict __filename,
        __const char *__restrict __modes,
        FILE *__restrict __stream) ;
extern FILE *fopen64 (__const char *__restrict __filename,
        __const char *__restrict __modes) ;
extern FILE *freopen64 (__const char *__restrict __filename,
   __const char *__restrict __modes,
   FILE *__restrict __stream) ;
extern FILE *fdopen (int __fd, __const char *__modes) throw () ;
extern FILE *fopencookie (void *__restrict __magic_cookie,
     __const char *__restrict __modes,
     _IO_cookie_io_functions_t __io_funcs) throw () ;
extern FILE *fmemopen (void *__s, size_t __len, __const char *__modes)
  throw () ;
extern FILE *open_memstream (char **__bufloc, size_t *__sizeloc) throw () ;
extern void setbuf (FILE *__restrict __stream, char *__restrict __buf) throw ();
extern int setvbuf (FILE *__restrict __stream, char *__restrict __buf,
      int __modes, size_t __n) throw ();
extern void setbuffer (FILE *__restrict __stream, char *__restrict __buf,
         size_t __size) throw ();
extern void setlinebuf (FILE *__stream) throw ();
extern int fprintf (FILE *__restrict __stream,
      __const char *__restrict __format, ...);
extern int printf (__const char *__restrict __format, ...);
extern int sprintf (char *__restrict __s,
      __const char *__restrict __format, ...) throw ();
extern int vfprintf (FILE *__restrict __s, __const char *__restrict __format,
       __gnuc_va_list __arg);
extern int vprintf (__const char *__restrict __format, __gnuc_va_list __arg);
extern int vsprintf (char *__restrict __s, __const char *__restrict __format,
       __gnuc_va_list __arg) throw ();
extern int snprintf (char *__restrict __s, size_t __maxlen,
       __const char *__restrict __format, ...)
     throw () __attribute__ ((__format__ (__printf__, 3, 4)));
extern int vsnprintf (char *__restrict __s, size_t __maxlen,
        __const char *__restrict __format, __gnuc_va_list __arg)
     throw () __attribute__ ((__format__ (__printf__, 3, 0)));
extern int vasprintf (char **__restrict __ptr, __const char *__restrict __f,
        __gnuc_va_list __arg)
     throw () __attribute__ ((__format__ (__printf__, 2, 0))) ;
extern int __asprintf (char **__restrict __ptr,
         __const char *__restrict __fmt, ...)
     throw () __attribute__ ((__format__ (__printf__, 2, 3))) ;
extern int asprintf (char **__restrict __ptr,
       __const char *__restrict __fmt, ...)
     throw () __attribute__ ((__format__ (__printf__, 2, 3))) ;
extern int vdprintf (int __fd, __const char *__restrict __fmt,
       __gnuc_va_list __arg)
     __attribute__ ((__format__ (__printf__, 2, 0)));
extern int dprintf (int __fd, __const char *__restrict __fmt, ...)
     __attribute__ ((__format__ (__printf__, 2, 3)));
extern int fscanf (FILE *__restrict __stream,
     __const char *__restrict __format, ...) ;
extern int scanf (__const char *__restrict __format, ...) ;
extern int sscanf (__const char *__restrict __s,
     __const char *__restrict __format, ...) throw ();
extern int vfscanf (FILE *__restrict __s, __const char *__restrict __format,
      __gnuc_va_list __arg)
     __attribute__ ((__format__ (__scanf__, 2, 0))) ;
extern int vscanf (__const char *__restrict __format, __gnuc_va_list __arg)
     __attribute__ ((__format__ (__scanf__, 1, 0))) ;
extern int vsscanf (__const char *__restrict __s,
      __const char *__restrict __format, __gnuc_va_list __arg)
     throw () __attribute__ ((__format__ (__scanf__, 2, 0)));
extern int fgetc (FILE *__stream);
extern int getc (FILE *__stream);
extern int getchar (void);
extern int getc_unlocked (FILE *__stream);
extern int getchar_unlocked (void);
extern int fgetc_unlocked (FILE *__stream);
extern int fputc (int __c, FILE *__stream);
extern int putc (int __c, FILE *__stream);
extern int putchar (int __c);
extern int fputc_unlocked (int __c, FILE *__stream);
extern int putc_unlocked (int __c, FILE *__stream);
extern int putchar_unlocked (int __c);
extern int getw (FILE *__stream);
extern int putw (int __w, FILE *__stream);
extern char *fgets (char *__restrict __s, int __n, FILE *__restrict __stream)
     ;
extern char *gets (char *__s) ;
extern char *fgets_unlocked (char *__restrict __s, int __n,
        FILE *__restrict __stream) ;
extern __ssize_t __getdelim (char **__restrict __lineptr,
          size_t *__restrict __n, int __delimiter,
          FILE *__restrict __stream) ;
extern __ssize_t getdelim (char **__restrict __lineptr,
        size_t *__restrict __n, int __delimiter,
        FILE *__restrict __stream) ;
extern __ssize_t getline (char **__restrict __lineptr,
       size_t *__restrict __n,
       FILE *__restrict __stream) ;
extern int fputs (__const char *__restrict __s, FILE *__restrict __stream);
extern int puts (__const char *__s);
extern int ungetc (int __c, FILE *__stream);
extern size_t fread (void *__restrict __ptr, size_t __size,
       size_t __n, FILE *__restrict __stream) ;
extern size_t fwrite (__const void *__restrict __ptr, size_t __size,
        size_t __n, FILE *__restrict __s) ;
extern int fputs_unlocked (__const char *__restrict __s,
      FILE *__restrict __stream);
extern size_t fread_unlocked (void *__restrict __ptr, size_t __size,
         size_t __n, FILE *__restrict __stream) ;
extern size_t fwrite_unlocked (__const void *__restrict __ptr, size_t __size,
          size_t __n, FILE *__restrict __stream) ;
extern int fseek (FILE *__stream, long int __off, int __whence);
extern long int ftell (FILE *__stream) ;
extern void rewind (FILE *__stream);
extern int fseeko (FILE *__stream, __off_t __off, int __whence);
extern __off_t ftello (FILE *__stream) ;
extern int fgetpos (FILE *__restrict __stream, fpos_t *__restrict __pos);
extern int fsetpos (FILE *__stream, __const fpos_t *__pos);
extern int fseeko64 (FILE *__stream, __off64_t __off, int __whence);
extern __off64_t ftello64 (FILE *__stream) ;
extern int fgetpos64 (FILE *__restrict __stream, fpos64_t *__restrict __pos);
extern int fsetpos64 (FILE *__stream, __const fpos64_t *__pos);
extern void clearerr (FILE *__stream) throw ();
extern int feof (FILE *__stream) throw () ;
extern int ferror (FILE *__stream) throw () ;
extern void clearerr_unlocked (FILE *__stream) throw ();
extern int feof_unlocked (FILE *__stream) throw () ;
extern int ferror_unlocked (FILE *__stream) throw () ;
extern void perror (__const char *__s);
extern int sys_nerr;
extern __const char *__const sys_errlist[];
extern int _sys_nerr;
extern __const char *__const _sys_errlist[];
extern int fileno (FILE *__stream) throw () ;
extern int fileno_unlocked (FILE *__stream) throw () ;
extern FILE *popen (__const char *__command, __const char *__modes) ;
extern int pclose (FILE *__stream);
extern char *ctermid (char *__s) throw ();
extern char *cuserid (char *__s);
struct obstack;
extern int obstack_printf (struct obstack *__restrict __obstack,
      __const char *__restrict __format, ...)
     throw () __attribute__ ((__format__ (__printf__, 2, 3)));
extern int obstack_vprintf (struct obstack *__restrict __obstack,
       __const char *__restrict __format,
       __gnuc_va_list __args)
     throw () __attribute__ ((__format__ (__printf__, 2, 0)));
extern void flockfile (FILE *__stream) throw ();
extern int ftrylockfile (FILE *__stream) throw () ;
extern void funlockfile (FILE *__stream) throw ();
extern __inline __attribute__ ((__gnu_inline__)) int
vprintf (__const char *__restrict __fmt, __gnuc_va_list __arg)
{
  return vfprintf (stdout, __fmt, __arg);
}
extern __inline __attribute__ ((__gnu_inline__)) int
getchar (void)
{
  return _IO_getc (stdin);
}
extern __inline __attribute__ ((__gnu_inline__)) int
fgetc_unlocked (FILE *__fp)
{
  return (__builtin_expect (((__fp)->_IO_read_ptr >= (__fp)->_IO_read_end), 0) ? __uflow (__fp) : *(unsigned char *) (__fp)->_IO_read_ptr++);
}
extern __inline __attribute__ ((__gnu_inline__)) int
getc_unlocked (FILE *__fp)
{
  return (__builtin_expect (((__fp)->_IO_read_ptr >= (__fp)->_IO_read_end), 0) ? __uflow (__fp) : *(unsigned char *) (__fp)->_IO_read_ptr++);
}
extern __inline __attribute__ ((__gnu_inline__)) int
getchar_unlocked (void)
{
  return (__builtin_expect (((stdin)->_IO_read_ptr >= (stdin)->_IO_read_end), 0) ? __uflow (stdin) : *(unsigned char *) (stdin)->_IO_read_ptr++);
}
extern __inline __attribute__ ((__gnu_inline__)) int
putchar (int __c)
{
  return _IO_putc (__c, stdout);
}
extern __inline __attribute__ ((__gnu_inline__)) int
fputc_unlocked (int __c, FILE *__stream)
{
  return (__builtin_expect (((__stream)->_IO_write_ptr >= (__stream)->_IO_write_end), 0) ? __overflow (__stream, (unsigned char) (__c)) : (unsigned char) (*(__stream)->_IO_write_ptr++ = (__c)));
}
extern __inline __attribute__ ((__gnu_inline__)) int
putc_unlocked (int __c, FILE *__stream)
{
  return (__builtin_expect (((__stream)->_IO_write_ptr >= (__stream)->_IO_write_end), 0) ? __overflow (__stream, (unsigned char) (__c)) : (unsigned char) (*(__stream)->_IO_write_ptr++ = (__c)));
}
extern __inline __attribute__ ((__gnu_inline__)) int
putchar_unlocked (int __c)
{
  return (__builtin_expect (((stdout)->_IO_write_ptr >= (stdout)->_IO_write_end), 0) ? __overflow (stdout, (unsigned char) (__c)) : (unsigned char) (*(stdout)->_IO_write_ptr++ = (__c)));
}
extern __inline __attribute__ ((__gnu_inline__)) __ssize_t
getline (char **__lineptr, size_t *__n, FILE *__stream)
{
  return __getdelim (__lineptr, __n, '\n', __stream);
}
extern __inline __attribute__ ((__gnu_inline__)) int
feof_unlocked (FILE *__stream) throw ()
{
  return (((__stream)->_flags & 0x10) != 0);
}
extern __inline __attribute__ ((__gnu_inline__)) int
ferror_unlocked (FILE *__stream) throw ()
{
  return (((__stream)->_flags & 0x20) != 0);
}
}
namespace std __attribute__ ((__visibility__ ("default"))) {
  using ::FILE;
  using ::fpos_t;
  using ::clearerr;
  using ::fclose;
  using ::feof;
  using ::ferror;
  using ::fflush;
  using ::fgetc;
  using ::fgetpos;
  using ::fgets;
  using ::fopen;
  using ::fprintf;
  using ::fputc;
  using ::fputs;
  using ::fread;
  using ::freopen;
  using ::fscanf;
  using ::fseek;
  using ::fsetpos;
  using ::ftell;
  using ::fwrite;
  using ::getc;
  using ::getchar;
  using ::gets;
  using ::perror;
  using ::printf;
  using ::putc;
  using ::putchar;
  using ::puts;
  using ::remove;
  using ::rename;
  using ::rewind;
  using ::scanf;
  using ::setbuf;
  using ::setvbuf;
  using ::sprintf;
  using ::sscanf;
  using ::tmpfile;
  using ::tmpnam;
  using ::ungetc;
  using ::vfprintf;
  using ::vprintf;
  using ::vsprintf;
}
namespace __gnu_cxx __attribute__ ((__visibility__ ("default"))) {
  using ::snprintf;
  using ::vfscanf;
  using ::vscanf;
  using ::vsnprintf;
  using ::vsscanf;
}
namespace std __attribute__ ((__visibility__ ("default"))) {
  using ::__gnu_cxx::snprintf;
  using ::__gnu_cxx::vfscanf;
  using ::__gnu_cxx::vscanf;
  using ::__gnu_cxx::vsnprintf;
  using ::__gnu_cxx::vsscanf;
}
namespace std
{
  using std::snprintf;
  using std::vsnprintf;
  using std::vfscanf;
  using std::vscanf;
  using std::vsscanf;
}
namespace stlp_std {
using std::FILE;
using std::fpos_t;
using std::size_t;
using std::clearerr;
using std::fclose;
using std::feof;
using std::ferror;
using std::fflush;
using std::fgetc;
using std::fgetpos;
using std::fgets;
using std::fopen;
using std::fprintf;
using std::fputc;
using std::fputs;
using std::fread;
using std::freopen;
using std::fscanf;
using std::fseek;
using std::fsetpos;
using std::ftell;
using std::fwrite;
 using std::getc;
 using std::putc;
 using std::getchar;
 using std::putchar;
using std::gets;
using std::perror;
using std::printf;
using std::puts;
using std::remove;
using std::rename;
using std::rewind;
using std::setbuf;
using std::tmpfile;
using std::tmpnam;
using std::scanf;
using std::setvbuf;
using std::sprintf;
using std::sscanf;
using std::ungetc;
using std::vfprintf;
using std::vprintf;
using std::vsprintf;
}
namespace stlp_std {
template <class _RandomAccessIterator>
void
push_heap(_RandomAccessIterator __first, _RandomAccessIterator __last);
template <class _RandomAccessIterator, class _Compare>
void
push_heap(_RandomAccessIterator __first, _RandomAccessIterator __last,
          _Compare __comp);
template <class _RandomAccessIterator, class _Distance, class _Tp>
void
__adjust_heap(_RandomAccessIterator __first, _Distance __holeIndex,
              _Distance __len, _Tp __val);
template <class _RandomAccessIterator, class _Tp, class _Distance>
inline void
__pop_heap(_RandomAccessIterator __first, _RandomAccessIterator __last,
           _RandomAccessIterator __result, _Tp __val, _Distance*)
{
  *__result = *__first;
  __adjust_heap(__first, _Distance(0), _Distance(__last - __first), __val);
}
template <class _RandomAccessIterator>
void pop_heap(_RandomAccessIterator __first,
        _RandomAccessIterator __last);
template <class _RandomAccessIterator, class _Distance,
          class _Tp, class _Compare>
void
__adjust_heap(_RandomAccessIterator __first, _Distance __holeIndex,
              _Distance __len, _Tp __val, _Compare __comp);
template <class _RandomAccessIterator, class _Tp, class _Compare,
          class _Distance>
inline void
__pop_heap(_RandomAccessIterator __first, _RandomAccessIterator __last,
           _RandomAccessIterator __result, _Tp __val, _Compare __comp,
           _Distance*)
{
  *__result = *__first;
  __adjust_heap(__first, _Distance(0), _Distance(__last - __first),
                __val, __comp);
}
template <class _RandomAccessIterator, class _Compare>
void
pop_heap(_RandomAccessIterator __first,
         _RandomAccessIterator __last, _Compare __comp);
template <class _RandomAccessIterator>
void
make_heap(_RandomAccessIterator __first, _RandomAccessIterator __last);
template <class _RandomAccessIterator, class _Compare>
void
make_heap(_RandomAccessIterator __first,
          _RandomAccessIterator __last, _Compare __comp);
template <class _RandomAccessIterator>
inline
void sort_heap(_RandomAccessIterator __first, _RandomAccessIterator __last)
{
  while (__last - __first > 1)
    pop_heap(__first, __last--);
}
template <class _RandomAccessIterator, class _Compare>
inline
void
sort_heap(_RandomAccessIterator __first,
          _RandomAccessIterator __last, _Compare __comp)
{
  while (__last - __first > 1)
    pop_heap(__first, __last--, __comp);
}
}
namespace stlp_std {
template <class _RandomAccessIterator, class _Distance, class _Tp>
inline
void
__push_heap(_RandomAccessIterator __first,
            _Distance __holeIndex, _Distance __topIndex, _Tp __val)
{
  _Distance __parent = (__holeIndex - 1) / 2;
  while (__holeIndex > __topIndex && *(__first + __parent) < __val) {
    *(__first + __holeIndex) = *(__first + __parent);
    __holeIndex = __parent;
    __parent = (__holeIndex - 1) / 2;
  }
  *(__first + __holeIndex) = __val;
}
template <class _RandomAccessIterator, class _Distance, class _Tp>
inline void
__push_heap_aux(_RandomAccessIterator __first,
                _RandomAccessIterator __last, _Distance*, _Tp*)
{
  __push_heap(__first, _Distance((__last - __first) - 1), _Distance(0),
              _Tp(*(__last - 1)));
}
template <class _RandomAccessIterator>
void
push_heap(_RandomAccessIterator __first, _RandomAccessIterator __last)
{
  __push_heap_aux(__first, __last,
                  (typename ::stlp_std::iterator_traits< _RandomAccessIterator >::difference_type*)0, (typename ::stlp_std::iterator_traits< _RandomAccessIterator >::value_type*)0);
}
template <class _RandomAccessIterator, class _Distance, class _Tp,
          class _Compare>
inline
void
__push_heap(_RandomAccessIterator __first, _Distance __holeIndex,
            _Distance __topIndex, _Tp __val, _Compare __comp)
{
  _Distance __parent = (__holeIndex - 1) / 2;
  while (__holeIndex > __topIndex && __comp(*(__first + __parent), __val)) {
   
    *(__first + __holeIndex) = *(__first + __parent);
    __holeIndex = __parent;
    __parent = (__holeIndex - 1) / 2;
  }
  *(__first + __holeIndex) = __val;
}
template <class _RandomAccessIterator, class _Compare,
          class _Distance, class _Tp>
inline void
__push_heap_aux(_RandomAccessIterator __first,
                _RandomAccessIterator __last, _Compare __comp,
                _Distance*, _Tp*)
{
  __push_heap(__first, _Distance((__last - __first) - 1), _Distance(0),
              _Tp(*(__last - 1)), __comp);
}
template <class _RandomAccessIterator, class _Compare>
void
push_heap(_RandomAccessIterator __first, _RandomAccessIterator __last,
          _Compare __comp)
{
  __push_heap_aux(__first, __last, __comp,
                  (typename ::stlp_std::iterator_traits< _RandomAccessIterator >::difference_type*)0, (typename ::stlp_std::iterator_traits< _RandomAccessIterator >::value_type*)0);
}
template <class _RandomAccessIterator, class _Distance, class _Tp>
void
__adjust_heap(_RandomAccessIterator __first, _Distance __holeIndex,
              _Distance __len, _Tp __val) {
  _Distance __topIndex = __holeIndex;
  _Distance __secondChild = 2 * __holeIndex + 2;
  while (__secondChild < __len) {
    if (*(__first + __secondChild) < *(__first + (__secondChild - 1)))
      __secondChild--;
    *(__first + __holeIndex) = *(__first + __secondChild);
    __holeIndex = __secondChild;
    __secondChild = 2 * (__secondChild + 1);
  }
  if (__secondChild == __len) {
    *(__first + __holeIndex) = *(__first + (__secondChild - 1));
    __holeIndex = __secondChild - 1;
  }
  __push_heap(__first, __holeIndex, __topIndex, __val);
}
template <class _RandomAccessIterator, class _Tp>
inline void
__pop_heap_aux(_RandomAccessIterator __first, _RandomAccessIterator __last, _Tp*) {
  __pop_heap(__first, __last - 1, __last - 1,
             _Tp(*(__last - 1)), (typename ::stlp_std::iterator_traits< _RandomAccessIterator >::difference_type*)0);
}
template <class _RandomAccessIterator>
void pop_heap(_RandomAccessIterator __first,
        _RandomAccessIterator __last) {
  __pop_heap_aux(__first, __last, (typename ::stlp_std::iterator_traits< _RandomAccessIterator >::value_type*)0);
}
template <class _RandomAccessIterator, class _Distance,
          class _Tp, class _Compare>
void
__adjust_heap(_RandomAccessIterator __first, _Distance __holeIndex,
              _Distance __len, _Tp __val, _Compare __comp)
{
  _Distance __topIndex = __holeIndex;
  _Distance __secondChild = 2 * __holeIndex + 2;
  while (__secondChild < __len) {
    if (__comp(*(__first + __secondChild), *(__first + (__secondChild - 1)))) {
     
      __secondChild--;
    }
    *(__first + __holeIndex) = *(__first + __secondChild);
    __holeIndex = __secondChild;
    __secondChild = 2 * (__secondChild + 1);
  }
  if (__secondChild == __len) {
    *(__first + __holeIndex) = *(__first + (__secondChild - 1));
    __holeIndex = __secondChild - 1;
  }
  __push_heap(__first, __holeIndex, __topIndex, __val, __comp);
}
template <class _RandomAccessIterator, class _Tp, class _Compare>
inline void
__pop_heap_aux(_RandomAccessIterator __first,
               _RandomAccessIterator __last, _Tp*, _Compare __comp)
{
  __pop_heap(__first, __last - 1, __last - 1, _Tp(*(__last - 1)), __comp,
             (typename ::stlp_std::iterator_traits< _RandomAccessIterator >::difference_type*)0);
}
template <class _RandomAccessIterator, class _Compare>
void
pop_heap(_RandomAccessIterator __first,
         _RandomAccessIterator __last, _Compare __comp)
{
    __pop_heap_aux(__first, __last, (typename ::stlp_std::iterator_traits< _RandomAccessIterator >::value_type*)0, __comp);
}
template <class _RandomAccessIterator, class _Tp, class _Distance>
inline
void
__make_heap(_RandomAccessIterator __first,
            _RandomAccessIterator __last, _Tp*, _Distance*)
{
  if (__last - __first < 2) return;
  _Distance __len = __last - __first;
  _Distance __parent = (__len - 2)/2;
  for (;;) {
    __adjust_heap(__first, __parent, __len, _Tp(*(__first + __parent)));
    if (__parent == 0) return;
    __parent--;
  }
}
template <class _RandomAccessIterator>
void
make_heap(_RandomAccessIterator __first, _RandomAccessIterator __last)
{
  __make_heap(__first, __last,
              (typename ::stlp_std::iterator_traits< _RandomAccessIterator >::value_type*)0, (typename ::stlp_std::iterator_traits< _RandomAccessIterator >::difference_type*)0);
}
template <class _RandomAccessIterator, class _Compare,
          class _Tp, class _Distance>
inline
void
__make_heap(_RandomAccessIterator __first, _RandomAccessIterator __last,
            _Compare __comp, _Tp*, _Distance*)
{
  if (__last - __first < 2) return;
  _Distance __len = __last - __first;
  _Distance __parent = (__len - 2)/2;
  for (;;) {
    __adjust_heap(__first, __parent, __len, _Tp(*(__first + __parent)),
                  __comp);
    if (__parent == 0) return;
    __parent--;
  }
}
template <class _RandomAccessIterator, class _Compare>
void
make_heap(_RandomAccessIterator __first,
          _RandomAccessIterator __last, _Compare __comp)
{
  __make_heap(__first, __last, __comp,
              (typename ::stlp_std::iterator_traits< _RandomAccessIterator >::value_type*)0, (typename ::stlp_std::iterator_traits< _RandomAccessIterator >::difference_type*)0);
}
}
namespace stlp_std {
template <class _InputIter, class _Function>
inline _Function
for_each(_InputIter __first, _InputIter __last, _Function __f) {
  for ( ; __first != __last; ++__first)
    __f(*__first);
  return __f;
}
template <class _InputIter, class _Predicate>
inline typename iterator_traits<_InputIter>::difference_type
count_if(_InputIter __first, _InputIter __last, _Predicate __pred) {
 
  typename iterator_traits<_InputIter>::difference_type __n = 0;
  for ( ; __first != __last; ++__first) {
    if (__pred(*__first))
      ++__n;
  }
  return __n;
}
template <class _ForwardIter, class _BinaryPredicate>
inline _ForwardIter
adjacent_find(_ForwardIter __first, _ForwardIter __last,
              _BinaryPredicate __binary_pred) {
 
  if (__first == __last)
    return __last;
  _ForwardIter __next = __first;
  while(++__next != __last) {
    if (__binary_pred(*__first, *__next))
      return __first;
    __first = __next;
  }
  return __last;
}
template <class _ForwardIter>
inline _ForwardIter
adjacent_find(_ForwardIter __first, _ForwardIter __last) {
  return adjacent_find(__first, __last,
                       ::stlp_std::priv:: __equal_to((typename ::stlp_std::iterator_traits< _ForwardIter >::value_type*)0));
}
template <class _InputIter, class _Tp, class _Size>
inline void
count(_InputIter __first, _InputIter __last, const _Tp& __val, _Size& __n) {
 
    for ( ; __first != __last; ++__first)
      if (*__first == __val)
        ++__n;
}
template <class _InputIter, class _Predicate, class _Size>
inline void
count_if(_InputIter __first, _InputIter __last, _Predicate __pred, _Size& __n) {
 
  for ( ; __first != __last; ++__first)
    if (__pred(*__first))
      ++__n;
}
template <class _ForwardIter1, class _ForwardIter2>
_ForwardIter1 search(_ForwardIter1 __first1, _ForwardIter1 __last1,
                     _ForwardIter2 __first2, _ForwardIter2 __last2);
template <class _ForwardIter, class _Integer, class _Tp>
_ForwardIter search_n(_ForwardIter __first, _ForwardIter __last,
                      _Integer __count, const _Tp& __val);
template <class _ForwardIter, class _Integer, class _Tp, class _BinaryPred>
_ForwardIter search_n(_ForwardIter __first, _ForwardIter __last,
                      _Integer __count, const _Tp& __val, _BinaryPred __binary_pred);
template <class _InputIter, class _ForwardIter>
inline _InputIter find_first_of(_InputIter __first1, _InputIter __last1,
                                _ForwardIter __first2, _ForwardIter __last2) {
 
 
  return ::stlp_std::priv:: __find_first_of(__first1, __last1, __first2, __last2);
}
template <class _InputIter, class _ForwardIter, class _BinaryPredicate>
inline _InputIter
find_first_of(_InputIter __first1, _InputIter __last1,
              _ForwardIter __first2, _ForwardIter __last2, _BinaryPredicate __comp) {
 
 
  return ::stlp_std::priv:: __find_first_of(__first1, __last1, __first2, __last2, __comp);
}
template <class _ForwardIter1, class _ForwardIter2>
_ForwardIter1
find_end(_ForwardIter1 __first1, _ForwardIter1 __last1,
         _ForwardIter2 __first2, _ForwardIter2 __last2);
template <class _ForwardIter1, class _ForwardIter2>
inline _ForwardIter2
swap_ranges(_ForwardIter1 __first1, _ForwardIter1 __last1, _ForwardIter2 __first2) {
 
  for ( ; __first1 != __last1; ++__first1, ++__first2)
    iter_swap(__first1, __first2);
  return __first2;
}
template <class _InputIter, class _OutputIter, class _UnaryOperation>
inline _OutputIter
transform(_InputIter __first, _InputIter __last, _OutputIter __result, _UnaryOperation __opr) {
 
  for ( ; __first != __last; ++__first, ++__result)
    *__result = __opr(*__first);
  return __result;
}
template <class _InputIter1, class _InputIter2, class _OutputIter, class _BinaryOperation>
inline _OutputIter
transform(_InputIter1 __first1, _InputIter1 __last1,
          _InputIter2 __first2, _OutputIter __result,_BinaryOperation __binary_op) {
 
  for ( ; __first1 != __last1; ++__first1, ++__first2, ++__result)
    *__result = __binary_op(*__first1, *__first2);
  return __result;
}
template <class _ForwardIter, class _Predicate, class _Tp>
inline void
replace_if(_ForwardIter __first, _ForwardIter __last, _Predicate __pred, const _Tp& __new_value) {
 
  for ( ; __first != __last; ++__first)
    if (__pred(*__first))
      *__first = __new_value;
}
template <class _InputIter, class _OutputIter, class _Tp>
inline _OutputIter
replace_copy(_InputIter __first, _InputIter __last,_OutputIter __result,
             const _Tp& __old_value, const _Tp& __new_value) {
 
  for ( ; __first != __last; ++__first, ++__result)
    *__result = *__first == __old_value ? __new_value : *__first;
  return __result;
}
template <class _Iterator, class _OutputIter, class _Predicate, class _Tp>
inline _OutputIter
replace_copy_if(_Iterator __first, _Iterator __last,
                _OutputIter __result,
                _Predicate __pred, const _Tp& __new_value) {
 
  for ( ; __first != __last; ++__first, ++__result)
    *__result = __pred(*__first) ? __new_value : *__first;
  return __result;
}
template <class _ForwardIter, class _Generator>
inline void
generate(_ForwardIter __first, _ForwardIter __last, _Generator __gen) {
 
  for ( ; __first != __last; ++__first)
    *__first = __gen();
}
template <class _OutputIter, class _Size, class _Generator>
inline void
generate_n(_OutputIter __first, _Size __n, _Generator __gen) {
  for ( ; __n > 0; --__n, ++__first)
    *__first = __gen();
}
template <class _InputIter, class _OutputIter, class _Tp>
inline _OutputIter
remove_copy(_InputIter __first, _InputIter __last,_OutputIter __result, const _Tp& __val) {
 
  for ( ; __first != __last; ++__first) {
    if (!(*__first == __val)) {
      *__result = *__first;
      ++__result;
    }
  }
  return __result;
}
template <class _InputIter, class _OutputIter, class _Predicate>
inline _OutputIter
remove_copy_if(_InputIter __first, _InputIter __last, _OutputIter __result, _Predicate __pred) {
 
  for ( ; __first != __last; ++__first) {
    if (!__pred(*__first)) {
      *__result = *__first;
      ++__result;
    }
  }
  return __result;
}
template <class _ForwardIter, class _Tp>
inline _ForwardIter
remove(_ForwardIter __first, _ForwardIter __last, const _Tp& __val) {
 
  __first = find(__first, __last, __val);
  if (__first == __last)
    return __first;
  else {
    _ForwardIter __next = __first;
    return remove_copy(++__next, __last, __first, __val);
  }
}
template <class _ForwardIter, class _Predicate>
inline _ForwardIter
remove_if(_ForwardIter __first, _ForwardIter __last, _Predicate __pred) {
 
  __first = find_if(__first, __last, __pred);
  if ( __first == __last )
    return __first;
  else {
    _ForwardIter __next = __first;
    return remove_copy_if(++__next, __last, __first, __pred);
  }
}
template <class _InputIter, class _OutputIter>
_OutputIter unique_copy(_InputIter __first, _InputIter __last, _OutputIter __result);
template <class _InputIter, class _OutputIter, class _BinaryPredicate>
_OutputIter unique_copy(_InputIter __first, _InputIter __last,_OutputIter __result,
                        _BinaryPredicate __binary_pred);
template <class _ForwardIter>
inline _ForwardIter unique(_ForwardIter __first, _ForwardIter __last) {
  __first = adjacent_find(__first, __last);
  return unique_copy(__first, __last, __first);
}
template <class _ForwardIter, class _BinaryPredicate>
inline _ForwardIter unique(_ForwardIter __first, _ForwardIter __last,
                           _BinaryPredicate __binary_pred) {
  __first = adjacent_find(__first, __last, __binary_pred);
  return unique_copy(__first, __last, __first, __binary_pred);
}
namespace priv {
template <class _BidirectionalIter>
inline void
__reverse(_BidirectionalIter __first, _BidirectionalIter __last, const bidirectional_iterator_tag &) {
  for (; __first != __last && __first != --__last; ++__first)
    ::stlp_std::iter_swap(__first,__last);
}
template <class _RandomAccessIter>
inline void
__reverse(_RandomAccessIter __first, _RandomAccessIter __last, const random_access_iterator_tag &) {
  for (; __first < __last; ++__first)
    ::stlp_std::iter_swap(__first, --__last);
}
}
template <class _BidirectionalIter>
inline void
reverse(_BidirectionalIter __first, _BidirectionalIter __last) {
 
  ::stlp_std::priv:: __reverse(__first, __last, typename ::stlp_std::iterator_traits< _BidirectionalIter >::iterator_category());
}
template <class _BidirectionalIter, class _OutputIter>
inline
_OutputIter reverse_copy(_BidirectionalIter __first,
                         _BidirectionalIter __last,
                         _OutputIter __result) {
 
  while (__first != __last) {
    --__last;
    *__result = *__last;
    ++__result;
  }
  return __result;
}
template <class _ForwardIter>
void rotate(_ForwardIter __first, _ForwardIter __middle, _ForwardIter __last);
template <class _ForwardIter, class _OutputIter>
inline _OutputIter rotate_copy(_ForwardIter __first, _ForwardIter __middle,
                               _ForwardIter __last, _OutputIter __result) {
  return ::stlp_std::copy(__first, __middle, copy(__middle, __last, __result));
}
template <class _RandomAccessIter>
void random_shuffle(_RandomAccessIter __first, _RandomAccessIter __last);
template <class _RandomAccessIter, class _RandomNumberGenerator>
void random_shuffle(_RandomAccessIter __first, _RandomAccessIter __last,
                    _RandomNumberGenerator& __rand);
template <class _ForwardIter, class _OutputIter, class _Distance>
_OutputIter random_sample_n(_ForwardIter __first, _ForwardIter __last,
                            _OutputIter __out_ite, const _Distance __n);
template <class _ForwardIter, class _OutputIter, class _Distance,
          class _RandomNumberGenerator>
_OutputIter random_sample_n(_ForwardIter __first, _ForwardIter __last,
                            _OutputIter __out_ite, const _Distance __n,
                            _RandomNumberGenerator& __rand);
template <class _InputIter, class _RandomAccessIter>
_RandomAccessIter
random_sample(_InputIter __first, _InputIter __last,
              _RandomAccessIter __out_first, _RandomAccessIter __out_last);
template <class _InputIter, class _RandomAccessIter,
          class _RandomNumberGenerator>
_RandomAccessIter
random_sample(_InputIter __first, _InputIter __last,
              _RandomAccessIter __out_first, _RandomAccessIter __out_last,
              _RandomNumberGenerator& __rand);
template <class _ForwardIter, class _Predicate>
_ForwardIter partition(_ForwardIter __first, _ForwardIter __last, _Predicate __pred);
template <class _ForwardIter, class _Predicate>
_ForwardIter
stable_partition(_ForwardIter __first, _ForwardIter __last, _Predicate __pred);
namespace priv {
template <class _Size>
inline _Size __lg(_Size __n) {
  _Size __k;
  for (__k = 0; __n != 1; __n >>= 1) ++__k;
  return __k;
}
}
template <class _RandomAccessIter>
void sort(_RandomAccessIter __first, _RandomAccessIter __last);
template <class _RandomAccessIter, class _Compare>
void sort(_RandomAccessIter __first, _RandomAccessIter __last, _Compare __comp);
template <class _RandomAccessIter>
void stable_sort(_RandomAccessIter __first,
                 _RandomAccessIter __last);
template <class _RandomAccessIter, class _Compare>
void stable_sort(_RandomAccessIter __first,
                 _RandomAccessIter __last, _Compare __comp);
template <class _RandomAccessIter>
void partial_sort(_RandomAccessIter __first, _RandomAccessIter __middle,
                  _RandomAccessIter __last);
template <class _RandomAccessIter, class _Compare>
void partial_sort(_RandomAccessIter __first,_RandomAccessIter __middle,
                  _RandomAccessIter __last, _Compare __comp);
template <class _InputIter, class _RandomAccessIter>
_RandomAccessIter
partial_sort_copy(_InputIter __first, _InputIter __last,
                  _RandomAccessIter __result_first, _RandomAccessIter __result_last);
template <class _InputIter, class _RandomAccessIter, class _Compare>
_RandomAccessIter
partial_sort_copy(_InputIter __first, _InputIter __last,
                  _RandomAccessIter __result_first,
                  _RandomAccessIter __result_last, _Compare __comp);
template <class _RandomAccessIter>
void nth_element(_RandomAccessIter __first, _RandomAccessIter __nth,
                 _RandomAccessIter __last);
template <class _RandomAccessIter, class _Compare>
void nth_element(_RandomAccessIter __first, _RandomAccessIter __nth,
                 _RandomAccessIter __last, _Compare __comp);
namespace priv {
template <class _T1, class _T2>
struct __less_2 {
  bool operator() (const _T1& __x, const _T2& __y) const { return __x < __y ; }
};
template <class _T1, class _T2>
__less_2<_T1,_T2> __less2(_T1*, _T2* ) { return __less_2<_T1, _T2>(); }
}
template <class _ForwardIter, class _Tp>
inline _ForwardIter lower_bound(_ForwardIter __first, _ForwardIter __last,
                                   const _Tp& __val) {
 
  return ::stlp_std::priv:: __lower_bound(__first, __last, __val,
                                  ::stlp_std::priv:: __less2((typename ::stlp_std::iterator_traits< _ForwardIter >::value_type*)0, (_Tp*)0),
                                  ::stlp_std::priv:: __less2((_Tp*)0, (typename ::stlp_std::iterator_traits< _ForwardIter >::value_type*)0),
                                  (typename ::stlp_std::iterator_traits< _ForwardIter >::difference_type*)0);
}
template <class _ForwardIter, class _Tp, class _Compare>
inline _ForwardIter lower_bound(_ForwardIter __first, _ForwardIter __last,
                                const _Tp& __val, _Compare __comp) {
 
  return ::stlp_std::priv:: __lower_bound(__first, __last, __val, __comp, __comp,
                                  (typename ::stlp_std::iterator_traits< _ForwardIter >::difference_type*)0);
}
namespace priv {
template <class _ForwardIter, class _Tp, class _Compare1, class _Compare2, class _Distance>
_ForwardIter __upper_bound(_ForwardIter __first, _ForwardIter __last, const _Tp& __val,
                           _Compare1 __comp1, _Compare2 __comp2, _Distance*);
}
template <class _ForwardIter, class _Tp>
inline _ForwardIter upper_bound(_ForwardIter __first, _ForwardIter __last,
                                const _Tp& __val) {
 
  return ::stlp_std::priv:: __upper_bound(__first, __last, __val,
                                  ::stlp_std::priv:: __less2((typename ::stlp_std::iterator_traits< _ForwardIter >::value_type*)0, (_Tp*)0),
                                  ::stlp_std::priv:: __less2((_Tp*)0, (typename ::stlp_std::iterator_traits< _ForwardIter >::value_type*)0),
                                  (typename ::stlp_std::iterator_traits< _ForwardIter >::difference_type*)0);
}
template <class _ForwardIter, class _Tp, class _Compare>
inline _ForwardIter upper_bound(_ForwardIter __first, _ForwardIter __last,
                                const _Tp& __val, _Compare __comp) {
 
  return ::stlp_std::priv:: __upper_bound(__first, __last, __val, __comp, __comp,
                                  (typename ::stlp_std::iterator_traits< _ForwardIter >::difference_type*)0);
}
namespace priv {
template <class _ForwardIter, class _Tp, class _Compare1, class _Compare2, class _Distance>
pair<_ForwardIter, _ForwardIter>
__equal_range(_ForwardIter __first, _ForwardIter __last, const _Tp& __val,
              _Compare1 __comp1, _Compare2 __comp2, _Distance*);
}
template <class _ForwardIter, class _Tp>
inline pair<_ForwardIter, _ForwardIter>
equal_range(_ForwardIter __first, _ForwardIter __last, const _Tp& __val) {
 
  return ::stlp_std::priv:: __equal_range(__first, __last, __val,
                                  ::stlp_std::priv:: __less2((typename ::stlp_std::iterator_traits< _ForwardIter >::value_type*)0, (_Tp*)0),
                                  ::stlp_std::priv:: __less2((_Tp*)0, (typename ::stlp_std::iterator_traits< _ForwardIter >::value_type*)0),
                                  (typename ::stlp_std::iterator_traits< _ForwardIter >::difference_type*)0);
}
template <class _ForwardIter, class _Tp, class _Compare>
inline pair<_ForwardIter, _ForwardIter>
equal_range(_ForwardIter __first, _ForwardIter __last, const _Tp& __val,
            _Compare __comp) {
 
  return ::stlp_std::priv:: __equal_range(__first, __last, __val, __comp, __comp,
                                  (typename ::stlp_std::iterator_traits< _ForwardIter >::difference_type*)0);
}
template <class _ForwardIter, class _Tp>
inline bool binary_search(_ForwardIter __first, _ForwardIter __last,
                   const _Tp& __val) {
 
  _ForwardIter __i = ::stlp_std::priv:: __lower_bound(__first, __last, __val,
                                              ::stlp_std::priv:: __less2((typename ::stlp_std::iterator_traits< _ForwardIter >::value_type*)0, (_Tp*)0),
                                              ::stlp_std::priv:: __less2((_Tp*)0, (typename ::stlp_std::iterator_traits< _ForwardIter >::value_type*)0),
                                              (typename ::stlp_std::iterator_traits< _ForwardIter >::difference_type*)0);
  return __i != __last && !(__val < *__i);
}
template <class _ForwardIter, class _Tp, class _Compare>
inline bool binary_search(_ForwardIter __first, _ForwardIter __last,
                          const _Tp& __val,
                          _Compare __comp) {
 
  _ForwardIter __i = ::stlp_std::priv:: __lower_bound(__first, __last, __val, __comp, __comp,
                                              (typename ::stlp_std::iterator_traits< _ForwardIter >::difference_type*)0);
  return __i != __last && !__comp(__val, *__i);
}
template <class _InputIter1, class _InputIter2, class _OutputIter>
_OutputIter merge(_InputIter1 __first1, _InputIter1 __last1,
                  _InputIter2 __first2, _InputIter2 __last2,
                  _OutputIter __result);
template <class _InputIter1, class _InputIter2, class _OutputIter,
          class _Compare>
_OutputIter merge(_InputIter1 __first1, _InputIter1 __last1,
                  _InputIter2 __first2, _InputIter2 __last2,
                  _OutputIter __result, _Compare __comp);
template <class _BidirectionalIter>
void inplace_merge(_BidirectionalIter __first,
                   _BidirectionalIter __middle,
                   _BidirectionalIter __last) ;
template <class _BidirectionalIter, class _Compare>
void inplace_merge(_BidirectionalIter __first,
                   _BidirectionalIter __middle,
                   _BidirectionalIter __last, _Compare __comp);
template <class _InputIter1, class _InputIter2>
bool includes(_InputIter1 __first1, _InputIter1 __last1,
              _InputIter2 __first2, _InputIter2 __last2);
template <class _InputIter1, class _InputIter2, class _Compare>
bool includes(_InputIter1 __first1, _InputIter1 __last1,
              _InputIter2 __first2, _InputIter2 __last2, _Compare __comp);
template <class _InputIter1, class _InputIter2, class _OutputIter>
_OutputIter set_union(_InputIter1 __first1, _InputIter1 __last1,
                      _InputIter2 __first2, _InputIter2 __last2,
                      _OutputIter __result);
template <class _InputIter1, class _InputIter2, class _OutputIter,
          class _Compare>
_OutputIter set_union(_InputIter1 __first1, _InputIter1 __last1,
                      _InputIter2 __first2, _InputIter2 __last2,
                      _OutputIter __result, _Compare __comp);
template <class _InputIter1, class _InputIter2, class _OutputIter>
_OutputIter set_intersection(_InputIter1 __first1, _InputIter1 __last1,
                             _InputIter2 __first2, _InputIter2 __last2,
                             _OutputIter __result);
template <class _InputIter1, class _InputIter2, class _OutputIter,
          class _Compare>
_OutputIter set_intersection(_InputIter1 __first1, _InputIter1 __last1,
                             _InputIter2 __first2, _InputIter2 __last2,
                             _OutputIter __result, _Compare __comp);
template <class _InputIter1, class _InputIter2, class _OutputIter>
_OutputIter set_difference(_InputIter1 __first1, _InputIter1 __last1,
                           _InputIter2 __first2, _InputIter2 __last2,
                           _OutputIter __result);
template <class _InputIter1, class _InputIter2, class _OutputIter,
          class _Compare>
_OutputIter set_difference(_InputIter1 __first1, _InputIter1 __last1,
                           _InputIter2 __first2, _InputIter2 __last2,
                           _OutputIter __result, _Compare __comp);
template <class _InputIter1, class _InputIter2, class _OutputIter>
_OutputIter
set_symmetric_difference(_InputIter1 __first1, _InputIter1 __last1,
                         _InputIter2 __first2, _InputIter2 __last2,
                         _OutputIter __result);
template <class _InputIter1, class _InputIter2, class _OutputIter,
          class _Compare>
_OutputIter
set_symmetric_difference(_InputIter1 __first1, _InputIter1 __last1,
                         _InputIter2 __first2, _InputIter2 __last2,
                         _OutputIter __result,
                         _Compare __comp);
template <class _ForwardIter>
_ForwardIter max_element(_ForwardIter __first, _ForwardIter __last);
template <class _ForwardIter, class _Compare>
_ForwardIter max_element(_ForwardIter __first, _ForwardIter __last,
                            _Compare __comp);
template <class _ForwardIter>
_ForwardIter min_element(_ForwardIter __first, _ForwardIter __last);
template <class _ForwardIter, class _Compare>
_ForwardIter min_element(_ForwardIter __first, _ForwardIter __last,
                            _Compare __comp);
template <class _BidirectionalIter>
bool next_permutation(_BidirectionalIter __first, _BidirectionalIter __last);
template <class _BidirectionalIter, class _Compare>
bool next_permutation(_BidirectionalIter __first, _BidirectionalIter __last,
                      _Compare __comp);
template <class _BidirectionalIter>
bool prev_permutation(_BidirectionalIter __first, _BidirectionalIter __last);
template <class _BidirectionalIter, class _Compare>
bool prev_permutation(_BidirectionalIter __first, _BidirectionalIter __last,
                      _Compare __comp);
template <class _RandomAccessIter>
bool is_heap(_RandomAccessIter __first, _RandomAccessIter __last);
template <class _RandomAccessIter, class _StrictWeakOrdering>
bool is_heap(_RandomAccessIter __first, _RandomAccessIter __last,
             _StrictWeakOrdering __comp);
namespace priv {
template <class _ForwardIter, class _StrictWeakOrdering>
bool __is_sorted(_ForwardIter __first, _ForwardIter __last,
                 _StrictWeakOrdering __comp);
}
template <class _ForwardIter>
inline bool is_sorted(_ForwardIter __first, _ForwardIter __last) {
  return ::stlp_std::priv:: __is_sorted(__first, __last,
                                ::stlp_std::priv:: __less((typename ::stlp_std::iterator_traits< _ForwardIter >::value_type*)0));
}
template <class _ForwardIter, class _StrictWeakOrdering>
inline bool is_sorted(_ForwardIter __first, _ForwardIter __last,
                      _StrictWeakOrdering __comp) {
  return ::stlp_std::priv:: __is_sorted(__first, __last, __comp);
}
}
namespace stlp_std {
template <class _Tp>
pair<_Tp*, ptrdiff_t>
__get_temporary_buffer(ptrdiff_t __len, _Tp*);
template <class _Tp>
inline pair<_Tp*, ptrdiff_t> get_temporary_buffer(ptrdiff_t __len) {
  return __get_temporary_buffer(__len, (_Tp*) 0);
}
template <class _Tp>
inline pair<_Tp*, ptrdiff_t>
get_temporary_buffer(ptrdiff_t __len, _Tp*) {
  return __get_temporary_buffer(__len, (_Tp*) 0);
}
template <class _Tp>
inline void return_temporary_buffer(_Tp* __p) {
  free((char*)__p);
}
template <class _ForwardIterator, class _Tp>
class _Temporary_buffer {
private:
  ptrdiff_t _M_original_len;
  ptrdiff_t _M_len;
  _Tp* _M_buffer;
  void _M_allocate_buffer() {
    _M_original_len = _M_len;
    _M_buffer = 0;
    if (_M_len > (ptrdiff_t)(2147483647 / sizeof(_Tp)))
      _M_len = 2147483647 / sizeof(_Tp);
    while (_M_len > 0) {
      _M_buffer = (_Tp*) malloc(_M_len * sizeof(_Tp));
      if (_M_buffer)
        break;
      _M_len /= 2;
    }
  }
  void _M_initialize_buffer(const _Tp&, const __true_type&) {}
  void _M_initialize_buffer(const _Tp& val, const __false_type&) {
    uninitialized_fill_n(_M_buffer, _M_len, val);
  }
public:
  ptrdiff_t size() const { return _M_len; }
  ptrdiff_t requested_size() const { return _M_original_len; }
  _Tp* begin() { return _M_buffer; }
  _Tp* end() { return _M_buffer + _M_len; }
  _Temporary_buffer(_ForwardIterator __first, _ForwardIterator __last) {
    typedef typename __type_traits<_Tp>::has_trivial_default_constructor _Trivial;
    try {
      _M_len = ::stlp_std::distance(__first, __last);
      _M_allocate_buffer();
      if (_M_len > 0)
        _M_initialize_buffer(*__first, _Trivial());
    }
    catch(...) { free(_M_buffer); _M_buffer = 0; _M_len = 0; throw; }
  }
  ~_Temporary_buffer() {
    ::stlp_std::_Destroy_Range(_M_buffer, _M_buffer + _M_len);
    free(_M_buffer);
  }
private:
  _Temporary_buffer(const _Temporary_buffer<_ForwardIterator, _Tp>&) {}
  void operator=(const _Temporary_buffer<_ForwardIterator, _Tp>&) {}
};
template <class _ForwardIterator,
          class _Tp
                    = typename iterator_traits<_ForwardIterator>::value_type
         >
struct temporary_buffer : public _Temporary_buffer<_ForwardIterator, _Tp>
{
  temporary_buffer(_ForwardIterator __first, _ForwardIterator __last)
    : _Temporary_buffer<_ForwardIterator, _Tp>(__first, __last) {}
  ~temporary_buffer() {}
};
}
namespace stlp_std {
template <class _Tp>
pair<_Tp*, ptrdiff_t>
__get_temporary_buffer(ptrdiff_t __len, _Tp*)
{
  if (__len > ptrdiff_t(2147483647 / sizeof(_Tp)))
    __len = 2147483647 / sizeof(_Tp);
  while (__len > 0) {
    _Tp* __tmp = (_Tp*) malloc((size_t)__len * sizeof(_Tp));
    if (__tmp != 0)
      return pair<_Tp*, ptrdiff_t>(__tmp, __len);
    __len /= 2;
  }
  return pair<_Tp*, ptrdiff_t>((_Tp*)0, 0);
}
}
namespace stlp_std {
namespace priv {
template <class _BidirectionalIter, class _Distance, class _Compare>
void __merge_without_buffer(_BidirectionalIter __first,
                            _BidirectionalIter __middle,
                            _BidirectionalIter __last,
                            _Distance __len1, _Distance __len2,
                            _Compare __comp);
template <class _BidirectionalIter1, class _BidirectionalIter2,
          class _BidirectionalIter3, class _Compare>
_BidirectionalIter3 __merge_backward(_BidirectionalIter1 __first1,
                                     _BidirectionalIter1 __last1,
                                     _BidirectionalIter2 __first2,
                                     _BidirectionalIter2 __last2,
                                     _BidirectionalIter3 __result,
                                     _Compare __comp);
template <class _Tp>
inline
const _Tp& __median(const _Tp& __a, const _Tp& __b, const _Tp& __c) {
  if (__a < __b)
    if (__b < __c)
      return __b;
    else if (__a < __c)
      return __c;
    else
      return __a;
  else if (__a < __c)
    return __a;
  else if (__b < __c)
    return __c;
  else
    return __b;
}
template <class _Tp, class _Compare>
inline
const _Tp&
__median(const _Tp& __a, const _Tp& __b, const _Tp& __c, _Compare __comp) {
  if (__comp(__a, __b)) {
   
    if (__comp(__b, __c)) {
     
      return __b;
    }
    else if (__comp(__a, __c)) {
     
      return __c;
    }
    else
      return __a;
  }
  else if (__comp(__a, __c)) {
   
    return __a;
  }
  else if (__comp(__b, __c)) {
   
    return __c;
  }
  else
    return __b;
}
}
template <class _ForwardIter1, class _ForwardIter2>
_ForwardIter1 search(_ForwardIter1 __first1, _ForwardIter1 __last1,
                     _ForwardIter2 __first2, _ForwardIter2 __last2) {
 
 
  if (__first1 == __last1 || __first2 == __last2)
    return __first1;
  _ForwardIter2 __p1(__first2);
  if ( ++__p1 == __last2 )
    return find(__first1, __last1, *__first2);
  for ( ; ; ) {
    __first1 = find(__first1, __last1, *__first2);
    if (__first1 == __last1)
      return __last1;
    _ForwardIter2 __p = __p1;
    _ForwardIter1 __current = __first1;
    if (++__current == __last1)
      return __last1;
    while (*__current == *__p) {
      if (++__p == __last2)
        return __first1;
      if (++__current == __last1)
        return __last1;
    }
    ++__first1;
  }
  return __first1;
}
namespace priv {
template <class _RandomAccessIter, class _Integer, class _Tp,
          class _BinaryPred, class _Distance>
_RandomAccessIter __search_n(_RandomAccessIter __first, _RandomAccessIter __last,
                             _Integer __count, const _Tp& __val, _BinaryPred __pred,
                             _Distance*, const random_access_iterator_tag &)
{
  _Distance __tailSize = __last - __first;
  const _Distance __pattSize = __count;
  const _Distance __skipOffset = __pattSize - 1;
  _RandomAccessIter __backTrack;
  _Distance __remainder, __prevRemainder;
  for ( _RandomAccessIter __lookAhead = __first + __skipOffset; __tailSize >= __pattSize; __lookAhead += __pattSize ) {
    __tailSize -= __pattSize;
    while ( !__pred(*__lookAhead, __val) ) {
      if (__tailSize < __pattSize)
        return __last;
      __lookAhead += __pattSize;
      __tailSize -= __pattSize;
    }
    if ( __skipOffset == 0 ) {
      return (__lookAhead - __skipOffset);
    }
    __remainder = __skipOffset;
    for (__backTrack = __lookAhead; __pred(*--__backTrack, __val); ) {
      if (--__remainder == 0)
        return (__lookAhead - __skipOffset);
    }
    if (__remainder > __tailSize)
      return __last;
    __lookAhead += __remainder;
    __tailSize -= __remainder;
    while ( __pred(*__lookAhead, __val) ) {
      __prevRemainder = __remainder;
      __backTrack = __lookAhead;
      do {
        if (--__remainder == 0)
          return (__lookAhead - __skipOffset);
      } while (__pred(*--__backTrack, __val));
      __remainder += __pattSize - __prevRemainder;
      if (__remainder > __tailSize)
        return __last;
      __lookAhead += __remainder;
      __tailSize -= __remainder;
    }
  }
  return __last;
}
template <class _ForwardIter, class _Integer, class _Tp,
          class _Distance, class _BinaryPred>
_ForwardIter __search_n(_ForwardIter __first, _ForwardIter __last,
                        _Integer __count, const _Tp& __val, _BinaryPred __pred,
                        _Distance*, const forward_iterator_tag &) {
  for (; (__first != __last) && !__pred(*__first, __val); ++__first) {}
  while (__first != __last) {
    _Integer __n = __count - 1;
    _ForwardIter __i = __first;
    ++__i;
    while (__i != __last && __n != 0 && __pred(*__i, __val)) {
      ++__i;
      --__n;
    }
    if (__n == 0)
      return __first;
    else if (__i != __last)
      for (__first = ++__i; (__first != __last) && !__pred(*__first, __val); ++__first) {}
    else
      break;
  }
  return __last;
}
}
template <class _ForwardIter, class _Integer, class _Tp>
_ForwardIter search_n(_ForwardIter __first, _ForwardIter __last,
                      _Integer __count, const _Tp& __val) {
 
  if (__count <= 0)
    return __first;
  if (__count == 1)
    return find(__first, __last, __val);
  return ::stlp_std::priv:: __search_n(__first, __last, __count, __val, equal_to<_Tp>(),
                               (typename ::stlp_std::iterator_traits< _ForwardIter >::difference_type*)0,
                               typename ::stlp_std::iterator_traits< _ForwardIter >::iterator_category());
}
template <class _ForwardIter, class _Integer, class _Tp, class _BinaryPred>
_ForwardIter search_n(_ForwardIter __first, _ForwardIter __last,
                      _Integer __count, const _Tp& __val,
                      _BinaryPred __binary_pred) {
 
  if (__count <= 0)
    return __first;
  return ::stlp_std::priv:: __search_n(__first, __last, __count, __val, __binary_pred,
                               (typename ::stlp_std::iterator_traits< _ForwardIter >::difference_type*)0,
                               typename ::stlp_std::iterator_traits< _ForwardIter >::iterator_category());
}
template <class _ForwardIter1, class _ForwardIter2>
_ForwardIter1
find_end(_ForwardIter1 __first1, _ForwardIter1 __last1,
         _ForwardIter2 __first2, _ForwardIter2 __last2) {
 
 
  return ::stlp_std::priv:: __find_end(__first1, __last1, __first2, __last2,
                               typename ::stlp_std::iterator_traits< _ForwardIter1 >::iterator_category(),
                               typename ::stlp_std::iterator_traits< _ForwardIter2 >::iterator_category(),
                               ::stlp_std::priv:: __equal_to((typename ::stlp_std::iterator_traits< _ForwardIter1 >::value_type*)0)
    );
}
namespace priv {
template <class _InputIterator, class _OutputIterator, class _BinaryPredicate,
          class _Tp>
inline _OutputIterator
__unique_copy(_InputIterator __first, _InputIterator __last,
              _OutputIterator __result,
              _BinaryPredicate __binary_pred, _Tp*) {
  _Tp __val = *__first;
  *__result = __val;
  while (++__first != __last)
    if (!__binary_pred(__val, *__first)) {
      __val = *__first;
      *++__result = __val;
    }
  return ++__result;
}
template <class _InputIter, class _OutputIter, class _BinaryPredicate>
inline _OutputIter
__unique_copy(_InputIter __first, _InputIter __last,_OutputIter __result,
              _BinaryPredicate __binary_pred, const output_iterator_tag &) {
  return ::stlp_std::priv:: __unique_copy(__first, __last, __result, __binary_pred,
                                  (typename ::stlp_std::iterator_traits< _InputIter >::value_type*)0);
}
template <class _InputIter, class _ForwardIter, class _BinaryPredicate>
inline _ForwardIter
__unique_copy(_InputIter __first, _InputIter __last, _ForwardIter __result,
              _BinaryPredicate __binary_pred, const forward_iterator_tag &) {
  *__result = *__first;
  while (++__first != __last)
    if (!__binary_pred(*__result, *__first)) *++__result = *__first;
  return ++__result;
}
}
template <class _InputIter, class _OutputIter>
_OutputIter
unique_copy(_InputIter __first, _InputIter __last, _OutputIter __result) {
 
  if (__first == __last) return __result;
  return ::stlp_std::priv:: __unique_copy(__first, __last, __result,
                                  ::stlp_std::priv:: __equal_to((typename ::stlp_std::iterator_traits< _InputIter >::value_type*)0),
                                  typename ::stlp_std::iterator_traits< _OutputIter >::iterator_category());
}
template <class _InputIter, class _OutputIter, class _BinaryPredicate>
_OutputIter
unique_copy(_InputIter __first, _InputIter __last,_OutputIter __result,
            _BinaryPredicate __binary_pred) {
 
  if (__first == __last) return __result;
  return ::stlp_std::priv:: __unique_copy(__first, __last, __result, __binary_pred,
                                  typename ::stlp_std::iterator_traits< _OutputIter >::iterator_category());
}
namespace priv {
template <class _ForwardIter, class _Distance>
_ForwardIter __rotate_aux(_ForwardIter __first,
                          _ForwardIter __middle,
                          _ForwardIter __last,
                          _Distance*,
                          const forward_iterator_tag &) {
  if (__first == __middle)
    return __last;
  if (__last == __middle)
    return __first;
  _ForwardIter __first2 = __middle;
  do {
    ::stlp_std::swap(*__first++, *__first2++);
    if (__first == __middle)
      __middle = __first2;
  } while (__first2 != __last);
  _ForwardIter __new_middle = __first;
  __first2 = __middle;
  while (__first2 != __last) {
    ::stlp_std::swap (*__first++, *__first2++);
    if (__first == __middle)
      __middle = __first2;
    else if (__first2 == __last)
      __first2 = __middle;
  }
  return __new_middle;
}
template <class _BidirectionalIter, class _Distance>
_BidirectionalIter __rotate_aux(_BidirectionalIter __first,
                                _BidirectionalIter __middle,
                                _BidirectionalIter __last,
                                _Distance*,
                                const bidirectional_iterator_tag &) {
  if (__first == __middle)
    return __last;
  if (__last == __middle)
    return __first;
  ::stlp_std::priv:: __reverse(__first, __middle, bidirectional_iterator_tag());
  ::stlp_std::priv:: __reverse(__middle, __last, bidirectional_iterator_tag());
  while (__first != __middle && __middle != __last)
    ::stlp_std::swap(*__first++, *--__last);
  if (__first == __middle) {
    ::stlp_std::priv:: __reverse(__middle, __last, bidirectional_iterator_tag());
    return __last;
  }
  else {
    ::stlp_std::priv:: __reverse(__first, __middle, bidirectional_iterator_tag());
    return __first;
  }
}
template <class _EuclideanRingElement>
inline
_EuclideanRingElement __gcd(_EuclideanRingElement __m,
                            _EuclideanRingElement __n) {
  while (__n != 0) {
    _EuclideanRingElement __t = __m % __n;
    __m = __n;
    __n = __t;
  }
  return __m;
}
template <class _RandomAccessIter, class _Distance, class _Tp>
_RandomAccessIter __rotate_aux(_RandomAccessIter __first,
                               _RandomAccessIter __middle,
                               _RandomAccessIter __last,
                               _Distance *, _Tp *) {
  _Distance __n = __last - __first;
  _Distance __k = __middle - __first;
  _Distance __l = __n - __k;
  _RandomAccessIter __result = __first + (__last - __middle);
  if (__k == 0)
    return __last;
  if (__k == __l) {
    ::stlp_std::swap_ranges(__first, __middle, __middle);
    return __result;
  }
  _Distance __d = ::stlp_std::priv:: __gcd(__n, __k);
  for (_Distance __i = 0; __i < __d; __i++) {
    _Tp __tmp = *__first;
    _RandomAccessIter __p = __first;
    if (__k < __l) {
      for (_Distance __j = 0; __j < __l/__d; __j++) {
        if (__p > __first + __l) {
          *__p = *(__p - __l);
          __p -= __l;
        }
        *__p = *(__p + __k);
        __p += __k;
      }
    }
    else {
      for (_Distance __j = 0; __j < __k/__d - 1; __j ++) {
        if (__p < __last - __k) {
          *__p = *(__p + __k);
          __p += __k;
        }
        *__p = * (__p - __l);
        __p -= __l;
      }
    }
    *__p = __tmp;
    ++__first;
  }
  return __result;
}
template <class _RandomAccessIter, class _Distance>
inline _RandomAccessIter
__rotate_aux(_RandomAccessIter __first, _RandomAccessIter __middle, _RandomAccessIter __last,
             _Distance * __dis, const random_access_iterator_tag &) {
  return ::stlp_std::priv:: __rotate_aux(__first, __middle, __last,
                                 __dis, (typename ::stlp_std::iterator_traits< _RandomAccessIter >::value_type*)0);
}
template <class _ForwardIter>
_ForwardIter
__rotate(_ForwardIter __first, _ForwardIter __middle, _ForwardIter __last) {
 
 
  return __rotate_aux(__first, __middle, __last,
                      (typename ::stlp_std::iterator_traits< _ForwardIter >::difference_type*)0,
                      typename ::stlp_std::iterator_traits< _ForwardIter >::iterator_category());
}
}
template <class _ForwardIter>
void rotate(_ForwardIter __first, _ForwardIter __middle, _ForwardIter __last) {
  ::stlp_std::priv:: __rotate(__first, __middle, __last);
}
namespace priv {
template <class _Distance>
inline _Distance __random_number(_Distance __n) {
  return rand() % __n;
}
}
template <class _RandomAccessIter>
void random_shuffle(_RandomAccessIter __first,
                    _RandomAccessIter __last) {
 
  if (__first == __last) return;
  for (_RandomAccessIter __i = __first + 1; __i != __last; ++__i)
    iter_swap(__i, __first + ::stlp_std::priv:: __random_number((__i - __first) + 1));
}
template <class _RandomAccessIter, class _RandomNumberGenerator>
void random_shuffle(_RandomAccessIter __first, _RandomAccessIter __last,
                    _RandomNumberGenerator &__rand) {
 
  if (__first == __last) return;
  for (_RandomAccessIter __i = __first + 1; __i != __last; ++__i)
    iter_swap(__i, __first + __rand((__i - __first) + 1));
}
template <class _ForwardIter, class _OutputIter, class _Distance>
_OutputIter random_sample_n(_ForwardIter __first, _ForwardIter __last,
                            _OutputIter __out_ite, const _Distance __n) {
 
  _Distance __remaining = ::stlp_std::distance(__first, __last);
  _Distance __m = (min) (__n, __remaining);
  while (__m > 0) {
    if (::stlp_std::priv:: __random_number(__remaining) < __m) {
      *__out_ite = *__first;
      ++__out_ite;
      --__m;
    }
    --__remaining;
    ++__first;
  }
  return __out_ite;
}
template <class _ForwardIter, class _OutputIter, class _Distance,
          class _RandomNumberGenerator>
_OutputIter random_sample_n(_ForwardIter __first, _ForwardIter __last,
                            _OutputIter __out_ite, const _Distance __n,
                            _RandomNumberGenerator& __rand) {
 
  _Distance __remaining = ::stlp_std::distance(__first, __last);
  _Distance __m = (min) (__n, __remaining);
  while (__m > 0) {
    if (__rand(__remaining) < __m) {
      *__out_ite = *__first;
      ++__out_ite;
      --__m;
    }
    --__remaining;
    ++__first;
  }
  return __out_ite;
}
namespace priv {
template <class _InputIter, class _RandomAccessIter, class _Distance>
_RandomAccessIter __random_sample(_InputIter __first, _InputIter __last,
                                  _RandomAccessIter __out_ite,
                                  const _Distance __n) {
  _Distance __m = 0;
  _Distance __t = __n;
  for ( ; __first != __last && __m < __n; ++__m, ++__first)
    __out_ite[__m] = *__first;
  while (__first != __last) {
    ++__t;
    _Distance __M = __random_number(__t);
    if (__M < __n)
      __out_ite[__M] = *__first;
    ++__first;
  }
  return __out_ite + __m;
}
template <class _InputIter, class _RandomAccessIter,
          class _RandomNumberGenerator, class _Distance>
_RandomAccessIter __random_sample(_InputIter __first, _InputIter __last,
                                  _RandomAccessIter __out_ite,
                                  _RandomNumberGenerator& __rand,
                                  const _Distance __n) {
  _Distance __m = 0;
  _Distance __t = __n;
  for ( ; __first != __last && __m < __n; ++__m, ++__first)
    __out_ite[__m] = *__first;
  while (__first != __last) {
    ++__t;
    _Distance __M = __rand(__t);
    if (__M < __n)
      __out_ite[__M] = *__first;
    ++__first;
  }
  return __out_ite + __m;
}
}
template <class _InputIter, class _RandomAccessIter>
_RandomAccessIter
random_sample(_InputIter __first, _InputIter __last,
              _RandomAccessIter __out_first, _RandomAccessIter __out_last) {
 
 
  return ::stlp_std::priv:: __random_sample(__first, __last,
                                    __out_first, __out_last - __out_first);
}
template <class _InputIter, class _RandomAccessIter, class _RandomNumberGenerator>
_RandomAccessIter
random_sample(_InputIter __first, _InputIter __last,
              _RandomAccessIter __out_first, _RandomAccessIter __out_last,
              _RandomNumberGenerator& __rand) {
 
 
  return ::stlp_std::priv:: __random_sample(__first, __last,
                                    __out_first, __rand,
                                    __out_last - __out_first);
}
namespace priv {
template <class _ForwardIter, class _Predicate>
inline _ForwardIter __partition(_ForwardIter __first,
                                           _ForwardIter __last,
                                           _Predicate __pred,
                                           const forward_iterator_tag &) {
  if (__first == __last) return __first;
  while (__pred(*__first))
    if (++__first == __last) return __first;
  _ForwardIter __next = __first;
  while (++__next != __last) {
    if (__pred(*__next)) {
      ::stlp_std::swap(*__first, *__next);
      ++__first;
    }
  }
  return __first;
}
template <class _BidirectionalIter, class _Predicate>
inline _BidirectionalIter __partition(_BidirectionalIter __first,
                                                 _BidirectionalIter __last,
                                                 _Predicate __pred,
                                                 const bidirectional_iterator_tag &) {
  for (;;) {
    for (;;) {
      if (__first == __last)
        return __first;
      else if (__pred(*__first))
        ++__first;
      else
        break;
    }
    --__last;
    for (;;) {
      if (__first == __last)
        return __first;
      else if (!__pred(*__last))
        --__last;
      else
        break;
    }
    iter_swap(__first, __last);
    ++__first;
  }
}
}
template <class _ForwardIter, class _Predicate>
_ForwardIter partition(_ForwardIter __first, _ForwardIter __last, _Predicate __pred) {
 
  return ::stlp_std::priv:: __partition(__first, __last, __pred, typename ::stlp_std::iterator_traits< _ForwardIter >::iterator_category());
}
namespace priv {
template <class _ForwardIter, class _Predicate, class _Distance>
_ForwardIter __inplace_stable_partition(_ForwardIter __first,
                                        _ForwardIter __last,
                                        _Predicate __pred, _Distance __len,
                                        bool __pred_of_first, bool __pred_of_before_last) {
  if (__len == 1)
    return (__pred_of_first && (__pred_of_before_last || __pred(*__first))) ? __last : __first;
  _ForwardIter __middle = __first;
  _Distance __half_len = __len / 2;
  ::stlp_std::advance(__middle, __half_len);
  return ::stlp_std::priv:: __rotate(::stlp_std::priv:: __inplace_stable_partition(__first, __middle, __pred, __half_len, __pred_of_first, false),
                             __middle,
                             ::stlp_std::priv:: __inplace_stable_partition(__middle, __last, __pred, __len - __half_len, true, __pred_of_before_last));
}
template <class _ForwardIter, class _Pointer, class _Predicate,
          class _Distance>
_ForwardIter __stable_partition_adaptive(_ForwardIter __first,
                                         _ForwardIter __last,
                                         _Predicate __pred, _Distance __len,
                                         _Pointer __buffer, _Distance __buffer_size,
                                         bool __pred_of_first, bool __pred_of_before_last) {
  if (__len <= __buffer_size) {
    _ForwardIter __result1 = __first;
    _Pointer __result2 = __buffer;
    if ((__first != __last) && (!__pred_of_first || __pred(*__first))) {
      *__result2 = *__first;
      ++__result2; ++__first; --__len;
    }
    for (; __first != __last ; ++__first, --__len) {
      if (((__len == 1) && (__pred_of_before_last || __pred(*__first))) ||
          ((__len != 1) && __pred(*__first))){
        *__result1 = *__first;
        ++__result1;
      }
      else {
        *__result2 = *__first;
        ++__result2;
      }
    }
    ::stlp_std::copy(__buffer, __result2, __result1);
    return __result1;
  }
  else {
    _ForwardIter __middle = __first;
    _Distance __half_len = __len / 2;
    ::stlp_std::advance(__middle, __half_len);
    return ::stlp_std::priv:: __rotate(::stlp_std::priv:: __stable_partition_adaptive(__first, __middle, __pred,
                                                                      __half_len, __buffer, __buffer_size,
                                                                      __pred_of_first, false),
                               __middle,
                               ::stlp_std::priv:: __stable_partition_adaptive(__middle, __last, __pred,
                                                                      __len - __half_len, __buffer, __buffer_size,
                                                                      true, __pred_of_before_last));
  }
}
template <class _ForwardIter, class _Predicate, class _Tp, class _Distance>
inline _ForwardIter
__stable_partition_aux_aux(_ForwardIter __first, _ForwardIter __last,
                           _Predicate __pred, _Tp*, _Distance*, bool __pred_of_before_last) {
  _Temporary_buffer<_ForwardIter, _Tp> __buf(__first, __last);
 
  return (__buf.size() > 0) ?
    __stable_partition_adaptive(__first, __last, __pred,
                                _Distance(__buf.requested_size()),
                                __buf.begin(), __buf.size(),
                                false, __pred_of_before_last) :
    __inplace_stable_partition(__first, __last, __pred,
                               _Distance(__buf.requested_size()),
                               false, __pred_of_before_last);
 
}
template <class _ForwardIter, class _Predicate>
_ForwardIter
__stable_partition_aux(_ForwardIter __first, _ForwardIter __last, _Predicate __pred,
                       const forward_iterator_tag &) {
  return __stable_partition_aux_aux(__first, __last, __pred,
                                    (typename ::stlp_std::iterator_traits< _ForwardIter >::value_type*)0,
                                    (typename ::stlp_std::iterator_traits< _ForwardIter >::difference_type*)0, false);
}
template <class _BidirectIter, class _Predicate>
_BidirectIter
__stable_partition_aux(_BidirectIter __first, _BidirectIter __last, _Predicate __pred,
                       const bidirectional_iterator_tag &) {
  for (--__last;;) {
    if (__first == __last)
      return __first;
    else if (!__pred(*__last))
      --__last;
    else
      break;
  }
  ++__last;
  return __stable_partition_aux_aux(__first, __last, __pred,
                                    (typename ::stlp_std::iterator_traits< _BidirectIter >::value_type*)0,
                                    (typename ::stlp_std::iterator_traits< _BidirectIter >::difference_type*)0, true);
}
}
template <class _ForwardIter, class _Predicate>
_ForwardIter
stable_partition(_ForwardIter __first, _ForwardIter __last, _Predicate __pred) {
 
  for (;;) {
    if (__first == __last)
      return __first;
    else if (__pred(*__first))
      ++__first;
    else
      break;
  }
  return ::stlp_std::priv:: __stable_partition_aux(__first, __last, __pred,
                                           typename ::stlp_std::iterator_traits< _ForwardIter >::iterator_category());
}
namespace priv {
template <class _RandomAccessIter, class _Tp, class _Compare>
_RandomAccessIter __unguarded_partition(_RandomAccessIter __first,
                                        _RandomAccessIter __last,
                                        _Tp __pivot, _Compare __comp) {
  for (;;) {
    while (__comp(*__first, __pivot)) {
     
      ++__first;
    }
    --__last;
    while (__comp(__pivot, *__last)) {
     
      --__last;
    }
    if (!(__first < __last))
      return __first;
    iter_swap(__first, __last);
    ++__first;
  }
}
template <class _RandomAccessIter, class _Tp, class _Compare>
void __unguarded_linear_insert(_RandomAccessIter __last, _Tp __val,
                               _Compare __comp) {
  _RandomAccessIter __next = __last;
  --__next;
  while (__comp(__val, *__next)) {
   
    *__last = *__next;
    __last = __next;
    --__next;
  }
  *__last = __val;
}
template <class _RandomAccessIter, class _Tp, class _Compare>
inline void __linear_insert(_RandomAccessIter __first,
                            _RandomAccessIter __last, _Tp __val, _Compare __comp) {
  if (__comp(__val, *__first)) {
   
    copy_backward(__first, __last, __last + 1);
    *__first = __val;
  }
  else
    __unguarded_linear_insert(__last, __val, __comp);
}
template <class _RandomAccessIter, class _Tp, class _Compare>
void __insertion_sort(_RandomAccessIter __first,
                      _RandomAccessIter __last,
                      _Tp *, _Compare __comp) {
  if (__first == __last) return;
  for (_RandomAccessIter __i = __first + 1; __i != __last; ++__i)
    __linear_insert<_RandomAccessIter, _Tp, _Compare>(__first, __i, *__i, __comp);
}
template <class _RandomAccessIter, class _Tp, class _Compare>
void __unguarded_insertion_sort_aux(_RandomAccessIter __first,
                                    _RandomAccessIter __last,
                                    _Tp*, _Compare __comp) {
  for (_RandomAccessIter __i = __first; __i != __last; ++__i)
    __unguarded_linear_insert<_RandomAccessIter, _Tp, _Compare>(__i, *__i, __comp);
}
template <class _RandomAccessIter, class _Compare>
inline void __unguarded_insertion_sort(_RandomAccessIter __first,
                                       _RandomAccessIter __last,
                                       _Compare __comp) {
  __unguarded_insertion_sort_aux(__first, __last, (typename ::stlp_std::iterator_traits< _RandomAccessIter >::value_type*)0, __comp);
}
template <class _RandomAccessIter, class _Compare>
void __final_insertion_sort(_RandomAccessIter __first,
                            _RandomAccessIter __last, _Compare __comp) {
  if (__last - __first > 16) {
    __insertion_sort(__first, __first + 16, (typename ::stlp_std::iterator_traits< _RandomAccessIter >::value_type*)0, __comp);
    __unguarded_insertion_sort(__first + 16, __last, __comp);
  }
  else
    __insertion_sort(__first, __last, (typename ::stlp_std::iterator_traits< _RandomAccessIter >::value_type*)0, __comp);
}
template <class _RandomAccessIter, class _Tp, class _Size, class _Compare>
void __introsort_loop(_RandomAccessIter __first,
                      _RandomAccessIter __last, _Tp*,
                      _Size __depth_limit, _Compare __comp) {
  while (__last - __first > 16) {
    if (__depth_limit == 0) {
      partial_sort(__first, __last, __last, __comp);
      return;
    }
    --__depth_limit;
    _RandomAccessIter __cut =
      __unguarded_partition(__first, __last,
                            _Tp(__median(*__first,
                                         *(__first + (__last - __first)/2),
                                         *(__last - 1), __comp)),
       __comp);
    __introsort_loop(__cut, __last, (_Tp*) 0, __depth_limit, __comp);
    __last = __cut;
  }
}
}
template <class _RandomAccessIter>
void sort(_RandomAccessIter __first, _RandomAccessIter __last) {
 
  if (__first != __last) {
    ::stlp_std::priv:: __introsort_loop(__first, __last,
                                (typename ::stlp_std::iterator_traits< _RandomAccessIter >::value_type*)0,
                                ::stlp_std::priv:: __lg(__last - __first) * 2,
                                ::stlp_std::priv:: __less((typename ::stlp_std::iterator_traits< _RandomAccessIter >::value_type*)0));
    ::stlp_std::priv:: __final_insertion_sort(__first, __last,
                                      ::stlp_std::priv:: __less((typename ::stlp_std::iterator_traits< _RandomAccessIter >::value_type*)0));
  }
}
template <class _RandomAccessIter, class _Compare>
void sort(_RandomAccessIter __first, _RandomAccessIter __last, _Compare __comp) {
 
  if (__first != __last) {
    ::stlp_std::priv:: __introsort_loop(__first, __last,
                                (typename ::stlp_std::iterator_traits< _RandomAccessIter >::value_type*)0,
                                ::stlp_std::priv:: __lg(__last - __first) * 2, __comp);
    ::stlp_std::priv:: __final_insertion_sort(__first, __last, __comp);
  }
}
namespace priv {
template <class _RandomAccessIter, class _Compare>
void __inplace_stable_sort(_RandomAccessIter __first,
                           _RandomAccessIter __last, _Compare __comp) {
  if (__last - __first < 15) {
    __insertion_sort(__first, __last, (typename ::stlp_std::iterator_traits< _RandomAccessIter >::value_type*)0, __comp);
    return;
  }
  _RandomAccessIter __middle = __first + (__last - __first) / 2;
  __inplace_stable_sort(__first, __middle, __comp);
  __inplace_stable_sort(__middle, __last, __comp);
  __merge_without_buffer(__first, __middle, __last,
                         __middle - __first,
                         __last - __middle,
                         __comp);
}
template <class _RandomAccessIter1, class _RandomAccessIter2,
          class _Distance, class _Compare>
void __merge_sort_loop(_RandomAccessIter1 __first,
                       _RandomAccessIter1 __last,
                       _RandomAccessIter2 __result, _Distance __step_size,
                       _Compare __comp) {
  _Distance __two_step = 2 * __step_size;
  while (__last - __first >= __two_step) {
    __result = merge(__first, __first + __step_size,
                     __first + __step_size, __first + __two_step,
                     __result,
                     __comp);
    __first += __two_step;
  }
  __step_size = (min) (_Distance(__last - __first), __step_size);
  merge(__first, __first + __step_size,
        __first + __step_size, __last,
        __result,
        __comp);
}
const int __stl_chunk_size = 7;
template <class _RandomAccessIter, class _Distance, class _Compare>
void __chunk_insertion_sort(_RandomAccessIter __first,
                            _RandomAccessIter __last,
                            _Distance __chunk_size, _Compare __comp) {
  while (__last - __first >= __chunk_size) {
    __insertion_sort(__first, __first + __chunk_size,
                     (typename ::stlp_std::iterator_traits< _RandomAccessIter >::value_type*)0, __comp);
    __first += __chunk_size;
  }
  __insertion_sort(__first, __last, (typename ::stlp_std::iterator_traits< _RandomAccessIter >::value_type*)0, __comp);
}
template <class _RandomAccessIter, class _Pointer, class _Distance,
          class _Compare>
void __merge_sort_with_buffer(_RandomAccessIter __first,
                              _RandomAccessIter __last, _Pointer __buffer,
                              _Distance*, _Compare __comp) {
  _Distance __len = __last - __first;
  _Pointer __buffer_last = __buffer + __len;
  _Distance __step_size = __stl_chunk_size;
  __chunk_insertion_sort(__first, __last, __step_size, __comp);
  while (__step_size < __len) {
    __merge_sort_loop(__first, __last, __buffer, __step_size, __comp);
    __step_size *= 2;
    __merge_sort_loop(__buffer, __buffer_last, __first, __step_size, __comp);
    __step_size *= 2;
  }
}
template <class _BidirectionalIter1, class _BidirectionalIter2,
          class _Distance>
_BidirectionalIter1 __rotate_adaptive(_BidirectionalIter1 __first,
                                      _BidirectionalIter1 __middle,
                                      _BidirectionalIter1 __last,
                                      _Distance __len1, _Distance __len2,
                                      _BidirectionalIter2 __buffer,
                                      _Distance __buffer_size) {
  if (__len1 > __len2 && __len2 <= __buffer_size) {
    _BidirectionalIter2 __buffer_end = ::stlp_std::copy(__middle, __last, __buffer);
    ::stlp_std::copy_backward(__first, __middle, __last);
    return ::stlp_std::copy(__buffer, __buffer_end, __first);
  }
  else if (__len1 <= __buffer_size) {
    _BidirectionalIter2 __buffer_end = ::stlp_std::copy(__first, __middle, __buffer);
    ::stlp_std::copy(__middle, __last, __first);
    return ::stlp_std::copy_backward(__buffer, __buffer_end, __last);
  }
  else
    return ::stlp_std::priv:: __rotate(__first, __middle, __last);
}
template <class _BidirectionalIter, class _Distance, class _Pointer,
          class _Compare>
void __merge_adaptive(_BidirectionalIter __first,
                      _BidirectionalIter __middle,
                      _BidirectionalIter __last,
                      _Distance __len1, _Distance __len2,
                      _Pointer __buffer, _Distance __buffer_size,
                      _Compare __comp) {
  if (__len1 <= __len2 && __len1 <= __buffer_size) {
    _Pointer __buffer_end = ::stlp_std::copy(__first, __middle, __buffer);
    ::stlp_std::merge(__buffer, __buffer_end, __middle, __last, __first, __comp);
  }
  else if (__len2 <= __buffer_size) {
    _Pointer __buffer_end = ::stlp_std::copy(__middle, __last, __buffer);
    ::stlp_std::priv:: __merge_backward(__first, __middle, __buffer, __buffer_end, __last,
                                __comp);
  }
  else {
    _BidirectionalIter __first_cut = __first;
    _BidirectionalIter __second_cut = __middle;
    _Distance __len11 = 0;
    _Distance __len22 = 0;
    if (__len1 > __len2) {
      __len11 = __len1 / 2;
      ::stlp_std::advance(__first_cut, __len11);
      __second_cut = ::stlp_std::lower_bound(__middle, __last, *__first_cut, __comp);
      __len22 += ::stlp_std::distance(__middle, __second_cut);
    }
    else {
      __len22 = __len2 / 2;
      ::stlp_std::advance(__second_cut, __len22);
      __first_cut = ::stlp_std::upper_bound(__first, __middle, *__second_cut, __comp);
      __len11 += ::stlp_std::distance(__first, __first_cut);
    }
    _BidirectionalIter __new_middle =
      __rotate_adaptive(__first_cut, __middle, __second_cut, __len1 - __len11,
                        __len22, __buffer, __buffer_size);
    __merge_adaptive(__first, __first_cut, __new_middle, __len11,
                     __len22, __buffer, __buffer_size, __comp);
    __merge_adaptive(__new_middle, __second_cut, __last, __len1 - __len11,
                     __len2 - __len22, __buffer, __buffer_size, __comp);
  }
}
template <class _RandomAccessIter, class _Pointer, class _Distance,
          class _Compare>
void __stable_sort_adaptive(_RandomAccessIter __first,
                            _RandomAccessIter __last, _Pointer __buffer,
                            _Distance __buffer_size, _Compare __comp) {
  _Distance __len = (__last - __first + 1) / 2;
  _RandomAccessIter __middle = __first + __len;
  if (__len > __buffer_size) {
    __stable_sort_adaptive(__first, __middle, __buffer, __buffer_size,
                           __comp);
    __stable_sort_adaptive(__middle, __last, __buffer, __buffer_size,
                           __comp);
  }
  else {
    __merge_sort_with_buffer(__first, __middle, __buffer, (_Distance*)0,
                               __comp);
    __merge_sort_with_buffer(__middle, __last, __buffer, (_Distance*)0,
                               __comp);
  }
  __merge_adaptive(__first, __middle, __last, _Distance(__middle - __first),
                   _Distance(__last - __middle), __buffer, __buffer_size,
                   __comp);
}
template <class _RandomAccessIter, class _Tp, class _Distance, class _Compare>
void __stable_sort_aux(_RandomAccessIter __first,
                       _RandomAccessIter __last, _Tp*, _Distance*,
                       _Compare __comp) {
  _Temporary_buffer<_RandomAccessIter, _Tp> buf(__first, __last);
  if (buf.begin() == 0)
    __inplace_stable_sort(__first, __last, __comp);
  else
    __stable_sort_adaptive(__first, __last, buf.begin(),
                           _Distance(buf.size()),
                           __comp);
}
}
template <class _RandomAccessIter>
void stable_sort(_RandomAccessIter __first,
                 _RandomAccessIter __last) {
 
  ::stlp_std::priv:: __stable_sort_aux(__first, __last,
                               (typename ::stlp_std::iterator_traits< _RandomAccessIter >::value_type*)0,
                               (typename ::stlp_std::iterator_traits< _RandomAccessIter >::difference_type*)0,
                               ::stlp_std::priv:: __less((typename ::stlp_std::iterator_traits< _RandomAccessIter >::value_type*)0));
}
template <class _RandomAccessIter, class _Compare>
void stable_sort(_RandomAccessIter __first,
                 _RandomAccessIter __last, _Compare __comp) {
 
  ::stlp_std::priv:: __stable_sort_aux(__first, __last,
                               (typename ::stlp_std::iterator_traits< _RandomAccessIter >::value_type*)0,
                               (typename ::stlp_std::iterator_traits< _RandomAccessIter >::difference_type*)0,
                               __comp);
}
namespace priv {
template <class _RandomAccessIter, class _Tp, class _Compare>
void __partial_sort(_RandomAccessIter __first, _RandomAccessIter __middle,
                    _RandomAccessIter __last, _Tp*, _Compare __comp) {
  make_heap(__first, __middle, __comp);
  for (_RandomAccessIter __i = __middle; __i < __last; ++__i) {
    if (__comp(*__i, *__first)) {
     
      __pop_heap(__first, __middle, __i, _Tp(*__i), __comp,
                 (typename ::stlp_std::iterator_traits< _RandomAccessIter >::difference_type*)0);
    }
  }
  sort_heap(__first, __middle, __comp);
}
}
template <class _RandomAccessIter>
void partial_sort(_RandomAccessIter __first,_RandomAccessIter __middle,
                  _RandomAccessIter __last) {
 
 
  ::stlp_std::priv:: __partial_sort(__first, __middle, __last, (typename ::stlp_std::iterator_traits< _RandomAccessIter >::value_type*)0,
                            ::stlp_std::priv:: __less((typename ::stlp_std::iterator_traits< _RandomAccessIter >::value_type*)0));
}
template <class _RandomAccessIter, class _Compare>
void partial_sort(_RandomAccessIter __first,_RandomAccessIter __middle,
                  _RandomAccessIter __last, _Compare __comp) {
 
 
  ::stlp_std::priv:: __partial_sort(__first, __middle, __last, (typename ::stlp_std::iterator_traits< _RandomAccessIter >::value_type*)0, __comp);
}
namespace priv {
template <class _InputIter, class _RandomAccessIter, class _Compare,
          class _Distance, class _Tp>
_RandomAccessIter __partial_sort_copy(_InputIter __first,
                                      _InputIter __last,
                                      _RandomAccessIter __result_first,
                                      _RandomAccessIter __result_last,
                                      _Compare __comp, _Distance*, _Tp*) {
  if (__result_first == __result_last) return __result_last;
  _RandomAccessIter __result_real_last = __result_first;
  while(__first != __last && __result_real_last != __result_last) {
    *__result_real_last = *__first;
    ++__result_real_last;
    ++__first;
  }
  make_heap(__result_first, __result_real_last, __comp);
  while (__first != __last) {
    if (__comp(*__first, *__result_first)) {
     
      __adjust_heap(__result_first, _Distance(0),
                    _Distance(__result_real_last - __result_first),
                    _Tp(*__first),
                    __comp);
    }
    ++__first;
  }
  sort_heap(__result_first, __result_real_last, __comp);
  return __result_real_last;
}
}
template <class _InputIter, class _RandomAccessIter>
_RandomAccessIter
partial_sort_copy(_InputIter __first, _InputIter __last,
                  _RandomAccessIter __result_first, _RandomAccessIter __result_last) {
 
 
  return ::stlp_std::priv:: __partial_sort_copy(__first, __last, __result_first, __result_last,
                                        ::stlp_std::priv:: __less((typename ::stlp_std::iterator_traits< _InputIter >::value_type*)0),
                                        (typename ::stlp_std::iterator_traits< _RandomAccessIter >::difference_type*)0,
                                        (typename ::stlp_std::iterator_traits< _InputIter >::value_type*)0);
}
template <class _InputIter, class _RandomAccessIter, class _Compare>
_RandomAccessIter
partial_sort_copy(_InputIter __first, _InputIter __last,
                  _RandomAccessIter __result_first,
                  _RandomAccessIter __result_last, _Compare __comp) {
 
 
  return ::stlp_std::priv:: __partial_sort_copy(__first, __last, __result_first, __result_last,
                                        __comp,
                                        (typename ::stlp_std::iterator_traits< _RandomAccessIter >::difference_type*)0,
                                        (typename ::stlp_std::iterator_traits< _InputIter >::value_type*)0);
}
namespace priv {
template <class _RandomAccessIter, class _Tp, class _Compare>
void __nth_element(_RandomAccessIter __first, _RandomAccessIter __nth,
                   _RandomAccessIter __last, _Tp*, _Compare __comp) {
  while (__last - __first > 3) {
    _RandomAccessIter __cut =
      __unguarded_partition(__first, __last,
                            _Tp(__median(*__first,
                                         *(__first + (__last - __first)/2),
                                         *(__last - 1),
                                         __comp)),
                            __comp);
    if (__cut <= __nth)
      __first = __cut;
    else
      __last = __cut;
  }
  __insertion_sort(__first, __last, (typename ::stlp_std::iterator_traits< _RandomAccessIter >::value_type*)0, __comp);
}
}
template <class _RandomAccessIter>
void nth_element(_RandomAccessIter __first, _RandomAccessIter __nth,
                 _RandomAccessIter __last) {
 
 
  ::stlp_std::priv:: __nth_element(__first, __nth, __last, (typename ::stlp_std::iterator_traits< _RandomAccessIter >::value_type*)0,
                           ::stlp_std::priv:: __less((typename ::stlp_std::iterator_traits< _RandomAccessIter >::value_type*)0));
}
template <class _RandomAccessIter, class _Compare>
void nth_element(_RandomAccessIter __first, _RandomAccessIter __nth,
                 _RandomAccessIter __last, _Compare __comp) {
 
 
  ::stlp_std::priv:: __nth_element(__first, __nth, __last, (typename ::stlp_std::iterator_traits< _RandomAccessIter >::value_type*)0, __comp);
}
namespace priv {
template <class _ForwardIter, class _Tp,
          class _Compare1, class _Compare2, class _Distance>
_ForwardIter __upper_bound(_ForwardIter __first, _ForwardIter __last, const _Tp& __val,
                           _Compare1 __comp1, _Compare2 __comp2, _Distance*) {
  _Distance __len = ::stlp_std::distance(__first, __last);
  _Distance __half;
  while (__len > 0) {
    __half = __len >> 1;
    _ForwardIter __middle = __first;
    ::stlp_std::advance(__middle, __half);
    if (__comp2(__val, *__middle)) {
     
      __len = __half;
    }
    else {
      __first = __middle;
      ++__first;
      __len = __len - __half - 1;
    }
  }
  return __first;
}
template <class _ForwardIter, class _Tp,
          class _Compare1, class _Compare2, class _Distance>
pair<_ForwardIter, _ForwardIter>
__equal_range(_ForwardIter __first, _ForwardIter __last, const _Tp& __val,
              _Compare1 __comp1, _Compare2 __comp2, _Distance* __dist) {
  _Distance __len = ::stlp_std::distance(__first, __last);
  _Distance __half;
  while (__len > 0) {
    __half = __len >> 1;
    _ForwardIter __middle = __first;
    ::stlp_std::advance(__middle, __half);
    if (__comp1(*__middle, __val)) {
     
      __first = __middle;
      ++__first;
      __len = __len - __half - 1;
    }
    else if (__comp2(__val, *__middle)) {
     
      __len = __half;
    }
    else {
      _ForwardIter __left = ::stlp_std::priv:: __lower_bound(__first, __middle, __val, __comp1, __comp2, __dist);
      if (__comp1(*__left, __val)) {
       
        return pair<_ForwardIter, _ForwardIter>(__left, __left);
      }
      ::stlp_std::advance(__first, __len);
      _ForwardIter __right = ::stlp_std::priv:: __upper_bound(++__middle, __first, __val, __comp1, __comp2, __dist);
      return pair<_ForwardIter, _ForwardIter>(__left, __right);
    }
  }
  return pair<_ForwardIter, _ForwardIter>(__first, __first);
}
}
template <class _InputIter1, class _InputIter2, class _OutputIter>
_OutputIter merge(_InputIter1 __first1, _InputIter1 __last1,
                  _InputIter2 __first2, _InputIter2 __last2,
                  _OutputIter __result) {
 
 
  while (__first1 != __last1 && __first2 != __last2) {
    if (*__first2 < *__first1) {
      *__result = *__first2;
      ++__first2;
    }
    else {
      *__result = *__first1;
      ++__first1;
    }
    ++__result;
  }
  return ::stlp_std::copy(__first2, __last2, ::stlp_std::copy(__first1, __last1, __result));
}
template <class _InputIter1, class _InputIter2, class _OutputIter,
          class _Compare>
_OutputIter merge(_InputIter1 __first1, _InputIter1 __last1,
                  _InputIter2 __first2, _InputIter2 __last2,
                  _OutputIter __result, _Compare __comp) {
 
 
  while (__first1 != __last1 && __first2 != __last2) {
    if (__comp(*__first2, *__first1)) {
     
      *__result = *__first2;
      ++__first2;
    }
    else {
      *__result = *__first1;
      ++__first1;
    }
    ++__result;
  }
  return ::stlp_std::copy(__first2, __last2, ::stlp_std::copy(__first1, __last1, __result));
}
namespace priv {
template <class _BidirectionalIter, class _Distance, class _Compare>
void __merge_without_buffer(_BidirectionalIter __first,
                            _BidirectionalIter __middle,
                            _BidirectionalIter __last,
                            _Distance __len1, _Distance __len2,
                            _Compare __comp) {
  if (__len1 == 0 || __len2 == 0)
    return;
  if (__len1 + __len2 == 2) {
    if (__comp(*__middle, *__first)) {
     
      iter_swap(__first, __middle);
    }
    return;
  }
  _BidirectionalIter __first_cut = __first;
  _BidirectionalIter __second_cut = __middle;
  _Distance __len11 = 0;
  _Distance __len22 = 0;
  if (__len1 > __len2) {
    __len11 = __len1 / 2;
    ::stlp_std::advance(__first_cut, __len11);
    __second_cut = ::stlp_std::lower_bound(__middle, __last, *__first_cut, __comp);
    __len22 += ::stlp_std::distance(__middle, __second_cut);
  }
  else {
    __len22 = __len2 / 2;
    ::stlp_std::advance(__second_cut, __len22);
    __first_cut = ::stlp_std::upper_bound(__first, __middle, *__second_cut, __comp);
    __len11 += ::stlp_std::distance(__first, __first_cut);
  }
  _BidirectionalIter __new_middle
    = ::stlp_std::priv:: __rotate(__first_cut, __middle, __second_cut);
  __merge_without_buffer(__first, __first_cut, __new_middle, __len11, __len22,
                         __comp);
  __merge_without_buffer(__new_middle, __second_cut, __last, __len1 - __len11,
                         __len2 - __len22, __comp);
}
template <class _BidirectionalIter1, class _BidirectionalIter2,
          class _BidirectionalIter3, class _Compare>
_BidirectionalIter3 __merge_backward(_BidirectionalIter1 __first1,
                                     _BidirectionalIter1 __last1,
                                     _BidirectionalIter2 __first2,
                                     _BidirectionalIter2 __last2,
                                     _BidirectionalIter3 __result,
                                     _Compare __comp) {
  if (__first1 == __last1)
    return copy_backward(__first2, __last2, __result);
  if (__first2 == __last2)
    return copy_backward(__first1, __last1, __result);
  --__last1;
  --__last2;
  for (;;) {
    if (__comp(*__last2, *__last1)) {
     
      *--__result = *__last1;
      if (__first1 == __last1)
        return copy_backward(__first2, ++__last2, __result);
      --__last1;
    }
    else {
      *--__result = *__last2;
      if (__first2 == __last2)
        return copy_backward(__first1, ++__last1, __result);
      --__last2;
    }
  }
}
template <class _BidirectionalIter, class _Tp,
          class _Distance, class _Compare>
inline void __inplace_merge_aux(_BidirectionalIter __first,
                                _BidirectionalIter __middle,
                                _BidirectionalIter __last, _Tp*, _Distance*,
                                _Compare __comp) {
  _Distance __len1 = ::stlp_std::distance(__first, __middle);
  _Distance __len2 = ::stlp_std::distance(__middle, __last);
  _Temporary_buffer<_BidirectionalIter, _Tp> __buf(__first, __last);
  if (__buf.begin() == 0)
    __merge_without_buffer(__first, __middle, __last, __len1, __len2, __comp);
  else
    __merge_adaptive(__first, __middle, __last, __len1, __len2,
                     __buf.begin(), _Distance(__buf.size()),
                     __comp);
}
}
template <class _BidirectionalIter>
void inplace_merge(_BidirectionalIter __first,
                   _BidirectionalIter __middle,
                   _BidirectionalIter __last) {
 
 
  if (__first == __middle || __middle == __last)
    return;
  ::stlp_std::priv:: __inplace_merge_aux(__first, __middle, __last,
                                 (typename ::stlp_std::iterator_traits< _BidirectionalIter >::value_type*)0, (typename ::stlp_std::iterator_traits< _BidirectionalIter >::difference_type*)0,
                                 ::stlp_std::priv:: __less((typename ::stlp_std::iterator_traits< _BidirectionalIter >::value_type*)0));
}
template <class _BidirectionalIter, class _Compare>
void inplace_merge(_BidirectionalIter __first,
                   _BidirectionalIter __middle,
                   _BidirectionalIter __last, _Compare __comp) {
 
 
  if (__first == __middle || __middle == __last)
    return;
  ::stlp_std::priv:: __inplace_merge_aux(__first, __middle, __last,
                                 (typename ::stlp_std::iterator_traits< _BidirectionalIter >::value_type*)0, (typename ::stlp_std::iterator_traits< _BidirectionalIter >::difference_type*)0,
                                 __comp);
}
namespace priv {
template <class _InputIter1, class _InputIter2, class _Compare>
bool __includes(_InputIter1 __first1, _InputIter1 __last1,
                _InputIter2 __first2, _InputIter2 __last2, _Compare __comp) {
 
 
  while (__first1 != __last1 && __first2 != __last2)
    if (__comp(*__first2, *__first1)) {
     
      return false;
    }
    else if (__comp(*__first1, *__first2))
      ++__first1;
    else
      ++__first1, ++__first2;
  return __first2 == __last2;
}
}
template <class _InputIter1, class _InputIter2, class _Compare>
bool includes(_InputIter1 __first1, _InputIter1 __last1,
              _InputIter2 __first2, _InputIter2 __last2, _Compare __comp) {
  return ::stlp_std::priv:: __includes(__first1, __last1, __first2, __last2, __comp);
}
template <class _InputIter1, class _InputIter2>
bool includes(_InputIter1 __first1, _InputIter1 __last1,
              _InputIter2 __first2, _InputIter2 __last2) {
  return ::stlp_std::priv:: __includes(__first1, __last1, __first2, __last2,
                               ::stlp_std::priv:: __less((typename ::stlp_std::iterator_traits< _InputIter1 >::value_type*)0));
}
namespace priv {
template <class _InputIter1, class _InputIter2, class _OutputIter,
          class _Compare>
_OutputIter __set_union(_InputIter1 __first1, _InputIter1 __last1,
                        _InputIter2 __first2, _InputIter2 __last2,
                        _OutputIter __result, _Compare __comp) {
 
 
  while (__first1 != __last1 && __first2 != __last2) {
    if (__comp(*__first1, *__first2)) {
     
      *__result = *__first1;
      ++__first1;
    }
    else if (__comp(*__first2, *__first1)) {
     
      *__result = *__first2;
      ++__first2;
    }
    else {
      *__result = *__first1;
      ++__first1;
      ++__first2;
    }
    ++__result;
  }
  return ::stlp_std::copy(__first2, __last2, ::stlp_std::copy(__first1, __last1, __result));
}
}
template <class _InputIter1, class _InputIter2, class _OutputIter>
_OutputIter set_union(_InputIter1 __first1, _InputIter1 __last1,
                      _InputIter2 __first2, _InputIter2 __last2,
                      _OutputIter __result) {
  return ::stlp_std::priv:: __set_union(__first1, __last1, __first2, __last2, __result,
                                ::stlp_std::priv:: __less((typename ::stlp_std::iterator_traits< _InputIter1 >::value_type*)0));
}
template <class _InputIter1, class _InputIter2, class _OutputIter,
          class _Compare>
_OutputIter set_union(_InputIter1 __first1, _InputIter1 __last1,
                      _InputIter2 __first2, _InputIter2 __last2,
                      _OutputIter __result, _Compare __comp) {
  return ::stlp_std::priv:: __set_union(__first1, __last1, __first2, __last2, __result, __comp);
}
namespace priv {
template <class _InputIter1, class _InputIter2, class _OutputIter,
          class _Compare>
_OutputIter __set_intersection(_InputIter1 __first1, _InputIter1 __last1,
                               _InputIter2 __first2, _InputIter2 __last2,
                               _OutputIter __result, _Compare __comp) {
 
 
  while (__first1 != __last1 && __first2 != __last2)
    if (__comp(*__first1, *__first2)) {
     
      ++__first1;
    }
    else if (__comp(*__first2, *__first1))
      ++__first2;
    else {
      *__result = *__first1;
      ++__first1;
      ++__first2;
      ++__result;
    }
  return __result;
}
}
template <class _InputIter1, class _InputIter2, class _OutputIter>
_OutputIter set_intersection(_InputIter1 __first1, _InputIter1 __last1,
                             _InputIter2 __first2, _InputIter2 __last2,
                             _OutputIter __result) {
  return ::stlp_std::priv:: __set_intersection(__first1, __last1, __first2, __last2, __result,
                                       ::stlp_std::priv:: __less((typename ::stlp_std::iterator_traits< _InputIter1 >::value_type*)0));
}
template <class _InputIter1, class _InputIter2, class _OutputIter,
          class _Compare>
_OutputIter set_intersection(_InputIter1 __first1, _InputIter1 __last1,
                             _InputIter2 __first2, _InputIter2 __last2,
                             _OutputIter __result, _Compare __comp) {
  return ::stlp_std::priv:: __set_intersection(__first1, __last1, __first2, __last2, __result, __comp);
}
namespace priv {
template <class _InputIter1, class _InputIter2, class _OutputIter,
          class _Compare>
_OutputIter __set_difference(_InputIter1 __first1, _InputIter1 __last1,
                             _InputIter2 __first2, _InputIter2 __last2,
                             _OutputIter __result, _Compare __comp) {
 
 
  while (__first1 != __last1 && __first2 != __last2)
    if (__comp(*__first1, *__first2)) {
     
      *__result = *__first1;
      ++__first1;
      ++__result;
    }
    else if (__comp(*__first2, *__first1))
      ++__first2;
    else {
      ++__first1;
      ++__first2;
    }
  return ::stlp_std::copy(__first1, __last1, __result);
}
}
template <class _InputIter1, class _InputIter2, class _OutputIter>
_OutputIter set_difference(_InputIter1 __first1, _InputIter1 __last1,
                           _InputIter2 __first2, _InputIter2 __last2,
                           _OutputIter __result) {
  return ::stlp_std::priv:: __set_difference(__first1, __last1, __first2, __last2, __result,
                                     ::stlp_std::priv:: __less((typename ::stlp_std::iterator_traits< _InputIter1 >::value_type*)0));
}
template <class _InputIter1, class _InputIter2, class _OutputIter,
          class _Compare>
_OutputIter set_difference(_InputIter1 __first1, _InputIter1 __last1,
                           _InputIter2 __first2, _InputIter2 __last2,
                           _OutputIter __result, _Compare __comp) {
  return ::stlp_std::priv:: __set_difference(__first1, __last1, __first2, __last2, __result, __comp);
}
namespace priv {
template <class _InputIter1, class _InputIter2, class _OutputIter, class _Compare>
_OutputIter
__set_symmetric_difference(_InputIter1 __first1, _InputIter1 __last1,
                           _InputIter2 __first2, _InputIter2 __last2,
                           _OutputIter __result, _Compare __comp) {
 
 
  while (__first1 != __last1 && __first2 != __last2) {
    if (__comp(*__first1, *__first2)) {
     
      *__result = *__first1;
      ++__first1;
      ++__result;
    }
    else if (__comp(*__first2, *__first1)) {
      *__result = *__first2;
      ++__first2;
      ++__result;
    }
    else {
      ++__first1;
      ++__first2;
    }
  }
  return ::stlp_std::copy(__first2, __last2, ::stlp_std::copy(__first1, __last1, __result));
}
}
template <class _InputIter1, class _InputIter2, class _OutputIter>
_OutputIter
set_symmetric_difference(_InputIter1 __first1, _InputIter1 __last1,
                         _InputIter2 __first2, _InputIter2 __last2,
                         _OutputIter __result) {
  return ::stlp_std::priv:: __set_symmetric_difference(__first1, __last1, __first2, __last2, __result,
                                               ::stlp_std::priv:: __less((typename ::stlp_std::iterator_traits< _InputIter1 >::value_type*)0));
}
template <class _InputIter1, class _InputIter2, class _OutputIter, class _Compare>
_OutputIter
set_symmetric_difference(_InputIter1 __first1, _InputIter1 __last1,
                         _InputIter2 __first2, _InputIter2 __last2,
                         _OutputIter __result,
                         _Compare __comp) {
  return ::stlp_std::priv:: __set_symmetric_difference(__first1, __last1, __first2, __last2, __result, __comp);
}
template <class _ForwardIter>
_ForwardIter max_element(_ForwardIter __first, _ForwardIter __last) {
 
  if (__first == __last) return __first;
  _ForwardIter __result = __first;
  while (++__first != __last)
    if (*__result < *__first) {
     
      __result = __first;
    }
  return __result;
}
template <class _ForwardIter, class _Compare>
_ForwardIter max_element(_ForwardIter __first, _ForwardIter __last,
                         _Compare __comp) {
 
  if (__first == __last) return __first;
  _ForwardIter __result = __first;
  while (++__first != __last) {
    if (__comp(*__result, *__first)) {
     
      __result = __first;
    }
  }
  return __result;
}
template <class _ForwardIter>
_ForwardIter min_element(_ForwardIter __first, _ForwardIter __last) {
 
  if (__first == __last) return __first;
  _ForwardIter __result = __first;
  while (++__first != __last)
    if (*__first < *__result) {
     
      __result = __first;
    }
  return __result;
}
template <class _ForwardIter, class _Compare>
_ForwardIter min_element(_ForwardIter __first, _ForwardIter __last,
                         _Compare __comp) {
 
  if (__first == __last) return __first;
  _ForwardIter __result = __first;
  while (++__first != __last) {
    if (__comp(*__first, *__result)) {
     
      __result = __first;
    }
  }
  return __result;
}
namespace priv {
template <class _BidirectionalIter, class _Compare>
bool __next_permutation(_BidirectionalIter __first, _BidirectionalIter __last,
                        _Compare __comp) {
 
  if (__first == __last)
    return false;
  _BidirectionalIter __i = __first;
  ++__i;
  if (__i == __last)
    return false;
  __i = __last;
  --__i;
  for(;;) {
    _BidirectionalIter __ii = __i;
    --__i;
    if (__comp(*__i, *__ii)) {
     
      _BidirectionalIter __j = __last;
      while (!__comp(*__i, *--__j)) {}
      iter_swap(__i, __j);
      reverse(__ii, __last);
      return true;
    }
    if (__i == __first) {
      reverse(__first, __last);
      return false;
    }
  }
}
}
template <class _BidirectionalIter>
bool next_permutation(_BidirectionalIter __first, _BidirectionalIter __last) {
 
  return ::stlp_std::priv:: __next_permutation(__first, __last,
                                       ::stlp_std::priv:: __less((typename ::stlp_std::iterator_traits< _BidirectionalIter >::value_type*)0));
}
template <class _BidirectionalIter, class _Compare>
bool next_permutation(_BidirectionalIter __first, _BidirectionalIter __last,
                      _Compare __comp) {
 
  return ::stlp_std::priv:: __next_permutation(__first, __last, __comp);
}
namespace priv {
template <class _BidirectionalIter, class _Compare>
bool __prev_permutation(_BidirectionalIter __first, _BidirectionalIter __last,
                        _Compare __comp) {
  if (__first == __last)
    return false;
  _BidirectionalIter __i = __first;
  ++__i;
  if (__i == __last)
    return false;
  __i = __last;
  --__i;
  for(;;) {
    _BidirectionalIter __ii = __i;
    --__i;
    if (__comp(*__ii, *__i)) {
     
      _BidirectionalIter __j = __last;
      while (!__comp(*--__j, *__i)) {}
      iter_swap(__i, __j);
      reverse(__ii, __last);
      return true;
    }
    if (__i == __first) {
      reverse(__first, __last);
      return false;
    }
  }
}
}
template <class _BidirectionalIter>
bool prev_permutation(_BidirectionalIter __first, _BidirectionalIter __last) {
 
  return ::stlp_std::priv:: __prev_permutation(__first, __last,
                                       ::stlp_std::priv:: __less((typename ::stlp_std::iterator_traits< _BidirectionalIter >::value_type*)0));
}
template <class _BidirectionalIter, class _Compare>
bool prev_permutation(_BidirectionalIter __first, _BidirectionalIter __last,
                      _Compare __comp) {
 
  return ::stlp_std::priv:: __prev_permutation(__first, __last, __comp);
}
namespace priv {
template <class _RandomAccessIter, class _Distance, class _StrictWeakOrdering>
bool __is_heap(_RandomAccessIter __first, _StrictWeakOrdering __comp,
               _Distance __n) {
  _Distance __parent = 0;
  for (_Distance __child = 1; __child < __n; ++__child) {
    if (__comp(__first[__parent], __first[__child])) {
     
      return false;
    }
    if ((__child & 1) == 0)
      ++__parent;
  }
  return true;
}
}
template <class _RandomAccessIter>
bool is_heap(_RandomAccessIter __first, _RandomAccessIter __last) {
 
  return ::stlp_std::priv:: __is_heap(__first, ::stlp_std::priv:: __less((typename ::stlp_std::iterator_traits< _RandomAccessIter >::value_type*)0), __last - __first);
}
template <class _RandomAccessIter, class _StrictWeakOrdering>
bool is_heap(_RandomAccessIter __first, _RandomAccessIter __last,
             _StrictWeakOrdering __comp) {
 
  return ::stlp_std::priv:: __is_heap(__first, __comp, __last - __first);
}
namespace priv {
template <class _ForwardIter, class _StrictWeakOrdering>
bool __is_sorted(_ForwardIter __first, _ForwardIter __last,
                 _StrictWeakOrdering __comp) {
 
  if (__first == __last)
    return true;
  _ForwardIter __next = __first;
  for (++__next; __next != __last; __first = __next, ++__next) {
    if (__comp(*__next, *__first)) {
     
      return false;
    }
  }
  return true;
}
}
}
namespace stlp_std {
namespace priv {
template <class _Tp, class _Alloc>
class _Vector_base {
public:
  typedef _Vector_base<_Tp, _Alloc> _Self;
 
  typedef _Alloc allocator_type;
  typedef _Tp* pointer;
  typedef _STLP_alloc_proxy<pointer, _Tp, allocator_type> _AllocProxy;
  _Vector_base(const _Alloc& __a)
    : _M_start(0), _M_finish(0), _M_end_of_storage(__a, 0) {}
  _Vector_base(size_t __n, const _Alloc& __a)
    : _M_start(0), _M_finish(0), _M_end_of_storage(__a, 0) {
    _M_start = _M_end_of_storage.allocate(__n, __n);
    _M_finish = _M_start;
    _M_end_of_storage._M_data = _M_start + __n;
   
  }
  _Vector_base(__move_source<_Self> src)
    : _M_start(src.get()._M_start), _M_finish(src.get()._M_finish),
      _M_end_of_storage(__move_source<_AllocProxy>(src.get()._M_end_of_storage)) {
    src.get()._M_finish = src.get()._M_end_of_storage._M_data = src.get()._M_start = 0;
  }
  ~_Vector_base() {
    if (_M_start != pointer())
      _M_end_of_storage.deallocate(_M_start, _M_end_of_storage._M_data - _M_start);
  }
protected:
  void __attribute__((noreturn)) _M_throw_length_error() const;
  void __attribute__((noreturn)) _M_throw_out_of_range() const;
  pointer _M_start;
  pointer _M_finish;
  _AllocProxy _M_end_of_storage;
};
}
template <class _Tp, class _Alloc = allocator<_Tp> >
class vector : protected ::stlp_std::priv:: _Vector_base<_Tp, _Alloc>
{
private:
  typedef ::stlp_std::priv:: _Vector_base<_Tp, _Alloc> _Base;
  typedef vector<_Tp, _Alloc> _Self;
public:
 
  typedef typename _Base::allocator_type allocator_type;
  typedef _Tp value_type;
  typedef value_type* pointer;
  typedef const value_type* const_pointer;
  typedef value_type* iterator;
  typedef const value_type* const_iterator;
  typedef value_type& reference;
  typedef const value_type& const_reference;
  typedef size_t size_type;
  typedef ptrdiff_t difference_type;
  typedef random_access_iterator_tag _Iterator_category;
  typedef ::stlp_std::reverse_iterator<const_iterator> const_reverse_iterator; typedef ::stlp_std::reverse_iterator<iterator> reverse_iterator;
  allocator_type get_allocator() const
  { return (const allocator_type&)this->_M_end_of_storage; }
private:
  void _M_insert_overflow_aux(pointer __pos, const _Tp& __x, const __false_type& ,
                              size_type __fill_len, bool __atend);
  void _M_insert_overflow_aux(pointer __pos, const _Tp& __x, const __true_type& ,
                              size_type __fill_len, bool __atend) {
    if (_M_is_inside(__x)) {
      value_type __x_copy = __x;
      _M_insert_overflow_aux(__pos, __x_copy, __false_type(), __fill_len, __atend);
      return;
    }
    _M_insert_overflow_aux(__pos, __x, __false_type(), __fill_len, __atend);
  }
  void _M_insert_overflow(pointer __pos, const _Tp& __x, const __false_type& ,
                          size_type __fill_len, bool __atend = false) {
    typedef typename __move_traits<_Tp>::implemented _Movable;
    _M_insert_overflow_aux(__pos, __x, _Movable(), __fill_len, __atend);
  }
  void _M_insert_overflow(pointer __pos, const _Tp& __x, const __true_type& ,
                          size_type __fill_len, bool __atend = false);
  void _M_range_check(size_type __n) const {
    if (__n >= size_type(this->_M_finish - this->_M_start))
      this->_M_throw_out_of_range();
  }
  size_type _M_compute_next_size(size_type __n) {
    const size_type __size = size();
    if (__n > max_size() - __size)
      this->_M_throw_length_error();
    size_type __len = __size + (max)(__n, __size);
    if (__len > max_size() || __len < __size)
      __len = max_size();
    return __len;
  }
public:
  iterator begin() { return this->_M_start; }
  const_iterator begin() const { return this->_M_start; }
  iterator end() { return this->_M_finish; }
  const_iterator end() const { return this->_M_finish; }
  reverse_iterator rbegin() { return reverse_iterator(end()); }
  const_reverse_iterator rbegin() const { return const_reverse_iterator(end()); }
  reverse_iterator rend() { return reverse_iterator(begin()); }
  const_reverse_iterator rend() const { return const_reverse_iterator(begin()); }
  size_type size() const { return size_type(this->_M_finish - this->_M_start); }
  size_type max_size() const {
    size_type __vector_max_size = size_type(-1) / sizeof(_Tp);
    typename allocator_type::size_type __alloc_max_size = this->_M_end_of_storage.max_size();
    return (__alloc_max_size < __vector_max_size)?__alloc_max_size:__vector_max_size;
  }
  size_type capacity() const { return size_type(this->_M_end_of_storage._M_data - this->_M_start); }
  bool empty() const { return this->_M_start == this->_M_finish; }
  reference operator[](size_type __n) { return *(begin() + __n); }
  const_reference operator[](size_type __n) const { return *(begin() + __n); }
  reference front() { return *begin(); }
  const_reference front() const { return *begin(); }
  reference back() { return *(end() - 1); }
  const_reference back() const { return *(end() - 1); }
  reference at(size_type __n) { _M_range_check(__n); return (*this)[__n]; }
  const_reference at(size_type __n) const { _M_range_check(__n); return (*this)[__n]; }
  explicit vector(const allocator_type& __a = allocator_type())
    : ::stlp_std::priv:: _Vector_base<_Tp, _Alloc>(__a) {}
private:
  void _M_initialize(size_type __n, const _Tp& __val = _Tp())
  { this->_M_finish = ::stlp_std::priv:: __uninitialized_init(this->_M_start, __n, __val); }
public:
  explicit vector(size_type __n)
    : ::stlp_std::priv:: _Vector_base<_Tp, _Alloc>(__n, allocator_type())
  { _M_initialize(__n); }
  vector(size_type __n, const _Tp& __val, const allocator_type& __a = allocator_type())
    : ::stlp_std::priv:: _Vector_base<_Tp, _Alloc>(__n, __a)
  { this->_M_finish = ::stlp_std::priv:: __uninitialized_fill_n(this->_M_start, __n, __val); }
  vector(const _Self& __x)
    : ::stlp_std::priv:: _Vector_base<_Tp, _Alloc>(__x.size(), __x.get_allocator()) {
    typedef typename __type_traits<_Tp>::has_trivial_copy_constructor _TrivialUCopy;
    this->_M_finish = ::stlp_std::priv:: __ucopy_ptrs(__x.begin(), __x.end(), this->_M_start, _TrivialUCopy());
  }
  vector(__move_source<_Self> src)
    : ::stlp_std::priv:: _Vector_base<_Tp, _Alloc>(__move_source<_Base>(src.get()))
  {}
private:
  template <class _Integer>
  void _M_initialize_aux(_Integer __n, _Integer __val,
                         const __true_type& ) {
    size_type __real_n = __n;
    this->_M_start = this->_M_end_of_storage.allocate(__n, __real_n);
    this->_M_end_of_storage._M_data = this->_M_start + __real_n;
    this->_M_finish = ::stlp_std::priv:: __uninitialized_fill_n(this->_M_start, __n, __val);
  }
  template <class _InputIterator>
  void _M_initialize_aux(_InputIterator __first, _InputIterator __last,
                         const __false_type& )
  { _M_range_initialize(__first, __last, typename ::stlp_std::iterator_traits< _InputIterator >::iterator_category()); }
public:
  template <class _InputIterator>
  vector(_InputIterator __first, _InputIterator __last,
               const allocator_type& __a = allocator_type() )
    : ::stlp_std::priv:: _Vector_base<_Tp, _Alloc>(__a) {
    typedef typename _IsIntegral<_InputIterator>::_Ret _Integral;
    _M_initialize_aux(__first, __last, _Integral());
  }
  ~vector() { ::stlp_std::_Destroy_Range(rbegin(), rend()); }
  _Self& operator=(const _Self& __x);
  void reserve(size_type __n);
  void assign(size_type __n, const _Tp& __val) { _M_fill_assign(__n, __val); }
  void _M_fill_assign(size_type __n, const _Tp& __val);
  template <class _ForwardIter>
  void _M_assign_aux(_ForwardIter __first, _ForwardIter __last, const forward_iterator_tag &) {
    const size_type __len = ::stlp_std::distance(__first, __last);
    if (__len > capacity()) {
      size_type __n = __len;
      iterator __tmp = _M_allocate_and_copy(__n, __first, __last);
      _M_clear();
      _M_set(__tmp, __tmp + __len, __tmp + __n);
    }
    else if (size() >= __len) {
      iterator __new_finish = copy(__first, __last, this->_M_start);
      ::stlp_std::_Destroy_Range(__new_finish, this->_M_finish);
      this->_M_finish = __new_finish;
    }
    else {
      _ForwardIter __mid = __first;
      ::stlp_std::advance(__mid, size());
      ::stlp_std::copy(__first, __mid, this->_M_start);
      this->_M_finish = ::stlp_std::uninitialized_copy(__mid, __last, this->_M_finish);
    }
  }
  template <class _InputIter>
  void _M_assign_aux(_InputIter __first, _InputIter __last,
                     const input_iterator_tag &) {
    iterator __cur = begin();
    for ( ; __first != __last && __cur != end(); ++__cur, ++__first)
      *__cur = *__first;
    if (__first == __last)
      erase(__cur, end());
    else
      insert(end(), __first, __last);
  }
  template <class _Integer>
  void _M_assign_dispatch(_Integer __n, _Integer __val,
                          const __true_type& )
  { _M_fill_assign(__n, __val); }
  template <class _InputIter>
  void _M_assign_dispatch(_InputIter __first, _InputIter __last,
                          const __false_type& )
  { _M_assign_aux(__first, __last, typename ::stlp_std::iterator_traits< _InputIter >::iterator_category()); }
  template <class _InputIterator>
  void assign(_InputIterator __first, _InputIterator __last) {
    typedef typename _IsIntegral<_InputIterator>::_Ret _Integral;
    _M_assign_dispatch(__first, __last, _Integral());
  }
  void push_back(const _Tp& __x = _Tp()) {
    if (this->_M_finish != this->_M_end_of_storage._M_data) {
      _Copy_Construct(this->_M_finish, __x);
      ++this->_M_finish;
    }
    else {
      typedef typename __type_traits<_Tp>::has_trivial_assignment_operator _TrivialCopy;
      _M_insert_overflow(this->_M_finish, __x, _TrivialCopy(), 1, true);
    }
  }
  iterator insert(iterator __pos, const _Tp& __x = _Tp());
  void swap(_Self& __x) {
    ::stlp_std::swap(this->_M_start, __x._M_start);
    ::stlp_std::swap(this->_M_finish, __x._M_finish);
    this->_M_end_of_storage.swap(__x._M_end_of_storage);
  }
private:
  void _M_fill_insert_aux (iterator __pos, size_type __n, const _Tp& __x, const __true_type& );
  void _M_fill_insert_aux (iterator __pos, size_type __n, const _Tp& __x, const __false_type& );
  void _M_fill_insert (iterator __pos, size_type __n, const _Tp& __x);
  bool _M_is_inside(const value_type& __x) const {
    return (&__x >= this->_M_start && &__x < this->_M_finish);
  }
  template <class _ForwardIterator>
  void _M_range_insert_realloc(iterator __pos,
                               _ForwardIterator __first, _ForwardIterator __last,
                               size_type __n) {
    typedef typename __type_traits<_Tp>::has_trivial_copy_constructor _TrivialUCopy;
    typedef typename __move_traits<_Tp>::implemented _Movable;
    size_type __len = _M_compute_next_size(__n);
    pointer __new_start = this->_M_end_of_storage.allocate(__len, __len);
    pointer __new_finish = __new_start;
    try {
      __new_finish = ::stlp_std::priv:: __uninitialized_move(this->_M_start, __pos, __new_start, _TrivialUCopy(), _Movable());
      __new_finish = uninitialized_copy(__first, __last, __new_finish);
      __new_finish = ::stlp_std::priv:: __uninitialized_move(__pos, this->_M_finish, __new_finish, _TrivialUCopy(), _Movable());
    }
    catch(...) { (::stlp_std::_Destroy_Range(__new_start,__new_finish), this->_M_end_of_storage.deallocate(__new_start,__len)); throw; }
    _M_clear_after_move();
    _M_set(__new_start, __new_finish, __new_start + __len);
  }
  template <class _ForwardIterator>
  void _M_range_insert_aux(iterator __pos,
                           _ForwardIterator __first, _ForwardIterator __last,
                           size_type __n, const __true_type& ) {
    iterator __src = this->_M_finish - 1;
    iterator __dst = __src + __n;
    for (; __src >= __pos; --__dst, --__src) {
      ::stlp_std::_Move_Construct(__dst, *__src);
      ::stlp_std::_Destroy_Moved(__src);
    }
    uninitialized_copy(__first, __last, __pos);
    this->_M_finish += __n;
  }
  template <class _ForwardIterator>
  void _M_range_insert_aux(iterator __pos,
                           _ForwardIterator __first, _ForwardIterator __last,
                           size_type __n, const __false_type& ) {
    typedef typename __type_traits<_Tp>::has_trivial_copy_constructor _TrivialUCopy;
    typedef typename __type_traits<_Tp>::has_trivial_assignment_operator _TrivialCopy;
    const size_type __elems_after = this->_M_finish - __pos;
    pointer __old_finish = this->_M_finish;
    if (__elems_after > __n) {
      ::stlp_std::priv:: __ucopy_ptrs(this->_M_finish - __n, this->_M_finish, this->_M_finish, _TrivialUCopy());
      this->_M_finish += __n;
      ::stlp_std::priv:: __copy_backward_ptrs(__pos, __old_finish - __n, __old_finish, _TrivialCopy());
      copy(__first, __last, __pos);
    }
    else {
      _ForwardIterator __mid = __first;
      ::stlp_std::advance(__mid, __elems_after);
      uninitialized_copy(__mid, __last, this->_M_finish);
      this->_M_finish += __n - __elems_after;
      ::stlp_std::priv:: __ucopy_ptrs(__pos, __old_finish, this->_M_finish, _TrivialUCopy());
      this->_M_finish += __elems_after;
      copy(__first, __mid, __pos);
    }
  }
  template <class _Integer>
  void _M_insert_dispatch(iterator __pos, _Integer __n, _Integer __val,
                          const __true_type&)
  { _M_fill_insert(__pos, (size_type) __n, (_Tp) __val); }
  template <class _InputIterator>
  void _M_insert_dispatch(iterator __pos,
                          _InputIterator __first, _InputIterator __last,
                          const __false_type&)
  { _M_range_insert(__pos, __first, __last, typename ::stlp_std::iterator_traits< _InputIterator >::iterator_category()); }
public:
  template <class _InputIterator>
  void insert(iterator __pos, _InputIterator __first, _InputIterator __last) {
    typedef typename _IsIntegral<_InputIterator>::_Ret _Integral;
    _M_insert_dispatch(__pos, __first, __last, _Integral());
  }
private:
  template <class _InputIterator>
  void _M_range_insert(iterator __pos,
                       _InputIterator __first, _InputIterator __last,
                       const input_iterator_tag &) {
    for ( ; __first != __last; ++__first) {
      __pos = insert(__pos, *__first);
      ++__pos;
    }
  }
  template <class _ForwardIterator>
  void _M_range_insert(iterator __pos,
                       _ForwardIterator __first, _ForwardIterator __last,
                       const forward_iterator_tag &) {
    typedef typename __move_traits<_Tp>::implemented _Movable;
    if (__first != __last) {
      size_type __n = ::stlp_std::distance(__first, __last);
      if (size_type(this->_M_end_of_storage._M_data - this->_M_finish) >= __n) {
        _M_range_insert_aux(__pos, __first, __last, __n, _Movable());
      }
      else {
        _M_range_insert_realloc(__pos, __first, __last, __n);
      }
    }
  }
public:
  void insert (iterator __pos, size_type __n, const _Tp& __x)
  { _M_fill_insert(__pos, __n, __x); }
  void pop_back() {
    --this->_M_finish;
    ::stlp_std::_Destroy(this->_M_finish);
  }
private:
  iterator _M_erase(iterator __pos, const __true_type& ) {
    ::stlp_std::_Destroy(__pos);
    iterator __dst = __pos, __src = __dst + 1;
    iterator __end = end();
    for (; __src != __end; ++__dst, ++__src) {
      ::stlp_std::_Move_Construct(__dst, *__src);
      ::stlp_std::_Destroy_Moved(__src);
    }
    this->_M_finish = __dst;
    return __pos;
  }
  iterator _M_erase(iterator __pos, const __false_type& ) {
    if (__pos + 1 != end()) {
      typedef typename __type_traits<_Tp>::has_trivial_assignment_operator _TrivialCopy;
      ::stlp_std::priv:: __copy_ptrs(__pos + 1, this->_M_finish, __pos, _TrivialCopy());
    }
    --this->_M_finish;
    ::stlp_std::_Destroy(this->_M_finish);
    return __pos;
  }
  iterator _M_erase(iterator __first, iterator __last, const __true_type& ) {
    iterator __dst = __first, __src = __last;
    iterator __end = end();
    for (; __dst != __last && __src != __end; ++__dst, ++__src) {
      ::stlp_std::_Destroy(__dst);
      ::stlp_std::_Move_Construct(__dst, *__src);
    }
    if (__dst != __last) {
      ::stlp_std::_Destroy_Range(__dst, __last);
      ::stlp_std::_Destroy_Moved_Range(__last, __end);
    }
    else {
      for (; __src != __end; ++__dst, ++__src) {
        ::stlp_std::_Destroy_Moved(__dst);
        ::stlp_std::_Move_Construct(__dst, *__src);
      }
      ::stlp_std::_Destroy_Moved_Range(__dst, __end);
    }
    this->_M_finish = __dst;
    return __first;
  }
  iterator _M_erase(iterator __first, iterator __last, const __false_type& ) {
    typedef typename __type_traits<_Tp>::has_trivial_assignment_operator _TrivialCopy;
    pointer __i = ::stlp_std::priv:: __copy_ptrs(__last, this->_M_finish, __first, _TrivialCopy());
    ::stlp_std::_Destroy_Range(__i, this->_M_finish);
    this->_M_finish = __i;
    return __first;
  }
public:
  iterator erase(iterator __pos) {
    typedef typename __move_traits<_Tp>::implemented _Movable;
    return _M_erase(__pos, _Movable());
  }
  iterator erase(iterator __first, iterator __last) {
    typedef typename __move_traits<_Tp>::implemented _Movable;
    if (__first == __last)
      return __first;
    return _M_erase(__first, __last, _Movable());
  }
  void resize(size_type __new_size, const _Tp& __x = _Tp()) {
    if (__new_size < size())
      erase(begin() + __new_size, end());
    else
      insert(end(), __new_size - size(), __x);
  }
  void clear() {
    erase(begin(), end());
  }
private:
  void _M_clear() {
    ::stlp_std::_Destroy_Range(rbegin(), rend());
    this->_M_end_of_storage.deallocate(this->_M_start, this->_M_end_of_storage._M_data - this->_M_start);
  }
  void _M_clear_after_move() {
    ::stlp_std::_Destroy_Moved_Range(rbegin(), rend());
    this->_M_end_of_storage.deallocate(this->_M_start, this->_M_end_of_storage._M_data - this->_M_start);
  }
  void _M_set(pointer __s, pointer __f, pointer __e) {
    this->_M_start = __s;
    this->_M_finish = __f;
    this->_M_end_of_storage._M_data = __e;
  }
  template <class _ForwardIterator>
  pointer _M_allocate_and_copy(size_type& __n,
                               _ForwardIterator __first, _ForwardIterator __last)
  {
    pointer __result = this->_M_end_of_storage.allocate(__n, __n);
    try {
      uninitialized_copy(__first, __last, __result);
      return __result;
    }
    catch(...) { this->_M_end_of_storage.deallocate(__result, __n); throw; }
   
  }
  template <class _InputIterator>
  void _M_range_initialize(_InputIterator __first, _InputIterator __last,
                           const input_iterator_tag &) {
    for ( ; __first != __last; ++__first)
      push_back(*__first);
  }
  template <class _ForwardIterator>
  void _M_range_initialize(_ForwardIterator __first, _ForwardIterator __last,
                           const forward_iterator_tag &) {
    size_type __n = ::stlp_std::distance(__first, __last);
    this->_M_start = this->_M_end_of_storage.allocate(__n, __n);
    this->_M_end_of_storage._M_data = this->_M_start + __n;
    this->_M_finish = uninitialized_copy(__first, __last, this->_M_start);
  }
};
}
namespace stlp_std {
namespace priv {
template <class _Tp, class _Alloc>
void _Vector_base<_Tp,_Alloc>::_M_throw_length_error() const
{ __stl_throw_length_error("vector"); }
template <class _Tp, class _Alloc>
void _Vector_base<_Tp, _Alloc>::_M_throw_out_of_range() const
{ __stl_throw_out_of_range("vector"); }
}
template <class _Tp, class _Alloc>
void vector<_Tp, _Alloc>::reserve(size_type __n) {
  if (capacity() < __n) {
    if (max_size() < __n) {
      this->_M_throw_length_error();
    }
    const size_type __old_size = size();
    pointer __tmp;
    if (this->_M_start) {
      __tmp = _M_allocate_and_copy(__n, this->_M_start, this->_M_finish);
      _M_clear();
    } else {
      __tmp = this->_M_end_of_storage.allocate(__n, __n);
    }
    _M_set(__tmp, __tmp + __old_size, __tmp + __n);
  }
}
template <class _Tp, class _Alloc>
void vector<_Tp, _Alloc>::_M_insert_overflow_aux(pointer __pos, const _Tp& __x, const __false_type& ,
                                                 size_type __fill_len, bool __atend ) {
  typedef typename __type_traits<_Tp>::has_trivial_copy_constructor _TrivialUCopy;
  typedef typename __move_traits<_Tp>::implemented _Movable;
  size_type __len = _M_compute_next_size(__fill_len);
  pointer __new_start = this->_M_end_of_storage.allocate(__len, __len);
  pointer __new_finish = __new_start;
  try {
    __new_finish = ::stlp_std::priv:: __uninitialized_move(this->_M_start, __pos, __new_start, _TrivialUCopy(), _Movable());
    if (__fill_len == 1) {
      _Copy_Construct(__new_finish, __x);
      ++__new_finish;
    } else
      __new_finish = ::stlp_std::priv:: __uninitialized_fill_n(__new_finish, __fill_len, __x);
    if (!__atend)
      __new_finish = ::stlp_std::priv:: __uninitialized_move(__pos, this->_M_finish, __new_finish, _TrivialUCopy(), _Movable());
  }
  catch(...) { (::stlp_std::_Destroy_Range(__new_start,__new_finish), this->_M_end_of_storage.deallocate(__new_start,__len)); throw; }
  _M_clear_after_move();
  _M_set(__new_start, __new_finish, __new_start + __len);
}
template <class _Tp, class _Alloc>
void vector<_Tp, _Alloc>::_M_insert_overflow(pointer __pos, const _Tp& __x, const __true_type& ,
                                             size_type __fill_len, bool __atend ) {
  size_type __len = _M_compute_next_size(__fill_len);
  pointer __new_start = this->_M_end_of_storage.allocate(__len, __len);
  pointer __new_finish = static_cast<pointer>(::stlp_std::priv:: __copy_trivial(this->_M_start, __pos, __new_start));
  __new_finish = ::stlp_std::priv:: __fill_n(__new_finish, __fill_len, __x);
  if (!__atend)
    __new_finish = static_cast<pointer>(::stlp_std::priv:: __copy_trivial(__pos, this->_M_finish, __new_finish));
  _M_clear();
  _M_set(__new_start, __new_finish, __new_start + __len);
}
template <class _Tp, class _Alloc>
void vector<_Tp, _Alloc>::_M_fill_insert_aux(iterator __pos, size_type __n,
                                             const _Tp& __x, const __true_type& ) {
  if (_M_is_inside(__x)) {
    _Tp __x_copy = __x;
    _M_fill_insert_aux(__pos, __n, __x_copy, __true_type());
    return;
  }
  iterator __src = this->_M_finish - 1;
  iterator __dst = __src + __n;
  for (; __src >= __pos; --__dst, --__src) {
    ::stlp_std::_Move_Construct(__dst, *__src);
    ::stlp_std::_Destroy_Moved(__src);
  }
  ::stlp_std::priv:: __uninitialized_fill_n(__pos, __n, __x);
  this->_M_finish += __n;
}
template <class _Tp, class _Alloc>
void vector<_Tp, _Alloc>::_M_fill_insert_aux (iterator __pos, size_type __n,
                                              const _Tp& __x, const __false_type& ) {
  typedef typename __type_traits<_Tp>::has_trivial_copy_constructor _TrivialUCopy;
  typedef typename __type_traits<_Tp>::has_trivial_assignment_operator _TrivialCopy;
  if (_M_is_inside(__x)) {
    _Tp __x_copy = __x;
    _M_fill_insert_aux(__pos, __n, __x_copy, __false_type());
    return;
  }
  const size_type __elems_after = this->_M_finish - __pos;
  pointer __old_finish = this->_M_finish;
  if (__elems_after > __n) {
    ::stlp_std::priv:: __ucopy_ptrs(this->_M_finish - __n, this->_M_finish, this->_M_finish, _TrivialUCopy());
    this->_M_finish += __n;
    ::stlp_std::priv:: __copy_backward_ptrs(__pos, __old_finish - __n, __old_finish, _TrivialCopy());
    ::stlp_std::fill(__pos, __pos + __n, __x);
  } else {
    this->_M_finish = ::stlp_std::priv:: __uninitialized_fill_n(this->_M_finish, __n - __elems_after, __x);
    ::stlp_std::priv:: __ucopy_ptrs(__pos, __old_finish, this->_M_finish, _TrivialUCopy());
    this->_M_finish += __elems_after;
    ::stlp_std::fill(__pos, __old_finish, __x);
  }
}
template <class _Tp, class _Alloc>
void vector<_Tp, _Alloc>::_M_fill_insert(iterator __pos,
                                         size_type __n, const _Tp& __x) {
  typedef typename __move_traits<_Tp>::implemented _Movable;
  if (__n != 0) {
    if (size_type(this->_M_end_of_storage._M_data - this->_M_finish) >= __n) {
      _M_fill_insert_aux(__pos, __n, __x, _Movable());
    } else {
      typedef typename __type_traits<_Tp>::has_trivial_assignment_operator _TrivialCopy;
      _M_insert_overflow(__pos, __x, _TrivialCopy(), __n);
    }
  }
}
template <class _Tp, class _Alloc>
vector<_Tp, _Alloc>& vector<_Tp, _Alloc>::operator = (const vector<_Tp, _Alloc>& __x) {
  typedef typename __type_traits<_Tp>::has_trivial_assignment_operator _TrivialCopy;
  typedef typename __type_traits<_Tp>::has_trivial_copy_constructor _TrivialUCopy;
  if (&__x != this) {
    const size_type __xlen = __x.size();
    if (__xlen > capacity()) {
      size_type __len = __xlen;
      pointer __tmp = _M_allocate_and_copy(__len, const_cast<const_pointer>(__x._M_start) + 0,
                                                  const_cast<const_pointer>(__x._M_finish) + 0);
      _M_clear();
      this->_M_start = __tmp;
      this->_M_end_of_storage._M_data = this->_M_start + __len;
    } else if (size() >= __xlen) {
      pointer __i = ::stlp_std::priv:: __copy_ptrs(const_cast<const_pointer>(__x._M_start) + 0,
                                           const_cast<const_pointer>(__x._M_finish) + 0, this->_M_start, _TrivialCopy());
      ::stlp_std::_Destroy_Range(__i, this->_M_finish);
    } else {
      ::stlp_std::priv:: __copy_ptrs(const_cast<const_pointer>(__x._M_start),
                             const_cast<const_pointer>(__x._M_start) + size(), this->_M_start, _TrivialCopy());
      ::stlp_std::priv:: __ucopy_ptrs(const_cast<const_pointer>(__x._M_start) + size(),
                              const_cast<const_pointer>(__x._M_finish) + 0, this->_M_finish, _TrivialUCopy());
    }
    this->_M_finish = this->_M_start + __xlen;
  }
  return *this;
}
template <class _Tp, class _Alloc>
void vector<_Tp, _Alloc>::_M_fill_assign(size_t __n, const _Tp& __val) {
  if (__n > capacity()) {
    vector<_Tp, _Alloc> __tmp(__n, __val, get_allocator());
    __tmp.swap(*this);
  } else if (__n > size()) {
    fill(begin(), end(), __val);
    this->_M_finish = ::stlp_std::priv:: __uninitialized_fill_n(this->_M_finish, __n - size(), __val);
  } else
    erase(::stlp_std::priv:: __fill_n(begin(), __n, __val), end());
}
template <class _Tp, class _Alloc>
typename vector<_Tp, _Alloc>::iterator
vector<_Tp, _Alloc>::insert(iterator __pos, const _Tp& __x) {
  size_type __n = __pos - begin();
  _M_fill_insert(__pos, 1, __x);
  return begin() + __n;
}
}
namespace stlp_std {
namespace priv {
struct _Bit_reference {
  unsigned int* _M_p;
  unsigned int _M_mask;
  _Bit_reference(unsigned int* __x, unsigned int __y)
    : _M_p(__x), _M_mask(__y) {}
public:
  _Bit_reference() : _M_p(0), _M_mask(0) {}
  operator bool() const {
    return !(!(*_M_p & _M_mask));
  }
  _Bit_reference& operator = (bool __x) {
    if (__x) *_M_p |= _M_mask;
    else *_M_p &= ~_M_mask;
    return *this;
  }
  _Bit_reference& operator = (const _Bit_reference& __x) {
    return *this = bool(__x);
  }
  bool operator == (const _Bit_reference& __x) const {
    return bool(*this) == bool(__x);
  }
  bool operator < (const _Bit_reference& __x) const {
    return !bool(*this) && bool(__x);
  }
  _Bit_reference& operator |= (bool __x) {
    if (__x)
      *_M_p |= _M_mask;
    return *this;
  }
  _Bit_reference& operator &= (bool __x) {
    if (!__x)
      *_M_p &= ~_M_mask;
    return *this;
  }
  void flip() { *_M_p ^= _M_mask; }
};
}
inline void swap(::stlp_std::priv:: _Bit_reference& __x, ::stlp_std::priv:: _Bit_reference& __y) {
  bool __tmp = (bool)__x;
  __x = __y;
  __y = __tmp;
}
template<>
struct __type_traits< ::stlp_std::priv:: _Bit_reference> {
  typedef __false_type has_trivial_default_constructor;
  typedef __true_type has_trivial_copy_constructor;
  typedef __false_type has_trivial_assignment_operator;
  typedef __true_type has_trivial_destructor;
  typedef __false_type is_POD_type;
};
namespace priv {
struct _Bit_iterator_base {
  typedef ptrdiff_t difference_type;
  unsigned int* _M_p;
  unsigned int _M_offset;
  void _M_bump_up() {
    if (_M_offset++ == (int(8 * sizeof(unsigned int))) - 1) {
      _M_offset = 0;
      ++_M_p;
    }
  }
  void _M_bump_down() {
    if (_M_offset-- == 0) {
      _M_offset = (int(8 * sizeof(unsigned int))) - 1;
      --_M_p;
    }
  }
  _Bit_iterator_base() : _M_p(0), _M_offset(0) {}
  _Bit_iterator_base(unsigned int* __x, unsigned int __y) : _M_p(__x), _M_offset(__y) {}
  void _M_advance (difference_type __i) {
    difference_type __n = __i + _M_offset;
    _M_p += __n / (int(8 * sizeof(unsigned int)));
    __n = __n % (int(8 * sizeof(unsigned int)));
    if (__n < 0) {
      _M_offset = (unsigned int) __n + (int(8 * sizeof(unsigned int)));
      --_M_p;
    } else
      _M_offset = (unsigned int) __n;
  }
  difference_type _M_subtract(const _Bit_iterator_base& __x) const {
    return (int(8 * sizeof(unsigned int))) * (_M_p - __x._M_p) + _M_offset - __x._M_offset;
  }
};
inline bool operator==(const _Bit_iterator_base& __x, const _Bit_iterator_base& __y) {
  return __y._M_p == __x._M_p && __y._M_offset == __x._M_offset;
}
inline bool operator!=(const _Bit_iterator_base& __x, const _Bit_iterator_base& __y) {
  return __y._M_p != __x._M_p || __y._M_offset != __x._M_offset;
}
inline bool operator<(const _Bit_iterator_base& __x, const _Bit_iterator_base& __y) {
  return __x._M_p < __y._M_p || (__x._M_p == __y._M_p && __x._M_offset < __y._M_offset);
}
inline bool operator>(const _Bit_iterator_base& __x, const _Bit_iterator_base& __y) {
  return operator <(__y , __x);
}
inline bool operator<=(const _Bit_iterator_base& __x, const _Bit_iterator_base& __y) {
  return !(__y < __x);
}
inline bool operator>=(const _Bit_iterator_base& __x, const _Bit_iterator_base& __y) {
  return !(__x < __y);
}
template <class _Ref, class _Ptr>
struct _Bit_iter : public _Bit_iterator_base {
  typedef _Ref reference;
  typedef _Ptr pointer;
  typedef _Bit_iter<_Ref, _Ptr> _Self;
  typedef random_access_iterator_tag iterator_category;
  typedef bool value_type;
  typedef ptrdiff_t difference_type;
  typedef size_t size_type;
  _Bit_iter(unsigned int* __x, unsigned int __y) : _Bit_iterator_base(__x, __y) {}
  _Bit_iter() {}
  _Bit_iter(const _Bit_iter<_Bit_reference, _Bit_reference*>& __x):
    _Bit_iterator_base((const _Bit_iterator_base&)__x) {}
  reference operator*() const {
    return _Bit_reference(_M_p, 1UL << _M_offset);
  }
  _Self& operator++() {
    _M_bump_up();
    return *this;
  }
  _Self operator++(int) {
    _Self __tmp = *this;
    _M_bump_up();
    return __tmp;
  }
  _Self& operator--() {
    _M_bump_down();
    return *this;
  }
  _Self operator--(int) {
    _Self __tmp = *this;
    _M_bump_down();
    return __tmp;
  }
  _Self& operator+=(difference_type __i) {
    _M_advance(__i);
    return *this;
  }
  _Self& operator-=(difference_type __i) {
    *this += -__i;
    return *this;
  }
  _Self operator+(difference_type __i) const {
    _Self __tmp = *this;
    return __tmp += __i;
  }
  _Self operator-(difference_type __i) const {
    _Self __tmp = *this;
    return __tmp -= __i;
  }
  difference_type operator-(const _Self& __x) const {
    return _M_subtract(__x);
  }
  reference operator[](difference_type __i) { return *(*this + __i); }
};
template <class _Ref, class _Ptr>
inline _Bit_iter<_Ref,_Ptr>
operator+(ptrdiff_t __n, const _Bit_iter<_Ref, _Ptr>& __x) {
   return __x + __n;
}
}
template <class _Ref, class _Ptr>
struct __type_traits< ::stlp_std::priv:: _Bit_iter<_Ref, _Ptr> > {
  typedef __false_type has_trivial_default_constructor;
  typedef __true_type has_trivial_copy_constructor;
  typedef __true_type has_trivial_assignment_operator;
  typedef __true_type has_trivial_destructor;
  typedef __false_type is_POD_type;
};
namespace priv {
typedef _Bit_iter<bool, const bool*> _Bit_const_iterator;
typedef _Bit_iter<_Bit_reference, _Bit_reference*> _Bit_iterator;
template <class _Alloc>
class _Bvector_base {
  typedef _Bvector_base<_Alloc> _Self;
public:
 
  typedef _Alloc allocator_type;
  typedef unsigned int __chunk_type;
  typedef typename _Alloc_traits<__chunk_type, _Alloc>::allocator_type __chunk_allocator_type;
  allocator_type get_allocator() const
  { return static_cast<const __chunk_allocator_type&>(_M_end_of_storage); }
  _Bvector_base(const allocator_type& __a)
    : _M_start(), _M_finish(), _M_end_of_storage(__a,
                                                 (__chunk_type*)0)
  {}
  _Bvector_base(__move_source<_Self> src)
    : _M_start(src.get()._M_start), _M_finish(src.get()._M_finish),
      _M_end_of_storage(src.get()._M_end_of_storage) {
    src.get()._M_start._M_p = 0;
  }
  ~_Bvector_base() {
    _M_deallocate();
  }
protected:
  static size_t _M_bits_to_chunks(size_t __n_bits)
  { return (__n_bits + (int(8 * sizeof(unsigned int))) - 1) / (int(8 * sizeof(unsigned int))); }
  __chunk_type* _M_bit_alloc(size_t __n)
  { return _M_end_of_storage.allocate(_M_bits_to_chunks(__n)); }
  void _M_deallocate() {
    if (_M_start._M_p)
      _M_end_of_storage.deallocate(_M_start._M_p,
                                   _M_end_of_storage._M_data - _M_start._M_p);
  }
  _Bit_iterator _M_start;
  _Bit_iterator _M_finish;
  _STLP_alloc_proxy<__chunk_type*, __chunk_type, __chunk_allocator_type> _M_end_of_storage;
};
}
template <class _Alloc>
class vector<bool, _Alloc> : public ::stlp_std::priv:: _Bvector_base<_Alloc >
{
  typedef ::stlp_std::priv:: _Bvector_base<_Alloc > _Base;
  typedef vector<bool, _Alloc> _Self;
public:
  typedef bool value_type;
  typedef size_t size_type;
  typedef ptrdiff_t difference_type;
  typedef ::stlp_std::priv:: _Bit_reference reference;
  typedef bool const_reference;
  typedef ::stlp_std::priv:: _Bit_reference* pointer;
  typedef const bool* const_pointer;
  typedef random_access_iterator_tag _Iterator_category;
  typedef ::stlp_std::priv:: _Bit_iterator iterator;
  typedef ::stlp_std::priv:: _Bit_const_iterator const_iterator;
  typedef ::stlp_std::reverse_iterator<const_iterator> const_reverse_iterator; typedef ::stlp_std::reverse_iterator<iterator> reverse_iterator;
  typedef typename ::stlp_std::priv:: _Bvector_base<_Alloc >::allocator_type allocator_type;
  typedef typename ::stlp_std::priv:: _Bvector_base<_Alloc >::__chunk_type __chunk_type;
protected:
  void _M_initialize(size_type __n) {
    __chunk_type* __q = this->_M_bit_alloc(__n);
    this->_M_end_of_storage._M_data = __q + _Base::_M_bits_to_chunks(__n);
    this->_M_start = iterator(__q, 0);
    this->_M_finish = this->_M_start + difference_type(__n);
  }
  void _M_insert_aux(iterator __position, bool __x) {
    if (this->_M_finish._M_p != this->_M_end_of_storage._M_data) {
      ::stlp_std::priv:: __copy_backward(__position, this->_M_finish, this->_M_finish + 1,
                                 random_access_iterator_tag(), (difference_type*)0 );
      *__position = __x;
      ++this->_M_finish;
    }
    else {
      size_type __len = size() ? 2 * size() : (int(8 * sizeof(unsigned int)));
      __chunk_type* __q = this->_M_bit_alloc(__len);
      iterator __i = ::stlp_std::copy(begin(), __position, iterator(__q, 0));
      *__i++ = __x;
      this->_M_finish = ::stlp_std::copy(__position, end(), __i);
      this->_M_deallocate();
      this->_M_end_of_storage._M_data = __q + _Base::_M_bits_to_chunks(__len);
      this->_M_start = iterator(__q, 0);
    }
  }
  template <class _InputIterator>
  void _M_initialize_range(_InputIterator __first, _InputIterator __last,
                           const input_iterator_tag &) {
    this->_M_start = iterator();
    this->_M_finish = iterator();
    this->_M_end_of_storage._M_data = 0;
    for ( ; __first != __last; ++__first)
      push_back(*__first);
  }
  template <class _ForwardIterator>
  void _M_initialize_range(_ForwardIterator __first, _ForwardIterator __last,
                           const forward_iterator_tag &) {
    size_type __n = ::stlp_std::distance(__first, __last);
    _M_initialize(__n);
    ::stlp_std::copy(__first, __last, this->_M_start);
  }
  template <class _InputIterator>
  void _M_insert_range(iterator __pos,
                       _InputIterator __first, _InputIterator __last,
                       const input_iterator_tag &) {
    for ( ; __first != __last; ++__first) {
      __pos = insert(__pos, *__first);
      ++__pos;
    }
  }
  template <class _ForwardIterator>
  void _M_insert_range(iterator __position,
                       _ForwardIterator __first, _ForwardIterator __last,
                       const forward_iterator_tag &) {
    if (__first != __last) {
      size_type __n = ::stlp_std::distance(__first, __last);
      if (capacity() - size() >= __n) {
        ::stlp_std::priv:: __copy_backward(__position, end(), this->_M_finish + difference_type(__n),
                                   random_access_iterator_tag(), (difference_type*)0 );
        ::stlp_std::copy(__first, __last, __position);
        this->_M_finish += difference_type(__n);
      }
      else {
        size_type __len = size() + (max)(size(), __n);
        __chunk_type* __q = this->_M_bit_alloc(__len);
        iterator __i = ::stlp_std::copy(begin(), __position, iterator(__q, 0));
        __i = ::stlp_std::copy(__first, __last, __i);
        this->_M_finish = ::stlp_std::copy(__position, end(), __i);
        this->_M_deallocate();
        this->_M_end_of_storage._M_data = __q + _Base::_M_bits_to_chunks(__len);
        this->_M_start = iterator(__q, 0);
      }
    }
  }
public:
  iterator begin() { return this->_M_start; }
  const_iterator begin() const { return this->_M_start; }
  iterator end() { return this->_M_finish; }
  const_iterator end() const { return this->_M_finish; }
  reverse_iterator rbegin() { return reverse_iterator(end()); }
  const_reverse_iterator rbegin() const {
    return const_reverse_iterator(end());
  }
  reverse_iterator rend() { return reverse_iterator(begin()); }
  const_reverse_iterator rend() const {
    return const_reverse_iterator(begin());
  }
  size_type size() const { return size_type(end() - begin()); }
  size_type max_size() const { return size_type(-1); }
  size_type capacity() const {
    return size_type(const_iterator(this->_M_end_of_storage._M_data, 0) - begin());
  }
  bool empty() const { return begin() == end(); }
  reference operator[](size_type __n)
  { return *(begin() + difference_type(__n)); }
  const_reference operator[](size_type __n) const
  { return *(begin() + difference_type(__n)); }
  void _M_range_check(size_type __n) const {
    if (__n >= this->size())
      __stl_throw_range_error("vector<bool>");
  }
  reference at(size_type __n)
    { _M_range_check(__n); return (*this)[__n]; }
  const_reference at(size_type __n) const
    { _M_range_check(__n); return (*this)[__n]; }
  explicit vector(const allocator_type& __a = allocator_type())
    : ::stlp_std::priv:: _Bvector_base<_Alloc >(__a) {}
  vector(size_type __n, bool __val,
            const allocator_type& __a = allocator_type())
    : ::stlp_std::priv:: _Bvector_base<_Alloc >(__a) {
    _M_initialize(__n);
    fill(this->_M_start._M_p, (__chunk_type*)(this->_M_end_of_storage._M_data), __val ? ~0 : 0);
  }
  explicit vector(size_type __n)
    : ::stlp_std::priv:: _Bvector_base<_Alloc >(allocator_type()) {
    _M_initialize(__n);
    fill(this->_M_start._M_p, (__chunk_type*)(this->_M_end_of_storage._M_data), 0);
  }
  vector(const _Self& __x)
    : ::stlp_std::priv:: _Bvector_base<_Alloc >(__x.get_allocator()) {
    _M_initialize(__x.size());
    ::stlp_std::copy(__x.begin(), __x.end(), this->_M_start);
  }
  template <class _Integer>
  void _M_initialize_dispatch(_Integer __n, _Integer __x, const __true_type&) {
    _M_initialize(__n);
    fill(this->_M_start._M_p, this->_M_end_of_storage._M_data, __x ? ~0 : 0);
  }
  template <class _InputIterator>
  void _M_initialize_dispatch(_InputIterator __first, _InputIterator __last,
                              const __false_type&) {
    _M_initialize_range(__first, __last, typename ::stlp_std::iterator_traits< _InputIterator >::iterator_category());
  }
  template <class _InputIterator>
  vector(_InputIterator __first, _InputIterator __last,
            const allocator_type& __a = allocator_type())
    : ::stlp_std::priv:: _Bvector_base<_Alloc >(__a) {
    typedef typename _IsIntegral<_InputIterator>::_Ret _Integral;
    _M_initialize_dispatch(__first, __last, _Integral());
  }
  vector(__move_source<_Self> src)
    : ::stlp_std::priv:: _Bvector_base<_Alloc >(__move_source<_Base>(src.get())) {}
  ~vector() {}
  vector<bool, _Alloc>& operator=(const vector<bool, _Alloc>& __x) {
    if (&__x == this) return *this;
    if (__x.size() > capacity()) {
      this->_M_deallocate();
      _M_initialize(__x.size());
    }
    ::stlp_std::copy(__x.begin(), __x.end(), begin());
    this->_M_finish = begin() + difference_type(__x.size());
    return *this;
  }
  void _M_fill_assign(size_t __n, bool __x) {
    if (__n > size()) {
      fill(this->_M_start._M_p, (__chunk_type*)(this->_M_end_of_storage._M_data), __x ? ~0 : 0);
      insert(end(), __n - size(), __x);
    }
    else {
      erase(begin() + __n, end());
      fill(this->_M_start._M_p, (__chunk_type*)(this->_M_end_of_storage._M_data), __x ? ~0 : 0);
    }
  }
  void assign(size_t __n, bool __x) { _M_fill_assign(__n, __x); }
  template <class _InputIterator>
  void assign(_InputIterator __first, _InputIterator __last) {
    typedef typename _IsIntegral<_InputIterator>::_Ret _Integral;
    _M_assign_dispatch(__first, __last, _Integral());
  }
  template <class _Integer>
  void _M_assign_dispatch(_Integer __n, _Integer __val, const __true_type&)
    { _M_fill_assign((size_t) __n, (bool) __val); }
  template <class _InputIter>
  void _M_assign_dispatch(_InputIter __first, _InputIter __last, const __false_type&)
    { _M_assign_aux(__first, __last, typename ::stlp_std::iterator_traits< _InputIter >::iterator_category()); }
  template <class _InputIterator>
  void _M_assign_aux(_InputIterator __first, _InputIterator __last,
                     const input_iterator_tag &) {
    iterator __cur = begin();
    for ( ; __first != __last && __cur != end(); ++__cur, ++__first)
      *__cur = *__first;
    if (__first == __last)
      erase(__cur, end());
    else
      insert(end(), __first, __last);
  }
  template <class _ForwardIterator>
  void _M_assign_aux(_ForwardIterator __first, _ForwardIterator __last,
                     const forward_iterator_tag &) {
    size_type __len = ::stlp_std::distance(__first, __last);
    if (__len < size())
      erase(::stlp_std::copy(__first, __last, begin()), end());
    else {
      _ForwardIterator __mid = __first;
      ::stlp_std::advance(__mid, size());
      ::stlp_std::copy(__first, __mid, begin());
      insert(end(), __mid, __last);
    }
  }
  void reserve(size_type __n) {
    if (capacity() < __n) {
      if (max_size() < __n)
        __stl_throw_length_error("vector<bool>");
      __chunk_type* __q = this->_M_bit_alloc(__n);
      ::stlp_std::priv:: _Bit_iterator __z(__q, 0);
      this->_M_finish = ::stlp_std::copy(begin(), end(), __z);
      this->_M_deallocate();
      this->_M_start = iterator(__q, 0);
      this->_M_end_of_storage._M_data = __q + _Base::_M_bits_to_chunks(__n);
    }
  }
  reference front() { return *begin(); }
  const_reference front() const { return *begin(); }
  reference back() { return *(end() - 1); }
  const_reference back() const { return *(end() - 1); }
  void push_back(bool __x) {
    if (this->_M_finish._M_p != this->_M_end_of_storage._M_data) {
      *(this->_M_finish) = __x;
      ++this->_M_finish;
    }
    else
      _M_insert_aux(end(), __x);
  }
  void swap(vector<bool, _Alloc>& __x) {
    ::stlp_std::swap(this->_M_start, __x._M_start);
    ::stlp_std::swap(this->_M_finish, __x._M_finish);
    this->_M_end_of_storage.swap(__x._M_end_of_storage);
  }
  iterator insert(iterator __position, bool __x = bool()) {
    difference_type __n = __position - begin();
    if (this->_M_finish._M_p != this->_M_end_of_storage._M_data && __position == end()) {
      *(this->_M_finish) = __x;
      ++this->_M_finish;
    }
    else
      _M_insert_aux(__position, __x);
    return begin() + __n;
  }
  template <class _Integer>
  void _M_insert_dispatch(iterator __pos, _Integer __n, _Integer __x,
                          const __true_type&) {
    _M_fill_insert(__pos, (size_type) __n, (bool) __x);
  }
  template <class _InputIterator>
  void _M_insert_dispatch(iterator __pos,
                          _InputIterator __first, _InputIterator __last,
                          const __false_type&) {
    _M_insert_range(__pos, __first, __last, typename ::stlp_std::iterator_traits< _InputIterator >::iterator_category());
  }
  template <class _InputIterator>
  void insert(iterator __position,
              _InputIterator __first, _InputIterator __last) {
    typedef typename _IsIntegral<_InputIterator>::_Ret _Integral;
    _M_insert_dispatch(__position, __first, __last, _Integral());
  }
  void _M_fill_insert(iterator __position, size_type __n, bool __x) {
    if (__n == 0) return;
    if (capacity() - size() >= __n) {
      ::stlp_std::priv:: __copy_backward(__position, end(), this->_M_finish + difference_type(__n),
                                 random_access_iterator_tag(), (difference_type*)0 );
      fill(__position, __position + difference_type(__n), __x);
      this->_M_finish += difference_type(__n);
    }
    else {
      size_type __len = size() + (max)(size(), __n);
      __chunk_type* __q = this->_M_bit_alloc(__len);
      iterator __i = ::stlp_std::copy(begin(), __position, iterator(__q, 0));
      fill_n(__i, __n, __x);
      this->_M_finish = ::stlp_std::copy(__position, end(), __i + difference_type(__n));
      this->_M_deallocate();
      this->_M_end_of_storage._M_data = __q + _Base::_M_bits_to_chunks(__len);
      this->_M_start = iterator(__q, 0);
    }
  }
  void insert(iterator __position, size_type __n, bool __x) {
    _M_fill_insert(__position, __n, __x);
  }
  void pop_back() {
    --this->_M_finish;
  }
  iterator erase(iterator __position) {
    if (__position + 1 != end())
      ::stlp_std::copy(__position + 1, end(), __position);
      --this->_M_finish;
    return __position;
  }
  iterator erase(iterator __first, iterator __last) {
    this->_M_finish = ::stlp_std::copy(__last, end(), __first);
    return __first;
  }
  void resize(size_type __new_size, bool __x = bool()) {
    if (__new_size < size())
      erase(begin() + difference_type(__new_size), end());
    else
      insert(end(), __new_size - size(), __x);
  }
  void flip() {
    for (__chunk_type* __p = this->_M_start._M_p; __p != this->_M_end_of_storage._M_data; ++__p)
      *__p = ~*__p;
  }
  void clear() { erase(begin(), end()); }
};
}
namespace stlp_std {
typedef vector<bool, allocator<bool> > bit_vector;
template <class _Tp, class _Alloc>
inline bool operator==(const vector<_Tp, _Alloc>& __x,
                                  const vector<_Tp, _Alloc>& __y) {
  return __x.size() == __y.size() &&
         equal(__x.begin(), __x.end(), __y.begin());
}
template <class _Tp, class _Alloc>
inline bool operator<(const vector<_Tp, _Alloc>& __x,
                                 const vector<_Tp, _Alloc>& __y) {
  return lexicographical_compare(__x.begin(), __x.end(),
                                 __y.begin(), __y.end());
}
template <class _Tp, class _Alloc> inline bool operator!=(const vector<_Tp, _Alloc>& __x, const vector<_Tp, _Alloc>& __y) {return !(__x == __y);}template <class _Tp, class _Alloc> inline bool operator>(const vector<_Tp, _Alloc>& __x, const vector<_Tp, _Alloc>& __y) {return __y < __x;}template <class _Tp, class _Alloc> inline bool operator<=(const vector<_Tp, _Alloc>& __x, const vector<_Tp, _Alloc>& __y) { return !(__y < __x);}template <class _Tp, class _Alloc> inline bool operator>=(const vector<_Tp, _Alloc>& __x, const vector<_Tp, _Alloc>& __y) { return !(__x < __y);}
template <class _Tp, class _Alloc>
inline void swap(vector<_Tp, _Alloc>& __x,
                            vector<_Tp, _Alloc>& __y) {
  __x.swap(__y);
}
template <class _Tp, class _Alloc>
struct __move_traits<vector<_Tp, _Alloc> > {
  typedef __true_type implemented;
  typedef typename __move_traits<_Alloc>::complete complete;
};
template <class _Tp, class _Alloc>
struct _DefaultZeroValue<vector<_Tp, _Alloc> >
{ typedef typename __type_traits<_Alloc>::has_trivial_default_constructor _Ret; };
}
extern "C" {
typedef __intptr_t intptr_t;
typedef __socklen_t socklen_t;
extern int access (__const char *__name, int __type) throw () __attribute__ ((__nonnull__ (1)));
extern int euidaccess (__const char *__name, int __type)
     throw () __attribute__ ((__nonnull__ (1)));
extern int eaccess (__const char *__name, int __type)
     throw () __attribute__ ((__nonnull__ (1)));
extern int faccessat (int __fd, __const char *__file, int __type, int __flag)
     throw () __attribute__ ((__nonnull__ (2))) ;
extern __off_t lseek (int __fd, __off_t __offset, int __whence) throw ();
extern __off64_t lseek64 (int __fd, __off64_t __offset, int __whence)
     throw ();
extern int close (int __fd);
extern ssize_t read (int __fd, void *__buf, size_t __nbytes) ;
extern ssize_t write (int __fd, __const void *__buf, size_t __n) ;
extern ssize_t pread (int __fd, void *__buf, size_t __nbytes,
        __off_t __offset) ;
extern ssize_t pwrite (int __fd, __const void *__buf, size_t __n,
         __off_t __offset) ;
extern ssize_t pread64 (int __fd, void *__buf, size_t __nbytes,
   __off64_t __offset) ;
extern ssize_t pwrite64 (int __fd, __const void *__buf, size_t __n,
    __off64_t __offset) ;
extern int pipe (int __pipedes[2]) throw () ;
extern int pipe2 (int __pipedes[2], int __flags) throw () ;
extern unsigned int alarm (unsigned int __seconds) throw ();
extern unsigned int sleep (unsigned int __seconds);
extern __useconds_t ualarm (__useconds_t __value, __useconds_t __interval)
     throw ();
extern int usleep (__useconds_t __useconds);
extern int pause (void);
extern int chown (__const char *__file, __uid_t __owner, __gid_t __group)
     throw () __attribute__ ((__nonnull__ (1))) ;
extern int fchown (int __fd, __uid_t __owner, __gid_t __group) throw () ;
extern int lchown (__const char *__file, __uid_t __owner, __gid_t __group)
     throw () __attribute__ ((__nonnull__ (1))) ;
extern int fchownat (int __fd, __const char *__file, __uid_t __owner,
       __gid_t __group, int __flag)
     throw () __attribute__ ((__nonnull__ (2))) ;
extern int chdir (__const char *__path) throw () __attribute__ ((__nonnull__ (1))) ;
extern int fchdir (int __fd) throw () ;
extern char *getcwd (char *__buf, size_t __size) throw () ;
extern char *get_current_dir_name (void) throw ();
extern char *getwd (char *__buf)
     throw () __attribute__ ((__nonnull__ (1))) __attribute__ ((__deprecated__)) ;
extern int dup (int __fd) throw () ;
extern int dup2 (int __fd, int __fd2) throw ();
extern int dup3 (int __fd, int __fd2, int __flags) throw ();
extern char **__environ;
extern char **environ;
extern int execve (__const char *__path, char *__const __argv[],
     char *__const __envp[]) throw () __attribute__ ((__nonnull__ (1)));
extern int fexecve (int __fd, char *__const __argv[], char *__const __envp[])
     throw ();
extern int execv (__const char *__path, char *__const __argv[])
     throw () __attribute__ ((__nonnull__ (1)));
extern int execle (__const char *__path, __const char *__arg, ...)
     throw () __attribute__ ((__nonnull__ (1)));
extern int execl (__const char *__path, __const char *__arg, ...)
     throw () __attribute__ ((__nonnull__ (1)));
extern int execvp (__const char *__file, char *__const __argv[])
     throw () __attribute__ ((__nonnull__ (1)));
extern int execlp (__const char *__file, __const char *__arg, ...)
     throw () __attribute__ ((__nonnull__ (1)));
extern int nice (int __inc) throw () ;
extern void _exit (int __status) __attribute__ ((__noreturn__));
enum
  {
    _PC_LINK_MAX,
    _PC_MAX_CANON,
    _PC_MAX_INPUT,
    _PC_NAME_MAX,
    _PC_PATH_MAX,
    _PC_PIPE_BUF,
    _PC_CHOWN_RESTRICTED,
    _PC_NO_TRUNC,
    _PC_VDISABLE,
    _PC_SYNC_IO,
    _PC_ASYNC_IO,
    _PC_PRIO_IO,
    _PC_SOCK_MAXBUF,
    _PC_FILESIZEBITS,
    _PC_REC_INCR_XFER_SIZE,
    _PC_REC_MAX_XFER_SIZE,
    _PC_REC_MIN_XFER_SIZE,
    _PC_REC_XFER_ALIGN,
    _PC_ALLOC_SIZE_MIN,
    _PC_SYMLINK_MAX,
    _PC_2_SYMLINKS
  };
enum
  {
    _SC_ARG_MAX,
    _SC_CHILD_MAX,
    _SC_CLK_TCK,
    _SC_NGROUPS_MAX,
    _SC_OPEN_MAX,
    _SC_STREAM_MAX,
    _SC_TZNAME_MAX,
    _SC_JOB_CONTROL,
    _SC_SAVED_IDS,
    _SC_REALTIME_SIGNALS,
    _SC_PRIORITY_SCHEDULING,
    _SC_TIMERS,
    _SC_ASYNCHRONOUS_IO,
    _SC_PRIORITIZED_IO,
    _SC_SYNCHRONIZED_IO,
    _SC_FSYNC,
    _SC_MAPPED_FILES,
    _SC_MEMLOCK,
    _SC_MEMLOCK_RANGE,
    _SC_MEMORY_PROTECTION,
    _SC_MESSAGE_PASSING,
    _SC_SEMAPHORES,
    _SC_SHARED_MEMORY_OBJECTS,
    _SC_AIO_LISTIO_MAX,
    _SC_AIO_MAX,
    _SC_AIO_PRIO_DELTA_MAX,
    _SC_DELAYTIMER_MAX,
    _SC_MQ_OPEN_MAX,
    _SC_MQ_PRIO_MAX,
    _SC_VERSION,
    _SC_PAGESIZE,
    _SC_RTSIG_MAX,
    _SC_SEM_NSEMS_MAX,
    _SC_SEM_VALUE_MAX,
    _SC_SIGQUEUE_MAX,
    _SC_TIMER_MAX,
    _SC_BC_BASE_MAX,
    _SC_BC_DIM_MAX,
    _SC_BC_SCALE_MAX,
    _SC_BC_STRING_MAX,
    _SC_COLL_WEIGHTS_MAX,
    _SC_EQUIV_CLASS_MAX,
    _SC_EXPR_NEST_MAX,
    _SC_LINE_MAX,
    _SC_RE_DUP_MAX,
    _SC_CHARCLASS_NAME_MAX,
    _SC_2_VERSION,
    _SC_2_C_BIND,
    _SC_2_C_DEV,
    _SC_2_FORT_DEV,
    _SC_2_FORT_RUN,
    _SC_2_SW_DEV,
    _SC_2_LOCALEDEF,
    _SC_PII,
    _SC_PII_XTI,
    _SC_PII_SOCKET,
    _SC_PII_INTERNET,
    _SC_PII_OSI,
    _SC_POLL,
    _SC_SELECT,
    _SC_UIO_MAXIOV,
    _SC_IOV_MAX = _SC_UIO_MAXIOV,
    _SC_PII_INTERNET_STREAM,
    _SC_PII_INTERNET_DGRAM,
    _SC_PII_OSI_COTS,
    _SC_PII_OSI_CLTS,
    _SC_PII_OSI_M,
    _SC_T_IOV_MAX,
    _SC_THREADS,
    _SC_THREAD_SAFE_FUNCTIONS,
    _SC_GETGR_R_SIZE_MAX,
    _SC_GETPW_R_SIZE_MAX,
    _SC_LOGIN_NAME_MAX,
    _SC_TTY_NAME_MAX,
    _SC_THREAD_DESTRUCTOR_ITERATIONS,
    _SC_THREAD_KEYS_MAX,
    _SC_THREAD_STACK_MIN,
    _SC_THREAD_THREADS_MAX,
    _SC_THREAD_ATTR_STACKADDR,
    _SC_THREAD_ATTR_STACKSIZE,
    _SC_THREAD_PRIORITY_SCHEDULING,
    _SC_THREAD_PRIO_INHERIT,
    _SC_THREAD_PRIO_PROTECT,
    _SC_THREAD_PROCESS_SHARED,
    _SC_NPROCESSORS_CONF,
    _SC_NPROCESSORS_ONLN,
    _SC_PHYS_PAGES,
    _SC_AVPHYS_PAGES,
    _SC_ATEXIT_MAX,
    _SC_PASS_MAX,
    _SC_XOPEN_VERSION,
    _SC_XOPEN_XCU_VERSION,
    _SC_XOPEN_UNIX,
    _SC_XOPEN_CRYPT,
    _SC_XOPEN_ENH_I18N,
    _SC_XOPEN_SHM,
    _SC_2_CHAR_TERM,
    _SC_2_C_VERSION,
    _SC_2_UPE,
    _SC_XOPEN_XPG2,
    _SC_XOPEN_XPG3,
    _SC_XOPEN_XPG4,
    _SC_CHAR_BIT,
    _SC_CHAR_MAX,
    _SC_CHAR_MIN,
    _SC_INT_MAX,
    _SC_INT_MIN,
    _SC_LONG_BIT,
    _SC_WORD_BIT,
    _SC_MB_LEN_MAX,
    _SC_NZERO,
    _SC_SSIZE_MAX,
    _SC_SCHAR_MAX,
    _SC_SCHAR_MIN,
    _SC_SHRT_MAX,
    _SC_SHRT_MIN,
    _SC_UCHAR_MAX,
    _SC_UINT_MAX,
    _SC_ULONG_MAX,
    _SC_USHRT_MAX,
    _SC_NL_ARGMAX,
    _SC_NL_LANGMAX,
    _SC_NL_MSGMAX,
    _SC_NL_NMAX,
    _SC_NL_SETMAX,
    _SC_NL_TEXTMAX,
    _SC_XBS5_ILP32_OFF32,
    _SC_XBS5_ILP32_OFFBIG,
    _SC_XBS5_LP64_OFF64,
    _SC_XBS5_LPBIG_OFFBIG,
    _SC_XOPEN_LEGACY,
    _SC_XOPEN_REALTIME,
    _SC_XOPEN_REALTIME_THREADS,
    _SC_ADVISORY_INFO,
    _SC_BARRIERS,
    _SC_BASE,
    _SC_C_LANG_SUPPORT,
    _SC_C_LANG_SUPPORT_R,
    _SC_CLOCK_SELECTION,
    _SC_CPUTIME,
    _SC_THREAD_CPUTIME,
    _SC_DEVICE_IO,
    _SC_DEVICE_SPECIFIC,
    _SC_DEVICE_SPECIFIC_R,
    _SC_FD_MGMT,
    _SC_FIFO,
    _SC_PIPE,
    _SC_FILE_ATTRIBUTES,
    _SC_FILE_LOCKING,
    _SC_FILE_SYSTEM,
    _SC_MONOTONIC_CLOCK,
    _SC_MULTI_PROCESS,
    _SC_SINGLE_PROCESS,
    _SC_NETWORKING,
    _SC_READER_WRITER_LOCKS,
    _SC_SPIN_LOCKS,
    _SC_REGEXP,
    _SC_REGEX_VERSION,
    _SC_SHELL,
    _SC_SIGNALS,
    _SC_SPAWN,
    _SC_SPORADIC_SERVER,
    _SC_THREAD_SPORADIC_SERVER,
    _SC_SYSTEM_DATABASE,
    _SC_SYSTEM_DATABASE_R,
    _SC_TIMEOUTS,
    _SC_TYPED_MEMORY_OBJECTS,
    _SC_USER_GROUPS,
    _SC_USER_GROUPS_R,
    _SC_2_PBS,
    _SC_2_PBS_ACCOUNTING,
    _SC_2_PBS_LOCATE,
    _SC_2_PBS_MESSAGE,
    _SC_2_PBS_TRACK,
    _SC_SYMLOOP_MAX,
    _SC_STREAMS,
    _SC_2_PBS_CHECKPOINT,
    _SC_V6_ILP32_OFF32,
    _SC_V6_ILP32_OFFBIG,
    _SC_V6_LP64_OFF64,
    _SC_V6_LPBIG_OFFBIG,
    _SC_HOST_NAME_MAX,
    _SC_TRACE,
    _SC_TRACE_EVENT_FILTER,
    _SC_TRACE_INHERIT,
    _SC_TRACE_LOG,
    _SC_LEVEL1_ICACHE_SIZE,
    _SC_LEVEL1_ICACHE_ASSOC,
    _SC_LEVEL1_ICACHE_LINESIZE,
    _SC_LEVEL1_DCACHE_SIZE,
    _SC_LEVEL1_DCACHE_ASSOC,
    _SC_LEVEL1_DCACHE_LINESIZE,
    _SC_LEVEL2_CACHE_SIZE,
    _SC_LEVEL2_CACHE_ASSOC,
    _SC_LEVEL2_CACHE_LINESIZE,
    _SC_LEVEL3_CACHE_SIZE,
    _SC_LEVEL3_CACHE_ASSOC,
    _SC_LEVEL3_CACHE_LINESIZE,
    _SC_LEVEL4_CACHE_SIZE,
    _SC_LEVEL4_CACHE_ASSOC,
    _SC_LEVEL4_CACHE_LINESIZE,
    _SC_IPV6 = _SC_LEVEL1_ICACHE_SIZE + 50,
    _SC_RAW_SOCKETS
  };
enum
  {
    _CS_PATH,
    _CS_V6_WIDTH_RESTRICTED_ENVS,
    _CS_GNU_LIBC_VERSION,
    _CS_GNU_LIBPTHREAD_VERSION,
    _CS_LFS_CFLAGS = 1000,
    _CS_LFS_LDFLAGS,
    _CS_LFS_LIBS,
    _CS_LFS_LINTFLAGS,
    _CS_LFS64_CFLAGS,
    _CS_LFS64_LDFLAGS,
    _CS_LFS64_LIBS,
    _CS_LFS64_LINTFLAGS,
    _CS_XBS5_ILP32_OFF32_CFLAGS = 1100,
    _CS_XBS5_ILP32_OFF32_LDFLAGS,
    _CS_XBS5_ILP32_OFF32_LIBS,
    _CS_XBS5_ILP32_OFF32_LINTFLAGS,
    _CS_XBS5_ILP32_OFFBIG_CFLAGS,
    _CS_XBS5_ILP32_OFFBIG_LDFLAGS,
    _CS_XBS5_ILP32_OFFBIG_LIBS,
    _CS_XBS5_ILP32_OFFBIG_LINTFLAGS,
    _CS_XBS5_LP64_OFF64_CFLAGS,
    _CS_XBS5_LP64_OFF64_LDFLAGS,
    _CS_XBS5_LP64_OFF64_LIBS,
    _CS_XBS5_LP64_OFF64_LINTFLAGS,
    _CS_XBS5_LPBIG_OFFBIG_CFLAGS,
    _CS_XBS5_LPBIG_OFFBIG_LDFLAGS,
    _CS_XBS5_LPBIG_OFFBIG_LIBS,
    _CS_XBS5_LPBIG_OFFBIG_LINTFLAGS,
    _CS_POSIX_V6_ILP32_OFF32_CFLAGS,
    _CS_POSIX_V6_ILP32_OFF32_LDFLAGS,
    _CS_POSIX_V6_ILP32_OFF32_LIBS,
    _CS_POSIX_V6_ILP32_OFF32_LINTFLAGS,
    _CS_POSIX_V6_ILP32_OFFBIG_CFLAGS,
    _CS_POSIX_V6_ILP32_OFFBIG_LDFLAGS,
    _CS_POSIX_V6_ILP32_OFFBIG_LIBS,
    _CS_POSIX_V6_ILP32_OFFBIG_LINTFLAGS,
    _CS_POSIX_V6_LP64_OFF64_CFLAGS,
    _CS_POSIX_V6_LP64_OFF64_LDFLAGS,
    _CS_POSIX_V6_LP64_OFF64_LIBS,
    _CS_POSIX_V6_LP64_OFF64_LINTFLAGS,
    _CS_POSIX_V6_LPBIG_OFFBIG_CFLAGS,
    _CS_POSIX_V6_LPBIG_OFFBIG_LDFLAGS,
    _CS_POSIX_V6_LPBIG_OFFBIG_LIBS,
    _CS_POSIX_V6_LPBIG_OFFBIG_LINTFLAGS
  };
extern long int pathconf (__const char *__path, int __name)
     throw () __attribute__ ((__nonnull__ (1)));
extern long int fpathconf (int __fd, int __name) throw ();
extern long int sysconf (int __name) throw ();
extern size_t confstr (int __name, char *__buf, size_t __len) throw ();
extern __pid_t getpid (void) throw ();
extern __pid_t getppid (void) throw ();
extern __pid_t getpgrp (void) throw ();
extern __pid_t __getpgid (__pid_t __pid) throw ();
extern __pid_t getpgid (__pid_t __pid) throw ();
extern int setpgid (__pid_t __pid, __pid_t __pgid) throw ();
extern int setpgrp (void) throw ();
extern __pid_t setsid (void) throw ();
extern __pid_t getsid (__pid_t __pid) throw ();
extern __uid_t getuid (void) throw ();
extern __uid_t geteuid (void) throw ();
extern __gid_t getgid (void) throw ();
extern __gid_t getegid (void) throw ();
extern int getgroups (int __size, __gid_t __list[]) throw () ;
extern int group_member (__gid_t __gid) throw ();
extern int setuid (__uid_t __uid) throw ();
extern int setreuid (__uid_t __ruid, __uid_t __euid) throw ();
extern int seteuid (__uid_t __uid) throw ();
extern int setgid (__gid_t __gid) throw ();
extern int setregid (__gid_t __rgid, __gid_t __egid) throw ();
extern int setegid (__gid_t __gid) throw ();
extern int getresuid (__uid_t *__ruid, __uid_t *__euid, __uid_t *__suid)
     throw ();
extern int getresgid (__gid_t *__rgid, __gid_t *__egid, __gid_t *__sgid)
     throw ();
extern int setresuid (__uid_t __ruid, __uid_t __euid, __uid_t __suid)
     throw ();
extern int setresgid (__gid_t __rgid, __gid_t __egid, __gid_t __sgid)
     throw ();
extern __pid_t fork (void) throw ();
extern __pid_t vfork (void) throw ();
extern char *ttyname (int __fd) throw ();
extern int ttyname_r (int __fd, char *__buf, size_t __buflen)
     throw () __attribute__ ((__nonnull__ (2))) ;
extern int isatty (int __fd) throw ();
extern int ttyslot (void) throw ();
extern int link (__const char *__from, __const char *__to)
     throw () __attribute__ ((__nonnull__ (1, 2))) ;
extern int linkat (int __fromfd, __const char *__from, int __tofd,
     __const char *__to, int __flags)
     throw () __attribute__ ((__nonnull__ (2, 4))) ;
extern int symlink (__const char *__from, __const char *__to)
     throw () __attribute__ ((__nonnull__ (1, 2))) ;
extern ssize_t readlink (__const char *__restrict __path,
    char *__restrict __buf, size_t __len)
     throw () __attribute__ ((__nonnull__ (1, 2))) ;
extern int symlinkat (__const char *__from, int __tofd,
        __const char *__to) throw () __attribute__ ((__nonnull__ (1, 3))) ;
extern ssize_t readlinkat (int __fd, __const char *__restrict __path,
      char *__restrict __buf, size_t __len)
     throw () __attribute__ ((__nonnull__ (2, 3))) ;
extern int unlink (__const char *__name) throw () __attribute__ ((__nonnull__ (1)));
extern int unlinkat (int __fd, __const char *__name, int __flag)
     throw () __attribute__ ((__nonnull__ (2)));
extern int rmdir (__const char *__path) throw () __attribute__ ((__nonnull__ (1)));
extern __pid_t tcgetpgrp (int __fd) throw ();
extern int tcsetpgrp (int __fd, __pid_t __pgrp_id) throw ();
extern char *getlogin (void);
extern int getlogin_r (char *__name, size_t __name_len) __attribute__ ((__nonnull__ (1)));
extern int setlogin (__const char *__name) throw () __attribute__ ((__nonnull__ (1)));
extern "C" {
extern char *optarg;
extern int optind;
extern int opterr;
extern int optopt;
extern int getopt (int ___argc, char *const *___argv, const char *__shortopts)
       throw ();
}
extern int gethostname (char *__name, size_t __len) throw () __attribute__ ((__nonnull__ (1)));
extern int sethostname (__const char *__name, size_t __len)
     throw () __attribute__ ((__nonnull__ (1))) ;
extern int sethostid (long int __id) throw () ;
extern int getdomainname (char *__name, size_t __len)
     throw () __attribute__ ((__nonnull__ (1))) ;
extern int setdomainname (__const char *__name, size_t __len)
     throw () __attribute__ ((__nonnull__ (1))) ;
extern int vhangup (void) throw ();
extern int revoke (__const char *__file) throw () __attribute__ ((__nonnull__ (1))) ;
extern int profil (unsigned short int *__sample_buffer, size_t __size,
     size_t __offset, unsigned int __scale)
     throw () __attribute__ ((__nonnull__ (1)));
extern int acct (__const char *__name) throw ();
extern char *getusershell (void) throw ();
extern void endusershell (void) throw ();
extern void setusershell (void) throw ();
extern int daemon (int __nochdir, int __noclose) throw () ;
extern int chroot (__const char *__path) throw () __attribute__ ((__nonnull__ (1))) ;
extern char *getpass (__const char *__prompt) __attribute__ ((__nonnull__ (1)));
extern int fsync (int __fd);
extern long int gethostid (void);
extern void sync (void) throw ();
extern int getpagesize (void) throw () __attribute__ ((__const__));
extern int getdtablesize (void) throw ();
extern int truncate (__const char *__file, __off_t __length)
     throw () __attribute__ ((__nonnull__ (1))) ;
extern int truncate64 (__const char *__file, __off64_t __length)
     throw () __attribute__ ((__nonnull__ (1))) ;
extern int ftruncate (int __fd, __off_t __length) throw () ;
extern int ftruncate64 (int __fd, __off64_t __length) throw () ;
extern int brk (void *__addr) throw () ;
extern void *sbrk (intptr_t __delta) throw ();
extern long int syscall (long int __sysno, ...) throw ();
extern int lockf (int __fd, int __cmd, __off_t __len) ;
extern int lockf64 (int __fd, int __cmd, __off64_t __len) ;
extern int fdatasync (int __fildes);
extern char *crypt (__const char *__key, __const char *__salt)
     throw () __attribute__ ((__nonnull__ (1, 2)));
extern void encrypt (char *__block, int __edflag) throw () __attribute__ ((__nonnull__ (1)));
extern void swab (__const void *__restrict __from, void *__restrict __to,
    ssize_t __n) throw () __attribute__ ((__nonnull__ (1, 2)));
extern char *ctermid (char *__s) throw ();
}
namespace boost{
   __extension__ typedef long long long_long_type;
   __extension__ typedef unsigned long long ulong_long_type;
}
namespace boost { namespace detail {
    template <typename T> T make_non_const(T t) { return t; }
}}
namespace stlp_std {
class __attribute__((visibility("default"))) codecvt_base {
public:
  enum result {ok, partial, error, noconv};
};
template <class _InternT, class _ExternT, class _StateT>
class codecvt : public locale::facet, public codecvt_base {
public:
  typedef _InternT intern_type;
  typedef _ExternT extern_type;
  typedef _StateT state_type;
  explicit codecvt(size_t __refs = 0) : locale::facet(__refs) {}
  result out(state_type& __state,
             const intern_type* __from,
             const intern_type* __from_end,
             const intern_type*& __from_next,
             extern_type* __to,
             extern_type* __to_limit,
             extern_type*& __to_next) const {
   
   
    return do_out(__state,
                  __from, __from_end, __from_next,
                  __to, __to_limit, __to_next);
  }
  result unshift(state_type& __state,
                 extern_type* __to,
                 extern_type* __to_limit,
                 extern_type*& __to_next) const {
   
    return do_unshift(__state, __to, __to_limit, __to_next);
  }
  result in(state_type& __state,
            const extern_type* __from,
            const extern_type* __from_end,
            const extern_type*& __from_next,
            intern_type* __to,
            intern_type* __to_limit,
            intern_type*& __to_next) const {
   
   
    return do_in(__state,
                 __from, __from_end, __from_next,
                 __to, __to_limit, __to_next);
  }
  int encoding() const throw() { return do_encoding(); }
  bool always_noconv() const throw() { return do_always_noconv(); }
  int length(state_type& __state,
             const extern_type* __from,
             const extern_type* __from_end,
             size_t __max) const {
   
    return do_length(__state, __from, __from_end, __max);
  }
  int max_length() const throw() { return do_max_length(); }
  static locale::id id;
protected:
  ~codecvt() {}
  virtual result do_out(state_type&,
                        const intern_type* __from,
                        const intern_type*,
                        const intern_type*& __from_next,
                        extern_type* __to,
                        extern_type*,
                        extern_type*& __to_next) const
  { __from_next = __from; __to_next = __to; return noconv; }
  virtual result do_in (state_type&,
                        const extern_type* __from,
                        const extern_type*,
                        const extern_type*& __from_next,
                        intern_type* __to,
                        intern_type*,
                        intern_type*& __to_next) const
  { __from_next = __from; __to_next = __to; return noconv; }
  virtual result do_unshift(state_type&,
                            extern_type* __to,
                            extern_type*,
                            extern_type*& __to_next) const
  { __to_next = __to; return noconv; }
  virtual int do_encoding() const throw()
  { return 1; }
  virtual bool do_always_noconv() const throw()
  { return true; }
  virtual int do_length(state_type&,
                        const extern_type* __from,
                        const extern_type* __end,
                        size_t __max) const
  { return (int)(min) ( static_cast<size_t>((__end - __from)), __max); }
  virtual int do_max_length() const throw()
  { return 1; }
private:
  codecvt(const codecvt<intern_type, extern_type, state_type>&);
  codecvt<intern_type, extern_type, state_type>& operator = (const codecvt<intern_type, extern_type, state_type>&);
};
template <class _InternT, class _ExternT, class _StateT>
locale::id codecvt<_InternT, _ExternT, _StateT>::id;
template <class _InternT, class _ExternT, class _StateT>
class codecvt_byname : public codecvt<_InternT, _ExternT, _StateT> {};
template<>
class __attribute__((visibility("default"))) codecvt<char, char, mbstate_t>
  : public locale::facet, public codecvt_base {
public:
  typedef char intern_type;
  typedef char extern_type;
  typedef mbstate_t state_type;
  explicit codecvt(size_t __refs = 0) : locale::facet(__refs) {}
  result out(state_type& __state,
             const char* __from,
             const char* __from_end,
             const char*& __from_next,
             char* __to,
             char* __to_limit,
             char*& __to_next) const {
   
   
    return do_out(__state,
                  __from, __from_end, __from_next,
                  __to, __to_limit, __to_next);
  }
  result unshift(state_type& __state,
                 char* __to, char* __to_limit, char*& __to_next) const {
   
    return do_unshift(__state, __to, __to_limit, __to_next);
  }
  result in(state_type& __state,
            const char* __from,
            const char* __from_end,
            const char*& __from_next,
            char* __to,
            char* __to_limit,
            char*& __to_next) const {
   
   
    return do_in(__state,
                 __from, __from_end, __from_next,
                 __to, __to_limit, __to_next);
  }
  int encoding() const throw() { return do_encoding(); }
  bool always_noconv() const throw() { return do_always_noconv(); }
  int length(state_type& __state,
             const char* __from, const char* __from_end,
             size_t __max) const {
   
    return do_length(__state, __from, __from_end, __max);
  }
  int max_length() const throw() { return do_max_length(); }
  static locale::id id;
protected:
  ~codecvt();
  virtual result do_out(state_type& ,
                        const char* __from,
                        const char* ,
                        const char*& __from_next,
                        char* __to,
                        char* ,
                        char*& __to_next) const;
  virtual result do_in (state_type& ,
                        const char* __from,
                        const char* ,
                        const char*& __from_next,
                        char* __to,
                        char* ,
                        char*& __to_next) const;
  virtual result do_unshift(state_type& ,
                            char* __to,
                            char* ,
                            char*& __to_next) const;
  virtual int do_encoding() const throw();
  virtual bool do_always_noconv() const throw();
  virtual int do_length(state_type& __state,
                        const char* __from,
                        const char* __end,
                        size_t __max) const;
  virtual int do_max_length() const throw();
private:
  codecvt(const codecvt<char, char, mbstate_t>&);
  codecvt<char, char, mbstate_t>& operator =(const codecvt<char, char, mbstate_t>&);
};
template<>
class __attribute__((visibility("default"))) codecvt<wchar_t, char, mbstate_t>
  : public locale::facet, public codecvt_base {
public:
  typedef wchar_t intern_type;
  typedef char extern_type;
  typedef mbstate_t state_type;
  explicit codecvt(size_t __refs = 0) : locale::facet(__refs) {}
  result out(state_type& __state,
             const wchar_t* __from,
             const wchar_t* __from_end,
             const wchar_t*& __from_next,
             char* __to,
             char* __to_limit,
             char*& __to_next) const {
   
   
    return do_out(__state,
                  __from, __from_end, __from_next,
                  __to, __to_limit, __to_next);
  }
  result unshift(state_type& __state,
                 char* __to, char* __to_limit, char*& __to_next) const {
   
    return do_unshift(__state, __to, __to_limit, __to_next);
  }
  result in(state_type& __state,
            const char* __from,
            const char* __from_end,
            const char*& __from_next,
            wchar_t* __to,
            wchar_t* __to_limit,
            wchar_t*& __to_next) const {
   
   
    return do_in(__state,
                 __from, __from_end, __from_next,
                 __to, __to_limit, __to_next);
  }
  int encoding() const throw() { return do_encoding(); }
  bool always_noconv() const throw() { return do_always_noconv(); }
  int length(state_type& __state,
             const char* __from, const char* __from_end,
             size_t __max) const {
   
    return do_length(__state, __from, __from_end, __max);
  }
  int max_length() const throw() { return do_max_length(); }
  static locale::id id;
protected:
  ~codecvt();
  virtual result do_out(state_type& __state,
                        const wchar_t* __from,
                        const wchar_t* __from_end,
                        const wchar_t*& __from_next,
                        char* __to,
                        char* __to_limit,
                        char*& __to_next) const;
  virtual result do_in (state_type& __state,
                        const char* __from,
                        const char* __from_end,
                        const char*& __from_next,
                        wchar_t* __to,
                        wchar_t* __to_limit,
                        wchar_t*& __to_next) const;
  virtual result do_unshift(state_type& __state,
                            char* __to,
                            char* __to_limit,
                            char*& __to_next) const;
  virtual int do_encoding() const throw();
  virtual bool do_always_noconv() const throw();
  virtual int do_length(state_type& __state,
                        const char* __from,
                        const char* __end,
                        size_t __max) const;
  virtual int do_max_length() const throw();
private:
  codecvt(const codecvt<wchar_t, char, mbstate_t>&);
  codecvt<wchar_t, char, mbstate_t>& operator = (const codecvt<wchar_t, char, mbstate_t>&);
};
template<>
class __attribute__((visibility("default"))) codecvt_byname<char, char, mbstate_t>
  : public codecvt<char, char, mbstate_t> {
public:
  explicit codecvt_byname(const char* __name, size_t __refs = 0);
  ~codecvt_byname();
private:
  codecvt_byname(const codecvt_byname<char, char, mbstate_t>&);
  codecvt_byname<char, char, mbstate_t>& operator =(const codecvt_byname<char, char, mbstate_t>&);
};
template<>
class __attribute__((visibility("default"))) codecvt_byname<wchar_t, char, mbstate_t>
  : public codecvt<wchar_t, char, mbstate_t> {
  friend class _Locale_impl;
public:
  explicit codecvt_byname(const char * __name, size_t __refs = 0);
protected:
  ~codecvt_byname();
  virtual result do_out(state_type& __state,
                        const wchar_t* __from,
                        const wchar_t* __from_end,
                        const wchar_t*& __from_next,
                        char* __to,
                        char* __to_limit,
                        char*& __to_next) const;
  virtual result do_in (state_type& __state,
                        const char* __from,
                        const char* __from_end,
                        const char*& __from_next,
                        wchar_t* __to,
                        wchar_t* __to_limit,
                        wchar_t*& __to_next) const;
  virtual result do_unshift(state_type& __state,
                            char* __to,
                            char* __to_limit,
                            char*& __to_next) const;
  virtual int do_encoding() const throw();
  virtual bool do_always_noconv() const throw();
  virtual int do_length(state_type& __state,
                        const char* __from,
                        const char* __end,
                        size_t __max) const;
  virtual int do_max_length() const throw();
private:
  codecvt_byname(_Locale_codecvt* __cvt)
    : _M_codecvt(__cvt) {}
  codecvt_byname(const codecvt_byname<wchar_t, char, mbstate_t>&);
  codecvt_byname<wchar_t, char, mbstate_t>& operator =(const codecvt_byname<wchar_t, char, mbstate_t>&);
  _Locale_codecvt* _M_codecvt;
};
}
namespace stlp_std {
template <class _CharT> class collate {};
template <class _CharT> class collate_byname {};
template<>
class __attribute__((visibility("default"))) collate<char> : public locale::facet {
public:
  typedef char char_type;
  typedef string string_type;
  explicit collate(size_t __refs = 0) : locale::facet(__refs) {}
  int compare(const char* __low1, const char* __high1,
              const char* __low2, const char* __high2) const {
    return do_compare( __low1, __high1, __low2, __high2);
  }
  string_type transform(const char* __low, const char* __high) const {
    return do_transform(__low, __high);
  }
  long hash(const char* __low, const char* __high) const
    { return do_hash(__low, __high); }
  static locale::id id;
protected:
  ~collate();
  virtual int do_compare(const char*, const char*,
                         const char*, const char*) const;
  virtual string_type do_transform(const char*, const char*) const;
  virtual long do_hash(const char*, const char*) const;
private:
  collate(const collate<char>&);
  collate<char>& operator =(const collate<char>&);
};
template<>
class __attribute__((visibility("default"))) collate<wchar_t> : public locale::facet {
public:
  typedef wchar_t char_type;
  typedef wstring string_type;
  explicit collate(size_t __refs = 0) : locale::facet(__refs) {}
  int compare(const wchar_t* __low1, const wchar_t* __high1,
              const wchar_t* __low2, const wchar_t* __high2) const {
    return do_compare( __low1, __high1, __low2, __high2);
  }
  string_type transform(const wchar_t* __low, const wchar_t* __high) const {
    return do_transform(__low, __high);
  }
  long hash(const wchar_t* __low, const wchar_t* __high) const
    { return do_hash(__low, __high); }
  static locale::id id;
protected:
  ~collate();
  virtual int do_compare(const wchar_t*, const wchar_t*,
                         const wchar_t*, const wchar_t*) const;
  virtual string_type do_transform(const wchar_t*, const wchar_t*) const;
  virtual long do_hash(const wchar_t* __low, const wchar_t* __high) const;
private:
  collate(const collate<wchar_t>&);
  collate<wchar_t>& operator = (const collate<wchar_t>&);
};
template<>
class __attribute__((visibility("default"))) collate_byname<char>: public collate<char> {
  friend class _Locale_impl;
public:
  explicit collate_byname(const char* __name, size_t __refs = 0);
protected:
  ~collate_byname();
  virtual int do_compare(const char*, const char*,
                         const char*, const char*) const;
  virtual string_type do_transform(const char*, const char*) const;
private:
  collate_byname(_Locale_collate *__coll)
    : _M_collate(__coll) {}
  _Locale_collate* _M_collate;
  collate_byname(const collate_byname<char>&);
  collate_byname<char>& operator =(const collate_byname<char>&);
};
template<>
class __attribute__((visibility("default"))) collate_byname<wchar_t>: public collate<wchar_t> {
  friend class _Locale_impl;
public:
  explicit collate_byname(const char * __name, size_t __refs = 0);
protected:
  ~collate_byname();
  virtual int do_compare(const wchar_t*, const wchar_t*,
                         const wchar_t*, const wchar_t*) const;
  virtual string_type do_transform(const wchar_t*, const wchar_t*) const;
private:
  collate_byname(_Locale_collate *__coll)
    : _M_collate(__coll) {}
  _Locale_collate* _M_collate;
  collate_byname(const collate_byname<wchar_t>&);
  collate_byname<wchar_t>& operator =(const collate_byname<wchar_t>&);
};
template <class _CharT, class _Traits, class _Alloc>
bool
__locale_do_operator_call (const locale& __loc,
                           const basic_string<_CharT, _Traits, _Alloc>& __x,
                           const basic_string<_CharT, _Traits, _Alloc>& __y) {
  collate<_CharT> const& __coll = use_facet<collate<_CharT> >(__loc);
  return __coll.compare(__x.data(), __x.data() + __x.size(),
                        __y.data(), __y.data() + __y.size()) < 0;
}
}
namespace stlp_std {
class money_base {
public:
  enum part {none, space, symbol, sign, value};
  struct pattern {
    char field[4];
  };
};
template <class _charT, bool _International = false > class moneypunct {};
template <class _CharT, class _InputIter>
class money_get : public locale::facet {
public:
  typedef _CharT char_type;
  typedef _InputIter iter_type;
  typedef basic_string<_CharT, char_traits<_CharT>, allocator<_CharT> > string_type;
  explicit money_get(size_t __refs = 0) : locale::facet(__refs) {}
  iter_type get(iter_type __s, iter_type __end, bool __intl,
                ios_base& __str, ios_base::iostate& __err,
                long double& __units) const
  { return do_get(__s, __end, __intl, __str, __err, __units); }
  iter_type get(iter_type __s, iter_type __end, bool __intl,
                ios_base& __str, ios_base::iostate& __err,
                string_type& __digits) const
  { return do_get(__s, __end, __intl, __str, __err, __digits); }
  static locale::id id;
protected:
  ~money_get() {}
  virtual iter_type do_get(iter_type __s, iter_type __end, bool __intl,
                           ios_base& __str, ios_base::iostate& __err,
                           long double& __units) const;
  virtual iter_type do_get(iter_type __s, iter_type __end, bool __intl,
                           ios_base& __str, ios_base::iostate& __err,
                           string_type& __digits) const;
};
template<>
class __attribute__((visibility("default"))) moneypunct<char, true> : public locale::facet, public money_base {
public:
  typedef char char_type;
  typedef string string_type;
  explicit moneypunct (size_t __refs = 0);
  char decimal_point() const { return do_decimal_point(); }
  char thousands_sep() const { return do_thousands_sep(); }
  string grouping() const { return do_grouping(); }
  string_type curr_symbol() const { return do_curr_symbol(); }
  string_type positive_sign() const { return do_positive_sign(); }
  string_type negative_sign() const { return do_negative_sign(); }
  int frac_digits() const { return do_frac_digits(); }
  pattern pos_format() const { return do_pos_format(); }
  pattern neg_format() const { return do_neg_format(); }
  static locale::id id;
  static const bool intl = true;
protected:
  pattern _M_pos_format;
  pattern _M_neg_format;
  ~moneypunct ();
  virtual char do_decimal_point() const;
  virtual char do_thousands_sep() const;
  virtual string do_grouping() const;
  virtual string do_curr_symbol() const;
  virtual string do_positive_sign() const;
  virtual string do_negative_sign() const;
  virtual int do_frac_digits() const;
  virtual pattern do_pos_format() const;
  virtual pattern do_neg_format() const;
};
template<>
class __attribute__((visibility("default"))) moneypunct<char, false> : public locale::facet, public money_base {
public:
  typedef char char_type;
  typedef string string_type;
  explicit moneypunct (size_t __refs = 0);
  char decimal_point() const { return do_decimal_point(); }
  char thousands_sep() const { return do_thousands_sep(); }
  string grouping() const { return do_grouping(); }
  string_type curr_symbol() const { return do_curr_symbol(); }
  string_type positive_sign() const { return do_positive_sign(); }
  string_type negative_sign() const { return do_negative_sign(); }
  int frac_digits() const { return do_frac_digits(); }
  pattern pos_format() const { return do_pos_format(); }
  pattern neg_format() const { return do_neg_format(); }
  static locale::id id;
  static const bool intl = false;
protected:
  pattern _M_pos_format;
  pattern _M_neg_format;
  ~moneypunct ();
  virtual char do_decimal_point() const;
  virtual char do_thousands_sep() const;
  virtual string do_grouping() const;
  virtual string do_curr_symbol() const;
  virtual string do_positive_sign() const;
  virtual string do_negative_sign() const;
  virtual int do_frac_digits() const;
  virtual pattern do_pos_format() const;
  virtual pattern do_neg_format() const;
};
template<>
class __attribute__((visibility("default"))) moneypunct<wchar_t, true> : public locale::facet, public money_base {
public:
  typedef wchar_t char_type;
  typedef wstring string_type;
  explicit moneypunct (size_t __refs = 0);
  wchar_t decimal_point() const { return do_decimal_point(); }
  wchar_t thousands_sep() const { return do_thousands_sep(); }
  string grouping() const { return do_grouping(); }
  string_type curr_symbol() const { return do_curr_symbol(); }
  string_type positive_sign() const { return do_positive_sign(); }
  string_type negative_sign() const { return do_negative_sign(); }
  int frac_digits() const { return do_frac_digits(); }
  pattern pos_format() const { return do_pos_format(); }
  pattern neg_format() const { return do_neg_format(); }
  static locale::id id;
  static const bool intl = true;
protected:
  pattern _M_pos_format;
  pattern _M_neg_format;
  ~moneypunct ();
  virtual wchar_t do_decimal_point() const;
  virtual wchar_t do_thousands_sep() const;
  virtual string do_grouping() const;
  virtual string_type do_curr_symbol() const;
  virtual string_type do_positive_sign() const;
  virtual string_type do_negative_sign() const;
  virtual int do_frac_digits() const;
  virtual pattern do_pos_format() const;
  virtual pattern do_neg_format() const;
};
template<>
class __attribute__((visibility("default"))) moneypunct<wchar_t, false> : public locale::facet, public money_base {
public:
  typedef wchar_t char_type;
  typedef wstring string_type;
  explicit moneypunct (size_t __refs = 0);
  wchar_t decimal_point() const { return do_decimal_point(); }
  wchar_t thousands_sep() const { return do_thousands_sep(); }
  string grouping() const { return do_grouping(); }
  string_type curr_symbol() const { return do_curr_symbol(); }
  string_type positive_sign() const { return do_positive_sign(); }
  string_type negative_sign() const { return do_negative_sign(); }
  int frac_digits() const { return do_frac_digits(); }
  pattern pos_format() const { return do_pos_format(); }
  pattern neg_format() const { return do_neg_format(); }
  static locale::id id;
  static const bool intl = false;
protected:
  pattern _M_pos_format;
  pattern _M_neg_format;
  ~moneypunct ();
  virtual wchar_t do_decimal_point() const;
  virtual wchar_t do_thousands_sep() const;
  virtual string do_grouping() const;
  virtual string_type do_curr_symbol() const;
  virtual string_type do_positive_sign() const;
  virtual string_type do_negative_sign() const;
  virtual int do_frac_digits() const;
  virtual pattern do_pos_format() const;
  virtual pattern do_neg_format() const;
};
template <class _charT, bool _International = false > class moneypunct_byname {};
template<>
class __attribute__((visibility("default"))) moneypunct_byname<char, true> : public moneypunct<char, true> {
  friend class _Locale_impl;
public:
  typedef money_base::pattern pattern;
  typedef char char_type;
  typedef string string_type;
  explicit moneypunct_byname (const char * __name, size_t __refs = 0);
protected:
  ~moneypunct_byname ();
  virtual char do_decimal_point() const;
  virtual char do_thousands_sep() const;
  virtual string do_grouping() const;
  virtual string_type do_curr_symbol() const;
  virtual string_type do_positive_sign() const;
  virtual string_type do_negative_sign() const;
  virtual int do_frac_digits() const;
private:
  moneypunct_byname (_Locale_monetary *__monetary);
  typedef moneypunct_byname<char, true> _Self;
  moneypunct_byname(_Self const&);
  _Self& operator = (_Self const&);
  _Locale_monetary* _M_monetary;
};
template<>
class __attribute__((visibility("default"))) moneypunct_byname<char, false> : public moneypunct<char, false> {
  friend class _Locale_impl;
public:
  typedef money_base::pattern pattern;
  typedef char char_type;
  typedef string string_type;
  explicit moneypunct_byname (const char * __name, size_t __refs = 0);
protected:
  ~moneypunct_byname ();
  virtual char do_decimal_point() const;
  virtual char do_thousands_sep() const;
  virtual string do_grouping() const;
  virtual string_type do_curr_symbol() const;
  virtual string_type do_positive_sign() const;
  virtual string_type do_negative_sign() const;
  virtual int do_frac_digits() const;
private:
  moneypunct_byname (_Locale_monetary *__monetary);
  typedef moneypunct_byname<char, false> _Self;
  moneypunct_byname(_Self const&);
  _Self& operator = (_Self const&);
  _Locale_monetary* _M_monetary;
};
template<>
class __attribute__((visibility("default"))) moneypunct_byname<wchar_t, true> : public moneypunct<wchar_t, true> {
  friend class _Locale_impl;
public:
  typedef money_base::pattern pattern;
  typedef wchar_t char_type;
  typedef wstring string_type;
  explicit moneypunct_byname (const char * __name, size_t __refs = 0);
protected:
  ~moneypunct_byname ();
  virtual wchar_t do_decimal_point() const;
  virtual wchar_t do_thousands_sep() const;
  virtual string do_grouping() const;
  virtual string_type do_curr_symbol() const;
  virtual string_type do_positive_sign() const;
  virtual string_type do_negative_sign() const;
  virtual int do_frac_digits() const;
private:
  moneypunct_byname (_Locale_monetary *__monetary);
  typedef moneypunct_byname<wchar_t, true> _Self;
  moneypunct_byname(_Self const&);
  _Self& operator = (_Self const&);
  _Locale_monetary* _M_monetary;
};
template<>
class __attribute__((visibility("default"))) moneypunct_byname<wchar_t, false> : public moneypunct<wchar_t, false> {
  friend class _Locale_impl;
public:
  typedef money_base::pattern pattern;
  typedef wchar_t char_type;
  typedef wstring string_type;
  explicit moneypunct_byname (const char * __name, size_t __refs = 0);
protected:
  ~moneypunct_byname ();
  virtual wchar_t do_decimal_point() const;
  virtual wchar_t do_thousands_sep() const;
  virtual string do_grouping() const;
  virtual string_type do_curr_symbol() const;
  virtual string_type do_positive_sign() const;
  virtual string_type do_negative_sign() const;
  virtual int do_frac_digits() const;
private:
  moneypunct_byname (_Locale_monetary *__monetary);
  typedef moneypunct_byname<wchar_t, false> _Self;
  moneypunct_byname(_Self const&);
  _Self& operator = (_Self const&);
  _Locale_monetary* _M_monetary;
};
template <class _CharT, class _OutputIter>
class money_put : public locale::facet {
public:
  typedef _CharT char_type;
  typedef _OutputIter iter_type;
  typedef basic_string<_CharT, char_traits<_CharT>, allocator<_CharT> > string_type;
  explicit money_put(size_t __refs = 0) : locale::facet(__refs) {}
  iter_type put(iter_type __s, bool __intl, ios_base& __str,
                char_type __fill, long double __units) const
    { return do_put(__s, __intl, __str, __fill, __units); }
  iter_type put(iter_type __s, bool __intl, ios_base& __str,
                char_type __fill,
                const string_type& __digits) const
    { return do_put(__s, __intl, __str, __fill, __digits); }
  static locale::id id;
protected:
  ~money_put() {}
  virtual iter_type do_put(iter_type __s, bool __intl, ios_base& __str,
                           char_type __fill, long double __units) const;
  virtual iter_type do_put(iter_type __s, bool __intl, ios_base& __str,
                           char_type __fill,
                           const string_type& __digits) const;
};
}
namespace stlp_std {
template <class _CharT, class _InputIterator>
locale::id money_get<_CharT, _InputIterator>::id;
template <class _CharT, class _OutputIterator>
locale::id money_put<_CharT, _OutputIterator>::id;
namespace priv {
template <class _InIt1, class _InIt2>
pair<_InIt1, bool> __get_string( _InIt1 __first, _InIt1 __last,
                                 _InIt2 __str_first, _InIt2 __str_last) {
  while ( __first != __last && __str_first != __str_last && *__first == *__str_first ) {
    ++__first;
    ++__str_first;
  }
  return make_pair(__first, __str_first == __str_last);
}
template <class _InIt, class _OuIt, class _CharT>
bool
__get_monetary_value(_InIt& __first, _InIt __last, _OuIt __out_ite,
                     const ctype<_CharT>& _c_type,
                     _CharT __point, int __frac_digits, _CharT __sep,
                     const string& __grouping, bool &__syntax_ok) {
  if (__first == __last || !_c_type.is(ctype_base::digit, *__first))
    return false;
  char __group_sizes[128];
  char* __group_sizes_end = __grouping.empty()? 0 : __group_sizes;
  char __current_group_size = 0;
  while (__first != __last) {
    if (_c_type.is(ctype_base::digit, *__first)) {
      ++__current_group_size;
      *__out_ite++ = *__first++;
    }
    else if (__group_sizes_end) {
      if (*__first == __sep) {
        *__group_sizes_end++ = __current_group_size;
        __current_group_size = 0;
        ++__first;
      }
      else break;
    }
    else
      break;
  }
  if (__grouping.empty())
    __syntax_ok = true;
  else {
    if (__group_sizes_end != __group_sizes)
      *__group_sizes_end++ = __current_group_size;
    __syntax_ok = __valid_grouping(__group_sizes, __group_sizes_end,
                                   __grouping.data(), __grouping.data()+ __grouping.size());
    if (__first == __last || *__first != __point) {
      for (int __digits = 0; __digits != __frac_digits; ++__digits)
        *__out_ite++ = _CharT('0');
      return true;
    }
  }
  ++__first;
  int __digits = 0;
  while (__first != __last && _c_type.is(ctype_base::digit, *__first)) {
      *__out_ite++ = *__first++;
     ++__digits;
  }
  __syntax_ok = __syntax_ok && (__digits == __frac_digits);
  return true;
}
template <class _CharT, class _InputIter, class _StrType>
_InputIter __money_do_get(_InputIter __s, _InputIter __end, bool __intl,
                     ios_base& __str, ios_base::iostate& __err,
                     _StrType& __digits, bool &__is_positive, _CharT* ) {
  if (__s == __end) {
    __err |= ios_base::eofbit;
    return __s;
  }
  typedef _CharT char_type;
  typedef _StrType string_type;
  typedef _InputIter iter_type;
  typedef moneypunct<char_type, false> _Punct;
  typedef moneypunct<char_type, true> _Punct_intl;
  typedef ctype<char_type> _Ctype;
  locale __loc = __str.getloc();
  const _Punct& __punct = use_facet<_Punct>(__loc) ;
  const _Punct_intl& __punct_intl = use_facet<_Punct_intl>(__loc) ;
  const _Ctype& __c_type = use_facet<_Ctype>(__loc) ;
  money_base::pattern __format = __intl ? __punct_intl.neg_format()
                                        : __punct.neg_format();
  string_type __ns = __intl ? __punct_intl.negative_sign()
                            : __punct.negative_sign();
  string_type __ps = __intl ? __punct_intl.positive_sign()
                            : __punct.positive_sign();
  int __i;
  bool __symbol_required = (__str.flags() & ios_base::showbase) != 0;
  string_type __buf;
  back_insert_iterator<string_type> __out_ite(__buf);
  for (__i = 0; __i < 4; ++__i) {
    switch (__format.field[__i]) {
    case money_base::space:
      if (!__c_type.is(ctype_base::space, *__s)) {
        __err = ios_base::failbit;
        return __s;
      }
      ++__s;
    case money_base::none:
      while (__s != __end && __c_type.is(ctype_base::space, *__s))
        ++__s;
      break;
    case money_base::symbol: {
      string_type __curs = __intl ? __punct_intl.curr_symbol()
                                  : __punct.curr_symbol();
      pair<iter_type, bool>
      __result = __get_string(__s, __end, __curs.begin(), __curs.end());
      if (!__result.second && __symbol_required)
        __err = ios_base::failbit;
      __s = __result.first;
      break;
    }
    case money_base::sign: {
      if (__s == __end) {
        if (__ps.empty())
          break;
        if (__ns.empty()) {
          __is_positive = false;
          break;
        }
        __err = ios_base::failbit;
        return __s;
      }
      else {
        if (__ps.empty()) {
          if (__ns.empty())
            break;
          if (*__s == __ns[0]) {
            ++__s;
            __is_positive = false;
          }
          break;
        }
        else {
          if (*__s == __ps[0]) {
            ++__s;
            break;
          }
          if (__ns.empty())
            break;
          if (*__s == __ns[0]) {
            ++__s;
            __is_positive = false;
            break;
          }
          __err = ios_base::failbit;
        }
      }
      return __s;
    }
    case money_base::value: {
      char_type __point = __intl ? __punct_intl.decimal_point()
                                 : __punct.decimal_point();
      int __frac_digits = __intl ? __punct_intl.frac_digits()
                                 : __punct.frac_digits();
      string __grouping = __intl ? __punct_intl.grouping()
                                 : __punct.grouping();
      bool __syntax_ok = true;
      bool __result;
      char_type __sep = __grouping.empty() ? char_type() :
      __intl ? __punct_intl.thousands_sep() : __punct.thousands_sep();
      __result = __get_monetary_value(__s, __end, __out_ite, __c_type,
                                      __point, __frac_digits,
                                      __sep,
                                      __grouping, __syntax_ok);
      if (!__syntax_ok)
        __err |= ios_base::failbit;
      if (!__result) {
        __err = ios_base::failbit;
        return __s;
      }
      break;
    }
    }
  }
  if (__is_positive) {
    if (__ps.size() > 1) {
      pair<_InputIter, bool>
        __result = __get_string(__s, __end, __ps.begin() + 1, __ps.end());
      __s = __result.first;
      if (!__result.second)
        __err |= ios::failbit;
    }
    if (!(__err & ios_base::failbit))
      __digits = __buf;
  }
  else {
    if (__ns.size() > 1) {
      pair<_InputIter, bool>
        __result = __get_string(__s, __end, __ns.begin() + 1, __ns.end());
      __s = __result.first;
      if (!__result.second)
        __err |= ios::failbit;
    }
    if (!(__err & ios::failbit)) {
      __digits = __c_type.widen('-');
      __digits += __buf;
    }
  }
  if (__s == __end)
    __err |= ios::eofbit;
  return __s;
}
}
template <class _CharT, class _InputIter>
_InputIter
money_get<_CharT, _InputIter>::do_get(_InputIter __s, _InputIter __end, bool __intl,
                                      ios_base& __str, ios_base::iostate& __err,
                                      long double& __units) const {
  string_type __buf;
  bool __is_positive = true;
  __s = ::stlp_std::priv:: __money_do_get(__s, __end, __intl, __str, __err, __buf, __is_positive, (_CharT*)0);
  if (__err == ios_base::goodbit || __err == ios_base::eofbit) {
    typename string_type::iterator __b = __buf.begin(), __e = __buf.end();
    if (!__is_positive) ++__b;
    ::stlp_std::priv:: __get_decimal_integer(__b, __e, __units, (_CharT*)0);
    if (!__is_positive) {
      __units = -__units;
    }
  }
  return __s;
}
template <class _CharT, class _InputIter>
_InputIter
money_get<_CharT, _InputIter>::do_get(iter_type __s, iter_type __end, bool __intl,
                                      ios_base& __str, ios_base::iostate& __err,
                                      string_type& __digits) const {
  bool __is_positive = true;
  return ::stlp_std::priv:: __money_do_get(__s, __end, __intl, __str, __err, __digits, __is_positive, (_CharT*)0);
}
namespace priv {
template <class _CharT, class _OutputIter, class _Str_Type, class _Str>
_OutputIter __money_do_put(_OutputIter __s, bool __intl, ios_base& __str,
                           _CharT __fill, const _Str& __digits, bool __check_digits,
                           _Str_Type * ) {
  typedef _CharT char_type;
  typedef _Str_Type string_type;
  typedef ctype<char_type> _Ctype;
  typedef moneypunct<char_type, false> _Punct;
  typedef moneypunct<char_type, true> _Punct_intl;
  locale __loc = __str.getloc();
  const _Ctype& __c_type = use_facet<_Ctype>(__loc) ;
  const _Punct& __punct = use_facet<_Punct>(__loc) ;
  const _Punct_intl& __punct_intl = use_facet<_Punct_intl>(__loc) ;
  char_type __minus = __c_type.widen('-');
  char_type __plus = __c_type.widen('+');
  char_type __space = __c_type.widen(' ');
  char_type __zero = __c_type.widen('0');
  char_type __point = __intl ? __punct_intl.decimal_point()
                             : __punct.decimal_point();
  char_type __sep = __intl ? __punct_intl.thousands_sep()
                           : __punct.thousands_sep();
  string __grouping = __intl ? __punct_intl.grouping()
                             : __punct.grouping();
  int __frac_digits = __intl ? __punct_intl.frac_digits()
                                  : __punct.frac_digits();
  string_type __curr_sym = __intl ? __punct_intl.curr_symbol()
                                  : __punct.curr_symbol();
  if (__digits.empty())
    return __s;
  typename string_type::const_iterator __digits_first = __digits.begin();
  typename string_type::const_iterator __digits_last = __digits.end();
  bool __is_negative = *__digits_first == __minus;
  if (__is_negative)
    ++__digits_first;
  string_type __sign = __intl ? __is_negative ? __punct_intl.negative_sign()
                                              : __punct_intl.positive_sign()
                              : __is_negative ? __punct.negative_sign()
                                              : __punct.positive_sign();
  if (__check_digits) {
    typename string_type::const_iterator __cp = __digits_first;
    while (__cp != __digits_last && __c_type.is(ctype_base::digit, *__cp))
      ++__cp;
    if (__cp == __digits_first)
      return __s;
    __digits_last = __cp;
  }
  ::stlp_std::priv:: __basic_iostring<char_type> __new_digits;
  if (!__grouping.empty()) {
    __new_digits.assign(__digits_first, __digits_last);
    __insert_grouping(__new_digits,
                      __new_digits.size() - __frac_digits,
                      __grouping,
                      __sep, __plus, __minus, 0);
    __digits_first = __new_digits.begin();
    __digits_last = __new_digits.end();
  }
  streamsize __width = __str.width();
  size_t __value_length = __digits_last - __digits_first;
  size_t __length = __value_length + __sign.size();
  if (__frac_digits != 0)
    ++__length;
  bool __generate_curr = (__str.flags() & ios_base::showbase) !=0;
  if (__generate_curr)
    __length += __curr_sym.size();
  money_base::pattern __format = __intl ? (__is_negative ? __punct_intl.neg_format()
                                                         : __punct_intl.pos_format())
                                        : (__is_negative ? __punct.neg_format()
                                                         : __punct.pos_format());
  {
    if ((__format.field[1] == (char) money_base::space) ||
        (__format.field[2] == (char) money_base::space))
      ++__length;
  }
  const bool __need_fill = (((sizeof(streamsize) > sizeof(size_t)) && (static_cast<streamsize>(__length) < __width)) ||
                            ((sizeof(streamsize) <= sizeof(size_t)) && (__length < static_cast<size_t>(__width))));
  streamsize __fill_amt = __need_fill ? __width - __length : 0;
  ios_base::fmtflags __fill_pos = __str.flags() & ios_base::adjustfield;
  if (__fill_amt != 0 &&
      !(__fill_pos & (ios_base::left | ios_base::internal)))
    __s = ::stlp_std::priv:: __fill_n(__s, __fill_amt, __fill);
  for (int __i = 0; __i < 4; ++__i) {
    char __ffield = __format.field[__i];
    switch (__ffield) {
      case money_base::space:
        *__s++ = __space;
      case money_base::none:
        if (__fill_amt != 0 && __fill_pos == ios_base::internal)
          __s = ::stlp_std::priv:: __fill_n(__s, __fill_amt, __fill);
        break;
      case money_base::symbol:
        if (__generate_curr)
          __s = ::stlp_std::copy(__curr_sym.begin(), __curr_sym.end(), __s);
        break;
      case money_base::sign:
        if (!__sign.empty())
          *__s++ = __sign[0];
        break;
      case money_base::value:
        if (__frac_digits == 0) {
          __s = ::stlp_std::copy(__digits_first, __digits_last, __s);
        } else {
          if ((int)__value_length <= __frac_digits) {
            *__s++ = __zero;
            *__s++ = __point;
            __s = ::stlp_std::priv:: __fill_n(__s, __frac_digits - __value_length, __zero);
            __s = ::stlp_std::copy(__digits_first, __digits_last, __s);
          } else {
            __s = ::stlp_std::copy(__digits_first, __digits_last - __frac_digits, __s);
            if (__frac_digits != 0) {
              *__s++ = __point;
              __s = ::stlp_std::copy(__digits_last - __frac_digits, __digits_last, __s);
            }
          }
        }
        break;
    }
  }
  if (__sign.size() > 1)
    __s = ::stlp_std::copy(__sign.begin() + 1, __sign.end(), __s);
  if (__fill_amt != 0 &&
      !(__fill_pos & (ios_base::right | ios_base::internal)))
    __s = ::stlp_std::priv:: __fill_n(__s, __fill_amt, __fill);
  return __s;
}
}
template <class _CharT, class _OutputIter>
_OutputIter
money_put<_CharT, _OutputIter>
 ::do_put(_OutputIter __s, bool __intl, ios_base& __str,
          char_type __fill, long double __units) const {
  ::stlp_std::priv:: __basic_iostring<char_type> __digits;
  ::stlp_std::priv:: __get_money_digits(__digits, __str, __units);
  return ::stlp_std::priv:: __money_do_put(__s, __intl, __str, __fill, __digits, false, static_cast<string_type*>(0));
}
template <class _CharT, class _OutputIter>
_OutputIter
money_put<_CharT, _OutputIter>
 ::do_put(_OutputIter __s, bool __intl, ios_base& __str,
          char_type __fill, const string_type& __digits) const {
  return ::stlp_std::priv:: __money_do_put(__s, __intl, __str, __fill, __digits, true, static_cast<string_type*>(0));
}
}
namespace stlp_std {
namespace priv {
class __attribute__((visibility("default"))) _Time_Info_Base {
public:
  string _M_time_format;
  string _M_date_format;
  string _M_date_time_format;
  string _M_long_date_format;
  string _M_long_date_time_format;
};
class __attribute__((visibility("default"))) _Time_Info : public _Time_Info_Base {
public:
  string _M_dayname[14];
  string _M_monthname[24];
  string _M_am_pm[2];
};
class __attribute__((visibility("default"))) _WTime_Info : public _Time_Info_Base {
public:
  wstring _M_dayname[14];
  wstring _M_monthname[24];
  wstring _M_am_pm[2];
};
}
class __attribute__((visibility("default"))) time_base {
public:
  enum dateorder {no_order, dmy, mdy, ymd, ydm};
};
namespace priv {
template <class _Ch>
class time_init;
template<>
class __attribute__((visibility("default"))) time_init<char> {
protected:
  time_init();
  time_init(const char *name);
  time_init(_Locale_time*);
  _Time_Info _M_timeinfo;
  time_base::dateorder _M_dateorder;
};
template<>
class __attribute__((visibility("default"))) time_init<wchar_t> {
protected:
  time_init();
  time_init(const char *name);
  time_init(_Locale_time*);
  _WTime_Info _M_timeinfo;
  time_base::dateorder _M_dateorder;
};
}
template <class _Ch, class _InIt>
class time_get : public locale::facet, public time_base, public ::stlp_std::priv:: time_init<_Ch> {
public:
  typedef _Ch char_type;
  typedef _InIt iter_type;
  explicit time_get(size_t __refs = 0) : locale::facet(__refs)
  {}
  dateorder date_order() const { return do_date_order(); }
  iter_type get_time(iter_type __s, iter_type __end, ios_base& __str,
                     ios_base::iostate& __err, tm* __t) const
  { return do_get_time(__s, __end, __str, __err, __t); }
  iter_type get_date(iter_type __s, iter_type __end, ios_base& __str,
                     ios_base::iostate& __err, tm* __t) const
  { return do_get_date(__s, __end, __str, __err, __t); }
  iter_type get_weekday(iter_type __s, iter_type __end, ios_base& __str,
                        ios_base::iostate& __err, tm* __t) const
  { return do_get_weekday(__s, __end, __str, __err, __t); }
  iter_type get_monthname(iter_type __s, iter_type __end, ios_base& __str,
                          ios_base::iostate& __err, tm* __t) const
  { return do_get_monthname(__s, __end, __str, __err, __t); }
  iter_type get_year(iter_type __s, iter_type __end, ios_base& __str,
                     ios_base::iostate& __err, tm* __t) const
  { return do_get_year(__s, __end, __str, __err, __t); }
  static locale::id id;
protected:
  time_get(const char* __name, size_t __refs)
    : locale::facet(__refs), ::stlp_std::priv:: time_init<_Ch>(__name)
  {}
  time_get(_Locale_time *__time)
    : ::stlp_std::priv:: time_init<_Ch>(__time)
  {}
  ~time_get() {}
  virtual dateorder do_date_order() const { return this->_M_dateorder; }
  virtual iter_type do_get_time(iter_type __s, iter_type __end,
                                ios_base&, ios_base::iostate& __err,
                                tm* __t) const;
  virtual iter_type do_get_date(iter_type __s, iter_type __end,
                                ios_base&, ios_base::iostate& __err,
                                tm* __t) const;
  virtual iter_type do_get_weekday(iter_type __s, iter_type __end,
                                   ios_base&,
                                   ios_base::iostate& __err,
                                   tm* __t) const;
  virtual iter_type do_get_monthname(iter_type __s, iter_type __end,
                                     ios_base&,
                                     ios_base::iostate& __err,
                                     tm* __t) const;
  virtual iter_type do_get_year(iter_type __s, iter_type __end,
                                ios_base&, ios_base::iostate& __err,
                                tm* __t) const;
};
template <class _Ch, class _InIt = istreambuf_iterator<_Ch, char_traits<_Ch> > >
class time_get_byname : public time_get<_Ch, _InIt> {
  friend class _Locale_impl;
public:
  typedef time_base::dateorder dateorder;
  typedef _InIt iter_type;
  explicit time_get_byname(const char* __name, size_t __refs = 0)
    : time_get<_Ch, _InIt>(__name, __refs) {}
protected:
  ~time_get_byname() {}
  dateorder do_date_order() const { return this->_M_dateorder; }
private:
  time_get_byname(_Locale_time *__time)
    : time_get<_Ch, _InIt>(__time)
  {}
  typedef time_get_byname<_Ch, _InIt> _Self;
  time_get_byname(_Self const&);
  _Self& operator = (_Self const&);
};
namespace priv {
__attribute__((visibility("default"))) void
__write_formatted_time(__iostring&, const ctype<char>& __ct,
                       char __format, char __modifier,
                       const _Time_Info& __table, const tm* __t);
__attribute__((visibility("default"))) void
__write_formatted_time(__iowstring&, const ctype<wchar_t>& __ct,
                       char __format, char __modifier,
                       const _WTime_Info& __table, const tm* __t);
}
template <class _Ch, class _OutIt>
class time_put : public locale::facet, public time_base, public ::stlp_std::priv:: time_init<_Ch> {
public:
  typedef _Ch char_type;
  typedef _OutIt iter_type;
  explicit time_put(size_t __refs = 0) : locale::facet(__refs)
  {}
  _OutIt put(iter_type __s, ios_base& __f, _Ch __fill,
                  const tm* __tmb,
                  const _Ch* __pat, const _Ch* __pat_end) const;
  _OutIt put(iter_type __s, ios_base& __f, _Ch __fill,
                  const tm* __tmb, char __format, char __modifier = 0) const
  { return do_put(__s, __f, __fill, __tmb, __format, __modifier); }
  static locale::id id;
protected:
  time_put(const char* __name, size_t __refs)
    : locale::facet(__refs), ::stlp_std::priv:: time_init<_Ch>(__name)
  {}
  time_put(_Locale_time *__time)
    : ::stlp_std::priv:: time_init<_Ch>(__time)
  {}
  ~time_put() {}
  virtual iter_type do_put(iter_type __s, ios_base& __f,
                           char_type , const tm* __tmb,
                           char __format, char ) const;
};
template <class _Ch, class _OutIt = ostreambuf_iterator<_Ch, char_traits<_Ch> > >
class time_put_byname : public time_put<_Ch, _OutIt> {
  friend class _Locale_impl;
public:
  typedef time_base::dateorder dateorder;
  typedef _OutIt iter_type;
  typedef _Ch char_type;
  explicit time_put_byname(const char * __name, size_t __refs = 0)
    : time_put<_Ch, _OutIt>(__name, __refs)
  {}
protected:
  ~time_put_byname() {}
private:
  time_put_byname(_Locale_time *__time)
    : time_put<_Ch, _OutIt>(__time)
  {}
  typedef time_put_byname<_Ch, _OutIt> _Self;
  time_put_byname(_Self const&);
  _Self& operator = (_Self const&);
};
}
namespace stlp_std {
template <class _CharT, class _InputIterator>
locale::id time_get<_CharT, _InputIterator>::id;
template <class _CharT, class _OutputIterator>
locale::id time_put<_CharT, _OutputIterator>::id;
namespace priv {
template <class _InIt, class _NameIt>
size_t
__match(_InIt& __first, _InIt& __last, _NameIt __name, _NameIt __name_end) {
  typedef ptrdiff_t difference_type;
  difference_type __n = __name_end - __name;
  difference_type __i, __start = 0;
  size_t __pos = 0;
  difference_type __check_count = __n;
  bool __do_not_check[24];
  size_t __matching_name_index = __n;
  memset(__do_not_check, 0, sizeof(__do_not_check));
  while (__first != __last) {
    difference_type __new_n = __n;
    for (__i = __start; __i < __n; ++__i) {
      if (!__do_not_check[__i]) {
        if (*__first == __name[__i][__pos]) {
          if (__pos == (__name[__i].size() - 1)) {
            __matching_name_index = __i;
            __do_not_check[__i] = true;
            if (__i == __start) ++__start;
            --__check_count;
            if (__check_count == 0) {
              ++__first;
              return __matching_name_index;
            }
          }
          __new_n = __i + 1;
        }
        else {
          __do_not_check[__i] = true;
          if (__i == __start) ++__start;
          --__check_count;
          if (__check_count == 0)
            return __matching_name_index;
        }
      }
      else {
        if (__i == __start) ++ __start;
      }
    }
    __n = __new_n;
    ++__first; ++__pos;
  }
  return __matching_name_index;
}
template <class _InIt1, class _Ch, class _TimeInfo>
string::const_iterator
__get_formatted_time (_InIt1 __first, _InIt1 __last,
                                 string::const_iterator __format, string::const_iterator __format_end,
                                 _Ch*, const _TimeInfo& __table,
                                 const ios_base& __s, ios_base::iostate& __err, tm* __t) {
  const ctype<_Ch>& __ct = use_facet<ctype<_Ch> >(__s.getloc());
  typedef basic_string<_Ch, char_traits<_Ch>, allocator<_Ch> > string_type;
  size_t offset;
  while (__first != __last && __format != __format_end) {
    offset = 0;
    if (*__format == '%') {
      ++__format;
      char __c = *__format;
      if (__c == '#') {
        ++__format;
        __c = *__format;
      }
      switch (__c) {
        case 'A':
          offset = 7;
        case 'a': {
          size_t __index = __match(__first, __last,
                                   __table._M_dayname + offset, __table._M_dayname + offset + 7);
          if (__index == 7)
            return __format;
          __t->tm_wday = static_cast<int>(__index);
          break;
        }
        case 'B':
          offset = 12;
        case 'b': {
          size_t __index = __match(__first, __last,
                                   __table._M_monthname + offset, __table._M_monthname + offset + 12);
          if (__index == 12)
            return __format;
          __t->tm_mon = static_cast<int>(__index);
          break;
        }
        case 'd': {
          bool __pr = __get_decimal_integer(__first, __last, __t->tm_mday, static_cast<_Ch*>(0));
          if (!__pr || __t->tm_mday < 1 || __t->tm_mday > 31) {
            __err |= ios_base::failbit;
            return __format;
          }
          break;
        }
        case 'H': case 'I': {
          bool __pr = __get_decimal_integer(__first, __last, __t->tm_hour, static_cast<_Ch*>(0));
          if (!__pr)
            return __format;
          break;
        }
        case 'j': {
          bool __pr = __get_decimal_integer(__first, __last, __t->tm_yday, static_cast<_Ch*>(0));
          if (!__pr)
            return __format;
          break;
        }
        case 'm': {
          bool __pr = __get_decimal_integer(__first, __last, __t->tm_mon, static_cast<_Ch*>(0));
          --__t->tm_mon;
          if (!__pr || __t->tm_mon < 0 || __t->tm_mon > 11) {
            __err |= ios_base::failbit;
            return __format;
          }
          break;
        }
        case 'M': {
          bool __pr = __get_decimal_integer(__first, __last, __t->tm_min, static_cast<_Ch*>(0));
          if (!__pr)
            return __format;
          break;
        }
        case 'p': {
          size_t __index = __match(__first, __last,
                                   __table._M_am_pm + 0, __table._M_am_pm + 2);
          if (__index == 2)
            return __format;
          if (__index == 1 && __t->tm_hour != 12 )
            __t->tm_hour += 12;
          if (__index == 0 && __t->tm_hour == 12 )
            __t->tm_hour = 0;
          break;
        }
        case 'S': {
          bool __pr = __get_decimal_integer(__first, __last, __t->tm_sec, static_cast<_Ch*>(0));
          if (!__pr)
            return __format;
          break;
        }
        case 'y': {
          bool __pr = __get_decimal_integer(__first, __last, __t->tm_year, static_cast<_Ch*>(0));
          if (!__pr)
            return __format;
          break;
        }
        case 'Y': {
          bool __pr = __get_decimal_integer(__first, __last, __t->tm_year, static_cast<_Ch*>(0));
          __t->tm_year -= 1900;
          if (!__pr)
            return __format;
          break;
        }
        default:
          break;
      }
    }
    else {
      if (*__first++ != __ct.widen(*__format)) break;
    }
    ++__format;
  }
  return __format;
}
template <class _InIt, class _TimeInfo>
bool
__get_short_or_long_dayname(_InIt& __first, _InIt& __last, const _TimeInfo& __table, tm* __t) {
  size_t __index = __match(__first, __last, __table._M_dayname + 0, __table._M_dayname + 14);
  if (__index != 14) {
    __t->tm_wday = static_cast<int>(__index % 7);
    return true;
  }
  return false;
}
template <class _InIt, class _TimeInfo>
bool
__get_short_or_long_monthname(_InIt& __first, _InIt& __last, const _TimeInfo& __table, tm* __t) {
  size_t __index = __match(__first, __last, __table._M_monthname + 0, __table._M_monthname + 24);
  if (__index != 24) {
    __t->tm_mon = static_cast<int>(__index % 12);
    return true;
  }
  return false;
}
}
template <class _Ch, class _InIt>
_InIt
time_get<_Ch, _InIt>::do_get_date(_InIt __s, _InIt __end,
                                  ios_base& __str, ios_base::iostate& __err,
                                  tm* __t) const {
  typedef string::const_iterator string_iterator;
  string_iterator __format = this->_M_timeinfo._M_date_format.begin();
  string_iterator __format_end = this->_M_timeinfo._M_date_format.end();
  string_iterator __result
    = ::stlp_std::priv:: __get_formatted_time(__s, __end, __format, __format_end,
                                      static_cast<_Ch*>(0), this->_M_timeinfo,
                                      __str, __err, __t);
  if (__result == __format_end)
    __err = ios_base::goodbit;
  else {
    __err = ios_base::failbit;
    if (__s == __end)
      __err |= ios_base::eofbit;
  }
  return __s;
}
template <class _Ch, class _InIt>
_InIt
time_get<_Ch, _InIt>::do_get_time(_InIt __s, _InIt __end,
                                  ios_base& __str, ios_base::iostate& __err,
                                  tm* __t) const {
  typedef string::const_iterator string_iterator;
  string_iterator __format = this->_M_timeinfo._M_time_format.begin();
  string_iterator __format_end = this->_M_timeinfo._M_time_format.end();
  string_iterator __result
    = ::stlp_std::priv:: __get_formatted_time(__s, __end, __format, __format_end,
                                      static_cast<_Ch*>(0), this->_M_timeinfo,
                                      __str, __err, __t);
  __err = __result == __format_end ? ios_base::goodbit
                                   : ios_base::failbit;
  if (__s == __end)
    __err |= ios_base::eofbit;
  return __s;
}
template <class _Ch, class _InIt>
_InIt
time_get<_Ch, _InIt>::do_get_year(_InIt __s, _InIt __end,
                                  ios_base&, ios_base::iostate& __err,
                                  tm* __t) const {
  if (__s == __end) {
    __err = ios_base::failbit | ios_base::eofbit;
    return __s;
  }
  bool __pr = ::stlp_std::priv:: __get_decimal_integer(__s, __end, __t->tm_year, static_cast<_Ch*>(0));
  __t->tm_year -= 1900;
  __err = __pr ? ios_base::goodbit : ios_base::failbit;
  if (__s == __end)
    __err |= ios_base::eofbit;
  return __s;
}
template <class _Ch, class _InIt>
_InIt
time_get<_Ch, _InIt>::do_get_weekday(_InIt __s, _InIt __end,
                                     ios_base &__str, ios_base::iostate &__err,
                                     tm *__t) const {
  bool __result =
    ::stlp_std::priv:: __get_short_or_long_dayname(__s, __end, this->_M_timeinfo, __t);
  if (__result)
    __err = ios_base::goodbit;
  else {
    __err = ios_base::failbit;
    if (__s == __end)
      __err |= ios_base::eofbit;
  }
  return __s;
}
template <class _Ch, class _InIt>
_InIt
time_get<_Ch, _InIt>::do_get_monthname(_InIt __s, _InIt __end,
                                       ios_base &__str, ios_base::iostate &__err,
                                       tm *__t) const {
  bool __result =
    ::stlp_std::priv:: __get_short_or_long_monthname(__s, __end, this->_M_timeinfo, __t);
  if (__result)
    __err = ios_base::goodbit;
  else {
    __err = ios_base::failbit;
    if (__s == __end)
      __err |= ios_base::eofbit;
  }
  return __s;
}
template<class _Ch, class _OutputIter>
_OutputIter
time_put<_Ch,_OutputIter>::put(_OutputIter __s, ios_base& __f, _Ch __fill,
                               const tm* __tmb, const _Ch* __pat,
                               const _Ch* __pat_end) const {
  const ctype<_Ch>& _Ct = use_facet<ctype<_Ch> >(__f.getloc());
  while (__pat != __pat_end) {
    char __c = _Ct.narrow(*__pat, 0);
    if (__c == '%') {
      char __mod = 0;
      ++__pat;
      __c = _Ct.narrow(*__pat++, 0);
      if (__c == '#') {
        __mod = __c;
        __c = _Ct.narrow(*__pat++, 0);
      }
      __s = do_put(__s, __f, __fill, __tmb, __c, __mod);
    }
    else
      *__s++ = *__pat++;
  }
  return __s;
}
template<class _Ch, class _OutputIter>
_OutputIter
time_put<_Ch,_OutputIter>::do_put(_OutputIter __s, ios_base& __f, _Ch ,
                                  const tm* __tmb, char __format,
                                  char __modifier ) const {
  const ctype<_Ch>& __ct = use_facet<ctype<_Ch> >(__f.getloc());
  ::stlp_std::priv:: __basic_iostring<_Ch> __buf;
  ::stlp_std::priv:: __write_formatted_time(__buf, __ct, __format, __modifier, this->_M_timeinfo, __tmb);
  return copy(__buf.begin(), __buf.end(), __s);
}
}
namespace stlp_std {
class messages_base {
  public:
    typedef int catalog;
};
template <class _CharT> class messages {};
namespace priv {
class _Messages;
}
template<>
class __attribute__((visibility("default"))) messages<char> : public locale::facet, public messages_base {
public:
  typedef messages_base::catalog catalog;
  typedef char char_type;
  typedef string string_type;
  explicit messages(size_t __refs = 0);
  catalog open(const string& __fn, const locale& __loc) const
  { return do_open(__fn, __loc); }
  string_type get(catalog __c, int __set, int __msgid,
                  const string_type& __dfault) const
  { return do_get(__c, __set, __msgid, __dfault); }
  inline void close(catalog __c) const
  { do_close(__c); }
  static locale::id id;
protected:
  ~messages() {}
  virtual catalog do_open(const string& __fn, const locale& __loc) const
  { return -1; }
  virtual string_type do_get(catalog __c, int __set, int __msgid,
                             const string_type& __dfault) const
  { return __dfault; }
  virtual void do_close(catalog __c) const
  {}
};
template<>
class __attribute__((visibility("default"))) messages<wchar_t> : public locale::facet, public messages_base {
public:
  typedef messages_base::catalog catalog;
  typedef wchar_t char_type;
  typedef wstring string_type;
  explicit messages(size_t __refs = 0);
  inline catalog open(const string& __fn, const locale& __loc) const
  { return do_open(__fn, __loc); }
  inline string_type get(catalog __c, int __set, int __msgid,
                         const string_type& __dfault) const
  { return do_get(__c, __set, __msgid, __dfault); }
  inline void close(catalog __c) const
  { do_close(__c); }
  static locale::id id;
protected:
  ~messages() {}
  virtual catalog do_open(const string& __fn, const locale& __loc) const
  { return -1; }
  virtual string_type do_get(catalog __c, int __set, int __msgid,
                             const string_type& __dfault) const
  { return __dfault; }
  virtual void do_close(catalog __c) const
  {}
};
template <class _CharT> class messages_byname {};
template<>
class __attribute__((visibility("default"))) messages_byname<char> : public messages<char> {
  friend class _Locale_impl;
public:
  typedef messages_base::catalog catalog;
  typedef string string_type;
  explicit messages_byname(const char* __name, size_t __refs = 0);
protected:
  ~messages_byname();
  virtual catalog do_open(const string& __fn, const locale& __loc) const;
  virtual string_type do_get(catalog __c, int __set, int __msgid,
                             const string_type& __dfault) const;
  virtual void do_close(catalog __c) const;
private:
  messages_byname(_Locale_messages*);
  typedef messages_byname<char> _Self;
  messages_byname(_Self const&);
  _Self& operator = (_Self const&);
  ::stlp_std::priv:: _Messages* _M_impl;
};
template<>
class __attribute__((visibility("default"))) messages_byname<wchar_t> : public messages<wchar_t> {
  friend class _Locale_impl;
public:
  typedef messages_base::catalog catalog;
  typedef wstring string_type;
  explicit messages_byname(const char* __name, size_t __refs = 0);
protected:
  ~messages_byname();
  virtual catalog do_open(const string& __fn, const locale& __loc) const;
  virtual string_type do_get(catalog __c, int __set, int __msgid,
                             const string_type& __dfault) const;
  virtual void do_close(catalog __c) const;
private:
  messages_byname(_Locale_messages*);
  typedef messages_byname<wchar_t> _Self;
  messages_byname(_Self const&);
  _Self& operator = (_Self const&);
  ::stlp_std::priv:: _Messages* _M_impl;
};
}
namespace stlp_std {
template <class _CharT>
inline bool isspace (_CharT c, const locale& loc)
{ return (use_facet<ctype<_CharT> >(loc)).is(ctype_base::space, c); }
template <class _CharT>
inline bool isprint (_CharT c, const locale& loc)
{ return (use_facet<ctype<_CharT> >(loc)).is(ctype_base::print, c); }
template <class _CharT>
inline bool iscntrl (_CharT c, const locale& loc)
{ return (use_facet<ctype<_CharT> >(loc)).is(ctype_base::cntrl, c); }
template <class _CharT>
inline bool isupper (_CharT c, const locale& loc)
{ return (use_facet<ctype<_CharT> >(loc)).is(ctype_base::upper, c); }
template <class _CharT>
inline bool islower (_CharT c, const locale& loc)
{ return (use_facet<ctype<_CharT> >(loc)).is(ctype_base::lower, c); }
template <class _CharT>
inline bool isalpha (_CharT c, const locale& loc)
{ return (use_facet<ctype<_CharT> >(loc)).is(ctype_base::alpha, c); }
template <class _CharT>
inline bool isdigit (_CharT c, const locale& loc)
{ return (use_facet<ctype<_CharT> >(loc)).is(ctype_base::digit, c); }
template <class _CharT>
inline bool ispunct (_CharT c, const locale& loc)
{ return (use_facet<ctype<_CharT> >(loc)).is(ctype_base::punct, c); }
template <class _CharT>
inline bool isxdigit (_CharT c, const locale& loc)
{ return (use_facet<ctype<_CharT> >(loc)).is(ctype_base::xdigit, c); }
template <class _CharT>
inline bool isalnum (_CharT c, const locale& loc)
{ return (use_facet<ctype<_CharT> >(loc)).is(ctype_base::alnum, c); }
template <class _CharT>
inline bool isgraph (_CharT c, const locale& loc)
{ return (use_facet<ctype<_CharT> >(loc)).is(ctype_base::graph, c); }
template <class _CharT>
inline _CharT toupper(_CharT c, const locale& loc)
{ return (use_facet<ctype<_CharT> >(loc)).toupper(c); }
template <class _CharT>
inline _CharT tolower(_CharT c, const locale& loc)
{ return (use_facet<ctype<_CharT> >(loc)).tolower(c); }
}
namespace stlp_std {
template <class _ForwardIterator, class _Tp>
class raw_storage_iterator
      : public iterator<output_iterator_tag,void,void,void,void>
{
protected:
  _ForwardIterator _M_iter;
public:
  typedef output_iterator_tag iterator_category;
  typedef void value_type;
  typedef void difference_type;
  typedef void pointer;
  typedef void reference;
  explicit raw_storage_iterator(_ForwardIterator __x) : _M_iter(__x) {}
  raw_storage_iterator<_ForwardIterator, _Tp>& operator*() { return *this; }
  raw_storage_iterator<_ForwardIterator, _Tp>& operator=(const _Tp& __element) {
    _Param_Construct(&*_M_iter, __element);
    return *this;
  }
  raw_storage_iterator<_ForwardIterator, _Tp>& operator++() {
    ++_M_iter;
    return *this;
  }
  raw_storage_iterator<_ForwardIterator, _Tp> operator++(int) {
    raw_storage_iterator<_ForwardIterator, _Tp> __tmp = *this;
    ++_M_iter;
    return __tmp;
  }
};
}
namespace stlp_std {
class __ptr_base {
public:
  void* _M_p;
  void __set(const volatile void* p) { _M_p = const_cast<void*>(p); }
  void __set(void* p) { _M_p = p; }
};
template <class _Tp>
class auto_ptr_ref {
public:
  __ptr_base& _M_r;
  _Tp* const _M_p;
  auto_ptr_ref(__ptr_base& __r, _Tp* __p) : _M_r(__r), _M_p(__p) { }
  _Tp* release() const { _M_r.__set(static_cast<void*>(0)); return _M_p; }
private:
  typedef auto_ptr_ref<_Tp> _Self;
  _Self& operator = (_Self const&);
};
template<class _Tp>
class auto_ptr : public __ptr_base {
public:
  typedef _Tp element_type;
  typedef auto_ptr<_Tp> _Self;
  _Tp* release() throw() {
    _Tp* __px = this->get();
    this->_M_p = 0;
    return __px;
  }
  void reset(_Tp* __px = 0) throw() {
    _Tp* __pt = this->get();
    if (__px != __pt)
      delete __pt;
    this->__set(__px);
  }
  _Tp* get() const throw()
  { return static_cast<_Tp*>(_M_p); }
  _Tp* operator->() const throw() {
   
    return get();
  }
  _Tp& operator*() const throw() {
   
    return *get();
  }
  explicit auto_ptr(_Tp* __px = 0) throw() { this->__set(__px); }
  template<class _Tp1> auto_ptr(auto_ptr<_Tp1>& __r) throw() {
    _Tp* __conversionCheck = __r.release();
    this->__set(__conversionCheck);
  }
  template<class _Tp1> auto_ptr<_Tp>& operator=(auto_ptr<_Tp1>& __r) throw() {
    _Tp* __conversionCheck = __r.release();
    reset(__conversionCheck);
    return *this;
  }
  auto_ptr(_Self& __r) throw() { this->__set(__r.release()); }
  _Self& operator=(_Self& __r) throw() {
    reset(__r.release());
    return *this;
  }
  ~auto_ptr() throw() { delete this->get(); }
  auto_ptr(auto_ptr_ref<_Tp> __r) throw()
  { this->__set(__r.release()); }
  _Self& operator=(auto_ptr_ref<_Tp> __r) throw() {
    reset(__r.release());
    return *this;
  }
  template<class _Tp1> operator auto_ptr_ref<_Tp1>() throw()
  { return auto_ptr_ref<_Tp1>(*this, this->get()); }
  template<class _Tp1> operator auto_ptr<_Tp1>() throw()
  { return auto_ptr<_Tp1>(release()); }
};
}
namespace boost {
template <typename Block = unsigned long,
          typename Allocator = stlp_std::allocator<Block> >
class dynamic_bitset;
}
namespace boost {
  namespace detail {
  namespace dynamic_bitset_impl {
    template <typename T>
    inline const unsigned char * object_representation (T* p)
    {
        return static_cast<const unsigned char *>(static_cast<const void *>(p));
    }
    template<typename T, int amount, int width >
    struct shifter
    {
        static void left_shift(T & v) {
            amount >= width ? (v = 0)
                : (v >>= (boost::detail::make_non_const(amount)));
        }
    };
    typedef unsigned char byte_type;
    template <bool value>
    struct value_to_type
    {
        value_to_type() {}
    };
    const bool access_by_bytes = true;
    const bool access_by_blocks = false;
    template <bool dummy_name = true>
    struct count_table { static const byte_type table[]; };
    template <>
    struct count_table<false> { };
     const unsigned int table_width = 8;
     template <bool b>
     const byte_type count_table<b>::table[] =
     {
     0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
     1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
     1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
     2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
     1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
     2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
     2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
     3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8
     };
     template <typename Iterator>
     inline stlp_std::size_t do_count(Iterator first, stlp_std::size_t length,
                                 int ,
                                 value_to_type<access_by_bytes>* )
     {
         stlp_std::size_t num = 0;
         if (length)
         {
             const byte_type * p = object_representation(&*first);
             length *= sizeof(*first);
              do {
                 num += count_table<>::table[*p];
                 ++p;
                 --length;
             } while (length);
         }
         return num;
     }
     template <typename Iterator, typename ValueType>
     inline stlp_std::size_t do_count(Iterator first, stlp_std::size_t length, ValueType,
                                 value_to_type<access_by_blocks>*)
     {
         stlp_std::size_t num = 0;
         while (length){
             ValueType value = *first;
             while (value) {
                 num += count_table<>::table[value & ((1u<<table_width) - 1)];
                 value >>= table_width;
             }
             ++first;
             --length;
         }
         return num;
     }
    template <typename T>
    typename T::size_type vector_max_size_workaround(const T & v) {
      typedef typename T::allocator_type allocator_type;
      const typename allocator_type::size_type alloc_max =
                                                  v.get_allocator().max_size();
      const typename T::size_type container_max = v.max_size();
      return alloc_max < container_max?
                    alloc_max :
                    container_max;
    }
    template <typename T>
    struct allowed_block_type {
        enum { value = T(-1) > 0 };
    };
    template <>
    struct allowed_block_type<bool> {
        enum { value = false };
    };
    template <typename T>
    struct is_numeric {
        enum { value = false };
    };
    template<> struct is_numeric< bool > { enum { value = true }; };
    template<> struct is_numeric< char > { enum { value = true }; };
    template<> struct is_numeric< wchar_t > { enum { value = true }; };
    template<> struct is_numeric< signed char > { enum { value = true }; };
    template<> struct is_numeric< short int > { enum { value = true }; };
    template<> struct is_numeric< int > { enum { value = true }; };
    template<> struct is_numeric< long int > { enum { value = true }; };
    template<> struct is_numeric< unsigned char > { enum { value = true }; };
    template<> struct is_numeric< unsigned short > { enum { value = true }; };
    template<> struct is_numeric< unsigned int > { enum { value = true }; };
    template<> struct is_numeric< unsigned long > { enum { value = true }; };
    template<> struct is_numeric< ::boost::long_long_type > { enum { value = true }; };
    template<> struct is_numeric< ::boost::ulong_long_type > { enum { value = true }; };
  }
  }
}
namespace stlp_std {
template <class _Tp,
          class _CharT = char, class _Traits = char_traits<_CharT>,
          class _Dist = ptrdiff_t>
class istream_iterator : public iterator<input_iterator_tag, _Tp , _Dist,
                                         const _Tp*, const _Tp& > {
  typedef istream_iterator< _Tp, _CharT, _Traits, _Dist > _Self;
public:
  typedef _CharT char_type;
  typedef _Traits traits_type;
  typedef basic_istream<_CharT, _Traits> istream_type;
  typedef input_iterator_tag iterator_category;
  typedef _Tp value_type;
  typedef _Dist difference_type;
  typedef const _Tp* pointer;
  typedef const _Tp& reference;
  istream_iterator() : _M_stream(0), _M_ok(false), _M_read_done(true) {}
  istream_iterator(istream_type& __s) : _M_stream(&__s), _M_ok(false), _M_read_done(false) {}
  reference operator*() const {
    if (!_M_read_done) {
      _M_read();
    }
    return _M_value;
  }
  pointer operator->() const { return &(operator*()); }
  _Self& operator++() {
    _M_read();
    return *this;
  }
  _Self operator++(int) {
    _Self __tmp = *this;
    _M_read();
    return __tmp;
  }
  bool _M_equal(const _Self& __x) const {
    if (!_M_read_done) {
      _M_read();
    }
    if (!__x._M_read_done) {
      __x._M_read();
    }
    return (_M_ok == __x._M_ok) && (!_M_ok || _M_stream == __x._M_stream);
  }
private:
  istream_type* _M_stream;
  mutable _Tp _M_value;
  mutable bool _M_ok;
  mutable bool _M_read_done;
  void _M_read() const {
    _M_ok = ((_M_stream != 0) && !_M_stream->fail());
    if (_M_ok) {
      *_M_stream >> _M_value;
      _M_ok = !_M_stream->fail();
    }
    _M_read_done = true;
  }
};
template <class _TpP,
          class _CharT = char, class _Traits = char_traits<_CharT> >
class ostream_iterator: public iterator<output_iterator_tag, void, void, void, void> {
  typedef ostream_iterator<_TpP, _CharT, _Traits> _Self;
public:
  typedef _CharT char_type;
  typedef _Traits traits_type;
  typedef basic_ostream<_CharT, _Traits> ostream_type;
  typedef output_iterator_tag iterator_category;
  ostream_iterator(ostream_type& __s) : _M_stream(&__s), _M_string(0) {}
  ostream_iterator(ostream_type& __s, const _CharT* __c)
    : _M_stream(&__s), _M_string(__c) {}
  _Self& operator=(const _TpP& __val) {
    *_M_stream << __val;
    if (_M_string) *_M_stream << _M_string;
    return *this;
  }
  _Self& operator*() { return *this; }
  _Self& operator++() { return *this; }
  _Self& operator++(int) { return *this; }
private:
  ostream_type* _M_stream;
  const _CharT* _M_string;
};
}
namespace stlp_std {
template < class _Tp, class _CharT, class _Traits, class _Dist >
inline bool
operator==(const istream_iterator< _Tp, _CharT, _Traits, _Dist >& __x,
           const istream_iterator< _Tp, _CharT, _Traits, _Dist >& __y)
{ return __x._M_equal(__y); }
template < class _Tp, class _CharT, class _Traits, class _Dist >
inline bool
operator!=(const istream_iterator< _Tp, _CharT, _Traits, _Dist >& __x,
           const istream_iterator< _Tp, _CharT, _Traits, _Dist >& __y)
{ return !__x._M_equal(__y); }
}
namespace boost { namespace detail {
template <class Iterator>
struct iterator_traits
    : stlp_std::iterator_traits<Iterator>
{};
using stlp_std::distance;
}}
namespace boost {
 namespace detail {
  template <typename T>
  int integer_log2_impl(T x, int n) {
      int result = 0;
      while (x != 1) {
          const T t = static_cast<T>(x >> n);
          if (t) {
              result += n;
              x = t;
          }
          n /= 2;
      }
      return result;
  }
  template <int p, int n>
  struct max_pow2_less {
      enum { c = 2*n < p };
      static const int value = c ? (max_pow2_less< c*p, 2*c*n>::value) : n;
  };
  template <>
  struct max_pow2_less<0, 0> {
      static const int value = 0;
  };
  template <typename T>
  struct width {
      static const int value = (stlp_std::numeric_limits<T>::digits);
  };
 }
 template <typename T>
 int integer_log2(T x) {
     (static_cast<void> (0));
     const int n = detail::max_pow2_less<
                     detail::width<T> :: value, 4
                   > :: value;
     return detail::integer_log2_impl(x, n);
 }
}
namespace boost {
    template <typename T>
    int lowest_bit(T x) {
        (static_cast<void> (0));
        return boost::integer_log2<T>( x - ( x & (x-1) ) );
    }
}
namespace boost {
template <typename Block, typename Allocator>
class dynamic_bitset
{
  static_assert(detail::dynamic_bitset_impl::allowed_block_type<Block>::value, "detail::dynamic_bitset_impl::allowed_block_type<Block>::value");
public:
    typedef Block block_type;
    typedef Allocator allocator_type;
    typedef stlp_std::size_t size_type;
    typedef block_type block_width_type;
    static const block_width_type bits_per_block = (stlp_std::numeric_limits<Block>::digits);
    static const size_type npos = static_cast<size_type>(-1);
public:
    class reference
    {
        friend class dynamic_bitset<Block, Allocator>;
        reference(block_type & b, block_type pos)
            :m_block(b),
             m_mask( ((static_cast<void> (0)),
                      block_type(1) << pos )
                   )
        { }
        void operator&();
    public:
        operator bool() const { return (m_block & m_mask) != 0; }
        bool operator~() const { return (m_block & m_mask) == 0; }
        reference& flip() { do_flip(); return *this; }
        reference& operator=(bool x) { do_assign(x); return *this; }
        reference& operator=(const reference& rhs) { do_assign(rhs); return *this; }
        reference& operator|=(bool x) { if (x) do_set(); return *this; }
        reference& operator&=(bool x) { if (!x) do_reset(); return *this; }
        reference& operator^=(bool x) { if (x) do_flip(); return *this; }
        reference& operator-=(bool x) { if (x) do_reset(); return *this; }
     private:
        block_type & m_block;
        const block_type m_mask;
        void do_set() { m_block |= m_mask; }
        void do_reset() { m_block &= ~m_mask; }
        void do_flip() { m_block ^= m_mask; }
        void do_assign(bool x) { x? do_set() : do_reset(); }
    };
    typedef bool const_reference;
    explicit
    dynamic_bitset(const Allocator& alloc = Allocator());
    explicit
    dynamic_bitset(size_type num_bits, unsigned long value = 0,
               const Allocator& alloc = Allocator());
    template <typename CharT, typename Traits, typename Alloc>
    dynamic_bitset(const stlp_std::basic_string<CharT, Traits, Alloc>& s,
        typename stlp_std::basic_string<CharT, Traits, Alloc>::size_type pos,
        typename stlp_std::basic_string<CharT, Traits, Alloc>::size_type n,
        size_type num_bits = npos,
        const Allocator& alloc = Allocator())
    :m_bits(alloc),
     m_num_bits(0)
    {
      init_from_string(s, pos, n, num_bits);
    }
    template <typename CharT, typename Traits, typename Alloc>
    explicit
    dynamic_bitset(const stlp_std::basic_string<CharT, Traits, Alloc>& s,
      typename stlp_std::basic_string<CharT, Traits, Alloc>::size_type pos = 0)
    :m_bits(Allocator()),
     m_num_bits(0)
    {
      init_from_string(s, pos, (stlp_std::basic_string<CharT, Traits, Alloc>::npos),
                       npos);
    }
    template <typename BlockInputIterator>
    dynamic_bitset(BlockInputIterator first, BlockInputIterator last,
                   const Allocator& alloc = Allocator())
    :m_bits(alloc),
     m_num_bits(0)
    {
        using boost::detail::dynamic_bitset_impl::value_to_type;
        using boost::detail::dynamic_bitset_impl::is_numeric;
        const value_to_type<
            is_numeric<BlockInputIterator>::value> selector;
        dispatch_init(first, last, selector);
    }
    template <typename T>
    void dispatch_init(T num_bits, unsigned long value,
                       detail::dynamic_bitset_impl::value_to_type<true>)
    {
        init_from_unsigned_long(static_cast<size_type>(num_bits), value);
    }
    template <typename T>
    void dispatch_init(T first, T last,
                       detail::dynamic_bitset_impl::value_to_type<false>)
    {
        init_from_block_range(first, last);
    }
    template <typename BlockIter>
    void init_from_block_range(BlockIter first, BlockIter last)
    {
        (static_cast<void> (0));
        m_bits.insert(m_bits.end(), first, last);
        m_num_bits = m_bits.size() * bits_per_block;
    }
    dynamic_bitset(const dynamic_bitset& b);
    ~dynamic_bitset();
    void swap(dynamic_bitset& b);
    dynamic_bitset& operator=(const dynamic_bitset& b);
    allocator_type get_allocator() const;
    void resize(size_type num_bits, bool value = false);
    void clear();
    void push_back(bool bit);
    void append(Block block);
    template <typename BlockInputIterator>
    void m_append(BlockInputIterator first, BlockInputIterator last, stlp_std::input_iterator_tag)
    {
        stlp_std::vector<Block, Allocator> v(first, last);
        m_append(v.begin(), v.end(), stlp_std::random_access_iterator_tag());
    }
    template <typename BlockInputIterator>
    void m_append(BlockInputIterator first, BlockInputIterator last, stlp_std::forward_iterator_tag)
    {
        (static_cast<void> (0));
        block_width_type r = count_extra_bits();
        stlp_std::size_t d = boost::detail::distance(first, last);
        m_bits.reserve(num_blocks() + d);
        if (r == 0) {
            for( ; first != last; ++first)
                m_bits.push_back(*first);
        }
        else {
            m_highest_block() |= (*first << r);
            do {
                Block b = *first >> (bits_per_block - r);
                ++first;
                m_bits.push_back(b | (first==last? 0 : *first << r));
            } while (first != last);
        }
        m_num_bits += bits_per_block * d;
    }
    template <typename BlockInputIterator>
    void append(BlockInputIterator first, BlockInputIterator last)
    {
        if (first != last) {
            typename detail::iterator_traits<BlockInputIterator>::iterator_category cat;
            m_append(first, last, cat);
        }
    }
    dynamic_bitset& operator&=(const dynamic_bitset& b);
    dynamic_bitset& operator|=(const dynamic_bitset& b);
    dynamic_bitset& operator^=(const dynamic_bitset& b);
    dynamic_bitset& operator-=(const dynamic_bitset& b);
    dynamic_bitset& operator<<=(size_type n);
    dynamic_bitset& operator>>=(size_type n);
    dynamic_bitset operator<<(size_type n) const;
    dynamic_bitset operator>>(size_type n) const;
    dynamic_bitset& set(size_type n, bool val = true);
    dynamic_bitset& set();
    dynamic_bitset& reset(size_type n);
    dynamic_bitset& reset();
    dynamic_bitset& flip(size_type n);
    dynamic_bitset& flip();
    bool test(size_type n) const;
    bool any() const;
    bool none() const;
    dynamic_bitset operator~() const;
    size_type count() const;
    reference operator[](size_type pos) {
        return reference(m_bits[block_index(pos)], bit_index(pos));
    }
    bool operator[](size_type pos) const { return test(pos); }
    unsigned long to_ulong() const;
    size_type size() const;
    size_type num_blocks() const;
    size_type max_size() const;
    bool empty() const;
    bool is_subset_of(const dynamic_bitset& a) const;
    bool is_proper_subset_of(const dynamic_bitset& a) const;
    bool intersects(const dynamic_bitset & a) const;
    size_type find_first() const;
    size_type find_next(size_type pos) const;
    template <typename B, typename A>
    friend bool operator==(const dynamic_bitset<B, A>& a,
                           const dynamic_bitset<B, A>& b);
    template <typename B, typename A>
    friend bool operator<(const dynamic_bitset<B, A>& a,
                          const dynamic_bitset<B, A>& b);
    template <typename B, typename A, typename BlockOutputIterator>
    friend void to_block_range(const dynamic_bitset<B, A>& b,
                               BlockOutputIterator result);
    template <typename BlockIterator, typename B, typename A>
    friend void from_block_range(BlockIterator first, BlockIterator last,
                                 dynamic_bitset<B, A>& result);
    template <typename CharT, typename Traits, typename B, typename A>
    friend stlp_std::basic_istream<CharT, Traits>& operator>>(stlp_std::basic_istream<CharT, Traits>& is,
                                                         dynamic_bitset<B, A>& b);
    template <typename B, typename A, typename stringT>
    friend void to_string_helper(const dynamic_bitset<B, A> & b, stringT & s, bool dump_all);
private:
    static const block_width_type ulong_width = stlp_std::numeric_limits<unsigned long>::digits;
    typedef stlp_std::vector<block_type, allocator_type> buffer_type;
    void m_zero_unused_bits();
    bool m_check_invariants() const;
    size_type m_do_find_from(size_type first_block) const;
    block_width_type count_extra_bits() const { return bit_index(size()); }
    static size_type block_index(size_type pos) { return pos / bits_per_block; }
    static block_width_type bit_index(size_type pos) { return static_cast<block_width_type>(pos % bits_per_block); }
    static Block bit_mask(size_type pos) { return Block(1) << bit_index(pos); }
    template <typename CharT, typename Traits, typename Alloc>
    void init_from_string(const stlp_std::basic_string<CharT, Traits, Alloc>& s,
        typename stlp_std::basic_string<CharT, Traits, Alloc>::size_type pos,
        typename stlp_std::basic_string<CharT, Traits, Alloc>::size_type n,
        size_type num_bits)
    {
        (static_cast<void> (0));
        typedef typename stlp_std::basic_string<CharT, Traits, Alloc> StrT;
        typedef typename StrT::traits_type Tr;
        const typename StrT::size_type rlen = (stlp_std::min)(n, s.size() - pos);
        const size_type sz = ( num_bits != npos? num_bits : rlen);
        m_bits.resize(calc_num_blocks(sz));
        m_num_bits = sz;
        const stlp_std::ctype<CharT> & fac = stlp_std::use_facet< stlp_std::ctype<CharT> >(stlp_std::locale());
        const CharT one = (fac.widen('1'));
        const size_type m = num_bits < rlen ? num_bits : rlen;
        typename StrT::size_type i = 0;
        for( ; i < m; ++i) {
            const CharT c = s[(pos + m - 1) - i];
            (static_cast<void> (0));
            if (Tr::eq(c, one))
                set(i);
        }
    }
    void init_from_unsigned_long(size_type num_bits,
                                 unsigned long value )
    {
        (static_cast<void> (0));
        m_bits.resize(calc_num_blocks(num_bits));
        m_num_bits = num_bits;
        typedef unsigned long num_type;
        typedef boost::detail::dynamic_bitset_impl
            ::shifter<num_type, bits_per_block, ulong_width> shifter;
        if (num_bits < static_cast<size_type>(ulong_width)) {
            const num_type mask = (num_type(1) << num_bits) - 1;
            value &= mask;
        }
        typename buffer_type::iterator it = m_bits.begin();
        for( ; value; shifter::left_shift(value), ++it) {
            *it = static_cast<block_type>(value);
        }
    }
private:
    bool m_unchecked_test(size_type pos) const;
    static size_type calc_num_blocks(size_type num_bits);
    Block& m_highest_block();
    const Block& m_highest_block() const;
    buffer_type m_bits;
    size_type m_num_bits;
    class bit_appender;
    friend class bit_appender;
    class bit_appender {
      dynamic_bitset & bs;
      size_type n;
      Block mask;
      Block * current;
      bit_appender(const bit_appender &);
      bit_appender & operator=(const bit_appender &);
    public:
        bit_appender(dynamic_bitset & r) : bs(r), n(0), mask(0), current(0) {}
        ~bit_appender() {
            stlp_std::reverse(bs.m_bits.begin(), bs.m_bits.end());
            const block_width_type offs = bit_index(n);
            if (offs)
                bs >>= (bits_per_block - offs);
            bs.resize(n);
            (static_cast<void> (0));
        }
        inline void do_append(bool value) {
            if (mask == 0) {
                bs.append(Block(0));
                current = &bs.m_highest_block();
                mask = Block(1) << (bits_per_block - 1);
            }
            if(value)
                *current |= mask;
            mask /= 2;
            ++n;
        }
        size_type get_count() const { return n; }
    };
};
template <typename Block, typename Allocator>
const typename dynamic_bitset<Block, Allocator>::block_width_type
dynamic_bitset<Block, Allocator>::bits_per_block;
template <typename Block, typename Allocator>
const typename dynamic_bitset<Block, Allocator>::size_type
dynamic_bitset<Block, Allocator>::npos;
template <typename Block, typename Allocator>
const typename dynamic_bitset<Block, Allocator>::block_width_type
dynamic_bitset<Block, Allocator>::ulong_width;
template <typename Block, typename Allocator>
bool operator!=(const dynamic_bitset<Block, Allocator>& a,
                const dynamic_bitset<Block, Allocator>& b);
template <typename Block, typename Allocator>
bool operator<=(const dynamic_bitset<Block, Allocator>& a,
                const dynamic_bitset<Block, Allocator>& b);
template <typename Block, typename Allocator>
bool operator>(const dynamic_bitset<Block, Allocator>& a,
               const dynamic_bitset<Block, Allocator>& b);
template <typename Block, typename Allocator>
bool operator>=(const dynamic_bitset<Block, Allocator>& a,
                const dynamic_bitset<Block, Allocator>& b);
template <typename CharT, typename Traits, typename Block, typename Allocator>
stlp_std::basic_ostream<CharT, Traits>&
operator<<(stlp_std::basic_ostream<CharT, Traits>& os,
           const dynamic_bitset<Block, Allocator>& b);
template <typename CharT, typename Traits, typename Block, typename Allocator>
stlp_std::basic_istream<CharT, Traits>&
operator>>(stlp_std::basic_istream<CharT, Traits>& is,
           dynamic_bitset<Block, Allocator>& b);
template <typename Block, typename Allocator>
dynamic_bitset<Block, Allocator>
operator&(const dynamic_bitset<Block, Allocator>& b1,
          const dynamic_bitset<Block, Allocator>& b2);
template <typename Block, typename Allocator>
dynamic_bitset<Block, Allocator>
operator|(const dynamic_bitset<Block, Allocator>& b1,
          const dynamic_bitset<Block, Allocator>& b2);
template <typename Block, typename Allocator>
dynamic_bitset<Block, Allocator>
operator^(const dynamic_bitset<Block, Allocator>& b1,
          const dynamic_bitset<Block, Allocator>& b2);
template <typename Block, typename Allocator>
dynamic_bitset<Block, Allocator>
operator-(const dynamic_bitset<Block, Allocator>& b1,
          const dynamic_bitset<Block, Allocator>& b2);
template<typename Block, typename Allocator>
void swap(dynamic_bitset<Block, Allocator>& b1,
          dynamic_bitset<Block, Allocator>& b2);
template <typename Block, typename Allocator, typename stringT>
void
to_string(const dynamic_bitset<Block, Allocator>& b, stringT & s);
template <typename Block, typename Allocator, typename BlockOutputIterator>
void
to_block_range(const dynamic_bitset<Block, Allocator>& b,
               BlockOutputIterator result);
template <typename BlockIterator, typename B, typename A>
inline void
from_block_range(BlockIterator first, BlockIterator last,
                 dynamic_bitset<B, A>& result)
{
    stlp_std::copy (first, last, result.m_bits.begin());
}
template <typename Block, typename Allocator>
dynamic_bitset<Block, Allocator>::dynamic_bitset(const Allocator& alloc)
  : m_bits(alloc), m_num_bits(0)
{
}
template <typename Block, typename Allocator>
dynamic_bitset<Block, Allocator>::
dynamic_bitset(size_type num_bits, unsigned long value, const Allocator& alloc)
    : m_bits(alloc),
      m_num_bits(0)
{
    init_from_unsigned_long(num_bits, value);
}
template <typename Block, typename Allocator>
inline dynamic_bitset<Block, Allocator>::
dynamic_bitset(const dynamic_bitset& b)
  : m_bits(b.m_bits), m_num_bits(b.m_num_bits)
{
}
template <typename Block, typename Allocator>
inline dynamic_bitset<Block, Allocator>::
~dynamic_bitset()
{
    (static_cast<void> (0));
}
template <typename Block, typename Allocator>
inline void dynamic_bitset<Block, Allocator>::
swap(dynamic_bitset<Block, Allocator>& b)
{
    stlp_std::swap(m_bits, b.m_bits);
    stlp_std::swap(m_num_bits, b.m_num_bits);
}
template <typename Block, typename Allocator>
dynamic_bitset<Block, Allocator>& dynamic_bitset<Block, Allocator>::
operator=(const dynamic_bitset<Block, Allocator>& b)
{
    m_bits = b.m_bits;
    m_num_bits = b.m_num_bits;
    return *this;
}
template <typename Block, typename Allocator>
inline typename dynamic_bitset<Block, Allocator>::allocator_type
dynamic_bitset<Block, Allocator>::get_allocator() const
{
    return m_bits.get_allocator();
}
template <typename Block, typename Allocator>
void dynamic_bitset<Block, Allocator>::
resize(size_type num_bits, bool value)
{
  const size_type old_num_blocks = num_blocks();
  const size_type required_blocks = calc_num_blocks(num_bits);
  const block_type v = value? ~Block(0) : Block(0);
  if (required_blocks != old_num_blocks) {
    m_bits.resize(required_blocks, v);
  }
  if (value && (num_bits > m_num_bits)) {
    const size_type extra_bits = count_extra_bits();
    if (extra_bits) {
        (static_cast<void> (0));
        m_bits[old_num_blocks - 1] |= (v << extra_bits);
    }
  }
  m_num_bits = num_bits;
  m_zero_unused_bits();
}
template <typename Block, typename Allocator>
void dynamic_bitset<Block, Allocator>::
clear()
{
  m_bits.clear();
  m_num_bits = 0;
}
template <typename Block, typename Allocator>
void dynamic_bitset<Block, Allocator>::
push_back(bool bit)
{
  const size_type sz = size();
  resize(sz + 1);
  set(sz, bit);
}
template <typename Block, typename Allocator>
void dynamic_bitset<Block, Allocator>::
append(Block value)
{
    const block_width_type r = count_extra_bits();
    if (r == 0) {
        m_bits.push_back(value);
    }
    else {
        m_bits.push_back(value >> (bits_per_block - r));
        m_bits[m_bits.size() - 2] |= (value << r);
    }
    m_num_bits += bits_per_block;
    (static_cast<void> (0));
}
template <typename Block, typename Allocator>
dynamic_bitset<Block, Allocator>&
dynamic_bitset<Block, Allocator>::operator&=(const dynamic_bitset& rhs)
{
    (static_cast<void> (0));
    for (size_type i = 0; i < num_blocks(); ++i)
        m_bits[i] &= rhs.m_bits[i];
    return *this;
}
template <typename Block, typename Allocator>
dynamic_bitset<Block, Allocator>&
dynamic_bitset<Block, Allocator>::operator|=(const dynamic_bitset& rhs)
{
    (static_cast<void> (0));
    for (size_type i = 0; i < num_blocks(); ++i)
        m_bits[i] |= rhs.m_bits[i];
    return *this;
}
template <typename Block, typename Allocator>
dynamic_bitset<Block, Allocator>&
dynamic_bitset<Block, Allocator>::operator^=(const dynamic_bitset& rhs)
{
    (static_cast<void> (0));
    for (size_type i = 0; i < this->num_blocks(); ++i)
        m_bits[i] ^= rhs.m_bits[i];
    return *this;
}
template <typename Block, typename Allocator>
dynamic_bitset<Block, Allocator>&
dynamic_bitset<Block, Allocator>::operator-=(const dynamic_bitset& rhs)
{
    (static_cast<void> (0));
    for (size_type i = 0; i < num_blocks(); ++i)
        m_bits[i] &= ~rhs.m_bits[i];
    return *this;
}
template <typename Block, typename Allocator>
dynamic_bitset<Block, Allocator>&
dynamic_bitset<Block, Allocator>::operator<<=(size_type n)
{
    if (n >= m_num_bits)
        return reset();
    if (n > 0) {
        size_type const last = num_blocks() - 1;
        size_type const div = n / bits_per_block;
        block_width_type const r = bit_index(n);
        block_type * const b = &m_bits[0];
        if (r != 0) {
            block_width_type const rs = bits_per_block - r;
            for (size_type i = last-div; i>0; --i) {
                b[i+div] = (b[i] << r) | (b[i-1] >> rs);
            }
            b[div] = b[0] << r;
        }
        else {
            for (size_type i = last-div; i>0; --i) {
                b[i+div] = b[i];
            }
            b[div] = b[0];
        }
        stlp_std::fill_n(b, div, static_cast<block_type>(0));
        m_zero_unused_bits();
    }
    return *this;
}
template <typename B, typename A>
dynamic_bitset<B, A> & dynamic_bitset<B, A>::operator>>=(size_type n) {
    if (n >= m_num_bits) {
        return reset();
    }
    if (n>0) {
        size_type const last = num_blocks() - 1;
        size_type const div = n / bits_per_block;
        block_width_type const r = bit_index(n);
        block_type * const b = &m_bits[0];
        if (r != 0) {
            block_width_type const ls = bits_per_block - r;
            for (size_type i = div; i < last; ++i) {
                b[i-div] = (b[i] >> r) | (b[i+1] << ls);
            }
            b[last-div] = b[last] >> r;
        }
        else {
            for (size_type i = div; i <= last; ++i) {
                b[i-div] = b[i];
            }
        }
        stlp_std::fill_n(b + (num_blocks()-div), div, static_cast<block_type>(0));
    }
    return *this;
}
template <typename Block, typename Allocator>
dynamic_bitset<Block, Allocator>
dynamic_bitset<Block, Allocator>::operator<<(size_type n) const
{
    dynamic_bitset r(*this);
    return r <<= n;
}
template <typename Block, typename Allocator>
dynamic_bitset<Block, Allocator>
dynamic_bitset<Block, Allocator>::operator>>(size_type n) const
{
    dynamic_bitset r(*this);
    return r >>= n;
}
template <typename Block, typename Allocator>
dynamic_bitset<Block, Allocator>&
dynamic_bitset<Block, Allocator>::set(size_type pos, bool val)
{
    (static_cast<void> (0));
    if (val)
        m_bits[block_index(pos)] |= bit_mask(pos);
    else
        reset(pos);
    return *this;
}
template <typename Block, typename Allocator>
dynamic_bitset<Block, Allocator>&
dynamic_bitset<Block, Allocator>::set()
{
  stlp_std::fill(m_bits.begin(), m_bits.end(), ~Block(0));
  m_zero_unused_bits();
  return *this;
}
template <typename Block, typename Allocator>
dynamic_bitset<Block, Allocator>&
dynamic_bitset<Block, Allocator>::reset(size_type pos)
{
    (static_cast<void> (0));
    m_bits[block_index(pos)] &= ~bit_mask(pos);
    return *this;
}
template <typename Block, typename Allocator>
dynamic_bitset<Block, Allocator>&
dynamic_bitset<Block, Allocator>::reset()
{
  stlp_std::fill(m_bits.begin(), m_bits.end(), Block(0));
  return *this;
}
template <typename Block, typename Allocator>
dynamic_bitset<Block, Allocator>&
dynamic_bitset<Block, Allocator>::flip(size_type pos)
{
    (static_cast<void> (0));
    m_bits[block_index(pos)] ^= bit_mask(pos);
    return *this;
}
template <typename Block, typename Allocator>
dynamic_bitset<Block, Allocator>&
dynamic_bitset<Block, Allocator>::flip()
{
    for (size_type i = 0; i < num_blocks(); ++i)
        m_bits[i] = ~m_bits[i];
    m_zero_unused_bits();
    return *this;
}
template <typename Block, typename Allocator>
bool dynamic_bitset<Block, Allocator>::m_unchecked_test(size_type pos) const
{
    return (m_bits[block_index(pos)] & bit_mask(pos)) != 0;
}
template <typename Block, typename Allocator>
bool dynamic_bitset<Block, Allocator>::test(size_type pos) const
{
    (static_cast<void> (0));
    return m_unchecked_test(pos);
}
template <typename Block, typename Allocator>
bool dynamic_bitset<Block, Allocator>::any() const
{
    for (size_type i = 0; i < num_blocks(); ++i)
        if (m_bits[i])
            return true;
    return false;
}
template <typename Block, typename Allocator>
inline bool dynamic_bitset<Block, Allocator>::none() const
{
    return !any();
}
template <typename Block, typename Allocator>
dynamic_bitset<Block, Allocator>
dynamic_bitset<Block, Allocator>::operator~() const
{
    dynamic_bitset b(*this);
    b.flip();
    return b;
}
template <typename Block, typename Allocator>
typename dynamic_bitset<Block, Allocator>::size_type
dynamic_bitset<Block, Allocator>::count() const
{
    using detail::dynamic_bitset_impl::table_width;
    using detail::dynamic_bitset_impl::access_by_bytes;
    using detail::dynamic_bitset_impl::access_by_blocks;
    using detail::dynamic_bitset_impl::value_to_type;
    const bool no_padding =
        dynamic_bitset<Block, Allocator>::bits_per_block
        == 8 * sizeof(Block);
    const bool enough_table_width = table_width >= 8;
    const bool mode = (no_padding && enough_table_width)
                          ? access_by_bytes
                          : access_by_blocks;
    return do_count(m_bits.begin(), num_blocks(), Block(0),
                                       static_cast<value_to_type<mode> *>(0));
}
template <typename B, typename A, typename stringT>
void to_string_helper(const dynamic_bitset<B, A> & b, stringT & s,
                      bool dump_all)
{
    typedef typename stringT::traits_type Tr;
    typedef typename stringT::value_type Ch;
    const stlp_std::ctype<Ch> & fac = stlp_std::use_facet< stlp_std::ctype<Ch> >(stlp_std::locale());
    const Ch zero = (fac.widen('0'));
    const Ch one = (fac.widen('1'));
    typedef typename dynamic_bitset<B, A>::size_type size_type;
    const size_type len = dump_all?
         dynamic_bitset<B, A>::bits_per_block * b.num_blocks():
         b.size();
    s.assign (len, zero);
    for (size_type i = 0; i < len; ++i) {
        if (b.m_unchecked_test(i))
            Tr::assign(s[len - 1 - i], one);
    }
}
template <typename Block, typename Allocator, typename stringT>
inline void
to_string(const dynamic_bitset<Block, Allocator>& b, stringT& s)
{
    to_string_helper(b, s, false);
}
template <typename B, typename A, typename stringT>
inline void
dump_to_string(const dynamic_bitset<B, A>& b, stringT& s)
{
    to_string_helper(b, s, true );
}
template <typename Block, typename Allocator, typename BlockOutputIterator>
inline void
to_block_range(const dynamic_bitset<Block, Allocator>& b,
               BlockOutputIterator result)
{
    stlp_std::copy(b.m_bits.begin(), b.m_bits.end(), result);
}
template <typename Block, typename Allocator>
unsigned long dynamic_bitset<Block, Allocator>::
to_ulong() const
{
  if (m_num_bits == 0)
      return 0;
  if (find_next(ulong_width - 1) != npos)
    throw stlp_std::overflow_error("boost::dynamic_bitset::to_ulong overflow");
  typedef unsigned long result_type;
  const size_type max_size =
            (stlp_std::min)(m_num_bits, static_cast<size_type>(ulong_width));
  const size_type last_block = block_index( max_size - 1 );
  (static_cast<void> (0));
  result_type result = 0;
  for (size_type i = 0; i <= last_block; ++i) {
    const size_type offset = i * bits_per_block;
    result |= (static_cast<result_type>(m_bits[i]) << offset);
  }
  return result;
}
template <typename Block, typename Allocator>
inline typename dynamic_bitset<Block, Allocator>::size_type
dynamic_bitset<Block, Allocator>::size() const
{
    return m_num_bits;
}
template <typename Block, typename Allocator>
inline typename dynamic_bitset<Block, Allocator>::size_type
dynamic_bitset<Block, Allocator>::num_blocks() const
{
    return m_bits.size();
}
template <typename Block, typename Allocator>
inline typename dynamic_bitset<Block, Allocator>::size_type
dynamic_bitset<Block, Allocator>::max_size() const
{
    const size_type m = detail::dynamic_bitset_impl::
                        vector_max_size_workaround(m_bits);
    return m <= (size_type(-1)/bits_per_block) ?
        m * bits_per_block :
        size_type(-1);
}
template <typename Block, typename Allocator>
inline bool dynamic_bitset<Block, Allocator>::empty() const
{
  return size() == 0;
}
template <typename Block, typename Allocator>
bool dynamic_bitset<Block, Allocator>::
is_subset_of(const dynamic_bitset<Block, Allocator>& a) const
{
    (static_cast<void> (0));
    for (size_type i = 0; i < num_blocks(); ++i)
        if (m_bits[i] & ~a.m_bits[i])
            return false;
    return true;
}
template <typename Block, typename Allocator>
bool dynamic_bitset<Block, Allocator>::
is_proper_subset_of(const dynamic_bitset<Block, Allocator>& a) const
{
    (static_cast<void> (0));
    (static_cast<void> (0));
    bool proper = false;
    for (size_type i = 0; i < num_blocks(); ++i) {
        const Block & bt = m_bits[i];
        const Block & ba = a.m_bits[i];
        if (bt & ~ba)
            return false;
        if (ba & ~bt)
            proper = true;
    }
    return proper;
}
template <typename Block, typename Allocator>
bool dynamic_bitset<Block, Allocator>::intersects(const dynamic_bitset & b) const
{
    size_type common_blocks = num_blocks() < b.num_blocks()
                              ? num_blocks() : b.num_blocks();
    for(size_type i = 0; i < common_blocks; ++i) {
        if(m_bits[i] & b.m_bits[i])
            return true;
    }
    return false;
}
template <typename Block, typename Allocator>
typename dynamic_bitset<Block, Allocator>::size_type
dynamic_bitset<Block, Allocator>::m_do_find_from(size_type first_block) const
{
    size_type i = first_block;
    while (i < num_blocks() && m_bits[i] == 0)
        ++i;
    if (i >= num_blocks())
        return npos;
    return i * bits_per_block + boost::lowest_bit(m_bits[i]);
}
template <typename Block, typename Allocator>
typename dynamic_bitset<Block, Allocator>::size_type
dynamic_bitset<Block, Allocator>::find_first() const
{
    return m_do_find_from(0);
}
template <typename Block, typename Allocator>
typename dynamic_bitset<Block, Allocator>::size_type
dynamic_bitset<Block, Allocator>::find_next(size_type pos) const
{
    const size_type sz = size();
    if (pos >= (sz-1) || sz == 0)
        return npos;
    ++pos;
    const size_type blk = block_index(pos);
    const block_width_type ind = bit_index(pos);
    const Block fore = m_bits[blk] & ( ~Block(0) << ind );
    return fore?
        blk * bits_per_block + lowest_bit(fore)
        :
        m_do_find_from(blk + 1);
}
template <typename Block, typename Allocator>
bool operator==(const dynamic_bitset<Block, Allocator>& a,
                const dynamic_bitset<Block, Allocator>& b)
{
    return (a.m_num_bits == b.m_num_bits)
           && (a.m_bits == b.m_bits);
}
template <typename Block, typename Allocator>
inline bool operator!=(const dynamic_bitset<Block, Allocator>& a,
                       const dynamic_bitset<Block, Allocator>& b)
{
    return !(a == b);
}
template <typename Block, typename Allocator>
bool operator<(const dynamic_bitset<Block, Allocator>& a,
               const dynamic_bitset<Block, Allocator>& b)
{
    (static_cast<void> (0));
    typedef typename dynamic_bitset<Block, Allocator>::size_type size_type;
    for (size_type ii = a.num_blocks(); ii > 0; --ii) {
      size_type i = ii-1;
      if (a.m_bits[i] < b.m_bits[i])
        return true;
      else if (a.m_bits[i] > b.m_bits[i])
        return false;
    }
    return false;
}
template <typename Block, typename Allocator>
inline bool operator<=(const dynamic_bitset<Block, Allocator>& a,
                       const dynamic_bitset<Block, Allocator>& b)
{
    return !(a > b);
}
template <typename Block, typename Allocator>
inline bool operator>(const dynamic_bitset<Block, Allocator>& a,
                      const dynamic_bitset<Block, Allocator>& b)
{
    return b < a;
}
template <typename Block, typename Allocator>
inline bool operator>=(const dynamic_bitset<Block, Allocator>& a,
                       const dynamic_bitset<Block, Allocator>& b)
{
    return !(a < b);
}
template <typename Ch, typename Tr, typename Block, typename Alloc>
stlp_std::basic_ostream<Ch, Tr>&
operator<<(stlp_std::basic_ostream<Ch, Tr>& os,
           const dynamic_bitset<Block, Alloc>& b)
{
    using namespace stlp_std;
    const ios_base::iostate ok = ios_base::goodbit;
    ios_base::iostate err = ok;
    typename basic_ostream<Ch, Tr>::sentry cerberos(os);
    if (cerberos) {
        const stlp_std::ctype<Ch> & fac = stlp_std::use_facet< stlp_std::ctype<Ch> >(os.getloc());
        const Ch zero = (fac.widen('0'));
        const Ch one = (fac.widen('1'));
        try {
            typedef typename dynamic_bitset<Block, Alloc>::size_type bitsetsize_type;
            typedef basic_streambuf<Ch, Tr> buffer_type;
            buffer_type * buf = os.rdbuf();
            size_t npad = os.width() <= 0
                || (bitsetsize_type) os.width() <= b.size()? 0 : os.width() - b.size();
            const Ch fill_char = os.fill();
            const ios_base::fmtflags adjustfield = os.flags() & ios_base::adjustfield;
            if (adjustfield != ios_base::left) {
                for (; 0 < npad; --npad)
                    if (Tr::eq_int_type(Tr::eof(), buf->sputc(fill_char))) {
                          err |= ios_base::failbit;
                          break;
                    }
            }
            if (err == ok) {
                for (bitsetsize_type i = b.size(); 0 < i; --i) {
                    typename buffer_type::int_type
                        ret = buf->sputc(b.test(i-1)? one : zero);
                    if (Tr::eq_int_type(Tr::eof(), ret)) {
                        err |= ios_base::failbit;
                        break;
                    }
                }
            }
            if (err == ok) {
                for (; 0 < npad; --npad) {
                    if (Tr::eq_int_type(Tr::eof(), buf->sputc(fill_char))) {
                        err |= ios_base::failbit;
                        break;
                    }
                }
            }
            os.width(0);
        } catch (...) {
            bool rethrow = false;
            try { os.setstate(ios_base::failbit); } catch (...) { rethrow = true; }
            if (rethrow)
                throw;
        }
    }
    if(err != ok)
        os.setstate(err);
    return os;
}
template <typename Ch, typename Tr, typename Block, typename Alloc>
stlp_std::basic_istream<Ch, Tr>&
operator>>(stlp_std::basic_istream<Ch, Tr>& is, dynamic_bitset<Block, Alloc>& b)
{
    using namespace stlp_std;
    typedef dynamic_bitset<Block, Alloc> bitset_type;
    typedef typename bitset_type::size_type size_type;
    const streamsize w = is.width();
    const size_type limit = 0 < w && static_cast<size_type>(w) < b.max_size()?
                                         w : b.max_size();
    ios_base::iostate err = ios_base::goodbit;
    typename basic_istream<Ch, Tr>::sentry cerberos(is);
    if(cerberos) {
        const stlp_std::ctype<Ch> & fac = stlp_std::use_facet< stlp_std::ctype<Ch> >(is.getloc());
        const Ch zero = (fac.widen('0'));
        const Ch one = (fac.widen('1'));
        b.clear();
        try {
            typename bitset_type::bit_appender appender(b);
            basic_streambuf <Ch, Tr> * buf = is.rdbuf();
            typename Tr::int_type c = buf->sgetc();
            for( ; appender.get_count() < limit; c = buf->snextc() ) {
                if (Tr::eq_int_type(Tr::eof(), c)) {
                    err |= ios_base::eofbit;
                    break;
                }
                else {
                    const Ch to_c = Tr::to_char_type(c);
                    const bool is_one = Tr::eq(to_c, one);
                    if (!is_one && !Tr::eq(to_c, zero))
                        break;
                    appender.do_append(is_one);
                }
            }
        }
        catch (...) {
            bool rethrow = false;
            try { is.setstate(ios_base::badbit); }
            catch(...) { rethrow = true; }
            if (rethrow)
                throw;
        }
    }
    is.width(0);
    if (b.size() == 0 )
        err |= ios_base::failbit;
    if (err != ios_base::goodbit)
        is.setstate (err);
    return is;
}
template <typename Block, typename Allocator>
dynamic_bitset<Block, Allocator>
operator&(const dynamic_bitset<Block, Allocator>& x,
          const dynamic_bitset<Block, Allocator>& y)
{
    dynamic_bitset<Block, Allocator> b(x);
    return b &= y;
}
template <typename Block, typename Allocator>
dynamic_bitset<Block, Allocator>
operator|(const dynamic_bitset<Block, Allocator>& x,
          const dynamic_bitset<Block, Allocator>& y)
{
    dynamic_bitset<Block, Allocator> b(x);
    return b |= y;
}
template <typename Block, typename Allocator>
dynamic_bitset<Block, Allocator>
operator^(const dynamic_bitset<Block, Allocator>& x,
          const dynamic_bitset<Block, Allocator>& y)
{
    dynamic_bitset<Block, Allocator> b(x);
    return b ^= y;
}
template <typename Block, typename Allocator>
dynamic_bitset<Block, Allocator>
operator-(const dynamic_bitset<Block, Allocator>& x,
          const dynamic_bitset<Block, Allocator>& y)
{
    dynamic_bitset<Block, Allocator> b(x);
    return b -= y;
}
template<typename Block, typename Allocator>
inline void
swap(dynamic_bitset<Block, Allocator>& left,
     dynamic_bitset<Block, Allocator>& right)
{
    left.swap(right);
}
template <typename Block, typename Allocator>
inline typename dynamic_bitset<Block, Allocator>::size_type
dynamic_bitset<Block, Allocator>::calc_num_blocks(size_type num_bits)
{
    return num_bits / bits_per_block
           + static_cast<int>( num_bits % bits_per_block != 0 );
}
template <typename Block, typename Allocator>
inline Block& dynamic_bitset<Block, Allocator>::m_highest_block()
{
    return const_cast<Block &>
           (static_cast<const dynamic_bitset *>(this)->m_highest_block());
}
template <typename Block, typename Allocator>
inline const Block& dynamic_bitset<Block, Allocator>::m_highest_block() const
{
    (static_cast<void> (0));
    return m_bits.back();
}
template <typename Block, typename Allocator>
inline void dynamic_bitset<Block, Allocator>::m_zero_unused_bits()
{
    (static_cast<void> (0));
    const block_width_type extra_bits = count_extra_bits();
    if (extra_bits != 0)
        m_highest_block() &= ~(~static_cast<Block>(0) << extra_bits);
}
template <typename Block, typename Allocator>
bool dynamic_bitset<Block, Allocator>::m_check_invariants() const
{
    const block_width_type extra_bits = count_extra_bits();
    if (extra_bits > 0) {
        block_type const mask = (~static_cast<Block>(0) << extra_bits);
        if ((m_highest_block() & mask) != 0)
            return false;
    }
    if (m_bits.size() > m_bits.capacity() || num_blocks() != calc_num_blocks(size()))
        return false;
    return true;
}
}
