MODULE deriv_class
  IMPLICIT NONE

  PRIVATE

  INTEGER, PARAMETER :: n = 3

  TYPE func 
     REAL :: value, x(n), xx(n*(n+1)/2)
  END TYPE func

  INTERFACE value
     MODULE PROCEDURE value, value_array, value_matrix
  END INTERFACE

  INTERFACE SD
     MODULE PROCEDURE SD, SD_one, SD_array_one, SD_matrix_one
  END INTERFACE

CONTAINS

  FUNCTION value(x) RESULT (res)
    TYPE (func), INTENT (in), TARGET :: x
    REAL , POINTER :: res
    res => x%value
  END FUNCTION value

  FUNCTION value_array(x) RESULT (res)
    TYPE (func), INTENT (in), DIMENSION (:), TARGET :: x
    REAL , DIMENSION (:), POINTER :: res
    res => x%value
  END FUNCTION value_array

  FUNCTION value_matrix(x) RESULT (res)
    TYPE (func), INTENT (in), DIMENSION (:, :), TARGET :: x
    REAL , DIMENSION (:, :), POINTER :: res
    res => x%value
  END FUNCTION value_matrix

  FUNCTION SD(x) RESULT (res)
    TYPE (func), INTENT (in), TARGET :: x
    REAL , DIMENSION (:), POINTER :: res
    res => x%xx
  END FUNCTION SD

  FUNCTION SD_array_one(x, i) RESULT (res)
    TYPE (func), DIMENSION (:), INTENT (in), TARGET :: x
    INTEGER, INTENT (in) :: i
    REAL , DIMENSION (:), POINTER :: res
    res => x%xx(i)
  END FUNCTION SD_array_one

  FUNCTION SD_matrix_one(x, i) RESULT (res)
    TYPE (func), DIMENSION (:, :), INTENT (in), TARGET :: x
    INTEGER, INTENT (in) :: i
    REAL , DIMENSION (:, :), POINTER :: res
    res => x%xx(i)
  END FUNCTION SD_matrix_one

  FUNCTION SD_one(x, i) RESULT (res)
    TYPE (func), INTENT (in), TARGET :: x
    INTEGER, INTENT (in) :: i
    REAL , POINTER :: res
    REAL , DIMENSION (:), POINTER :: second
    second => SD(x)
    res => second(i)
  END FUNCTION SD_one

  FUNCTION matmul_k21(a, b) RESULT (res)
    TYPE (func), DIMENSION (:, :), INTENT (in) :: a
    TYPE (func), DIMENSION (:), INTENT (in) :: b
    INTEGER :: i, j
    TYPE (func), DIMENSION (SIZE(a, 1)), TARGET ::  res
    REAL ,  DIMENSION (:), POINTER :: ptr
       DO j = 1, n
          DO i = j, n
             ptr => SD(res, 1)
             ptr = MATMUL(SD(a, 1), value(b))
          END DO
       END DO
  END FUNCTION matmul_k21

END MODULE deriv_class
