#include <cassert>
namespace llvm {
 class Type;
 class AbstractTypeUser {
  };
 template<typename FromCl> struct isa_impl_cl;
 template<typename From> struct simplify_type {
    typedef From SimpleType;
    static SimpleType &getSimplifiedValue(From &Val) {
  }
  };
 template<typename To, typename From, typename SimpleType> struct isa_impl_wrap {
    static bool doit(const From &Val) {
      return isa_impl_cl<const SimpleType>::template                     isa<To>(simplify_type<const From>::getSimplifiedValue(Val));
    }
  };
 template<typename FromCl> struct isa_impl_cl {
    template<class ToCl>   static bool isa(const FromCl &Val) {
      return isa_impl_wrap<ToCl,const FromCl,                    typename simplify_type<const FromCl>::SimpleType>::doit(Val);
    }
  };
 template <class X, class Y> inline bool isa(const Y &Val) {
    return isa_impl_cl<Y>::template isa<X>(Val);
  }
 template<class To, class From> struct cast_retty_impl {
    typedef To* ret_type;
  };
 template<class To, class From, class SimpleFrom> struct cast_retty_wrap {
  };
 template<class To, class FromTy> struct cast_retty_wrap<To, FromTy, FromTy> {
    typedef typename cast_retty_impl<To,FromTy>::ret_type ret_type;
  };
 template<class To, class From> struct cast_retty {
    typedef typename cast_retty_wrap<To, From,                    typename simplify_type<From>::SimpleType>::ret_type ret_type;
  };
 template <class X, class Y> inline typename cast_retty<X, Y>::ret_type dyn_cast(const Y &Val) {
  }
 }
#include <iterator>
template<class Ty, class PtrDiffTy> struct bidirectional_iterator   :  public std::iterator<std::bidirectional_iterator_tag, Ty, PtrDiffTy> {
  };
template<class Ty, class PtrDiffTy> struct forward_iterator   :  public std::iterator<std::forward_iterator_tag, Ty, PtrDiffTy> {
  };
#include <inttypes.h>
namespace llvm {
 class User;
 class Use {
  public:
    User *getUser() const;
  };
 template<typename UserTy> class value_use_iterator : public forward_iterator<UserTy*, ptrdiff_t> {
    typedef value_use_iterator<UserTy> _Self;
  public:
    bool operator!=(const _Self &x) const {
    }
    _Self &operator++() {
    }
    Use &getUse() const {
  }
  };
 class BasicBlock;
 class Function;
 class Value {
  public:
    inline const Type *getType() const {
  }
    typedef value_use_iterator<User> use_iterator;
    use_iterator use_begin() {
  }
    use_iterator use_end() {
  }
  };
 class User : public Value {
  public:
    Value *getOperand(unsigned i) const {
    }
  };
 class Constant : public User {
  };
 }
#include <vector>
namespace llvm {
 class PointerType;
 class Type : public AbstractTypeUser {
    enum TypeID {
      VoidTyID = 0,     FloatTyID,     DoubleTyID,     X86_FP80TyID,     FP128TyID,     PPC_FP128TyID,     LabelTyID,     IntegerTyID,     FunctionTyID,     StructTyID,     ArrayTyID,     PointerTyID,     OpaqueTyID,     VectorTyID,     NumTypeIDs,     LastPrimitiveTyID = LabelTyID,     FirstDerivedTyID = IntegerTyID   };
    TypeID ID :
  8;
  public:
    bool isInteger() const {
  }
  };
 class APInt {
  public:
    static APInt getNullValue(unsigned numBits) {
    }
    bool operator==(uint64_t Val) const {
    }
  };
 }
namespace llvm {
 class ConstantInt : public Constant {
  public:
    inline const APInt& getValue() const {
    }
    static ConstantInt *get(const APInt &V);
  };
 class ConstantPointerNull : public Constant {
  public:
    static ConstantPointerNull *get(const PointerType *T);
  };
 template<typename NodeTy> class ilist_node {
  };
 class Instruction : public User, public ilist_node<Instruction> {
  public:
    inline BasicBlock *getParent() {
  }
    unsigned getOpcode() const {
  }
    enum BinaryOps {
   BinaryOpsBegin = 7, Add = 7, Sub = 8, Mul = 9, UDiv = 10, SDiv = 11, FDiv = 12, URem = 13, SRem = 14, FRem = 15, Shl = 16, LShr = 17, AShr = 18, And = 19, Or = 20, Xor = 21,   BinaryOpsEnd = 21 +1   };
    enum CastOps {
   CastOpsBegin = 28, Trunc = 28, ZExt = 29, SExt = 30, FPToUI = 31, FPToSI = 32, UIToFP = 33, SIToFP = 34, FPTrunc = 35, FPExt = 36, PtrToInt = 37, IntToPtr = 38, BitCast = 39,   CastOpsEnd = 39 +1   };
  };
 class UnaryInstruction : public Instruction {
  };
 class BinaryOperator : public Instruction {
  public:
    BinaryOps getOpcode() const {
    }
  };
 class CastInst : public UnaryInstruction {
  public:
    const Type* getSrcTy() const {
  }
  };
 class CmpInst: public Instruction {
  public:
    enum Predicate {
      FCMP_FALSE = 0,     FCMP_OEQ = 1,     FCMP_OGT = 2,     FCMP_OGE = 3,     FCMP_OLT = 4,     FCMP_OLE = 5,     FCMP_ONE = 6,     FCMP_ORD = 7,     FCMP_UNO = 8,     FCMP_UEQ = 9,     FCMP_UGT = 10,     FCMP_UGE = 11,     FCMP_ULT = 12,     FCMP_ULE = 13,     FCMP_UNE = 14,     FCMP_TRUE = 15,     FIRST_FCMP_PREDICATE = FCMP_FALSE,     LAST_FCMP_PREDICATE = FCMP_TRUE,     BAD_FCMP_PREDICATE = FCMP_TRUE + 1,     ICMP_EQ = 32,     ICMP_NE = 33,     ICMP_UGT = 34,     ICMP_UGE = 35,     ICMP_ULT = 36,     ICMP_ULE = 37,     ICMP_SGT = 38,     ICMP_SGE = 39,     ICMP_SLT = 40,     ICMP_SLE = 41,     FIRST_ICMP_PREDICATE = ICMP_EQ,     LAST_ICMP_PREDICATE = ICMP_SLE,     BAD_ICMP_PREDICATE = ICMP_SLE + 1   };
    static Predicate getInversePredicate(Predicate pred);
    static Predicate getSwappedPredicate(Predicate pred);
  };
 template<typename NodeTy> struct ilist_nextprev_traits {
  };
 template<typename NodeTy> struct ilist_sentinel_traits {
  };
 template<typename NodeTy> struct ilist_default_traits : ilist_nextprev_traits<NodeTy>,                               ilist_sentinel_traits<NodeTy> {
  };
 template<typename NodeTy> struct ilist_traits : ilist_default_traits<NodeTy> {
 };
 template<typename NodeTy> class ilist_iterator   : public bidirectional_iterator<NodeTy, ptrdiff_t> {
    typedef bidirectional_iterator<NodeTy, ptrdiff_t> super;
    typedef typename super::pointer pointer;
  public:
    operator pointer() const {
    }
    ilist_iterator operator++(int) {
  }
  };
 template<typename NodeTy, typename Traits=ilist_traits<NodeTy> > class iplist : public Traits {
  public:
    typedef ilist_iterator<NodeTy> iterator;
  };
 class BasicBlock : public Value,                    public ilist_node<BasicBlock> {
    typedef iplist<Instruction> InstListType;
  public:
    typedef InstListType::iterator iterator;
    inline iterator begin() {
  }
    inline iterator end () {
  }
  };
 class ICmpInst: public CmpInst {
  };
 class AnalysisResolver;
 class Pass {
    AnalysisResolver *Resolver;
    intptr_t PassID;
  public:
    explicit Pass(const void *pid) : Resolver(0), PassID((intptr_t)pid) {
    }
  };
 class FunctionPass : public Pass {
  public:
    explicit FunctionPass(const void *pid) : Pass(pid) {
 }
    virtual bool runOnFunction(Function &F) = 0;
  };
 class PassInfo {
    typedef Pass* (*NormalCtor_t)();
    const char *const PassName;
    const char *const PassArgument;
    const intptr_t PassID;
    const bool IsCFGOnlyPass;
    const bool IsAnalysis;
    const bool IsAnalysisGroup;
    NormalCtor_t NormalCtor;
  public:
    PassInfo(const char *name, const char *arg, intptr_t pi,            NormalCtor_t normal = 0,            bool isCFGOnly = false, bool is_analysis = false)     : PassName(name), PassArgument(arg), PassID(pi),       IsCFGOnlyPass(isCFGOnly),       IsAnalysis(is_analysis), IsAnalysisGroup(false), NormalCtor(normal) {
    }
  };
 template<typename PassName> Pass *callDefaultCtor() {
  return new PassName();
  }
 template<typename passName> struct RegisterPass : public PassInfo {
    RegisterPass(const char *PassArg, const char *Name, bool CFGOnly = false,                bool is_analysis = false)     : PassInfo(Name, PassArg, intptr_t(&passName::ID),                PassInfo::NormalCtor_t(callDefaultCtor<passName>),                CFGOnly, is_analysis) {
    }
  };
 class Argument : public Value, public ilist_node<Argument> {
  };
 class ConstantRange {
   public:
    ConstantRange(const APInt &Value);
    const APInt *getSingleElement() const {
  }
    ConstantRange maximalIntersectWith(const ConstantRange &CR) const;
    ConstantRange truncate(uint32_t BitWidth) const;
  };
 template<typename SubClass, typename RetTy=void> class InstVisitor {
  public:
    RetTy visit(Instruction &I) {
      switch (I.getOpcode()) {
  case Instruction::Sub:
  return static_cast<SubClass*>(this)-> visitSub(static_cast<BinaryOperator&>(I));
      }
    }
  RetTy visitSub(BinaryOperator &I) {
  return static_cast<SubClass*>(this)-> visitBinaryOperator(static_cast<BinaryOperator&>(I));
  }
  };
 }
#include <stack>
using namespace llvm;
namespace {
   class DomTreeDFS {
    public:
      class Node {
      public:
        unsigned getDFSNumIn() const {
  }
        BasicBlock *getBlock() const {
  }
        bool dominates(const Node *N) const {
        }
        bool DominatedBy(const Node *N) const {
        }
      };
      Node *getNodeForBlock(BasicBlock *BB) const {
      }
    };
   enum LatticeBits {
      EQ_BIT = 1, UGT_BIT = 2, ULT_BIT = 4, SGT_BIT = 8, SLT_BIT = 16   };
   enum LatticeVal {
      GT = SGT_BIT | UGT_BIT,     GE = GT | EQ_BIT,     LT = SLT_BIT | ULT_BIT,     LE = LT | EQ_BIT,     NE = SLT_BIT | SGT_BIT | ULT_BIT | UGT_BIT,     SGTULT = SGT_BIT | ULT_BIT,     SGEULE = SGTULT | EQ_BIT,     SLTUGT = SLT_BIT | UGT_BIT,     SLEUGE = SLTUGT | EQ_BIT,     ULT = SLT_BIT | SGT_BIT | ULT_BIT,     UGT = SLT_BIT | SGT_BIT | UGT_BIT,     SLT = SLT_BIT | ULT_BIT | UGT_BIT,     SGT = SGT_BIT | ULT_BIT | UGT_BIT,     SLE = SLT | EQ_BIT,     SGE = SGT | EQ_BIT,     ULE = ULT | EQ_BIT,     UGE = UGT | EQ_BIT   };
   class __attribute__ ((visibility("hidden"))) ValueNumbering {
    public:
      unsigned getOrInsertVN(Value *V, DomTreeDFS::Node *Subtree) {
      }
      Value *value(unsigned index) const {
        ((index != 0 && "Zero index is reserved for not found.") ? static_cast<void> (0) : __assert_fail ("index != 0 && \"Zero index is reserved for not found.\"", "/svn/llvm/lib/Transforms/Scalar/PredicateSimplifier.cpp", 511, __PRETTY_FUNCTION__));
      }
    };
   class __attribute__ ((visibility("hidden"))) InequalityGraph {
    public:
      bool isRelatedBy(unsigned n1, unsigned n2, DomTreeDFS::Node *Subtree,                      LatticeVal LV) {
      }
      void addInequality(unsigned n1, unsigned n2, DomTreeDFS::Node *Subtree,                        LatticeVal LV1) {
      }
    };
   class VRPSolver;
   class __attribute__ ((visibility("hidden"))) ValueRanges {
      ValueNumbering &VN;
      class __attribute__ ((visibility("hidden"))) ScopedRange {
        typedef std::vector<std::pair<DomTreeDFS::Node *, ConstantRange> >               RangeListType;
        RangeListType RangeList;
        void dump(std::ostream &os) const {
          for (const_iterator I = begin(), E = end();
  I != E;
  ++I) {           os << &I->second << " (" << I->first->getDFSNumIn() << "), ";         }
        }
        typedef RangeListType::const_iterator const_iterator;
        const_iterator begin() const {
  }
        const_iterator end() const {
  }
      };
      std::vector<ScopedRange> Ranges;
      void update(unsigned n, const ConstantRange &CR, DomTreeDFS::Node *Subtree){
        if (Ranges.size() < n) Ranges.resize(n);
      }
    public:
      ConstantRange range(unsigned n, DomTreeDFS::Node *Subtree) {
        Value *V = VN.value(n);
        ConstantRange CR = range(V);
      }
      ConstantRange range(Value *V) const {
        if (ConstantInt *C = dyn_cast<ConstantInt>(V))         return ConstantRange(C->getValue());
        else if (isa<ConstantPointerNull>(V))         return ConstantRange(APInt::getNullValue(typeToWidth(V->getType())));
      }
      uint32_t typeToWidth(const Type *Ty) const {
      }
      bool isRelatedBy(unsigned n1, unsigned n2, DomTreeDFS::Node *Subtree,                      LatticeVal LV) {
      }
      void addToWorklist(Value *V, Constant *C, ICmpInst::Predicate Pred,                        VRPSolver *VRP);
      void applyRange(unsigned n, const ConstantRange &CR,                     DomTreeDFS::Node *Subtree, VRPSolver *VRP) {
        ConstantRange Merged = CR.maximalIntersectWith(range(n, Subtree));
        if (const APInt *I = Merged.getSingleElement()) {
          Value *V = VN.value(n);
          const Type *Ty = V->getType();
          if (Ty->isInteger()) {           addToWorklist(V, ConstantInt::get(*I), ICmpInst::ICMP_EQ, VRP);           return;         }
  else if (const PointerType *PTy = dyn_cast<PointerType>(Ty)) {           ((*I == 0 && "Pointer is null but not zero?") ? static_cast<void> (0) : __assert_fail ("*I == 0 && \"Pointer is null but not zero?\"", "/svn/llvm/lib/Transforms/Scalar/PredicateSimplifier.cpp", 1223, __PRETTY_FUNCTION__));           addToWorklist(V, ConstantPointerNull::get(PTy),                         ICmpInst::ICMP_EQ, VRP);           return;         }
        }
        update(n, Merged, Subtree);
      }
      void addInequality(unsigned n1, unsigned n2, DomTreeDFS::Node *Subtree,                        LatticeVal LV, VRPSolver *VRP) {
      }
    };
   class __attribute__ ((visibility("hidden"))) UnreachableBlocks {
    public:
      void mark(BasicBlock *BB) {
      }
      bool isDead(BasicBlock *BB) {
      }
    };
   class __attribute__ ((visibility("hidden"))) VRPSolver {
      struct Operation {
        Value *LHS, *RHS;
        ICmpInst::Predicate Op;
      };
      std::deque<Operation> WorkList;
      ValueNumbering &VN;
      InequalityGraph &IG;
      UnreachableBlocks &UB;
      ValueRanges &VR;
      DomTreeDFS *DTDFS;
      DomTreeDFS::Node *Top;
      BasicBlock *TopBB;
      Instruction *TopInst;
      bool &modified;
      bool aboveOrBelow(Instruction *I) {
      }
      bool makeEqual(Value *V1, Value *V2) {
      }
      static LatticeVal cmpInstToLattice(ICmpInst::Predicate Pred) {
      }
    public:
      VRPSolver(ValueNumbering &VN, InequalityGraph &IG, UnreachableBlocks &UB,               ValueRanges &VR, DomTreeDFS *DTDFS, bool &modified,               Instruction *TopInst)       : VN(VN),         IG(IG),         UB(UB),         VR(VR),         DTDFS(DTDFS),         Top(DTDFS->getNodeForBlock(TopInst->getParent())),         TopBB(TopInst->getParent()),         TopInst(TopInst),         modified(modified)     {
      }
      bool isRelatedBy(Value *V1, Value *V2, ICmpInst::Predicate Pred) const {
      }
      void defToOps(Instruction *I) {
        if (BinaryOperator *BO = dyn_cast<BinaryOperator>(I)) {
        }
  else if (CastInst *CI = dyn_cast<CastInst>(I)) {
          const Type *SrcTy = CI->getSrcTy();
          unsigned ci = VN.getOrInsertVN(CI, Top);
          uint32_t W = VR.typeToWidth(SrcTy);
          ConstantRange CR = VR.range(ci, Top);
          switch (CI->getOpcode()) {           default: break;           case Instruction::ZExt:           case Instruction::SExt:             VR.applyRange(VN.getOrInsertVN(CI->getOperand(0), Top),                           CR.truncate(W), Top, this);             break;           case Instruction::BitCast:             VR.applyRange(VN.getOrInsertVN(CI->getOperand(0), Top),                           CR, Top, this);             break;         }
        }
      }
      void opsToDef(Instruction *I) {
      }
      void solve() {
        while (!WorkList.empty()) {
          Operation &O = WorkList.front();
          if (O.Op == ICmpInst::ICMP_EQ) {           if (!makeEqual(O.RHS, O.LHS))             UB.mark(TopBB);         }
  else {           LatticeVal LV = cmpInstToLattice(O.Op);           if ((LV & EQ_BIT) &&               isRelatedBy(O.LHS, O.RHS, ICmpInst::getSwappedPredicate(O.Op))) {             if (!makeEqual(O.RHS, O.LHS))               UB.mark(TopBB);           } else {             if (isRelatedBy(O.LHS, O.RHS, ICmpInst::getInversePredicate(O.Op))){               UB.mark(TopBB);               WorkList.pop_front();               continue;             }             unsigned n1 = VN.getOrInsertVN(O.LHS, Top);             unsigned n2 = VN.getOrInsertVN(O.RHS, Top);             if (n1 == n2) {               if (O.Op != ICmpInst::ICMP_UGE && O.Op != ICmpInst::ICMP_ULE &&                   O.Op != ICmpInst::ICMP_SGE && O.Op != ICmpInst::ICMP_SLE)                 UB.mark(TopBB);               WorkList.pop_front();               continue;             }             if (VR.isRelatedBy(n1, n2, Top, LV) ||                 IG.isRelatedBy(n1, n2, Top, LV)) {               WorkList.pop_front();               continue;             }             VR.addInequality(n1, n2, Top, LV, this);             if ((!isa<ConstantInt>(O.RHS) && !isa<ConstantInt>(O.LHS)) ||                 LV == NE)               IG.addInequality(n1, n2, Top, LV);             if (Instruction *I1 = dyn_cast<Instruction>(O.LHS)) {               if (aboveOrBelow(I1))                 defToOps(I1);             }             if (isa<Instruction>(O.LHS) || isa<Argument>(O.LHS)) {               for (Value::use_iterator UI = O.LHS->use_begin(),                    UE = O.LHS->use_end(); UI != UE;) {                 Use &TheUse = UI.getUse();                 ++UI;                 if (Instruction *I = dyn_cast<Instruction>(TheUse.getUser())) {                   if (aboveOrBelow(I))                     opsToDef(I);                 }               }             }             if (Instruction *I2 = dyn_cast<Instruction>(O.RHS)) {               if (aboveOrBelow(I2))               defToOps(I2);             }             if (isa<Instruction>(O.RHS) || isa<Argument>(O.RHS)) {               for (Value::use_iterator UI = O.RHS->use_begin(),                    UE = O.RHS->use_end(); UI != UE;) {                 Use &TheUse = UI.getUse();                 ++UI;                 if (Instruction *I = dyn_cast<Instruction>(TheUse.getUser())) {                   if (aboveOrBelow(I))                     opsToDef(I);                 }               }             }           }         }
        }
      }
    };
   class __attribute__ ((visibility("hidden"))) PredicateSimplifier : public FunctionPass {
      DomTreeDFS *DTDFS;
      bool modified;
      ValueNumbering *VN;
      InequalityGraph *IG;
      UnreachableBlocks UB;
      ValueRanges *VR;
      std::vector<DomTreeDFS::Node *> WorkList;
    public:
      static char ID;
      PredicateSimplifier() : FunctionPass(&ID) {
 }
      bool runOnFunction(Function &F);
      class __attribute__ ((visibility("hidden"))) Forwards : public InstVisitor<Forwards> {
        PredicateSimplifier *PS;
        DomTreeDFS::Node *DTNode;
      public:
        ValueNumbering &VN;
        InequalityGraph &IG;
        UnreachableBlocks &UB;
        ValueRanges &VR;
        Forwards(PredicateSimplifier *PS, DomTreeDFS::Node *DTNode)         : PS(PS), DTNode(DTNode), VN(*PS->VN), IG(*PS->IG), UB(PS->UB),           VR(*PS->VR) {
 }
        void visitBinaryOperator(BinaryOperator &BO);
      };
      void visitBasicBlock(DomTreeDFS::Node *Node) {
        BasicBlock *BB = Node->getBlock();
        for (BasicBlock::iterator I = BB->begin(), E = BB->end();
  I != E;
 ) {
          visitInstruction(I++, Node);
        }
      }
      void visitInstruction(Instruction *I, DomTreeDFS::Node *DT) {
        Forwards visit(this, DT);
        visit.visit(*I);
      }
    };
   bool PredicateSimplifier::runOnFunction(Function &F) {
      do {
        DomTreeDFS::Node *DTNode = WorkList.back();
        if (!UB.isDead(DTNode->getBlock())) visitBasicBlock(DTNode);
      }
  while (!WorkList.empty());
    }
   void PredicateSimplifier::Forwards::visitBinaryOperator(BinaryOperator &BO) {
      Instruction::BinaryOps ops = BO.getOpcode();
      switch (ops) {
      default:
  {
          VRPSolver VRP(VN, IG, UB, VR, PS->DTDFS, PS->modified, &BO);
          VRP.solve();
        }
      }
    }
 }
static RegisterPass<PredicateSimplifier> X("predsimplify", "Predicate Simplifier");
