module s_type_mod
  type s_foo_type
    real(kind(1.e0)), allocatable :: v(:)
  end type s_foo_type
end module s_type_mod
module s_foo_mod
  use s_type_mod
  interface foobar
    subroutine s_foobar(x)  
      use s_type_mod
      type(s_foo_type), intent (inout) :: x
    end subroutine s_foobar
  end interface
end module s_foo_mod

module d_type_mod
  type d_foo_type
    real(kind(1.d0)), allocatable :: v(:)
  end type d_foo_type
end module d_type_mod

module d_foo_mod
  use d_type_mod
    
  interface foobar
    subroutine d_foobar(x)  
      use d_type_mod
      type(d_foo_type), intent (inout) :: x
    end subroutine d_foobar
  end interface
end module d_foo_mod

module foo_mod
  use s_foo_mod
  use d_foo_mod
end module foo_mod

subroutine s_foobar(x)  
  use foo_mod, protect => s_foobar
  type(s_foo_type), intent (inout) :: x
  
  if (.not.allocated(x%v)) allocate(x%v(10))
end subroutine s_foobar

subroutine d_foobar(x)  
  use foo_mod, protect => d_foobar
  type(d_foo_type), intent (inout) :: x
  
  if (.not.allocated(x%v)) allocate(x%v(10))
end subroutine d_foobar


program test
  use foo_mod
  type(d_foo_type) :: z

  call foobar(z)

end program test
