*fordeck f12_integrals $Revision: 2006.4 Patch(2006.4): move_f12 uccsd_f12_6 $
cstart latex
c;\section{General density fitting integral generation}
c;\begin{verbatim}
cend
      module df_f12_integrals
      implicit double precision (a-h,o-z)

      public f12_integral_init,
     >       f12_integrals,
     >       f12_Fock,
     >       f12_Exch,
     >       f12_Coulomb,
     >       f12_CoreH,
     >       f12_integral_printcpu,
     >       f12_integral_truncate,
     >       f12_integral_term,
     >       f12_define_bra,
     >       f12_define_ket

      private
      parameter (maxbra=6,maxket=32,maxbas=3)
cstart latex
c;\end{verbatim}
c;This set of routines allows to compute 4-index integrals
c;of the form $<kl|OP|rs>$, where $k,l$ should normally in the
c;occupied or valence orbital space, and $r,s$ can be any orbitals or basis
c;functions. For each index ($k,l,r,s$) a different transformation
c;matrix can be used, and in principle any number of such
c;orbital types can be defined (restricted by parameters {\tt maxbra, maxket}).
c;Also, in principle any number of different basis sets can be used
c;(restricted by parameter {\tt maxbas}), i.e., each of the four
c;indices could refer to a different basis set. The list of $k,l$ can be
c;sparse and is provided by {\tt listkl}. For each $kl$ in the list,
c;a matrix with indices $r,s$ is generated. The indices $r,s$ can
c;be restricted to domains (different domains can be used for each
c;type of $r,s$). Currently, the following operators are
c;implemented: {\tt J,R,F,U,UR,UF,FJ,FT,FF}.

c;The routines must be initialized using subroutine {\tt f12\_integrals\_init},
c;which sets up the basis information, united domains and whatever else is needed.
c;Subsequently, integrals can be computed using subroutine {\tt f12\_integrals}.
c;Exchange or Fock operators in mixed bases can be computed
c;using subroutines {\tt f12\_Exch} and {\tt f12\_Fock}, respectively (the
c;latter computes the exchange operator as well). The program uses
c;a recursive algorithm and reuses previously computed intermediates
c;whenever possible. CPU-time usage can be printed using {\tt f12\_integral\_printcpu}.
c;Intermediates that are no longer needed can be deleted using
c;{\tt f12\_integral\_truncate}. The module is terminated using
c;{\tt f12\_integral\_term}. If this is called, all intermediates are
c;erased and all memory is released. Note that {\tt f12\_integrals\_init}
c;and {\tt f12\_integrals} allocate some memory, and therefore memory
c;which was allocated before calls to {\tt f12\_integrals\_init} and
c;{\tt f12\_integrals} must not be released before {\tt f12\_integral\_term}.
celse

      save
c
      logical robust,robustk,lscreen,dscreen
      logical printcpu,printdeb,debug
      logical fullao
      logical sph_au
      double precision thrao,thrsw,thrmo,throv,thrprod,thrf12    !screening thresholds
      double precision cpu_inv,cpu_i2x,cpu_i3x,cpu_srt,cpu_tr1,
     >                 cpu_tr2,cpu_fit,cpu_til,cpu_asmbl,cpu_tran         !cpu info
      double precision flops_inv,flops_tr1,flops_tr2,flops_fit,
     >                 flops_til,flops_asmbl,flops_tran          !flops info
      integer ibase_tot,ibase_3idx,ioff_dom_base,ndom_base       !memory stack info
      double precision disktr2
      integer ideb_r12,iprx
      integer nen_half,nen_srt,nen_bar,nen_til,nrecout           !file info
      integer nfit,nfitmin,nfitmax,n2,ngrp_au,maxgrp_au,isw_au,
     >        infg_au,iexp_au,icgr_au                            !fitting basis info
      integer locfit,loctra,ioff_fitdom,ioff_unifitdom           !local fitting info
      integer listmo,norb                                        !orbital list
      integer ijop,ikop,iden,igvec                               !for exchange and coulomb operators
      integer ibuf,lbuf,maxrec,iden_shl,ipaomx,kgrp_lst,isw_ao   !for dftrans_loc1
      integer numbti,lenbti,lenbtj,nibatch,lbatch_max            !orbital batch info
      integer iscr1,listq                                        !pointers for scratch arrays
      integer nbas                                               !number of basis sets
      integer itrans_f12                                         !If non-zero, use tranop_f12
      integer list_kl,nklmx                                      !operator list and it length
      character(len=64) :: fitbas,aobas(maxbas)                  !for saving fitting basis name
      character(len=16) string
c
c... records
      integer name,irec_jinv,irec_gvec
      parameter (maxop=12,maxopsav=20)
      character*2 typeaa
      character*2 typb_4idx(maxopsav)
      character*2 typk_4idx(maxopsav)
      dimension nkl_4idx(maxopsav)                               !number of operators made for 4-index integrals ab
      dimension irec_4idx(maxopsav),ifil_4idx(maxopsav)          !for 4-index integrals ab
      dimension irec_2idx(maxop)                                 !records for 2-index integrals
      dimension irec_raw(maxbas,maxbra,maxop)                    !records for half transformed 3-index integrals
      dimension irec_srt(maxket,maxbra,maxop)                    !records for sorted or fully transformed 3-index ints
      dimension irec_bar(maxket,maxbra,maxop)                    !records for fitting coefficients
      dimension irec_til(maxket,maxbra,maxop)                    !records for tilde quantities
      dimension ioff_uniorbdom(maxket)
c... integral info
      logical sph(maxbas)
      integer nopsav
      integer oper_4idx(maxopsav)
      integer rawket1_4idx(maxopsav)
      integer rawket2_4idx(maxopsav)
      dimension nrec(maxbas,maxbra,maxop)              !number of records of raw half transformed ints
      dimension name_info(maxbas,maxbra,maxop)         !pointers to record info
      dimension name_off(maxbas,maxbra,maxop)          !pointers to record offsets
      dimension numbtk(maxbas,maxbra,maxop)
      dimension nkbatch(maxbas,maxbra,maxop)
      dimension ngto(maxbas),ngrp(maxbas),nshl(maxbas),infg(maxbas)
      dimension iexp(maxbas),icgr(maxbas)
      dimension nblk(maxbas),idim_blk(maxbas)
      dimension iblk_grp(maxbas),ioff_blk(maxbas)
      dimension ngrp_blk(maxbas),iofg_blk(maxbas),igrp_lst(maxbas)
      dimension iperm_2bl(maxbas),iperm_bl2(maxbas)
      dimension maxblk(maxbas)
      dimension ioff_uniorbdoma(maxbas)
c... orbital info
      integer nbras,nkets,mbra,maxgto
      character*1 typb(maxbra),typk(maxket)       !transformation set types
      character*1 typr(maxbas)                    !Basis set types
      dimension ibmos(maxbra),iorbmx(maxbra)      !pointers for sorted bra orbitals, used in first half trans.
      dimension ikmos(maxket)                     !pointers for sorted ket orbitals, used in second half trans.
      dimension ibmo(maxbra)                      !pointers for original bra orbitals
      dimension ikmo(maxket)                      !pointers for original ket orbitals
      dimension listorb(maxbra)                   !pointer to orbital permutation list
      dimension ioff_pairdom(maxket)              !domain offsets for operators
      logical  locket(maxket)                     !if true, domains are used
      logical  fullket(maxket)                    !if true, all domains are are full
      dimension nbket(maxket)                     !leading dimensions of ket orbitals
      dimension mbket(maxket)                     !leading dimensions of output matrices (if full domains)
      dimension nbbra(maxbra)                     !leading dimensions of bra orbitals
c... types
      dimension iraw_bra(maxbra)
      dimension iraw_ket(maxket)
c... operators
      character(len=2)   :: opnam(maxop)
      data opnam/'J','R','F','X','FX','Y','FJ','FT','FF','U','UF','UR'/
c... files
      integer, parameter :: ifil_2idx       = 7    ! 2-index integrals
      integer, parameter :: ifil_3idx_half  = 4    ! half-transformed 3-index integrals
      integer, parameter :: ifil_3idx_srt   = 7    ! fully-transformed 3-index integrals
      integer, parameter :: ifil_3idx_bar   = 8    ! Fitting coefficients
      integer, parameter :: ifil_3idx_til   = 9    ! Tilde quantities
      !include "common/big"
!comdeck big $Revision: 2002.10 $
      common /big/ q(2)
      integer iq(2)
      equivalence (q(1),iq(1))
      !include "common/cpar"
*comdeck cpar $Revision: 2006.3 $
c.....nstate: number of external vectors calculated simultaneously
c.....nstati: number of roots calculated in internal ci
c.....nstatr: number of reference vectors for pairs
c.....nstatx: maximum number of external vectors
c.....nrootr(irefst): root corresponding to reference vector irefst
c.....nroote(istate): root corresponding to external vector istate
c.....nrootx(istate): internal vector corresponding to external vector istate
c.....ncepa:  cepa flag
c.....mxshrf: highest allowed shell number in reference
c.....nokop:  if nonzero, skip integral transf.
c.....iuncon: if nonzero, use uncontracted pair basis
c.....itrans: itrans=0: integral transformation for double ext. only
c.....itrans: itrans=1: perform integral transf for triple ext.
c             itrans=2: perform full two-electron transf.
c.....itrdm:  if nonzero, calculate transition moments only
c.....ifock:  if nonzero, calculate external orbitals as eigenvectors
c.....        of predifined fock operator
c.....idip:   print dipole moment starting at iteration idip
c.....densav: density matrix in ao basis saved on densav-1+istate
c.....natcor: If non-zero, exclude core orbitals from natural orbital transformation
c.....maxit:  maximum iteration number
c.....maxiti: maximum iteration number in internal ci
c.....maxdav: maximum number of external expansion vectors per state
c.....maxvi:  maximum number of internal expansion vectors
c.....ndav:   present number of external expansion vectors
c.....idavof: offset for nstate expansion vectors of present iteration
c.....itrlx:  number of iterations between relaxing contraction coeff.
c.....mxrlx:  maximum number of relaxations
c.....irlm:   method of relaxation: 1 last dcp not used, 2 dcp used
c.....isep:   if nonzero, separate reference states for each state
c.....ikcps:  flag for options of kext
c.....nopair: if nonzero no pairs
c.....nosing: if nonzero no singles
c.....noexc:  if nonzero no excitations
c.....ioptgm: option for precalculation of quantities needed in den23h
c.....ioptor: option for calculation of intermediate orbitals for pairs
c.....irfopt: if nonzero, optimize reference coefficients; otherwise
c.....        extract reference coefficients from internal ci
c.....iavden: average hii and hss denominators over spin couplings if nonzero
c.....idelcg: if.ne.0 then destroy files icfil,igfil at end!
c.....irest:  if nonzero, restart
c.....natorb: if nonzero, natural orbitals are calculated and printed
c.....        the number of printed external orbitals per symmetry is
c.....        max(natorb,2)
c.....lenbuf: length of i/o buffers
c.....wfnat:  if nonzero, natural orbitals are saved to this record
c.....ipunrf: if nonzero, punch coefficients of reference configurations
c.....ideno:  no scaling of density matrix for cepa and acpf
c.....ref:    record name of option for reference space
c.....ref2:   second record name for reference space
c.....refthr: threshold for selecting references
c.....refsta: state from which reference configurations are selected
c.....orbit:  reference orbital record name
c.....shifti: shift for internal energy denominators
c.....shifts: shift for single energy denominators
c.....shiftp: shift for pair energy denominators
c.....fock(iorb):occupation numbers for fock operator
c.....savecp  record name to save wavefunction
c.....saveco  record name to save internal configurations
c.....restc1 & 2  record name from which wavefunction restored
c.....rectr_bra, rectr_ket: mold records for transition moment and HLS calculations
c.....nrectr_bra, nrectr_ket: number of records in rectr_bra, rectr_ket
c.....ihls:   if nonzero, compute hls
c.....ltest:  test options (logical)
c.....nstpr:  number of internal ci vectors printed at end of calc.(max nstati
c.....igpsfl: flag to force the algorithm used in cigps
c.....iclustr: davidson correction option
c.....icloso: if 1, force all orbitals active, and give restricts
c.....ilstyp: ilstyp=1  first-order spin-orbit calculation.
c             ilstyp=2  second-order spin-orbit calculation.
c.....itrls:  number of spin-orbit components
c.....iccsd:  iccsd=1   qci calculation
c             iccsd=2   ccsd calculation
c.....idiscon:idiscon=0: remove disconnected terms in rccsd
c             idiscon=1: do nor remove disconnected terms, but project correctly
c             idiscon=-1: reproduce old molpro results (wrong projection)
c.....eom:    if nonzero, do eom calculation. eom=nstate.isym
c.....local:  if nonzero, local ci treatment
c.....ibaso:  if nonzero, work in AO basis (ccsd)
c.....imp2:   if nonzero, use mp2 denominators for pairs (ci) or determines
c.....        order of mp expansion (2-4) (CCSD)
c.....itedis: first iteration in which diis extrapolation may be performed
c.....incdis: iteration increment between diis extrapolations
c.....maxdis: maximum number of diis expansion vectors
c.....itydis: itydis=1:  use residual for diis; itydis=2: use update vector
c.....ibruek: if nonzero, make Brueckner orbitals. ibruek=1: additive method,
c             ibruek=2 exponential method
c.....ibrstr: first iteration for singles absorption
c.....orbbrk: if nonzero, save brueckner orbitals to this record
c.....brsfak: scaling factor for singles absorption
c.....incbrk: increment between brueckner iterations
c.....itripl: 1:evaluate (t) term; 2: evaluate[t]; 3:evaluate (t),[t]
c.....trifac: coefficient of t1 term in triples
c.....icctyp: icctyp=1: closed-shell, icctyp=2: unrestricted open-shell,
c             icctyp=3: restricted open-shell coupled cluster
c.....ihppd:  if nonzero, diagonalize gamma(p,q) matrix
c.....iccnew: paramter for rccsd
c.....i3ext:  if nonzero, transformed 3-external integrals are used in ccsd
c.....i4ext:  if nonzero, transformed 4-external integrals are used in lccsd
c,,,,.i3save: if nonzero, save transformed 3-external integrals on file 1
c.....ideb:   Debug option
c.....idleig: Determines method for selecting redundant functions
c.....idftyp: Parameter for DFT approximation
c.....imp3:   Parameter for rspt3
c.....iprojcs: Parameter for projection of singles to FO space
c.....iproci: Parameter for projection of internals to FO space
c.....iprocc: Parameter for projection of singles to FO space only for closed
c.....iusecs: If nonzero, use contracted singles with at least one hole in closed
c.....iuseci: If nonzero, use contracted internals having two holes in closed
c.....ioldpair:  if nonzero, use old density routines for pairs
c.....noint:  If nonzero, omit S-R coupling in rs2
c.....noref:  If nonzero, no contributions of reference CSFS in rs2
c.....imp2g:  gi option of Andersson for caspt2
c.....ihint:  if non-zero, use full internal Hamiltonian in caspt2
c.....ifdia:  if non-zero, use only diagonal elements of F in caspt2
c.....isparop:if nonzero, use N^4 m^2 algorithm in direct transformation
c.....mp2d:   if non-zero, use Martin Schuetz direct mp2 program
c.....orbtype: requested orbital type
c.....ihlstrans: if nonzero, form symmetry adapted HSO matrix
c.....iwigner: if nonzero, use wigner-eckert theorem in construction of HSO
c.....idiis_cphf: if nonzero, start diis in cphf at iteration idiis_cphf
c.....idism_cphf: if nonzero, start macro-diis in cphf at iteration idiis_cphf
c.....maxit_cphf: max number of iterations in cphf
c.....shift_cphf: denominator shift in cphf
c.....thrmax_cphf:  initial convergence parameter of cphf
c.....thrmin_cphf:  final convergence parameter of cphf
c.....start_cphf: start record for cphf
c.....save_cphf:  save record for cphf
c.....imatel: if nonzero, print also individual matrix elements
c             (not completely realized, yet)
c.....ispdeg: if nonzero, set block-diagonal elements of spacially non-
c             degenerate states equal to 0 instead of calculating them
c             (not realized, yet)
c.....irs2c:  if nonzero, rs2 calculation is internally contracted
c.....kextyp:if one, do include linear singles terms in cckext
C
C memory_pt2: options to save momory in MRPT2 calculations.
C             0: Build Q- and T-space. Store lists and <Ic|Ers|0> in core
C             1: No T-space needed (direct code for rs2refref: slow).
C             2: As 1 but I-space is ordered and binary
C                search is used (fast!).
C            1x: No Q-space needed (direct code for cirs2ssa : slow).
C                This also turns off use of T-space.
C                "memory_pt2 = nn10" is equivalent to "memory_pt2 = nn11"
C            2x: Same as 10 but S-space is ordered and binary
C                search is used (fast!).
C           1xx: No 4c/2a-space needed (direct code for rs21a1a: slow).
C                This option also turn on direct code for rs2ref1a.
C          1xxx: Don't store transition density <Ic|Ers|0> but evaluate it
C                on-the-fly with outermost cycle over iconr.
C                Presently available only for blocks 1c-1f and 1c-1g.
C
      !include "common/mxsti"
*comdeck mxsti $Revision: 2006.3 $
      parameter (mxsti=20)
      parameter (mxrectr=20)
      common/cpari/ nstate,nstati,nstatr,ncepa,nokop,itrdm,itrans,idip,
     >             maxit,maxiti,maxdav,maxvi,nosing,nopair,mxshrf,
     >             ikcps,ioptgm,ioptor,irfopt,iavden,idelcg,irest,
     >             natorb,ipunrf,isep,ideno,nstpr,igpsfl,iclustr,icloso,
     >             ilstyp,itrls,iccsd,local,ibaso,imp2,itedis,incdis,
     >             maxdis,itydis,ibruek,ibrstr,incbrk,itripl,icctyp,
     >             ihppd,iccnew,i3ext,ideb,idleig,idftyp,imp3,iprojcs,
     >             noint,noref,imp2g,ihint,ifdia,isparop,jksym,icphf,
     >             mp2d,idkint,npkex,idrvk,ihlstrans,iwigner,idiis_cphf,
     >             maxit_cphf,imatel,ispdeg,maxmem_cphf,idism_cphf,
     >             ikdcp_max,ikdcp_ci,ired_thr,iusecs,iprocc,i3save,
     >             ikdcp,iuseci,ioldpair,iproci,keepcl,idiscon,ishifte0,
     >             idiis_int,molcas_conv,memory_pt2,nrecord_pt2,irs2c,
     >             kextyp,icipt2,idecp0s0,i4ext,natcor,icfmp2,ipolari
c.....following parameters cannot be set on option card
      common/cpars/ nroote(mxsti),nrootr(mxsti),nrootx(mxsti),
     >             ndav,idavof,ifock,noexc,ncpf,lenbuf,nstatx,
     >             itrlx,mxrlx,ilrm,nproj,iuncon,lstyp(3),
     >             nrectr_bra,nrectr_ket,ihls,nevpt2
      common/cparr/ orbit,ref,shifti,shifts,shiftp,focc(64),
     >              savecp,restc1,restc2,ref2,refthr,saveco,wfnat,
     >              densav,gacpfi,gacpfe,prorec,refsta,brsfak,orbbrk,
     >              trifac,dftden,rectr_bra(mxrectr),rectr_ket(mxrectr),
     >              shift_cphf,thrg_cphf,start_cphf,save_cphf,
     >              diis_shift,eom,thrmax_cphf,thrmin_cphf
      logical ltest,fxdiag,fidiag
      common/cparl/ ltest(40),fxdiag,fidiag,usecs
c.... for ket functions
      common/cpari1/ nstat1,nsta1r,nsta1x
      common/cpari2/ nstat2,nsta2r,nsta2x
      character(16) :: orbtype,lsmethod
      common/cparc/ orbtype,lsmethod
      !include "common/zahl"
! src/common/zahl $Revision: 2006.3 Patch(2006.4): common_zahl $
      common/zahl/ z0,z1,z2,z4,z05,z10h6,z10hm8,z10m12
      !include "common/corb"
!comdeck corb $Revision: 2002.10 $
      !include "common/corbdim"
! src/common/corbdim $Revision: 2006.3 $
!comdeck corbdim $ Revision: 2002.9 $
      !include "common/maxval"
!comdeck maxval $Revision: 2002.10 $
      parameter (maxval= 300)
!ftc if Molpro
!ftc start unix-i4 ibm
!ftc ;      integer, parameter :: mxval=maxval,mxact=16,mxclos=maxval
!ftc end
!ftc start univac
!ftc ;      integer, parameter :: mxval=maxval,mxact=18,mxclos=maxval
!ftc end
!ftc start cray eta unix-i8
      integer, parameter :: mxval=maxval,mxact=32,mxclos=maxval
!ftc end
!ftc else
!ftc ;      integer, parameter :: mxval=maxval
!ftc end
!.....nsk:          number of different orbital symmetries
!.....nskcp:        number of different product symmetries
!.....mult(is,js):  symmetry multiplication table.
!
!.....nocc:         total number of occupied orbitals
!.....ncore:        total number of core orbitals
!.....nclos:        total number of closed-shell orbitals in ref.
!.....nval:         total number of valence (correlated) orbitals
!.....nact:         total number of active orbitals in reference
!
!.....iocc(isy):    number of internal orbitals in symmetries
!.....icore(isy):   number of core orbitals in symmetries
!.....iclos(isy):   number of closed-shell+core orbitals in symmetries
!.....icloss(isy):  number of closed-shell orbitals in symmetries
!.....ival(isy):    number of valence orbitals in symmetries
!.....iact(isy):    number of active orbitals in symmetries
!
!.....isyval(iorb): symmetry of given valence orbital.
!.....iorbvl(lorb): absolute orbital number in symmetry for valence orb.
!.....iacval(iorb): number of active orbital for given valence orbital
!.....              iacval(iorb)=0: closed-shell orbital
!.....ivals(iorb):  number of absolute val. orb. iorb in its symmetry(1st=1)
!.....iofval(isy):  offsets of valence orbitals in symmetries
!.....ivastr(isy):  first valence orbital of given symmetry
!.....ivaend(isy):  last valence orbital of given symmetry
!.....ldval(isy):   lengths of triangular valence matrices of given symmetries
!.....lqval(isy):   lengths of square square matrices of given symmetries
!
!.....isyact(iorb): symmetry of given active orbital.
!.....ivalac(iorb): valence orbital number for given active orbital
!.....iofact(isy):  offsets of active orbitals in symmetries
!.....iacstr(isy):  first active orbital of given symmetry
!.....iacend(isy):  last active orbital of given symmetry
!.....ldact(isy):   lengths of triangular active matrices of given symmetries
!.....lqact(isy):   lengths of square active matrices of given symmetries
!.....iaaq(i,j):    square active-active matrix addressing
!.....iaad(i,j):    triangular ative-active active matrix addressing
!.....iccq(i,j):    square closed-closed matrix addressing
!.....iccd(i,j):    triangular closed-closed matrix addressing
!.....icaq(i,j):    square closed-active matrix addressing
!.....icad(i,j):    triangular closed-active matrix addressing
!.....iacq(i,j):    square active-closed matrix addressing
!.....iacd(i,j):    triangular active-closed matrix addressing
!.....ivvd(i,j):    square valence-valence matrix addressing
!
!.....isyclo(iorb): symmetry of given closed-shell orbital
!.....ivalcl(iorb): valence orbital number for given closed-shell orbital
!.....iclval(iorb): closed-shell orbital number for given valence orbital
!                   (zero if not closed-shell)
!.....iofclo(isy):  offsets of closed-shell orbitals in symmetries
!.....iclstr(isy):  first closed-shell orbital of given symmetry
!.....iclend(isy):  last closed-shell orbital of given symmetry
!.....ldclo(isy):   lengths of triangular closed-shell matrices
!.....lqclo(isy):   lengths of square closed-shell matrices
!.....ldacc(isy):   lengths of triangular active-closed matrices
!.....lqacc(isy):   lengths of square closed-active  matrices
!
!.....idoff(isy):   symmetry offsets for second order density
!.....idoffv(isy):  symmetry offsets for second order density, valence
!.....iqoff(isy):   symmetry offsets for third order density
!.....lend2:        length of second order density matrix
!.....lend2v:       length of second order density matrix, valence
!.....lend3(isyij): length of third order density matrix for given ij
!.....lend3m:       maximum of lend3(isy)
      common/cval/ nval,ival(8),iofval(9),ivastr(8),ivaend(8),          &
     &             ldval(8),lqval(8),                                   &
     &             isyval(mxval),iacval(mxval),iorbvl(mxval),           &
     &             listp(mxval,mxval),ivals(mxval),iclval(mxval)
      common/corb/ nocc,iocc(8)
!ftc if Molpro
      common/ccor/ ncore,icore(8)
      common/clos/ nclos,iclos(8),isyclo(mxclos),ivalcl(mxclos),        &
     &             icloss(8),iofclo(9),ldclo(8),lqclo(8),               &
     &             iclstr(8),iclend(8),iclosx(8)
      common/cact/ nact,iact(8),iofact(9),ldact(8),lqact(8),            &
     &             mult(8,8),isyact(mxact),iacstr(8),iacend(8),         &
     &             idoff(8),lend2,iqoff(8,8),lend3(8),lend3m,           &
     &             nsk,nskcp,ivalac(mxact)
!.....dimensions for cicon/cclist: if closed-shells kept, these dimensions
!.... are equal to nval/ival. If closed-shells are eliminated, they
!.....are equal to nact/iact
!.....pointers:  iactvc(ivcl): points to corresponding active orbital
!.....           ivalvc(ivcl): points to corresponding valence orbital
!.....           iclovc(ivcl): points to corresponding closed-shell orbital
      common/cvac/ nvac,ivac(8),iofvac(9),ivcstr(8),ivcend(8),          &
     &             isyvac(mxval),iactvc(mxval),ivalvc(mxval),           &
     &             iclovc(mxval),ldvac(8),lqvac(8),                     &
     &             ivacac(mxact)
      common/cnum/numop(mxval,mxval)
      common/caad/idoffv(8),lend2v,iaaq(mxact,mxact),iaad(mxact,mxact), &
     &            iccq(mxclos,mxclos),iccd(mxclos,mxclos),              &
     &            icaq(mxclos,mxact),iacq(mxact,mxclos),                &
     &            ldacc(8),lqacc(8),ivvd(mxval,mxval),                  &
     &            icad(mxclos,mxact),iacd(mxact,mxclos),                &
     &            ivvq(mxval,mxval)
!ftc else
!ftc ;      common/cact/ mult(8,8),nsk,nskcp
!ftc ;      common/caad/ivvd(mxval,mxval),ivvq(mxval,mxval)
!ftc end
!.....ntos(isym,iblock): block offsets for (n,occ) matrices
!.....ntogs(isym): total lengths of (n,occ) matrices
!.....noos(isym,iblock): block offsets for (occ,occ) matrices
!.....noogs(isym): total lengths of (occ,occ) matrices
!ftc if Molpro
      common/cobas/ ntos(8,8),ntogs(8),noos(8,8),noogs(8)
      common/cvbas/ ntvs(8,8),ntvgs(8),nvvs(8,8),nvvgs(8)
!ftc end
      !include "common/cbas"
! src/common/cbas $Revision: 2006.3 $
!comdeck cbas $ Revision: 2002.9 $
!.....nt(isy):  number of basis functions in symmetry
!.....nts(isy): offset for basis functions of given symmetry
!.....ntg:      total number of basis functions
!.....ntd(isy): block offsets in triangular matrices of symmetry 1
!.....ntdg:     total length of triangular matrix of symmetry 1
!.....ntq(isy): block offsets in square matrices of symmetry 1
!.....ntqg:     total length of square matrix of symmetry 1
!.....ntds(isy,iblock): block offsets in triangular matrices
!.....ntqs(isy,iblock): block offsets in square matrices
!.....ntdgs(isy): total length of triangular matrices
!.....ntqgs(isy): total length of square matrices
!.....ntdgc(isy): ntdgs(isy) rounded up to multiple of sector length
!.....ntqgc(isy): ntqgs(isy) rounded up to multiple of sector length
!
!.....all quantities with x: as above for full basis set
!.....all quantities with y: as above for external space
!.....all quantities with z: as above for open + virtual space
!.....(open shell perturbation and coupled cluster theory)
!...  y and z are reversed if the flag  irevyz is set!
!
!.....the block number is equal to the row (left) symmetry
!
      common/cbasci/ nt(8),ntb(8),nts(8),ntg,ntd(8),ntdg,ntq(8),ntqg,   &
     &         ntds(8,8),ntqs(8,8),ntdgs(8),ntqgs(8),                   &
     &         ntdgc(8),ntqgc(8),                                       &
     &         ntx(8),ntbx(8),ntsx(8),ntgx,ntdx(8),ntdgx,ntqx(8),ntqgx, &
     &         ntdsx(8,8),ntqsx(8,8),ntdgsx(8),ntqgsx(8),               &
     &         ntdgcx(8),ntqgcx(8),                                     &
     &         nty(8),ntby(8),ntsy(8),ntgy,ntdy(8),ntdgy,ntqy(8),ntqgy, &
     &         ntdsy(8,8),ntqsy(8,8),ntdgsy(8),ntqgsy(8),               &
     &         ntdgcy(8),ntqgcy(8),                                     &
     &         ntr
!ftc Start Molpro
      common/cbaso/                                                     &
     &         ntz(8),ntbz(8),ntsz(8),ntgz,ntdz(8),ntdgz,ntqz(8),ntqgz, &
     &         ntdsz(8,8),ntqsz(8,8),ntdgsz(8),ntqgsz(8),               &
     &         ntdgcz(8),ntqgcz(8),ntqsyz(8,8),ntqgsyz(8),ntqgcyz(8),   &
     &         ntqyz(8),ntqgyz,irevyz
!ftc End
      !include "common/clseg"
*comdeck clseg $Revision: 2006.3 Patch(2006.4): common_clseg $
c.....lseg:   disc sector length in real*8 words
c.....intrel: number of integers per real*8
c.....maximum_integer : maximum integer value
c.....ivect:  0=scalar, 1=vector machine
c.....minvec: minimum vector length for call to mxmb
c.....ibank:  number of memory banks
c.....ltrack: number of real*8 words per track
c.....ltr:    either lseg or 1, used for operator offsets on file
c.....ncpus:  maximum number of cpus to be used in multitasking
c.....nobuff: if not 0, disable system buffering
c.....iasyn:  if not 0, enable asynchronous i/o
c.....ncache: machine cache size in bytes
c.....mxmblk: column/row block size for mxma
c.....mxmbln: link block size for mxma
c.....mxmblk_dkext: column block size for mxma in dkext
c.....minbr1:  min number of floating point ops per processor
c.....mxdump:  max number of dump files with full functionality
c.....nroll:   3: use mxm3, 4: use mxm4 for matrix multiplications
c.....noblas:  if nonzero, do not use dgemm
c.....mindgm:  minimum matrix dimension for call to dgemm
c.....mindgr:  minimum value of nrow for call to dgemm
c.....mindgc:  minimum value of ncol for call to dgemm
c.....mindgl:  minimum value of nlink for call to dgemm
c.....mindgv:  minimum matrix dimension for call to dgemv
c.....mflopdgm: MFLOP rate for dgemm
c.....mflopdgv: MFLOP rate for dgemv
c.....mflopmxm: MFLOP rate for mxva
c.....mflopmxv: MFLOP rate for mxva
c.....mpplat:   Latency for mxma_mpp in microseconds
c.....mppspeed: bandwidth for for mxma_mpp in MB/sec
c.....use_olddiag2: if nonzero, use old diag2 routine
c
c... must declare all integers here to avoid errors with blas4
CStart Molpro
cstart unix-i8
      INTEGER, PARAMETER :: maximum_integer=9223372036854775807
celse
c;      INTEGER, PARAMETER :: maximum_integer=2147483647
cend
      integer lseg,intrel,ivect,minvec,ibank,ltrack,ltr,ncpus,
     1   nobuff,iasyn,ncache,mxmblk,mxmbln,minbr1,nchunk1,ibank_save,
     2   mxmblk_dkext,mxdmp,nroll,noblas,mindgm,mindgv,mindgl,mindgr,
     3   mindgc,mindgf,mflopdgm,mflopdgv,mflopmxm,mflopmxv,mpplat,
     4   mppspeed,mxmalat,use_olddiag2,mindgm2
      common/clseg/ lseg,intrel,ivect,minvec,ibank,ltrack,ltr,ncpus,
     1   nobuff,iasyn,ncache,mxmblk,mxmbln,minbr1,nchunk1,ibank_save,
     2   mxmblk_dkext,mxdmp,nroll,noblas,mindgm,mindgv,mindgl,mindgr,
     3   mindgc,mindgf,mflopdgm,mflopdgv,mflopmxm,mflopmxv,mpplat,
     4   mppspeed,mxmalat,use_olddiag2,mindgm2
CElse
c;      common/clseg/ lseg,intrel,ltrack
CEnd
      !include "common/cprint"
! src/common/cprint $Revision: 2006.3 $
!comdeck cprint
! iprint: local print options
! ipring: global print options
! note: this common defined explicitly in muinp1!
!ftc if Molpro
      parameter (nprc=24,nprt=50)
      common/cprint/ iprint(nprt)
      common/cpring/ ipring(nprc)
!ftc end
      !include "common/clocal"
*comdeck clocal $Revision: 2006.4 $
CStart Molpro
      !include "common/maxval_loc"
! src/common/maxval_loc $Revision: 2006.3 $
*comdeck maxval_loc
      parameter (mxvl= 300)
      !include "common/maxatm_loc"
! src/common/maxatm_loc $Revision: 2006.3 $
*comdeck maxatm_loc
      parameter (maxatm= 200)
      parameter (nloci=48,nlocr=44,maxmerge_list=maxatm)
c.....nloc(isym):       number of localized orbitals in symmetry isym
c.....xlcnt(imo), ylcnt(imo), zlcnt(imo): centers of charge for localized orbitals
      common/ccenter/ nloc(8),xlcnt(mxvl),ylcnt(mxvl),zlcnt(mxvl)
c
c.....ipaoc_str(maxatm,isym) 1st PAO of each center...
c.....ipaoc_end(maxatm,isym) last PAO of each center...
c.....npaoc(maxatm,isym)     number of PAOs on each center...
c.....npaocmx                max of all npaoc(,)
      common/cpaocen/ ipaoc_str(maxatm,8),ipaoc_end(maxatm,8),
     &                npaoc(maxatm,8),npaocmx
c
c.....ndoma:            number of primitive domains (= number of unique centers)
c.....ndomo:            number of domain blocks for valence orbitals
c.....ndomp:            number of domain blocks for pairs
c.....ndom:             total number of domain blocks
c.....idoma_str(imo):   pointer to first element of idoma for valence orbital imo
c.....idoma_end(imo):   pointer to last element of idoma for valence orbital imo
c.....idoma(idom):      z-matrix row numbers defining domains for valence orbitals (input)
c.....idomo_str(imo,isym):  pointer to first domain block of symmetry isym for orbital imo
c.....idomo_end(imo,isym):  pointer to last  domain block of symmetry isym for orbital imo
c.....idomp_str(ip,isym):   pointer to first domain block of symmetry isym for pair ip
c.....idomp_end(ip,isym):   pointer to last  domain block of symmetry isym for pair ip
c.....idomup_str(imo,isym): pointer to first domain block of symmetry isym for orbital imo
c.....idomup_end(imo,isym): pointer to last  domain block of symmetry isym for orbital imo
c........ idomup_ ...       unified domains for given imo, only strong and weak pairs)
c.....idom_str(idom):   first basis function (AO) for domain block idom in its symmetry
c.....idom_end(idom):   last  basis function (AO) for domain block idom in its symmetry
c.....ntloc(imo,isym):  number of orbitals per symmetry in the domains of given mo
c.....iwadr(ip,isym):   address of pseudo canonical transformation matrix for pair domain ip
c.....ivadr(ip,isym):   address of canonical->local transformation matrix for pair domain ip
c.....lenv,lenw:        total lengths of transformation matrices
c.....it2len(ip):       length of local pair matrix ip
c.....nstrong:          number of strong pairs
c.....npcls:            number of close pairs (included in nstrong)
c.....nweak:            number of weak pairs
c.....ndist:            number of distant pairs
c.....nvdist:           number of very distant pairs
c.....maxpdomsize       max over all pair domain sizes
c.....maxjdomsize       max over all jop domain sizes
c.....maxkdomsize       max over all kop domain sizes
c.....maxjedomsize      max over all J(E) domain sizes
c.....MaxL_KOp          max size of local K operator
c
c.....offsets in idomp lists (concerns idomp_str, idomp_end, ntloc, it2len).
c.....ioff_distdom: offset for orbital domains used in asymmetric distant pairs
c.....ioff_opjdom:  offset for j-operator domains: use idomp_str(ioff_jdom+iop,isym) etc
c.....              for J(Eij), K(Eij) use:  idomp_str(ioff_jdom+numop(i,j),isym)
c.....ioff_opkdom:  offset for j-operator domains: use idomp_str(ioff_kdom+iop,isym) etc
c.....ioff_up0dom:  offset for up domains for strong pairs: idomp_str(ioff_up0dom+ival,isym)
c.....ioff_up1dom:  offset for up domains for strong and weak pairs: idomp_str(ioff_up1dom+ival,isym)
c.....ioff_up2dom:  offset for up-domains for strong, ewak, and distant pairs: idomp_str(ioff_up2dom+ival,isym)
c.....ioff_opjup1dom: offset for up1 domains over joperator pair domains
c.....ioff_opkup1dom: offset for up1 domains over koperator pair domains
c.....ioff_utridom:   offset for united triple domains
c.....ioff_3extdom:   offset for domains for 3ext integrals
c.....ioff_relopjdom: offset for opj pair domains, rel. to 3ext domains...
c.....ioff_relpdom:   offset for (strong) pair domains, rel. to 3ext domains...
c.....ioff_intdom_lccsd:    offset for internal j-operator domains in lccsd
c.....ioff_fitdom_lccsd:    offset for fitting domains in lccsd
c.....ioff_1extdom_lccsd:   offset for 1-external domains in lccsd
c.....ioff_dom:       current offset in domain list idomp
c.....numopq(imo,jmo): numop (quadr.) for rel. pair domains...
c.....listpq(imo,jmo): listp (quadr.) for rel. pair domains...
c.....                 note: unlike numop numopq(imo,jmo).ne.numopq(jmo,imo) !!
c.....lmax:         largest pair domain size (strong+weak) in one symmetry
c.....lmax2:        largest pair matrix (strong+weak)
c
      parameter (mxpr=mxvl*(mxvl+1)/2)
      parameter (mxdomo=4*mxvl+8,mxdomp=8*mxpr+8,mxdom=mxdomo+mxdomp)
      common/cdomain/ ndom,
     >   ndoma,idoma_str(mxvl),idoma_end(mxvl),idoma(mxdomo),
     >   ndomo,idomo_str(0:8+mxvl,8),idomo_end(0:8+mxvl,8),
     >   ndomp,idomp_str(0:8+mxpr,8),idomp_end(0:8+mxpr,8),
     >   idom_str(mxdom),idom_end(mxdom),
     >   ntloc(0:mxpr,8),iwadr(mxpr,8),lenw,ivadr(mxpr,8),lenv,
     >   it2len(mxpr),nlt1,int1t(mxvl),nstrong,nweak,ndist,nvdist,
     >   ipdlm,isydlm,ndelp,eigdlm,eigmin,ipmin,isymin,natom_list,
     >   maxpdomsize,ioff_opjdom,ioff_opkdom,
     >   ioff_up0dom,ioff_up1dom,ioff_up2dom,lmax,lmax2,
     >   maxjdomsize,maxkdomsize,
     >   ioff_opjup1dom,ioff_opkup1dom,
     >   ioff_utridom,ioff_3extdom,ioff_relopjdom,ioff_relpdom,
     >   npcls,maxjedomsize,ioff_opjedom,ioff_opjupedom,MaxL_Kop,
     >   merge_list,merge_set,atom_merge_set(mxvl),
     >   idomoc_end(0:8+mxvl,8),idomow_end(0:8+mxvl,8),
     >   idomod_end(0:8+mxvl,8),
     >   iwoff(mxpr+2),ioff_distdom,
     >   ioff_mp2dom,ioff_dom,ioff_intdom_lccsd,ioff_1extdom_lccsd,
     >   ioff_fitdom_lccsd,npp_lccsd,npp_lccsd_res,list_canblk(mxvl),
     >   keepcls,maxtyp_r,maxtyp_t,ioff_totdom,nvalcc
      common/cnum_loc/ numopq(mxvl,mxvl),listpq(mxvl,mxvl)
c
c.....drange:   radius from center of charge of localitzed orbitals within which
c               basis functions are included
c.....unitr:    unit of drange (can be set to ANG; default AU)
c.....savdom:   record for saveing domain information
c.....restdom:  record for restarting domain information
c.....weakpair: distance criterion for weak pairs (treated by MP2)
c.....distpair: distance criterion for distant pairs (treated approximately by MP2)
c.....verydist: distance criterion for very distant pairs (neglected)
c.....
c.....skipdist: determines at which stage distant pairs are eliminated
c.....locsing:  if zero, singles are not treated locally (for testing only)
c.....chgfrac:  atoms are included in an orbital domain, if total charge is below chgfrac
c.....chgmin:   atoms are included in an orbital domain if abs Mulliken charge is larger than chgmin
c.....chgminh:  H-atoms are included in an orbital domain if abs Mulliken charge is larger than chgminh
c.....locmull:  parameter to determine method for calculating atomic charges
c.....locorb:   if nonzero, localize orbitals according to Pipek-Mezey scheme
c.....locao:    localize with AO criterion
c.....thrpip:   threshold for Pipek-Mezey
c.....savloc:   record to save local orbitals
c.....thrkcp:   threshold for neglecting small coefficients in cckext
c.....thrcor:   threshold for deleting core orbitals (default 0.1)
c.....idelcor:  parameter for deleting core basis functions
c.....jiterm:   parameter for deleting domain blocks (ji)
c.....maxl_dom: maxl+1 for selecting orbital domains (2 means include s,p functions)
c.....nonorm:   if nonzero, don't normalize projected functions (ibaso=1)
c.....idomonly: if nonzero, determine domains only
c.....itypecheck: check type of basis functions in redundancy check
c.....lmp2algo:  if nonzero, use low order scaling method in lmp2 iterations
c.....iopdom:    if nonzero, use operator domain approximation
c.....iprojocc:  if nonzero, project occupied orbitals
c.....iopdom_dtraf if nonzero, use operator domain approximation in dtraf/lccsd
c.....thrlocx, thrgapx, thrloctx, thrgaptx: dummies, values in cthr are used
cgh - idistmthd: choose method for multipole approximation
cgh - nmltp: level for multipole approximation of exchange integrals
cgh - ishortmlt: level for multipole correction / monopolar exp.
cgh - longmlt: level of multipole correction / bipolar exp.
cgh - idstmlt: level of distant pair multipole expansion
cgh - mltpalgo: determines details of multipole algorithm
cgh - irun: specifies run number for two pass split operator algorithm
cgh - icof: level of damping function for multipole operators
cgh - cot: cutoff (in bohr) for multipole operators
cgh - scalecof: scaling factor for this damping function
cgh - decay: decay parameter for split coulomb operator approach
cgh - rmain: threshold for switching from monopolar expansion to 4-block approach for strong/weak pairs multipole correction
cgh - rionic: threshold for switching from mono- to bipolar expansion for ionic cross excitations
c.....i_epart:       if nonzero, activates energy partitioning...
c.....epart_cutoff:  cutoff parameter for energy partitioning
c.....thrmp2 threshold for mp2 iterations
      integer skipdist
      common/cparloci/ locmeth,idlbas,idlmeth,skipdist,locsing,
     >                locmull,locorb,jiterm,locao,nonorm,
     >                idelcor,idlshl,itypecheck,maxl_dom,iselect,
     >                iprselect,iolddef,idomonly,i_epart,nmltp,
     >                idistmthd,ishortmlt,longmlt,mltpalgo,irun,
     >                idstmlt,icof,lmp2algo,iopdom,ifitmltp,
     >                if1dgrid,if2dgridr,if2dgridp,i3dweight,
     >                mergedom,iprojocc,iopdom_dtraf,monopole,
     >                multpage,numbatch,ibatchalgo,iranseed,ipet
      common/cparlocr/ savdom,restdom,savloc,drange,verydist,distpair,
     >                weakpair,chgfrac,cdelmin,rionic,decay,
     >                rmain,epart_cutoff,cot,scalecof,
     >                supxex,f1dborder,f1dgamma,f2dborder,f2dgamma,
     >                thrlocx,throrbx,thrpipx,thrmltpx,chgmin,chgminh,
     >                rijkl_max,rkl_max,rkli_max,thrmp2,thrcor,
     >                weightpr,batchdiam,thrgapx,thrloctx,thrgaptx
      logical zeromat,zero1ext
      common/cparlocl/ zeromat,zero1ext
      common/crestloc/ ioffsave,ioffrest,fop_done
      parameter(mxdistpart=10)
      common/ceneparti/ ndist_part
      common/cenepartr/ dist_part(mxdistpart)
      dimension vall(nlocr),ivall(nloci)
      equivalence (savdom,vall(1))
      equivalence (locmeth,ivall(1))
      character(8) :: unitr,atom_list,atom_merge_list
      common/crangc/ unitr,atom_list(maxatm),
     >               atom_merge_list(maxmerge_list)
c... for singly external integrals
      common/cd1ex/ list1ex(mxvl,mxvl)
c... for local uccsd
      common/clucc/ iexdomp

cgh - pointers to arrays for least squares fit based multipole approx.
      common/fitmltp_mem/ivpos,impos,ipivpos,mappos,iw1dpos,ix1dpos,
     >                   iw2drpos,ix2drpos,iw2dppos,ix2dppos,
     >                   ippos,iqpos,iypos

cgh - workaround
      common/temp_common/multend,multstart,multstartint
c...
*   - pointers to auxiliary domains connected to 3ext/triples stuff
      common/triplist/ntrip,listrip_p,l3ext
      common/triplist_restart/ntrip_prev
      common/auxdoms/idom_tdl_str_p,idom_tdl_end_p,ntloct_p,
     &               idom_rtdl_str_p,idom_rtdl_end_p,
     &               idomt_str_p,idomt_end_p,
     &               idom_rsp_str_p,idom_rsp_end_p,
     &               idomr_str_p,idomr_end_p,
     &               idom_rtd2l_str_p,idom_rtd2l_end_p
*   - pointers to center pair domain domains for 4ext/dkext stuff
      common/pdcentres/i_size_PDcen,ip_idomap_str,ip_idomap_end,
     &                 ip_idomap
*   - pointers to center operator domain domains for new 3ext stuff
      common/odcentres/i_size_ODcen,ip_idomao_str,ip_idomao_end,
     &                 ip_idomao
*   - pointers to center 3ext domain domains for new 3ext stuff
      common/udcentres/i_size_3Dcen,
     &                 ip_idoma3_str,ip_idoma3_end,ip_idoma3,     ! 3ext domains
     &                 ip_idomaf_str,ip_idomaf_end,ip_idomaf      ! full domains
*   - pointers to center triple domain domains for new 3ext stuff
      common/tdcentres/i_size_TDcen,ip_idomat_str,ip_idomat_end,
     &                 ip_idomat
      common/cenplist/n_cenp,ip_listcen,ip_cenplst,
     &                ip_nCP4fCen,ip_iOffCP4fCen,
     &                n_cenp_q,ip_listcen_q,ip_cenplst_q,
     &                ip_nCP4fCen_q,ip_iOffCP4fCen_q
      common/mocenplist3x/len_mocenl3x,len_mocenpl3x,len_mocentl3x,
     &                ip_mocenlst3x,ip_lst3xmocen,
     &                ip_mocenplst3x,ip_lst3xmocenp,
     &                ip_mocentlst3x,ip_mooff_mocentlst3x
c...
CEnd
      !include "common/cgeom"
!comdeck cgeom $Revision: 2002.10 $
!...  for geometry generation and optimisation
!...  nuq:   number of unique centres including dummies
!...  ncen:  total number of centres (excluding dummies)
!     ngeng number of symmetry generators
!..   neq(iuq): number of symmetry equivalent atoms
!..   jatom(iuq): number of atom group (sharing same basis) for unique centre
!..   jsyt(iuq): sequence number within atom group
!..   atname(iuq)   chemical symbol of atom number iuq appended by number
!     ibing symmetry generator patterns
!     rr(3,n) current coordinates of atom n (all atoms)
!     charg(n) current nuclear charge of atom n (all atoms)
      !include "common/maxatm"
!comdeck maxatm $Revision: 2002.10 $
      parameter (mxatm= 200)
      parameter (maxcen=mxatm)
      character(4) :: atname
      common /cgeom / nuq,ncen,ngeng,ibing(3,3),jatom(maxcen),           &
     &                jsyt(maxcen),iuniq(maxcen),neq(maxcen)
      common /cgeomr/ rr(3,maxcen)
      common /cgeomc/ atname(maxcen)
      common /ccharg/ charg(maxcen)
      logical angstr,m92r
      common /cunita/ angstr(maxcen),m92r
      !include "common/cexplicit"
*comdeck cexplicit $Revision: 2006.4 Patch(2006.4): ccf12_valeev2 lmp2_f12_cabs $
      integer hybrid,hybridx
      common/cexpliciti/npp_r12,                     !number of r12 pairs
     >                  ioff_orbdom_ri_r12,          !offset for resolution of the identity domains
     >                  ioff_orbdom_ao_r12,          !offset for AO orbital domains (for ansatz1)
     >                  ioff_orbdom_so_r12,          !offset for SO orbital domains (for ansatz2)
     >                  ioff_pairdom_ri_r12,         !offset for SO pair domains (for ansatz2)
     >                  ioff_pairdom_ao_r12,         !offset for AO pair domains (for ansatz1)
     >                  ioff_pairdom_so_r12,         !offset for SO pair domains (for ansatz2)
     >                  ioff_uniorbdom_ri_r12,       !offset for united ri-domains
     >                  ioff_uniorbdom_ao_r12,       !offset for united ao-domains (for ansatz1)
     >                  ioff_uniorbdom_so_r12,       !offset for united so-domains (for ansatz2)
     >                  ioff_uniorbdom_ao,           !offset for ao-domains (for Q1/Q2, currently full)
     >                  irec_ep_r12,ifil_ep_r12,     !record for storing pair energies
     >                  nij_f12,nkl_f12,             !number of f12 pairs and excitations
     >                  name_B,ifil_B,               !Record for B-matrix
     >                  name_C,ifil_C,               !Record for C-matrices
     >                  name_V,ifil_V,               !Record for V-matrix
     >                  name_X,ifil_X,               !Record for X-matrix
     >                  ideb_r12,                    !print parameter
     >                  ioff_Vdom,ioff_Bdom,ioff_Xdom,
     >                  name_J(10), name_F(10),
     >                  name_U(10),
     >                  ioffrec(10),
     >                  hybrid,hybridx,
     >                  name_Stil,name_Stil_A,
     >                  irec_AoCabs, irec_RiCabs,nCabs
      common/cexplicitr/emp2_r12,                    !mp2-r12 correlation energy
     >                  emp2_r12_sing,               !mp2-r12 singlet correlation energy
     >                  emp2_r12_trip,               !mp2-r12 triplet correlation energy
     >                  emp2_r12_strong,             !mp2-r12 correlation energy for strong pairs
     >                  emp2_r12_close,              !mp2-r12 correlation energy for close pairs
     >                  emp2_r12_weak,               !mp2-r12 correlation energy for weak pairs
     >                  emp2_r12_dist,               !mp2-r12 correlation energy for distant pairs
     >                  emp2_r12s,                   !mp2-r12/* correlation energy
     >                  emp2_r12s_sing,              !mp2-r12/* singlet correlation energy
     >                  emp2_r12s_trip,              !mp2-r12/* triplet correlation energy
     >                  emp2_r12s_strong,            !mp2-r12/* correlation energy for strong pairs
     >                  emp2_r12s_close,             !mp2-r12/* correlation energy for close pairs
     >                  emp2_r12s_weak,              !mp2-r12/* correlation energy for weak pairs
     >                  emp2_r12s_dist,              !mp2-r12/* correlation energy for distant pairs
     >                  emp2_r12sd,                  !mp2-r12/*(DX) correlation energy
     >                  emp2_r12sd_sing,             !mp2-r12/*(DX) singlet correlation energy
     >                  emp2_r12sd_trip,             !mp2-r12/*(DX) triplet correlation energy
     >                  emp2_r12sd_strong,           !mp2-r12/*(DX) correlation energy for strong pairs
     >                  emp2_r12sd_close,            !mp2-r12/*(DX) correlation energy for close pairs
     >                  emp2_r12sd_weak,             !mp2-r12/*(DX) correlation energy for weak pairs
     >                  emp2_r12sd_dist,             !mp2-r12/*(DX) correlation energy for distant pairs
     >                  ef12bts,ef12btt,             !fixc energy contributions of V*t+B*t^2 term
     >                  ef12cts,ef12ctt,             !fixc energy contributions of C*T*t term
     >                  ef12vts,ef12vtt,             !fixc energy contributions of V*T*t term
     >                  ef12singles                  !mp2 energy contribution
      parameter(len_emp2_f12=28)  !should be the number of entries in common/cexplicitr/
      dimension emp2_f12(len_emp2_f12)
      equivalence (emp2_f12(1),emp2_r12)
      logical do_r12,do_f12,nox,ebc,gbc,doc,diagonal,diagonalx
      logical noex,nofik,fockri,cabs,cabsp,cabsk,cabsf,ldmat,cabsa,cabsc
      logical ansatzA,ansatzB,ansatzC
      logical fockri_A,fockri_B,fockri_C,fockri_P
      logical exch_A,exch_B,exch_C,exch_P
      common/cexplicitl/ do_r12,                     !if true, explicit correlation calc (r12 or f12)
     >                   do_f12,                     !if true, f12 calculation
     >                   nox,                        !if true, neglect X
     >                   ebc,                        !if true, use EBC
     >                   gbc,                        !if true, use GBC
     >                   noex,                       !if true, neglect exchange
     >                   doc,                        !if true, use approximation C
     >                   diagonal,                   !if true, use diagonal approximation
     >                   fockri,                     !if true, use fockri for C
     >                   nofik,                      !if true, fik contributions are included in intermediate orbitals
     >                   cabsp,cabsk,cabsf,          !if true, use CABS for P, K, and F, respectively
     >                   ansatzA,ansatzB,ansatzC,
     >                   fockri_A,fockri_B,
     >                   fockri_C,fockri_P,
     >                   exch_A,exch_B,
     >                   exch_C,exch_P,
     >                   ldmat,cabsa,cabsc,
     >                   diagonalx                   !if true, use diagonal approximation for X
      character*64 ansatz,method,methodd,methods
      common/cexplicic/ ansatz,method,methodd,methods
      INTEGER, PARAMETER :: ifil_K   = 6           ! K-operator
      INTEGER, PARAMETER :: ifil_J   = 5           ! J-integrals
      INTEGER, PARAMETER :: ifil_F   = 6           ! R-integrals
      INTEGER, PARAMETER :: ifil_U   = 5           ! U-integrals
      INTEGER, PARAMETER :: ifil_FJ  = 6           ! FJ-integrals
      INTEGER, PARAMETER :: ifil_FT  = 5           ! FU-integrals
      INTEGER, PARAMETER :: ifil_FF  = 5           ! FF-integrals
      INTEGER, PARAMETER :: name_FJ   = 6400       ! FJ-integrals
      INTEGER, PARAMETER :: name_FT   = 6410       ! FU-integrals
      INTEGER, PARAMETER :: name_FF   = 6420       ! FF-integrals
      CONTAINS
c----------------------------------------------------------------------
      recursive subroutine f12_integrals_raw(inket,ibra,iop1)
c----------------------------------------------------------------------
      implicit double precision (a-h,o-z)
      !include "common/big"
!comdeck big $Revision: 2002.10 $
      common /big/ q(2)
      integer iq(2)
      equivalence (q(1),iq(1))
      !include "common/tapes"
!comdeck tapes $Revision: 2006.4 $
!.....inp:  molpro input file number
!.....iout: output file number
!.....ipun: punch file number
!.....inpc: standart input file number
!.....iprio: io print paramter
!.....ltap:  max number of records per file (set in blk1)
!.....logout: unit number of log file
!.....logfile: name of log file
!.....logopen: flag indicating whether log file is open
!.....lastout: output unit before last call to openlog
!.....npl(ifile):  logical file number for molpro file ifile
!.....nre(ifile):  number of calculation
!.....iwrite(ifile): if nonzero, file has been written since last tapsav
!.....int2ad(irec): address offsets for two electron integral symmetry blocks
!ftc if Molpro
      !include "common/mxrec"
! src/common/mxrec $Revision: 2006.4 $
      parameter (mxrec=200)
      integer, parameter :: mxfil=9
      logical :: ga_debug
      common/tapes/inp,iout,ipun,inpc,iprio,ltap,logout,logopen,lastout,&
     &             npl(mxfil),nre(mxfil),iwrite(mxfil),int2ad(51)
      common/ltapes/ga_debug
      equivalence (nein,inp),(naus,iout)
      character(255) :: logfile
      common/clogf/logfile
!ftc else
!ftc ;      common/tapes/iout
!ftc end
      !include "common/cprint"
! src/common/cprint $Revision: 2006.3 $
!comdeck cprint
! iprint: local print options
! ipring: global print options
! note: this common defined explicitly in muinp1!
!ftc if Molpro
      parameter (nprc=24,nprt=50)
      common/cprint/ iprint(nprt)
      common/cpring/ ipring(nprc)
!ftc end
      logical twobasis
      name=name+1
      inbra=iraw_bra(ibra)
      irec_raw(inket,ibra,iop1)=name
      name_info(inket,ibra,iop1)=icori(2*maxrec)
      name_off(inket,ibra,iop1)=icorr(maxrec)
      numbtk(inket,ibra,iop1)=icori(nfit)       !for fitting function batch sizes
      ipri=max(0,ideb_r12-1)
      twobasis=inbra.ne.inket
      nclass=1
      t1=second()
      icase=0
      if(ijop.ne.0.and.inbra.eq.1.and.inket.eq.1
     >            .and.irec_gvec.eq.0) icase=1
      if(ideb_r12.gt.1) then
        write(iout,70) 'tr1',
     >             typr(inket)//typr(inbra),trim(opnam(iop1)),'A',
     >             typr(inket)//typb(ibra), trim(opnam(iop1)),'A',
     >             name,ifil_3idx_half
        if(icase.ne.0) write(iout,*) 'make gvec'
      end if
      call df_trans_loc1(q(ibmos(ibra)),iq(listmo),norb,
     >     q(iden),icase,q(igvec),
     >     q(iorbmx(ibra)),q(ipaomx),
     >     q(iden_shl),q(iscr1),q(ibuf),lbuf,
     >     iq(kgrp_lst),iq(listorb(ibra)),
     >     opnam(iop1),nclass,

     >     sph(inbra),ngto(inbra),ngrp(inbra),nshl(inbra),
     >     iq(infg(inbra)),q(iexp(inbra)),q(icgr(inbra)),
     >     nblk(inbra),iq(idim_blk(inbra)),iq(ngrp_blk(inbra)),
     >     iq(iofg_blk(inbra)),iq(igrp_lst(inbra)),maxblk(inbra),

     >     sph(inket),ngto(inket),ngrp(inket),nshl(inket),
     >     iq(infg(inket)),q(iexp(inket)),q(icgr(inket)),
     >     nblk(inket),iq(ioff_blk(inket)),iq(idim_blk(inket)),
     >     iq(ngrp_blk(inket)),iq(iofg_blk(inket)),iq(igrp_lst(inket)),
     >     maxblk(inket),iq(iperm_2bl(inket)),

     >     sph_au,nfit,ngrp_au,maxgrp_au,lbatch_max,
     >     iq(infg_au),q(iexp_au),q(icgr_au),

     >     iq(numbti),nibatch,
     >     iq(numbtk(inket,ibra,iop1)),nkbatch(inket,ibra,iop1),

     >     thrao,thrmo,throv,thrprod,thrsw,
     >     ioff_uniorbdoma(inket),
     >     ioff_unifitdom,
     >     q(isw_ao),q(isw_au),.false.,
     >     locfit,loctra,lscreen,dscreen,twobasis,

     >     iq(name_info(inket,ibra,iop1)),q(name_off(inket,ibra,iop1)),
     >     nrec(inket,ibra,iop1),maxrec,
     >     irec_raw(inket,ibra,iop1),ifil_3idx_half,
     >     cpu_i3x,cpu_tr1,flops_tr1,ipri)
           t2=second()
      if(icase.ne.0) then
        name=name+1
        irec_gvec=name
        if(ideb_r12.ge.1) write(iout,60) irec_gvec,ifil_2idx
60      format(' g-vector written to record ',i6,'.',i1)
        call writem(q(igvec),nfit,ifil_2idx,irec_gvec,0,'GVEC')
        ijop=0
      end if
      if(printdeb) write(iout,70) 'tr1',
     >             typr(inket)//typr(inbra),trim(opnam(iop1)),'A',
     >             typr(inket)//typb(ibra), trim(opnam(iop1)),'A',
     >             name,ifil_3idx_half,t2-t1
70    format(1x,a,2x,'<',a,'|',a,'|',a,'>',t16,' -> ',t20,
     >               '<',a,'|',a,'|',a,'>',t35,'record=',i4,'.',i1,:,
     >               '    CPU=',f8.2,' sec')
      return
      end subroutine f12_integrals_raw
c----------------------------------------------------------------------
      recursive subroutine f12_integrals_srt(iket,ibra,iop1)
c----------------------------------------------------------------------
      implicit double precision (a-h,o-z)
      !include "common/tapes"
!comdeck tapes $Revision: 2006.4 $
!.....inp:  molpro input file number
!.....iout: output file number
!.....ipun: punch file number
!.....inpc: standart input file number
!.....iprio: io print paramter
!.....ltap:  max number of records per file (set in blk1)
!.....logout: unit number of log file
!.....logfile: name of log file
!.....logopen: flag indicating whether log file is open
!.....lastout: output unit before last call to openlog
!.....npl(ifile):  logical file number for molpro file ifile
!.....nre(ifile):  number of calculation
!.....iwrite(ifile): if nonzero, file has been written since last tapsav
!.....int2ad(irec): address offsets for two electron integral symmetry blocks
!ftc if Molpro
      !include "common/mxrec"
! src/common/mxrec $Revision: 2006.4 $
      parameter (mxrec=200)
      integer, parameter :: mxfil=9
      logical :: ga_debug
      common/tapes/inp,iout,ipun,inpc,iprio,ltap,logout,logopen,lastout,&
     &             npl(mxfil),nre(mxfil),iwrite(mxfil),int2ad(51)
      common/ltapes/ga_debug
      equivalence (nein,inp),(naus,iout)
      character(255) :: logfile
      common/clogf/logfile
!ftc else
!ftc ;      common/tapes/iout
!ftc end
      !include "common/big"
!comdeck big $Revision: 2002.10 $
      common /big/ q(2)
      integer iq(2)
      equivalence (q(1),iq(1))
      inkt=iraw_ket(iket)
      inbr=iraw_bra(ibra)
      if(irec_raw(inkt,ibra,iop1).eq.0)
     >   call f12_integrals_raw(inkt,ibra,iop1)
      name=name+1
      iclass=1
      irec_srt(iket,ibra,iop1)=name
      if(typr(inkt).ne.typk(iket)) then
        t1=cpu_tr2
        call df_trans_loc2(q(ikmos(iket)),q(ibuf),nbket(iket),
     >          ngto(inkt),
     >          iq(listmo),norb,
     >          nfit,nblk(inkt),iq(idim_blk(inkt)),
     >          iq(ioff_blk(inkt)),iq(numbti),nibatch,
     >          iq(numbtk(inkt,ibra,iop1)),nkbatch(inkt,ibra,iop1),
     >          ioff_uniorbdom(iket),ioff_unifitdom,
     >          irec_raw(inkt,ibra,iop1), ifil_3idx_half,
     >          irec_srt(iket,ibra,iop1), ifil_3idx_srt,
     >          nrec(inkt,ibra,iop1),iq(name_info(inkt,ibra,iop1)),
     >          q(name_off(inkt,ibra,iop1)),iclass,
     >          TRIM(opnam(iop1))//typk(iket)//typb(ibra),
     >          cpu_tr2,flops_tr2,
     >          disktr2,nrecout,0)
        t2=second()
        if(printdeb) write(iout,70) 'tr2',
     >                  typr(inkt)//typb(ibra),trim(opnam(iop1)),'A',
     >                  'A',trim(opnam(iop1)),typk(iket)//typb(ibra),
     >                   name,ifil_3idx_srt,cpu_tr2-t1
70    format(1x,a,2x,'<',a,'|',a,'|',a,'>',t16,' -> ',t20,
     >               '<',a,'|',a,'|',a,'>',t35,'record=',i4,'.',i1,
     >               '    CPU=',f8.2,' sec')
      else
        t1=cpu_srt
        call df_sort_loc2(q(ibuf),ngto(inkt),nfit,nblk(inkt),
     >        iq(listmo),norb,
     >        iq(idim_blk(inkt)),iq(ioff_blk(inkt)),
     >        iq(iperm_bl2(inkt)),
     >        iq(numbti),nibatch,
     >        iq(numbtk(inkt,ibra,iop1)),nkbatch(inkt,ibra,iop1),
     >        ioff_uniorbdom(iket),ioff_unifitdom,
     >        irec_raw(inkt,ibra,iop1), ifil_3idx_half,
     >        irec_srt(iket,ibra,iop1), ifil_3idx_srt,
     >        nrec(inkt,ibra,iop1),iq(name_info(inkt,ibra,iop1)),
     >        q(name_off(inkt,ibra,iop1)),iclass,
     >        TRIM(opnam(iop1))//typk(iket)//typb(ibra),
     >        cpu_srt,disktr2,nrecout)
        if(printdeb) write(iout,70) 'srt',
     >               typr(inkt)//typb(ibra),trim(opnam(iop1)),'A',
     >               'A',trim(opnam(iop1)),typk(iket)//typb(ibra),
     >               name,ifil_3idx_srt,cpu_srt-t1
      end if
      return
      end subroutine f12_integrals_srt
c----------------------------------------------------------------------
      recursive subroutine f12_integrals_bar(iket,ibra,iop1)
c----------------------------------------------------------------------
      implicit double precision (a-h,o-z)
      !include "common/tapes"
!comdeck tapes $Revision: 2006.4 $
!.....inp:  molpro input file number
!.....iout: output file number
!.....ipun: punch file number
!.....inpc: standart input file number
!.....iprio: io print paramter
!.....ltap:  max number of records per file (set in blk1)
!.....logout: unit number of log file
!.....logfile: name of log file
!.....logopen: flag indicating whether log file is open
!.....lastout: output unit before last call to openlog
!.....npl(ifile):  logical file number for molpro file ifile
!.....nre(ifile):  number of calculation
!.....iwrite(ifile): if nonzero, file has been written since last tapsav
!.....int2ad(irec): address offsets for two electron integral symmetry blocks
!ftc if Molpro
      !include "common/mxrec"
! src/common/mxrec $Revision: 2006.4 $
      parameter (mxrec=200)
      integer, parameter :: mxfil=9
      logical :: ga_debug
      common/tapes/inp,iout,ipun,inpc,iprio,ltap,logout,logopen,lastout,&
     &             npl(mxfil),nre(mxfil),iwrite(mxfil),int2ad(51)
      common/ltapes/ga_debug
      equivalence (nein,inp),(naus,iout)
      character(255) :: logfile
      common/clogf/logfile
!ftc else
!ftc ;      common/tapes/iout
!ftc end
      !include "common/big"
!comdeck big $Revision: 2002.10 $
      common /big/ q(2)
      integer iq(2)
      equivalence (q(1),iq(1))
      if(irec_srt(iket,ibra,iop1).eq.0)
     >   call f12_integrals_srt(iket,ibra,iop1)
      ixmat=icorr(n2)
      ixloc=ixmat
      ipiv=icori(nfit+1)
      if(locfit.eq.0) then
        call f12_integrals_jinv(ixmat,ipiv)   !get J^{-1}(A,B)
      else
        ixloc=icorr(n2)
        call f12_integrals_2idx(ixmat,1)          !get J(A,B)
      end if
      name=name+1
      irec_bar(iket,ibra,iop1)=name
      call add_mpptim('DFR12FIT',0,0)
      t1=cpu_fit
      call df_fit_f12(q(ixmat),q(ixloc),iq(ipiv),
     >                locfit,iq(listmo),norb,nfit,
     >                ioff_uniorbdom(iket),                   !united AO orbital domains
     >                ioff_fitdom,ioff_unifitdom,             !extended united fit domains
     >                irec_srt(iket,ibra,iop1),               !input integral records
     >                irec_bar(iket,ibra,iop1),               !output fitting coefficients
     >                ifil_3idx_srt,
     >                ifil_3idx_bar,
     >                opnam(iop1),typk(iket)//typb(ibra),
     >                cpu_fit,flops_fit,
     >                disktr2,nrecout)
      if(printdeb) write(iout,70) 'fit',
     >                     'A',trim(opnam(iop1)),typk(iket)//typb(ibra),
     >                    'Ab',trim(opnam(iop1)),typk(iket)//typb(ibra),
     >                     name,ifil_3idx_bar,cpu_fit-t1
70    format(1x,a,2x,'<',a,'|',a,'|',a,'>',t16,' -> ',t20,
     >               '<',a,'|',a,'|',a,'>',t35,'record=',i4,'.',i1,
     >               '    CPU=',f8.2,' sec')
      call corlsr(ixmat)
      call add_mpptim('DFR12FIT',0,1)
      return
      end subroutine f12_integrals_bar
c----------------------------------------------------------------------
      recursive subroutine f12_integrals_til(iket,ibra,iop1)
c----------------------------------------------------------------------
      implicit double precision (a-h,o-z)
      !include "common/tapes"
!comdeck tapes $Revision: 2006.4 $
!.....inp:  molpro input file number
!.....iout: output file number
!.....ipun: punch file number
!.....inpc: standart input file number
!.....iprio: io print paramter
!.....ltap:  max number of records per file (set in blk1)
!.....logout: unit number of log file
!.....logfile: name of log file
!.....logopen: flag indicating whether log file is open
!.....lastout: output unit before last call to openlog
!.....npl(ifile):  logical file number for molpro file ifile
!.....nre(ifile):  number of calculation
!.....iwrite(ifile): if nonzero, file has been written since last tapsav
!.....int2ad(irec): address offsets for two electron integral symmetry blocks
!ftc if Molpro
      !include "common/mxrec"
! src/common/mxrec $Revision: 2006.4 $
      parameter (mxrec=200)
      integer, parameter :: mxfil=9
      logical :: ga_debug
      common/tapes/inp,iout,ipun,inpc,iprio,ltap,logout,logopen,lastout,&
     &             npl(mxfil),nre(mxfil),iwrite(mxfil),int2ad(51)
      common/ltapes/ga_debug
      equivalence (nein,inp),(naus,iout)
      character(255) :: logfile
      common/clogf/logfile
!ftc else
!ftc ;      common/tapes/iout
!ftc end
      !include "common/big"
!comdeck big $Revision: 2002.10 $
      common /big/ q(2)
      integer iq(2)
      equivalence (q(1),iq(1))
      if(irec_bar(iket,ibra,1).eq.0)
     >    call f12_integrals_bar(iket,ibra,1)
      if(irec_srt(iket,ibra,iop1).eq.0)
     >    call f12_integrals_srt(iket,ibra,iop1)
c
      ixmat=icorr(n2)
      ixloc=ixmat
      if(locfit.gt.0) ixloc=icorr(nfitmax*nfitmax)
      call f12_integrals_2idx(ixmat,iop1)
c
      name=name+1
      irec_til(iket,ibra,iop1)=name
      t1=cpu_til
      call df_til_f12(q(ixmat),q(ixloc),
     >                locfit,iq(listmo),norb,nfit,
     >                ioff_uniorbdom(iket),                   !united AO orbital domains
     >                ioff_fitdom,ioff_unifitdom,             !extended united fit domains
     >                irec_srt(iket,ibra,iop1),               !input integral records
     >                irec_til(iket,ibra,iop1),               !output tilde integrals
     >                irec_bar(iket,ibra,1),                  !J fitting coefficients
     >                ifil_3idx_srt,
     >                ifil_3idx_til,
     >                ifil_3idx_bar,
     >                opnam(iop1),typk(iket)//typb(ibra),
     >                cpu_til,flops_til,
     >                disktr2,nrecout)
      call corlsr(ixmat)
      if(printdeb) write(iout,70) 'til',
     >                   'A',trim(opnam(iop1)),typk(iket)//typb(ibra),
     >                  'At',trim(opnam(iop1)),typk(iket)//typb(ibra),
     >                   name,ifil_3idx_til,cpu_til-t1
70    format(1x,a,2x,'<',a,'|',a,'|',a,'>',t16,' -> ',t20,
     >               '<',a,'|',a,'|',a,'>',t35,'record=',i4,'.',i1,
     >               '    CPU=',f8.2,' sec')
      return
      end subroutine f12_integrals_til
c----------------------------------------------------------------------
      recursive subroutine f12_integrals_2idx(ixmt,iop1)
c----------------------------------------------------------------------
      implicit double precision (a-h,o-z)
      !include "common/tapes"
!comdeck tapes $Revision: 2006.4 $
!.....inp:  molpro input file number
!.....iout: output file number
!.....ipun: punch file number
!.....inpc: standart input file number
!.....iprio: io print paramter
!.....ltap:  max number of records per file (set in blk1)
!.....logout: unit number of log file
!.....logfile: name of log file
!.....logopen: flag indicating whether log file is open
!.....lastout: output unit before last call to openlog
!.....npl(ifile):  logical file number for molpro file ifile
!.....nre(ifile):  number of calculation
!.....iwrite(ifile): if nonzero, file has been written since last tapsav
!.....int2ad(irec): address offsets for two electron integral symmetry blocks
!ftc if Molpro
      !include "common/mxrec"
! src/common/mxrec $Revision: 2006.4 $
      parameter (mxrec=200)
      integer, parameter :: mxfil=9
      logical :: ga_debug
      common/tapes/inp,iout,ipun,inpc,iprio,ltap,logout,logopen,lastout,&
     &             npl(mxfil),nre(mxfil),iwrite(mxfil),int2ad(51)
      common/ltapes/ga_debug
      equivalence (nein,inp),(naus,iout)
      character(255) :: logfile
      common/clogf/logfile
!ftc else
!ftc ;      common/tapes/iout
!ftc end
      !include "common/big"
!comdeck big $Revision: 2002.10 $
      common /big/ q(2)
      integer iq(2)
      equivalence (q(1),iq(1))
c
c... 2-index integrals
c
      if(irec_2idx(iop1).eq.0) then
        t1=second()
        name=name+1
        irec_2idx(iop1)=name
        call basis_sqr(fitbas,opnam(iop1),q(ixmt),throv)
        call writem(q(ixmt),n2,ifil_2idx,irec_2idx(iop1),0,opnam(iop1))
        t2=second()
        cpu_i2x=cpu_i2x+t2-t1
        if(printdeb) write(iout,80) '2-index integrals',
     >       trim(opnam(iop1))//'AB',name,ifil_2idx,t2-t1
80      format(1x,a,1x,a,t35,'record=',i4,'.'i1,'    CPU=',f8.2,' sec')
      else
        call lesw(q(ixmt),n2,ifil_2idx,irec_2idx(iop1),0)
      end if
      return
      end subroutine f12_integrals_2idx
c----------------------------------------------------------------------
      subroutine f12_integrals_jinv(ixmt,ipv)
c----------------------------------------------------------------------
      implicit double precision (a-h,o-z)
      !include "common/tapes"
!comdeck tapes $Revision: 2006.4 $
!.....inp:  molpro input file number
!.....iout: output file number
!.....ipun: punch file number
!.....inpc: standart input file number
!.....iprio: io print paramter
!.....ltap:  max number of records per file (set in blk1)
!.....logout: unit number of log file
!.....logfile: name of log file
!.....logopen: flag indicating whether log file is open
!.....lastout: output unit before last call to openlog
!.....npl(ifile):  logical file number for molpro file ifile
!.....nre(ifile):  number of calculation
!.....iwrite(ifile): if nonzero, file has been written since last tapsav
!.....int2ad(irec): address offsets for two electron integral symmetry blocks
!ftc if Molpro
      !include "common/mxrec"
! src/common/mxrec $Revision: 2006.4 $
      parameter (mxrec=200)
      integer, parameter :: mxfil=9
      logical :: ga_debug
      common/tapes/inp,iout,ipun,inpc,iprio,ltap,logout,logopen,lastout,&
     &             npl(mxfil),nre(mxfil),iwrite(mxfil),int2ad(51)
      common/ltapes/ga_debug
      equivalence (nein,inp),(naus,iout)
      character(255) :: logfile
      common/clogf/logfile
!ftc else
!ftc ;      common/tapes/iout
!ftc end
      !include "common/clseg"
      !include "common/big"
!comdeck big $Revision: 2002.10 $
      common /big/ q(2)
      integer iq(2)
      equivalence (q(1),iq(1))
c
c... LU decomposition of J
c
      if(irec_jinv.gt.0) then
        call lesw(q(ixmt),n2,ifil_2idx,irec_Jinv,0)
        call lesw(iq(ipv),(nfit+1)/intrel,ifil_2idx,irec_Jinv,n2)
        return
      else
        if(irec_2idx(1).eq.0) call f12_integrals_2idx(ixmt,1)
        t1=second()
        name=name+1
        irec_jinv=name
        info = 0
        call dgetrf_x(nfit,nfit,q(ixmt),nfit,iq(ipv),info)
        if(info.ne.0) goto 500
        call writem(q(ixmt),n2,ifil_2idx,irec_Jinv,0,'Jinv')
        call writem(iq(ipv),(nfit+1)/intrel,ifil_2idx,irec_Jinv,n2,
     >              'Jinv')
        flops_inv=flops_inv+dble(nfit)*dble(nfit)*dble(nfit)
        t2=second()
        cpu_inv=cpu_inv+t2-t1
        if(printdeb) write(iout,80) 'LU decomposion of',
     >              'JAB',name,ifil_2idx,t2-t1
80      format(1x,a,1x,a,t35,'record=',i4,'.'i1,'    CPU=',f8.2,' sec')
      end if
      return
500   write(6,*) 'dgetrf return code=',info
      call error('Error in dgetrf','f12_integrals')
      return
      end subroutine f12_integrals_jinv
c----------------------------------------------------------------------
      subroutine f12_listmo(listkl,nkl,listmo,m,norb,nklq,debug)
c----------------------------------------------------------------------
      implicit double precision (a-h,o-z)
      integer, intent(in)  :: listkl(2,nkl)
      integer, intent(in)  :: nkl,m
      integer, intent(out) :: nklq,listmo(*),norb
      logical, intent(in)  :: debug
      !include "common/corb"
!comdeck corb $Revision: 2002.10 $
      !include "common/corbdim"
! src/common/corbdim $Revision: 2006.3 $
!comdeck corbdim $ Revision: 2002.9 $
      !include "common/maxval"
!comdeck maxval $Revision: 2002.10 $
      parameter (maxval= 300)
!ftc if Molpro
!ftc start unix-i4 ibm
!ftc ;      integer, parameter :: mxval=maxval,mxact=16,mxclos=maxval
!ftc end
!ftc start univac
!ftc ;      integer, parameter :: mxval=maxval,mxact=18,mxclos=maxval
!ftc end
!ftc start cray eta unix-i8
      integer, parameter :: mxval=maxval,mxact=32,mxclos=maxval
!ftc end
!ftc else
!ftc ;      integer, parameter :: mxval=maxval
!ftc end
!.....nsk:          number of different orbital symmetries
!.....nskcp:        number of different product symmetries
!.....mult(is,js):  symmetry multiplication table.
!
!.....nocc:         total number of occupied orbitals
!.....ncore:        total number of core orbitals
!.....nclos:        total number of closed-shell orbitals in ref.
!.....nval:         total number of valence (correlated) orbitals
!.....nact:         total number of active orbitals in reference
!
!.....iocc(isy):    number of internal orbitals in symmetries
!.....icore(isy):   number of core orbitals in symmetries
!.....iclos(isy):   number of closed-shell+core orbitals in symmetries
!.....icloss(isy):  number of closed-shell orbitals in symmetries
!.....ival(isy):    number of valence orbitals in symmetries
!.....iact(isy):    number of active orbitals in symmetries
!
!.....isyval(iorb): symmetry of given valence orbital.
!.....iorbvl(lorb): absolute orbital number in symmetry for valence orb.
!.....iacval(iorb): number of active orbital for given valence orbital
!.....              iacval(iorb)=0: closed-shell orbital
!.....ivals(iorb):  number of absolute val. orb. iorb in its symmetry(1st=1)
!.....iofval(isy):  offsets of valence orbitals in symmetries
!.....ivastr(isy):  first valence orbital of given symmetry
!.....ivaend(isy):  last valence orbital of given symmetry
!.....ldval(isy):   lengths of triangular valence matrices of given symmetries
!.....lqval(isy):   lengths of square square matrices of given symmetries
!
!.....isyact(iorb): symmetry of given active orbital.
!.....ivalac(iorb): valence orbital number for given active orbital
!.....iofact(isy):  offsets of active orbitals in symmetries
!.....iacstr(isy):  first active orbital of given symmetry
!.....iacend(isy):  last active orbital of given symmetry
!.....ldact(isy):   lengths of triangular active matrices of given symmetries
!.....lqact(isy):   lengths of square active matrices of given symmetries
!.....iaaq(i,j):    square active-active matrix addressing
!.....iaad(i,j):    triangular ative-active active matrix addressing
!.....iccq(i,j):    square closed-closed matrix addressing
!.....iccd(i,j):    triangular closed-closed matrix addressing
!.....icaq(i,j):    square closed-active matrix addressing
!.....icad(i,j):    triangular closed-active matrix addressing
!.....iacq(i,j):    square active-closed matrix addressing
!.....iacd(i,j):    triangular active-closed matrix addressing
!.....ivvd(i,j):    square valence-valence matrix addressing
!
!.....isyclo(iorb): symmetry of given closed-shell orbital
!.....ivalcl(iorb): valence orbital number for given closed-shell orbital
!.....iclval(iorb): closed-shell orbital number for given valence orbital
!                   (zero if not closed-shell)
!.....iofclo(isy):  offsets of closed-shell orbitals in symmetries
!.....iclstr(isy):  first closed-shell orbital of given symmetry
!.....iclend(isy):  last closed-shell orbital of given symmetry
!.....ldclo(isy):   lengths of triangular closed-shell matrices
!.....lqclo(isy):   lengths of square closed-shell matrices
!.....ldacc(isy):   lengths of triangular active-closed matrices
!.....lqacc(isy):   lengths of square closed-active  matrices
!
!.....idoff(isy):   symmetry offsets for second order density
!.....idoffv(isy):  symmetry offsets for second order density, valence
!.....iqoff(isy):   symmetry offsets for third order density
!.....lend2:        length of second order density matrix
!.....lend2v:       length of second order density matrix, valence
!.....lend3(isyij): length of third order density matrix for given ij
!.....lend3m:       maximum of lend3(isy)
      common/cval/ nval,ival(8),iofval(9),ivastr(8),ivaend(8),          &
     &             ldval(8),lqval(8),                                   &
     &             isyval(mxval),iacval(mxval),iorbvl(mxval),           &
     &             listp(mxval,mxval),ivals(mxval),iclval(mxval)
      common/corb/ nocc,iocc(8)
!ftc if Molpro
      common/ccor/ ncore,icore(8)
      common/clos/ nclos,iclos(8),isyclo(mxclos),ivalcl(mxclos),        &
     &             icloss(8),iofclo(9),ldclo(8),lqclo(8),               &
     &             iclstr(8),iclend(8),iclosx(8)
      common/cact/ nact,iact(8),iofact(9),ldact(8),lqact(8),            &
     &             mult(8,8),isyact(mxact),iacstr(8),iacend(8),         &
     &             idoff(8),lend2,iqoff(8,8),lend3(8),lend3m,           &
     &             nsk,nskcp,ivalac(mxact)
!.....dimensions for cicon/cclist: if closed-shells kept, these dimensions
!.... are equal to nval/ival. If closed-shells are eliminated, they
!.....are equal to nact/iact
!.....pointers:  iactvc(ivcl): points to corresponding active orbital
!.....           ivalvc(ivcl): points to corresponding valence orbital
!.....           iclovc(ivcl): points to corresponding closed-shell orbital
      common/cvac/ nvac,ivac(8),iofvac(9),ivcstr(8),ivcend(8),          &
     &             isyvac(mxval),iactvc(mxval),ivalvc(mxval),           &
     &             iclovc(mxval),ldvac(8),lqvac(8),                     &
     &             ivacac(mxact)
      common/cnum/numop(mxval,mxval)
      common/caad/idoffv(8),lend2v,iaaq(mxact,mxact),iaad(mxact,mxact), &
     &            iccq(mxclos,mxclos),iccd(mxclos,mxclos),              &
     &            icaq(mxclos,mxact),iacq(mxact,mxclos),                &
     &            ldacc(8),lqacc(8),ivvd(mxval,mxval),                  &
     &            icad(mxclos,mxact),iacd(mxact,mxclos),                &
     &            ivvq(mxval,mxval)
!ftc else
!ftc ;      common/cact/ mult(8,8),nsk,nskcp
!ftc ;      common/caad/ivvd(mxval,mxval),ivvq(mxval,mxval)
!ftc end
!.....ntos(isym,iblock): block offsets for (n,occ) matrices
!.....ntogs(isym): total lengths of (n,occ) matrices
!.....noos(isym,iblock): block offsets for (occ,occ) matrices
!.....noogs(isym): total lengths of (occ,occ) matrices
!ftc if Molpro
      common/cobas/ ntos(8,8),ntogs(8),noos(8,8),noogs(8)
      common/cvbas/ ntvs(8,8),ntvgs(8),nvvs(8,8),nvvgs(8)
!ftc end
      call izero(listmo,m)
      mmax=0
      nklq=0
      do kl=1,nkl
        k=listkl(1,kl)
        l=listkl(2,kl)
        if(k.eq.l) nklq=nklq+1
        if(k.gt.l) nklq=nklq+2
        listmo(k)=1
        listmo(l)=1
        mmax=max(mmax,k,l)
      end do
      if(mmax.gt.m) then
        write(6,*) 'Highest orbital in listkl:',mmax
        write(6,*) 'Number of bra orbitals:   ',m
        call error('Inconsistent bra dimensions','f12_integrals_init')
      end if
      norb=0
      do i=1,mmax
        if(listmo(i).ne.0) then
          norb=norb+1
          listmo(norb)=i
        end if
      end do
      if(debug) call outive(listmo,norb,'LISTMO')
      return
      end subroutine f12_listmo
c----------------------------------------------------------------------
      subroutine f12_unidom(ioff_pairdom,ioff_uniorbdom,
     >           listkl,nkl,listq,m,list,n,locket,fullket,typ)
c----------------------------------------------------------------------
      implicit double precision (a-h,o-z)
      character*(*) typ
      logical locket,fullket
      !include "common/zahl"
! src/common/zahl $Revision: 2006.3 Patch(2006.4): common_zahl $
      common/zahl/ z0,z1,z2,z4,z05,z10h6,z10hm8,z10m12
      !include "common/corb"
!comdeck corb $Revision: 2002.10 $
      !include "common/corbdim"
! src/common/corbdim $Revision: 2006.3 $
!comdeck corbdim $ Revision: 2002.9 $
      !include "common/maxval"
!comdeck maxval $Revision: 2002.10 $
      parameter (maxval= 300)
!ftc if Molpro
!ftc start unix-i4 ibm
!ftc ;      integer, parameter :: mxval=maxval,mxact=16,mxclos=maxval
!ftc end
!ftc start univac
!ftc ;      integer, parameter :: mxval=maxval,mxact=18,mxclos=maxval
!ftc end
!ftc start cray eta unix-i8
      integer, parameter :: mxval=maxval,mxact=32,mxclos=maxval
!ftc end
!ftc else
!ftc ;      integer, parameter :: mxval=maxval
!ftc end
!.....nsk:          number of different orbital symmetries
!.....nskcp:        number of different product symmetries
!.....mult(is,js):  symmetry multiplication table.
!
!.....nocc:         total number of occupied orbitals
!.....ncore:        total number of core orbitals
!.....nclos:        total number of closed-shell orbitals in ref.
!.....nval:         total number of valence (correlated) orbitals
!.....nact:         total number of active orbitals in reference
!
!.....iocc(isy):    number of internal orbitals in symmetries
!.....icore(isy):   number of core orbitals in symmetries
!.....iclos(isy):   number of closed-shell+core orbitals in symmetries
!.....icloss(isy):  number of closed-shell orbitals in symmetries
!.....ival(isy):    number of valence orbitals in symmetries
!.....iact(isy):    number of active orbitals in symmetries
!
!.....isyval(iorb): symmetry of given valence orbital.
!.....iorbvl(lorb): absolute orbital number in symmetry for valence orb.
!.....iacval(iorb): number of active orbital for given valence orbital
!.....              iacval(iorb)=0: closed-shell orbital
!.....ivals(iorb):  number of absolute val. orb. iorb in its symmetry(1st=1)
!.....iofval(isy):  offsets of valence orbitals in symmetries
!.....ivastr(isy):  first valence orbital of given symmetry
!.....ivaend(isy):  last valence orbital of given symmetry
!.....ldval(isy):   lengths of triangular valence matrices of given symmetries
!.....lqval(isy):   lengths of square square matrices of given symmetries
!
!.....isyact(iorb): symmetry of given active orbital.
!.....ivalac(iorb): valence orbital number for given active orbital
!.....iofact(isy):  offsets of active orbitals in symmetries
!.....iacstr(isy):  first active orbital of given symmetry
!.....iacend(isy):  last active orbital of given symmetry
!.....ldact(isy):   lengths of triangular active matrices of given symmetries
!.....lqact(isy):   lengths of square active matrices of given symmetries
!.....iaaq(i,j):    square active-active matrix addressing
!.....iaad(i,j):    triangular ative-active active matrix addressing
!.....iccq(i,j):    square closed-closed matrix addressing
!.....iccd(i,j):    triangular closed-closed matrix addressing
!.....icaq(i,j):    square closed-active matrix addressing
!.....icad(i,j):    triangular closed-active matrix addressing
!.....iacq(i,j):    square active-closed matrix addressing
!.....iacd(i,j):    triangular active-closed matrix addressing
!.....ivvd(i,j):    square valence-valence matrix addressing
!
!.....isyclo(iorb): symmetry of given closed-shell orbital
!.....ivalcl(iorb): valence orbital number for given closed-shell orbital
!.....iclval(iorb): closed-shell orbital number for given valence orbital
!                   (zero if not closed-shell)
!.....iofclo(isy):  offsets of closed-shell orbitals in symmetries
!.....iclstr(isy):  first closed-shell orbital of given symmetry
!.....iclend(isy):  last closed-shell orbital of given symmetry
!.....ldclo(isy):   lengths of triangular closed-shell matrices
!.....lqclo(isy):   lengths of square closed-shell matrices
!.....ldacc(isy):   lengths of triangular active-closed matrices
!.....lqacc(isy):   lengths of square closed-active  matrices
!
!.....idoff(isy):   symmetry offsets for second order density
!.....idoffv(isy):  symmetry offsets for second order density, valence
!.....iqoff(isy):   symmetry offsets for third order density
!.....lend2:        length of second order density matrix
!.....lend2v:       length of second order density matrix, valence
!.....lend3(isyij): length of third order density matrix for given ij
!.....lend3m:       maximum of lend3(isy)
      common/cval/ nval,ival(8),iofval(9),ivastr(8),ivaend(8),          &
     &             ldval(8),lqval(8),                                   &
     &             isyval(mxval),iacval(mxval),iorbvl(mxval),           &
     &             listp(mxval,mxval),ivals(mxval),iclval(mxval)
      common/corb/ nocc,iocc(8)
!ftc if Molpro
      common/ccor/ ncore,icore(8)
      common/clos/ nclos,iclos(8),isyclo(mxclos),ivalcl(mxclos),        &
     &             icloss(8),iofclo(9),ldclo(8),lqclo(8),               &
     &             iclstr(8),iclend(8),iclosx(8)
      common/cact/ nact,iact(8),iofact(9),ldact(8),lqact(8),            &
     &             mult(8,8),isyact(mxact),iacstr(8),iacend(8),         &
     &             idoff(8),lend2,iqoff(8,8),lend3(8),lend3m,           &
     &             nsk,nskcp,ivalac(mxact)
!.....dimensions for cicon/cclist: if closed-shells kept, these dimensions
!.... are equal to nval/ival. If closed-shells are eliminated, they
!.....are equal to nact/iact
!.....pointers:  iactvc(ivcl): points to corresponding active orbital
!.....           ivalvc(ivcl): points to corresponding valence orbital
!.....           iclovc(ivcl): points to corresponding closed-shell orbital
      common/cvac/ nvac,ivac(8),iofvac(9),ivcstr(8),ivcend(8),          &
     &             isyvac(mxval),iactvc(mxval),ivalvc(mxval),           &
     &             iclovc(mxval),ldvac(8),lqvac(8),                     &
     &             ivacac(mxact)
      common/cnum/numop(mxval,mxval)
      common/caad/idoffv(8),lend2v,iaaq(mxact,mxact),iaad(mxact,mxact), &
     &            iccq(mxclos,mxclos),iccd(mxclos,mxclos),              &
     &            icaq(mxclos,mxact),iacq(mxact,mxclos),                &
     &            ldacc(8),lqacc(8),ivvd(mxval,mxval),                  &
     &            icad(mxclos,mxact),iacd(mxact,mxclos),                &
     &            ivvq(mxval,mxval)
!ftc else
!ftc ;      common/cact/ mult(8,8),nsk,nskcp
!ftc ;      common/caad/ivvd(mxval,mxval),ivvq(mxval,mxval)
!ftc end
!.....ntos(isym,iblock): block offsets for (n,occ) matrices
!.....ntogs(isym): total lengths of (n,occ) matrices
!.....noos(isym,iblock): block offsets for (occ,occ) matrices
!.....noogs(isym): total lengths of (occ,occ) matrices
!ftc if Molpro
      common/cobas/ ntos(8,8),ntogs(8),noos(8,8),noogs(8)
      common/cvbas/ ntvs(8,8),ntvgs(8),nvvs(8,8),nvvgs(8)
!ftc end
      !include "common/cbas"
! src/common/cbas $Revision: 2006.3 $
!comdeck cbas $ Revision: 2002.9 $
!.....nt(isy):  number of basis functions in symmetry
!.....nts(isy): offset for basis functions of given symmetry
!.....ntg:      total number of basis functions
!.....ntd(isy): block offsets in triangular matrices of symmetry 1
!.....ntdg:     total length of triangular matrix of symmetry 1
!.....ntq(isy): block offsets in square matrices of symmetry 1
!.....ntqg:     total length of square matrix of symmetry 1
!.....ntds(isy,iblock): block offsets in triangular matrices
!.....ntqs(isy,iblock): block offsets in square matrices
!.....ntdgs(isy): total length of triangular matrices
!.....ntqgs(isy): total length of square matrices
!.....ntdgc(isy): ntdgs(isy) rounded up to multiple of sector length
!.....ntqgc(isy): ntqgs(isy) rounded up to multiple of sector length
!
!.....all quantities with x: as above for full basis set
!.....all quantities with y: as above for external space
!.....all quantities with z: as above for open + virtual space
!.....(open shell perturbation and coupled cluster theory)
!...  y and z are reversed if the flag  irevyz is set!
!
!.....the block number is equal to the row (left) symmetry
!
      common/cbasci/ nt(8),ntb(8),nts(8),ntg,ntd(8),ntdg,ntq(8),ntqg,   &
     &         ntds(8,8),ntqs(8,8),ntdgs(8),ntqgs(8),                   &
     &         ntdgc(8),ntqgc(8),                                       &
     &         ntx(8),ntbx(8),ntsx(8),ntgx,ntdx(8),ntdgx,ntqx(8),ntqgx, &
     &         ntdsx(8,8),ntqsx(8,8),ntdgsx(8),ntqgsx(8),               &
     &         ntdgcx(8),ntqgcx(8),                                     &
     &         nty(8),ntby(8),ntsy(8),ntgy,ntdy(8),ntdgy,ntqy(8),ntqgy, &
     &         ntdsy(8,8),ntqsy(8,8),ntdgsy(8),ntqgsy(8),               &
     &         ntdgcy(8),ntqgcy(8),                                     &
     &         ntr
!ftc Start Molpro
      common/cbaso/                                                     &
     &         ntz(8),ntbz(8),ntsz(8),ntgz,ntdz(8),ntdgz,ntqz(8),ntqgz, &
     &         ntdsz(8,8),ntqsz(8,8),ntdgsz(8),ntqgsz(8),               &
     &         ntdgcz(8),ntqgcz(8),ntqsyz(8,8),ntqgsyz(8),ntqgcyz(8),   &
     &         ntqyz(8),ntqgyz,irevyz
!ftc End
      !include "common/tapes"
!comdeck tapes $Revision: 2006.4 $
!.....inp:  molpro input file number
!.....iout: output file number
!.....ipun: punch file number
!.....inpc: standart input file number
!.....iprio: io print paramter
!.....ltap:  max number of records per file (set in blk1)
!.....logout: unit number of log file
!.....logfile: name of log file
!.....logopen: flag indicating whether log file is open
!.....lastout: output unit before last call to openlog
!.....npl(ifile):  logical file number for molpro file ifile
!.....nre(ifile):  number of calculation
!.....iwrite(ifile): if nonzero, file has been written since last tapsav
!.....int2ad(irec): address offsets for two electron integral symmetry blocks
!ftc if Molpro
      !include "common/mxrec"
! src/common/mxrec $Revision: 2006.4 $
      parameter (mxrec=200)
      integer, parameter :: mxfil=9
      logical :: ga_debug
      common/tapes/inp,iout,ipun,inpc,iprio,ltap,logout,logopen,lastout,&
     &             npl(mxfil),nre(mxfil),iwrite(mxfil),int2ad(51)
      common/ltapes/ga_debug
      equivalence (nein,inp),(naus,iout)
      character(255) :: logfile
      common/clogf/logfile
!ftc else
!ftc ;      common/tapes/iout
!ftc end
      !include "common/cprint"
! src/common/cprint $Revision: 2006.3 $
!comdeck cprint
! iprint: local print options
! ipring: global print options
! note: this common defined explicitly in muinp1!
!ftc if Molpro
      parameter (nprc=24,nprt=50)
      common/cprint/ iprint(nprt)
      common/cpring/ ipring(nprc)
!ftc end
      !include "common/clocal"
*comdeck clocal $Revision: 2006.4 $
CStart Molpro
      !include "common/maxval_loc"
! src/common/maxval_loc $Revision: 2006.3 $
*comdeck maxval_loc
      parameter (mxvl= 300)
      !include "common/maxatm_loc"
! src/common/maxatm_loc $Revision: 2006.3 $
*comdeck maxatm_loc
      parameter (maxatm= 200)
      parameter (nloci=48,nlocr=44,maxmerge_list=maxatm)
c.....nloc(isym):       number of localized orbitals in symmetry isym
c.....xlcnt(imo), ylcnt(imo), zlcnt(imo): centers of charge for localized orbitals
      common/ccenter/ nloc(8),xlcnt(mxvl),ylcnt(mxvl),zlcnt(mxvl)
c
c.....ipaoc_str(maxatm,isym) 1st PAO of each center...
c.....ipaoc_end(maxatm,isym) last PAO of each center...
c.....npaoc(maxatm,isym)     number of PAOs on each center...
c.....npaocmx                max of all npaoc(,)
      common/cpaocen/ ipaoc_str(maxatm,8),ipaoc_end(maxatm,8),
     &                npaoc(maxatm,8),npaocmx
c
c.....ndoma:            number of primitive domains (= number of unique centers)
c.....ndomo:            number of domain blocks for valence orbitals
c.....ndomp:            number of domain blocks for pairs
c.....ndom:             total number of domain blocks
c.....idoma_str(imo):   pointer to first element of idoma for valence orbital imo
c.....idoma_end(imo):   pointer to last element of idoma for valence orbital imo
c.....idoma(idom):      z-matrix row numbers defining domains for valence orbitals (input)
c.....idomo_str(imo,isym):  pointer to first domain block of symmetry isym for orbital imo
c.....idomo_end(imo,isym):  pointer to last  domain block of symmetry isym for orbital imo
c.....idomp_str(ip,isym):   pointer to first domain block of symmetry isym for pair ip
c.....idomp_end(ip,isym):   pointer to last  domain block of symmetry isym for pair ip
c.....idomup_str(imo,isym): pointer to first domain block of symmetry isym for orbital imo
c.....idomup_end(imo,isym): pointer to last  domain block of symmetry isym for orbital imo
c........ idomup_ ...       unified domains for given imo, only strong and weak pairs)
c.....idom_str(idom):   first basis function (AO) for domain block idom in its symmetry
c.....idom_end(idom):   last  basis function (AO) for domain block idom in its symmetry
c.....ntloc(imo,isym):  number of orbitals per symmetry in the domains of given mo
c.....iwadr(ip,isym):   address of pseudo canonical transformation matrix for pair domain ip
c.....ivadr(ip,isym):   address of canonical->local transformation matrix for pair domain ip
c.....lenv,lenw:        total lengths of transformation matrices
c.....it2len(ip):       length of local pair matrix ip
c.....nstrong:          number of strong pairs
c.....npcls:            number of close pairs (included in nstrong)
c.....nweak:            number of weak pairs
c.....ndist:            number of distant pairs
c.....nvdist:           number of very distant pairs
c.....maxpdomsize       max over all pair domain sizes
c.....maxjdomsize       max over all jop domain sizes
c.....maxkdomsize       max over all kop domain sizes
c.....maxjedomsize      max over all J(E) domain sizes
c.....MaxL_KOp          max size of local K operator
c
c.....offsets in idomp lists (concerns idomp_str, idomp_end, ntloc, it2len).
c.....ioff_distdom: offset for orbital domains used in asymmetric distant pairs
c.....ioff_opjdom:  offset for j-operator domains: use idomp_str(ioff_jdom+iop,isym) etc
c.....              for J(Eij), K(Eij) use:  idomp_str(ioff_jdom+numop(i,j),isym)
c.....ioff_opkdom:  offset for j-operator domains: use idomp_str(ioff_kdom+iop,isym) etc
c.....ioff_up0dom:  offset for up domains for strong pairs: idomp_str(ioff_up0dom+ival,isym)
c.....ioff_up1dom:  offset for up domains for strong and weak pairs: idomp_str(ioff_up1dom+ival,isym)
c.....ioff_up2dom:  offset for up-domains for strong, ewak, and distant pairs: idomp_str(ioff_up2dom+ival,isym)
c.....ioff_opjup1dom: offset for up1 domains over joperator pair domains
c.....ioff_opkup1dom: offset for up1 domains over koperator pair domains
c.....ioff_utridom:   offset for united triple domains
c.....ioff_3extdom:   offset for domains for 3ext integrals
c.....ioff_relopjdom: offset for opj pair domains, rel. to 3ext domains...
c.....ioff_relpdom:   offset for (strong) pair domains, rel. to 3ext domains...
c.....ioff_intdom_lccsd:    offset for internal j-operator domains in lccsd
c.....ioff_fitdom_lccsd:    offset for fitting domains in lccsd
c.....ioff_1extdom_lccsd:   offset for 1-external domains in lccsd
c.....ioff_dom:       current offset in domain list idomp
c.....numopq(imo,jmo): numop (quadr.) for rel. pair domains...
c.....listpq(imo,jmo): listp (quadr.) for rel. pair domains...
c.....                 note: unlike numop numopq(imo,jmo).ne.numopq(jmo,imo) !!
c.....lmax:         largest pair domain size (strong+weak) in one symmetry
c.....lmax2:        largest pair matrix (strong+weak)
c
      parameter (mxpr=mxvl*(mxvl+1)/2)
      parameter (mxdomo=4*mxvl+8,mxdomp=8*mxpr+8,mxdom=mxdomo+mxdomp)
      common/cdomain/ ndom,
     >   ndoma,idoma_str(mxvl),idoma_end(mxvl),idoma(mxdomo),
     >   ndomo,idomo_str(0:8+mxvl,8),idomo_end(0:8+mxvl,8),
     >   ndomp,idomp_str(0:8+mxpr,8),idomp_end(0:8+mxpr,8),
     >   idom_str(mxdom),idom_end(mxdom),
     >   ntloc(0:mxpr,8),iwadr(mxpr,8),lenw,ivadr(mxpr,8),lenv,
     >   it2len(mxpr),nlt1,int1t(mxvl),nstrong,nweak,ndist,nvdist,
     >   ipdlm,isydlm,ndelp,eigdlm,eigmin,ipmin,isymin,natom_list,
     >   maxpdomsize,ioff_opjdom,ioff_opkdom,
     >   ioff_up0dom,ioff_up1dom,ioff_up2dom,lmax,lmax2,
     >   maxjdomsize,maxkdomsize,
     >   ioff_opjup1dom,ioff_opkup1dom,
     >   ioff_utridom,ioff_3extdom,ioff_relopjdom,ioff_relpdom,
     >   npcls,maxjedomsize,ioff_opjedom,ioff_opjupedom,MaxL_Kop,
     >   merge_list,merge_set,atom_merge_set(mxvl),
     >   idomoc_end(0:8+mxvl,8),idomow_end(0:8+mxvl,8),
     >   idomod_end(0:8+mxvl,8),
     >   iwoff(mxpr+2),ioff_distdom,
     >   ioff_mp2dom,ioff_dom,ioff_intdom_lccsd,ioff_1extdom_lccsd,
     >   ioff_fitdom_lccsd,npp_lccsd,npp_lccsd_res,list_canblk(mxvl),
     >   keepcls,maxtyp_r,maxtyp_t,ioff_totdom,nvalcc
      common/cnum_loc/ numopq(mxvl,mxvl),listpq(mxvl,mxvl)
c
c.....drange:   radius from center of charge of localitzed orbitals within which
c               basis functions are included
c.....unitr:    unit of drange (can be set to ANG; default AU)
c.....savdom:   record for saveing domain information
c.....restdom:  record for restarting domain information
c.....weakpair: distance criterion for weak pairs (treated by MP2)
c.....distpair: distance criterion for distant pairs (treated approximately by MP2)
c.....verydist: distance criterion for very distant pairs (neglected)
c.....
c.....skipdist: determines at which stage distant pairs are eliminated
c.....locsing:  if zero, singles are not treated locally (for testing only)
c.....chgfrac:  atoms are included in an orbital domain, if total charge is below chgfrac
c.....chgmin:   atoms are included in an orbital domain if abs Mulliken charge is larger than chgmin
c.....chgminh:  H-atoms are included in an orbital domain if abs Mulliken charge is larger than chgminh
c.....locmull:  parameter to determine method for calculating atomic charges
c.....locorb:   if nonzero, localize orbitals according to Pipek-Mezey scheme
c.....locao:    localize with AO criterion
c.....thrpip:   threshold for Pipek-Mezey
c.....savloc:   record to save local orbitals
c.....thrkcp:   threshold for neglecting small coefficients in cckext
c.....thrcor:   threshold for deleting core orbitals (default 0.1)
c.....idelcor:  parameter for deleting core basis functions
c.....jiterm:   parameter for deleting domain blocks (ji)
c.....maxl_dom: maxl+1 for selecting orbital domains (2 means include s,p functions)
c.....nonorm:   if nonzero, don't normalize projected functions (ibaso=1)
c.....idomonly: if nonzero, determine domains only
c.....itypecheck: check type of basis functions in redundancy check
c.....lmp2algo:  if nonzero, use low order scaling method in lmp2 iterations
c.....iopdom:    if nonzero, use operator domain approximation
c.....iprojocc:  if nonzero, project occupied orbitals
c.....iopdom_dtraf if nonzero, use operator domain approximation in dtraf/lccsd
c.....thrlocx, thrgapx, thrloctx, thrgaptx: dummies, values in cthr are used
cgh - idistmthd: choose method for multipole approximation
cgh - nmltp: level for multipole approximation of exchange integrals
cgh - ishortmlt: level for multipole correction / monopolar exp.
cgh - longmlt: level of multipole correction / bipolar exp.
cgh - idstmlt: level of distant pair multipole expansion
cgh - mltpalgo: determines details of multipole algorithm
cgh - irun: specifies run number for two pass split operator algorithm
cgh - icof: level of damping function for multipole operators
cgh - cot: cutoff (in bohr) for multipole operators
cgh - scalecof: scaling factor for this damping function
cgh - decay: decay parameter for split coulomb operator approach
cgh - rmain: threshold for switching from monopolar expansion to 4-block approach for strong/weak pairs multipole correction
cgh - rionic: threshold for switching from mono- to bipolar expansion for ionic cross excitations
c.....i_epart:       if nonzero, activates energy partitioning...
c.....epart_cutoff:  cutoff parameter for energy partitioning
c.....thrmp2 threshold for mp2 iterations
      integer skipdist
      common/cparloci/ locmeth,idlbas,idlmeth,skipdist,locsing,
     >                locmull,locorb,jiterm,locao,nonorm,
     >                idelcor,idlshl,itypecheck,maxl_dom,iselect,
     >                iprselect,iolddef,idomonly,i_epart,nmltp,
     >                idistmthd,ishortmlt,longmlt,mltpalgo,irun,
     >                idstmlt,icof,lmp2algo,iopdom,ifitmltp,
     >                if1dgrid,if2dgridr,if2dgridp,i3dweight,
     >                mergedom,iprojocc,iopdom_dtraf,monopole,
     >                multpage,numbatch,ibatchalgo,iranseed,ipet
      common/cparlocr/ savdom,restdom,savloc,drange,verydist,distpair,
     >                weakpair,chgfrac,cdelmin,rionic,decay,
     >                rmain,epart_cutoff,cot,scalecof,
     >                supxex,f1dborder,f1dgamma,f2dborder,f2dgamma,
     >                thrlocx,throrbx,thrpipx,thrmltpx,chgmin,chgminh,
     >                rijkl_max,rkl_max,rkli_max,thrmp2,thrcor,
     >                weightpr,batchdiam,thrgapx,thrloctx,thrgaptx
      logical zeromat,zero1ext
      common/cparlocl/ zeromat,zero1ext
      common/crestloc/ ioffsave,ioffrest,fop_done
      parameter(mxdistpart=10)
      common/ceneparti/ ndist_part
      common/cenepartr/ dist_part(mxdistpart)
      dimension vall(nlocr),ivall(nloci)
      equivalence (savdom,vall(1))
      equivalence (locmeth,ivall(1))
      character(8) :: unitr,atom_list,atom_merge_list
      common/crangc/ unitr,atom_list(maxatm),
     >               atom_merge_list(maxmerge_list)
c... for singly external integrals
      common/cd1ex/ list1ex(mxvl,mxvl)
c... for local uccsd
      common/clucc/ iexdomp

cgh - pointers to arrays for least squares fit based multipole approx.
      common/fitmltp_mem/ivpos,impos,ipivpos,mappos,iw1dpos,ix1dpos,
     >                   iw2drpos,ix2drpos,iw2dppos,ix2dppos,
     >                   ippos,iqpos,iypos

cgh - workaround
      common/temp_common/multend,multstart,multstartint
c...
*   - pointers to auxiliary domains connected to 3ext/triples stuff
      common/triplist/ntrip,listrip_p,l3ext
      common/triplist_restart/ntrip_prev
      common/auxdoms/idom_tdl_str_p,idom_tdl_end_p,ntloct_p,
     &               idom_rtdl_str_p,idom_rtdl_end_p,
     &               idomt_str_p,idomt_end_p,
     &               idom_rsp_str_p,idom_rsp_end_p,
     &               idomr_str_p,idomr_end_p,
     &               idom_rtd2l_str_p,idom_rtd2l_end_p
*   - pointers to center pair domain domains for 4ext/dkext stuff
      common/pdcentres/i_size_PDcen,ip_idomap_str,ip_idomap_end,
     &                 ip_idomap
*   - pointers to center operator domain domains for new 3ext stuff
      common/odcentres/i_size_ODcen,ip_idomao_str,ip_idomao_end,
     &                 ip_idomao
*   - pointers to center 3ext domain domains for new 3ext stuff
      common/udcentres/i_size_3Dcen,
     &                 ip_idoma3_str,ip_idoma3_end,ip_idoma3,     ! 3ext domains
     &                 ip_idomaf_str,ip_idomaf_end,ip_idomaf      ! full domains
*   - pointers to center triple domain domains for new 3ext stuff
      common/tdcentres/i_size_TDcen,ip_idomat_str,ip_idomat_end,
     &                 ip_idomat
      common/cenplist/n_cenp,ip_listcen,ip_cenplst,
     &                ip_nCP4fCen,ip_iOffCP4fCen,
     &                n_cenp_q,ip_listcen_q,ip_cenplst_q,
     &                ip_nCP4fCen_q,ip_iOffCP4fCen_q
      common/mocenplist3x/len_mocenl3x,len_mocenpl3x,len_mocentl3x,
     &                ip_mocenlst3x,ip_lst3xmocen,
     &                ip_mocenplst3x,ip_lst3xmocenp,
     &                ip_mocentlst3x,ip_mooff_mocentlst3x
c...
CEnd
      !include "common/cexplicit"
*comdeck cexplicit $Revision: 2006.4 Patch(2006.4): ccf12_valeev2 lmp2_f12_cabs $
      integer hybrid,hybridx
      common/cexpliciti/npp_r12,                     !number of r12 pairs
     >                  ioff_orbdom_ri_r12,          !offset for resolution of the identity domains
     >                  ioff_orbdom_ao_r12,          !offset for AO orbital domains (for ansatz1)
     >                  ioff_orbdom_so_r12,          !offset for SO orbital domains (for ansatz2)
     >                  ioff_pairdom_ri_r12,         !offset for SO pair domains (for ansatz2)
     >                  ioff_pairdom_ao_r12,         !offset for AO pair domains (for ansatz1)
     >                  ioff_pairdom_so_r12,         !offset for SO pair domains (for ansatz2)
     >                  ioff_uniorbdom_ri_r12,       !offset for united ri-domains
     >                  ioff_uniorbdom_ao_r12,       !offset for united ao-domains (for ansatz1)
     >                  ioff_uniorbdom_so_r12,       !offset for united so-domains (for ansatz2)
     >                  ioff_uniorbdom_ao,           !offset for ao-domains (for Q1/Q2, currently full)
     >                  irec_ep_r12,ifil_ep_r12,     !record for storing pair energies
     >                  nij_f12,nkl_f12,             !number of f12 pairs and excitations
     >                  name_B,ifil_B,               !Record for B-matrix
     >                  name_C,ifil_C,               !Record for C-matrices
     >                  name_V,ifil_V,               !Record for V-matrix
     >                  name_X,ifil_X,               !Record for X-matrix
     >                  ideb_r12,                    !print parameter
     >                  ioff_Vdom,ioff_Bdom,ioff_Xdom,
     >                  name_J(10), name_F(10),
     >                  name_U(10),
     >                  ioffrec(10),
     >                  hybrid,hybridx,
     >                  name_Stil,name_Stil_A,
     >                  irec_AoCabs, irec_RiCabs,nCabs
      common/cexplicitr/emp2_r12,                    !mp2-r12 correlation energy
     >                  emp2_r12_sing,               !mp2-r12 singlet correlation energy
     >                  emp2_r12_trip,               !mp2-r12 triplet correlation energy
     >                  emp2_r12_strong,             !mp2-r12 correlation energy for strong pairs
     >                  emp2_r12_close,              !mp2-r12 correlation energy for close pairs
     >                  emp2_r12_weak,               !mp2-r12 correlation energy for weak pairs
     >                  emp2_r12_dist,               !mp2-r12 correlation energy for distant pairs
     >                  emp2_r12s,                   !mp2-r12/* correlation energy
     >                  emp2_r12s_sing,              !mp2-r12/* singlet correlation energy
     >                  emp2_r12s_trip,              !mp2-r12/* triplet correlation energy
     >                  emp2_r12s_strong,            !mp2-r12/* correlation energy for strong pairs
     >                  emp2_r12s_close,             !mp2-r12/* correlation energy for close pairs
     >                  emp2_r12s_weak,              !mp2-r12/* correlation energy for weak pairs
     >                  emp2_r12s_dist,              !mp2-r12/* correlation energy for distant pairs
     >                  emp2_r12sd,                  !mp2-r12/*(DX) correlation energy
     >                  emp2_r12sd_sing,             !mp2-r12/*(DX) singlet correlation energy
     >                  emp2_r12sd_trip,             !mp2-r12/*(DX) triplet correlation energy
     >                  emp2_r12sd_strong,           !mp2-r12/*(DX) correlation energy for strong pairs
     >                  emp2_r12sd_close,            !mp2-r12/*(DX) correlation energy for close pairs
     >                  emp2_r12sd_weak,             !mp2-r12/*(DX) correlation energy for weak pairs
     >                  emp2_r12sd_dist,             !mp2-r12/*(DX) correlation energy for distant pairs
     >                  ef12bts,ef12btt,             !fixc energy contributions of V*t+B*t^2 term
     >                  ef12cts,ef12ctt,             !fixc energy contributions of C*T*t term
     >                  ef12vts,ef12vtt,             !fixc energy contributions of V*T*t term
     >                  ef12singles                  !mp2 energy contribution
      parameter(len_emp2_f12=28)  !should be the number of entries in common/cexplicitr/
      dimension emp2_f12(len_emp2_f12)
      equivalence (emp2_f12(1),emp2_r12)
      logical do_r12,do_f12,nox,ebc,gbc,doc,diagonal,diagonalx
      logical noex,nofik,fockri,cabs,cabsp,cabsk,cabsf,ldmat,cabsa,cabsc
      logical ansatzA,ansatzB,ansatzC
      logical fockri_A,fockri_B,fockri_C,fockri_P
      logical exch_A,exch_B,exch_C,exch_P
      common/cexplicitl/ do_r12,                     !if true, explicit correlation calc (r12 or f12)
     >                   do_f12,                     !if true, f12 calculation
     >                   nox,                        !if true, neglect X
     >                   ebc,                        !if true, use EBC
     >                   gbc,                        !if true, use GBC
     >                   noex,                       !if true, neglect exchange
     >                   doc,                        !if true, use approximation C
     >                   diagonal,                   !if true, use diagonal approximation
     >                   fockri,                     !if true, use fockri for C
     >                   nofik,                      !if true, fik contributions are included in intermediate orbitals
     >                   cabsp,cabsk,cabsf,          !if true, use CABS for P, K, and F, respectively
     >                   ansatzA,ansatzB,ansatzC,
     >                   fockri_A,fockri_B,
     >                   fockri_C,fockri_P,
     >                   exch_A,exch_B,
     >                   exch_C,exch_P,
     >                   ldmat,cabsa,cabsc,
     >                   diagonalx                   !if true, use diagonal approximation for X
      character*64 ansatz,method,methodd,methods
      common/cexplicic/ ansatz,method,methodd,methods
      INTEGER, PARAMETER :: ifil_K   = 6           ! K-operator
      INTEGER, PARAMETER :: ifil_J   = 5           ! J-integrals
      INTEGER, PARAMETER :: ifil_F   = 6           ! R-integrals
      INTEGER, PARAMETER :: ifil_U   = 5           ! U-integrals
      INTEGER, PARAMETER :: ifil_FJ  = 6           ! FJ-integrals
      INTEGER, PARAMETER :: ifil_FT  = 5           ! FU-integrals
      INTEGER, PARAMETER :: ifil_FF  = 5           ! FF-integrals
      INTEGER, PARAMETER :: name_FJ   = 6400       ! FJ-integrals
      INTEGER, PARAMETER :: name_FT   = 6410       ! FU-integrals
      INTEGER, PARAMETER :: name_FF   = 6420       ! FF-integrals
      dimension listkl(2,nkl),listq(m,m),list(n)
      fullket=.true.
      if(ioff_pairdom.lt.0) then
        locket=.false.
c       write(iout,10) typ,n
10      format(' Using full domains for space ',a,'  m=',i4)
c... here for full domains
        ioff_pairdom=ioff_dom
        ioff_dom=ioff_dom+nkl
        ndom=ndom+1
        if(ndom.gt.mxdom) call error('mxdom too small','f12_integrals')
        idom_str(ndom)=1
        idom_end(ndom)=n
        do kl=1,nkl
          ipkl=ioff_pairdom+kl
          idomp_str(ipkl,1)=ndom
          idomp_end(ipkl,1)=ndom
          ntloc(ipkl,1)=n
          it2len(ipkl)=n*n
        end do
        ioff_uniorbdom=ioff_dom
        ioff_dom=ioff_dom+m
        do i=1,m
          ipi=ioff_uniorbdom+i
          idomp_str(ipi,1)=ndom
          idomp_end(ipi,1)=ndom
          ntloc(ipi,1)=n
          it2len(ipi)=n*n
        end do
        return
      end if
c
c... here if input domains are given
      locket=.true.
      call izero(list,n)
      call izero(listq,m*m)
      do kl=1,nkl
        k=listkl(1,kl)
        l=listkl(2,kl)
        listq(k,l)=kl
        listq(l,k)=kl
        if(k.gt.m.or.l.gt.m) call error('m too small','f12_uniorbdom')
      end do
      nmin=n
      nmax=0
      av=0
      ioff_uniorbdom=ioff_dom
      ioff_dom=ioff_dom+m
      do k=1,m
        imin=n
        imax=0
        ipk=ioff_uniorbdom+k
        idomp_str(ipk,1)=ndom+1
        idomp_end(ipk,1)=0
        do l=1,m
          if(listq(l,k).eq.0) cycle
          ipkl=ioff_pairdom+listq(l,k)
          if(ntloc(ipkl,1).lt.n) fullket=.false.
          if(ntloc(ipkl,1).gt.n) then
             write(6,'(/1x,3(a,i4))') 'ipkl=',ipkl,
     >        '  ntloc=',ntloc(ipkl,1),'  n=',n
             call error('inconsistent domain dimension','f12_unidom')
          end if
          do idom=idomp_str(ipkl,1),idomp_end(ipkl,1)
            do i=idom_str(idom),idom_end(idom)
              imin=min(imin,i)
              imax=max(imax,i)
              list(i)=1
            end do
          end do
        end do
        last=-1
        nd=0
        do i=imin,imax
          if(list(i).eq.0) cycle
          if(i.ne.last+1) then
            ndom=ndom+1
            if(ndom.gt.mxdom) call error('mxdom too small',
     >                                   'f12_unidom')
            idom_str(ndom)=i
          end if
          idom_end(ndom)=i
          list(i)=0
          last=i
          nd=nd+1
        end do
        ntloc(ipk,1)=nd
        it2len(ipk)=nd*nd
        idomp_end(ipk,1)=ndom
        nmin=min(nmin,nd)
        nmax=max(nmax,nd)
        av=av+nd
      end do
      nav=nint(av/m)
      if(debug) write(iout,20) typ,n,nmin,nmax,nav
20    format(' United orb domains for space ',a,'  m=',i4,
     >       6x,'min=',i4,'  max=',i4,'  aver=',i4)
      return
      end subroutine f12_unidom
c----------------------------------------------------------------------
      subroutine tranop_f12(op,typein,typeout,
     >                      orb1,nb1,ioffdom1,
     >                      orb2,nb2,ioffdom2,
     >                      ioffdom3,ioffdom4,
     >                      listkl,nkl,
     >                      irec_ab,ifil_ab,
     >                      irec,ifil,offrec,
     >                      q1,q2,q3,
     >                      cpu,flops,iadd,idone,icase,itrans)
c----------------------------------------------------------------------
      IMPLICIT DOUBLE PRECISION (a-h,o-z)
      character(len=*), intent(in)  :: typein,typeout,op
      double precision, intent(in)  :: orb1(*)       !left transformation matrix
      double precision, intent(in)  :: orb2(*)       !right transformation matrix
      double precision, intent(out) :: offrec(*)     !Record offsets for matrices
      integer, intent(in) :: nkl
      integer, intent(in) :: listkl(2,nkl)           !Operator list (triang)
      integer, intent(in) :: ioffdom1,ioffdom2,ioffdom3,ioffdom4
      integer, intent(in) :: irec,ifil,irec_ab,ifil_ab
      double precision    :: q1(*)
      double precision    :: q2(*)
      double precision    :: q3(*)
      !include "common/tapes"
!comdeck tapes $Revision: 2006.4 $
!.....inp:  molpro input file number
!.....iout: output file number
!.....ipun: punch file number
!.....inpc: standart input file number
!.....iprio: io print paramter
!.....ltap:  max number of records per file (set in blk1)
!.....logout: unit number of log file
!.....logfile: name of log file
!.....logopen: flag indicating whether log file is open
!.....lastout: output unit before last call to openlog
!.....npl(ifile):  logical file number for molpro file ifile
!.....nre(ifile):  number of calculation
!.....iwrite(ifile): if nonzero, file has been written since last tapsav
!.....int2ad(irec): address offsets for two electron integral symmetry blocks
!ftc if Molpro
      !include "common/mxrec"
! src/common/mxrec $Revision: 2006.4 $
      parameter (mxrec=200)
      integer, parameter :: mxfil=9
      logical :: ga_debug
      common/tapes/inp,iout,ipun,inpc,iprio,ltap,logout,logopen,lastout,&
     &             npl(mxfil),nre(mxfil),iwrite(mxfil),int2ad(51)
      common/ltapes/ga_debug
      equivalence (nein,inp),(naus,iout)
      character(255) :: logfile
      common/clogf/logfile
!ftc else
!ftc ;      common/tapes/iout
!ftc end
      !include "common/clocal"
*comdeck clocal $Revision: 2006.4 $
CStart Molpro
      !include "common/maxval_loc"
! src/common/maxval_loc $Revision: 2006.3 $
*comdeck maxval_loc
      parameter (mxvl= 300)
      !include "common/maxatm_loc"
! src/common/maxatm_loc $Revision: 2006.3 $
*comdeck maxatm_loc
      parameter (maxatm= 200)
      parameter (nloci=48,nlocr=44,maxmerge_list=maxatm)
c.....nloc(isym):       number of localized orbitals in symmetry isym
c.....xlcnt(imo), ylcnt(imo), zlcnt(imo): centers of charge for localized orbitals
      common/ccenter/ nloc(8),xlcnt(mxvl),ylcnt(mxvl),zlcnt(mxvl)
c
c.....ipaoc_str(maxatm,isym) 1st PAO of each center...
c.....ipaoc_end(maxatm,isym) last PAO of each center...
c.....npaoc(maxatm,isym)     number of PAOs on each center...
c.....npaocmx                max of all npaoc(,)
      common/cpaocen/ ipaoc_str(maxatm,8),ipaoc_end(maxatm,8),
     &                npaoc(maxatm,8),npaocmx
c
c.....ndoma:            number of primitive domains (= number of unique centers)
c.....ndomo:            number of domain blocks for valence orbitals
c.....ndomp:            number of domain blocks for pairs
c.....ndom:             total number of domain blocks
c.....idoma_str(imo):   pointer to first element of idoma for valence orbital imo
c.....idoma_end(imo):   pointer to last element of idoma for valence orbital imo
c.....idoma(idom):      z-matrix row numbers defining domains for valence orbitals (input)
c.....idomo_str(imo,isym):  pointer to first domain block of symmetry isym for orbital imo
c.....idomo_end(imo,isym):  pointer to last  domain block of symmetry isym for orbital imo
c.....idomp_str(ip,isym):   pointer to first domain block of symmetry isym for pair ip
c.....idomp_end(ip,isym):   pointer to last  domain block of symmetry isym for pair ip
c.....idomup_str(imo,isym): pointer to first domain block of symmetry isym for orbital imo
c.....idomup_end(imo,isym): pointer to last  domain block of symmetry isym for orbital imo
c........ idomup_ ...       unified domains for given imo, only strong and weak pairs)
c.....idom_str(idom):   first basis function (AO) for domain block idom in its symmetry
c.....idom_end(idom):   last  basis function (AO) for domain block idom in its symmetry
c.....ntloc(imo,isym):  number of orbitals per symmetry in the domains of given mo
c.....iwadr(ip,isym):   address of pseudo canonical transformation matrix for pair domain ip
c.....ivadr(ip,isym):   address of canonical->local transformation matrix for pair domain ip
c.....lenv,lenw:        total lengths of transformation matrices
c.....it2len(ip):       length of local pair matrix ip
c.....nstrong:          number of strong pairs
c.....npcls:            number of close pairs (included in nstrong)
c.....nweak:            number of weak pairs
c.....ndist:            number of distant pairs
c.....nvdist:           number of very distant pairs
c.....maxpdomsize       max over all pair domain sizes
c.....maxjdomsize       max over all jop domain sizes
c.....maxkdomsize       max over all kop domain sizes
c.....maxjedomsize      max over all J(E) domain sizes
c.....MaxL_KOp          max size of local K operator
c
c.....offsets in idomp lists (concerns idomp_str, idomp_end, ntloc, it2len).
c.....ioff_distdom: offset for orbital domains used in asymmetric distant pairs
c.....ioff_opjdom:  offset for j-operator domains: use idomp_str(ioff_jdom+iop,isym) etc
c.....              for J(Eij), K(Eij) use:  idomp_str(ioff_jdom+numop(i,j),isym)
c.....ioff_opkdom:  offset for j-operator domains: use idomp_str(ioff_kdom+iop,isym) etc
c.....ioff_up0dom:  offset for up domains for strong pairs: idomp_str(ioff_up0dom+ival,isym)
c.....ioff_up1dom:  offset for up domains for strong and weak pairs: idomp_str(ioff_up1dom+ival,isym)
c.....ioff_up2dom:  offset for up-domains for strong, ewak, and distant pairs: idomp_str(ioff_up2dom+ival,isym)
c.....ioff_opjup1dom: offset for up1 domains over joperator pair domains
c.....ioff_opkup1dom: offset for up1 domains over koperator pair domains
c.....ioff_utridom:   offset for united triple domains
c.....ioff_3extdom:   offset for domains for 3ext integrals
c.....ioff_relopjdom: offset for opj pair domains, rel. to 3ext domains...
c.....ioff_relpdom:   offset for (strong) pair domains, rel. to 3ext domains...
c.....ioff_intdom_lccsd:    offset for internal j-operator domains in lccsd
c.....ioff_fitdom_lccsd:    offset for fitting domains in lccsd
c.....ioff_1extdom_lccsd:   offset for 1-external domains in lccsd
c.....ioff_dom:       current offset in domain list idomp
c.....numopq(imo,jmo): numop (quadr.) for rel. pair domains...
c.....listpq(imo,jmo): listp (quadr.) for rel. pair domains...
c.....                 note: unlike numop numopq(imo,jmo).ne.numopq(jmo,imo) !!
c.....lmax:         largest pair domain size (strong+weak) in one symmetry
c.....lmax2:        largest pair matrix (strong+weak)
c
      parameter (mxpr=mxvl*(mxvl+1)/2)
      parameter (mxdomo=4*mxvl+8,mxdomp=8*mxpr+8,mxdom=mxdomo+mxdomp)
      common/cdomain/ ndom,
     >   ndoma,idoma_str(mxvl),idoma_end(mxvl),idoma(mxdomo),
     >   ndomo,idomo_str(0:8+mxvl,8),idomo_end(0:8+mxvl,8),
     >   ndomp,idomp_str(0:8+mxpr,8),idomp_end(0:8+mxpr,8),
     >   idom_str(mxdom),idom_end(mxdom),
     >   ntloc(0:mxpr,8),iwadr(mxpr,8),lenw,ivadr(mxpr,8),lenv,
     >   it2len(mxpr),nlt1,int1t(mxvl),nstrong,nweak,ndist,nvdist,
     >   ipdlm,isydlm,ndelp,eigdlm,eigmin,ipmin,isymin,natom_list,
     >   maxpdomsize,ioff_opjdom,ioff_opkdom,
     >   ioff_up0dom,ioff_up1dom,ioff_up2dom,lmax,lmax2,
     >   maxjdomsize,maxkdomsize,
     >   ioff_opjup1dom,ioff_opkup1dom,
     >   ioff_utridom,ioff_3extdom,ioff_relopjdom,ioff_relpdom,
     >   npcls,maxjedomsize,ioff_opjedom,ioff_opjupedom,MaxL_Kop,
     >   merge_list,merge_set,atom_merge_set(mxvl),
     >   idomoc_end(0:8+mxvl,8),idomow_end(0:8+mxvl,8),
     >   idomod_end(0:8+mxvl,8),
     >   iwoff(mxpr+2),ioff_distdom,
     >   ioff_mp2dom,ioff_dom,ioff_intdom_lccsd,ioff_1extdom_lccsd,
     >   ioff_fitdom_lccsd,npp_lccsd,npp_lccsd_res,list_canblk(mxvl),
     >   keepcls,maxtyp_r,maxtyp_t,ioff_totdom,nvalcc
      common/cnum_loc/ numopq(mxvl,mxvl),listpq(mxvl,mxvl)
c
c.....drange:   radius from center of charge of localitzed orbitals within which
c               basis functions are included
c.....unitr:    unit of drange (can be set to ANG; default AU)
c.....savdom:   record for saveing domain information
c.....restdom:  record for restarting domain information
c.....weakpair: distance criterion for weak pairs (treated by MP2)
c.....distpair: distance criterion for distant pairs (treated approximately by MP2)
c.....verydist: distance criterion for very distant pairs (neglected)
c.....
c.....skipdist: determines at which stage distant pairs are eliminated
c.....locsing:  if zero, singles are not treated locally (for testing only)
c.....chgfrac:  atoms are included in an orbital domain, if total charge is below chgfrac
c.....chgmin:   atoms are included in an orbital domain if abs Mulliken charge is larger than chgmin
c.....chgminh:  H-atoms are included in an orbital domain if abs Mulliken charge is larger than chgminh
c.....locmull:  parameter to determine method for calculating atomic charges
c.....locorb:   if nonzero, localize orbitals according to Pipek-Mezey scheme
c.....locao:    localize with AO criterion
c.....thrpip:   threshold for Pipek-Mezey
c.....savloc:   record to save local orbitals
c.....thrkcp:   threshold for neglecting small coefficients in cckext
c.....thrcor:   threshold for deleting core orbitals (default 0.1)
c.....idelcor:  parameter for deleting core basis functions
c.....jiterm:   parameter for deleting domain blocks (ji)
c.....maxl_dom: maxl+1 for selecting orbital domains (2 means include s,p functions)
c.....nonorm:   if nonzero, don't normalize projected functions (ibaso=1)
c.....idomonly: if nonzero, determine domains only
c.....itypecheck: check type of basis functions in redundancy check
c.....lmp2algo:  if nonzero, use low order scaling method in lmp2 iterations
c.....iopdom:    if nonzero, use operator domain approximation
c.....iprojocc:  if nonzero, project occupied orbitals
c.....iopdom_dtraf if nonzero, use operator domain approximation in dtraf/lccsd
c.....thrlocx, thrgapx, thrloctx, thrgaptx: dummies, values in cthr are used
cgh - idistmthd: choose method for multipole approximation
cgh - nmltp: level for multipole approximation of exchange integrals
cgh - ishortmlt: level for multipole correction / monopolar exp.
cgh - longmlt: level of multipole correction / bipolar exp.
cgh - idstmlt: level of distant pair multipole expansion
cgh - mltpalgo: determines details of multipole algorithm
cgh - irun: specifies run number for two pass split operator algorithm
cgh - icof: level of damping function for multipole operators
cgh - cot: cutoff (in bohr) for multipole operators
cgh - scalecof: scaling factor for this damping function
cgh - decay: decay parameter for split coulomb operator approach
cgh - rmain: threshold for switching from monopolar expansion to 4-block approach for strong/weak pairs multipole correction
cgh - rionic: threshold for switching from mono- to bipolar expansion for ionic cross excitations
c.....i_epart:       if nonzero, activates energy partitioning...
c.....epart_cutoff:  cutoff parameter for energy partitioning
c.....thrmp2 threshold for mp2 iterations
      integer skipdist
      common/cparloci/ locmeth,idlbas,idlmeth,skipdist,locsing,
     >                locmull,locorb,jiterm,locao,nonorm,
     >                idelcor,idlshl,itypecheck,maxl_dom,iselect,
     >                iprselect,iolddef,idomonly,i_epart,nmltp,
     >                idistmthd,ishortmlt,longmlt,mltpalgo,irun,
     >                idstmlt,icof,lmp2algo,iopdom,ifitmltp,
     >                if1dgrid,if2dgridr,if2dgridp,i3dweight,
     >                mergedom,iprojocc,iopdom_dtraf,monopole,
     >                multpage,numbatch,ibatchalgo,iranseed,ipet
      common/cparlocr/ savdom,restdom,savloc,drange,verydist,distpair,
     >                weakpair,chgfrac,cdelmin,rionic,decay,
     >                rmain,epart_cutoff,cot,scalecof,
     >                supxex,f1dborder,f1dgamma,f2dborder,f2dgamma,
     >                thrlocx,throrbx,thrpipx,thrmltpx,chgmin,chgminh,
     >                rijkl_max,rkl_max,rkli_max,thrmp2,thrcor,
     >                weightpr,batchdiam,thrgapx,thrloctx,thrgaptx
      logical zeromat,zero1ext
      common/cparlocl/ zeromat,zero1ext
      common/crestloc/ ioffsave,ioffrest,fop_done
      parameter(mxdistpart=10)
      common/ceneparti/ ndist_part
      common/cenepartr/ dist_part(mxdistpart)
      dimension vall(nlocr),ivall(nloci)
      equivalence (savdom,vall(1))
      equivalence (locmeth,ivall(1))
      character(8) :: unitr,atom_list,atom_merge_list
      common/crangc/ unitr,atom_list(maxatm),
     >               atom_merge_list(maxmerge_list)
c... for singly external integrals
      common/cd1ex/ list1ex(mxvl,mxvl)
c... for local uccsd
      common/clucc/ iexdomp

cgh - pointers to arrays for least squares fit based multipole approx.
      common/fitmltp_mem/ivpos,impos,ipivpos,mappos,iw1dpos,ix1dpos,
     >                   iw2drpos,ix2drpos,iw2dppos,ix2dppos,
     >                   ippos,iqpos,iypos

cgh - workaround
      common/temp_common/multend,multstart,multstartint
c...
*   - pointers to auxiliary domains connected to 3ext/triples stuff
      common/triplist/ntrip,listrip_p,l3ext
      common/triplist_restart/ntrip_prev
      common/auxdoms/idom_tdl_str_p,idom_tdl_end_p,ntloct_p,
     &               idom_rtdl_str_p,idom_rtdl_end_p,
     &               idomt_str_p,idomt_end_p,
     &               idom_rsp_str_p,idom_rsp_end_p,
     &               idomr_str_p,idomr_end_p,
     &               idom_rtd2l_str_p,idom_rtd2l_end_p
*   - pointers to center pair domain domains for 4ext/dkext stuff
      common/pdcentres/i_size_PDcen,ip_idomap_str,ip_idomap_end,
     &                 ip_idomap
*   - pointers to center operator domain domains for new 3ext stuff
      common/odcentres/i_size_ODcen,ip_idomao_str,ip_idomao_end,
     &                 ip_idomao
*   - pointers to center 3ext domain domains for new 3ext stuff
      common/udcentres/i_size_3Dcen,
     &                 ip_idoma3_str,ip_idoma3_end,ip_idoma3,     ! 3ext domains
     &                 ip_idomaf_str,ip_idomaf_end,ip_idomaf      ! full domains
*   - pointers to center triple domain domains for new 3ext stuff
      common/tdcentres/i_size_TDcen,ip_idomat_str,ip_idomat_end,
     &                 ip_idomat
      common/cenplist/n_cenp,ip_listcen,ip_cenplst,
     &                ip_nCP4fCen,ip_iOffCP4fCen,
     &                n_cenp_q,ip_listcen_q,ip_cenplst_q,
     &                ip_nCP4fCen_q,ip_iOffCP4fCen_q
      common/mocenplist3x/len_mocenl3x,len_mocenpl3x,len_mocentl3x,
     &                ip_mocenlst3x,ip_lst3xmocen,
     &                ip_mocenplst3x,ip_lst3xmocenp,
     &                ip_mocentlst3x,ip_mooff_mocentlst3x
c...
CEnd
      !include "common/cpfil"
*comdeck cpfil $Revision: 2006.0 $
c.....nwf:          record number for orbitals, file kopfil
c.....nfc,nfo:      record numbers for fc, fo, file jopfil
c.....nfk1:         offset record number for k-operators, ao, file 2
c.....nfj1:         offset record number for j-operators, ao, file 3
c.....nfko:         offset record number for k-operators, mo, file 2
c.....nfjo:         offset record number for j-operators, mo, file 3
c.....nfkp:         offset number for symmetrized k-operators, mo, file 3
c.....              (k(ij)+k(ij))/(1+delta(ij)) is stored
c.....nfkm:         offset number for antisymm. k-operators, mo, file 3
c.....lenj:         length of all j-operators on file
c.....lenk:         length of all k-operators om file
c.....iadjk:        if nonzero, operators are read with offsets iadjk*lenj
c.....              or iadjk*lenk (used in multi only)
c.....in ci:
c.....all internal integrals are at nfjo+nop+1, file jopfil
c.....singly external integrals are at nfjo+nop+2, file jopfil
c
c.....in multi:
c.....core fock matrix at nfjo+nop+1 file jopfil
c.....frozen core fock matrix at nfjo+nop+2, file jopfil
c.....g matrix at nfjo+nop+3
c.....f matrix at nfjo+nop+4
c
c.....operators iop are read as follows:
c
c     call cread(op,len,jopfil,nfjo+iop,next)
c     call cread(op,len,kopfil,nfko+iop,next)
c     next will initiate find for this record
c
c.....lenrec: record length for coupling coefficients
c.....lentrp: length of transformation matrix for pairs
c.....lencpy: length of all cp matrices (mo) on file
c.....lencpx: length of all cp matrices (ao) on file
c.....lencss: length of symmetry block of cs, rounded ltr
c.....ipfils: offsets for symmetry block of cs
c.....lencsy: sum of lencss
c.....lenii:  nii rounded up to multiple of lseg
c.....lenepp: length of pair denominator record
c.....lenkcp: length of internal-external part of k(cps)
c
c.....the following quantities are on file icfil:
c.....ndens:    1-particle density matrices
c.....nepp:   energy denominators for pairs
c.....ntrap:  transformation matrix for pairs
c.....nwfp:   intermediate orbitals for pairs
c.....nhii:   diagonal elements for internals
c.....nhss:   diagonal elements for singles
c.....nhpp:   p-space hamiltonian
c.....ngam:  record for <i|e(ij)|0> etc. used with ioptgm=1
c.....ncref: reference coefficients (1 record, length nref*nstatr)
c.....ngref: h|cref> (1 record, length nref*nstatr)
c.....nfpp: intermediate storage of operators fpp if paging is necessary
c
c.....record names for ci-coefficients etc.:
c.....ncp:  matrices cp in non-orthogonal basis (nstate records)
c.....ngp:  matrices gp in non-orthogonal basis (nstate records)
c.....ncpo: matrices cp in orthogonal basis (ndav records)
c.....ngpo: matrices gp in orthogonal basis (ndav records)
c.....      ngp, ngpo do not include internal contribution gpi
c.....ngpr: <p|h|ref>
c.....ngsr: <s|h|ref>
c.....ngpi: total gp in orthogonal basis
c.....ncps: matrices cp'=cp+cps in orthogonal basis (nstate records)
c.....ncpsint: matrices cp'=cp+cps in non-orthogonal basis (nstate records)
c.....nkcp: internal-external part of k(cp) (nstate records)
c.....nkcpint: internal-external part of k(cp) in non-orthogonal basis (nstate records)
c.....ncs:  vectors cs (ndav records)
c.....ngs:  vectors gs (ndav records)
c.....ngsi: vectors gs from cigsi (nstate records)
c.....ndcs: intermediate storage of dcs
c.....nci:  coefficients of internals (1 record, length nii*nstati)
c.....ngi:  external contributions to gi (ndav vectors)
c.....nprojr: internal ci projection vectors
c.....nkcpe: external-external part of k(cp) (only transition)
c.....all cp, cs, ci are on file icfil
c.....all gp, gs, gi, k(cp) are on file igfil
c
c.....pair matrices etc. in mo basis are written/read as follows:
c
c     call reserv(lencpy,icfil,ncp,0)  (before first write to ncp)
c     call sreibw(cp,len,ncp+istate,icfil,ipfil(ip))
c     call lesw(cp,len,ncp+istate,icfil,ipfil(ip))
c
c.....vectors [k(cp)](ai) with ipfilk(ip)
c
CStart Molpro
      common/opfil/ jopfil,kopfil,nwf,nfo,nfc,nfjo,nfko,nfj1,nfk1,
     >              nfkp,nfkm,iadrfj,iadrfk,lenj,lenk,iadrs(1)
      common/opkmpp/ iproc_kop(1)
      common/opjmpp/ iproc_jop(1)
      common/opjmppbo/ iproc_jop_bo(1)
      common/opjempp/ iproc_jeop(1)
      common/opofs/ iadjk,iadwri,iadrea,iofjf,iofkf
      common/cpfil/ icfil,igfil,lenrec,lencpx,lencpy,lencss(8),
     >              ipfils(8),lencsy,
     >              lenii,lentrp,lenepp,lenkcp,ipfil(1)
      common/cadrk/ ipfilk(1)
      common/cpnam/ nhii,nhss,nhpp,nepp,ncref,ngref,ntrap,ndens,ngam,
     >              nci,ngi,ncs,ngs,ncp,ncpo,ngp,ngpo,ngpi,ncps,nkcp,
     >              nfpp,nwfp,ngsi,ngpr,ngsr,namorb,ndcs,nprojr,nkcpe,
     >              namjk,ngo,ncpsint,nkcpint,nzp,nzs,nkzp,
     >              nzw1,nzw2,nzw3,nzw4,nzw5,nzw6,nzw7,nzw8,nzw9,nctij
c.... for ket functions
      common/cpfil1/icfil1,igfil1,lenc1x,lencp1,lenc1s(8),
     >              ipfi1s(8),lencs1,
     >              lentr1,lenkc1,ipfil1(1)
      common/cadrk1/ipfi1k(1)
      common/cpfil2/icfil2,igfil2,lenc2x,lencp2,lenc2s(8),
     >              ipfi2s(8),lencs2,
     >              lentr2,lenkc2
CElse
c;      common/cpfil/ icfil,igfil,lenrec,lencpx,lencpy,lencss(8),
c;     >              ipfils(8),lencsy,
c;     >              lenii,lentrp,lenepp,lenkcp,ipfil(mxpair)
c;      common/cpnam/ ncp
CEnd
      !include "common/copj"
! src/common/copj $Revision: 2006.3 $
*comdeck copj
c.....nop = number of operators = nval*(nval+1)/2
c.....nopjm: maximum number of operators in one symmetry
c.....nopj(isy): number of j-operators for given symmetry
c.....nopof(isy): offset operator number for given symmetry
c.....jop(1,iop): valence orbital number i for j(ij), k(ij)
c.....jop(2,iop): valence orbital number j for j(ij), k(ij)
c.....jop(3,iop): number of operator minus one in its symmerty
c.....jop(4,iop): symmetry of operator
CStart Molpro
      common/cjop/ nop,nopjm,nopj(8),nopof(9),
     >             maxop,jop(4,1)
CElse
c;      common/cjop/ nopj(8)
CEnd
      !include "common/corb"
!comdeck corb $Revision: 2002.10 $
      !include "common/corbdim"
! src/common/corbdim $Revision: 2006.3 $
!comdeck corbdim $ Revision: 2002.9 $
      !include "common/maxval"
!comdeck maxval $Revision: 2002.10 $
      parameter (maxval= 300)
!ftc if Molpro
!ftc start unix-i4 ibm
!ftc ;      integer, parameter :: mxval=maxval,mxact=16,mxclos=maxval
!ftc end
!ftc start univac
!ftc ;      integer, parameter :: mxval=maxval,mxact=18,mxclos=maxval
!ftc end
!ftc start cray eta unix-i8
      integer, parameter :: mxval=maxval,mxact=32,mxclos=maxval
!ftc end
!ftc else
!ftc ;      integer, parameter :: mxval=maxval
!ftc end
!.....nsk:          number of different orbital symmetries
!.....nskcp:        number of different product symmetries
!.....mult(is,js):  symmetry multiplication table.
!
!.....nocc:         total number of occupied orbitals
!.....ncore:        total number of core orbitals
!.....nclos:        total number of closed-shell orbitals in ref.
!.....nval:         total number of valence (correlated) orbitals
!.....nact:         total number of active orbitals in reference
!
!.....iocc(isy):    number of internal orbitals in symmetries
!.....icore(isy):   number of core orbitals in symmetries
!.....iclos(isy):   number of closed-shell+core orbitals in symmetries
!.....icloss(isy):  number of closed-shell orbitals in symmetries
!.....ival(isy):    number of valence orbitals in symmetries
!.....iact(isy):    number of active orbitals in symmetries
!
!.....isyval(iorb): symmetry of given valence orbital.
!.....iorbvl(lorb): absolute orbital number in symmetry for valence orb.
!.....iacval(iorb): number of active orbital for given valence orbital
!.....              iacval(iorb)=0: closed-shell orbital
!.....ivals(iorb):  number of absolute val. orb. iorb in its symmetry(1st=1)
!.....iofval(isy):  offsets of valence orbitals in symmetries
!.....ivastr(isy):  first valence orbital of given symmetry
!.....ivaend(isy):  last valence orbital of given symmetry
!.....ldval(isy):   lengths of triangular valence matrices of given symmetries
!.....lqval(isy):   lengths of square square matrices of given symmetries
!
!.....isyact(iorb): symmetry of given active orbital.
!.....ivalac(iorb): valence orbital number for given active orbital
!.....iofact(isy):  offsets of active orbitals in symmetries
!.....iacstr(isy):  first active orbital of given symmetry
!.....iacend(isy):  last active orbital of given symmetry
!.....ldact(isy):   lengths of triangular active matrices of given symmetries
!.....lqact(isy):   lengths of square active matrices of given symmetries
!.....iaaq(i,j):    square active-active matrix addressing
!.....iaad(i,j):    triangular ative-active active matrix addressing
!.....iccq(i,j):    square closed-closed matrix addressing
!.....iccd(i,j):    triangular closed-closed matrix addressing
!.....icaq(i,j):    square closed-active matrix addressing
!.....icad(i,j):    triangular closed-active matrix addressing
!.....iacq(i,j):    square active-closed matrix addressing
!.....iacd(i,j):    triangular active-closed matrix addressing
!.....ivvd(i,j):    square valence-valence matrix addressing
!
!.....isyclo(iorb): symmetry of given closed-shell orbital
!.....ivalcl(iorb): valence orbital number for given closed-shell orbital
!.....iclval(iorb): closed-shell orbital number for given valence orbital
!                   (zero if not closed-shell)
!.....iofclo(isy):  offsets of closed-shell orbitals in symmetries
!.....iclstr(isy):  first closed-shell orbital of given symmetry
!.....iclend(isy):  last closed-shell orbital of given symmetry
!.....ldclo(isy):   lengths of triangular closed-shell matrices
!.....lqclo(isy):   lengths of square closed-shell matrices
!.....ldacc(isy):   lengths of triangular active-closed matrices
!.....lqacc(isy):   lengths of square closed-active  matrices
!
!.....idoff(isy):   symmetry offsets for second order density
!.....idoffv(isy):  symmetry offsets for second order density, valence
!.....iqoff(isy):   symmetry offsets for third order density
!.....lend2:        length of second order density matrix
!.....lend2v:       length of second order density matrix, valence
!.....lend3(isyij): length of third order density matrix for given ij
!.....lend3m:       maximum of lend3(isy)
      common/cval/ nval,ival(8),iofval(9),ivastr(8),ivaend(8),          &
     &             ldval(8),lqval(8),                                   &
     &             isyval(mxval),iacval(mxval),iorbvl(mxval),           &
     &             listp(mxval,mxval),ivals(mxval),iclval(mxval)
      common/corb/ nocc,iocc(8)
!ftc if Molpro
      common/ccor/ ncore,icore(8)
      common/clos/ nclos,iclos(8),isyclo(mxclos),ivalcl(mxclos),        &
     &             icloss(8),iofclo(9),ldclo(8),lqclo(8),               &
     &             iclstr(8),iclend(8),iclosx(8)
      common/cact/ nact,iact(8),iofact(9),ldact(8),lqact(8),            &
     &             mult(8,8),isyact(mxact),iacstr(8),iacend(8),         &
     &             idoff(8),lend2,iqoff(8,8),lend3(8),lend3m,           &
     &             nsk,nskcp,ivalac(mxact)
!.....dimensions for cicon/cclist: if closed-shells kept, these dimensions
!.... are equal to nval/ival. If closed-shells are eliminated, they
!.....are equal to nact/iact
!.....pointers:  iactvc(ivcl): points to corresponding active orbital
!.....           ivalvc(ivcl): points to corresponding valence orbital
!.....           iclovc(ivcl): points to corresponding closed-shell orbital
      common/cvac/ nvac,ivac(8),iofvac(9),ivcstr(8),ivcend(8),          &
     &             isyvac(mxval),iactvc(mxval),ivalvc(mxval),           &
     &             iclovc(mxval),ldvac(8),lqvac(8),                     &
     &             ivacac(mxact)
      common/cnum/numop(mxval,mxval)
      common/caad/idoffv(8),lend2v,iaaq(mxact,mxact),iaad(mxact,mxact), &
     &            iccq(mxclos,mxclos),iccd(mxclos,mxclos),              &
     &            icaq(mxclos,mxact),iacq(mxact,mxclos),                &
     &            ldacc(8),lqacc(8),ivvd(mxval,mxval),                  &
     &            icad(mxclos,mxact),iacd(mxact,mxclos),                &
     &            ivvq(mxval,mxval)
!ftc else
!ftc ;      common/cact/ mult(8,8),nsk,nskcp
!ftc ;      common/caad/ivvd(mxval,mxval),ivvq(mxval,mxval)
!ftc end
!.....ntos(isym,iblock): block offsets for (n,occ) matrices
!.....ntogs(isym): total lengths of (n,occ) matrices
!.....noos(isym,iblock): block offsets for (occ,occ) matrices
!.....noogs(isym): total lengths of (occ,occ) matrices
!ftc if Molpro
      common/cobas/ ntos(8,8),ntogs(8),noos(8,8),noogs(8)
      common/cvbas/ ntvs(8,8),ntvgs(8),nvvs(8,8),nvvgs(8)
!ftc end
      !include "common/cbas"
! src/common/cbas $Revision: 2006.3 $
!comdeck cbas $ Revision: 2002.9 $
!.....nt(isy):  number of basis functions in symmetry
!.....nts(isy): offset for basis functions of given symmetry
!.....ntg:      total number of basis functions
!.....ntd(isy): block offsets in triangular matrices of symmetry 1
!.....ntdg:     total length of triangular matrix of symmetry 1
!.....ntq(isy): block offsets in square matrices of symmetry 1
!.....ntqg:     total length of square matrix of symmetry 1
!.....ntds(isy,iblock): block offsets in triangular matrices
!.....ntqs(isy,iblock): block offsets in square matrices
!.....ntdgs(isy): total length of triangular matrices
!.....ntqgs(isy): total length of square matrices
!.....ntdgc(isy): ntdgs(isy) rounded up to multiple of sector length
!.....ntqgc(isy): ntqgs(isy) rounded up to multiple of sector length
!
!.....all quantities with x: as above for full basis set
!.....all quantities with y: as above for external space
!.....all quantities with z: as above for open + virtual space
!.....(open shell perturbation and coupled cluster theory)
!...  y and z are reversed if the flag  irevyz is set!
!
!.....the block number is equal to the row (left) symmetry
!
      common/cbasci/ nt(8),ntb(8),nts(8),ntg,ntd(8),ntdg,ntq(8),ntqg,   &
     &         ntds(8,8),ntqs(8,8),ntdgs(8),ntqgs(8),                   &
     &         ntdgc(8),ntqgc(8),                                       &
     &         ntx(8),ntbx(8),ntsx(8),ntgx,ntdx(8),ntdgx,ntqx(8),ntqgx, &
     &         ntdsx(8,8),ntqsx(8,8),ntdgsx(8),ntqgsx(8),               &
     &         ntdgcx(8),ntqgcx(8),                                     &
     &         nty(8),ntby(8),ntsy(8),ntgy,ntdy(8),ntdgy,ntqy(8),ntqgy, &
     &         ntdsy(8,8),ntqsy(8,8),ntdgsy(8),ntqgsy(8),               &
     &         ntdgcy(8),ntqgcy(8),                                     &
     &         ntr
!ftc Start Molpro
      common/cbaso/                                                     &
     &         ntz(8),ntbz(8),ntsz(8),ntgz,ntdz(8),ntdgz,ntqz(8),ntqgz, &
     &         ntdsz(8,8),ntqsz(8,8),ntdgsz(8),ntqgsz(8),               &
     &         ntdgcz(8),ntqgcz(8),ntqsyz(8,8),ntqgsyz(8),ntqgcyz(8),   &
     &         ntqyz(8),ntqgyz,irevyz
!ftc End
      !include "common/cpair"
!comdeck cpair $Revision: 2006.4 $
!.....npair: number of pairs in list ipair per state
!.....npp: number of non redundant pairs
!.....nps: number of singlet pairs
!.....npt: number of triplet pairs
!.....npsym(isy,1): number of singlet pairs in symmetries
!.....npsym(isy,2): number of triplet pairs in symmetries
!.....nppsym(isy):  total number of pairs in symmetries
!.....ipair(1,ip): iorb
!.....ipair(2,ip): jorb
!.....ipair(3,ip): np
!.....ipair(4,ip): isyij
!.....ipair(5,ip): reference state (if zero, not present for this state)
!.....pnorm(ip):   normalization factors for pairs
!.....nblkp: number of pair transformation blocks
!.....iplist(irow):  pointer from row number to pair list
!.....ibldim(iblk):  block dimensions
!.....lentrs:       length of pair overlap matrix
!.....iplist(ip):   block number of pair ip
!.....jplist(ip):   number of pair ip in block
!ftc if Molpro
      common/cpair/ npair,npp,nps,npt,npsym(8,2),nppsym(8),npof(9),     &
     &              mxpair,ipair(5,1)
      common/cpnrm/ pnorm(1)
      common/cplis/ nblkp,iplist(1)
      common/cpibl/ lentrs,ibllst(1)
      common/cpjbl/ jbllst(1)
      common/cpdim/ ibldim(1)
      common/cpadr/ icadr(10)
      common/cgadr/ igadr(10)
!.....for ket functions
      common/cpair1/ npair1,npp1,nps1,npt1,npsym1(8,2),nppsy1(8),       &
     &               npof1(9),mxpai1,ipair1(5,1)
      common/cpnrm1/ pnorm1(1)
      common/cplis1/ nblkp1,iplis1(1)
      common/cpdim1/ ibldi1(1)
      common/cpair2/ npair2,npp2,nps2,npt2,npsym2(8,2),nppsy2(8),       &
     &               npof2(9),mxpai2
      common/cplis2/ nblkp2
!ftc else
!ftc ;      parameter (mxpair=mxval*mxval)
!ftc ;      common/cpair/ npair,npp,nps,npt,npsym(8,2),nppsym(8),npof(9),     &
!ftc ;     &              mxpar,ipair(5,mxpair)
!ftc end
      common/cmpp_pair/ iproc_pair(1)
      !include "common/cprint"
! src/common/cprint $Revision: 2006.3 $
!comdeck cprint
! iprint: local print options
! ipring: global print options
! note: this common defined explicitly in muinp1!
!ftc if Molpro
      parameter (nprc=24,nprt=50)
      common/cprint/ iprint(nprt)
      common/cpring/ ipring(nprc)
!ftc end
      !include "common/code"
! src/common/code $Revision: 2006.3 $
!comdeck code $ Revision: 2002.9 $
      integer data,basis,sm,ho,ho1,tegr,ekin,dip,dik,rs,wf              &
     &,codxtr,basinp
      common/code/data,basis,sm,ho,ho1,tegr(10),ekin,dip(3),dik,rs,wf(2)&
     &,codxtr(19),basinp
      character*8 string
      n=nt(1)
c
c... transform Kij
c
      t1=second()
      string=typein
      if(itrans.gt.0) then
        string(1:1)=typein(2:2)
        string(2:2)=typein(1:1)
      end if
      idone=1
      off_ab=0
      offset=0
      if(typeout(1:1).eq.string(1:1).and.
     >   typeout(2:2).ne.string(2:2)) then
        icase=1
      else if(typeout(2:2).eq.string(2:2).and.
     >        typeout(1:1).ne.string(1:1)) then
        icase=2
      else
        icase=3
      end if
      if(idone.eq.0) return
      do kl=1,nkl
        k=listkl(1,kl)
        l=listkl(2,kl)
        ipkl1=ioffdom1+kl
        ipkl2=ioffdom2+kl
        ipkl3=ioffdom3+kl
        ipkl4=ioffdom4+kl
        ni=ntloc(ipkl1,1)
        nj=ntloc(ipkl2,1)
        na=ntloc(ipkl3,1)
        nb=ntloc(ipkl4,1)
        offrec(kl)=offset
        lkdone=0
        if(itrans.le.0) then
          nn1=1
          nn2=na
        else
          nn1=nb
          nn2=1
        end if
10      if(itrans.le.0.or.k.eq.l) then
          call readm_big(q1,na*nb,ifil_ab,irec_ab,off_ab,string)
          off_ab=off_ab+dble(na*nb)
        else
          if(lkdone.eq.0) then
            off=off_ab+dble(na*nb)
            off_ab=off_ab+dble(na*nb)
          else
            off=off_ab-dble(na*nb)
            off_ab=off_ab+dble(na*nb)
          end if
          call readm_big(q1,na*nb,ifil_ab,irec_ab,off,string)
        end if
20      if(iadd.ne.0) call readm_big(q3,ni*nj,ifil,irec,offset,string)
        if(icase.eq.1) then
          if(na.ne.ni) then
             write(6,*) 'na=',na,'  nb=',nb,'  ni=',ni,'  nj=',nj
             call error('na.ne.ni','tranop_f12')
          end if
          if(iadd.eq.1) then
            call mxmb (q1,nn1,nn2, orb2,1,nb2, q3,1,na, na,nb,nj)
          else if(iadd.eq.-1) then
            call mxmbn(q1,nn1,nn2, orb2,1,nb2, q3,1,na, na,nb,nj)
          else if(iadd.ne.0) then
            call mxma (q1,nn1,nn2, orb2,1,nb2, q2,1,na, na,nb,nj)
            call daxpy(na*nj,dble(iadd),q2,1,q3,1)
          else
            call mxma (q1,nn1,nn2, orb2,1,nb2, q3,1,na, na,nb,nj)
          end if
          call writem_big(q3,na*nj,ifil,irec,offset,op//typeout(1:2))
          offset=offset+dble(na*nj)
          flops=flops+dble(na*nb*nj)
          if(k.ne.l.and.lkdone.eq.0) then
            lkdone=1
            if(typein(1:1).ne.typein(2:2)) goto 10
            if(itrans.le.0) then
              nn1=na
              nn2=1
            else
              nn1=1
              nn2=nb
            end if
            goto 20
          end if
        else if(icase.eq.2) then
          if(nb.ne.nj) then
             write(6,*) 'na=',na,'  nb=',nb,'  ni=',ni,'  nj=',nj
             call error('nb.ne.nj','tranop_f12')
          end if
          if(iadd.eq.1) then
            call mxmb (orb1,nb1,1,q1,nn1,nn2, q3,1,ni, ni,na,nb)
          else if(iadd.eq.-1) then
            call mxmbn(orb1,nb1,1,q1,nn1,nn2, q3,1,ni, ni,na,nb)
          else if(iadd.ne.0) then
            call mxma (orb1,nb1,1,q1,nn1,nn2, q2,1,ni, ni,na,nb)
            call daxpy(ni*nb,dble(iadd),q2,1,q3,1)
          else
            call mxma (orb1,nb1,1,q1,nn1,nn2, q3,1,ni, ni,na,nb)
          end if
          call writem_big(q3,ni*nb,ifil,irec,offset,op//typeout(1:2))
          offset=offset+dble(ni*nb)
          flops=flops+dble(na*nb*ni)
          if(k.ne.l.and.lkdone.eq.0) then
            lkdone=1
            if(typein(1:1).ne.typein(2:2)) goto 10
            if(itrans.le.0) then
              nn1=na
              nn2=1
            else
              nn1=1
              nn2=nb
            end if
            goto 20
          end if
        else
          flop1=na*nb*nj+ni*na*nj
          flop2=ni*na*nb+ni*nb*nj
          if(flop1.le.flop2) then
            call mxma (q1,nn1,nn2, orb2,1,nb2, q2,1,na, na,nb,nj)
            if(iadd.eq.1) then
              call mxmb (orb1,nb1,1, q2,1,na, q3,1,ni, ni,na,nj)
            else if(iadd.eq.-1) then
              call mxmbn(orb1,nb1,1, q2,1,na, q3,1,ni, ni,na,nj)
            else
              call mxma (orb1,nb1,1, q2,1,na, q3,1,ni, ni,na,nj)
            end if
            flops=flops+flop1
          else
            call mxma(orb1,nb1,1, q1,nn1,nn2, q2,1,ni, ni,na,nb)
            if(iadd.eq.1) then
              call mxmb (q2,1,ni, orb2,1,nb2, q3,1,ni, ni,nb,nj)
            else if(iadd.eq.-1) then
              call mxmbn(q2,1,ni, orb2,1,nb2, q3,1,ni, ni,nb,nj)
            else
              call mxma (q2,1,ni, orb2,1,nb2, q3,1,ni, ni,nb,nj)
            end if
            flops=flops+flop2
          end if
          if(irec.le.0) then
            if(irec.eq.0) then
              nrc=nfko+numop(k,l)
            else
              nrc=abs(irec)+numop(k,l)
            end if
            call cwrite(q3,ni*nj,ifil,nrc,0)
          else
            call writem_big(q3,ni*nj,ifil,irec,offset,op//typeout(1:2))
          end if
          offset=offset+dble(ni*nj)
          if(k.ne.l.and.lkdone.eq.0) then
            lkdone=1
            if(typein(1:1).ne.typein(2:2)) then
              if(typeout(1:1).eq.typeout(2:2)) then
                off_ab=off_ab+dble(na*nb)
              else
                goto 10
              end if
            else if(typeout(1:1).ne.typeout(2:2)) then
              if(itrans.le.0) then
                nn1=na
                nn2=1
              else
                nn1=1
                nn2=nb
              end if
              goto 20
            end if
          end if
        end if
      end do
      offrec(nkl+1)=offset
      cpu=cpu+second()-t1
      return
      end subroutine tranop_f12
c-----------------------------------------------------------------------
      subroutine df_fit_f12(X,Xloc,ipiv,locfit,
     >                      listmo,norb,nfit,
     >                      ioff_uniorbdom,
     >                      ioff_fitdom,ioff_unifitdom,
     >                      name_j,name_jbar,
     >                      ifil_j,ifil_jbar,
     >                      mats,type,
     >                      cpu_fit,flops_fit,
     >                      disktr2,nrecout)
c-----------------------------------------------------------------------
      implicit double precision (a-h,o-z)
      character*(*) mats,type
      character*8 str
      logical robust
      !include "common/zahl"
! src/common/zahl $Revision: 2006.3 Patch(2006.4): common_zahl $
      common/zahl/ z0,z1,z2,z4,z05,z10h6,z10hm8,z10m12
      !include "common/clseg"
*comdeck clseg $Revision: 2006.3 Patch(2006.4): common_clseg $
c.....lseg:   disc sector length in real*8 words
c.....intrel: number of integers per real*8
c.....maximum_integer : maximum integer value
c.....ivect:  0=scalar, 1=vector machine
c.....minvec: minimum vector length for call to mxmb
c.....ibank:  number of memory banks
c.....ltrack: number of real*8 words per track
c.....ltr:    either lseg or 1, used for operator offsets on file
c.....ncpus:  maximum number of cpus to be used in multitasking
c.....nobuff: if not 0, disable system buffering
c.....iasyn:  if not 0, enable asynchronous i/o
c.....ncache: machine cache size in bytes
c.....mxmblk: column/row block size for mxma
c.....mxmbln: link block size for mxma
c.....mxmblk_dkext: column block size for mxma in dkext
c.....minbr1:  min number of floating point ops per processor
c.....mxdump:  max number of dump files with full functionality
c.....nroll:   3: use mxm3, 4: use mxm4 for matrix multiplications
c.....noblas:  if nonzero, do not use dgemm
c.....mindgm:  minimum matrix dimension for call to dgemm
c.....mindgr:  minimum value of nrow for call to dgemm
c.....mindgc:  minimum value of ncol for call to dgemm
c.....mindgl:  minimum value of nlink for call to dgemm
c.....mindgv:  minimum matrix dimension for call to dgemv
c.....mflopdgm: MFLOP rate for dgemm
c.....mflopdgv: MFLOP rate for dgemv
c.....mflopmxm: MFLOP rate for mxva
c.....mflopmxv: MFLOP rate for mxva
c.....mpplat:   Latency for mxma_mpp in microseconds
c.....mppspeed: bandwidth for for mxma_mpp in MB/sec
c.....use_olddiag2: if nonzero, use old diag2 routine
c
c... must declare all integers here to avoid errors with blas4
CStart Molpro
cstart unix-i8
      INTEGER, PARAMETER :: maximum_integer=9223372036854775807
celse
c;      INTEGER, PARAMETER :: maximum_integer=2147483647
cend
      integer lseg,intrel,ivect,minvec,ibank,ltrack,ltr,ncpus,
     1   nobuff,iasyn,ncache,mxmblk,mxmbln,minbr1,nchunk1,ibank_save,
     2   mxmblk_dkext,mxdmp,nroll,noblas,mindgm,mindgv,mindgl,mindgr,
     3   mindgc,mindgf,mflopdgm,mflopdgv,mflopmxm,mflopmxv,mpplat,
     4   mppspeed,mxmalat,use_olddiag2,mindgm2
      common/clseg/ lseg,intrel,ivect,minvec,ibank,ltrack,ltr,ncpus,
     1   nobuff,iasyn,ncache,mxmblk,mxmbln,minbr1,nchunk1,ibank_save,
     2   mxmblk_dkext,mxdmp,nroll,noblas,mindgm,mindgv,mindgl,mindgr,
     3   mindgc,mindgf,mflopdgm,mflopdgv,mflopmxm,mflopmxv,mpplat,
     4   mppspeed,mxmalat,use_olddiag2,mindgm2
CElse
c;      common/clseg/ lseg,intrel,ltrack
CEnd
      !include "common/tapes"
!comdeck tapes $Revision: 2006.4 $
!.....inp:  molpro input file number
!.....iout: output file number
!.....ipun: punch file number
!.....inpc: standart input file number
!.....iprio: io print paramter
!.....ltap:  max number of records per file (set in blk1)
!.....logout: unit number of log file
!.....logfile: name of log file
!.....logopen: flag indicating whether log file is open
!.....lastout: output unit before last call to openlog
!.....npl(ifile):  logical file number for molpro file ifile
!.....nre(ifile):  number of calculation
!.....iwrite(ifile): if nonzero, file has been written since last tapsav
!.....int2ad(irec): address offsets for two electron integral symmetry blocks
!ftc if Molpro
      !include "common/mxrec"
! src/common/mxrec $Revision: 2006.4 $
      parameter (mxrec=200)
      integer, parameter :: mxfil=9
      logical :: ga_debug
      common/tapes/inp,iout,ipun,inpc,iprio,ltap,logout,logopen,lastout,&
     &             npl(mxfil),nre(mxfil),iwrite(mxfil),int2ad(51)
      common/ltapes/ga_debug
      equivalence (nein,inp),(naus,iout)
      character(255) :: logfile
      common/clogf/logfile
!ftc else
!ftc ;      common/tapes/iout
!ftc end
      !include "common/cprint"
! src/common/cprint $Revision: 2006.3 $
!comdeck cprint
! iprint: local print options
! ipring: global print options
! note: this common defined explicitly in muinp1!
!ftc if Molpro
      parameter (nprc=24,nprt=50)
      common/cprint/ iprint(nprt)
      common/cpring/ ipring(nprc)
!ftc end
      !include "common/clocal"
*comdeck clocal $Revision: 2006.4 $
CStart Molpro
      !include "common/maxval_loc"
! src/common/maxval_loc $Revision: 2006.3 $
*comdeck maxval_loc
      parameter (mxvl= 300)
      !include "common/maxatm_loc"
! src/common/maxatm_loc $Revision: 2006.3 $
*comdeck maxatm_loc
      parameter (maxatm= 200)
      parameter (nloci=48,nlocr=44,maxmerge_list=maxatm)
c.....nloc(isym):       number of localized orbitals in symmetry isym
c.....xlcnt(imo), ylcnt(imo), zlcnt(imo): centers of charge for localized orbitals
      common/ccenter/ nloc(8),xlcnt(mxvl),ylcnt(mxvl),zlcnt(mxvl)
c
c.....ipaoc_str(maxatm,isym) 1st PAO of each center...
c.....ipaoc_end(maxatm,isym) last PAO of each center...
c.....npaoc(maxatm,isym)     number of PAOs on each center...
c.....npaocmx                max of all npaoc(,)
      common/cpaocen/ ipaoc_str(maxatm,8),ipaoc_end(maxatm,8),
     &                npaoc(maxatm,8),npaocmx
c
c.....ndoma:            number of primitive domains (= number of unique centers)
c.....ndomo:            number of domain blocks for valence orbitals
c.....ndomp:            number of domain blocks for pairs
c.....ndom:             total number of domain blocks
c.....idoma_str(imo):   pointer to first element of idoma for valence orbital imo
c.....idoma_end(imo):   pointer to last element of idoma for valence orbital imo
c.....idoma(idom):      z-matrix row numbers defining domains for valence orbitals (input)
c.....idomo_str(imo,isym):  pointer to first domain block of symmetry isym for orbital imo
c.....idomo_end(imo,isym):  pointer to last  domain block of symmetry isym for orbital imo
c.....idomp_str(ip,isym):   pointer to first domain block of symmetry isym for pair ip
c.....idomp_end(ip,isym):   pointer to last  domain block of symmetry isym for pair ip
c.....idomup_str(imo,isym): pointer to first domain block of symmetry isym for orbital imo
c.....idomup_end(imo,isym): pointer to last  domain block of symmetry isym for orbital imo
c........ idomup_ ...       unified domains for given imo, only strong and weak pairs)
c.....idom_str(idom):   first basis function (AO) for domain block idom in its symmetry
c.....idom_end(idom):   last  basis function (AO) for domain block idom in its symmetry
c.....ntloc(imo,isym):  number of orbitals per symmetry in the domains of given mo
c.....iwadr(ip,isym):   address of pseudo canonical transformation matrix for pair domain ip
c.....ivadr(ip,isym):   address of canonical->local transformation matrix for pair domain ip
c.....lenv,lenw:        total lengths of transformation matrices
c.....it2len(ip):       length of local pair matrix ip
c.....nstrong:          number of strong pairs
c.....npcls:            number of close pairs (included in nstrong)
c.....nweak:            number of weak pairs
c.....ndist:            number of distant pairs
c.....nvdist:           number of very distant pairs
c.....maxpdomsize       max over all pair domain sizes
c.....maxjdomsize       max over all jop domain sizes
c.....maxkdomsize       max over all kop domain sizes
c.....maxjedomsize      max over all J(E) domain sizes
c.....MaxL_KOp          max size of local K operator
c
c.....offsets in idomp lists (concerns idomp_str, idomp_end, ntloc, it2len).
c.....ioff_distdom: offset for orbital domains used in asymmetric distant pairs
c.....ioff_opjdom:  offset for j-operator domains: use idomp_str(ioff_jdom+iop,isym) etc
c.....              for J(Eij), K(Eij) use:  idomp_str(ioff_jdom+numop(i,j),isym)
c.....ioff_opkdom:  offset for j-operator domains: use idomp_str(ioff_kdom+iop,isym) etc
c.....ioff_up0dom:  offset for up domains for strong pairs: idomp_str(ioff_up0dom+ival,isym)
c.....ioff_up1dom:  offset for up domains for strong and weak pairs: idomp_str(ioff_up1dom+ival,isym)
c.....ioff_up2dom:  offset for up-domains for strong, ewak, and distant pairs: idomp_str(ioff_up2dom+ival,isym)
c.....ioff_opjup1dom: offset for up1 domains over joperator pair domains
c.....ioff_opkup1dom: offset for up1 domains over koperator pair domains
c.....ioff_utridom:   offset for united triple domains
c.....ioff_3extdom:   offset for domains for 3ext integrals
c.....ioff_relopjdom: offset for opj pair domains, rel. to 3ext domains...
c.....ioff_relpdom:   offset for (strong) pair domains, rel. to 3ext domains...
c.....ioff_intdom_lccsd:    offset for internal j-operator domains in lccsd
c.....ioff_fitdom_lccsd:    offset for fitting domains in lccsd
c.....ioff_1extdom_lccsd:   offset for 1-external domains in lccsd
c.....ioff_dom:       current offset in domain list idomp
c.....numopq(imo,jmo): numop (quadr.) for rel. pair domains...
c.....listpq(imo,jmo): listp (quadr.) for rel. pair domains...
c.....                 note: unlike numop numopq(imo,jmo).ne.numopq(jmo,imo) !!
c.....lmax:         largest pair domain size (strong+weak) in one symmetry
c.....lmax2:        largest pair matrix (strong+weak)
c
      parameter (mxpr=mxvl*(mxvl+1)/2)
      parameter (mxdomo=4*mxvl+8,mxdomp=8*mxpr+8,mxdom=mxdomo+mxdomp)
      common/cdomain/ ndom,
     >   ndoma,idoma_str(mxvl),idoma_end(mxvl),idoma(mxdomo),
     >   ndomo,idomo_str(0:8+mxvl,8),idomo_end(0:8+mxvl,8),
     >   ndomp,idomp_str(0:8+mxpr,8),idomp_end(0:8+mxpr,8),
     >   idom_str(mxdom),idom_end(mxdom),
     >   ntloc(0:mxpr,8),iwadr(mxpr,8),lenw,ivadr(mxpr,8),lenv,
     >   it2len(mxpr),nlt1,int1t(mxvl),nstrong,nweak,ndist,nvdist,
     >   ipdlm,isydlm,ndelp,eigdlm,eigmin,ipmin,isymin,natom_list,
     >   maxpdomsize,ioff_opjdom,ioff_opkdom,
     >   ioff_up0dom,ioff_up1dom,ioff_up2dom,lmax,lmax2,
     >   maxjdomsize,maxkdomsize,
     >   ioff_opjup1dom,ioff_opkup1dom,
     >   ioff_utridom,ioff_3extdom,ioff_relopjdom,ioff_relpdom,
     >   npcls,maxjedomsize,ioff_opjedom,ioff_opjupedom,MaxL_Kop,
     >   merge_list,merge_set,atom_merge_set(mxvl),
     >   idomoc_end(0:8+mxvl,8),idomow_end(0:8+mxvl,8),
     >   idomod_end(0:8+mxvl,8),
     >   iwoff(mxpr+2),ioff_distdom,
     >   ioff_mp2dom,ioff_dom,ioff_intdom_lccsd,ioff_1extdom_lccsd,
     >   ioff_fitdom_lccsd,npp_lccsd,npp_lccsd_res,list_canblk(mxvl),
     >   keepcls,maxtyp_r,maxtyp_t,ioff_totdom,nvalcc
      common/cnum_loc/ numopq(mxvl,mxvl),listpq(mxvl,mxvl)
c
c.....drange:   radius from center of charge of localitzed orbitals within which
c               basis functions are included
c.....unitr:    unit of drange (can be set to ANG; default AU)
c.....savdom:   record for saveing domain information
c.....restdom:  record for restarting domain information
c.....weakpair: distance criterion for weak pairs (treated by MP2)
c.....distpair: distance criterion for distant pairs (treated approximately by MP2)
c.....verydist: distance criterion for very distant pairs (neglected)
c.....
c.....skipdist: determines at which stage distant pairs are eliminated
c.....locsing:  if zero, singles are not treated locally (for testing only)
c.....chgfrac:  atoms are included in an orbital domain, if total charge is below chgfrac
c.....chgmin:   atoms are included in an orbital domain if abs Mulliken charge is larger than chgmin
c.....chgminh:  H-atoms are included in an orbital domain if abs Mulliken charge is larger than chgminh
c.....locmull:  parameter to determine method for calculating atomic charges
c.....locorb:   if nonzero, localize orbitals according to Pipek-Mezey scheme
c.....locao:    localize with AO criterion
c.....thrpip:   threshold for Pipek-Mezey
c.....savloc:   record to save local orbitals
c.....thrkcp:   threshold for neglecting small coefficients in cckext
c.....thrcor:   threshold for deleting core orbitals (default 0.1)
c.....idelcor:  parameter for deleting core basis functions
c.....jiterm:   parameter for deleting domain blocks (ji)
c.....maxl_dom: maxl+1 for selecting orbital domains (2 means include s,p functions)
c.....nonorm:   if nonzero, don't normalize projected functions (ibaso=1)
c.....idomonly: if nonzero, determine domains only
c.....itypecheck: check type of basis functions in redundancy check
c.....lmp2algo:  if nonzero, use low order scaling method in lmp2 iterations
c.....iopdom:    if nonzero, use operator domain approximation
c.....iprojocc:  if nonzero, project occupied orbitals
c.....iopdom_dtraf if nonzero, use operator domain approximation in dtraf/lccsd
c.....thrlocx, thrgapx, thrloctx, thrgaptx: dummies, values in cthr are used
cgh - idistmthd: choose method for multipole approximation
cgh - nmltp: level for multipole approximation of exchange integrals
cgh - ishortmlt: level for multipole correction / monopolar exp.
cgh - longmlt: level of multipole correction / bipolar exp.
cgh - idstmlt: level of distant pair multipole expansion
cgh - mltpalgo: determines details of multipole algorithm
cgh - irun: specifies run number for two pass split operator algorithm
cgh - icof: level of damping function for multipole operators
cgh - cot: cutoff (in bohr) for multipole operators
cgh - scalecof: scaling factor for this damping function
cgh - decay: decay parameter for split coulomb operator approach
cgh - rmain: threshold for switching from monopolar expansion to 4-block approach for strong/weak pairs multipole correction
cgh - rionic: threshold for switching from mono- to bipolar expansion for ionic cross excitations
c.....i_epart:       if nonzero, activates energy partitioning...
c.....epart_cutoff:  cutoff parameter for energy partitioning
c.....thrmp2 threshold for mp2 iterations
      integer skipdist
      common/cparloci/ locmeth,idlbas,idlmeth,skipdist,locsing,
     >                locmull,locorb,jiterm,locao,nonorm,
     >                idelcor,idlshl,itypecheck,maxl_dom,iselect,
     >                iprselect,iolddef,idomonly,i_epart,nmltp,
     >                idistmthd,ishortmlt,longmlt,mltpalgo,irun,
     >                idstmlt,icof,lmp2algo,iopdom,ifitmltp,
     >                if1dgrid,if2dgridr,if2dgridp,i3dweight,
     >                mergedom,iprojocc,iopdom_dtraf,monopole,
     >                multpage,numbatch,ibatchalgo,iranseed,ipet
      common/cparlocr/ savdom,restdom,savloc,drange,verydist,distpair,
     >                weakpair,chgfrac,cdelmin,rionic,decay,
     >                rmain,epart_cutoff,cot,scalecof,
     >                supxex,f1dborder,f1dgamma,f2dborder,f2dgamma,
     >                thrlocx,throrbx,thrpipx,thrmltpx,chgmin,chgminh,
     >                rijkl_max,rkl_max,rkli_max,thrmp2,thrcor,
     >                weightpr,batchdiam,thrgapx,thrloctx,thrgaptx
      logical zeromat,zero1ext
      common/cparlocl/ zeromat,zero1ext
      common/crestloc/ ioffsave,ioffrest,fop_done
      parameter(mxdistpart=10)
      common/ceneparti/ ndist_part
      common/cenepartr/ dist_part(mxdistpart)
      dimension vall(nlocr),ivall(nloci)
      equivalence (savdom,vall(1))
      equivalence (locmeth,ivall(1))
      character(8) :: unitr,atom_list,atom_merge_list
      common/crangc/ unitr,atom_list(maxatm),
     >               atom_merge_list(maxmerge_list)
c... for singly external integrals
      common/cd1ex/ list1ex(mxvl,mxvl)
c... for local uccsd
      common/clucc/ iexdomp

cgh - pointers to arrays for least squares fit based multipole approx.
      common/fitmltp_mem/ivpos,impos,ipivpos,mappos,iw1dpos,ix1dpos,
     >                   iw2drpos,ix2drpos,iw2dppos,ix2dppos,
     >                   ippos,iqpos,iypos

cgh - workaround
      common/temp_common/multend,multstart,multstartint
c...
*   - pointers to auxiliary domains connected to 3ext/triples stuff
      common/triplist/ntrip,listrip_p,l3ext
      common/triplist_restart/ntrip_prev
      common/auxdoms/idom_tdl_str_p,idom_tdl_end_p,ntloct_p,
     &               idom_rtdl_str_p,idom_rtdl_end_p,
     &               idomt_str_p,idomt_end_p,
     &               idom_rsp_str_p,idom_rsp_end_p,
     &               idomr_str_p,idomr_end_p,
     &               idom_rtd2l_str_p,idom_rtd2l_end_p
*   - pointers to center pair domain domains for 4ext/dkext stuff
      common/pdcentres/i_size_PDcen,ip_idomap_str,ip_idomap_end,
     &                 ip_idomap
*   - pointers to center operator domain domains for new 3ext stuff
      common/odcentres/i_size_ODcen,ip_idomao_str,ip_idomao_end,
     &                 ip_idomao
*   - pointers to center 3ext domain domains for new 3ext stuff
      common/udcentres/i_size_3Dcen,
     &                 ip_idoma3_str,ip_idoma3_end,ip_idoma3,     ! 3ext domains
     &                 ip_idomaf_str,ip_idomaf_end,ip_idomaf      ! full domains
*   - pointers to center triple domain domains for new 3ext stuff
      common/tdcentres/i_size_TDcen,ip_idomat_str,ip_idomat_end,
     &                 ip_idomat
      common/cenplist/n_cenp,ip_listcen,ip_cenplst,
     &                ip_nCP4fCen,ip_iOffCP4fCen,
     &                n_cenp_q,ip_listcen_q,ip_cenplst_q,
     &                ip_nCP4fCen_q,ip_iOffCP4fCen_q
      common/mocenplist3x/len_mocenl3x,len_mocenpl3x,len_mocentl3x,
     &                ip_mocenlst3x,ip_lst3xmocen,
     &                ip_mocenplst3x,ip_lst3xmocenp,
     &                ip_mocentlst3x,ip_mooff_mocentlst3x
c...
CEnd
      !include "common/big"
!comdeck big $Revision: 2002.10 $
      common /big/ q(2)
      integer iq(2)
      equivalence (q(1),iq(1))
      dimension X(*),Xloc(*),ipiv(*),listmo(norb)
c
c... computes fitting coefficients for lmp2-r12 theories
c
c     Jbar(A,ai) = J(A,B)^{-1} J(B,ai)
c
c...  a   in ioff_uniorbdom_ao
c...  A,B in ioff_unifitdom
c
c...  if (locfit.eq.0) Xloc is expected at same address at X and to hold J^{-1}(A,B)
c...  if (locfit.gt.0) X is expected to hold J(A,B)

      ibase=icorr(0)
      len_loc=0
      len_ext=0
      blenai=0
      blenak=0
      nao=0
      do iorb=1,norb
        i=listmo(iorb)
        ipfit=ioff_fitdom+i
        ipext=ioff_unifitdom+i
        ipa=ioff_uniorbdom+i
        lenai_loc=ntloc(ipfit,1)*ntloc(ipa,1)
        lenai_ext=ntloc(ipext,1)*ntloc(ipa,1)
        blenai=blenai+lenai_loc
        blenak=blenak+lenai_ext
        len_loc=max(len_loc,lenai_loc)
        len_ext=max(len_ext,lenai_ext)
        nao=max(nao,ntloc(ipa,1))
      end do
      call reserve_big(blenai,ifil_jbar,name_jbar,-1,0,
     >                 trim(mats)//type//'bar')
      nrecout=nrecout+1
c
      t1=second()
      info = 0
      iadj=icorr(len_ext)
      iadl=iadj
      if(locfit.gt.0) iadl=icorr(len_loc)
      if(locfit.gt.0) then
        leni=max(nfit,nao)
        indk=icori(leni)
        indi=icori(leni)
        call izero(iq(indk),leni)
        call izero(iq(indi),leni)
      end if
      offak=0
      offaf=0
      do iorb=1,norb
        i=listmo(iorb)
        ipa=ioff_uniorbdom+i
        ipext=ioff_unifitdom+i
        ipfit=ioff_fitdom+i
        nadom=ntloc(ipa,1)
        nkdom=ntloc(ipext,1)
        nfdom=ntloc(ipfit,1)
        lenaf=nadom*nfdom
        lenak=nadom*nkdom
        if(locfit.ne.0) then
          call df_contrs(X,Xloc,nfit,ipfit)
          call dgetrf_x(nfdom,nfdom,Xloc,nfdom,ipiv,info)
          if(info.ne.0) goto 500
          flops_fit=flops_fit+dble(nfdom)*dble(nfdom)*dble(nfdom)/3.d0
        end if
c
c... fitting coefficients
c
        call readm_big(q(iadj),lenak,ifil_j,name_j,offak,str)
        if(locfit.gt.0) then
          call df_contrx(q(iadj),q(iadl),iq(indk),iq(indi),
     >                   ipext,ipfit,ipa,ipa)
        else
          iadl=iadj
        end if
        call dgetrs_x('No transpose', nfdom,nadom, Xloc,nfdom,
     >               ipiv, q(iadl), nfdom,info)
        if(info.ne.0) goto 510
        call writem_big(q(iadl),lenaf,ifil_jbar,name_jbar,
     >                  offaf,trim(mats)//type//'bar')
        disktr2=disktr2+lenaf
        flops_fit=flops_fit+dble(nfdom)*dble(lenaf)
c
        offak=offak+lenak
        offaf=offaf+lenaf
      end do
      cpu_fit=cpu_fit+second()-t1
      call corlsr(ibase)
      return
500   write(6,*) 'dgetrf return code=',info
      call error('Error in dgetrf','df_fit_r12')
510   write(6,*) 'dgetrs return code=',info
      call error('Error in dgetrs','df_fit_r12')
      end subroutine df_fit_f12
c-----------------------------------------------------------------------
      end module df_f12_integrals
