<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE xsl:stylesheet [
<!ENTITY cr "&#x0A;"> 
]>

<!-- $Header: /server/CVS/abscon/absconCVS3/src/abscon/xml/Attic/instance_2_0.xsl,v 1.1.2.3 2006/11/14 18:57:35 lecoutre Exp $ -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="xml" indent="yes"/> 

<xsl:template match="instance">
<!-- <xsl:comment> This file has been generated by Abscon. For more information about its format, see http://www.cril.univ-artois.fr/~lecoutre </xsl:comment> -->
<xsl:text>&cr;</xsl:text> 
<instance>
<xsl:apply-templates select="presentation | domains | variables | relations | predicates | constraints"/>
</instance>
</xsl:template>

<xsl:template match="presentation">
  <xsl:text>&cr;</xsl:text> 
  <presentation>
    <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
    <xsl:if test="string-length(@maxConstraintArity) != 0">
      <xsl:attribute name="maxConstraintArity"><xsl:value-of select="@maxConstraintArity"/></xsl:attribute>
    </xsl:if>
     <!--  <xsl:attribute name="nbSolutions"><xsl:value-of select="@nbSolutions"/></xsl:attribute>      
    <xsl:if test="string-length(@solution) != 0">
      <xsl:attribute name="solution"><xsl:value-of select="@solution"/></xsl:attribute>
    </xsl:if>
   -->
    <xsl:attribute name="format"><xsl:value-of select="@format"/></xsl:attribute>
    <xsl:if test="string-length(@type) != 0">
      <xsl:attribute name="type"><xsl:value-of select="@type"/></xsl:attribute>
    </xsl:if>
    
    
  <!--  <xsl:text>&cr;</xsl:text> 
    <xsl:value-of select="text()"/>
    <xsl:text>&cr;</xsl:text> 
    -->
  </presentation>
  <xsl:text>&cr;</xsl:text>
</xsl:template>

<xsl:template match="domains">
  <xsl:text>&cr;</xsl:text> 
  <domains> 
    <xsl:attribute name="nbDomains"><xsl:value-of select="@nbDomains"/></xsl:attribute>
    <xsl:apply-templates select="domain"/>
    <xsl:text>&cr;</xsl:text>
  </domains>
  <xsl:text>&cr;</xsl:text>
</xsl:template>

<xsl:template match="domain">
  <xsl:text>&cr;</xsl:text> 
  <domain>
    <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>   
    <xsl:attribute name="nbValues"><xsl:value-of select="@nbValues"/></xsl:attribute>
   <!-- <xsl:text>&cr;</xsl:text> -->
    <xsl:value-of select="text()"/>
   <!-- <xsl:text>&cr;</xsl:text> -->
  </domain>
</xsl:template>

<xsl:template match="variables">
  <xsl:text>&cr;</xsl:text> 
  <variables>
    <xsl:attribute name="nbVariables"><xsl:value-of select="@nbVariables"/></xsl:attribute>
    <xsl:apply-templates select="variable"/>
    <xsl:text>&cr;</xsl:text>
  </variables>
  <xsl:text>&cr;</xsl:text>
</xsl:template>
    
<xsl:template match="variable">
  <xsl:text>&cr;</xsl:text> 
  <variable>
    <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
    <xsl:attribute name="domain"><xsl:value-of select="@domain"/></xsl:attribute>
  </variable>
</xsl:template>

<xsl:template match="relations">
  <xsl:text>&cr;</xsl:text>
  <relations> 
     <xsl:attribute name="nbRelations"><xsl:value-of select="@nbRelations"/></xsl:attribute>
     <xsl:apply-templates select="relation"/>
     <xsl:text>&cr;</xsl:text>
  </relations>
  <xsl:text>&cr;</xsl:text>
</xsl:template>

<xsl:template match="relation">
  <xsl:text>&cr;</xsl:text>
  <relation>
    <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
    <xsl:attribute name="arity"><xsl:value-of select="@arity"/></xsl:attribute>
    <xsl:attribute name="nbTuples"><xsl:value-of select="@nbTuples"/></xsl:attribute>
    <xsl:attribute name="semantics"><xsl:value-of select="@semantics"/></xsl:attribute>
    <!-- <xsl:text>&cr;</xsl:text> -->
    <xsl:value-of select="text()"/>
    <!-- <xsl:text>&cr;</xsl:text> -->
  </relation>
</xsl:template>

<xsl:template match="predicates">
  <xsl:text>&cr;</xsl:text>
  <predicates> 
    <xsl:attribute name="nbPredicates"><xsl:value-of select="@nbPredicates"/></xsl:attribute>
    <xsl:apply-templates select="predicate"/>
    <xsl:text>&cr;</xsl:text>
  </predicates>
  <xsl:text>&cr;</xsl:text>
</xsl:template>


<xsl:template match="predicate">
  <xsl:text>&cr;</xsl:text>
  <predicate>
    <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
     <xsl:apply-templates select="parameters"/> 
     <xsl:apply-templates select="expression"/> 
    <xsl:text>&cr;</xsl:text>
  </predicate>
</xsl:template>

<xsl:template match="parameters">
  <xsl:text>&cr;  </xsl:text>
  <parameters> 
    <xsl:value-of select="node()"/>
  </parameters>
</xsl:template>

<xsl:template match="expression">
  <xsl:text>&cr;  </xsl:text>
  <expression> 
    <xsl:text> </xsl:text> <xsl:apply-templates select="functional"/> 
    <xsl:text>&cr;  </xsl:text>
  </expression>
</xsl:template>

<xsl:template match="functional">
   <xsl:text>&cr;    </xsl:text>
   <functional>  <xsl:value-of select="node()"/>  </functional>
</xsl:template>


<xsl:template match="constraints">
  <xsl:text>&cr;</xsl:text>
  <constraints>
    <xsl:attribute name="nbConstraints"><xsl:value-of select="@nbConstraints"/></xsl:attribute>
    <xsl:if test="string-length(@lowerBound) != 0">
      <xsl:attribute name="lowerBound"><xsl:value-of select="@lowerBound"/></xsl:attribute> 
    </xsl:if>
    <xsl:if test="string-length(@upperBound) != 0">
      <xsl:attribute name="upperBound"><xsl:value-of select="@upperBound"/></xsl:attribute> 
    </xsl:if>
    <xsl:apply-templates select="constraint"/>
    <xsl:text>&cr;</xsl:text>
  </constraints>
  <xsl:text>&cr;</xsl:text>
</xsl:template>
    
<xsl:template match="constraint">
  <xsl:text>&cr;</xsl:text>
  <constraint>
    <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
    <xsl:attribute name="arity"><xsl:value-of select="@arity"/></xsl:attribute>
    <xsl:attribute name="scope"><xsl:value-of select="@scope"/></xsl:attribute>
    <xsl:attribute name="reference"><xsl:value-of select="@reference"/></xsl:attribute> 
    <xsl:if test="string-length(@defaultCost) != 0">
      <xsl:attribute name="defaultCost"><xsl:value-of select="@defaultCost"/></xsl:attribute> 
    </xsl:if>
    <xsl:apply-templates select="parameters"/>
  </constraint>
</xsl:template>

</xsl:stylesheet>


