/*
 * Decompiled with CFR 0.152.
 */
package abscon.xml;

import abscon.xml.Cores;
import abscon.xml.XMLManipulation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLProblemModifier {
    private static Cores cores = new Cores();

    public static int getNbVariablesIn(Document document) {
        Element variablesElement = XMLManipulation.getFirstElementByTagNameFromRoot(document, "variables");
        return variablesElement.getElementsByTagName("variable").getLength();
    }

    public static int getNbConstraintsIn(Document document) {
        Element constraintsElement = XMLManipulation.getFirstElementByTagNameFromRoot(document, "constraints");
        return constraintsElement.getElementsByTagName("constraint").getLength();
    }

    public static int getNbVariablesOrConstraints(Document document, boolean flag) {
        if (flag) {
            return XMLProblemModifier.getNbVariablesIn(document);
        }
        return XMLProblemModifier.getNbConstraintsIn(document);
    }

    public static void updateNbVariablesAndNbConstraintsIn(Document document) {
        Element variablesElement = XMLManipulation.getFirstElementByTagNameFromRoot(document, "variables");
        variablesElement.getAttributeNode("nbVariables").setNodeValue(String.valueOf(XMLProblemModifier.getNbVariablesIn(document)));
        Element constraintsElement = XMLManipulation.getFirstElementByTagNameFromRoot(document, "constraints");
        constraintsElement.getAttributeNode("nbConstraints").setNodeValue(String.valueOf(XMLProblemModifier.getNbConstraintsIn(document)));
    }

    private static String deleteElement(Document document, int position, String tagName, String subtagName) {
        Element elements = XMLManipulation.getFirstElementByTagNameFromRoot(document, tagName);
        NodeList nodeList = document.getElementsByTagName(subtagName);
        Element element = (Element)nodeList.item(position);
        String name = element.getAttribute("name");
        elements.removeChild(element);
        return name;
    }

    private static void deleteElement(Document document, String name, String tagName, String subtagName) {
        Element elements = XMLManipulation.getFirstElementByTagNameFromRoot(document, tagName);
        NodeList nodeList = elements.getElementsByTagName(subtagName);
        int i = 0;
        while (i < nodeList.getLength()) {
            Element element = (Element)nodeList.item(i);
            if (name.equals(element.getAttribute("name"))) {
                elements.removeChild(element);
                break;
            }
            ++i;
        }
    }

    private static void deleteElements(Document document, String[] names, String tagName, String subtagName) {
        Arrays.sort(names);
        Element elements = XMLManipulation.getFirstElementByTagNameFromRoot(document, tagName);
        NodeList nodeList = elements.getElementsByTagName(subtagName);
        ArrayList<Element> list = new ArrayList<Element>();
        int i = 0;
        while (i < nodeList.getLength()) {
            Element element = (Element)nodeList.item(i);
            String name = element.getAttribute("name");
            if (Arrays.binarySearch(names, name) >= 0) {
                list.add(element);
            }
            ++i;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            elements.removeChild((Element)it.next());
        }
    }

    private static void deleteElements(Document document, boolean[] removed, String tagName, String subtagName) {
        Element elements = XMLManipulation.getFirstElementByTagNameFromRoot(document, tagName);
        NodeList nodeList = elements.getElementsByTagName(subtagName);
        assert (removed.length == nodeList.getLength());
        ArrayList<Node> list = new ArrayList<Node>();
        int i = 0;
        while (i < removed.length) {
            if (removed[i]) {
                list.add(nodeList.item(i));
            }
            ++i;
        }
        for (Node node : list) {
            elements.removeChild(node);
        }
    }

    private static String[] getNamesOfElementsToBeRemoved(Document document, boolean[] removed, String tagName, String subtagName) {
        Element elements = XMLManipulation.getFirstElementByTagNameFromRoot(document, tagName);
        NodeList nodeList = elements.getElementsByTagName(subtagName);
        assert (removed.length == nodeList.getLength());
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < removed.length) {
            if (removed[i]) {
                list.add(((Element)nodeList.item(i)).getAttribute("name"));
            }
            ++i;
        }
        Object[] names = list.toArray(new String[0]);
        Arrays.sort(names);
        return names;
    }

    public static void deleteConstraint(Document document, int position) {
        XMLProblemModifier.deleteElement(document, position, "constraints", "constraint");
        XMLProblemModifier.updateNbVariablesAndNbConstraintsIn(document);
    }

    public static void deleteConstraint(Document document, String name) {
        XMLProblemModifier.deleteElement(document, name, "constraints", "constraint");
        XMLProblemModifier.updateNbVariablesAndNbConstraintsIn(document);
    }

    public static void deleteConstraints(Document document, boolean[] removed) {
        XMLProblemModifier.deleteElements(document, removed, "constraints", "constraint");
        XMLProblemModifier.updateNbVariablesAndNbConstraintsIn(document);
        assert (XMLProblemModifier.controlNamesInDocument(document));
    }

    public static void deleteConstraints(Document document, String[] constraintNames) {
        Arrays.sort(constraintNames);
        XMLProblemModifier.deleteElements(document, constraintNames, "constraints", "constraint");
        XMLProblemModifier.updateNbVariablesAndNbConstraintsIn(document);
    }

    private static boolean isPresentAsToken(String s, String[] variableNames) {
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (Arrays.binarySearch(variableNames, token) < 0) continue;
            return true;
        }
        return false;
    }

    private static void deleteConstraintsInvolving(Document document, String[] variableNames) {
        Element constraintsElement = XMLManipulation.getFirstElementByTagNameFromRoot(document, "constraints");
        NodeList constraintList = constraintsElement.getElementsByTagName("constraint");
        ArrayList<Element> list = new ArrayList<Element>();
        int i = 0;
        while (i < constraintList.getLength()) {
            Element constraintElement = (Element)constraintList.item(i);
            if (XMLProblemModifier.isPresentAsToken(constraintElement.getAttribute("scope"), variableNames)) {
                list.add(constraintElement);
            }
            ++i;
        }
        for (Element element : list) {
            constraintsElement.removeChild(element);
        }
    }

    public static void deleteVariable(Document document, int position) {
        String[] variableNames = new String[]{XMLProblemModifier.deleteElement(document, position, "variables", "variable")};
        XMLProblemModifier.deleteConstraintsInvolving(document, variableNames);
        XMLProblemModifier.updateNbVariablesAndNbConstraintsIn(document);
    }

    public static void deleteVariable(Document document, String name) {
        XMLProblemModifier.deleteElement(document, name, "variables", "variable");
        XMLProblemModifier.deleteConstraintsInvolving(document, new String[]{name});
        XMLProblemModifier.updateNbVariablesAndNbConstraintsIn(document);
    }

    public static void deleteVariables(Document document, String[] variableNames) {
        Arrays.sort(variableNames);
        XMLProblemModifier.deleteElements(document, variableNames, "variables", "variable");
        XMLProblemModifier.deleteConstraintsInvolving(document, variableNames);
        XMLProblemModifier.updateNbVariablesAndNbConstraintsIn(document);
    }

    public static void deleteVariables(Document document, boolean[] removed) {
        String[] variableNames = XMLProblemModifier.getNamesOfElementsToBeRemoved(document, removed, "variables", "variable");
        XMLProblemModifier.deleteVariables(document, variableNames);
        assert (XMLProblemModifier.controlNamesInDocument(document));
    }

    public static void deleteVariableOrConstraint(Document document, int position, boolean flag) {
        if (flag) {
            XMLProblemModifier.deleteVariable(document, position);
        } else {
            XMLProblemModifier.deleteConstraint(document, position);
        }
    }

    private static String[] getNamesIn(Document document, String tagName, String subtagName) {
        Element elements = XMLManipulation.getFirstElementByTagNameFromRoot(document, tagName);
        NodeList nodeList = elements.getElementsByTagName(subtagName);
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < nodeList.getLength()) {
            list.add(((Element)nodeList.item(i)).getAttribute("name"));
            ++i;
        }
        return list.toArray(new String[0]);
    }

    public static Cores getCores() {
        return cores;
    }

    private static void updateKernels(Document document) {
        cores.add(XMLProblemModifier.getNbVariablesIn(document), XMLProblemModifier.getNbConstraintsIn(document));
    }

    private static boolean isSingletonVariable(Document document, String variableName) {
        Element constraintsElement = XMLManipulation.getFirstElementByTagNameFromRoot(document, "constraints");
        NodeList constraintList = constraintsElement.getElementsByTagName("constraint");
        String[] variableNames = new String[]{variableName};
        int i = 0;
        while (i < constraintList.getLength()) {
            Element constraintElement = (Element)constraintList.item(i);
            if (XMLProblemModifier.isPresentAsToken(constraintElement.getAttribute("variables"), variableNames)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static void deleteIsolatedVariables(Document document) {
        boolean[] removed = new boolean[XMLProblemModifier.getNbVariablesIn(document)];
        Element variablesElement = XMLManipulation.getFirstElementByTagNameFromRoot(document, "variables");
        NodeList variableList = variablesElement.getElementsByTagName("variable");
        assert (removed.length == variableList.getLength());
        int i = 0;
        while (i < variableList.getLength()) {
            Element variableElement = (Element)variableList.item(i);
            if (XMLProblemModifier.isSingletonVariable(document, variableElement.getAttribute("name"))) {
                removed[i] = true;
            }
            ++i;
        }
        XMLProblemModifier.deleteElements(document, removed, "variables", "variable");
    }

    public static Document minus(String fileName1, String fileName2) {
        Document document1 = XMLManipulation.load(fileName1);
        Document document2 = XMLManipulation.load(fileName2);
        XMLProblemModifier.updateKernels(document2);
        XMLProblemModifier.deleteConstraints(document1, XMLProblemModifier.getNamesIn(document2, "constraints", "constraint"));
        return document1;
    }

    public static boolean controlNamesInDocument(Document document) {
        Element constraintsElement = XMLManipulation.getFirstElementByTagNameFromRoot(document, "constraints");
        NodeList constraintList = constraintsElement.getElementsByTagName("constraint");
        int i = 0;
        while (i < constraintList.getLength()) {
            Element constraintElement = (Element)constraintList.item(i);
            if (!constraintElement.hasAttribute("name")) {
                System.out.println("pb as no name for a constraint in CSPManipulation");
                return false;
            }
            ++i;
        }
        return true;
    }
}

