/*
 * Decompiled with CFR 0.152.
 */
package abscon.xml;

import abscon.constraints.Constraint;
import abscon.problem.Problem;
import abscon.problem.Variable;

public class State {
    private Problem problem;
    private boolean[] presentVariables;
    private boolean[] presentConstraints;

    public Problem getProblem() {
        return this.problem;
    }

    public boolean isPresentVariable(int i) {
        return this.presentVariables == null || this.presentVariables[i];
    }

    public boolean isPresentConstraint(int i) {
        return this.presentConstraints == null || this.presentConstraints[i];
    }

    public int getNbPresentVariables() {
        if (this.presentVariables == null) {
            return this.problem.getNbVariables();
        }
        int cpt = 0;
        int i = 0;
        while (i < this.presentVariables.length) {
            if (this.presentVariables[i]) {
                ++cpt;
            }
            ++i;
        }
        return cpt;
    }

    public int getNbPresentConstraints() {
        if (this.presentConstraints == null) {
            return this.problem.getNbConstraints();
        }
        int cpt = 0;
        int i = 0;
        while (i < this.presentConstraints.length) {
            if (this.presentConstraints[i]) {
                ++cpt;
            }
            ++i;
        }
        return cpt;
    }

    public State(Problem problem) {
        this.problem = problem;
    }

    public State(Problem problem, boolean[] presentVariables, boolean[] presentConstraints) {
        this.problem = problem;
        this.presentVariables = presentVariables;
        this.presentConstraints = presentConstraints;
        assert (this.controlCoherence());
    }

    public State(Problem problem, boolean[] presentVariables) {
        this.problem = problem;
        this.presentVariables = presentVariables;
        boolean[] tmp = new boolean[presentVariables.length];
        this.presentConstraints = new boolean[problem.getNbConstraints()];
        Constraint[] constraintArray = problem.getConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Variable variable;
            Constraint constraint = constraintArray[n];
            boolean involved = true;
            Variable[] variableArray = constraint.getInvolvedVariables();
            int n3 = 0;
            int n4 = variableArray.length;
            while (n3 < n4) {
                variable = variableArray[n3];
                if (!presentVariables[variable.getId()]) {
                    involved = false;
                    break;
                }
                ++n3;
            }
            if (involved) {
                variableArray = constraint.getInvolvedVariables();
                n3 = 0;
                n4 = variableArray.length;
                while (n3 < n4) {
                    variable = variableArray[n3];
                    tmp[variable.getId()] = true;
                    ++n3;
                }
            }
            this.presentConstraints[constraint.getId()] = involved;
            ++n;
        }
        int i = 0;
        while (i < presentVariables.length) {
            presentVariables[i] = presentVariables[i] && tmp[i];
            ++i;
        }
        assert (this.controlCoherence());
    }

    public State(Problem problem, boolean[] presentConstraints, boolean b) {
        this.problem = problem;
        this.presentConstraints = presentConstraints;
        this.presentVariables = new boolean[problem.getNbVariables()];
        int i = 0;
        while (i < this.presentVariables.length) {
            boolean involved = false;
            Constraint[] constraintArray = problem.getVariable(i).getInvolvingConstraints();
            int n = 0;
            int n2 = constraintArray.length;
            while (n < n2) {
                Constraint constraint = constraintArray[n];
                if (presentConstraints[constraint.getId()]) {
                    involved = true;
                    break;
                }
                ++n;
            }
            this.presentVariables[i] = involved;
            ++i;
        }
        assert (this.controlCoherence());
    }

    private boolean controlCoherence() {
        Variable[] variables = this.problem.getVariables();
        Constraint[] constraints = this.problem.getConstraints();
        if (variables.length != this.presentVariables.length || constraints.length != this.presentConstraints.length) {
            return false;
        }
        int i = 0;
        while (i < constraints.length) {
            if (this.presentConstraints[i]) {
                Variable[] involvedVariables = constraints[i].getInvolvedVariables();
                int j = 0;
                while (j < involvedVariables.length) {
                    if (!this.presentVariables[involvedVariables[j].getId()]) {
                        System.out.println("constraint " + constraints[i] + " with not present variable " + involvedVariables[j]);
                        return false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < variables.length) {
            if (this.presentVariables[i]) {
                Constraint[] involvingConstraints = variables[i].getInvolvingConstraints();
                boolean found = false;
                int j = 0;
                while (!found && j < involvingConstraints.length) {
                    if (this.presentConstraints[involvingConstraints[j].getId()]) {
                        found = true;
                    }
                    ++j;
                }
                if (!found) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }
}

