/*
 * Decompiled with CFR 0.152.
 */
package abscon.xml;

import abscon.ExtractionResolution;
import abscon.constants.XMLInstanceRepresentation;
import abscon.constraints.Constraint;
import abscon.constraints.extension.ExtensionConstraint;
import abscon.constraints.extension.Semantics;
import abscon.constraints.extension.SoftExtensionConstraint;
import abscon.constraints.extension.structures.Tuples;
import abscon.constraints.global.GlobalConstraint;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.xml.ExpressionBuilder;
import abscon.xml.ProblemDocumentBuilder;
import abscon.xml.State;
import abscon.xml.XMLManipulation;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import wcsp.Problem0;

public class ProblemDocumentBuilder2_0
extends ProblemDocumentBuilder {
    private List<Relation> relations = new LinkedList<Relation>();
    private List<Predicate> predicates = new LinkedList<Predicate>();
    private boolean useCanonicalVariableName = true;
    private boolean useCanonicalConstraintName = true;

    private Long isInteger(String token) {
        try {
            long l = Long.parseLong(token);
            return new Long(l);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Variable isVariableName(String token) {
        Variable[] variableArray = this.state.getProblem().getVariables();
        int n = 0;
        int n2 = variableArray.length;
        while (n < n2) {
            Variable variable = variableArray[n];
            if (variable.getName().equals(token)) {
                return variable;
            }
            ++n;
        }
        return null;
    }

    private Element buildDomainElement(String values, int id) {
        Element domainElement = this.document.createElement("domain");
        domainElement.setAttribute("name", XMLInstanceRepresentation.getDomainNameFor(id));
        domainElement.setAttribute("nbValues", String.valueOf(this.getNbValuesOf(values)));
        domainElement.setTextContent(values);
        return domainElement;
    }

    private Element buildDomainsElement(String[] domainsValues) {
        Element domainsElement = this.document.createElement("domains");
        domainsElement.setAttribute("nbDomains", String.valueOf(domainsValues.length));
        int i = 0;
        while (i < domainsValues.length) {
            domainsElement.appendChild(this.buildDomainElement(domainsValues[i], i));
            ++i;
        }
        return domainsElement;
    }

    private String[] getDomainsValues(Variable[] variables) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < variables.length) {
            String s = variables[i].getDomain().getStringListOfValues();
            int index = list.indexOf(s);
            if (index == -1) {
                list.add(s);
            }
            ++i;
        }
        return list.toArray(new String[0]);
    }

    private int getDomainIdOf(String[] list, String s) {
        int i = 0;
        while (i < list.length) {
            if (list[i].compareTo(s) == 0) {
                return i;
            }
            ++i;
        }
        assert (false);
        return -1;
    }

    private Element buildVariableElement(Variable variable, String[] domainDefinitions) {
        Element variableElement = this.document.createElement("variable");
        variableElement.setAttribute("name", this.useCanonicalVariableName ? variable.getDefaultName() : variable.getName());
        String domainName = XMLInstanceRepresentation.getDomainNameFor(this.getDomainIdOf(domainDefinitions, variable.getDomain().getStringListOfValues()));
        variableElement.setAttribute("domain", domainName);
        this.domainNamesOfVariables[variable.getId()] = domainName;
        return variableElement;
    }

    private Element buildVariablesElement(Variable[] variables, String[] domainDefinitions) {
        Element variablesElement = this.document.createElement("variables");
        variablesElement.setAttribute("nbVariables", String.valueOf(this.state.getNbPresentVariables()));
        this.domainNamesOfVariables = new String[this.state.getProblem().getNbVariables()];
        int i = 0;
        while (i < variables.length) {
            if (this.state.isPresentVariable(i)) {
                variablesElement.appendChild(this.buildVariableElement(variables[i], domainDefinitions));
            }
            ++i;
        }
        return variablesElement;
    }

    private Element buildRelationElement(Relation relation) {
        Element relationElement = this.document.createElement("relation");
        relationElement.setAttribute("name", relation.name);
        relationElement.setAttribute("arity", String.valueOf(relation.arity));
        relationElement.setAttribute("nbTuples", String.valueOf(relation.nbTuples));
        relationElement.setAttribute("semantics", relation.semantics.toString());
        relationElement.setTextContent(relation.tuples);
        return relationElement;
    }

    private Element buildRelationsElement() {
        if (this.relations.isEmpty()) {
            return null;
        }
        Element relationsElement = this.document.createElement("relations");
        relationsElement.setAttribute("nbRelations", String.valueOf(this.relations.size()));
        for (Relation relation : this.relations) {
            relationsElement.appendChild(this.buildRelationElement(relation));
        }
        return relationsElement;
    }

    private Element buildParameters(String s) {
        Element parametersElement = this.document.createElement("parameters");
        parametersElement.setTextContent(s);
        return parametersElement;
    }

    private Element buildFunctional(String s) {
        Element functionalElement = this.document.createElement("functional");
        functionalElement.setTextContent(s);
        return functionalElement;
    }

    private Element buildExpression(Element element) {
        Element expressionElement = this.document.createElement("expression");
        expressionElement.appendChild(element);
        return expressionElement;
    }

    private Element buildPredicateElement(Predicate predicate) {
        Element predicateElement = this.document.createElement("predicate");
        predicateElement.setAttribute("name", predicate.name);
        predicateElement.appendChild(this.buildParameters(predicate.formalParameters));
        Element function = this.buildFunctional(ExpressionBuilder.buildFunctionalExpression(predicate.canonicalExpression));
        predicateElement.appendChild(this.buildExpression(function));
        return predicateElement;
    }

    private Element buildPredicatesElement() {
        if (this.predicates.isEmpty()) {
            return null;
        }
        Element predicatesElement = this.document.createElement("predicates");
        predicatesElement.setAttribute("nbPredicates", String.valueOf(this.predicates.size()));
        for (Predicate predicate : this.predicates) {
            predicatesElement.appendChild(this.buildPredicateElement(predicate));
        }
        return predicatesElement;
    }

    private String seekRelation(int arity, String tuplesAndSize) {
        int position = tuplesAndSize.lastIndexOf(35);
        assert (position != -1);
        String tuples = position == 0 ? "" : tuplesAndSize.substring(0, position - 1);
        Semantics semantics = Semantics.searchFrom(tuplesAndSize.substring(position + 1));
        int nbTuples = Integer.parseInt(tuplesAndSize.substring(position + 1 + semantics.toString().length()));
        for (Relation relation : this.relations) {
            if (!relation.hasSameSemanticsAndTuples(semantics, arity, nbTuples, tuples)) continue;
            return relation.name;
        }
        String relationName = XMLInstanceRepresentation.getRelationNameFor(this.relations.size());
        this.relations.add(new Relation(relationName, arity, semantics, nbTuples, tuples));
        return relationName;
    }

    private Predicate seekPredicate(String expression) {
        String predicateName;
        Predicate newPredicate = new Predicate(expression);
        for (Predicate predicate : this.predicates) {
            if (!predicate.isSimilarTo(newPredicate)) continue;
            newPredicate.name = predicate.name;
            return newPredicate;
        }
        newPredicate.name = predicateName = XMLInstanceRepresentation.getPredicateNameFor(this.predicates.size());
        this.predicates.add(newPredicate);
        return newPredicate;
    }

    private String setConstraintDomain(Constraint constraint) {
        String domain = "";
        Variable[] variableArray = constraint.getInvolvedVariables();
        int n = 0;
        int n2 = variableArray.length;
        while (n < n2) {
            Variable variable = variableArray[n];
            domain = String.valueOf(domain) + " " + this.domainNamesOfVariables[variable.getId()];
            ++n;
        }
        return domain.substring(1);
    }

    private Element buildParametersElement(String s) {
        Element parameters = this.document.createElement("parameters");
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            Element child;
            String token = st.nextToken();
            Long l = this.isInteger(token);
            if (l != null) {
                child = this.document.createElement("cst");
                child.setAttribute("value", l.toString());
                parameters.appendChild(child);
                continue;
            }
            assert (this.isVariableName(token) != null);
            child = this.document.createElement("var");
            child.setAttribute("name", token);
            parameters.appendChild(child);
        }
        return parameters;
    }

    private Element buildConstraintElement(Constraint constraint, int cpt) {
        Element constraintElement = this.document.createElement("constraint");
        constraintElement.setAttribute("name", this.useCanonicalConstraintName ? XMLInstanceRepresentation.getConstraintNameFor(cpt) : constraint.getName());
        constraintElement.setAttribute("arity", String.valueOf(constraint.getArity()));
        constraintElement.setAttribute("scope", constraint.getStringListOfVariables(this.useCanonicalVariableName));
        if (constraint instanceof SoftExtensionConstraint) {
            constraintElement.setAttribute("defaultCost", "" + ((SoftExtensionConstraint)constraint).getDefaultCost());
        }
        if (constraint instanceof GlobalConstraint) {
            ((GlobalConstraint)constraint).updateElement(this.document, constraintElement, this.canonicalForm);
        } else if (!this.predicateForm || !constraint.canBeDefinedByAPredicate()) {
            String listOfTuples = null;
            listOfTuples = constraint instanceof SoftExtensionConstraint ? ((SoftExtensionConstraint)constraint).getStringListOfTuples() : (constraint instanceof ExtensionConstraint && ((ExtensionConstraint)constraint).getExtensionStructure() instanceof Tuples ? ((Tuples)((ExtensionConstraint)constraint).getExtensionStructure()).getStringListOfTuples() : constraint.getTupleManager().getStringListOfTuples());
            constraintElement.setAttribute("reference", this.seekRelation(constraint.getArity(), listOfTuples));
        } else {
            Predicate predicate = this.seekPredicate(constraint.getPredicateExpression(0));
            constraintElement.setAttribute("reference", predicate.name);
            constraintElement.appendChild(this.buildParameters(predicate.effectiveParameters));
        }
        return constraintElement;
    }

    private Element buildConstraintsElement(Constraint[] constraints) {
        this.relations.clear();
        Element constraintsElement = this.document.createElement("constraints");
        constraintsElement.setAttribute("nbConstraints", String.valueOf(this.state.getNbPresentConstraints()));
        if (this.state.getProblem() instanceof Problem0) {
            constraintsElement.setAttribute("lowerBound", "" + ((Problem0)this.state.getProblem()).getLowerBound());
            constraintsElement.setAttribute("upperBound", "" + ((Problem0)this.state.getProblem()).getUpperBound());
        }
        int cpt = 0;
        int i = 0;
        while (i < constraints.length) {
            if (this.state.isPresentConstraint(i)) {
                constraintsElement.appendChild(this.buildConstraintElement(constraints[i], cpt++));
            }
            ++i;
        }
        return constraintsElement;
    }

    private String solutionToString(int[] t) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < t.length) {
            sb.append(String.valueOf(t[i]) + (i < t.length - 1 ? " " : ""));
            ++i;
        }
        return sb.toString();
    }

    private Element buildPresentation() {
        Problem problem = this.state.getProblem();
        boolean core = problem.getResolution() instanceof ExtractionResolution;
        boolean limited = problem.getResolution() == null || problem.getSolver() == null;
        Element descriptionElement = this.document.createElement("presentation");
        descriptionElement.setAttribute("name", this.canonicalForm ? "?" : problem.getName());
        descriptionElement.setAttribute("maxConstraintArity", String.valueOf(problem.getMaxConstraintArity()));
        if (!(limited || this.canonicalForm || core || problem.getSolver().getStatistics().getNbFoundSolutions() <= 0L)) {
            descriptionElement.setAttribute("solution", problem.getSolver().getLastSolution().toString());
        }
        descriptionElement.setAttribute("nbSolutions", limited || core || this.canonicalForm ? "?" : problem.getSolver().getStatusOfNbSolutions());
        descriptionElement.setAttribute("format", "XCSP 2.0");
        if (this.state.getProblem() instanceof Problem0) {
            descriptionElement.setAttribute("type", "weightedCSP");
        }
        descriptionElement.setTextContent(String.valueOf(core ? "core of " : "") + problem.getDescription());
        return descriptionElement;
    }

    public ProblemDocumentBuilder2_0(State state, boolean predicateForm, boolean canonicalForm) {
        super(state, predicateForm, canonicalForm);
    }

    protected Document buildDocument() {
        this.document = XMLManipulation.createNewDocument();
        Element root = this.document.createElement("instance");
        root.appendChild(this.buildPresentation());
        String[] domainsValues = this.getDomainsValues(this.state.getProblem().getVariables());
        root.appendChild(this.buildDomainsElement(domainsValues));
        root.appendChild(this.buildVariablesElement(this.state.getProblem().getVariables(), domainsValues));
        Element constraintsElement = this.buildConstraintsElement(this.state.getProblem().getConstraints());
        Element predicatesElement = this.buildPredicatesElement();
        Element relationsElement = this.buildRelationsElement();
        if (relationsElement != null) {
            root.appendChild(relationsElement);
        }
        if (predicatesElement != null) {
            root.appendChild(predicatesElement);
        }
        root.appendChild(constraintsElement);
        this.document.appendChild(root);
        this.document.normalize();
        return this.document;
    }

    private static class Relation {
        String name;
        int arity;
        Semantics semantics;
        int nbTuples;
        String tuples;

        Relation(String name, int arity, Semantics semantics, int nbTuples, String tuples) {
            this.name = name;
            this.arity = arity;
            this.semantics = semantics;
            this.nbTuples = nbTuples;
            this.tuples = tuples;
        }

        boolean hasSameSemanticsAndTuples(Semantics semantics, int arity, int nbTuples, String tuples) {
            return this.semantics == semantics && this.arity == arity && this.nbTuples == nbTuples && this.tuples.equals(tuples);
        }
    }

    private class Predicate {
        String name;
        String initialExpression;
        String canonicalExpression;
        String formalParameters;
        String effectiveParameters;

        boolean isSimilarTo(Predicate predicate) {
            return this.canonicalExpression.equals(predicate.canonicalExpression);
        }

        Predicate(String initialExpression) {
            this.initialExpression = initialExpression;
            this.canonicalExpression = "";
            this.formalParameters = "";
            this.effectiveParameters = "";
            int nbParameters = 0;
            int nbTokens = 0;
            StringTokenizer st = new StringTokenizer(initialExpression);
            while (st.hasMoreTokens()) {
                ++nbTokens;
                String token = st.nextToken();
                Long l = ProblemDocumentBuilder2_0.this.isInteger(token);
                if (l != null) {
                    String formalParameterName = XMLInstanceRepresentation.getParameterNameFor(nbParameters++);
                    this.formalParameters = String.valueOf(this.formalParameters) + (nbParameters > 1 ? " " : "") + "int " + formalParameterName;
                    this.effectiveParameters = String.valueOf(this.effectiveParameters) + (nbParameters > 1 ? " " : "") + l;
                    this.canonicalExpression = String.valueOf(this.canonicalExpression) + (nbParameters > 1 ? " " : "") + formalParameterName;
                    continue;
                }
                Variable variable = ProblemDocumentBuilder2_0.this.isVariableName(token);
                if (variable != null) {
                    String formalParameterName = XMLInstanceRepresentation.getParameterNameFor(nbParameters++);
                    this.formalParameters = String.valueOf(this.formalParameters) + (nbParameters > 1 ? " " : "") + "int " + formalParameterName;
                    this.effectiveParameters = String.valueOf(this.effectiveParameters) + (nbParameters > 1 ? " " : "") + (ProblemDocumentBuilder2_0.this.useCanonicalVariableName ? variable.getDefaultName() : variable.getName());
                    this.canonicalExpression = String.valueOf(this.canonicalExpression) + (nbParameters > 1 ? " " : "") + formalParameterName;
                    continue;
                }
                this.canonicalExpression = String.valueOf(this.canonicalExpression) + (nbTokens > 1 ? " " : "") + token;
            }
        }

        boolean hasSameDomainAndSameExpression(String domain, String expression) {
            return this.canonicalExpression.equals(expression);
        }

        boolean hasSameExpression(String expression) {
            return this.canonicalExpression.equals(expression);
        }
    }
}

