/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools.reflection;

import abscon.constraints.Constraint;
import abscon.exceptions.MissingImplementationException;
import abscon.tools.Tools;
import abscon.tools.reflection.DigestedFields;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflector {
    public static final char JAR_SEPARATOR_CHAR = '/';

    public static Class getFirstInnerClassOfInheritingFrom(Class cl, Class targetClass) {
        Class<?>[] innerClasses = cl.getDeclaredClasses();
        int i = 0;
        while (i < innerClasses.length) {
            if (targetClass.isAssignableFrom(innerClasses[i])) {
                return innerClasses[i];
            }
            ++i;
        }
        return null;
    }

    private static String replaceAll(String s, char oldChar, char newChar) {
        StringBuffer sb = new StringBuffer(s);
        int i = 0;
        while (i < sb.length()) {
            if (sb.charAt(i) == oldChar) {
                sb.setCharAt(i, newChar);
            }
            ++i;
        }
        return sb.toString();
    }

    private static String getAbsoluteClassNameOf(File classFile, String basicPackageName) {
        String s = Reflector.replaceAll(classFile.getAbsolutePath(), File.separatorChar, '.');
        int firstIndex = s.indexOf(basicPackageName);
        assert (firstIndex != -1);
        int lastIndex = s.lastIndexOf(".");
        s = s.substring(firstIndex, lastIndex);
        return s;
    }

    private static void updateListIfSubclassing(List<Class> list, Class rootClass, String absoluteClassName, int requiredModifiers, int forbiddenModifiers) {
        try {
            Class<?> c = Class.forName(absoluteClassName);
            if ((c.getModifiers() & requiredModifiers) == requiredModifiers && (c.getModifiers() & forbiddenModifiers) == 0 && rootClass.isAssignableFrom(c)) {
                list.add(c);
            }
        }
        catch (ClassNotFoundException e) {
            Tools.dealWithFatalException(e);
        }
    }

    public static List<Class> searchClassesInheritingFromIn(Class rootClass, File directory, int requiredModifiers, int forbiddenModifiers) {
        assert (directory.isDirectory());
        ArrayList<Class> list = new ArrayList<Class>();
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                list.addAll(Reflector.searchClassesInheritingFromIn(rootClass, files[i], requiredModifiers, forbiddenModifiers));
            } else if (files[i].getName().endsWith(".class")) {
                Reflector.updateListIfSubclassing(list, rootClass, Reflector.getAbsoluteClassNameOf(files[i], rootClass.getPackage().getName()), requiredModifiers, forbiddenModifiers);
            }
            ++i;
        }
        return list;
    }

    public static Enumeration getEntriesOf(String jarName) {
        try {
            JarFile jf = new JarFile(jarName);
            return jf.entries();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static List<Class> searchClassesInheretingFromInJar(Class rootClass, String jarName, int requiredModifiers, int forbiddenModifiers) {
        list = new ArrayList<Class>();
        enumeration = Reflector.getEntriesOf(jarName);
        if (enumeration != null) ** GOTO lbl10
        return list;
lbl-1000:
        // 1 sources

        {
            name = ((ZipEntry)enumeration.nextElement()).getName();
            packTmp = Reflector.replaceAll(rootClass.getPackage().getName(), '.', '/');
            if (!name.endsWith(".class") || !name.startsWith(packTmp)) continue;
            name = Reflector.replaceAll(name.substring(0, name.lastIndexOf(".")), '/', '.');
            Reflector.updateListIfSubclassing(list, rootClass, name, requiredModifiers, forbiddenModifiers);
lbl10:
            // 3 sources

            ** while (enumeration.hasMoreElements())
        }
lbl11:
        // 1 sources

        return list;
    }

    private static File getDirectoryOf(String classPathToken, String basicDirectory) {
        basicDirectory = Reflector.replaceAll(basicDirectory, '.', File.separatorChar);
        return new File(String.valueOf(classPathToken) + (classPathToken.endsWith(File.separator) ? "" : File.separator) + basicDirectory);
    }

    private static File getDirectoryOf(String classPathToken, Class clazz) {
        return Reflector.getDirectoryOf(classPathToken, clazz.getPackage().getName());
    }

    public static Class[] searchClassesInheritingFrom(Class rootClass, int requiredModifiers, int forbiddenModifiers) {
        ArrayList<Class> classes = new ArrayList<Class>();
        StringTokenizer st = new StringTokenizer(System.getProperty("java.class.path", "."), File.pathSeparator);
        while (st.hasMoreTokens()) {
            String classPathToken = st.nextToken();
            if (classPathToken.endsWith(".jar")) {
                classes.addAll(Reflector.searchClassesInheretingFromInJar(rootClass, classPathToken, requiredModifiers, forbiddenModifiers));
                continue;
            }
            File directory = Reflector.getDirectoryOf(classPathToken, rootClass);
            if (!directory.exists() || !directory.isDirectory()) continue;
            classes.addAll(Reflector.searchClassesInheritingFromIn(rootClass, directory, requiredModifiers, forbiddenModifiers));
        }
        return classes.toArray(new Class[0]);
    }

    public static Field getFirstFieldOfWithType(Class cl, Class targetClass) {
        Field[] fields = cl.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if (targetClass.isAssignableFrom(fields[i].getType())) {
                return fields[i];
            }
            ++i;
        }
        return cl.getSuperclass() == null ? null : Reflector.getFirstFieldOfWithType(cl.getSuperclass(), targetClass);
    }

    public static DigestedFields getAllFieldsOfFieldOfInheritingFrom(Object object, Class targetClass) {
        Class innerClass = Reflector.getFirstInnerClassOfInheritingFrom(object.getClass(), targetClass);
        Field field = Reflector.getFirstFieldOfWithType(object.getClass(), targetClass);
        try {
            field.setAccessible(true);
            Object value = field.get(object);
            DigestedFields digest = new DigestedFields();
            while (innerClass != null) {
                Field[] fields = innerClass.getDeclaredFields();
                int i = 0;
                int cpt = 0;
                while (i < fields.length) {
                    fields[i].setAccessible(true);
                    if (!fields[i].getName().startsWith("this") && !fields[i].getType().getName().equals(object.getClass().getName())) {
                        digest.add(fields[i].getName(), fields[i].getType(), fields[i].get(value).toString(), cpt++);
                    }
                    ++i;
                }
                innerClass = innerClass.getSuperclass();
            }
            return digest;
        }
        catch (IllegalAccessException e) {
            Tools.dealWithFatalException(e);
            return null;
        }
    }

    public static String[][] getDescriptionOfDeclaredFieldsOf(Object object) {
        String[][] description = null;
        try {
            Class<?> cl = object.getClass();
            Field[] fields = cl.getDeclaredFields();
            description = new String[fields.length - 1][2];
            int i = 0;
            while (i < fields.length - 1) {
                fields[i].setAccessible(true);
                description[i][0] = fields[i].getName();
                String value = fields[i].get(object).toString();
                int position = value.lastIndexOf(47);
                description[i][1] = value = value.substring(position + 1);
                ++i;
            }
        }
        catch (Exception e) {
            Tools.dealWithFatalException(e);
        }
        return description;
    }

    public static String getStringConcatenationOfDeclaredFieldsOf(Object object) {
        StringBuffer sb = new StringBuffer();
        try {
            Class<?> cl = object.getClass();
            Field[] fields = cl.getDeclaredFields();
            int i = 0;
            while (i < fields.length - 1) {
                fields[i].setAccessible(true);
                String value = fields[i].get(object).toString();
                int position = value.lastIndexOf(47);
                value = value.substring(position + 1);
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(value);
                ++i;
            }
        }
        catch (Exception e) {
            Tools.dealWithFatalException(e);
        }
        return sb.toString();
    }

    private static String searchClassInDirectory(File directory, String name) {
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            File entry = files[i];
            if (entry.isDirectory()) {
                String path = Reflector.searchClassInDirectory(entry, name);
                if (path != null) {
                    return path;
                }
            } else if (entry.getName().equals(name)) {
                return entry.getPath();
            }
            ++i;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static String searchClassInJar(String jarName, String basicDirectory, String className) {
        enumeration = Reflector.getEntriesOf(jarName);
        if (enumeration != null) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            name = ((ZipEntry)enumeration.nextElement()).getName();
            if (!name.startsWith(basicDirectory) || !name.substring(name.lastIndexOf(47) + 1).equals(className)) continue;
            return Reflector.replaceAll(name.substring(0, name.lastIndexOf(".")), '/', '.');
lbl7:
            // 2 sources

            ** while (enumeration.hasMoreElements())
        }
lbl8:
        // 1 sources

        return null;
    }

    public static String searchAbsoluteNameOf(String basicPackage, String className) {
        StringTokenizer st = new StringTokenizer(System.getProperty("java.class.path", "."), File.pathSeparator);
        while (st.hasMoreTokens()) {
            String path;
            String classPathToken = st.nextToken();
            if (classPathToken.endsWith(".jar")) {
                String basicDirectory = Reflector.replaceAll(basicPackage, '.', '/');
                path = Reflector.searchClassInJar(classPathToken, basicDirectory, String.valueOf(className) + ".class");
                if (path == null) continue;
                return path;
            }
            File directory = Reflector.getDirectoryOf(classPathToken, basicPackage);
            if (!directory.exists() || !directory.isDirectory() || (path = Reflector.searchClassInDirectory(directory, String.valueOf(className) + ".class")) == null) continue;
            path = path.substring(classPathToken.length() + (classPathToken.endsWith(File.separator) ? 0 : 1), path.lastIndexOf("."));
            return Reflector.replaceAll(path, File.separatorChar, '.');
        }
        return null;
    }

    public static Method searchMethod(Class clazz, String methodName, int modifiers) {
        Method[] allClassMethods = clazz.getMethods();
        int j = 0;
        while (j < allClassMethods.length) {
            if (allClassMethods[j].getName().equals(methodName) && (allClassMethods[j].getModifiers() & modifiers) == modifiers) {
                return allClassMethods[j];
            }
            ++j;
        }
        return null;
    }

    public static Method[] searchMethods(Class[] classes, String methodName, int modifiers) {
        Method[] methods = new Method[classes.length];
        int i = 0;
        while (i < methods.length) {
            methods[i] = Reflector.searchMethod(classes[i], methodName, modifiers);
            ++i;
        }
        return methods;
    }

    public static Constructor searchFirstConstructor(Class clazz, int modifiers) {
        Constructor<?>[] constructors = clazz.getConstructors();
        Constructor<?> constructor = null;
        int i = 0;
        while (i < constructors.length) {
            if ((constructors[i].getModifiers() & modifiers) == modifiers) {
                constructor = constructors[i];
            }
            ++i;
        }
        return constructor;
    }

    public static Constructor[] searchFirstConstructors(Class[] classes, int modifiers) {
        Constructor[] constructors = new Constructor[classes.length];
        int i = 0;
        while (i < constructors.length) {
            constructors[i] = Reflector.searchFirstConstructor(classes[i], modifiers);
            if (constructors[i] == null) {
                throw new MissingImplementationException("Missing constructor in " + classes[i].getName());
            }
            ++i;
        }
        return constructors;
    }

    public static void main(String[] args) throws ClassNotFoundException {
        Class[] classes = Reflector.searchClassesInheritingFrom(Constraint.class, 1, 1024);
        Method[] methods = Reflector.searchMethods(classes, "getPredicateExpression", 8);
        Constructor[] constructors = Reflector.searchFirstConstructors(classes, 1);
        int i = 0;
        while (i < classes.length) {
            System.out.println(String.valueOf(classes[i].getName()) + "\n  with method " + methods[i] + "\n  constructor " + constructors[i]);
            ++i;
        }
    }
}

