/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools.randomLists;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Random;

public abstract class RandomListGenerator {
    public static final int UNSTRUCTURED = 0;
    public static final int CONNECTED = 1;
    public static final int BALANCED = 2;
    protected Random random;
    protected long seed;
    protected int[] nbValues;
    protected int tupleLength;
    protected int type;
    protected boolean tupleRepetition;
    protected boolean valueRepetition;
    protected int[][] tuples;
    protected int[] fixedTuple;
    protected boolean requiredFixedTuple;
    protected int[] nbOccurences;
    protected int nbMaxValues;

    public int[][] getTuples() {
        return this.tuples;
    }

    public RandomListGenerator(int[] nbValues, long seed) {
        this.nbValues = nbValues;
        this.tupleLength = nbValues.length;
        this.seed = seed;
        this.random = new Random(seed);
        this.nbMaxValues = nbValues[0];
        int i = 1;
        while (i < nbValues.length) {
            if (nbValues[i] > this.nbMaxValues) {
                this.nbMaxValues = nbValues[i];
            }
            ++i;
        }
        this.nbOccurences = new int[this.nbMaxValues];
    }

    public RandomListGenerator(int nb, int tupleLength, long seed) {
        this.nbValues = new int[tupleLength];
        Arrays.fill(this.nbValues, nb);
        this.tupleLength = tupleLength;
        this.seed = seed;
        this.random = new Random(seed);
        this.nbMaxValues = nb;
        this.nbOccurences = new int[nb];
    }

    public void setParameters(int type, boolean tupleRepetition, boolean valueRepetition, int[] fixedTuple, boolean requiredFixedTuple) {
        this.type = type;
        this.tupleRepetition = tupleRepetition;
        this.valueRepetition = valueRepetition;
        this.fixedTuple = fixedTuple;
        this.requiredFixedTuple = requiredFixedTuple;
        if (this.computeNbDistinctTuples() == 0.0) {
            throw new IllegalArgumentException("The number of distinct tuples is equal to 0");
        }
        if (fixedTuple != null && !valueRepetition) {
            int i = 0;
            while (i < fixedTuple.length - 1) {
                if (fixedTuple[i] >= fixedTuple[i + 1]) {
                    throw new IllegalArgumentException("The fixed tuple must be ordered");
                }
                ++i;
            }
        }
    }

    protected void updateNbValueOccurencesFor(int[] tuple) {
        int i = 0;
        while (i < tuple.length) {
            int n = tuple[i];
            this.nbOccurences[n] = this.nbOccurences[n] + 1;
            ++i;
        }
    }

    protected static double cnp(int n, int p) {
        double k = 1.0;
        int i = n;
        while (i > n - p) {
            k *= (double)i;
            --i;
        }
        i = p;
        while (i > 1) {
            k /= (double)i;
            --i;
        }
        return k;
    }

    public static double computeNbArrangementsFrom(int[] t) {
        double d = 1.0;
        int i = 0;
        while (i < t.length) {
            d *= (double)t[i];
            ++i;
        }
        return d;
    }

    public static double computeNbCombinationsFrom(int[] t, int i, int j) {
        if (i == t.length - 1) {
            return t[i] - j;
        }
        double cpt = 0.0;
        int k = j;
        while (k < t[i]) {
            cpt += RandomListGenerator.computeNbCombinationsFrom(t, i + 1, k + 1);
            ++k;
        }
        return cpt;
    }

    public static double computeNbCombinationsFrom(int[] t) {
        int[] tmp = (int[])t.clone();
        Arrays.sort(tmp);
        if (tmp[0] == tmp[tmp.length - 1]) {
            return RandomListGenerator.cnp(tmp[0], tmp.length);
        }
        return RandomListGenerator.computeNbCombinationsFrom(tmp, 0, 0);
    }

    protected double computeNbDistinctTuples() {
        return this.valueRepetition ? RandomListGenerator.computeNbArrangementsFrom(this.nbValues) : RandomListGenerator.computeNbCombinationsFrom(this.nbValues);
    }

    protected String getSelectionDescription() {
        return String.valueOf(this.tuples.length);
    }

    private String getTypeDescription() {
        if (this.type == 0) {
            return "unstructured";
        }
        if (this.type == 1) {
            return "connected";
        }
        return "balanced";
    }

    public void saveElements() {
        String name = "List_" + this.nbValues + "_" + this.tupleLength + "_" + this.seed + "_" + this.getSelectionDescription() + "_" + this.getTypeDescription() + "_" + this.tupleRepetition + "_" + this.valueRepetition + (this.fixedTuple != null ? "_sat" : "") + ".txt";
        PrintWriter out = null;
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(name)));
        }
        catch (IOException e) {
            System.out.println(e);
            System.exit(1);
        }
        int i = 0;
        while (i < this.tuples.length) {
            int j = 0;
            while (j < this.tuples[i].length) {
                out.print(String.valueOf(this.tuples[i][j]) + " ");
                ++j;
            }
            out.println();
            ++i;
        }
        out.close();
    }

    public void displayTuples() {
        double max = this.tupleRepetition ? -1.0 : (this.valueRepetition ? RandomListGenerator.computeNbArrangementsFrom(this.nbValues) : RandomListGenerator.computeNbCombinationsFrom(this.nbValues));
        System.out.println("There are " + this.tuples.length + " elements " + (max != -1.0 ? "/  " + max + " elements" : ""));
        int i = 0;
        while (i < this.tuples.length) {
            System.out.print("(");
            int j = 0;
            while (j < this.tuples[i].length) {
                System.out.print(this.tuples[i][j]);
                if (j != this.tuples[i].length - 1) {
                    System.out.print(",");
                }
                ++j;
            }
            System.out.print(") ");
            ++i;
        }
        System.out.println();
        System.out.println("Occurrences of values");
        i = 0;
        while (i < this.nbOccurences.length) {
            System.out.println(" value " + i + " => " + this.nbOccurences[i]);
            ++i;
        }
    }

    static void main(String[] args) {
        int[] t = new int[]{2, 2, 6, 23, 3, 7, 8, 10, 10, 10, 10, 12, 21, 30};
        System.out.println("Combinations = " + RandomListGenerator.computeNbCombinationsFrom(t));
        System.out.println("Arrangements = " + RandomListGenerator.computeNbArrangementsFrom(t));
    }
}

