/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools.randomLists;

import abscon.tools.math.LexicographicComparator;
import abscon.tools.randomLists.CoarseProportionRandomListGenerator;
import abscon.tools.randomLists.FineProportionRandomListGenerator;
import abscon.tools.randomLists.RandomListGenerator;
import java.util.Arrays;

public abstract class ProportionRandomListGenerator
extends RandomListGenerator {
    protected static final int OCCURENCES_LIMIT = 100;
    protected int nbWishedOccurences;
    protected int nbMaxOccurences;
    protected int nbAllowedOverflows;
    protected int nbCurrentOverflows;
    private int nbCurrentOverflowsBis;
    private int[] nbOccurencesBis;
    private LexicographicComparator lexicographicComparator = new LexicographicComparator();

    public ProportionRandomListGenerator(int[] nbValues, long seed) {
        super(nbValues, seed);
        this.nbOccurencesBis = new int[this.nbMaxValues];
    }

    public ProportionRandomListGenerator(int nb, int tupleLength, long seed) {
        super(nb, tupleLength, seed);
        this.nbOccurencesBis = new int[nb];
    }

    protected void storeNbOccurrences() {
        int i = 0;
        while (i < this.nbOccurences.length) {
            this.nbOccurencesBis[i] = this.nbOccurences[i];
            ++i;
        }
        this.nbCurrentOverflowsBis = this.nbCurrentOverflows;
    }

    protected void restoreNbOccurrences() {
        int i = 0;
        while (i < this.nbOccurences.length) {
            this.nbOccurences[i] = this.nbOccurencesBis[i];
            ++i;
        }
        this.nbCurrentOverflows = this.nbCurrentOverflowsBis;
    }

    protected void fixLimits(int type) {
        int nbTuples = this.tuples.length;
        if (type == 0) {
            this.nbWishedOccurences = Integer.MAX_VALUE;
            this.nbMaxOccurences = Integer.MAX_VALUE;
            this.nbAllowedOverflows = 0;
        }
        if (type == 1) {
            this.nbWishedOccurences = 1;
            this.nbMaxOccurences = nbTuples;
            this.nbAllowedOverflows = this.tupleLength * nbTuples - this.nbWishedOccurences * this.nbMaxValues;
        }
        if (type == 2) {
            this.nbWishedOccurences = this.tupleLength * nbTuples / this.nbMaxValues;
            this.nbMaxOccurences = this.nbWishedOccurences + 1;
            this.nbAllowedOverflows = this.tupleLength * nbTuples % this.nbMaxValues;
        }
    }

    protected boolean mustValueWait(int value) {
        int n = value;
        this.nbOccurences[n] = this.nbOccurences[n] + 1;
        if (this.nbOccurences[value] <= this.nbWishedOccurences) {
            return false;
        }
        if (this.nbOccurences[value] > this.nbMaxOccurences) {
            return true;
        }
        ++this.nbCurrentOverflows;
        return this.nbCurrentOverflows > this.nbAllowedOverflows;
    }

    protected boolean mustTupleWait(int[] tuple) {
        int i = 0;
        while (i < tuple.length) {
            if (this.mustValueWait(tuple[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected abstract void makeSelection();

    public int[][] selectTuples(int nbTuples, int type, boolean tupleRepetition, boolean valueRepetition, int[] fixedTuple, boolean requiredFixedTuple) {
        double nbDistinctTuples;
        this.setParameters(type, tupleRepetition, valueRepetition, fixedTuple, requiredFixedTuple);
        if (this.tuples == null || this.tuples.length != nbTuples) {
            this.tuples = new int[nbTuples][this.tupleLength];
        }
        if (!tupleRepetition && (double)nbTuples > (nbDistinctTuples = this.computeNbDistinctTuples())) {
            throw new IllegalArgumentException("The number of tuples " + nbTuples + " is greater than the maximum number " + nbDistinctTuples);
        }
        this.fixLimits(type);
        this.makeSelection();
        Arrays.sort(this.tuples, this.lexicographicComparator);
        return this.tuples;
    }

    public int[][] selectTuples(int nbTuples, int type, boolean tupleRepetition, boolean valueRepetition) {
        return this.selectTuples(nbTuples, type, tupleRepetition, valueRepetition, null, false);
    }

    public void displayTuples() {
        super.displayTuples();
    }

    static void main(String[] args) {
        int nbValues = Integer.parseInt(args[0]);
        int arity = Integer.parseInt(args[1]);
        int seed = Integer.parseInt(args[2]);
        int nbElements = Integer.parseInt(args[3]);
        int type = Integer.parseInt(args[4]);
        boolean erepetition = Integer.parseInt(args[5]) != 0;
        boolean vrepetition = Integer.parseInt(args[6]) != 0;
        boolean fine = Integer.parseInt(args[7]) != 0;
        ProportionRandomListGenerator r = null;
        r = fine ? new FineProportionRandomListGenerator(nbValues, arity, seed) : new CoarseProportionRandomListGenerator(nbValues, arity, seed);
        r.selectTuples(nbElements, type, erepetition, vrepetition);
        r.displayTuples();
    }
}

