/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools.randomLists;

import abscon.tools.math.BasisConvertor;
import abscon.tools.math.CombinationIterator;
import abscon.tools.randomLists.RandomListGenerator;
import java.util.LinkedList;

public class ProbabilityRandomListGenerator
extends RandomListGenerator {
    private double selectionLimit;

    public ProbabilityRandomListGenerator(int[] nbValues, long seed) {
        super(nbValues, seed);
        this.type = 0;
        this.tupleRepetition = false;
    }

    public ProbabilityRandomListGenerator(int nb, int tupleLength, long seed) {
        super(nb, tupleLength, seed);
        this.type = 0;
        this.tupleRepetition = false;
    }

    private double getActualSelectionLimit(double nbMaxElements) {
        if (this.fixedTuple == null) {
            return this.selectionLimit;
        }
        if (this.requiredFixedTuple) {
            return Math.max(0.0, this.selectionLimit - 1.0 / nbMaxElements) * (nbMaxElements / (nbMaxElements - 1.0));
        }
        return this.selectionLimit * nbMaxElements / (nbMaxElements - 1.0);
    }

    public int[][] selectTuples(double selectionLimit, boolean valueRepetition, int[] fixedTuple, boolean requiredFixedTuple) {
        this.setParameters(0, false, valueRepetition, fixedTuple, requiredFixedTuple);
        this.selectionLimit = selectionLimit;
        LinkedList<int[]> linkedList = new LinkedList<int[]>();
        double nbDistinctTuples = this.computeNbDistinctTuples();
        double actualSelectionLimit = this.getActualSelectionLimit(nbDistinctTuples);
        long fixedIndex = fixedTuple == null ? -1L : BasisConvertor.getDecimalValueFor(fixedTuple, this.nbValues);
        CombinationIterator iterator = valueRepetition ? null : new CombinationIterator(this.nbValues);
        int[] element = new int[this.tupleLength];
        int i = 0;
        while ((double)i < nbDistinctTuples) {
            int[] nArray = element = valueRepetition ? BasisConvertor.getValueFor((long)i, element, this.nbValues) : iterator.next();
            if (!(BasisConvertor.getDecimalValueFor(element, this.nbValues) == fixedIndex ? !requiredFixedTuple : this.random.nextDouble() > actualSelectionLimit)) {
                this.updateNbValueOccurencesFor(element);
                linkedList.add((int[])element.clone());
            }
            ++i;
        }
        this.tuples = (int[][])linkedList.toArray((T[])new int[0][]);
        return this.tuples;
    }

    public int[][] selectTuples(double selectionLimit, boolean valueRepetition) {
        return this.selectTuples(selectionLimit, valueRepetition, null, false);
    }

    protected String getSelectionDescription() {
        return String.valueOf(this.tuples.length) + "(" + this.selectionLimit + ")";
    }

    static void main(String[] args) {
        int nbValues = Integer.parseInt(args[0]);
        int arity = Integer.parseInt(args[1]);
        int seed = Integer.parseInt(args[2]);
        double selectionLimit = Double.parseDouble(args[3]);
        boolean vrepetition = Integer.parseInt(args[4]) != 0;
        ProbabilityRandomListGenerator r = new ProbabilityRandomListGenerator(nbValues, arity, seed);
        r.selectTuples(selectionLimit, vrepetition);
        r.displayTuples();
    }
}

