/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools.randomLists;

import java.security.MessageDigest;

public class ImplicitRandomList {
    private MessageDigest md;
    private int prefix1;
    private int prefix2;
    private byte[] bytes;

    public ImplicitRandomList(int prefix1, int prefix2, int tupleLength, String algorithm) {
        this.prefix1 = prefix1;
        this.prefix2 = prefix2;
        this.bytes = new byte[tupleLength + 3];
        short s = (short)prefix1;
        this.bytes[tupleLength + 1] = (byte)(s & 0xFF);
        this.bytes[tupleLength] = (byte)(s >> 8);
        s = (short)prefix2;
        this.bytes[tupleLength + 2] = (byte)(s & 0xFF);
        try {
            this.md = MessageDigest.getInstance(algorithm);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    public final byte getRandomValueFor(int[] tuple) {
        int i = 0;
        while (i < tuple.length) {
            this.bytes[i] = (byte)(tuple[i] & 0xFF);
            ++i;
        }
        byte[] digest = this.md.digest(this.bytes);
        byte resultat = digest[0];
        int i2 = 1;
        while (i2 < digest.length) {
            resultat = (byte)(resultat ^ digest[i2]);
            ++i2;
        }
        return resultat;
    }

    static void main(String[] args) {
        int[] nArray = new int[4];
        nArray[0] = 123;
        nArray[1] = 1;
        nArray[2] = 12345;
        int[] t = nArray;
        ImplicitRandomList ir = new ImplicitRandomList(10, 6, 4, "SHA");
        System.out.println("name " + ir.md.getAlgorithm() + "=> " + ir.md);
        int i = 0;
        while (i < 10000) {
            byte d = ir.getRandomValueFor(t);
            if (i % 10000 == 0) {
                System.out.println(String.valueOf(i) + "\t" + d);
            }
            int j = 0;
            while (j < t.length) {
                int n = j++;
                t[n] = t[n] + 1;
            }
            ++i;
        }
    }
}

