/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools.randomLists;

import abscon.tools.math.BasisConvertor;
import abscon.tools.math.CombinationIterator;
import abscon.tools.randomLists.ProportionRandomListGenerator;
import java.util.Arrays;

public class FineProportionRandomListGenerator
extends ProportionRandomListGenerator {
    private static final int STRUCTURES_LIMIT = 100000;
    private long[] validIndexes;
    private int nbValidIndexes;
    private long[] waitingIndexes;
    private int nbWaitingIndexes;

    public FineProportionRandomListGenerator(int[] nbValues, long seed) {
        super(nbValues, seed);
    }

    public FineProportionRandomListGenerator(int nb, int tupleLength, long seed) {
        super(nb, tupleLength, seed);
    }

    public void setParameters(int type, boolean tupleRepetition, boolean valueRepetition, int[] fixedTuple, boolean requiredFixedTuple) {
        super.setParameters(type, tupleRepetition, valueRepetition, fixedTuple, requiredFixedTuple);
        if (tupleRepetition) {
            throw new IllegalArgumentException("It is not possible to use a fine proportion random list generator with tuple repetition");
        }
        if (this.computeNbDistinctTuples() > 100000.0) {
            throw new IllegalArgumentException("It is not possible to use a fine proportion random list generator with so many potential tuples");
        }
    }

    private void fillIndexStructures() {
        int nbDistinctTuples = (int)Math.ceil(this.computeNbDistinctTuples());
        this.nbWaitingIndexes = 0;
        this.waitingIndexes = new long[nbDistinctTuples];
        this.nbValidIndexes = nbDistinctTuples;
        this.validIndexes = new long[nbDistinctTuples];
        CombinationIterator iterator = this.valueRepetition ? null : new CombinationIterator(this.nbValues);
        int i = 0;
        while (i < this.validIndexes.length) {
            this.validIndexes[i] = this.valueRepetition ? (long)i : BasisConvertor.getDecimalValueFor(iterator.next(), this.nbValues);
            ++i;
        }
    }

    private void manageRequiredElement() {
        if (this.fixedTuple != null) {
            int position = Arrays.binarySearch(this.validIndexes, BasisConvertor.getDecimalValueFor(this.fixedTuple, this.nbValues));
            this.validIndexes[position] = this.validIndexes[--this.nbValidIndexes];
            if (!this.requiredFixedTuple) {
                return;
            }
            if (this.mustTupleWait(this.fixedTuple)) {
                throw new AssertionError();
            }
            System.arraycopy(this.fixedTuple, 0, this.tuples[0], 0, this.fixedTuple.length);
        }
    }

    protected void makeSelection() {
        this.fillIndexStructures();
        this.manageRequiredElement();
        int i = this.fixedTuple != null && this.requiredFixedTuple ? 1 : 0;
        while (i < this.tuples.length) {
            this.storeNbOccurrences();
            boolean found = false;
            int nbTrials = 0;
            while (!found) {
                ++nbTrials;
                while (!found && this.nbValidIndexes > 0) {
                    this.restoreNbOccurrences();
                    int rand = this.random.nextInt(this.nbValidIndexes);
                    long index = this.validIndexes[rand];
                    this.tuples[i] = BasisConvertor.getValueFor(index, this.tuples[i], this.nbValues);
                    if (this.mustTupleWait(this.tuples[i])) {
                        this.waitingIndexes[this.nbWaitingIndexes++] = index;
                    } else {
                        found = true;
                    }
                    this.validIndexes[rand] = this.validIndexes[--this.nbValidIndexes];
                }
                if (found) continue;
                if (nbTrials % 100 == 0) {
                    ++this.nbMaxOccurences;
                } else {
                    ++this.nbAllowedOverflows;
                }
                this.nbValidIndexes = this.nbWaitingIndexes;
                int j = 0;
                while (j < this.nbValidIndexes) {
                    this.validIndexes[j] = this.waitingIndexes[j];
                    ++j;
                }
                this.nbWaitingIndexes = 0;
            }
            ++i;
        }
    }
}

