/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools.randomLists;

import abscon.tools.randomLists.ProportionRandomListGenerator;
import java.util.Arrays;

public class CoarseProportionRandomListGenerator
extends ProportionRandomListGenerator {
    private static final int RANDOMS_LIMIT = 4;
    private static final int OVERFLOWS_LIMIT = 35;

    public CoarseProportionRandomListGenerator(int[] nbValues, long seed) {
        super(nbValues, seed);
    }

    public CoarseProportionRandomListGenerator(int nb, int tupleLength, long seed) {
        super(nb, tupleLength, seed);
    }

    private boolean isValidValue(int[] element, int position) {
        int value = element[position];
        if (!this.valueRepetition) {
            int i = 0;
            while (i < position) {
                if (element[i] == value) {
                    return false;
                }
                ++i;
            }
        }
        if (this.mustValueWait(value)) {
            if (this.nbOccurences[value] <= this.nbMaxOccurences) {
                --this.nbCurrentOverflows;
            }
            int n = value;
            this.nbOccurences[n] = this.nbOccurences[n] - 1;
            assert (this.nbOccurences[value] <= this.nbMaxOccurences && this.nbCurrentOverflows <= this.nbAllowedOverflows);
            return false;
        }
        return true;
    }

    private boolean isAuthorizedElement(int[] element, int limit) {
        if (this.fixedTuple != null && !this.requiredFixedTuple && Arrays.equals(element, this.fixedTuple)) {
            return false;
        }
        if (this.tupleRepetition) {
            return true;
        }
        int i = 0;
        while (i < limit) {
            if (Arrays.equals(this.tuples[i], element)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void manageRequiredElement() {
        if (this.fixedTuple != null && this.requiredFixedTuple) {
            if (this.mustTupleWait(this.fixedTuple)) {
                throw new AssertionError();
            }
            System.arraycopy(this.fixedTuple, 0, this.tuples[0], 0, this.fixedTuple.length);
        }
    }

    private void doPotentialRelaxation(int nbTrials) {
        if (nbTrials % 100 == 0) {
            ++this.nbMaxOccurences;
        } else if (nbTrials % 35 == 0) {
            ++this.nbAllowedOverflows;
        }
    }

    protected void makeSelection() {
        this.manageRequiredElement();
        int i = this.fixedTuple != null && this.requiredFixedTuple ? 1 : 0;
        while (i < this.tuples.length) {
            this.storeNbOccurrences();
            int nbTrials = 0;
            do {
                boolean valid = false;
                while (!valid) {
                    this.restoreNbOccurrences();
                    valid = true;
                    int j = 0;
                    while (valid && j < this.tuples[i].length) {
                        int nbRandomUses = 0;
                        do {
                            this.tuples[i][j] = this.random.nextInt(this.nbValues[j]);
                        } while (!this.isValidValue(this.tuples[i], j) && nbRandomUses++ < 4 * this.nbValues[j]);
                        if (nbRandomUses >= 4 * this.nbValues[j]) {
                            valid = false;
                        }
                        ++j;
                    }
                    if (!valid) {
                        this.doPotentialRelaxation(++nbTrials);
                        continue;
                    }
                    if (this.valueRepetition) continue;
                    Arrays.sort(this.tuples[i]);
                }
                this.doPotentialRelaxation(++nbTrials);
            } while (!this.isAuthorizedElement(this.tuples[i], i));
            ++i;
        }
    }
}

