/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools.math;

import abscon.tools.randomLists.RandomListGenerator;
import java.util.Arrays;

public class CombinationIterator {
    private int[] nbValues;
    private int length;
    private boolean uniform;
    private int[] currentElement;
    private boolean computedNextValue;
    private boolean hasNextValue;

    public CombinationIterator(int[] nbValues) {
        this.nbValues = (int[])nbValues.clone();
        this.length = nbValues.length;
        this.uniform = true;
        int i = 1;
        while (i < nbValues.length) {
            if (nbValues[i - 1] > nbValues[i]) {
                throw new IllegalArgumentException("The propagationSet of numbers of values are not in an increasing order");
            }
            if (nbValues[i] != nbValues[0]) {
                this.uniform = false;
            }
            ++i;
        }
        this.currentElement = new int[this.length];
        this.reset();
    }

    public CombinationIterator(int nb, int length) {
        if (nb < 1 || length < 1 || nb < length) {
            throw new IllegalArgumentException();
        }
        this.nbValues = new int[length];
        Arrays.fill(this.nbValues, nb);
        this.length = length;
        this.uniform = true;
        this.currentElement = new int[length];
        this.reset();
    }

    public void reset() {
        this.computedNextValue = true;
        this.hasNextValue = true;
        int i = 0;
        while (this.hasNextValue && i < this.length) {
            if (i >= this.nbValues[i]) {
                this.hasNextValue = false;
            } else {
                this.currentElement[i] = i;
            }
            ++i;
        }
    }

    private boolean isExtensibleFrom(int index) {
        if (this.uniform) {
            return this.nbValues[index] - this.currentElement[index] > this.length - index;
        }
        int value = this.currentElement[index];
        int i = index;
        while (i < this.currentElement.length) {
            if (++value >= this.nbValues[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean hasNext() {
        if (this.computedNextValue) {
            return this.hasNextValue;
        }
        this.computedNextValue = true;
        for (int last = this.length - 1; last >= 0; --last) {
            if (!this.isExtensibleFrom(last)) {
                continue;
            }
            this.currentElement[last] = this.currentElement[last] + 1;
            int i = last + 1;
            while (i < this.length) {
                this.currentElement[i] = this.currentElement[i - 1] + 1;
                ++i;
            }
            this.hasNextValue = true;
            return true;
        }
        this.hasNextValue = false;
        return false;
    }

    public int[] next() {
        if (!this.computedNextValue) {
            this.hasNext();
        }
        assert (this.hasNextValue);
        this.computedNextValue = false;
        return this.currentElement;
    }

    public void displayAllCombinations() {
        this.reset();
        int cpt = 0;
        while (this.hasNext()) {
            int[] element = this.next();
            System.out.print("(");
            int i = 0;
            while (i < element.length) {
                System.out.print(String.valueOf(i == 0 ? "" : ",") + element[i]);
                ++i;
            }
            System.out.print(")  ");
            ++cpt;
        }
        System.out.println("\nThere are " + cpt + " combinations");
    }

    public static void main(String[] args) {
        int[] nbValues = new int[]{7, 7, 7, 7};
        CombinationIterator iterator = new CombinationIterator(nbValues);
        System.out.println(RandomListGenerator.computeNbCombinationsFrom(nbValues));
        iterator.displayAllCombinations();
    }
}

