/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools.elements;

import abscon.exceptions.UnreachableCodeException;
import abscon.tools.elements.ExtensionElements;

public class GeneralElements
extends ExtensionElements {
    public GeneralElements(int size) {
        super(size);
    }

    public int getNextPresent(int element) {
        if (this.absentLevels[element] == -1) {
            return this.nextPresents[element];
        }
        if (element < this.firstPresent) {
            return this.firstPresent;
        }
        if (element > this.lastPresent) {
            return -1;
        }
        int i = element + 1;
        while (i <= this.lastPresent) {
            if (this.absentLevels[i] == -1) {
                return i;
            }
            ++i;
        }
        throw new UnreachableCodeException();
    }

    public int getPrevPresent(int element) {
        if (this.absentLevels[element] == -1) {
            return this.prevPresents[element];
        }
        if (element < this.firstPresent) {
            return -1;
        }
        if (element > this.lastPresent) {
            return this.lastPresent;
        }
        int i = element - 1;
        while (i >= this.firstPresent) {
            if (this.absentLevels[i] == -1) {
                return i;
            }
            --i;
        }
        throw new UnreachableCodeException();
    }

    public void addElement(int element) {
        int next = -1;
        int i = element + 1;
        while (next == -1 && i < this.absentLevels.length) {
            if (this.absentLevels[i] == -1) {
                next = i;
            }
            ++i;
        }
        int prev = -1;
        int i2 = element - 1;
        while (prev == -1 && i2 >= 0) {
            if (this.absentLevels[i2] == -1) {
                prev = i2;
            }
            --i2;
        }
        this.prevPresents[element] = prev;
        this.nextPresents[element] = next;
        if (prev == -1) {
            this.firstPresent = element;
        } else {
            this.nextPresents[prev] = element;
        }
        if (next == -1) {
            this.lastPresent = element;
        } else {
            this.prevPresents[next] = element;
        }
        if (this.lastAbsent == element) {
            this.lastAbsent = this.prevAbsents[element];
        } else {
            int current = this.lastAbsent;
            while (this.prevAbsents[current] != element) {
                current = this.prevAbsents[current];
            }
            this.prevAbsents[current] = this.prevAbsents[element];
        }
    }

    protected void removeElement(int element) {
        int prev = this.prevPresents[element];
        int next = this.nextPresents[element];
        if (prev == -1) {
            this.firstPresent = next;
        } else {
            this.nextPresents[prev] = next;
        }
        if (next == -1) {
            this.lastPresent = prev;
        } else {
            this.prevPresents[next] = prev;
        }
        this.prevAbsents[element] = this.lastAbsent;
        this.lastAbsent = element;
    }

    public void addPotentiallyIntermediate(int element) {
        int index = this.lastAbsent;
        while (index != -1) {
            if (index == element) {
                this.add(element);
                break;
            }
            assert (this.absentLevels[index] > this.absentLevels[element]);
            int n = index;
            this.absentLevels[n] = this.absentLevels[n] - 1;
            index = this.prevAbsents[index];
        }
    }
}

