/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools.elements;

import abscon.tools.elements.Elements;
import java.util.Arrays;

public abstract class ExtensionElements
extends Elements {
    protected int firstPresent;
    protected int lastPresent;
    protected int lastAbsent;
    protected int[] absentLevels;
    protected int[] nextPresents;
    protected int[] prevPresents;
    protected int[] prevAbsents;
    protected int nbPresentElements;
    protected int nbAbsentElements;

    public int getFirstPresent() {
        return this.firstPresent;
    }

    public int getLastPresent() {
        return this.lastPresent;
    }

    public int getLastAbsent() {
        return this.lastAbsent;
    }

    public int[] getAbsentLevels() {
        return this.absentLevels;
    }

    public int getMaximumSize() {
        return this.absentLevels.length;
    }

    public int getNbPresentElements() {
        return this.nbPresentElements;
    }

    public int getNbAbsentElements() {
        return this.nbAbsentElements;
    }

    public int getNbAbsentElementsAtDepth(int level) {
        int cpt = 0;
        int index = this.getLastAbsent();
        while (index != -1) {
            if (this.absentLevels[index] == level) {
                ++cpt;
            }
            index = this.getPrevAbsent(index);
        }
        return cpt;
    }

    public int getPrevAbsent(int element) {
        return this.prevAbsents[element];
    }

    public int getLastAbsentLevel() {
        if (this.lastAbsent == -1) {
            return -1;
        }
        return this.absentLevels[this.lastAbsent];
    }

    public int getAbsentLevelOf(int element) {
        return this.absentLevels[element];
    }

    private void initializeLinksOfDroppedElements() {
        int current = -1;
        int i = this.absentLevels.length - 1;
        while (i >= 0) {
            if (this.absentLevels[i] == -1) {
                current = i;
            } else {
                this.nextPresents[i] = current;
            }
            --i;
        }
        current = -1;
        i = 0;
        while (i < this.absentLevels.length) {
            if (this.absentLevels[i] == -1) {
                current = i;
            } else {
                this.prevPresents[i] = current;
            }
            ++i;
        }
    }

    public int initialize() {
        int prev = 0;
        while (prev < this.absentLevels.length && this.absentLevels[prev] != -1) {
            ++prev;
        }
        if (prev == this.absentLevels.length) {
            this.lastPresent = -1;
            this.firstPresent = -1;
            this.lastAbsent = -1;
            this.nbAbsentElements = 0;
            this.nbPresentElements = 0;
            return 0;
        }
        this.firstPresent = prev;
        this.prevPresents[prev] = -1;
        int size = 1;
        boolean finished = false;
        while (!finished) {
            int next = prev + 1;
            while (next < this.absentLevels.length && this.absentLevels[next] != -1) {
                ++next;
            }
            if (next == this.absentLevels.length) {
                finished = true;
                continue;
            }
            this.nextPresents[prev] = next;
            this.prevPresents[next] = prev;
            prev = next;
            ++size;
        }
        this.lastPresent = prev;
        this.nextPresents[prev] = -1;
        this.initializeLinksOfDroppedElements();
        this.nbPresentElements = size;
        this.lastAbsent = -1;
        this.nbAbsentElements = 0;
        return size;
    }

    public ExtensionElements(int size) {
        super(size);
        this.absentLevels = new int[size];
        this.nextPresents = new int[size];
        this.prevAbsents = new int[size];
        this.prevPresents = new int[size];
        Arrays.fill(this.absentLevels, -1);
        this.initialize();
    }

    public boolean isPresent(int element) {
        return this.absentLevels[element] == -1;
    }

    protected abstract void addElement(int var1);

    public void add(int element) {
        assert (this.absentLevels[element] != -1);
        this.absentLevels[element] = -1;
        ++this.nbPresentElements;
        --this.nbAbsentElements;
        this.addElement(element);
    }

    protected abstract void removeElement(int var1);

    public void remove(int element, int level) {
        assert (level >= 0 && this.absentLevels[element] == -1) : "level = " + level + " level = " + this.absentLevels[element];
        this.absentLevels[element] = level;
        --this.nbPresentElements;
        ++this.nbAbsentElements;
        this.removeElement(element);
    }

    public long[] getBinaryRepresentation() {
        return null;
    }

    public void reduceTo(int element, int level) {
        assert (level >= 0 && this.absentLevels[element] == -1);
        int i = this.firstPresent;
        while (i != -1) {
            if (i != element) {
                this.remove(i, level);
            }
            i = this.nextPresents[i];
        }
    }

    public void restoreElementsAtLevelGreaterThanOrEqualTo(int level) {
        assert (this.lastAbsent == -1 || this.absentLevels[this.lastAbsent] <= level);
        int element = this.lastAbsent;
        while (element != -1) {
            if (this.absentLevels[element] < level) break;
            this.add(element);
            element = this.prevAbsents[element];
        }
    }

    public String getStringListOfPresentElements() {
        boolean first = true;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.absentLevels.length) {
            if (this.absentLevels[i] == -1) {
                if (first) {
                    first = false;
                } else {
                    sb.append(' ');
                }
                sb.append(i);
            }
            ++i;
        }
        return sb.toString();
    }

    public boolean controlElements() {
        int i = this.firstPresent;
        while (i != -1) {
            if (this.absentLevels[i] != -1 || this.nextPresents[i] != -1 && i >= this.nextPresents[i]) {
                System.out.println("pb forward present : absent = " + this.absentLevels[i] + " i= " + i + " next = " + this.nextPresents[i]);
                return false;
            }
            i = this.nextPresents[i];
        }
        i = this.lastPresent;
        while (i != -1) {
            if (this.absentLevels[i] != -1 || this.prevPresents[i] != -1 && i <= this.prevPresents[i]) {
                System.out.println("pb backward present : absent = " + this.absentLevels[i] + " i= " + i + " prev = " + this.prevPresents[i]);
                return false;
            }
            i = this.prevPresents[i];
        }
        i = this.lastAbsent;
        while (i != -1) {
            if (this.absentLevels[i] == -1) {
                System.out.println("bad value of absentLevels");
                return false;
            }
            if (this.prevAbsents[i] != -1 && this.absentLevels[this.prevAbsents[i]] > this.absentLevels[i]) {
                System.out.println("level of " + i + " = " + this.absentLevels[i] + " level of " + this.prevAbsents[i] + " = " + this.absentLevels[this.prevAbsents[i]]);
                return false;
            }
            i = this.prevAbsents[i];
        }
        return true;
    }
}

