/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools.elements;

import java.util.Random;

public abstract class Elements {
    public long[] getBinaryRepresentation() {
        return null;
    }

    public abstract int getMaximumSize();

    public int getInitialSize() {
        return this.getNbPresentElements() + this.getNbAbsentElements();
    }

    public abstract int getNbPresentElements();

    public abstract int getNbAbsentElements();

    public abstract int getNbAbsentElementsAtDepth(int var1);

    public abstract int getFirstPresent();

    public abstract int getLastPresent();

    public int getPresent(int i) {
        assert (i >= 1 && i <= this.getNbPresentElements());
        int index = this.getFirstPresent();
        int cpt = 1;
        while (cpt < i) {
            index = this.getNextPresent(index);
            ++cpt;
        }
        return index;
    }

    public abstract int getNextPresent(int var1);

    public abstract int getPrevPresent(int var1);

    public abstract int getLastAbsent();

    public abstract int getPrevAbsent(int var1);

    public abstract int getLastAbsentLevel();

    public abstract int getAbsentLevelOf(int var1);

    public abstract int[] getAbsentLevels();

    public abstract int initialize();

    public Elements(int size) {
    }

    public int getUniquePresentElement() {
        assert (this.getNbPresentElements() == 1) : "Current size = " + this.getNbPresentElements();
        return this.getFirstPresent();
    }

    public abstract boolean isPresent(int var1);

    public abstract void add(int var1);

    public abstract void remove(int var1, int var2);

    public abstract void reduceTo(int var1, int var2);

    public void addPotentiallyIntermediate(int element) {
        assert (element == this.getLastAbsent());
        this.add(element);
    }

    public abstract void restoreElementsAtLevelGreaterThanOrEqualTo(int var1);

    public abstract String getStringListOfPresentElements();

    public String getStringListOfForPresentElements() {
        boolean first = true;
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.getNbPresentElements()) + " Present  elements (forward linking) : ");
        int i = this.getFirstPresent();
        while (i != -1) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(i);
            i = this.getNextPresent(i);
        }
        return sb.toString();
    }

    public String getStringListOfBackPresentElements() {
        boolean first = true;
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.getNbPresentElements()) + " Present elements (backward linking) : ");
        int i = this.getLastPresent();
        while (i != -1) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(i);
            i = this.getPrevPresent(i);
        }
        return sb.toString();
    }

    public String getStringListOfAbsentElements() {
        boolean first = true;
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.getNbAbsentElements()) + " Absent elements : ");
        int i = this.getLastAbsent();
        while (i != -1) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(String.valueOf(i) + "(" + this.getAbsentLevelOf(i) + ")");
            i = this.getPrevAbsent(i);
        }
        return sb.toString();
    }

    public String toString() {
        return "  " + this.getStringListOfForPresentElements() + "\n  " + this.getStringListOfBackPresentElements() + "\n  " + this.getStringListOfAbsentElements() + "\n";
    }

    protected abstract boolean controlElements();

    public boolean controlFullness() {
        if (this.getNbAbsentElements() != 0) {
            return false;
        }
        return this.controlElements();
    }

    public int getRandomElement(Random random) {
        int i = random.nextInt(this.getNbPresentElements()) + 1;
        return this.getPresent(i);
    }
}

