/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools.elements;

import abscon.exceptions.UnreachableCodeException;
import abscon.tools.elements.Elements;
import java.util.Vector;

public class BoundedElements
extends Elements {
    protected int firstPresent = 0;
    protected int lastPresent;
    private int initialSize;
    private Vector<Interval> history;

    public int initialize() {
        return this.getNbPresentElements();
    }

    public BoundedElements(int size) {
        super(size);
        this.lastPresent = size - 1;
        this.initialSize = size;
        this.history = new Vector();
        this.history.add(new Interval(-1, this.firstPresent, this.lastPresent));
        this.initialize();
    }

    public int getMaximumSize() {
        return this.initialSize;
    }

    public int getNbPresentElements() {
        return this.lastPresent - this.firstPresent + 1;
    }

    public int getNbAbsentElements() {
        return this.initialSize - this.getNbPresentElements();
    }

    public int getFirstPresent() {
        return this.firstPresent > this.lastPresent ? -1 : this.firstPresent;
    }

    public int getLastPresent() {
        return this.firstPresent > this.lastPresent ? -1 : this.lastPresent;
    }

    public int getPresent(int i) {
        assert (i >= 1 && i <= this.getNbPresentElements());
        return this.firstPresent + i - 1;
    }

    public int getNextPresent(int element) {
        if (this.firstPresent > this.lastPresent || element >= this.lastPresent) {
            return -1;
        }
        return Math.max(this.firstPresent, element + 1);
    }

    public int getPrevPresent(int element) {
        if (this.firstPresent > this.lastPresent || element <= this.firstPresent) {
            return -1;
        }
        return element - 1;
    }

    public boolean isPresent(int element) {
        return this.firstPresent <= this.lastPresent && this.firstPresent <= element && element <= this.lastPresent;
    }

    public int getLastAbsentLevel() {
        return this.history.lastElement().level;
    }

    public int getAbsentLevelOf(int element) {
        assert (element >= 0 && element < this.initialSize);
        assert (!this.isPresent(element) && this.history.get(0).has(element));
        int i = 1;
        while (i < this.history.size()) {
            Interval interval = this.history.get(i);
            if (!interval.has(element)) {
                return interval.level;
            }
            ++i;
        }
        return -1;
    }

    public int getNbAbsentElementsAtDepth(int level) {
        assert (level >= 0);
        int i = 0;
        while (i < this.history.size()) {
            Interval interval = this.history.get(i);
            if (interval.level == level) {
                return this.initialSize - interval.getNbPresentElements();
            }
            ++i;
        }
        return -1;
    }

    public void remove(int element, int level) {
        assert (element == this.firstPresent || element == this.lastPresent) : "Can't remove element in bounds " + element + "(" + this.getStringListOfPresentElements() + ")";
        Interval lastInterval = this.history.lastElement();
        if (element == this.firstPresent) {
            ++this.firstPresent;
            if (lastInterval.level == level) {
                lastInterval.min = this.firstPresent;
            } else {
                this.history.add(new Interval(level, this.firstPresent, this.lastPresent));
            }
        } else {
            --this.lastPresent;
            if (lastInterval.level == level) {
                lastInterval.max = this.lastPresent;
            } else {
                this.history.add(new Interval(level, this.firstPresent, this.lastPresent));
            }
        }
    }

    public void removeUpTo(int element, int level) {
        if (element <= this.firstPresent) {
            return;
        }
        this.firstPresent = Math.min(element, this.lastPresent + 1);
        Interval lastInterval = this.history.lastElement();
        if (lastInterval.level == level) {
            lastInterval.min = this.firstPresent;
        } else {
            this.history.add(new Interval(level, this.firstPresent, this.lastPresent));
        }
    }

    public void removeDownTo(int element, int level) {
        if (element >= this.lastPresent) {
            return;
        }
        this.lastPresent = Math.max(element, this.firstPresent - 1);
        Interval lastInterval = this.history.lastElement();
        if (lastInterval.level == level) {
            lastInterval.max = this.lastPresent;
        } else {
            this.history.add(new Interval(level, this.firstPresent, this.lastPresent));
        }
    }

    public void remove(int min, int max, int level) {
        if (min <= this.firstPresent) {
            this.removeUpTo(max + 1, level);
        } else if (max >= this.lastPresent) {
            this.removeDownTo(min - 1, level);
        } else {
            throw new UnsupportedOperationException("Trying to remove [" + min + ", " + max + "] from " + this);
        }
    }

    public void reduceTo(int element, int level) {
        assert (this.isPresent(element) && this.history.lastElement().level < level);
        this.firstPresent = this.lastPresent = element;
        this.history.add(new Interval(level, element, element));
    }

    public void reduceTo(int min, int max, int level) {
        assert (this.history.lastElement().level <= level);
        this.firstPresent = min;
        this.lastPresent = max;
        this.history.add(new Interval(level, min, max));
    }

    public void restoreElementsAtLevelGreaterThanOrEqualTo(int level) {
        while (this.history.lastElement().level >= level) {
            this.history.remove(this.history.size() - 1);
        }
        Interval interval = this.history.lastElement();
        this.firstPresent = interval.min;
        this.lastPresent = interval.max;
    }

    public void store(int level) {
        this.history.add(new Interval(level, this.firstPresent, this.lastPresent));
    }

    public int getNbAbsentElementsSinceStorage() {
        assert (this.history.size() >= 2);
        Interval interval1 = this.history.get(this.history.size() - 2);
        Interval interval2 = this.history.get(this.history.size() - 1);
        return interval2.min - interval1.min + interval1.max - interval2.max;
    }

    public Interval getMinIntervalFromStorage() {
        Interval interval1 = this.history.get(this.history.size() - 2);
        Interval interval2 = this.history.get(this.history.size() - 1);
        return new Interval(-2, interval1.min, interval2.min);
    }

    public Interval getMaxIntervalFromStorage() {
        Interval interval1 = this.history.get(this.history.size() - 2);
        Interval interval2 = this.history.get(this.history.size() - 1);
        return new Interval(-2, interval2.max, interval1.max);
    }

    public int getLastAbsent() {
        throw new UnreachableCodeException();
    }

    public int getPrevAbsent(int element) {
        throw new UnreachableCodeException();
    }

    public int[] getAbsentLevels() {
        throw new UnreachableCodeException();
    }

    public void setState(int index, boolean b) {
        throw new UnreachableCodeException();
    }

    public void addElement(int element) {
        throw new UnreachableCodeException();
    }

    public void add(int element) {
        throw new UnreachableCodeException();
    }

    public void addPotentiallyIntermediate(int element) {
        throw new UnreachableCodeException();
    }

    public String getStringListOfPresentElements() {
        return String.valueOf(this.firstPresent) + ".." + this.lastPresent;
    }

    public String getStringListOfAbsentElements() {
        return "Absent elements not available";
    }

    protected boolean controlElements() {
        return true;
    }

    public class Interval {
        public int level;
        public int min;
        public int max;

        public Interval(int level, int min, int max) {
            this.level = level;
            this.min = min;
            this.max = max;
        }

        public boolean has(int element) {
            return this.min <= this.max && this.min <= element && element <= this.max;
        }

        public int getNbPresentElements() {
            return this.max - this.min + 1;
        }

        public String toString() {
            return "[" + this.min + ".." + this.max + "]";
        }
    }
}

