/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools.elements;

import abscon.tools.BitManager;
import abscon.tools.elements.StackElements;
import java.util.Arrays;

public final class BitsStackElements
extends StackElements {
    private long[] binaryRepresentation;

    public long[] getBinaryRepresentation() {
        return this.binaryRepresentation;
    }

    public BitsStackElements(int size) {
        super(size);
        this.binaryRepresentation = new long[size / 64 + (size % 64 != 0 ? 1 : 0)];
        Arrays.fill(this.binaryRepresentation, -1L);
        this.binaryRepresentation[this.binaryRepresentation.length - 1] = BitManager.buildAllLongBitsTo1Upto(size - (this.binaryRepresentation.length - 1) * 64);
    }

    public void addElement(int element) {
        super.addElement(element);
        int n = element / 64;
        this.binaryRepresentation[n] = this.binaryRepresentation[n] | BitManager.ONE_LONG_BIT_TO_1[element % 64];
    }

    protected void removeElement(int element) {
        super.removeElement(element);
        int n = element / 64;
        this.binaryRepresentation[n] = this.binaryRepresentation[n] & BitManager.ONE_LONG_BIT_TO_0[element % 64];
    }
}

