/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools.absconParameters;

import abscon.Resolution;
import abscon.solvers.Solver;
import abscon.solvers.Statistics;
import abscon.tools.absconParameters.ArgumentsManager;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class StatisticsManager {
    private Resolution resolution;
    private QuickStatistics[] satStatistics;
    private QuickStatistics[] unsatStatistics;
    private QuickStatistics[] unknownStatistics;
    private QuickStatistics[] expiredStatistics;
    private QuickStatistics[] allStatistics;

    public StatisticsManager(Resolution resolution) {
        this.resolution = resolution;
        int nbAbstractionLevels = resolution.getNbAbstractionLevels();
        if (ArgumentsManager.getNbInstances() > 1) {
            this.satStatistics = new QuickStatistics[nbAbstractionLevels + 1];
            int i = 0;
            while (i < this.satStatistics.length) {
                this.satStatistics[i] = new QuickStatistics(i, "sat");
                ++i;
            }
            this.unsatStatistics = new QuickStatistics[nbAbstractionLevels + 1];
            i = 0;
            while (i < this.unsatStatistics.length) {
                this.unsatStatistics[i] = new QuickStatistics(i, "unsat");
                ++i;
            }
            this.unknownStatistics = new QuickStatistics[nbAbstractionLevels + 1];
            i = 0;
            while (i < this.unknownStatistics.length) {
                this.unknownStatistics[i] = new QuickStatistics(i, "unknown");
                ++i;
            }
            this.expiredStatistics = new QuickStatistics[nbAbstractionLevels + 1];
            i = 0;
            while (i < this.expiredStatistics.length) {
                this.expiredStatistics[i] = new QuickStatistics(i, "expired");
                ++i;
            }
            this.allStatistics = new QuickStatistics[nbAbstractionLevels + 1];
            i = 0;
            while (i < this.allStatistics.length) {
                this.allStatistics[i] = new QuickStatistics(i, "all");
                ++i;
            }
        }
    }

    public void update() {
        int i = 0;
        while (i <= this.resolution.getNbAbstractionLevels()) {
            Solver solver = this.resolution.getSolver(i);
            Statistics statistics = solver.getStatistics();
            if (statistics != null) {
                if (this.resolution.isTimeExpired()) {
                    this.expiredStatistics[i].updateStatisticsWith(statistics);
                } else if (statistics.getNbFoundSolutions() > 0L) {
                    this.satStatistics[i].updateStatisticsWith(statistics);
                } else if (solver.getFullExploration()) {
                    this.unsatStatistics[i].updateStatisticsWith(statistics);
                } else {
                    this.unknownStatistics[i].updateStatisticsWith(statistics);
                }
                this.allStatistics[i].updateStatisticsWith(statistics);
                this.allStatistics[i].updateForMedian(statistics.getDurationToRunSolver(), !this.resolution.isTimeExpired() && (statistics.getNbFoundSolutions() > 0L || solver.getFullExploration()));
            }
            ++i;
        }
    }

    public void outputGlobalStatistics() {
        int i = 0;
        while (i < this.expiredStatistics.length) {
            this.expiredStatistics[i].display();
            this.satStatistics[i].display();
            this.unsatStatistics[i].display();
            this.unknownStatistics[i].display();
            this.allStatistics[i].display();
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QuickStatistics {
        private String name;
        private int nbTreatedInstances;
        private long sumOfDurationToDoPrepro;
        private long sumOfDurationToDoSearch;
        private long sumOfDurationToRunSolver;
        private long sumOfNbSingletonTests;
        private long sumOfNbEffectiveSingletonTests;
        private long sumOfNbConstraintChecks;
        private long sumOfNbValidityChecks;
        private long sumOfNbPropagations;
        private long sumOfNbAssignments;
        private long sumOfNbSolutions;
        private long nbPreproRemovals;
        private int nbPreproInconsistencies;
        private int nbSuccesses;
        private long[] durationsToRunSolver;

        QuickStatistics(int level, String name) {
            this.name = name;
        }

        void updateStatisticsWith(Statistics statistics) {
            ++this.nbTreatedInstances;
            this.sumOfDurationToDoPrepro += statistics.getPreproWallClockTime();
            this.sumOfDurationToDoSearch += statistics.getSearchWallClockTime();
            this.sumOfDurationToRunSolver += statistics.getDurationToRunSolver();
            this.sumOfNbSingletonTests += statistics.getNbPreproSingletonTests();
            this.sumOfNbEffectiveSingletonTests += statistics.getNbPreproEffectiveSingletonTests();
            this.sumOfNbConstraintChecks += statistics.getNbConstraintChecks();
            this.sumOfNbValidityChecks += statistics.getNbValidityChecks();
            this.sumOfNbPropagations += statistics.getNbPropagations();
            this.sumOfNbAssignments += statistics.getNbAssignments();
            this.sumOfNbSolutions += statistics.getNbFoundSolutions();
            this.nbPreproRemovals += statistics.getNbPreproRemovals();
            this.nbPreproInconsistencies += statistics.getNbPreproInconsistencies();
        }

        void updateForMedian(long durationToRunSolver, boolean success) {
            if (this.durationsToRunSolver == null) {
                this.durationsToRunSolver = new long[ArgumentsManager.getNbInstances()];
            }
            if (success) {
                this.durationsToRunSolver[this.nbTreatedInstances - 1] = durationToRunSolver;
                ++this.nbSuccesses;
            } else {
                this.durationsToRunSolver[this.nbTreatedInstances - 1] = Long.MAX_VALUE;
            }
        }

        long computeMedian() {
            int nbInstances = ArgumentsManager.getNbInstances();
            if (this.nbSuccesses < nbInstances / 2 + 1) {
                return -1L;
            }
            Arrays.sort(this.durationsToRunSolver);
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.durationsToRunSolver.length) {
                sb.append(String.valueOf(this.durationsToRunSolver[i]) + " ");
                ++i;
            }
            if (nbInstances % 2 == 0) {
                return (this.durationsToRunSolver[nbInstances / 2] + this.durationsToRunSolver[nbInstances / 2 - 1]) / 2L;
            }
            return this.durationsToRunSolver[nbInstances / 2];
        }

        public Map<String, String> getMapOfCumulatedAttributes() {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("nbInstances", String.valueOf(this.nbTreatedInstances));
            if (this.nbTreatedInstances != 0) {
                map.put("preproCpuTime", String.valueOf(this.sumOfDurationToDoPrepro / (long)this.nbTreatedInstances));
                map.put("searchCpuTime", String.valueOf(this.sumOfDurationToDoSearch / (long)this.nbTreatedInstances));
                map.put("solvingCpuTime", String.valueOf(this.sumOfDurationToRunSolver / (long)this.nbTreatedInstances));
                if (this.durationsToRunSolver != null) {
                    map.put("medianCpuTime", String.valueOf(this.computeMedian()));
                }
                if (this.sumOfNbSingletonTests != 0L) {
                    map.put("nbSingletonTests", String.valueOf(this.sumOfNbSingletonTests / (long)this.nbTreatedInstances));
                }
                if (this.sumOfNbEffectiveSingletonTests != 0L) {
                    map.put("nbEffectiveSingletonTests", String.valueOf(this.sumOfNbEffectiveSingletonTests / (long)this.nbTreatedInstances));
                }
                map.put("nbConstraintChecks", String.valueOf(this.sumOfNbConstraintChecks / (long)this.nbTreatedInstances));
                map.put("nbValidityChecks", String.valueOf(this.sumOfNbValidityChecks / (long)this.nbTreatedInstances));
                map.put("nbPropagations", String.valueOf(this.sumOfNbPropagations / (long)this.nbTreatedInstances));
                map.put("nbAssignments", String.valueOf((double)this.sumOfNbAssignments / (double)this.nbTreatedInstances));
                map.put("nbFoundSolutions", String.valueOf((double)this.sumOfNbSolutions / (double)this.nbTreatedInstances));
                map.put("nbRemovedValues", String.valueOf((double)this.nbPreproRemovals / (double)this.nbTreatedInstances));
                if (this.name.equals("Unsat")) {
                    map.put("nbPreproInconsistencies", String.valueOf(this.nbPreproInconsistencies));
                }
            }
            return map;
        }

        void display() {
            StatisticsManager.this.resolution.getOutputManager().outputMap(this.name, this.getMapOfCumulatedAttributes(), 0);
        }
    }
}

