/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools.absconParameters;

import abscon.exceptions.InvalidPropertyException;
import abscon.propagationTechniques.revisionManagers.RevisionManager6;
import abscon.tools.Tools;
import abscon.xml.XMLManipulation;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

public class ConfigurationManager {
    private static Document document;
    private static Map<String, String> map;
    private static XPath xPath;

    public static void loadConfigurationFile(File file) {
        document = XMLManipulation.loadConfiguration(file);
        map = new HashMap<String, String>(256);
        xPath = XPathFactory.newInstance().newXPath();
    }

    public static void loadConfigurationFile(InputStream is) {
        document = XMLManipulation.loadConfiguration(is);
        map = new HashMap<String, String>(256);
        xPath = XPathFactory.newInstance().newXPath();
    }

    public static void loadConfigurationFile(String fileName) {
        ConfigurationManager.loadConfigurationFile(new File(fileName));
    }

    public static void setString(int level, String tag, String attribute, String value) {
        map.put(String.valueOf(ConfigurationManager.getLevel(level)) + tag + attribute, value);
    }

    public static void setString(String tag, String attribute, String value) {
        map.put(String.valueOf(tag) + attribute, value);
    }

    public static String getString(String tag, String attribute) {
        String key = String.valueOf(tag) + attribute;
        String value = map.get(key);
        if (value != null) {
            return value;
        }
        value = "";
        try {
            value = xPath.evaluate(String.valueOf(tag) + "/@" + attribute, document);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        map.put(key, value);
        return value;
    }

    private static String getLevel(int level) {
        return "//abstractionLevel[@value='" + level + "']/";
    }

    public static String getString(int level, String tag, String attribute) {
        return ConfigurationManager.getString(String.valueOf(ConfigurationManager.getLevel(level)) + tag, attribute);
    }

    public static int getInt(String tag, String attribute) {
        return Integer.parseInt(ConfigurationManager.getString(tag, attribute));
    }

    public static int getInt(int level, String tag, String attribute) {
        return ConfigurationManager.getInt(String.valueOf(ConfigurationManager.getLevel(level)) + tag, attribute);
    }

    public static double getDouble(String tag, String attribute) {
        return Double.parseDouble(ConfigurationManager.getString(tag, attribute));
    }

    public static double getDouble(int level, String tag, String attribute) {
        return ConfigurationManager.getDouble(String.valueOf(ConfigurationManager.getLevel(level)) + tag, attribute);
    }

    public static boolean getBoolean(String tag, String attribute) {
        String s = ConfigurationManager.getString(tag, attribute).toLowerCase();
        if (s.equals("y") || s.equals("yes")) {
            return true;
        }
        if (s.equals("n") || s.equals("no")) {
            return false;
        }
        throw new InvalidPropertyException();
    }

    public static boolean getBoolean(int level, String tag, String attribute) {
        return ConfigurationManager.getBoolean(String.valueOf(ConfigurationManager.getLevel(level)) + tag, attribute);
    }

    public static boolean isRevisionManager6(int level, String phase) {
        String prefix = "/propagationTechnique";
        String className = ConfigurationManager.getString(level, String.valueOf(phase) + prefix + "/" + "revisionManager", "class");
        return className.equals(Tools.getRelativeClassNameOf(RevisionManager6.class));
    }
}

