/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;

public class Tools {
    public static String getMemoryInformation() {
        Runtime rt = Runtime.getRuntime();
        DecimalFormat df = new DecimalFormat("###,###,###,###");
        return "used = " + df.format(rt.totalMemory() - rt.freeMemory()) + " free = " + rt.freeMemory() + " total = " + rt.totalMemory() + " max = " + rt.maxMemory();
    }

    public static void copy(String srcFileName, String dstFileName) {
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(srcFileName));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dstFileName));
            byte[] bytes = new byte[1024];
            int nb = in.read(bytes, 0, bytes.length);
            while (nb > 0) {
                out.write(bytes, 0, nb);
                nb = in.read(bytes, 0, bytes.length);
            }
            in.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static String getRawInstanceName(String s) {
        int first = s.lastIndexOf(File.separator) != -1 ? s.lastIndexOf(File.separator) + 1 : 0;
        int last = s.lastIndexOf(".") != -1 ? s.lastIndexOf(".") : s.length();
        return first > last ? s.substring(first) : s.substring(first, last);
    }

    public static String getRelativeParentPackageNameOf(Class clazz) {
        String s = clazz.getName();
        int last = s.lastIndexOf(".");
        if (last == -1) {
            return null;
        }
        String path = s.substring(0, last);
        return path.substring(path.lastIndexOf(".") + 1);
    }

    public static String getRelativeClassNameOf(Class clazz) {
        String s = clazz.getName();
        return s.substring(s.lastIndexOf(".") + 1);
    }

    public static String getRelativeClassNameOf(Object object) {
        String s = object.getClass().getName();
        return s.substring(s.lastIndexOf(".") + 1);
    }

    public static String getSeparator(int mode) {
        return mode == 0 ? "," : "\n";
    }

    public static void dealWithFatalException(Exception e) {
        Throwable x = e.getCause() == null ? e : e.getCause();
        x.printStackTrace();
        System.exit(1);
    }

    public static String getXMLBaseNameOf(String s) {
        int start = s.lastIndexOf(File.separator);
        start = start == -1 ? 0 : start + 1;
        int end = s.toLowerCase().lastIndexOf(".xml");
        end = end == -1 ? s.length() : end;
        return s.substring(start, end);
    }

    public static Integer isInteger(String token) {
        try {
            int l = Integer.parseInt(token);
            return new Integer(l);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Long isLong(String token) {
        try {
            long l = Long.parseLong(token);
            return new Long(l);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String getFormattedCurrentDate() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(System.currentTimeMillis());
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        DecimalFormat df = new DecimalFormat("00");
        return String.valueOf(year) + "_" + df.format(month) + "_" + df.format(day) + "_" + df.format(hour) + "_" + df.format(minute);
    }

    public static String getFormattedMemorySize(long size) {
        long m = size / 1000000L;
        long k = size / 1000L;
        return String.valueOf(m) + "M" + (k -= m * 1000L);
    }

    public static long getFreeMemory() {
        Runtime rt = Runtime.getRuntime();
        return rt.maxMemory() - rt.totalMemory() + rt.freeMemory();
    }

    public static long getUsedMemory() {
        Runtime rt = Runtime.getRuntime();
        return rt.totalMemory() - rt.freeMemory();
    }

    public static String getFormattedUsedMemorySize() {
        return Tools.getFormattedMemorySize(Tools.getUsedMemory());
    }

    public static String getAllocatedMemory() {
        Runtime rt = Runtime.getRuntime();
        return Tools.getFormattedMemorySize(rt.totalMemory());
    }
}

