/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericFifo<Type>
implements Queue<Type>,
Iterable<Type> {
    protected final int MAX_SIZE;
    protected int size;
    protected int head;
    protected int queue;
    protected Type[] fifo;

    public GenericFifo(int max_size) {
        this.MAX_SIZE = max_size;
        this.clear();
        this.fifo = new Object[this.MAX_SIZE];
    }

    private int prev(int i) {
        if (i == 0) {
            return this.MAX_SIZE - 1;
        }
        return i - 1;
    }

    @Override
    public boolean offer(Type value) {
        if (this.size == this.MAX_SIZE) {
            return false;
        }
        this.queue = this.prev(this.queue);
        this.fifo[this.queue] = value;
        ++this.size;
        return true;
    }

    @Override
    public boolean add(Type value) {
        if (!this.offer(value)) {
            throw new IllegalArgumentException("Queue is full");
        }
        return true;
    }

    @Override
    public Type poll() {
        Type value;
        try {
            value = this.remove();
        }
        catch (NoSuchElementException e) {
            return null;
        }
        return value;
    }

    @Override
    public Type remove() {
        if (this.size < 1) {
            throw new NoSuchElementException();
        }
        Type value = this.fifo[this.head];
        this.head = this.prev(this.head);
        --this.size;
        return value;
    }

    @Override
    public boolean contains(Object value) {
        if (this.isEmpty()) {
            return false;
        }
        for (Type current : this) {
            if (!current.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Type element() {
        if (this.size < 1) {
            throw new NoSuchElementException();
        }
        return this.fifo[this.head];
    }

    @Override
    public Type peek() {
        Type value;
        try {
            value = this.element();
        }
        catch (NoSuchElementException e) {
            return null;
        }
        return value;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size < 1;
    }

    @Override
    public Type[] toArray() {
        Object[] array = new Object[this.size()];
        int i = 0;
        for (Type current : this) {
            array[i++] = current;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.head = 0;
        this.queue = 1;
        this.size = 0;
    }

    @Override
    public Iterator<Type> iterator() {
        return new FifoIterator(this);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Type> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FifoIterator
    implements Iterator<Type> {
        GenericFifo fifo;
        int i;

        public FifoIterator(GenericFifo fifo) {
            this.fifo = fifo;
            this.i = fifo.head;
        }

        @Override
        public boolean hasNext() {
            if (GenericFifo.this.size == 0) {
                return false;
            }
            return this.i != GenericFifo.this.prev(GenericFifo.this.queue) || this.i == GenericFifo.this.head;
        }

        @Override
        public Type next() {
            Object currentValue = this.fifo.fifo[this.i];
            this.i = this.fifo.prev(this.i);
            return currentValue;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

