/*
 * Decompiled with CFR 0.152.
 */
package abscon.tools;

import java.util.Random;

public class Categories {
    private int nbObjects;
    private int nbCategories;
    private int nbStrictCategories;
    private int nbSharing;
    private int[][] categoriesOfObject;
    private int[][] objectsOfCategory;
    private boolean[][] isObjectInCategory;
    private boolean[][] isSharingObjectsWith;
    private int[] strictCategoryOfObject;
    private int[][] objectsOfStrictCategory;
    private int[][] strictCategoriesOfCategory;
    private int[][] categoriesOfStrictCategory;
    private boolean[][] isStrictCategoryInCategory;
    private Random random;

    public int getNbObjects() {
        return this.nbObjects;
    }

    public int getNbCategories() {
        return this.nbCategories;
    }

    public int getNbStrictCategories() {
        return this.nbStrictCategories;
    }

    public int getNbObjectsOfStrictCategory(int i) {
        return this.objectsOfStrictCategory[i].length;
    }

    public int getNbSharing() {
        return this.nbSharing;
    }

    public int[][] getCategoriesOfObject() {
        return this.categoriesOfObject;
    }

    public int[] getCategoriesOfObject(int object) {
        return this.categoriesOfObject[object];
    }

    public int[][] getObjectsOfCategory() {
        return this.objectsOfCategory;
    }

    public int[] getObjectsOfCategory(int category) {
        return this.objectsOfCategory[category];
    }

    public int getObjectOfCategory(int category, int order) {
        return this.objectsOfCategory[category][order];
    }

    public int[][] getObjectsOfStrictCategory() {
        return this.objectsOfStrictCategory;
    }

    public int[] getObjectsOfStrictCategory(int strictCategory) {
        return this.objectsOfStrictCategory[strictCategory];
    }

    public boolean[][] getIsObjectInCategory() {
        return this.isObjectInCategory;
    }

    public boolean[][] getIsSharingObjectsWith() {
        return this.isSharingObjectsWith;
    }

    public int[][] getStrictCategoriesOfCategory() {
        return this.strictCategoriesOfCategory;
    }

    public int[] getStrictCategoriesOfCategory(int i) {
        return this.strictCategoriesOfCategory[i];
    }

    public int[][] getCategoriesOfStrictCategory() {
        return this.categoriesOfStrictCategory;
    }

    public int[] getCategoriesOfStrictCategory(int i) {
        return this.categoriesOfStrictCategory[i];
    }

    public boolean[][] getIsStrictCategoryInCategory() {
        return this.isStrictCategoryInCategory;
    }

    public Categories(int o, int c, int s, Random r) {
        this.nbObjects = o;
        this.nbCategories = c;
        this.nbSharing = s;
        this.random = r;
        this.buildCategories();
        this.buildStrictCategories();
    }

    public int getCategoryOfUse(int use) {
        assert (use >= 0 && use < this.nbObjects + this.nbSharing);
        int cpt = 0;
        int i = 0;
        while (i < this.objectsOfCategory.length) {
            if (use < cpt + this.objectsOfCategory[i].length) {
                return i;
            }
            cpt += this.objectsOfCategory[i].length;
            ++i;
        }
        return -1;
    }

    public int getObjectOfUse(int use) {
        assert (use >= 0 && use < this.nbObjects + this.nbSharing);
        int cpt = 0;
        int i = 0;
        while (i < this.objectsOfCategory.length) {
            if (use < cpt + this.objectsOfCategory[i].length) {
                return use - cpt;
            }
            cpt += this.objectsOfCategory[i].length;
            ++i;
        }
        return -1;
    }

    public int[][] getusesOfCategories() {
        int[][] t = new int[this.nbCategories][];
        int cpt = 0;
        int i = 0;
        while (i < t.length) {
            t[i] = new int[this.objectsOfCategory[i].length];
            int j = 0;
            while (j < t[i].length) {
                t[i][j] = cpt++;
                ++j;
            }
            ++i;
        }
        return t;
    }

    public int getNbObjectsOfCategory(int cat) {
        return this.objectsOfCategory[cat].length;
    }

    public int getNbObjectsOfCategories(int cat1, int cat2) {
        int cpt = 0;
        int i = 0;
        while (i < this.nbObjects) {
            if (this.isObjectInCategory[i][cat1] || this.isObjectInCategory[i][cat2]) {
                ++cpt;
            }
            ++i;
        }
        return cpt;
    }

    public int getNbObjectsOfCategories(int cat1, int cat2, int cat3) {
        int cpt = 0;
        int i = 0;
        while (i < this.nbObjects) {
            if (this.isObjectInCategory[i][cat1] || this.isObjectInCategory[i][cat2] || this.isObjectInCategory[i][cat3]) {
                ++cpt;
            }
            ++i;
        }
        return cpt;
    }

    public int getNbObjectsSharedByCategories(int cat1, int cat2) {
        int cpt = 0;
        int i = 0;
        while (i < this.nbObjects) {
            if (this.isObjectInCategory[i][cat1] && this.isObjectInCategory[i][cat2]) {
                ++cpt;
            }
            ++i;
        }
        return cpt;
    }

    public int getNbObjectsSharedByCategories(int cat1, int cat2, int cat3) {
        int cpt = 0;
        int i = 0;
        while (i < this.nbObjects) {
            if (this.isObjectInCategory[i][cat1] && this.isObjectInCategory[i][cat2] && this.isObjectInCategory[i][cat3]) {
                ++cpt;
            }
            ++i;
        }
        return cpt;
    }

    public int getNbStrictCategoriesOfCategory(int cat) {
        return this.strictCategoriesOfCategory[cat].length;
    }

    public int getNbStrictCategoriesOfCategories(int cat1, int cat2) {
        int cpt = 0;
        int i = 0;
        while (i < this.nbStrictCategories) {
            if (this.isStrictCategoryInCategory[i][cat1] || this.isStrictCategoryInCategory[i][cat2]) {
                ++cpt;
            }
            ++i;
        }
        return cpt;
    }

    public int getNbStrictCategoriesOfCategories(int cat1, int cat2, int cat3) {
        int cpt = 0;
        int i = 0;
        while (i < this.nbStrictCategories) {
            if (this.isStrictCategoryInCategory[i][cat1] || this.isStrictCategoryInCategory[i][cat2] || this.isStrictCategoryInCategory[i][cat3]) {
                ++cpt;
            }
            ++i;
        }
        return cpt;
    }

    private void buildIsObjectInCategory() {
        this.isObjectInCategory = new boolean[this.nbObjects][this.nbCategories];
        int i = 0;
        while (i < this.nbObjects) {
            this.isObjectInCategory[i][i % this.nbCategories] = true;
            ++i;
        }
        i = 0;
        while (i < this.nbSharing) {
            boolean performed = false;
            while (!performed) {
                int category;
                int object = this.random.nextInt(this.nbObjects);
                if (this.isObjectInCategory[object][category = this.random.nextInt(this.nbCategories)]) continue;
                this.isObjectInCategory[object][category] = true;
                performed = true;
            }
            ++i;
        }
    }

    private int computeNbCategoriesOfObject(int object) {
        int cpt = 0;
        int i = 0;
        while (i < this.nbCategories) {
            if (this.isObjectInCategory[object][i]) {
                ++cpt;
            }
            ++i;
        }
        return cpt;
    }

    private void buildCategoriesOfObject() {
        this.categoriesOfObject = new int[this.nbObjects][];
        int obj = 0;
        while (obj < this.nbObjects) {
            this.categoriesOfObject[obj] = new int[this.computeNbCategoriesOfObject(obj)];
            int cpt = 0;
            int cat = 0;
            while (cat < this.nbCategories) {
                if (this.isObjectInCategory[obj][cat]) {
                    this.categoriesOfObject[obj][cpt++] = cat;
                }
                ++cat;
            }
            ++obj;
        }
    }

    private int computeNbObjectsOfCategory(int category) {
        int cpt = 0;
        int i = 0;
        while (i < this.nbObjects) {
            if (this.isObjectInCategory[i][category]) {
                ++cpt;
            }
            ++i;
        }
        return cpt;
    }

    private void buildObjectsOfCategory() {
        this.objectsOfCategory = new int[this.nbCategories][];
        int cat = 0;
        while (cat < this.nbCategories) {
            this.objectsOfCategory[cat] = new int[this.computeNbObjectsOfCategory(cat)];
            int cpt = 0;
            int obj = 0;
            while (obj < this.nbObjects) {
                if (this.isObjectInCategory[obj][cat]) {
                    this.objectsOfCategory[cat][cpt++] = obj;
                }
                ++obj;
            }
            ++cat;
        }
    }

    private void buildIsSharingObjectsWith() {
        this.isSharingObjectsWith = new boolean[this.nbCategories][this.nbCategories];
        int i = 0;
        while (i < this.nbCategories) {
            this.isSharingObjectsWith[i][i] = true;
            ++i;
        }
        i = 0;
        while (i < this.nbCategories) {
            int j = i + 1;
            while (j < this.nbCategories) {
                boolean found = false;
                int k = 0;
                while (!found && k < this.nbObjects) {
                    if (this.isObjectInCategory[k][i] && this.isObjectInCategory[k][j]) {
                        found = true;
                    }
                    ++k;
                }
                if (found) {
                    this.isSharingObjectsWith[i][j] = true;
                    this.isSharingObjectsWith[j][i] = true;
                }
                ++j;
            }
            ++i;
        }
    }

    public void buildCategories() {
        this.buildIsObjectInCategory();
        this.buildCategoriesOfObject();
        this.buildObjectsOfCategory();
        this.buildIsSharingObjectsWith();
    }

    private int getEquivalentObjectBefore(int objectIndex) {
        int i = 0;
        while (i < objectIndex) {
            if (this.categoriesOfObject[i].length == this.categoriesOfObject[objectIndex].length) {
                boolean found = true;
                int j = 0;
                while (found && j < this.categoriesOfObject[i].length) {
                    if (this.categoriesOfObject[i][j] != this.categoriesOfObject[objectIndex][j]) {
                        found = false;
                    }
                    ++j;
                }
                if (found) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    private void buildStrictCategoryOfObject() {
        this.nbStrictCategories = 0;
        this.strictCategoryOfObject = new int[this.nbObjects];
        int i = 0;
        while (i < this.nbObjects) {
            int obj = this.getEquivalentObjectBefore(i);
            this.strictCategoryOfObject[i] = obj == -1 ? this.nbStrictCategories++ : this.strictCategoryOfObject[obj];
            ++i;
        }
    }

    private int computeNbObjectsOfStrictCategory(int strictCategory) {
        int cpt = 0;
        int i = 0;
        while (i < this.nbObjects) {
            if (this.strictCategoryOfObject[i] == strictCategory) {
                ++cpt;
            }
            ++i;
        }
        return cpt;
    }

    private void buildObjectsOfStrictCategory() {
        this.objectsOfStrictCategory = new int[this.nbStrictCategories][];
        int i = 0;
        while (i < this.nbStrictCategories) {
            this.objectsOfStrictCategory[i] = new int[this.computeNbObjectsOfStrictCategory(i)];
            int cpt = 0;
            int j = 0;
            while (j < this.nbObjects) {
                if (this.strictCategoryOfObject[j] == i) {
                    this.objectsOfStrictCategory[i][cpt++] = j;
                }
                ++j;
            }
            ++i;
        }
    }

    private int computeNbStrictCategoriesOfCategory(int category) {
        int cpt = 0;
        int i = 0;
        while (i < this.objectsOfCategory[category].length) {
            boolean found = false;
            int j = 0;
            while (!found && j < i) {
                if (this.strictCategoryOfObject[this.objectsOfCategory[category][i]] == this.strictCategoryOfObject[this.objectsOfCategory[category][j]]) {
                    found = true;
                }
                ++j;
            }
            if (!found) {
                ++cpt;
            }
            ++i;
        }
        return cpt;
    }

    private void buildStrictCategoriesOfCategory(int category) {
        this.strictCategoriesOfCategory[category] = new int[this.computeNbStrictCategoriesOfCategory(category)];
        int cpt = 0;
        int i = 0;
        while (i < this.objectsOfCategory[category].length) {
            boolean found = false;
            int j = 0;
            while (!found && j < i) {
                if (this.strictCategoryOfObject[this.objectsOfCategory[category][i]] == this.strictCategoryOfObject[this.objectsOfCategory[category][j]]) {
                    found = true;
                }
                ++j;
            }
            if (!found) {
                this.strictCategoriesOfCategory[category][cpt++] = this.strictCategoryOfObject[this.objectsOfCategory[category][i]];
            }
            ++i;
        }
    }

    private void buildStrictCategoriesOfCategory() {
        this.strictCategoriesOfCategory = new int[this.nbCategories][];
        int i = 0;
        while (i < this.nbCategories) {
            this.buildStrictCategoriesOfCategory(i);
            ++i;
        }
    }

    private void buildCategoriesOfStrictCategory(int category) {
        int oneObject = this.objectsOfStrictCategory[category][0];
        this.categoriesOfStrictCategory[category] = new int[this.categoriesOfObject[oneObject].length];
        int cpt = 0;
        int i = 0;
        while (i < this.categoriesOfObject[oneObject].length) {
            this.categoriesOfStrictCategory[category][cpt++] = this.categoriesOfObject[oneObject][i];
            ++i;
        }
    }

    private void buildCategoriesOfStrictCategory() {
        this.categoriesOfStrictCategory = new int[this.nbStrictCategories][];
        int i = 0;
        while (i < this.nbStrictCategories) {
            this.buildCategoriesOfStrictCategory(i);
            ++i;
        }
    }

    private void buildIsStrictCategoryInCategory() {
        this.isStrictCategoryInCategory = new boolean[this.nbStrictCategories][this.nbCategories];
        int i = 0;
        while (i < this.nbStrictCategories) {
            int j = 0;
            while (j < this.categoriesOfStrictCategory[i].length) {
                this.isStrictCategoryInCategory[i][this.categoriesOfStrictCategory[i][j]] = true;
                ++j;
            }
            ++i;
        }
    }

    private void buildStrictCategories() {
        this.buildStrictCategoryOfObject();
        this.buildObjectsOfStrictCategory();
        this.buildStrictCategoriesOfCategory();
        this.buildCategoriesOfStrictCategory();
        this.buildIsStrictCategoryInCategory();
    }

    public void displayArrayOfIntegers(int[][] t, String name) {
        System.out.println();
        System.out.println(name);
        int i = 0;
        while (i < t.length) {
            System.out.print(String.valueOf(i) + " => ");
            int j = 0;
            while (j < t[i].length) {
                System.out.print(String.valueOf(t[i][j]) + " ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public void displayArrayOfBooleans(boolean[][] t, String name) {
        System.out.println();
        System.out.println(name);
        int i = 0;
        while (i < t.length) {
            System.out.print(String.valueOf(i) + " => ");
            int j = 0;
            while (j < t[i].length) {
                System.out.print("(" + j + "," + (t[i][j] ? 1 : 0) + ") ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public void displayCategories() {
        this.displayArrayOfIntegers(this.categoriesOfObject, "Categories of object");
        this.displayArrayOfIntegers(this.objectsOfCategory, "Objects of category");
        this.displayArrayOfBooleans(this.isObjectInCategory, "Is object in category");
        this.displayArrayOfBooleans(this.isSharingObjectsWith, "Is sharing objects with");
    }

    private void displayStrictCategoryOfObject() {
        System.out.println();
        System.out.println("Strict category of object");
        int i = 0;
        while (i < this.nbObjects) {
            System.out.print(", " + i + " => " + this.strictCategoryOfObject[i]);
            ++i;
        }
        System.out.println();
    }

    public void displayStrictCategories() {
        this.displayStrictCategoryOfObject();
        this.displayArrayOfIntegers(this.objectsOfStrictCategory, "Objects of strict category");
        this.displayArrayOfIntegers(this.categoriesOfStrictCategory, "Categories of strict category");
        this.displayArrayOfIntegers(this.strictCategoriesOfCategory, "Strict categories of category");
        this.displayArrayOfBooleans(this.isStrictCategoryInCategory, "Is strict category in category");
    }
}

