/*
 * Decompiled with CFR 0.152.
 */
package abscon.solvers.variableManagers;

import abscon.problem.Variable;

public abstract class VariableManager {
    protected Variable[] variables;
    protected int nbDisconnectedVariables;

    public VariableManager(Variable[] variables) {
        this.variables = variables;
    }

    public int getNbDisconnectedVariables() {
        return this.nbDisconnectedVariables;
    }

    public abstract int getNbPastVariables();

    public int getNbFutureVariables() {
        return this.variables.length - this.getNbPastVariables() - this.nbDisconnectedVariables;
    }

    public boolean areAllPastVariables() {
        return this.variables.length == this.getNbPastVariables();
    }

    public void updateNbDisconnectedVariables(boolean incrementation) {
        this.nbDisconnectedVariables += incrementation ? 1 : -1;
    }

    public abstract Variable getLastPastVariable();

    public abstract Variable getPrevPastVariableBefore(Variable var1);

    public abstract Variable getFirstFutureVariable();

    public abstract Variable getNextFutureVariableAfter(Variable var1);

    public abstract int getAssignmentDepthOf(Variable var1);

    public abstract void doAPastVariableOf(Variable var1);

    public abstract void undoAPastVariableOf(Variable var1);

    public abstract void displayPastVariables();

    public abstract void displayFutureVariables();
}

