/*
 * Decompiled with CFR 0.152.
 */
package abscon.solvers.systematicSolvers;

import abscon.problem.Problem;
import abscon.propagationTechniques.forwardPropagationTechniques.ForwardPropagationTechnique;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.SingletonArcConsistency;
import abscon.propagationTechniques.supportManagers.SupportManagerOptimal;
import abscon.solvers.Statistics;
import abscon.solvers.systematicSolvers.SolutionCounter;
import abscon.solvers.systematicSolvers.SystematicSolver;
import abscon.tools.Tools;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystematicStatistics
extends Statistics {
    protected long nbBeforeSearchConstraintChecks;
    protected long nbSearchConstraintChecks;
    protected long nbSearchValidityChecks;
    protected long nbRestorations;
    protected long nbSearchPropagations;
    protected long nbSearchRevisions;
    protected long nbSearchUselessRevisions;
    protected long nbSearchSingletonTests;
    protected long nbSearchEffectiveSingletonTests;
    protected long nbConstraintChecks;
    protected long nbValidityChecks;
    protected long nbPropagations;
    protected long nbRevisions;
    protected long nbUselessRevisions;
    protected long nbAssignments;
    protected long nbFailedAssignments;
    protected long nbBacktracks;
    protected SystematicSolver solver;

    public SystematicStatistics(SystematicSolver solver) {
        super(solver);
        this.solver = solver;
    }

    @Override
    public long getNbAssignments() {
        return this.nbAssignments - this.nbSearchSingletonTests;
    }

    public long getNbFailedAssignments() {
        return this.nbFailedAssignments;
    }

    public void resetNbFailedAssignments() {
        this.nbFailedAssignments = 0L;
    }

    public long getNbBacktracks() {
        return this.nbBacktracks;
    }

    public void incrementNbAssignments() {
        ++this.nbAssignments;
    }

    public void decrementNbAssignments() {
        --this.nbAssignments;
    }

    public void incrementNbFailedAssignments() {
        ++this.nbFailedAssignments;
    }

    public void incrementNbBacktracks() {
        ++this.nbBacktracks;
    }

    @Override
    public long getNbConstraintChecks() {
        return this.nbPreproConstraintChecks + this.nbBeforeSearchConstraintChecks + this.nbSearchConstraintChecks;
    }

    @Override
    public long getNbValidityChecks() {
        return this.nbPreproValidityChecks + this.nbSearchValidityChecks;
    }

    @Override
    public long getNbPropagations() {
        return this.nbPreproPropagations + this.nbSearchPropagations;
    }

    @Override
    public long getNbRevisions() {
        return this.nbPreproRevisions + this.nbSearchRevisions;
    }

    @Override
    public long getNbUselessRevisions() {
        return this.nbPreproUselessRevisions + this.nbSearchUselessRevisions;
    }

    public void setNbBeforeSearchConstraintChecks(long l) {
        this.nbBeforeSearchConstraintChecks = l;
    }

    @Override
    protected void manageAfterPreprocessing(boolean preproConsistency) {
        super.manageAfterPreprocessing(preproConsistency);
        this.nbAssignments = 0L;
    }

    @Override
    protected void manageAfterSearch() {
        ForwardPropagationTechnique fpt;
        Problem problem = this.solver.getProblem();
        this.searchCpuTime = this.stopwatch.getCurrentCpuTime();
        this.searchWckTime = this.stopwatch.getCurrentWallClockTime();
        this.nbSearchConstraintChecks += problem.getNbConstraintChecks();
        this.nbSearchValidityChecks += problem.getNbValidityChecks();
        if (problem.getSolver().getSearchPropagationTechnique() instanceof ForwardPropagationTechnique && (fpt = (ForwardPropagationTechnique)problem.getSolver().getSearchPropagationTechnique()).getSupportManager() instanceof SupportManagerOptimal) {
            this.nbRestorations += (long)((SupportManagerOptimal)fpt.getSupportManager()).getNbEffectiveRestorations();
        }
        this.nbSearchPropagations += this.solver.getSearchPropagationTechnique().getNbPropagations();
        this.nbSearchRevisions += this.solver.getSearchPropagationTechnique().getNbRevisions();
        this.nbSearchUselessRevisions += this.solver.getSearchPropagationTechnique().getNbUselessRevisions();
        if (this.solver.getSearchPropagationTechnique() instanceof SingletonArcConsistency) {
            this.nbSearchSingletonTests += ((SingletonArcConsistency)this.solver.getSearchPropagationTechnique()).getNbSingletonTests();
            this.nbSearchEffectiveSingletonTests += ((SingletonArcConsistency)this.solver.getSearchPropagationTechnique()).getNbEffectiveSingletonTests();
        }
        this.nbConstraintChecks += this.nbPreproConstraintChecks + this.nbSearchConstraintChecks;
        this.nbValidityChecks += this.nbPreproValidityChecks + this.nbSearchValidityChecks;
        this.nbPropagations += this.nbPreproPropagations + this.nbSearchPropagations;
        this.nbRevisions += this.nbPreproRevisions + this.nbSearchRevisions;
        this.nbUselessRevisions += this.nbPreproUselessRevisions + this.nbSearchUselessRevisions;
    }

    @Override
    public Map<String, String> getMapOfSearchAttributes() {
        SolutionCounter solutionCounter;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int run = this.solver.getRestarter().getCurrentRun();
        map.put("run", String.valueOf(run));
        map.put("nbConstraintChecks", String.valueOf(this.nbSearchConstraintChecks));
        if (this.nbSearchValidityChecks > 0L) {
            map.put("nbValidityChecks", String.valueOf(this.nbSearchValidityChecks));
        }
        if (this.nbBeforeSearchConstraintChecks != 0L) {
            map.put("nbBeforeConstraintsChecks", String.valueOf(this.nbBeforeSearchConstraintChecks));
        }
        map.put("nbPropagations", String.valueOf(this.nbSearchPropagations));
        map.put("nbRevisions", String.valueOf(this.nbSearchRevisions));
        map.put("nbUselessRevisions", String.valueOf(this.nbSearchUselessRevisions));
        if (this.nbSearchSingletonTests > 0L) {
            map.put("nbSingletonTests", String.valueOf(this.nbSearchSingletonTests));
            map.put("nbEffectiveSingletonTests", String.valueOf(this.nbSearchEffectiveSingletonTests));
        }
        map.put("nbAssignments", String.valueOf(this.getNbAssignments()));
        map.put("nbFailedAssignments", String.valueOf(this.nbFailedAssignments));
        map.put("nbBacktracks", String.valueOf(this.nbBacktracks));
        map.put("nbVisitedNodes", String.valueOf(this.solver.getNbVisitedNodes()));
        if (this.solver.getNogoodManager() != null) {
            map.put("nbRestartNogoods", String.valueOf(this.solver.getNogoodManager().getNbNogoods()));
        }
        if ((solutionCounter = this.solver.getSolutionCounter()) != null && !solutionCounter.isStopped()) {
            map.put("mapSize", String.valueOf(solutionCounter.getMapSize()));
            map.put("nbInferences", String.valueOf(solutionCounter.getNbInferences()));
            map.put("nbTooLargeKeys", String.valueOf(solutionCounter.getNbTooLargeKeys()));
        }
        map.put("wckTime", String.valueOf((double)this.searchWckTime / 1000.0));
        map.put("cpuTime", String.valueOf((double)this.searchCpuTime / 1000.0));
        map.put("mem", Tools.getFormattedUsedMemorySize());
        return map;
    }

    @Override
    public Map<String, String> getMapOfCumulatedAttributes() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("nbConstraintChecks", String.valueOf(this.getNbConstraintChecks()));
        if (this.getNbValidityChecks() > 0L) {
            map.put("nbValidityChecks", String.valueOf(this.getNbValidityChecks()));
        }
        if (this.getNbPropagations() > 0L) {
            map.put("nbPropagations", String.valueOf(this.getNbPropagations()));
        }
        if (this.getNbRevisions() > 0L) {
            map.put("nbRevisions", String.valueOf(this.getNbRevisions()));
            map.put("nbUselessRevisions", String.valueOf(this.getNbUselessRevisions()));
        }
        if (this.solver.getNogoodManager() != null) {
            map.put("nbRestartNogoods", String.valueOf(this.solver.getNogoodManager().getNbNogoods()));
        }
        return map;
    }
}

