/*
 * Decompiled with CFR 0.152.
 */
package abscon.solvers.systematicSolvers;

import abscon.Resolution;
import abscon.constants.AbsconConstants;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.heuristics.variableOrdering.VariableOrderingHeuristic;
import abscon.problem.Variable;
import abscon.propagationTechniques.PropagationTechnique;
import abscon.propagationTechniques.backwardPropagationTechniques.Backtracking0;
import abscon.propagationTechniques.forwardPropagationTechniques.ArcConsistency;
import abscon.propagationTechniques.forwardPropagationTechniques.ForwardPropagationTechnique;
import abscon.propagationTechniques.forwardPropagationTechniques.fc.ForwardChecking0;
import abscon.propagationTechniques.propagationSets.NewPropagationSet;
import abscon.propagationTechniques.propagationSets.PropagationSetOfVariablesNogood;
import abscon.propagationTechniques.substitutabilityManagers.SubstitutabilityManager;
import abscon.solvers.GraphManager;
import abscon.solvers.Solver;
import abscon.solvers.systematicSolvers.CulpritManager;
import abscon.solvers.systematicSolvers.DecisionManager;
import abscon.solvers.systematicSolvers.Disconnector;
import abscon.solvers.systematicSolvers.HyperNogoodManager;
import abscon.solvers.systematicSolvers.NogoodManager;
import abscon.solvers.systematicSolvers.SolutionCounter;
import abscon.solvers.systematicSolvers.SystematicStatistics;
import abscon.solvers.variableManagers.GlobalVariableManager;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.Stopwatch;
import abscon.tools.Tools;
import abscon.tools.absconParameters.ConfigurationManager;
import abscon.tools.elements.Elements;
import abscon.tools.reflection.Factory;

public abstract class SystematicSolver
extends Solver {
    protected VariableManager variableManager;
    protected VariableOrderingHeuristic variableOrderingHeuristic;
    private SubstitutabilityManager substitutabilityManager;
    protected Disconnector disconnector;
    protected CulpritManager culpritManager;
    protected DecisionManager decisionManager;
    private SolutionCounter solutionCounter;
    protected NogoodManager nogoodManager;
    protected int backtrackingMode;
    protected SystematicStatistics systematicStatistics;
    protected GraphManager graphManager;
    private int forcedDepth = -1;
    private int restarterMode;
    private boolean test = false;
    private HyperNogoodManager hnm;
    private int cptI = 0;
    private int lastMode;
    private Variable lastRefutationVariable;
    private Variable lastFailedAssignedVariable;
    Stopwatch st = new Stopwatch();

    public SolutionCounter getSolutionCounter() {
        return this.solutionCounter;
    }

    public NogoodManager getNogoodManager() {
        return this.nogoodManager;
    }

    public void attachTo(Resolution resolution, int levelInResolution) {
        int nogoodRecordingMode;
        String s = ConfigurationManager.getString(levelInResolution, "search/backtrackingMode", "value");
        this.backtrackingMode = AbsconConstants.getBacktrackingModeFor(s);
        int elems = ConfigurationManager.getInt(levelInResolution, "problem/elements", "type");
        if (this.backtrackingMode != 10 && elems != 1) {
            throw new IncompatiblePropertiesException();
        }
        super.attachTo(resolution, levelInResolution);
        this.systematicStatistics = new SystematicStatistics(this);
        this.statistics = this.systematicStatistics;
        this.variableManager = new GlobalVariableManager(this.variables);
        if (this.doSearch) {
            String className;
            boolean similar = ConfigurationManager.getBoolean(levelInResolution, "similarPreproAndSearchParameters", "value");
            if (resolution.isCompetition() && (long)this.getProblem().getNbCurrentValues() > 50000L) {
                similar = true;
            }
            if (this.doPrepro && similar) {
                this.searchPropagationTechnique = this.preproPropagationTechnique;
            } else {
                className = ConfigurationManager.getString(levelInResolution, "search/propagationTechnique", "class");
                this.searchPropagationTechnique = (PropagationTechnique)Factory.getInstanceOf(className, PropagationTechnique.class);
                this.searchPropagationTechnique.attachTo(this);
            }
            className = ConfigurationManager.getString(levelInResolution, "search/variableHeuristic", "class");
            this.variableOrderingHeuristic = (VariableOrderingHeuristic)Factory.getInstanceOf(className, VariableOrderingHeuristic.class);
            this.variableOrderingHeuristic.attachTo(this);
            int i = 0;
            while (i < this.variables.length) {
                this.variables[i].setValueOrderingHeuristic();
                ++i;
            }
        }
        if ((nogoodRecordingMode = ConfigurationManager.getInt(levelInResolution, "search/nogoodRecording", "mode")) != 0) {
            if (this.doPrepro && !(this.preproPropagationTechnique.getPropagationSet() instanceof PropagationSetOfVariablesNogood) && !(this.preproPropagationTechnique.getPropagationSet() instanceof NewPropagationSet)) {
                throw new IncompatiblePropertiesException();
            }
            if (this.doSearch && !(this.searchPropagationTechnique.getPropagationSet() instanceof PropagationSetOfVariablesNogood) && !(this.searchPropagationTechnique.getPropagationSet() instanceof NewPropagationSet)) {
                throw new IncompatiblePropertiesException();
            }
            this.decisionManager = new DecisionManager(this);
            if (this.decisionManager.isUnexploitable()) {
                this.decisionManager = null;
            } else {
                this.nogoodManager = new NogoodManager(this, this.decisionManager, 10000, Integer.MAX_VALUE);
                if (this.doPrepro) {
                    if (this.preproPropagationTechnique.getPropagationSet() instanceof PropagationSetOfVariablesNogood) {
                        ((PropagationSetOfVariablesNogood)this.preproPropagationTechnique.getPropagationSet()).setNogoodManager(this.nogoodManager);
                    } else {
                        ((NewPropagationSet)this.preproPropagationTechnique.getPropagationSet()).setNogoodManager(this.nogoodManager);
                    }
                }
                if (this.doSearch) {
                    if (this.searchPropagationTechnique.getPropagationSet() instanceof PropagationSetOfVariablesNogood) {
                        ((PropagationSetOfVariablesNogood)this.searchPropagationTechnique.getPropagationSet()).setNogoodManager(this.nogoodManager);
                    } else {
                        ((NewPropagationSet)this.searchPropagationTechnique.getPropagationSet()).setNogoodManager(this.nogoodManager);
                    }
                }
            }
        }
        this.disconnector = new Disconnector(this);
        this.culpritManager = new CulpritManager(this, this.backtrackingMode != 10);
        this.lastMode = ConfigurationManager.getInt(0, "search/variableHeuristic", "last");
        int solutionCounterMode = ConfigurationManager.getInt(0, "search/solutionCounter", "mode");
        if (solutionCounterMode > 0) {
            this.solutionCounter = new SolutionCounter(this, solutionCounterMode);
        }
        if (this.test) {
            this.hnm = new HyperNogoodManager(this);
            ((NewPropagationSet)this.preproPropagationTechnique.getPropagationSet()).setHyperNogoodManager(this.hnm);
        }
        this.restarterMode = ConfigurationManager.getInt(levelInResolution, "search/restarts", "mode");
    }

    public VariableManager getVariableManager() {
        return this.variableManager;
    }

    public VariableOrderingHeuristic getVariableOrderingHeuristic() {
        return this.variableOrderingHeuristic;
    }

    public int getBacktrackingMode() {
        return this.backtrackingMode;
    }

    public SystematicStatistics getTreeStatistics() {
        return (SystematicStatistics)this.statistics;
    }

    public Variable getFirstFutureVariable() {
        return this.variableManager.getFirstFutureVariable();
    }

    public Variable getNextFutureVariableAfter(Variable futureVariable) {
        return this.variableManager.getNextFutureVariableAfter(futureVariable);
    }

    public int getNbPastVariables() {
        return this.variableManager.getNbPastVariables();
    }

    public int getNbFutureVariables() {
        return this.variableManager.getNbFutureVariables();
    }

    public void setDepth(int depth) {
        this.forcedDepth = depth;
    }

    public void unSetDepth() {
        this.forcedDepth = -1;
    }

    public int getCurrentDepth() {
        return this.forcedDepth < 0 ? this.variableManager.getNbPastVariables() : this.forcedDepth;
    }

    public long getRestartCounter() {
        if (this.restarterMode == 0) {
            return this.systematicStatistics.getNbFailedAssignments();
        }
        return this.systematicStatistics.getNbBacktracks();
    }

    public void doAssignment(Variable variable, int index) {
        assert (variable.getCurrentDomainSize() > 0);
        assert (this.controlAllExplanations());
        this.systematicStatistics.incrementNbAssignments();
        this.variableManager.doAPastVariableOf(variable);
        variable.doAssignment(index);
    }

    public void undoAssignmentOf(Variable variable) {
        this.variableManager.undoAPastVariableOf(variable);
        variable.undoAssignment();
        assert (variable.isFuture());
    }

    protected void undoPropagationAt(int depth) {
        Variable futureVariable = this.variableManager.getFirstFutureVariable();
        while (futureVariable != null) {
            futureVariable.getDomain().restoreElementsRemovedAtLevelGreaterThanOrEqualTo(depth);
            futureVariable = this.variableManager.getNextFutureVariableAfter(futureVariable);
        }
    }

    public void undoPropagationOf(Variable variable) {
        if (this.backtrackingMode == 10) {
            this.undoPropagationAt(this.getCurrentDepth() + 1);
        } else {
            int i = 0;
            while (i < this.variables.length) {
                this.variables[i].getDomain().getExplanations().removeExplanationsSetFrom(variable);
                ++i;
            }
        }
    }

    protected void dealWithNoMoreFutureVariables() {
        if (this.disconnector.getNbDisconnectedVariables() == 0) {
            this.dealWithNewSolution();
        } else {
            this.disconnector.findSolutionUsingSingletons();
        }
        if (this.variableManager.getNbPastVariables() == 0) {
            this.fullExploration = true;
        } else {
            this.culpritManager.setCulpritVariablesTo(this.variables);
        }
    }

    private void displayStateNogoodStatistics() {
        if (!this.test) {
            return;
        }
        System.out.println("cptI " + this.cptI + " used mem = " + Tools.getFormattedUsedMemorySize());
    }

    protected void manageEmptyDomainOf(Variable variable) {
        this.systematicStatistics.incrementNbBacktracks();
        if (this.solutionCounter != null) {
            this.solutionCounter.dealWhenClosingNode();
        }
        if (this.hnm != null) {
            this.hnm.moveWaitingNogoodFrom(this.getCurrentDepth());
        }
        this.culpritManager.fixCulpritVariablesFromEmptyDomainOf(variable);
        if (this.culpritManager.getNbCulpritVariables() == 0) {
            this.fullExploration = true;
        }
    }

    public Variable getLastConflictPriorityVariable() {
        if (this.lastFailedAssignedVariable != null) {
            return this.lastFailedAssignedVariable;
        }
        if (this.lastMode == 2 && this.lastRefutationVariable != null && !this.lastRefutationVariable.isAssigned()) {
            return this.lastRefutationVariable;
        }
        return null;
    }

    protected boolean tryAssignment(Variable variable, int index) {
        if (this.decisionManager != null) {
            this.decisionManager.addPositiveDecision(variable, index);
        }
        this.lastFailedAssignedVariable = variable;
        this.doAssignment(variable, index);
        ++this.nbVisitedNodes;
        if (!this.searchPropagationTechnique.checkConsistencyAfterAssignmentOf(variable)) {
            this.systematicStatistics.incrementNbFailedAssignments();
            this.culpritManager.establishCulpritVariablesOfInconsistency();
            if (this.nogoodManager != null) {
                this.nogoodManager.addCurrentNogood();
            }
            return false;
        }
        if (!this.getProblem().mustContinue()) {
            this.systematicStatistics.incrementNbFailedAssignments();
            this.culpritManager.setCulpritVariablesToPastVariables();
            return false;
        }
        if (this.solutionCounter != null && !this.solutionCounter.dealWhenOpeningNode()) {
            return false;
        }
        if (this.hnm != null) {
            this.hnm.putAtLevel(this.getCurrentDepth());
        }
        this.lastFailedAssignedVariable = null;
        return true;
    }

    protected boolean tryRefutation(Variable variable, int index, int depth, boolean first) {
        if (this.lastFailedAssignedVariable != null && variable != this.lastFailedAssignedVariable) {
            this.lastRefutationVariable = variable;
        }
        if (this.decisionManager != null) {
            this.decisionManager.replacePositiveByNegativeDecision(variable, index);
        }
        variable.getDomain().removeElementAt(index, this.culpritManager.getCulpritVariables(), this.culpritManager.getNbCulpritVariables());
        if (variable.getCurrentDomainSize() == 0) {
            this.manageEmptyDomainOf(variable);
            return false;
        }
        if (this.backtrackingMode != 10 && !(this.searchPropagationTechnique instanceof Backtracking0)) {
            if (this.backtrackingMode == 12) {
                this.searchPropagationTechnique.getPropagationSet().fill();
            } else if (!first && !(this.searchPropagationTechnique instanceof ForwardChecking0)) {
                this.searchPropagationTechnique.getPropagationSet().fill();
            }
        }
        ++this.nbVisitedNodes;
        if (!this.searchPropagationTechnique.checkConsistencyAfterRefutationOf(variable, depth)) {
            this.manageEmptyDomainOf((Variable)this.searchPropagationTechnique.getCulprit());
            return false;
        }
        return true;
    }

    protected abstract Variable searchAtNextDepth();

    protected void restoreProblem() {
        if (this.hnm != null) {
            this.hnm.displayStats();
        }
        Variable pastVariable = this.variableManager.getLastPastVariable();
        while (pastVariable != null) {
            this.disconnector.tryReconnectingSingletons();
            this.undoAssignmentOf(pastVariable);
            this.undoPropagationOf(pastVariable);
            pastVariable = this.variableManager.getPrevPastVariableBefore(pastVariable);
        }
        this.disconnector.tryReconnectingSingletons();
        if (!(this.fullExploration || this.resolution.isFinished() || this.restarter.isFinished())) {
            return;
        }
        if (this.backtrackingMode != 12) {
            this.undoPropagationAt(0);
        } else {
            int i = 0;
            while (i < this.variables.length) {
                Elements elements = this.variables[i].getDomain().getElements();
                int index = elements.getLastAbsent();
                while (index != -1) {
                    this.variables[i].getDomain().getExplanations().removeDefinitiveExplanationOf(index);
                    index = elements.getPrevAbsent(index);
                }
                ++i;
            }
        }
        assert (this.getProblem().controlFullDomains());
        assert (this.controlAllExplanations());
        assert (this.disconnector.getNbDisconnectedVariables() == 0) : this.disconnector;
    }

    protected void doRun() {
        assert (((ForwardPropagationTechnique)this.searchPropagationTechnique).getSupportManager().controlSupports());
        if (this.decisionManager != null) {
            this.decisionManager.reset();
        }
        this.variableOrderingHeuristic.initializeBeforeSearch();
        int i = 0;
        while (i < this.variables.length) {
            this.variables[i].getValueOrderingHeuristic().initializeBeforeRun();
            ++i;
        }
        this.searchPropagationTechnique.initializeBeforeRun();
        this.searchAtNextDepth();
        this.restoreProblem();
        this.displayStateNogoodStatistics();
    }

    private int searchTransitionDecision(int left, int right, int[] decisions, int nbDecisions, int limitDepth) {
        boolean consistent = true;
        while (left < right && consistent) {
            Variable variable = this.variables[this.decisionManager.getVariableInDecision(decisions[left]).getId()];
            int index = this.decisionManager.getIndexInDecision(decisions[left]);
            if (decisions[left] > 0) {
                if (!variable.getDomain().hasIndex(index)) {
                    consistent = false;
                } else {
                    this.doAssignment(variable, index);
                    consistent = this.searchPropagationTechnique.checkConsistencyAfterAssignmentOf(variable);
                }
            } else if (variable.getDomain().getCurrentSize() == 1 && variable.getDomain().hasIndex(index)) {
                consistent = false;
            } else if (variable.getDomain().hasIndex(index)) {
                variable.getDomain().removeElementAt(index);
                boolean bl = consistent = variable.getCurrentDomainSize() > 0 && this.searchPropagationTechnique.checkConsistencyAfterRefutationOf(variable, this.getCurrentDepth());
            }
            assert (!consistent || !(this.searchPropagationTechnique instanceof ArcConsistency) || ((ArcConsistency)this.searchPropagationTechnique).controlConsistency(false));
            ++left;
        }
        if (left == nbDecisions - 1 && consistent) {
            return -1;
        }
        assert (!consistent && left - 1 < right) : "cons = " + consistent + " lastPositive = " + (left - 1);
        Variable pastVariable = this.variableManager.getLastPastVariable();
        while (pastVariable != null) {
            if (this.getCurrentDepth() == limitDepth - 1) break;
            this.undoAssignmentOf(pastVariable);
            this.undoPropagationOf(pastVariable);
            pastVariable = this.variableManager.getPrevPastVariableBefore(pastVariable);
        }
        return left - 1;
    }

    private boolean addTransitionDecisionTo(int indexOfLastTransitionDecision, int[] tmp, int nbFoundTransitionDecisions, int[] decisions, int nbDecisions) {
        tmp[nbFoundTransitionDecisions] = decisions[indexOfLastTransitionDecision];
        int limit = Math.max(0, nbFoundTransitionDecisions - 1);
        while (tmp[limit] < 0) {
            --limit;
        }
        int i = limit;
        while (i < nbFoundTransitionDecisions) {
            boolean consistent;
            Variable variable = this.variables[this.decisionManager.getVariableInDecision(tmp[i]).getId()];
            int index = this.decisionManager.getIndexInDecision(tmp[i]);
            if (tmp[i] > 0) {
                assert (variable.getDomain().hasIndex(index));
                this.doAssignment(variable, index);
                consistent = this.searchPropagationTechnique.checkConsistencyAfterAssignmentOf(variable);
                assert (consistent);
            } else {
                assert (variable.getDomain().getCurrentSize() > 1 || !variable.getDomain().hasIndex(index));
                if (variable.getDomain().hasIndex(index)) {
                    variable.getDomain().removeElementAt(index);
                    boolean bl = consistent = variable.getCurrentDomainSize() > 0 && this.searchPropagationTechnique.checkConsistencyAfterRefutationOf(variable, this.getCurrentDepth());
                    assert (consistent);
                }
            }
            ++i;
        }
        Variable variable = this.variables[this.decisionManager.getVariableInDecision(decisions[indexOfLastTransitionDecision]).getId()];
        int index = this.decisionManager.getIndexInDecision(decisions[indexOfLastTransitionDecision]);
        boolean consistent = true;
        if (decisions[indexOfLastTransitionDecision] > 0) {
            if (!variable.getDomain().hasIndex(index)) {
                return false;
            }
            this.doAssignment(variable, index);
            consistent = this.searchPropagationTechnique.checkConsistencyAfterAssignmentOf(variable);
        } else {
            if (variable.getDomain().getCurrentSize() == 1 && variable.getDomain().hasIndex(index)) {
                return false;
            }
            if (variable.getDomain().hasIndex(index)) {
                variable.getDomain().removeElementAt(index);
                consistent = variable.getCurrentDomainSize() > 0 && this.searchPropagationTechnique.checkConsistencyAfterRefutationOf(variable, this.getCurrentDepth());
            }
        }
        return consistent;
    }

    private boolean addPositiveTransitionDecisionTo(int positiveDecision, int[] tmp, int nbFoundTransitionDecisions) {
        tmp[nbFoundTransitionDecisions] = positiveDecision;
        Variable variable = this.variables[this.decisionManager.getVariableInDecision(positiveDecision).getId()];
        int index = this.decisionManager.getIndexInDecision(positiveDecision);
        if (!variable.getDomain().hasIndex(index)) {
            return false;
        }
        this.doAssignment(variable, index);
        return this.searchPropagationTechnique.checkConsistencyAfterAssignmentOf(variable);
    }

    private int searchPositiveTransitionDecision(int right, int[] decisions, int limitDepth) {
        boolean consistent = true;
        int left = 0;
        while (consistent && left < right) {
            Variable variable = this.variables[this.decisionManager.getVariableInDecision(decisions[left]).getId()];
            int index = this.decisionManager.getIndexInDecision(decisions[left]);
            if (!variable.getDomain().hasIndex(index)) {
                consistent = false;
            } else {
                this.doAssignment(variable, index);
                consistent = this.searchPropagationTechnique.checkConsistencyAfterAssignmentOf(variable);
            }
            assert (!consistent || !(this.searchPropagationTechnique instanceof ArcConsistency) || ((ArcConsistency)this.searchPropagationTechnique).controlConsistency(false));
            ++left;
        }
        if (consistent) {
            return -1;
        }
        Variable pastVariable = this.variableManager.getLastPastVariable();
        while (pastVariable != null) {
            if (this.getCurrentDepth() == limitDepth - 1) break;
            this.undoAssignmentOf(pastVariable);
            this.undoPropagationOf(pastVariable);
            pastVariable = this.variableManager.getPrevPastVariableBefore(pastVariable);
        }
        return left - 1;
    }

    /*
     * Unable to fully structure code
     */
    public int[] extractMinimalFrom(int[] decisions) {
        tmp = new int[decisions.length];
        positionOfLastFoundTransitionDecision = decisions.length - 1;
        nbFoundTransitionDecisions = 0;
        if (backgroundConsistent = this.addPositiveTransitionDecisionTo(decisions[positionOfLastFoundTransitionDecision], tmp, nbFoundTransitionDecisions++)) ** GOTO lbl21
        lastPastVariable = this.variableManager.getLastPastVariable();
        index = lastPastVariable.getDomain().getUniqueIndex();
        this.undoAssignmentOf(lastPastVariable);
        this.undoPropagationOf(lastPastVariable);
        lastPastVariable.getDomain().removeElementAt(index);
        v0 = backgroundConsistent = lastPastVariable.getCurrentDomainSize() > 0 && this.searchPropagationTechnique.checkConsistencyAfterRefutationOf(lastPastVariable, this.getCurrentDepth()) != false;
        if (!backgroundConsistent) {
            System.out.println("FINI");
            this.fullExploration = true;
            return new int[0];
        }
        return null;
lbl-1000:
        // 1 sources

        {
            if (positionOfLastFoundTransitionDecision == 1) {
                tmp[nbFoundTransitionDecisions++] = decisions[0];
                break;
            }
            if ((positionOfLastFoundTransitionDecision = this.searchPositiveTransitionDecision(positionOfLastFoundTransitionDecision, decisions, this.getCurrentDepth())) == -1) continue;
            backgroundConsistent = this.addPositiveTransitionDecisionTo(decisions[positionOfLastFoundTransitionDecision], tmp, nbFoundTransitionDecisions++);
lbl21:
            // 3 sources

            ** while (backgroundConsistent && positionOfLastFoundTransitionDecision > 0 && nbFoundTransitionDecisions < NogoodManager.NOGOOD_SIZE_LIMIT)
        }
lbl22:
        // 2 sources

        pastVariable = this.variableManager.getLastPastVariable();
        while (pastVariable != null) {
            this.undoAssignmentOf(pastVariable);
            this.undoPropagationOf(pastVariable);
            pastVariable = this.variableManager.getPrevPastVariableBefore(pastVariable);
        }
        if (positionOfLastFoundTransitionDecision == -1) {
            t = new int[decisions.length + 2];
            i = 0;
            while (i < decisions.length) {
                t[i + 2] = -decisions[i];
                ++i;
            }
            return t;
        }
        t = new int[nbFoundTransitionDecisions + 2];
        i = 2;
        while (i < t.length) {
            t[i] = -tmp[i - 2];
            ++i;
        }
        return t;
    }

    public int[] extractMinimalFrom(SystematicSolver solver, int[] decisions, int nbDecisions) {
        this.searchPropagationTechnique.getPropagationSet().clear();
        int i = 0;
        while (i < this.variables.length) {
            Elements elements = solver.getVariable(i).getDomain().getElements();
            Elements auxiliaryElements = this.getVariable(i).getDomain().getElements();
            int index = elements.getLastAbsent();
            while (index != -1) {
                if (elements.getAbsentLevelOf(index) == 0) {
                    auxiliaryElements.remove(index, 0);
                }
                index = elements.getPrevAbsent(index);
            }
            ++i;
        }
        int[] tmp = new int[nbDecisions];
        int nbFoundTransitionDecisions = 0;
        boolean consistent = this.addTransitionDecisionTo(nbDecisions - 1, tmp, nbFoundTransitionDecisions++, decisions, nbDecisions);
        int initialLeftOffset = 0;
        while (decisions[initialLeftOffset] < 0) {
            ++initialLeftOffset;
        }
        int right = nbDecisions - 1;
        while (consistent && nbFoundTransitionDecisions < NogoodManager.NOGOOD_SIZE_LIMIT && initialLeftOffset < right) {
            assert (decisions[initialLeftOffset] > 0);
            int IndexOfTransitionDecision = this.searchTransitionDecision(initialLeftOffset, right, decisions, nbDecisions, this.getCurrentDepth());
            if (IndexOfTransitionDecision == -1) {
                right = -1;
                continue;
            }
            right = IndexOfTransitionDecision;
            consistent = this.addTransitionDecisionTo(IndexOfTransitionDecision, tmp, nbFoundTransitionDecisions++, decisions, nbDecisions);
        }
        Variable pastVariable = this.variableManager.getLastPastVariable();
        while (pastVariable != null) {
            this.undoAssignmentOf(pastVariable);
            this.undoPropagationOf(pastVariable);
            pastVariable = this.variableManager.getPrevPastVariableBefore(pastVariable);
        }
        this.undoPropagationAt(0);
        assert (this.getProblem().controlFullDomains());
        if (consistent && nbFoundTransitionDecisions >= NogoodManager.NOGOOD_SIZE_LIMIT || right == -1 && nbDecisions >= NogoodManager.NOGOOD_SIZE_LIMIT) {
            return null;
        }
        if (right == -1) {
            int nbPositiveDecisions = 0;
            int i2 = 0;
            while (i2 < nbDecisions) {
                if (decisions[i2] > 0) {
                    ++nbPositiveDecisions;
                }
                ++i2;
            }
            int[] t = new int[nbPositiveDecisions + 2];
            int cpt = 2;
            int i3 = 0;
            while (i3 < nbDecisions) {
                if (decisions[i3] > 0) {
                    t[cpt++] = -decisions[i3];
                }
                ++i3;
            }
            return t;
        }
        int[] t = new int[nbFoundTransitionDecisions + 2];
        int i4 = 2;
        while (i4 < t.length) {
            t[i4] = -tmp[i4 - 2];
            ++i4;
        }
        return t;
    }

    public void removeInconsistentValue(Variable variable, int index) {
    }

    public boolean controlMinimalNogood(SystematicSolver solver, int[] t) {
        if (t == null) {
            return true;
        }
        this.searchPropagationTechnique.getPropagationSet().clear();
        int i = 0;
        while (i < this.variables.length) {
            Elements elements = solver.getVariable(i).getDomain().getElements();
            Elements auxiliaryElements = this.getVariable(i).getDomain().getElements();
            int index = elements.getLastAbsent();
            while (index != -1) {
                if (elements.getAbsentLevelOf(index) == 0) {
                    auxiliaryElements.remove(index, 0);
                }
                index = elements.getPrevAbsent(index);
            }
            ++i;
        }
        boolean notMinimal = false;
        int i2 = 2;
        while (!notMinimal && i2 < t.length) {
            boolean consistent;
            int decision = -t[i2];
            Variable variable = this.variables[this.decisionManager.getVariableInDecision(decision).getId()];
            int index = this.decisionManager.getIndexInDecision(decision);
            if (decision > 0) {
                if (!variable.getDomain().hasIndex(index)) {
                    if (i2 != t.length - 1) {
                        System.out.println("nogood not minimal 1 " + variable + " " + index);
                        notMinimal = true;
                    }
                } else {
                    this.doAssignment(variable, index);
                    consistent = this.searchPropagationTechnique.checkConsistencyAfterAssignmentOf(variable);
                    if (!consistent && i2 != t.length - 1) {
                        System.out.println("nogood not minimal 2 " + variable + " " + index);
                        notMinimal = true;
                    }
                }
            } else if (variable.getDomain().getCurrentSize() == 1 && variable.getDomain().hasIndex(index)) {
                if (i2 != t.length - 1) {
                    System.out.println("nogood not minimal 3 " + variable + " " + index);
                    notMinimal = true;
                }
            } else if (variable.getDomain().hasIndex(index)) {
                variable.getDomain().removeElementAt(index);
                boolean bl = consistent = variable.getCurrentDomainSize() > 0 && this.searchPropagationTechnique.checkConsistencyAfterRefutationOf(variable, this.getCurrentDepth());
                if (!consistent && i2 != t.length - 1) {
                    System.out.println("nogood not minimal 4 " + variable + " " + index);
                    notMinimal = true;
                }
            }
            ++i2;
        }
        Variable pastVariable = this.variableManager.getLastPastVariable();
        while (pastVariable != null) {
            this.undoAssignmentOf(pastVariable);
            this.undoPropagationOf(pastVariable);
            pastVariable = this.variableManager.getPrevPastVariableBefore(pastVariable);
        }
        this.undoPropagationAt(0);
        assert (this.getProblem().controlFullDomains());
        return !notMinimal;
    }

    public void displayAssignments() {
        System.out.println("Current Assignment with " + this.variableManager.getNbPastVariables() + " past variables");
        int i = 0;
        while (i < this.variables.length) {
            if (this.variables[i].isAssigned()) {
                System.out.print(String.valueOf(this.getProblem().getStringAssignment(this.variables[i], this.variables[i].getDomain().getUniqueValue())) + " ");
            }
            ++i;
        }
        System.out.println();
    }

    public boolean controlAllExplanations() {
        int i = 0;
        while (i < this.variables.length) {
            if (!this.variables[i].getDomain().controlExplanations()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void dealWithNewSolution() {
        super.dealWithNewSolution();
    }

    public int doGreedy(int[] variableIds, int[] indexes, int limit) {
        int i = 0;
        int max = limit;
        while (i <= max) {
            if (!this.variables[variableIds[i]].getDomain().hasIndex(indexes[i])) break;
            this.doAssignment(this.variables[variableIds[i]], indexes[i]);
            if (!this.searchPropagationTechnique.checkConsistencyAfterAssignmentOf(this.variables[variableIds[i]])) break;
            ++i;
        }
        if (i > limit) {
            --i;
        }
        Variable pastVariable = this.variableManager.getLastPastVariable();
        while (pastVariable != null) {
            this.undoAssignmentOf(pastVariable);
            this.undoPropagationOf(pastVariable);
            pastVariable = this.variableManager.getPrevPastVariableBefore(pastVariable);
        }
        return i;
    }
}

