/*
 * Decompiled with CFR 0.152.
 */
package abscon.solvers.systematicSolvers;

import abscon.exceptions.UnreachableCodeException;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;
import abscon.propagationTechniques.propagationSets.PropagationSet;
import abscon.solvers.systematicSolvers.DecisionManager;
import abscon.solvers.systematicSolvers.SystematicSolver;
import abscon.tools.absconParameters.ConfigurationManager;
import abscon.tools.elements.Elements;
import java.util.Arrays;

public class NogoodManager {
    public static int NOGOOD_SIZE_LIMIT;
    private NogoodConfiguration nogoodConfiguration;
    private final int nbMaxNogoods;
    private SystematicSolver solver;
    private DecisionManager decisionManager;
    private PropagationSet set;
    private boolean incrementWeight;
    private int[][] nogoods;
    private int nbNogoods;
    private int[] offsets;
    private int[] watches;
    private int[] access;
    private int[] nexts;
    private int free;
    private int[] tmpNRR;
    private boolean bottomUp = true;

    public int getNbNogoods() {
        return this.nbNogoods;
    }

    private int getLiteralIndexInWatchesFor(int decision) {
        Variable variable = this.decisionManager.getVariableInDecision(decision);
        int t = this.offsets[variable.getId()] + this.decisionManager.getIndexInDecision(decision) * 2 + (decision < 0 ? 1 : 0);
        return t;
    }

    private void addWatch(int decisionPosition, int watchPosition, int nogoodId) {
        int[] t = this.nogoods[nogoodId];
        t[watchPosition] = decisionPosition;
        int lit = this.getLiteralIndexInWatchesFor(t[decisionPosition]);
        int tmp = this.nexts[this.free];
        this.access[this.free] = nogoodId;
        this.nexts[this.free] = this.watches[lit];
        this.watches[lit] = this.free;
        this.free = tmp;
    }

    private boolean canBeWatched(int decision) {
        Variable variable = this.decisionManager.getVariableInDecision(decision);
        int index = this.decisionManager.getIndexInDecision(decision);
        Elements elements = variable.getDomain().getElements();
        assert (decision != 0);
        if (decision > 0) {
            return elements.isPresent(index);
        }
        if (elements.getNbPresentElements() > 1) {
            return true;
        }
        return !elements.isPresent(index);
    }

    private int canFindAnotherWatch(int nogoodId, int decision) {
        int[] nogood = this.nogoods[nogoodId];
        int i = 2;
        while (i < nogood.length) {
            int otherDecision = nogood[i];
            if (otherDecision != nogood[nogood[0]] && otherDecision != nogood[nogood[1]] && this.canBeWatched(otherDecision)) {
                this.addWatch(i, nogood[nogood[0]] == decision ? 0 : 1, nogoodId);
                return 0;
            }
            ++i;
        }
        return nogood[nogood[0]] == decision ? nogood[nogood[1]] : nogood[nogood[0]];
    }

    private boolean dealWithInference(int inferenceDecision) {
        Variable variable = this.decisionManager.getVariableInDecision(inferenceDecision);
        int index = this.decisionManager.getIndexInDecision(inferenceDecision);
        Domain domain = variable.getDomain();
        Elements elements = domain.getElements();
        int nbRemovals = 0;
        if (inferenceDecision > 0) {
            if (!elements.isPresent(index)) {
                return false;
            }
            int currentIndex = elements.getFirstPresent();
            while (currentIndex != -1) {
                if (currentIndex != index) {
                    domain.removeElementAt(currentIndex);
                    ++nbRemovals;
                }
                currentIndex = elements.getNextPresent(currentIndex);
            }
        } else {
            if (elements.getNbPresentElements() == 1 && elements.isPresent(index)) {
                return false;
            }
            if (elements.isPresent(index)) {
                ++nbRemovals;
                domain.removeElementAt(index);
            }
        }
        if (elements.getNbPresentElements() == 0) {
            return false;
        }
        if (nbRemovals > 0) {
            this.set.updateAfterEffectiveRevisionOf(null, variable, nbRemovals);
        }
        return true;
    }

    private void updateWeightsFromNogood(int[] nogood) {
        int i = 2;
        while (i < nogood.length) {
            Variable variable = this.decisionManager.getVariableInDecision(nogood[i]);
            variable.incrementWeightedDegree();
            ++i;
        }
    }

    public boolean checkWatchesOf(int decision) {
        int lit = this.getLiteralIndexInWatchesFor(decision);
        int previous = -1;
        int current = this.watches[lit];
        while (current != -1) {
            int inferenceDecision = this.canFindAnotherWatch(this.access[current], decision);
            if (inferenceDecision == 0) {
                if (previous == -1) {
                    this.watches[lit] = this.nexts[current];
                } else {
                    this.nexts[previous] = this.nexts[current];
                }
                int tmp = this.nexts[current];
                this.nexts[current] = this.free;
                this.free = current;
                current = tmp;
                continue;
            }
            if (!this.dealWithInference(inferenceDecision)) {
                if (this.incrementWeight) {
                    this.updateWeightsFromNogood(this.nogoods[this.access[current]]);
                }
                return false;
            }
            previous = current;
            current = this.nexts[current];
        }
        assert (this.controlWatches());
        return true;
    }

    public boolean checkWatchesOf(Variable variable, int index, boolean positive) {
        if (positive) {
            return this.checkWatchesOf(this.decisionManager.getPositiveDecisionFor(variable, index));
        }
        return this.checkWatchesOf(this.decisionManager.getNegativeDecisionFor(variable, index));
    }

    public NogoodManager(SystematicSolver solver, DecisionManager decisionManager, int nbMaxNogoods, int nogoodSizeLimit) {
        NOGOOD_SIZE_LIMIT = nogoodSizeLimit;
        this.solver = solver;
        this.decisionManager = decisionManager;
        this.nbMaxNogoods = nbMaxNogoods;
        if (solver.getSearchPropagationTechnique() == null) {
            return;
        }
        this.nogoodConfiguration = NogoodConfiguration.getNogoodConfigurationFor(ConfigurationManager.getInt(solver.getLevelInResolution(), "search/nogoodRecording", "mode"));
        this.nogoods = new int[nbMaxNogoods][];
        int capacity = 0;
        this.offsets = new int[solver.getNbVariables()];
        int i = 0;
        while (i < this.offsets.length) {
            this.offsets[i] = capacity;
            capacity += solver.getVariable(i).getDomain().getMaximumSize() * 2;
            ++i;
        }
        this.watches = new int[capacity];
        this.access = new int[nbMaxNogoods * 2];
        this.nexts = new int[nbMaxNogoods * 2];
        Arrays.fill(this.watches, -1);
        i = 0;
        while (i < this.nexts.length - 1) {
            this.nexts[i] = i + 1;
            ++i;
        }
        this.nexts[this.nexts.length - 1] = -1;
        this.free = 0;
        this.set = solver.getSearchPropagationTechnique().getPropagationSet();
        this.incrementWeight = ConfigurationManager.getBoolean(solver.getLevelInResolution(), "search/nogoodRecording", "incrementWeight");
    }

    private void addNogood(int[] nogood) {
        if (this.nbNogoods >= this.nogoods.length - 1) {
            return;
        }
        this.nogoods[this.nbNogoods] = nogood;
        this.addWatch(nogood.length - 2, 0, this.nbNogoods);
        this.addWatch(nogood.length - 1, 1, this.nbNogoods);
        ++this.nbNogoods;
    }

    public void addCurrentNogood() {
        if (this.nogoodConfiguration == NogoodConfiguration.PEIGNE_RECORDING || this.nogoodConfiguration == NogoodConfiguration.MINIMAL_PEIGNE_RECORDING || this.nbNogoods >= this.nogoods.length - 1) {
            return;
        }
        if (this.solver.getCurrentDepth() < 2) {
            return;
        }
        int nbDecisions = this.decisionManager.getNbDecisions();
        int[] decisions = this.decisionManager.getDecisions();
        int[] t = null;
        if (this.nogoodConfiguration == NogoodConfiguration.MINIMAL_NOGOOD_RECORDING) {
            t = this.solver.getResolution().getAuxiliarySolver().extractMinimalFrom(this.solver, decisions, nbDecisions);
            assert (this.solver.getResolution().getAuxiliarySolver().controlMinimalNogood(this.solver, t));
        } else {
            t = new int[nbDecisions + 2];
            int i = 2;
            while (i < t.length) {
                t[i] = -decisions[i - 2];
                ++i;
            }
        }
        if (t != null && t.length > 3) {
            this.addNogood(t);
        }
        assert (this.controlWatches());
    }

    public void addNogoodsOfCurrentBranch() {
        if (this.nogoodConfiguration != NogoodConfiguration.PEIGNE_RECORDING && this.nogoodConfiguration != NogoodConfiguration.MINIMAL_PEIGNE_RECORDING) {
            return;
        }
        int nbDecisions = this.decisionManager.getNbDecisions();
        if (nbDecisions < 2) {
            return;
        }
        int[] decisions = this.decisionManager.getDecisions();
        if (this.tmpNRR == null) {
            this.tmpNRR = new int[this.solver.getProblem().getNbVariables()];
        }
        int cpt = 0;
        int nbMetPositiveDecisions = 0;
        int i = 0;
        while (i < nbDecisions) {
            if (decisions[i] > 0) {
                this.tmpNRR[nbMetPositiveDecisions++] = decisions[i];
            } else if (nbMetPositiveDecisions > 0) {
                int[] t;
                if (this.nogoodConfiguration == NogoodConfiguration.MINIMAL_PEIGNE_RECORDING && this.decisionManager.isFailedAssignment(i)) {
                    int j;
                    t = new int[nbMetPositiveDecisions + 1];
                    if (this.bottomUp) {
                        j = 0;
                        while (j < nbMetPositiveDecisions) {
                            t[j] = this.tmpNRR[nbMetPositiveDecisions - j - 1];
                            ++j;
                        }
                    } else {
                        j = 0;
                        while (j < nbMetPositiveDecisions) {
                            t[j] = this.tmpNRR[j];
                            ++j;
                        }
                    }
                    t[t.length - 1] = -decisions[i];
                    int[] nogood = this.solver.extractMinimalFrom(t);
                    if (nogood != null) {
                        if (nogood.length == 0) {
                            return;
                        }
                        this.addNogood(nogood);
                    }
                } else {
                    t = new int[nbMetPositiveDecisions + 3];
                    int j = 2;
                    while (j < t.length - 1) {
                        t[j] = -this.tmpNRR[j - 2];
                        ++j;
                    }
                    t[t.length - 1] = decisions[i];
                    this.addNogood(t);
                    ++cpt;
                }
            }
            ++i;
        }
        assert (this.controlWatches());
    }

    private void display(int[] nogood) {
        int i = 2;
        while (i < nogood.length) {
            System.out.print(String.valueOf(this.decisionManager.getDecisionEncodedBy(nogood[i])) + " ");
            ++i;
        }
        System.out.println();
    }

    public void display() {
        int max = 0;
        int cpt = 0;
        System.out.println(String.valueOf(this.nbNogoods) + " nogoods");
        int i = 0;
        while (i < this.nbNogoods) {
            if (this.nogoods[i].length - 2 > max) {
                max = this.nogoods[i].length - 2;
            }
            cpt += this.nogoods[i].length - 2;
            this.display(this.nogoods[i]);
            ++i;
        }
        System.out.print("max = " + max + " cpt =" + (double)cpt / (double)this.nbNogoods);
    }

    private boolean seekWatch(int nogoodId, int literalIndex) {
        if (this.nogoods[nogoodId] == null) {
            System.out.println("nogood with id = " + nogoodId + " is null");
            return false;
        }
        int[] t = this.nogoods[nogoodId];
        if (this.getLiteralIndexInWatchesFor(t[t[0]]) != literalIndex && this.getLiteralIndexInWatchesFor(t[t[1]]) != literalIndex) {
            System.out.println("nogood with id = " + nogoodId + " does not watch " + literalIndex);
            return false;
        }
        return true;
    }

    private boolean seekNogood(int literalIndex, int nogoodId) {
        int current = this.watches[literalIndex];
        while (current != -1) {
            if (this.access[current] == nogoodId) {
                return true;
            }
            current = this.nexts[current];
        }
        System.out.println("Literal " + literalIndex + " not found in watches of nogood with id " + nogoodId);
        return false;
    }

    private boolean controlWatches() {
        int i = 0;
        while (i < this.watches.length) {
            int current = this.watches[i];
            while (current != -1) {
                if (!this.seekWatch(this.access[current], i)) {
                    return false;
                }
                current = this.nexts[current];
            }
            ++i;
        }
        i = 0;
        while (i < this.nogoods.length) {
            if (this.nogoods[i] != null) {
                int[] t = this.nogoods[i];
                int literal = this.getLiteralIndexInWatchesFor(t[t[0]]);
                if (!this.seekNogood(literal, i)) {
                    return false;
                }
                literal = this.getLiteralIndexInWatchesFor(t[t[1]]);
                if (!this.seekNogood(literal, i)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NogoodConfiguration {
        NO_NOGOOD_RECORDING,
        STANDARD_NOGOOD_RECORDING,
        PEIGNE_RECORDING,
        MINIMAL_NOGOOD_RECORDING,
        MINIMAL_PEIGNE_RECORDING;


        public static NogoodConfiguration getNogoodConfigurationFor(int idApproach) {
            if (idApproach == 0) {
                return NO_NOGOOD_RECORDING;
            }
            if (idApproach == 1) {
                return STANDARD_NOGOOD_RECORDING;
            }
            if (idApproach == 2) {
                return PEIGNE_RECORDING;
            }
            if (idApproach == 3) {
                return MINIMAL_NOGOOD_RECORDING;
            }
            if (idApproach == 4) {
                return MINIMAL_PEIGNE_RECORDING;
            }
            throw new UnreachableCodeException();
        }
    }
}

