/*
 * Decompiled with CFR 0.152.
 */
package abscon.solvers.systematicSolvers;

import abscon.constraints.Constraint;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;
import abscon.propagationTechniques.forwardPropagationTechniques.ForwardPropagationTechnique;
import abscon.propagationTechniques.supportManagers.SupportManager2003;
import abscon.solvers.systematicSolvers.SystematicSolver;
import abscon.tools.absconParameters.ConfigurationManager;

public class Disconnector {
    private SystematicSolver solver;
    private boolean active;
    private Variable[] disconnectedVariables;
    private int[] disconnectedVariableDepths;
    private Constraint[] disconnectedVariableConstraints;
    private int nbDisconnectedVariables;
    private ForwardPropagationTechnique propagationTechnique;

    public boolean isActive() {
        return this.active;
    }

    public int getNbDisconnectedVariables() {
        return this.nbDisconnectedVariables;
    }

    public Disconnector(SystematicSolver solver) {
        this.solver = solver;
        this.active = ConfigurationManager.getBoolean(solver.getLevelInResolution(), "search/disconnectSingletons", "value");
        if (this.active) {
            if (!solver.getSearchPropagationTechnique().guaranteeConsistencyOfValueSingletons()) {
                this.active = false;
                System.out.println("\nWarning: singletons disconnection is disabled as arc consistency is not guaranteed\n");
            }
            if (solver.getBacktrackingMode() != 10) {
                this.active = false;
                System.out.println("\nWarning: singletons disconnection is disabled as intelligent or dynamic backtrackingMode is used\n");
            }
            if (solver.getSearchPropagationTechnique().isBoundConsistency()) {
                this.active = false;
                System.out.println("\nWarning: singletons disconnection is disabled as bound consistency is used\n");
            }
        }
        if (this.active) {
            this.propagationTechnique = (ForwardPropagationTechnique)solver.getSearchPropagationTechnique();
            if (this.propagationTechnique.getSupportManager() instanceof SupportManager2003) {
                throw new IncompatiblePropertiesException();
            }
            int nbVariables = solver.getNbVariables();
            this.disconnectedVariables = new Variable[nbVariables];
            this.disconnectedVariableDepths = new int[nbVariables];
            this.disconnectedVariableConstraints = new Constraint[nbVariables];
        }
    }

    private void addDisconnectedVariable(Variable variable, Constraint constraint, int depth) {
        assert (this.active && !variable.isAssigned() && !variable.isDisconnected());
        System.out.println("Add " + variable + " at level " + depth);
        this.disconnectedVariables[this.nbDisconnectedVariables] = variable;
        this.disconnectedVariableDepths[variable.getId()] = depth;
        this.disconnectedVariableConstraints[variable.getId()] = constraint;
        variable.setDisconnected(true);
        ++this.nbDisconnectedVariables;
        this.solver.getVariableManager().updateNbDisconnectedVariables(true);
        assert (this.nbDisconnectedVariables == this.solver.getVariableManager().getNbDisconnectedVariables());
    }

    private void removeDisconnectedVariable(Variable variable) {
        assert (this.active && variable.isDisconnected() && variable == this.disconnectedVariables[this.nbDisconnectedVariables - 1]);
        System.out.println("remove " + variable + " at level " + this.solver.getCurrentDepth());
        variable.setDisconnected(false);
        --this.nbDisconnectedVariables;
        this.solver.getVariableManager().updateNbDisconnectedVariables(false);
    }

    /*
     * Unable to fully structure code
     */
    void tryReconnectingSingletons() {
        if (this.active) ** GOTO lbl5
        return;
        while (this.disconnectedVariableDepths[(variable = this.disconnectedVariables[this.nbDisconnectedVariables - 1]).getId()] >= this.solver.getCurrentDepth()) {
            this.removeDisconnectedVariable(variable);
lbl5:
            // 2 sources

            if (this.nbDisconnectedVariables > 0) continue;
        }
    }

    void tryDisconnectingSingletons() {
        if (!this.active) {
            return;
        }
        int depth = this.solver.getCurrentDepth();
        boolean disconnection = true;
        while (disconnection) {
            disconnection = false;
            Variable futureVariable = this.solver.getFirstFutureVariable();
            while (futureVariable != null) {
                Constraint constraint = futureVariable.getUniqueFreeConstraint();
                if (constraint != null) {
                    disconnection = true;
                    if (constraint == Constraint.TAG) {
                        constraint = null;
                    }
                    this.addDisconnectedVariable(futureVariable, constraint, depth);
                }
                futureVariable = this.solver.getNextFutureVariableAfter(futureVariable);
            }
        }
    }

    private void findSolutionUsingSingletons(int position, boolean first) {
        Variable variable = this.disconnectedVariables[position];
        variable.setDisconnected(false);
        Constraint constraint = this.disconnectedVariableConstraints[variable.getId()];
        if (constraint != null && constraint.getNbDisconnectedVariables() != 1) {
            if (!first) {
                this.propagationTechnique.getSupportManager().restoreSupportsOf(constraint, variable, this.propagationTechnique.getSolver().getCurrentDepth());
            }
            boolean consistent = this.propagationTechnique.isConsistent(constraint, variable);
            assert (consistent);
        }
        Domain domain = variable.getDomain();
        assert (domain.getCurrentSize() != 0);
        int index = domain.getFirstValidIndex();
        while (index != -1 && !this.solver.getResolution().isSuccessful()) {
            first = first && index == domain.getFirstValidIndex();
            this.solver.doAssignment(variable, index);
            if (position == 0) {
                this.solver.dealWithNewSolution();
            } else {
                this.findSolutionUsingSingletons(position - 1, first);
            }
            this.solver.undoAssignmentOf(variable);
            this.solver.undoPropagationOf(variable);
            index = domain.getNextValidIndexAfter(index);
        }
        if (constraint != null && constraint.getNbDisconnectedVariables() != 1) {
            variable.getDomain().restoreElementsRemovedAtLevelGreaterThanOrEqualTo(this.solver.getCurrentDepth());
        }
        variable.setDisconnected(true);
    }

    public void findSolutionUsingSingletons() {
        Constraint constraint;
        Variable variable;
        assert (this.active);
        int i = 0;
        while (i < this.nbDisconnectedVariables) {
            variable = this.disconnectedVariables[i];
            constraint = this.disconnectedVariableConstraints[variable.getId()];
            if (constraint != null && constraint.getNbDisconnectedVariables() == 1) {
                boolean consistent = this.propagationTechnique.isConsistent(constraint, variable);
                assert (consistent);
            }
            ++i;
        }
        this.findSolutionUsingSingletons(this.nbDisconnectedVariables - 1, true);
        i = 0;
        while (i < this.nbDisconnectedVariables) {
            variable = this.disconnectedVariables[i];
            constraint = this.disconnectedVariableConstraints[variable.getId()];
            if (constraint != null && constraint.getNbDisconnectedVariables() == 1) {
                variable.getDomain().restoreElementsRemovedAtLevelGreaterThanOrEqualTo(this.solver.getCurrentDepth());
            }
            ++i;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("disconnector " + (this.active ? "active with " + this.nbDisconnectedVariables + " elements" : " not active"));
        int i = 0;
        while (i < this.nbDisconnectedVariables) {
            sb.append(this.disconnectedVariables[i] + " at depth " + this.disconnectedVariableDepths[i] + " from " + this.disconnectedVariableConstraints[i]);
            ++i;
        }
        return sb.toString();
    }
}

