/*
 * Decompiled with CFR 0.152.
 */
package abscon.solvers.systematicSolvers;

import abscon.exceptions.MissingImplementationException;
import abscon.exceptions.UnreachableCodeException;
import abscon.problem.Variable;
import abscon.solvers.systematicSolvers.SystematicSolver;
import abscon.tools.BitManager;

public class DecisionManager {
    public static final int OFFSET = (int)Math.pow(2.0, 16.0);
    private SystematicSolver solver;
    private int[] decisions;
    private byte[] failedAssignments;
    private int nbDecisions;
    private boolean unexploitable;

    public int[] getDecisions() {
        return this.decisions;
    }

    public int getNbDecisions() {
        return this.nbDecisions;
    }

    public int getLastDecision() {
        return this.decisions[this.nbDecisions - 1];
    }

    public void reset() {
        this.solver.getNogoodManager().addNogoodsOfCurrentBranch();
        this.nbDecisions = 0;
    }

    public int[] getCloneOfDecisions() {
        int[] t = new int[this.nbDecisions];
        System.arraycopy(this.decisions, 0, t, 0, t.length);
        return t;
    }

    public boolean isUnexploitable() {
        return this.unexploitable;
    }

    public boolean isFailedAssignment(int decisionPosition) {
        assert (decisionPosition < this.nbDecisions);
        return BitManager.isTo1(this.failedAssignments, decisionPosition);
    }

    public DecisionManager(SystematicSolver solver) {
        this.solver = solver;
        int maxDomainSize = solver.getProblem().getMaxVariableDomainSize();
        int nbVariables = solver.getProblem().getNbVariables();
        if (maxDomainSize + 1 >= OFFSET / 2 || nbVariables >= OFFSET / 2) {
            this.unexploitable = true;
        } else {
            int nb = (int)solver.getProblem().getNbMaximumValues();
            this.decisions = new int[nb];
            this.failedAssignments = new byte[nb / 8 + 1];
        }
    }

    public int getPositiveDecisionFor(Variable variable, int index) {
        return 1 + index + OFFSET * variable.getId();
    }

    public int getNegativeDecisionFor(Variable variable, int index) {
        return -1 * (1 + index + OFFSET * variable.getId());
    }

    public void addPositiveDecision(Variable variable, int index) {
        BitManager.setTo0(this.failedAssignments, this.nbDecisions);
        this.decisions[this.nbDecisions] = 1 + index + OFFSET * variable.getId();
        ++this.nbDecisions;
        assert (this.controlDecisions());
    }

    public void addNegativeDecision(Variable variable, int index) {
        this.decisions[this.nbDecisions] = -1 * (1 + index + OFFSET * variable.getId());
        ++this.nbDecisions;
        assert (this.controlDecisions());
    }

    public void replacePositiveByNegativeDecision(Variable variable, int index) {
        --this.nbDecisions;
        if (this.decisions[this.nbDecisions] > 0) {
            BitManager.setTo1(this.failedAssignments, this.nbDecisions);
        } else {
            do {
                --this.nbDecisions;
            } while (this.decisions[this.nbDecisions] < 0);
        }
        assert (this.getVariableInDecision(this.decisions[this.nbDecisions]) == variable);
        this.decisions[this.nbDecisions] = -1 * (1 + index + OFFSET * variable.getId());
        ++this.nbDecisions;
        assert (this.controlDecisions());
    }

    public int[] getDecisionsToPerform(Variable pivot, Variable variable, int index) {
        throw new MissingImplementationException();
    }

    public int getIndexOfPositiveDecisionWith(Variable variable) {
        int i = 0;
        while (i < this.nbDecisions) {
            if (this.decisions[i] > 0 && this.getVariableInDecision(this.decisions[i]) == variable) {
                return i;
            }
            ++i;
        }
        throw new UnreachableCodeException();
    }

    public int getIndexInDecision(int codedDecision, Variable variable) {
        throw new UnreachableCodeException();
    }

    public Variable getVariableInDecision(int codedDecision) {
        codedDecision = Math.abs(codedDecision);
        int variableId = codedDecision / OFFSET;
        return this.solver.getVariable(variableId);
    }

    public int getIndexInDecision(int codedDecision) {
        codedDecision = Math.abs(codedDecision);
        int index = codedDecision % OFFSET - 1;
        return index;
    }

    public String getDecisionEncodedBy(int code) {
        assert (code != 0);
        boolean positive = code > 0;
        code = Math.abs(code);
        Variable variable = this.getVariableInDecision(code);
        int index = this.getIndexInDecision(code);
        return variable + (positive ? "=" : "!=") + index;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.nbDecisions) + " decisions : ");
        int i = 0;
        while (i < this.nbDecisions) {
            sb.append(String.valueOf(this.getDecisionEncodedBy(this.decisions[i])) + (BitManager.isTo1(this.failedAssignments, i) ? "(f)" : "") + "  ");
            ++i;
        }
        return sb.toString();
    }

    private boolean controlDecisions() {
        int i = 0;
        while (i < this.nbDecisions - 1) {
            int j = i + 1;
            while (j < this.nbDecisions) {
                if (this.decisions[i] == -this.decisions[j]) {
                    System.out.println("Pb as " + this.decisions[i] + " " + this.decisions[j]);
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }
}

