/*
 * Decompiled with CFR 0.152.
 */
package abscon.solvers.systematicSolvers;

import abscon.constraints.Constraint;
import abscon.problem.Explanations;
import abscon.problem.Variable;
import abscon.solvers.systematicSolvers.SystematicSolver;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.elements.Elements;
import java.util.Arrays;

public class CulpritManager {
    private SystematicSolver solver;
    private boolean active;
    private Variable[] culpritVariables;
    private int nbCulpritVariables;
    private boolean[] status;
    private Variable[] localCulpritVariables;

    public int getNbCulpritVariables() {
        return this.active ? this.nbCulpritVariables : this.solver.getVariableManager().getNbPastVariables();
    }

    public Variable[] getCulpritVariables() {
        return this.culpritVariables;
    }

    public CulpritManager(SystematicSolver solver, boolean active) {
        this.solver = solver;
        this.active = active;
        if (active) {
            this.status = new boolean[solver.getNbVariables()];
            this.localCulpritVariables = new Variable[solver.getNbVariables()];
        }
    }

    public void fixCulpritVariablesFromEmptyDomainOf(Variable variable) {
        if (!this.active) {
            return;
        }
        assert (variable.getCurrentDomainSize() == 0);
        Arrays.fill(this.status, false);
        this.nbCulpritVariables = 0;
        Explanations explanations = variable.getDomain().getExplanations();
        Elements elements = variable.getDomain().getElements();
        int index = elements.getLastAbsent();
        while (index != -1) {
            int j = 0;
            while (j < explanations.getNbCulpritsOf(index)) {
                Variable var = explanations.getCulprit(index, j);
                if (!this.status[var.getId()]) {
                    this.localCulpritVariables[this.nbCulpritVariables++] = var;
                    this.status[var.getId()] = true;
                }
                ++j;
            }
            index = elements.getPrevAbsent(index);
        }
        this.culpritVariables = this.localCulpritVariables;
    }

    public void setCulpritVariablesToPastVariables() {
        if (!this.active) {
            return;
        }
        this.nbCulpritVariables = 0;
        VariableManager variableStatuteManager = this.solver.getVariableManager();
        Variable pastVariable = variableStatuteManager.getLastPastVariable();
        while (pastVariable != null) {
            this.localCulpritVariables[this.nbCulpritVariables++] = pastVariable;
            pastVariable = variableStatuteManager.getPrevPastVariableBefore(pastVariable);
        }
        this.culpritVariables = this.localCulpritVariables;
    }

    public void setCulpritVariablesTo(Variable[] variables) {
        if (!this.active) {
            return;
        }
        this.culpritVariables = variables;
        this.nbCulpritVariables = this.culpritVariables.length;
    }

    public void establishCulpritVariablesOfInconsistency() {
        if (!this.active) {
            return;
        }
        Object object = this.solver.getSearchPropagationTechnique().getCulprit();
        if (object instanceof Constraint) {
            this.setCulpritVariablesTo(((Constraint)object).getInvolvedVariables());
        } else {
            this.fixCulpritVariablesFromEmptyDomainOf((Variable)object);
        }
    }

    Variable getYoungestCulpritVariable() {
        VariableManager variableStatuteManager = this.solver.getVariableManager();
        if (!this.active) {
            return variableStatuteManager.getLastPastVariable();
        }
        if (this.nbCulpritVariables == 0) {
            return null;
        }
        Variable oldestCulpritVariable = this.culpritVariables[0];
        int i = 1;
        while (i < this.nbCulpritVariables) {
            if (variableStatuteManager.getAssignmentDepthOf(this.culpritVariables[i]) > variableStatuteManager.getAssignmentDepthOf(oldestCulpritVariable)) {
                oldestCulpritVariable = this.culpritVariables[i];
            }
            ++i;
        }
        return oldestCulpritVariable;
    }
}

