/*
 * Decompiled with CFR 0.152.
 */
package abscon.solvers.localSolvers.neighborHeuristics;

import abscon.problem.Variable;
import abscon.solvers.localSolvers.neighborHeuristics.NeighborHeuristic;

public class TabuManager {
    private boolean[][] tabus;
    private int[] t1;
    private int[] t2;
    private int head;

    public TabuManager(NeighborHeuristic neigborOrderingHeuristic, int size) {
        if (size <= 0) {
            return;
        }
        this.tabus = new boolean[neigborOrderingHeuristic.getSolver().getNbVariables()][];
        int i = 0;
        while (i < this.tabus.length) {
            this.tabus[i] = new boolean[neigborOrderingHeuristic.getSolver().getVariable(i).getDomain().getElements().getMaximumSize()];
            ++i;
        }
        this.t1 = new int[size];
        this.t2 = new int[size];
    }

    public void push(Variable variable, int index) {
        this.tabus[this.t1[this.head]][this.t2[this.head]] = false;
        this.tabus[variable.getId()][index] = true;
        this.t1[this.head] = variable.getId();
        this.t2[this.head] = index;
        this.head = (this.head + 1) % this.t1.length;
    }

    public boolean isTabu(Variable variable, int index) {
        return this.tabus != null && this.tabus[variable.getId()][index];
    }
}

