/*
 * Decompiled with CFR 0.152.
 */
package abscon.solvers.localSolvers.neighborHeuristics;

import abscon.exceptions.UnreachableCodeException;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;
import abscon.solvers.localSolvers.LocalSearchSolver;
import abscon.solvers.localSolvers.neighborHeuristics.TabuManager;
import abscon.tools.absconParameters.ConfigurationManager;
import java.util.Random;

public abstract class NeighborHeuristic {
    protected LocalSearchSolver solver;
    protected Variable[] variables;
    protected TabuManager tabuManager;
    protected Random random;
    protected float randVariable;
    protected float randValue;
    protected Variable bestVariable;
    protected int bestIndex;
    protected int bestEvolution;
    protected int localBestEvolution;
    protected int bestEvaluationEverSeen = Integer.MAX_VALUE;
    protected Variable lastAssignedVariable;
    protected int[] counters;

    public LocalSearchSolver getSolver() {
        return this.solver;
    }

    public void attachTo(LocalSearchSolver solver) {
        this.solver = solver;
        this.variables = solver.getVariables();
        this.random = solver.getResolution().getRandom();
        String s = "search/assignmentHeuristic";
        this.randVariable = (float)ConfigurationManager.getDouble(solver.getLevelInResolution(), s, "randVar");
        this.randValue = (float)ConfigurationManager.getDouble(solver.getLevelInResolution(), s, "randVal");
        int tabuListSize = ConfigurationManager.getInt(solver.getLevelInResolution(), s, "tabuListSize");
        this.tabuManager = new TabuManager(this, tabuListSize);
        this.counters = new int[solver.getNbVariables()];
    }

    protected boolean dealWithRandom() {
        if (this.random.nextFloat() < this.randVariable) {
            Variable[] variables = this.solver.getVariables();
            Variable variable = variables[this.random.nextInt(variables.length)];
            if (this.random.nextFloat() < this.randValue) {
                int index = variable.getDomain().getRandomIndex();
                int evolution = this.solver.getConflictManager().computeEvolutionOf(variable, index);
                if (evolution < this.bestEvaluationEverSeen) {
                    this.bestEvaluationEverSeen = evolution;
                } else if (this.tabuManager.isTabu(variable, index)) {
                    this.bestVariable = Variable.TAG;
                    return true;
                }
                this.bestVariable = variable;
                this.bestIndex = index;
                return true;
            }
            int index = this.selectIndexOfBestNeighborOf(variable, Integer.MAX_VALUE);
            if (index < 0) {
                this.bestVariable = Variable.TAG;
                return true;
            }
            this.bestVariable = variable;
            this.bestIndex = index;
            return true;
        }
        return false;
    }

    protected int selectIndexOfBestNeighborOf(Variable variable, int limitEvolution) {
        int localTieSize = 0;
        int localBestIndex = -1;
        this.localBestEvolution = limitEvolution;
        Domain domain = variable.getDomain();
        int index = domain.getFirstValidIndex();
        while (index != -1) {
            block8: {
                int evolution;
                block10: {
                    block9: {
                        if (index == domain.getUniqueIndex() || (evolution = this.solver.getConflictManager().computeEvolutionOfUpto(variable, index, this.localBestEvolution)) > this.localBestEvolution) break block8;
                        if (evolution + this.solver.getConflictManager().getCurrentEvaluation() >= this.bestEvaluationEverSeen) break block9;
                        this.bestEvaluationEverSeen = evolution + this.solver.getConflictManager().getCurrentEvaluation();
                        break block10;
                    }
                    if (this.tabuManager.isTabu(variable, index)) break block8;
                }
                if (evolution < this.localBestEvolution) {
                    localTieSize = 1;
                    localBestIndex = index;
                    this.localBestEvolution = evolution;
                } else if (evolution == this.localBestEvolution) {
                    ++localTieSize;
                    if (this.random.nextDouble() < 1.0 / (double)localTieSize) {
                        localBestIndex = index;
                    }
                }
            }
            index = domain.getNextValidIndexAfter(index);
        }
        return localBestIndex;
    }

    public Variable setNeighbor() {
        if (this.bestVariable != null && this.bestVariable != Variable.TAG) {
            this.bestVariable.getDomain().setUniqueIndex(this.bestIndex);
            this.tabuManager.push(this.bestVariable, this.bestIndex);
            this.lastAssignedVariable = this.bestVariable;
            int n = this.bestVariable.getId();
            this.counters[n] = this.counters[n] + 1;
            this.solver.getConflictManager().updateFromNewAssignmentOf(this.bestVariable);
        }
        return this.bestVariable;
    }

    public void selectNeighbor() {
        throw new UnreachableCodeException();
    }
}

