/*
 * Decompiled with CFR 0.152.
 */
package abscon.solvers.localSolvers;

import abscon.Resolution;
import abscon.constraints.Constraint;
import abscon.problem.Variable;
import abscon.solvers.Solver;
import abscon.solvers.localSolvers.ConflictManager;
import abscon.solvers.localSolvers.LocalStatistics;
import abscon.solvers.localSolvers.neighborHeuristics.NeighborHeuristic;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.Stopwatch;
import abscon.tools.absconParameters.ConfigurationManager;
import abscon.tools.reflection.Factory;

public class LocalSearchSolver
extends Solver {
    protected int nbIterations;
    protected NeighborHeuristic neighborHeuristic;
    protected ConflictManager conflictManager;
    protected LocalStatistics localStatistics;
    protected int resetWeights;
    private Stopwatch stopwatch;
    private final long timeLimit = 30000L;
    private long timeLastSolution = 0L;
    private int upperBound = Integer.MAX_VALUE;

    public void setNbIterations(int nbIterations) {
        this.nbIterations = nbIterations;
    }

    public ConflictManager getConflictManager() {
        return this.conflictManager;
    }

    public NeighborHeuristic getNeighborOrderingHeuristic() {
        return this.neighborHeuristic;
    }

    public void attachTo(Resolution resolution, int levelInResolution) {
        super.attachTo(resolution, levelInResolution);
        this.nbIterations = ConfigurationManager.getInt(levelInResolution, "search/restarts", "cutoff");
        if (this.nbIterations == -1) {
            this.nbIterations = 10 * this.variables.length;
        }
        String className = ConfigurationManager.getString(levelInResolution, "search/assignmentHeuristic", "class");
        this.resetWeights = ConfigurationManager.getInt(levelInResolution, "search/assignmentHeuristic", "resetWeights");
        if (this.resetWeights <= 0) {
            this.resetWeights = Integer.MAX_VALUE;
        }
        this.neighborHeuristic = (NeighborHeuristic)Factory.getInstanceOf(className, NeighborHeuristic.class);
        this.neighborHeuristic.attachTo(this);
        this.conflictManager = new ConflictManager(this);
        this.localStatistics = new LocalStatistics(this);
        this.statistics = this.localStatistics;
        this.stopwatch = new Stopwatch();
    }

    public void randomSolution() {
        double bias;
        int[] solution = this.getProblem().getForcedSolution();
        double d = bias = solution == null ? 0.0 : ConfigurationManager.getDouble(this.levelInResolution, "search/assignmentHeuristic", "initialBias");
        if (bias != 0.0) {
            System.out.print("Solution = ");
            int i = 0;
            while (i < solution.length) {
                System.out.print(String.valueOf(solution[i]) + " ");
                ++i;
            }
            System.out.print("  bias = " + bias);
            boolean[] forced = new boolean[this.variables.length];
            long nb = Math.round(bias * (double)this.variables.length);
            int i2 = 0;
            while ((long)i2 < nb) {
                int position = this.resolution.getRandom().nextInt(this.variables.length);
                while (forced[position]) {
                    position = this.resolution.getRandom().nextInt(this.variables.length);
                }
                this.variables[position].getDomain().setUniqueIndex(solution[position]);
                forced[position] = true;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.variables.length) {
                if (!forced[i2]) {
                    this.variables[i2].getDomain().setUniqueIndex(-10);
                    int index = this.variables[i2].getDomain().getRandomIndex();
                    while (index == solution[i2]) {
                        index = this.variables[i2].getDomain().getRandomIndex();
                    }
                    this.variables[i2].getDomain().setUniqueIndex(index);
                }
                ++i2;
            }
            int cpt = 0;
            int i3 = 0;
            while (i3 < this.variables.length) {
                if (this.variables[i3].getDomain().getUniqueIndex() == solution[i3]) {
                    ++cpt;
                }
                ++i3;
            }
            System.out.println("  real bias = " + (double)cpt / (double)this.variables.length);
        } else {
            Variable[] variableArray = this.variables;
            int n = 0;
            int n2 = variableArray.length;
            while (n < n2) {
                Variable variable = variableArray[n];
                variable.getDomain().setUniqueIndex(variable.getDomain().getRandomIndex());
                ++n;
            }
        }
    }

    public long getRestartCounter() {
        return Long.MAX_VALUE;
    }

    public int getCurrentDepth() {
        return 0;
    }

    protected void initialize() {
        Constraint constraint;
        Constraint[] constraintArray = this.constraints;
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            constraint = constraintArray[n];
            if (!constraint.checkCurrent()) {
                this.conflictManager.add(constraint);
            }
            ++n;
        }
        if (this.restarter.getCurrentRun() > 0 && this.restarter.getCurrentRun() % this.resetWeights == 0) {
            constraintArray = this.constraints;
            n = 0;
            n2 = constraintArray.length;
            while (n < n2) {
                constraint = constraintArray[n];
                constraint.resetWeightedDegree();
                ++n;
            }
        }
        this.conflictManager.updateEvaluations();
    }

    public Variable makeStep() {
        this.neighborHeuristic.selectNeighbor();
        return this.neighborHeuristic.setNeighbor();
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public void runSolver() {
        this.initialize();
        int best = Integer.MAX_VALUE;
        int cpt = 0;
        while (cpt < this.nbIterations) {
            if (this.conflictManager.size() == 0) {
                this.dealWithNewSolution();
                if (!this.resolution.isFinished()) {
                    this.randomSolution();
                }
            }
            if (this.resolution.isFinished()) break;
            if (this.stopwatch.getCurrentCpuTime() - this.timeLastSolution > 30000L) {
                this.restarter.setNbRuns(0);
                break;
            }
            Variable variable = this.makeStep();
            if (variable == null) break;
            this.localStatistics.incrementNbAssignments();
            if (this.conflictManager.size() < best) {
                best = this.conflictManager.size();
            }
            if (this.conflictManager.size() < this.upperBound) {
                this.upperBound = this.conflictManager.size();
                if (this.lastSolution == null) {
                    System.out.println();
                    System.out.println("s SATISFIABLE");
                }
                System.out.println("o " + (this.constraints.length - best));
                System.out.println("c " + best);
                this.recordlastSolution();
                System.out.flush();
                this.timeLastSolution = this.stopwatch.getCurrentCpuTime();
                if (this.upperBound == 1) {
                    this.restarter.setNbRuns(0);
                    break;
                }
            }
            ++cpt;
        }
    }

    protected void doRun() {
        this.randomSolution();
        this.runSolver();
    }

    public VariableManager getVariableManager() {
        throw new UnsupportedOperationException();
    }

    public void doAssignment(Variable variable, int index) {
        throw new UnsupportedOperationException();
    }

    public void undoAssignmentOf(Variable variable) {
        throw new UnsupportedOperationException();
    }

    public void undoPropagationOf(Variable v) {
        throw new UnsupportedOperationException();
    }
}

