/*
 * Decompiled with CFR 0.152.
 */
package abscon.solvers;

import abscon.Resolution;
import abscon.abstraction.AbstractionManager;
import abscon.constraints.Constraint;
import abscon.constraints.extension.structures.Bits;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;
import abscon.propagationTechniques.PropagationTechnique;
import abscon.propagationTechniques.forwardPropagationTechniques.ArcConsistency;
import abscon.propagationTechniques.forwardPropagationTechniques.maxCSP.MaxCSP;
import abscon.solvers.Restarter;
import abscon.solvers.Statistics;
import abscon.solvers.systematicSolvers.SystematicSolver;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.Tools;
import abscon.tools.absconParameters.ConfigurationManager;
import abscon.tools.elements.Elements;
import abscon.tools.reflection.Factory;
import abscon.xml.OutputManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Solver {
    protected Resolution resolution;
    protected Problem problem;
    protected int levelInResolution;
    protected Variable[] variables;
    protected Constraint[] constraints;
    protected PropagationTechnique currentPropagationTechnique;
    protected PropagationTechnique preproPropagationTechnique;
    protected PropagationTechnique searchPropagationTechnique;
    protected boolean doPrepro;
    protected boolean doSearch;
    protected int currentDepth;
    protected Restarter restarter;
    protected Statistics statistics;
    protected int nbSearchedSolutions;
    protected boolean fullExploration;
    protected StringBuffer lastSolution;
    protected boolean recordSolutions;
    protected Collection<int[]> allSolutions = new LinkedList<int[]>();
    private long durationToBeBuilt;
    protected int nbVisitedNodes = 1;
    private boolean inProgress;

    public int getNbVisitedNodes() {
        return this.nbVisitedNodes;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public int getLevelInResolution() {
        return this.levelInResolution;
    }

    public Problem getProblem() {
        return this.problem;
    }

    public Variable getVariable(int i) {
        return this.variables[i];
    }

    public Variable[] getVariables() {
        return this.variables;
    }

    public Constraint getConstraint(int i) {
        return this.constraints[i];
    }

    public Constraint[] getConstraints() {
        return this.constraints;
    }

    public int getNbVariables() {
        return this.variables.length;
    }

    public int getNbConstraints() {
        return this.constraints.length;
    }

    public PropagationTechnique getCurrentPropagationTechnique() {
        return this.currentPropagationTechnique;
    }

    public PropagationTechnique getPreproPropagationTechnique() {
        return this.preproPropagationTechnique;
    }

    public PropagationTechnique getSearchPropagationTechnique() {
        return this.searchPropagationTechnique;
    }

    public Restarter getRestarter() {
        return this.restarter;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public abstract int getCurrentDepth();

    public abstract VariableManager getVariableManager();

    public int getNbSearchedSolutions() {
        return this.nbSearchedSolutions;
    }

    public int getNbUniqueSolutions() {
        return this.allSolutions.size();
    }

    public long getDurationToBeBuilt() {
        return this.durationToBeBuilt;
    }

    public void setDurationToBeBuilt(long l) {
        this.durationToBeBuilt = l;
    }

    public abstract long getRestartCounter();

    public boolean mustDoPrepro() {
        return this.doPrepro;
    }

    public boolean mustDoSearch() {
        return this.doSearch;
    }

    public boolean getFullExploration() {
        return this.fullExploration;
    }

    public void setFullExploration(boolean fullExploration) {
        this.fullExploration = fullExploration;
    }

    public StringBuffer getLastSolution() {
        return this.lastSolution;
    }

    public void setLastSolution(StringBuffer lastSolution) {
        this.lastSolution = lastSolution;
    }

    public void reinitNbEffectiveRevisionsOfConstraints() {
        Constraint[] constraintArray = this.constraints;
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            constraint.resetNbEffectiveRevisions();
            ++n;
        }
    }

    public int computeNbConstraintsEffectiveRevisors() {
        int cpt = 0;
        Constraint[] constraintArray = this.constraints;
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (constraint.getNbEffectiveRevisions() > 0) {
                ++cpt;
            }
            ++n;
        }
        return cpt;
    }

    public void attachTo(Resolution resolution, int levelInResolution) {
        this.resolution = resolution;
        this.problem = resolution.getProblem(levelInResolution);
        this.levelInResolution = levelInResolution;
        this.variables = this.getProblem().getVariables();
        this.constraints = this.getProblem().getConstraints();
        this.nbSearchedSolutions = levelInResolution > 0 ? -1 : resolution.getNbSearchedSolutions();
        this.doPrepro = ConfigurationManager.getBoolean(levelInResolution, "preprocessing", "enabled");
        if (this.doPrepro) {
            String className = ConfigurationManager.getString(levelInResolution, "preprocessing/propagationTechnique", "class");
            if (resolution.isCompetition() && (long)this.getProblem().getNbCurrentValues() > 50000L) {
                className = Tools.getRelativeClassNameOf(ArcConsistency.class);
            }
            this.preproPropagationTechnique = (PropagationTechnique)Factory.getInstanceOf(className, PropagationTechnique.class);
            this.preproPropagationTechnique.attachTo(this);
        }
        this.doSearch = ConfigurationManager.getBoolean(levelInResolution, "search", "enabled");
        this.restarter = new Restarter(this);
    }

    public AbstractionManager getTopManager() {
        if (this.levelInResolution == this.resolution.getNbAbstractionLevels()) {
            return null;
        }
        return this.resolution.getManager(this.levelInResolution);
    }

    public AbstractionManager getDownManager() {
        if (this.levelInResolution == 0) {
            return null;
        }
        return this.resolution.getManager(this.levelInResolution - 1);
    }

    public abstract void doAssignment(Variable var1, int var2);

    public abstract void undoAssignmentOf(Variable var1);

    public abstract void undoPropagationOf(Variable var1);

    void recordLastSolution() {
        int[] lastSolution = new int[this.variables.length];
        int i = 0;
        while (i < lastSolution.length) {
            lastSolution[i] = this.variables[i].getDomain().getUniqueValue();
            ++i;
        }
        Iterator<int[]> it = this.allSolutions.iterator();
        boolean found = false;
        while (!found && it.hasNext()) {
            int[] solution = it.next();
            found = true;
            int i2 = 0;
            while (found && i2 < solution.length) {
                if (solution[i2] != lastSolution[i2]) {
                    found = false;
                }
                ++i2;
            }
        }
        if (!found) {
            this.allSolutions.add((int[])lastSolution.clone());
        }
    }

    private boolean controlLastSolution() {
        Object[] objectArray = this.variables;
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Variable variable = objectArray[n];
            if (variable.getDomain().getUniqueIndex() == -10 && variable.getDomain().getCurrentSize() != 1) {
                System.out.println("Problem with last solution: variable " + variable + " has not a unique value");
                return false;
            }
            ++n;
        }
        if (this instanceof SystematicSolver && this.getCurrentPropagationTechnique() instanceof MaxCSP) {
            return true;
        }
        objectArray = this.constraints;
        n = 0;
        n2 = objectArray.length;
        while (n < n2) {
            Object constraint = objectArray[n];
            if (!((Constraint)constraint).seekSupport()) {
                System.out.println("Problem with last solution: constraint " + constraint + " not satisfied");
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    public void recordlastSolution() {
        this.inProgress = true;
        if (this.lastSolution == null) {
            this.lastSolution = new StringBuffer(this.variables.length * 2);
        }
        this.lastSolution.delete(0, this.lastSolution.length());
        int i = 0;
        while (i < this.variables.length) {
            this.lastSolution.append(this.variables[i].getDomain().getUniqueValue());
            this.lastSolution.append(" ");
            ++i;
        }
        this.inProgress = false;
    }

    public void dealWithNewSolution() {
        this.statistics.manageSolution();
        if (this.statistics.getNbFoundSolutions() == (long)this.nbSearchedSolutions) {
            this.resolution.setSuccessful(true);
        }
        this.recordlastSolution();
        if (this.resolution.getDisplayMode() >= 0) {
            this.displayLastSolution();
        }
        if (!this.controlLastSolution()) {
            System.exit(1);
        }
        if (this.resolution.getRecordSolutions()) {
            this.recordLastSolution();
        }
        this.getProblem().dealWithNewSolution();
        if (this.getDownManager() != null) {
            this.getDownManager().runConcreteSolver();
        }
    }

    protected void restoreProblem() {
    }

    public void doPreprocessing() {
        if (!this.doPrepro) {
            return;
        }
        this.currentPropagationTechnique = this.preproPropagationTechnique;
        this.statistics.manageBeforePreprocessing();
        this.preproPropagationTechnique.initializeBeforePreprocessing();
        this.fullExploration = !this.preproPropagationTechnique.checkConsistency();
        this.statistics.manageAfterPreprocessing(!this.fullExploration);
        this.resolution.getOutputManager().outputMap("preprocessing", this.statistics.getMapOfPreproAttributes(), 2);
    }

    protected abstract void doRun();

    protected void doSearch() {
        if (!this.doSearch) {
            return;
        }
        this.currentPropagationTechnique = this.searchPropagationTechnique;
        OutputManager output = this.resolution.getOutputManager();
        Variable[] variableArray = this.variables;
        int n = 0;
        int n2 = variableArray.length;
        while (n < n2) {
            Variable variable = variableArray[n];
            if (variable.getValueOrderingHeuristic() != null) {
                variable.getValueOrderingHeuristic().initializeBeforeSearch();
            }
            ++n;
        }
        this.restarter.initialize();
        while (!this.fullExploration && !this.resolution.isFinished() && !this.restarter.isFinished() || this.restarter.isForceRestart()) {
            this.restarter.newRun();
            this.currentDepth = 0;
            this.statistics.manageBeforeSearch();
            this.doRun();
            this.statistics.manageAfterSearch();
            if (this.resolution.isFinished()) break;
            if (!this.restarter.isRunFinished() && !this.restarter.isForceRestart()) {
                this.fullExploration = true;
                continue;
            }
            if (this.restarter.isFinished() || this.resolution.getConciseResults()) continue;
            output.outputMap("search", this.statistics.getMapOfSearchAttributes(), 2);
        }
        output.outputMap("search", this.statistics.getMapOfSearchAttributes(), 2);
    }

    private void dealWithUniversalConstraints() {
        int cpt = 0;
        Constraint[] constraintArray = this.constraints;
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (constraint.getExtensionStructure() instanceof Bits) {
                Variable variable = constraint.getInvolvedVariable(0).getDomain().getCurrentSize() < constraint.getInvolvedVariable(1).getDomain().getCurrentSize() ? constraint.getInvolvedVariable(0) : constraint.getInvolvedVariable(1);
                long[] t2 = constraint.getFirstVariableDifferentFrom(variable).getDomain().getElements().getBinaryRepresentation();
                long[][] t1s = ((Bits)constraint.getExtensionStructure()).getBinaryRepresentationOfSupportsOf(constraint.getPositionOf(variable));
                Domain domain = variable.getDomain();
                Elements elements = domain.getElements();
                boolean universal = true;
                int index = elements.getFirstPresent();
                while (universal && index != -1) {
                    long[] t1 = t1s[index];
                    int i = 0;
                    while (universal && i < t1.length) {
                        if ((t1[i] & t2[i]) != t2[i]) {
                            universal = false;
                        }
                        ++i;
                    }
                    index = elements.getNextPresent(index);
                }
                if (universal) {
                    ++cpt;
                }
            }
            ++n;
        }
        System.out.println("cpt = " + cpt);
    }

    public void solve() {
        this.fullExploration = this.getProblem().hasOneVariableWithEmptyDomain();
        this.statistics.manageBeforeSolve();
        if (!this.fullExploration) {
            this.doPreprocessing();
        }
        if (!this.fullExploration && !this.resolution.isFinished()) {
            this.doSearch();
        }
        this.statistics.manageAfterSolve();
        this.resolution.getOutputManager().outputMap("global", this.statistics.getMapOfGlobalAttributes(), 2);
        this.restoreProblem();
    }

    public Map<String, String> getMapOfAttributes() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (this.resolution.getNbAbstractionLevels() > 0) {
            map.put("level", String.valueOf(this.getLevelInResolution()));
        }
        map.put("wckTime", String.valueOf((double)this.resolution.getCurrentInstanceStopwatch().getCurrentWallClockTime() / 1000.0));
        map.put("cpuTime", String.valueOf((double)this.resolution.getCurrentInstanceStopwatch().getCurrentCpuTime() / 1000.0));
        map.put("mem", Tools.getFormattedUsedMemorySize());
        return map;
    }

    public void displayLastSolution() {
        System.out.println("    solution");
        System.out.println("       number = " + this.statistics.getNbFoundSolutions() + "   value = " + this.lastSolution.toString());
    }

    public String getStatusOfNbSolutions() {
        if (this.fullExploration) {
            return String.valueOf(this.statistics.getNbFoundSolutions());
        }
        if (this.statistics.getNbFoundSolutions() == 0L) {
            return "?";
        }
        return "at least " + this.statistics.getNbFoundSolutions();
    }
}

