/*
 * Decompiled with CFR 0.152.
 */
package abscon.solvers;

import abscon.solvers.Solver;
import abscon.tools.Tools;
import abscon.tools.absconParameters.ConfigurationManager;

public class Restarter {
    private Solver solver;
    private long cutoff;
    private long currentCutoff;
    private int nbRuns;
    private double increasingFactor;
    private int currentRun;
    private boolean forceRestart;
    private long nbAssignmentsWhenLastImprovement = 0L;
    private boolean lubyOptimalStrategy = false;

    public void setCutoff(long cutoff) {
        this.cutoff = cutoff;
    }

    public void incrementCutoffOf(long offset) {
        this.cutoff += offset;
    }

    private long computeOptimalCutoffForRun(long i) {
        int k = (int)Math.floor(Math.log(i) / Math.log(2.0)) + 1;
        long pow = (long)Math.pow(2.0, k - 1);
        if (i == pow * 2L - 1L) {
            return pow;
        }
        return this.computeOptimalCutoffForRun(i - pow + 1L);
    }

    public void newMaxCSPSolutionFound() {
        if (this.currentCutoff == Long.MAX_VALUE) {
            return;
        }
        this.currentCutoff += Math.min(1000L, this.solver.getStatistics().getNbAssignments() - this.nbAssignmentsWhenLastImprovement);
        this.nbAssignmentsWhenLastImprovement = this.solver.getStatistics().getNbAssignments();
    }

    public void updateCutoff() {
        this.currentCutoff = this.lubyOptimalStrategy ? this.solver.getRestartCounter() + this.computeOptimalCutoffForRun(this.currentRun + 1) * 100L : (this.cutoff == -1L ? Long.MAX_VALUE : this.solver.getRestartCounter() + (long)((double)this.cutoff * Math.pow(this.increasingFactor, this.currentRun)));
    }

    public int getNbRuns() {
        return this.nbRuns;
    }

    public void setNbRuns(int nbRuns) {
        this.nbRuns = nbRuns;
    }

    public int getCurrentRun() {
        return this.currentRun;
    }

    public Restarter(Solver solver) {
        this.solver = solver;
        String s = "search/restarts";
        this.cutoff = ConfigurationManager.getInt(solver.getLevelInResolution(), s, "cutoff");
        this.nbRuns = this.cutoff == -1L ? 1 : ConfigurationManager.getInt(solver.getLevelInResolution(), s, "nbRuns");
        this.increasingFactor = ConfigurationManager.getDouble(solver.getLevelInResolution(), s, "factor");
    }

    public void initialize() {
        this.currentRun = -1;
    }

    public void newRun() {
        ++this.currentRun;
        this.setForceRestart(false);
        this.updateCutoff();
        this.nbAssignmentsWhenLastImprovement = 0L;
    }

    public boolean isFinished() {
        return this.currentRun >= this.nbRuns;
    }

    public boolean isRunFinished() {
        return this.solver.getRestartCounter() >= this.currentCutoff;
    }

    public void displayCurrentAdvancement() {
        System.out.println("\nStart " + this.currentRun + "/" + this.nbRuns);
    }

    public String getDescription(boolean full) {
        String delimiter = full ? "\n" : " ";
        return this.cutoff == -1L ? "" : String.valueOf(Tools.getRelativeClassNameOf(this)) + "(cutoff=" + this.cutoff + ",nbRestarts=" + this.nbRuns + ")" + delimiter;
    }

    public boolean isForceRestart() {
        return this.forceRestart;
    }

    public void setForceRestart(boolean forceRestart) {
        this.forceRestart = forceRestart;
    }
}

