/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.supportManagers.supportUnits;

import abscon.constraints.Constraint;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.problem.Variable;
import abscon.problem.cliques.PathManager;
import abscon.propagationTechniques.forwardPropagationTechniques.MaxRPC;
import abscon.propagationTechniques.supportManagers.SupportManagerOptimal;
import abscon.propagationTechniques.supportManagers.supportUnits.StackOfSupportsb;
import abscon.propagationTechniques.supportManagers.supportUnits.SupportUnitOptimal;
import abscon.tools.elements.Elements;
import java.util.Arrays;

public abstract class SupportUnitb
extends SupportUnitOptimal {
    protected int[] lastSupports;
    protected int[] lastStackSupports;
    protected StackOfSupportsb[] stacks;
    protected Elements brotherElements;
    protected boolean limitedRPC = false;
    private boolean notUpdateLast = false;
    private boolean partialPath = false;

    public boolean isInitialized(int index) {
        return this.lastSupports[index] != -1;
    }

    public int[] getLastSupportOf(int index) {
        this.buffer[this.variablePosition] = index;
        this.buffer[this.brotherPosition] = this.lastSupports[index];
        return this.buffer;
    }

    public int getLastSupportFromBrotherOf(int index) {
        return this.lastSupports[index];
    }

    public boolean isLastSupportStrictlyLessThan(int index, int otherIndex) {
        assert (this.brotherElements.isPresent(this.lastSupports[index]));
        return this.lastSupports[index] < this.lastSupports[otherIndex];
    }

    public SupportUnitb(SupportManagerOptimal supportManager, Constraint constraint, Variable variable) {
        super(supportManager, constraint, variable);
        if (constraint.getArity() != 2) {
            throw new IncompatiblePropertiesException();
        }
        this.lastSupports = new int[variable.getDomain().getMaximumSize()];
        if (supportManager.mustStackSupports()) {
            this.stacks = new StackOfSupportsb[variable.getDomain().getMaximumSize()];
            int i = 0;
            while (i < this.stacks.length) {
                this.stacks[i] = new StackOfSupportsb();
                ++i;
            }
        } else {
            this.lastStackSupports = new int[variable.getDomain().getMaximumSize()];
        }
        this.brotherElements = constraint.getInvolvedVariable(this.brotherPosition).getDomain().getElements();
    }

    public void initialize() {
        Arrays.fill(this.lastSupports, -1);
        if (this.stacks != null) {
            int i = 0;
            while (i < this.stacks.length) {
                this.stacks[i].initialize();
                ++i;
            }
        } else {
            Arrays.fill(this.lastStackSupports, -1);
        }
        this.globalDepth = 0;
    }

    protected boolean restore(int index, int depthLimit) {
        if (this.lastDepths[index] <= depthLimit && !this.supportManager.isSolverUsingDynamicBacktracking()) {
            return false;
        }
        ++this.nbEffectiveRestorations;
        if (this.stacks != null) {
            int t = this.stacks[index].getSupportValidAt(depthLimit);
            assert (t != -1 || this.stacks[index].getDepthAtTop() == 0);
            this.lastSupports[index] = t;
            this.lastDepths[index] = this.stacks[index].getDepthAtTop();
        } else {
            this.lastSupports[index] = this.lastStackSupports[index];
            this.lastDepths[index] = 0;
        }
        return true;
    }

    protected void manageLostSupport(int index) {
    }

    protected void manageNewSupport(int index) {
        int depth = this.supportManager.getPropagationTechnique().getSolver().getCurrentDepth();
        if (this.stacks != null) {
            this.stacks[index].push(this.lastSupports[index], this.lastDepths[index]);
        } else if (depth == 0) {
            this.lastStackSupports[index] = this.buffer[this.brotherPosition];
        }
        this.lastSupports[index] = this.buffer[this.brotherPosition];
        this.updateDepths(index, depth);
    }

    public boolean getArcSupportOf(int index) {
        assert (!this.variable.isAssigned() && this.variable.getDomain().hasIndex(index));
        boolean success = false;
        int support = this.lastSupports[index];
        if (support == -1) {
            success = this.constraint.seekSupport(this.variablePosition, index, this.buffer);
        } else {
            assert (this.supportManager.getPropagationTechnique() instanceof MaxRPC || this.controlCoherenceOfLastSupportWrt(index));
            this.constraint.getProblem().incrementNbValidityChecks();
            if (this.brotherElements.isPresent(support)) {
                if (this.supportManager.getRelationFiltering()) {
                    this.buffer[this.variablePosition] = index;
                    this.buffer[this.brotherPosition] = support;
                    this.constraint.getProblem().incrementNbConstraintChecks();
                    if (this.constraint.checkTupleOfIndexes(this.buffer)) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            this.manageLostSupport(index);
            this.buffer[this.variablePosition] = index;
            this.buffer[this.brotherPosition] = support;
            success = this.constraint.seekAnotherSupport(this.variablePosition, index, this.buffer);
        }
        if (success && this.brotherElements.getNbPresentElements() > 1) {
            this.manageNewSupport(index);
        }
        return success;
    }

    private boolean controlPathConsistencyOf(int index) {
        PathManager cliqueManager = this.constraint.getProblem().getCliqueManager();
        boolean consistent = true;
        while (consistent) {
            assert (this.constraint.checkValidityOf(this.buffer) && this.constraint.checkTupleOfIndexes(this.buffer));
            if (cliqueManager.isPathConsistent(this.constraint, this.buffer, this.supportManager)) {
                return true;
            }
            consistent = this.constraint.seekAnotherSupport(this.variablePosition, index, this.buffer);
        }
        return consistent;
    }

    private boolean mustDoPathSearchOf(int index) {
        if (!this.partialPath) {
            return true;
        }
        int support = this.buffer[this.brotherPosition];
        double d = (double)(support + 1) / (double)this.brotherElements.getNbPresentElements();
        return d > 1.0;
    }

    public boolean getPathSupportOf(int index) {
        assert (!this.variable.isAssigned() && this.variable.getDomain().hasIndex(index));
        boolean success = false;
        int support = this.lastSupports[index];
        if (support == -1) {
            success = this.constraint.seekSupport(this.variablePosition, index, this.buffer);
        } else {
            this.constraint.getProblem().incrementNbValidityChecks();
            if (this.brotherElements.isPresent(support) && this.supportManager.getLastSupportFromBrotherOf(this.constraint, this.constraint.getInvolvedVariable(this.brotherPosition), support) <= index) {
                assert (this.constraint.checkTupleOfIndexes(this.getLastSupportOf(index)));
                if (this.limitedRPC) {
                    return true;
                }
                this.manageLostSupport(index);
                this.buffer[this.variablePosition] = index;
                this.buffer[this.brotherPosition] = support;
                success = true;
            } else {
                this.manageLostSupport(index);
                this.buffer[this.variablePosition] = index;
                this.buffer[this.brotherPosition] = support;
                success = this.constraint.seekAnotherSupport(this.variablePosition, index, this.buffer);
            }
        }
        if (success && this.mustDoPathSearchOf(index)) {
            success = this.controlPathConsistencyOf(index);
        }
        if (success) {
            this.manageNewSupport(index);
            assert (this.constraint.checkTupleOfIndexes(this.getLastSupportOf(index)));
            assert (this.partialPath || this.constraint.getProblem().getCliqueManager().isPathConsistent(this.constraint, this.getLastSupportOf(index), this.supportManager));
        }
        return success;
    }

    public void display() {
        super.display();
        if (this.stacks == null) {
            System.out.println("LaststackSupports");
            int i = 0;
            while (i < this.lastStackSupports.length) {
                System.out.print(String.valueOf(i) + " => " + this.lastStackSupports[i] + " ; ");
                ++i;
            }
            System.out.println();
        }
    }
}

