/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.supportManagers.supportUnits;

import abscon.constraints.Constraint;
import abscon.exceptions.UnreachableCodeException;
import abscon.problem.Variable;
import abscon.propagationTechniques.supportManagers.SupportManager;
import abscon.propagationTechniques.supportManagers.supportUnits.SupportUnit;
import abscon.tools.absconParameters.ConfigurationManager;

public final class SupportUnit2005N
extends SupportUnit {
    private SupportUnit2005N[] brotherUnits;
    private int[][] lastFoundSupports;
    protected int[][] lastStackSupports;
    protected int[] buffer;
    private int variant;

    public SupportUnit2005N(SupportManager supportManager, Constraint constraint, Variable variable) {
        super(supportManager, constraint, variable);
        this.lastFoundSupports = new int[variable.getDomain().getMaximumSize()][constraint.getNbInvolvedVariables()];
        this.lastStackSupports = new int[variable.getDomain().getMaximumSize()][constraint.getNbInvolvedVariables()];
        this.buffer = new int[constraint.getNbInvolvedVariables()];
        this.variant = ConfigurationManager.getInt(supportManager.getPropagationTechnique().getLevel(), String.valueOf(supportManager.getPropagationTechnique().getPhase()) + "/" + "propagationTechnique" + "/" + "supportManager", "variant");
    }

    public void initialize() {
        if (this.brotherUnits == null) {
            SupportUnit[] units = this.supportManager.getSupportUnitsOf(this.constraint);
            this.brotherUnits = new SupportUnit2005N[units.length];
            int i = 0;
            while (i < this.brotherUnits.length) {
                this.brotherUnits[i] = (SupportUnit2005N)units[i];
                ++i;
            }
            i = 0;
            while (i < this.lastFoundSupports.length) {
                this.lastFoundSupports[i][this.variablePosition] = i;
                this.lastFoundSupports[i][this.brotherPosition] = -1;
                this.lastStackSupports[i][this.variablePosition] = i;
                this.lastStackSupports[i][this.brotherPosition] = -1;
                ++i;
            }
        }
    }

    public void restore(int index) {
    }

    protected void copySupport(int[] dstSupport, int[] srcSupport) {
        int i = 0;
        while (i < dstSupport.length) {
            dstSupport[i] = srcSupport[i];
            ++i;
        }
    }

    protected final void manageNewSupport(int index, int[] support) {
        if (this.supportManager.getPropagationTechnique().getSolver().getCurrentDepth() == 0) {
            this.copySupport(this.lastStackSupports[index], support);
        }
        if (this.variant == 0) {
            int i = 0;
            while (i < this.brotherUnits.length) {
                int[] lastSupport = this.brotherUnits[i].lastFoundSupports[support[i]];
                this.copySupport(lastSupport, support);
                ++i;
            }
        } else {
            this.copySupport(this.lastFoundSupports[index], support);
        }
    }

    public boolean getArcSupportOf(int index) {
        int[] support = this.lastFoundSupports[index];
        if (support[this.brotherPosition] != -1 && this.constraint.checkValidityOf(support)) {
            return true;
        }
        boolean success = false;
        support = this.lastStackSupports[index];
        if (support[this.brotherPosition] == -1) {
            success = this.constraint.seekSupport(this.variablePosition, index, this.buffer);
        } else {
            if (this.constraint.checkValidityOf(support)) {
                return true;
            }
            this.copySupport(this.buffer, support);
            success = this.constraint.seekAnotherSupport(this.variablePosition, index, this.buffer);
        }
        if (success) {
            this.manageNewSupport(index, this.buffer);
        }
        return success;
    }

    public boolean getPathSupportOf(int index) {
        throw new UnreachableCodeException();
    }
}

