/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.supportManagers.supportUnits;

import abscon.constraints.Constraint;
import abscon.exceptions.UnreachableCodeException;
import abscon.problem.Variable;
import abscon.propagationTechniques.supportManagers.SupportManager;
import abscon.propagationTechniques.supportManagers.supportUnits.SupportUnit;
import abscon.tools.absconParameters.ConfigurationManager;

public final class SupportUnit2005
extends SupportUnit {
    private SupportUnit2005[] brotherUnits;
    private int[][] lastFoundSupports;
    private int variant;

    public SupportUnit2005(SupportManager supportManager, Constraint constraint, Variable variable) {
        super(supportManager, constraint, variable);
        this.lastFoundSupports = new int[variable.getDomain().getMaximumSize()][constraint.getNbInvolvedVariables()];
        this.variant = ConfigurationManager.getInt(supportManager.getPropagationTechnique().getLevel(), String.valueOf(supportManager.getPropagationTechnique().getPhase()) + "/" + "propagationTechnique" + "/" + "supportManager", "variant");
    }

    public void initialize() {
        if (this.brotherUnits == null) {
            SupportUnit[] units = this.supportManager.getSupportUnitsOf(this.constraint);
            this.brotherUnits = new SupportUnit2005[units.length];
            int i = 0;
            while (i < this.brotherUnits.length) {
                this.brotherUnits[i] = (SupportUnit2005)units[i];
                ++i;
            }
            i = 0;
            while (i < this.lastFoundSupports.length) {
                this.lastFoundSupports[i][this.brotherPosition] = -1;
                ++i;
            }
        }
    }

    public void restore(int index) {
    }

    protected void copySupport(int[] dstSupport, int[] srcSupport) {
        int i = 0;
        while (i < dstSupport.length) {
            dstSupport[i] = srcSupport[i];
            ++i;
        }
    }

    protected final void manageNewSupport(int index, int[] support) {
        if (this.variant == 0) {
            int i = 0;
            while (i < this.brotherUnits.length) {
                int[] lastSupport = this.brotherUnits[i].lastFoundSupports[support[i]];
                this.copySupport(lastSupport, support);
                ++i;
            }
        } else {
            this.copySupport(this.lastFoundSupports[index], support);
        }
    }

    public boolean getArcSupportOf(int index) {
        int[] support = this.lastFoundSupports[index];
        if (support[this.brotherPosition] != -1 && this.constraint.checkValidityOf(support)) {
            return true;
        }
        if (this.constraint.seekSupport(this.variablePosition, index)) {
            this.manageNewSupport(index, this.constraint.getTupleManager().getLocalTuple());
            return true;
        }
        return false;
    }

    public boolean getPathSupportOf(int index) {
        throw new UnreachableCodeException();
    }
}

