/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.supportManagers.supportUnits;

import abscon.constraints.Constraint;
import abscon.problem.Variable;
import abscon.propagationTechniques.forwardPropagationTechniques.MaxRPC;
import abscon.propagationTechniques.supportManagers.SupportManagerOptimal;
import abscon.propagationTechniques.supportManagers.supportUnits.SupportUnit2001b;
import java.util.Arrays;

public final class SupportUnit2003b
extends SupportUnit2001b {
    private SupportUnit2003b brotherUnit;
    private int[] nbExternSupports;
    private boolean[] referencedInternSupports;

    public SupportUnit2003b(SupportManagerOptimal supportManager, Constraint constraint, Variable variable) {
        super(supportManager, constraint, variable);
        this.nbExternSupports = new int[variable.getDomain().getMaximumSize()];
        this.referencedInternSupports = new boolean[variable.getDomain().getMaximumSize()];
    }

    public void initialize() {
        super.initialize();
        Arrays.fill(this.nbExternSupports, 0);
        Arrays.fill(this.referencedInternSupports, false);
        this.brotherUnit = (SupportUnit2003b)this.supportManager.getSupportUnitOf(this.constraint, this.constraint.getInvolvedVariable(this.brotherPosition));
    }

    public void reset() {
        Arrays.fill(this.nbExternSupports, 0);
        Arrays.fill(this.referencedInternSupports, false);
    }

    private void referenceInternSupport(int index) {
        this.referencedInternSupports[index] = true;
        int n = this.lastSupports[index];
        this.brotherUnit.nbExternSupports[n] = this.brotherUnit.nbExternSupports[n] + 1;
    }

    private void unreferenceInternSupport(int index) {
        this.referencedInternSupports[index] = false;
        int n = this.lastSupports[index];
        this.brotherUnit.nbExternSupports[n] = this.brotherUnit.nbExternSupports[n] - 1;
    }

    protected boolean restore(int index, int depthLimit) {
        if (this.lastSupports[index] == -1) {
            return false;
        }
        if (this.lastDepths[index] <= depthLimit && !this.supportManager.isSolverUsingDynamicBacktracking()) {
            return false;
        }
        ++this.nbEffectiveRestorations;
        if (this.referencedInternSupports[index]) {
            this.unreferenceInternSupport(index);
        }
        if (this.stacks != null) {
            int t = this.stacks[index].getSupportValidAt(depthLimit);
            assert (t != -1 || this.stacks[index].getDepthAtTop() == 0);
            this.lastSupports[index] = t;
            this.lastDepths[index] = this.stacks[index].getDepthAtTop();
        } else {
            this.lastSupports[index] = this.lastStackSupports[index];
            this.lastDepths[index] = 0;
        }
        return true;
    }

    protected void manageLostSupport(int index) {
        if (this.referencedInternSupports[index]) {
            this.unreferenceInternSupport(index);
        }
    }

    protected void manageNewSupport(int index) {
        super.manageNewSupport(index);
        this.referenceInternSupport(index);
    }

    public void updateAfterRemovalOf(int index) {
        if (this.referencedInternSupports[index]) {
            this.unreferenceInternSupport(index);
        }
    }

    private void dealWithRemovalOf(int index) {
        if (this.variable.getDomain().getCurrentSize() == 1) {
            return;
        }
        Constraint[] constraintArray = this.variable.getInvolvingConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint currentConstraint = constraintArray[n];
            if (currentConstraint != this.constraint && currentConstraint.getNbFutureVariables() != 1) {
                this.supportManager.getSupportUnitOf(currentConstraint, this.variable).updateAfterRemovalOf(index);
            }
            ++n;
        }
    }

    public boolean superGetArcSupportOf(int index) {
        assert (!this.variable.isAssigned() && this.variable.getDomain().hasIndex(index));
        boolean success = false;
        int support = this.lastSupports[index];
        if (support == -1) {
            success = this.constraint.seekSupport(this.variablePosition, index, this.buffer);
        } else {
            assert (this.supportManager.getPropagationTechnique() instanceof MaxRPC || this.controlCoherenceOfLastSupportWrt(index));
            this.constraint.getProblem().incrementNbValidityChecks();
            if (this.brotherElements.isPresent(support)) {
                return true;
            }
            this.manageLostSupport(index);
            this.buffer[this.variablePosition] = index;
            this.buffer[this.brotherPosition] = support;
            success = this.constraint.seekAnotherSupport(this.variablePosition, index, this.buffer);
        }
        if (success) {
            this.manageNewSupport(index);
        }
        return success;
    }

    public boolean getArcSupportOf(int index) {
        if (this.nbExternSupports[index] > 0) {
            return true;
        }
        if (this.superGetArcSupportOf(index)) {
            if (!this.referencedInternSupports[index]) {
                this.referenceInternSupport(index);
            }
            return true;
        }
        this.dealWithRemovalOf(index);
        return false;
    }

    public boolean getPathSupportOf(int index) {
        if (this.nbExternSupports[index] > 0) {
            return true;
        }
        int support = this.lastSupports[index];
        boolean success = super.getPathSupportOf(index);
        if (success) {
            if (this.lastSupports[index] == support && !this.referencedInternSupports[index]) {
                this.referenceInternSupport(index);
            }
            return true;
        }
        this.dealWithRemovalOf(index);
        return false;
    }

    public void display() {
        super.display();
        System.out.println(" **nbExternSupports of (" + this.constraint.getId() + "," + this.variablePosition + ":id=" + this.variable.getId() + ")");
        int i = 0;
        while (i < this.nbExternSupports.length) {
            System.out.print("   " + i + "=>" + this.nbExternSupports[i]);
            if (i < this.lastSupports.length - 1) {
                System.out.print(" ;");
            }
            ++i;
        }
        System.out.println();
        System.out.println();
    }

    public boolean control() {
        int index = 0;
        while (index < this.lastSupports.length) {
            if (this.lastSupports[index] != -1) {
                int cpt = 0;
                int j = 0;
                while (j < this.brotherUnit.lastSupports.length) {
                    if (this.brotherUnit.isInitialized(j) && this.brotherUnit.referencedInternSupports[j] && this.brotherUnit.lastSupports[j] == index) {
                        ++cpt;
                    }
                    ++j;
                }
                if (this.nbExternSupports[index] != cpt) {
                    System.out.println("pb test : nb = " + this.nbExternSupports[index] + " cpt = " + cpt);
                    System.out.println("pb from " + this.constraint.getId() + "," + this.variablePosition + "," + index);
                    this.supportManager.display();
                    return false;
                }
            }
            ++index;
        }
        return true;
    }
}

