/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.supportManagers.supportUnits;

import abscon.constraints.Constraint;
import abscon.problem.Variable;
import abscon.propagationTechniques.supportManagers.SupportManagerOptimal;
import abscon.propagationTechniques.supportManagers.supportUnits.SupportUnit;
import abscon.propagationTechniques.supportManagers.supportUnits.SupportUnitOptimal;

public final class SupportUnit2002
extends SupportUnitOptimal {
    private SupportUnit2002[] brotherUnits;
    private int[][] lastExternSupports;

    public SupportUnit2002(SupportManagerOptimal supportManager, Constraint constraint, Variable variable) {
        super(supportManager, constraint, variable);
        this.lastExternSupports = new int[variable.getDomain().getMaximumSize()][constraint.getNbInvolvedVariables()];
    }

    public void initialize() {
        super.initialize();
        if (this.brotherUnits == null) {
            SupportUnit[] units = this.supportManager.getSupportUnitsOf(this.constraint);
            this.brotherUnits = new SupportUnit2002[units.length];
            int i = 0;
            while (i < this.brotherUnits.length) {
                this.brotherUnits[i] = (SupportUnit2002)units[i];
                ++i;
            }
        }
        int i = 0;
        while (i < this.lastExternSupports.length) {
            this.lastExternSupports[i][this.brotherPosition] = -1;
            ++i;
        }
    }

    protected final void manageNewSupport(int index) {
        super.manageNewSupport(index);
        int[] support = this.lastSupports[index];
        int i = 0;
        while (i < this.brotherUnits.length) {
            int[] lastSupport = this.brotherUnits[i].lastExternSupports[support[i]];
            this.copySupport(lastSupport, support);
            ++i;
        }
    }

    public final boolean getArcSupportOf(int index) {
        int[] lastExtern = this.lastExternSupports[index];
        assert (lastExtern[this.brotherPosition] == -1 || lastExtern[this.variablePosition] == index);
        if (lastExtern[this.brotherPosition] != -1 && this.constraint.checkValidityOf(lastExtern, this.variablePosition)) {
            return true;
        }
        return super.getArcSupportOf(index);
    }
}

