/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.supportManagers.supportUnits;

import abscon.constraints.Constraint;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.exceptions.MissingImplementationException;
import abscon.problem.Variable;
import abscon.propagationTechniques.supportManagers.SupportManager;

public abstract class SupportUnit {
    protected SupportManager supportManager;
    protected Constraint constraint;
    protected Variable variable;
    protected int variablePosition;
    protected int brotherPosition;

    public Constraint getConstraint() {
        return this.constraint;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public SupportUnit(SupportManager supportManager, Constraint constraint, Variable variable) {
        this.supportManager = supportManager;
        this.constraint = constraint;
        this.variable = variable;
        this.variablePosition = constraint.getPositionOf(variable);
        this.brotherPosition = constraint.getPositionOf(constraint.getFirstVariableDifferentFrom(variable));
        if (supportManager.mustStackSupports() && constraint.getArity() > 2) {
            throw new IncompatiblePropertiesException();
        }
    }

    public abstract void initialize();

    public abstract boolean getArcSupportOf(int var1);

    public abstract boolean getPathSupportOf(int var1);

    public int getLastSupportFromBrotherOf(int index) {
        return 0;
    }

    public void updateAfterRemovalOf(int index) {
        throw new MissingImplementationException();
    }

    public abstract void restore(int var1);

    public void display() {
        System.out.println("SupportUnit of (" + this.constraint + "," + this.variable + ")" + " of class " + this.getClass().getName());
    }

    public boolean control() {
        return true;
    }
}

