/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.supportManagers;

import abscon.constraints.Constraint;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.problem.Variable;
import abscon.propagationTechniques.PropagationTechnique;
import abscon.propagationTechniques.supportManagers.SupportManager;
import abscon.propagationTechniques.supportManagers.supportUnits.SupportUnit;
import abscon.propagationTechniques.supportManagers.supportUnits.SupportUnitOptimal;
import abscon.solvers.systematicSolvers.SystematicSolver;
import java.util.Arrays;

public abstract class SupportManagerOptimal
extends SupportManager {
    private boolean adaptative = false;

    public int getLastDepth(int constraintId) {
        return this.lastDepths[constraintId];
    }

    public void setLastDepth(int constraintId, int depth) {
        this.lastDepths[constraintId] = Math.max(depth, this.lastDepths[constraintId]);
        assert (this.controlModificationDepths(constraintId));
    }

    public int getLastSupportFromBrotherOf(Constraint constraint, Variable variable, int index) {
        return this.supportUnits[constraint.getId()][constraint.getPositionOf(variable)].getLastSupportFromBrotherOf(index);
    }

    public int getNbEffectiveRestorations() {
        int cpt = 0;
        int i = 0;
        while (i < this.supportUnits.length) {
            if (this.supportUnits[i].length > 1) {
                int j = 0;
                while (j < this.supportUnits[i].length) {
                    cpt += ((SupportUnitOptimal)this.supportUnits[i][j]).getNbEffectiveRestorations();
                    ++j;
                }
            }
            ++i;
        }
        return cpt;
    }

    public void attachTo(PropagationTechnique propagationTechnique) {
        if (propagationTechnique.getSolver() instanceof SystematicSolver && ((SystematicSolver)propagationTechnique.getSolver()).getBacktrackingMode() == 12 && (this.mustStackSupports() || this.isCandidateAttentive())) {
            throw new IncompatiblePropertiesException();
        }
        super.attachTo(propagationTechnique);
        this.lastDepths = new int[propagationTechnique.getSolver().getNbConstraints()];
    }

    public void initializeStructures() {
        Constraint[] constraints;
        int i = 0;
        while (i < this.supportUnits.length) {
            int j = 0;
            while (j < this.supportUnits[i].length) {
                this.supportUnits[i][j].initialize();
                ++j;
            }
            ++i;
        }
        Constraint[] constraintArray = constraints = this.propagationTechnique.getSolver().getProblem().getConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            SupportUnit[] units;
            Constraint constraint = constraintArray[n];
            constraint.setCandidateAttentive(this.candidateAttentive);
            if (this.candidateAttentive && (units = this.getSupportUnitsOf(constraint))[0] instanceof SupportUnitOptimal) {
                SupportUnitOptimal[] unitOptimals = new SupportUnitOptimal[units.length];
                int i2 = 0;
                while (i2 < unitOptimals.length) {
                    unitOptimals[i2] = (SupportUnitOptimal)units[i2];
                    ++i2;
                }
                constraint.getTupleManager().setSupportUnits(unitOptimals);
            }
            ++n;
        }
        Arrays.fill(this.lastDepths, 0);
    }

    public boolean seekNextSupport(int constraintId, int variablePosition, int index) {
        if (this.propagationTechnique.getPathExtension()) {
            return this.supportUnits[constraintId][variablePosition].getPathSupportOf(index);
        }
        return this.supportUnits[constraintId][variablePosition].getArcSupportOf(index);
    }

    public void restoreSupportsOf(Constraint constraint, Variable variable, int depthLimit) {
        this.supportUnits[constraint.getId()][constraint.getPositionOf(variable)].restore(depthLimit);
    }

    public void restoreSupportsOfFutureVariables(int depthLimit) {
        Constraint[] constraints = this.propagationTechnique.getSolver().getConstraints();
        int i = 0;
        while (i < constraints.length) {
            if (this.lastDepths[i] > depthLimit || this.dynamicBacktracking) {
                Variable[] involvedVariables = constraints[i].getInvolvedVariables();
                int j = 0;
                while (j < involvedVariables.length) {
                    if (involvedVariables[j].isFuture()) {
                        this.supportUnits[i][j].restore(depthLimit);
                    }
                    ++j;
                }
                this.setLastDepth(i, depthLimit);
            }
            ++i;
        }
    }

    public void initAfterModificationOf(Variable variable, boolean progression, int depthLimitToUpdateStructures) {
        if (!progression) {
            this.restoreSupportsOfFutureVariables(depthLimitToUpdateStructures);
        }
    }

    public boolean controlSupports() {
        int i = 0;
        while (i < this.supportUnits.length) {
            int j = 0;
            while (j < this.supportUnits[i].length) {
                if (!this.supportUnits[i][j].control()) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public boolean controlModificationDepths(int i) {
        Constraint constraint = this.propagationTechnique.getSolver().getConstraint(i);
        Variable[] involvedVariables = constraint.getInvolvedVariables();
        int j = 0;
        while (j < involvedVariables.length) {
            SupportUnitOptimal supportUnit = (SupportUnitOptimal)this.supportUnits[i][j];
            if (supportUnit.getGlobalDepth() > this.lastDepths[i]) {
                System.out.println("sup init depth = " + supportUnit.getGlobalDepth() + " gloabl =" + this.lastDepths[i]);
                this.supportUnits[i][j].display();
                return false;
            }
            ++j;
        }
        return true;
    }
}

